/*
 * Decompiled with CFR 0.152.
 */
package shared.checksumhelper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import shared.proglistener.ProgListener;
import shared.proglistener.ProgNotify;

public class JChecksumHelper {
    private static final int BUF_SIZE = 4096;
    private byte[] m_byteArray;

    public byte[] getChecksum() {
        return this.m_byteArray;
    }

    public String getChecksumAsString() {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n < this.m_byteArray.length) {
            stringBuilder.append(String.format("%02x", this.m_byteArray[n++]));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCalculateMD(File file, ProgListener progListener, String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            long l = file.length();
            CRC32 cRC32 = null;
            MessageDigest messageDigest = null;
            Adler32 adler32 = null;
            if (string.equalsIgnoreCase("CRC32")) {
                cRC32 = new CRC32();
            } else if (string.equalsIgnoreCase("Adler32")) {
                adler32 = new Adler32();
            } else {
                messageDigest = MessageDigest.getInstance(string);
            }
            byte[] byArray = new byte[4096];
            int n = -1;
            if (progListener != null) {
                progListener.notify(new ProgNotify(0, 0, new Long(l).toString()));
            }
            long l2 = l;
            boolean bl = false;
            while (l != 0L && (n = fileInputStream.read(byArray)) >= 0) {
                if (cRC32 != null) {
                    cRC32.update(byArray, 0, n);
                } else if (adler32 != null) {
                    adler32.update(byArray, 0, n);
                } else {
                    messageDigest.update(byArray, 0, n);
                }
                assert (l <= (long)n);
                if (progListener == null || !(bl = progListener.notify(new ProgNotify(1, (int)(1000L - (l -= (long)n) * 1000L / l2), null)))) continue;
            }
            if (bl) {
                if (progListener != null) {
                    progListener.notify(new ProgNotify(-2, 0, null));
                }
            } else {
                this.m_byteArray = cRC32 != null ? this.longToByteArray4(cRC32.getValue()) : (adler32 != null ? this.longToByteArray4(adler32.getValue()) : messageDigest.digest());
                int n2 = 0;
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = null;
                while (n2 < this.m_byteArray.length) {
                    string2 = String.format("%02x", this.m_byteArray[n2++]);
                    stringBuilder.append(string2);
                }
                if (progListener != null) {
                    progListener.notify(new ProgNotify(2, 1000, stringBuilder.toString()));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (progListener != null) {
                progListener.notify(new ProgNotify(-1, 0, fileNotFoundException.toString()));
            }
        }
        catch (Exception exception) {
            if (progListener != null) {
                progListener.notify(new ProgNotify(-1, 0, exception.toString()));
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public byte[] longToByteArray4(long l) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(l & 0xFFL);
        byArray[2] = (byte)(l >> 8 & 0xFFL);
        byArray[1] = (byte)(l >> 16 & 0xFFL);
        byArray[0] = (byte)(l >> 24 & 0xFFL);
        return byArray;
    }

    public void calculateChecksum(File file, ProgListener progListener, String string) {
        final File file2 = file;
        final ProgListener progListener2 = progListener;
        final String string2 = string;
        Thread thread = new Thread(){

            public void run() {
                JChecksumHelper.this.doCalculateMD(file2, progListener2, string2);
            }
        };
        thread.start();
    }

    public void calculateChecksum(String string, ProgListener progListener, String string2) {
        this.calculateChecksum(new File(string), progListener, string2);
    }
}

