/*
 * Decompiled with CFR 0.152.
 */
package shared.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class JImageView
extends JComponent
implements Printable {
    private Object m_interpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
    private Image m_img;

    public boolean hasImage() {
        return this.m_img != null;
    }

    public void setImage(Image image) {
        this.m_img = image;
    }

    public void setImage(String string) {
        this.m_img = Toolkit.getDefaultToolkit().createImage(string);
    }

    public void paintComponent(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        this.doPaint(graphics2, this.getSize(), false);
    }

    public boolean doPaint(Graphics graphics, Dimension dimension, boolean bl) {
        if (this.m_img != null) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.m_img.getWidth(this);
            int n2 = this.m_img.getHeight(this);
            if (dimension == null) {
                dimension = new Dimension(n, n2);
            }
            d = (double)dimension.width / (double)n;
            d2 = (double)dimension.height / (double)n2;
            d3 = Math.min(d, d2);
            graphics2D.scale(d3, d3);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.m_interpolation);
            Rectangle rectangle = graphics2D.getClipBounds();
            if (rectangle != null) {
                graphics2D.drawImage(this.m_img, (int)rectangle.getX(), (int)rectangle.getY(), (int)(rectangle.getX() + rectangle.getWidth()), (int)(rectangle.getY() + rectangle.getHeight()), (int)rectangle.getX(), (int)rectangle.getY(), (int)(rectangle.getX() + rectangle.getWidth()), (int)(rectangle.getY() + rectangle.getHeight()), this);
            }
        }
        return false;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.m_img != null && n == 0) {
            graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            RepaintManager repaintManager = RepaintManager.currentManager(this);
            repaintManager.setDoubleBufferingEnabled(false);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            this.doPaint(graphics, new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight()), true);
            repaintManager.setDoubleBufferingEnabled(true);
            System.gc();
            return 0;
        }
        return 1;
    }
}

