/*
 * Decompiled with CFR 0.152.
 */
package shared.settings;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import shared.swing.JSwingHelper;

public abstract class JSettingsHelper {
    private static final String DEBUG = "Debug";
    private static final String NOBOLDFONT = "NoBoldFont";
    private static final String LOCALE = "Locale";
    private static final String LOOKANDFEEL = "LookAndFeel";
    private static final String RESBUNDLEFILE = "ResBundleFile";
    private static final String CHECKUPDATE = "CheckUpdates";
    private static final String VERSION = "Version";
    private static final String DEF_DEBUG = "false";
    private static final String DEF_NOBOLDFONT = "true";
    private static final String DEF_LOCALE = "";
    private static final String DEF_CHECKUPDATE = "true";
    private static final String DEF_VERSION = "";
    protected boolean m_bDebug;
    protected boolean m_bNoBoldFont;
    protected String m_locale;
    protected String m_lookAndFeel;
    protected String m_resBundleFile;
    protected String m_version;
    protected boolean m_bInitSwing;
    protected boolean m_bCheckUpdate;
    protected ResourceBundle m_resBundle;

    public JSettingsHelper(boolean bl) {
        this.m_bInitSwing = bl;
        if (this.m_bInitSwing) {
            JSwingHelper.setAnitAliasing();
        }
    }

    protected abstract void doLoad(Properties var1);

    protected abstract void doSave(Properties var1);

    protected abstract String getComment();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDummy(String string) {
        Properties properties = new Properties();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, this.getComment());
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string, String string2) {
        FileInputStream fileInputStream = null;
        File file = new File(string);
        if (!file.exists()) {
            this.createDummy(string);
        }
        if (file.canRead()) {
            try {
                fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                this.m_bDebug = new Boolean(properties.getProperty(DEBUG, DEF_DEBUG));
                this.m_bNoBoldFont = new Boolean(properties.getProperty(NOBOLDFONT, "true"));
                this.m_locale = properties.getProperty(LOCALE, "");
                this.m_lookAndFeel = properties.getProperty(LOOKANDFEEL, UIManager.getCrossPlatformLookAndFeelClassName());
                this.m_resBundleFile = properties.getProperty(RESBUNDLEFILE, "");
                this.m_bCheckUpdate = new Boolean(properties.getProperty(CHECKUPDATE, "true"));
                this.m_version = properties.getProperty(VERSION, "");
                if (this.getLocale().length() > 0) {
                    Locale.setDefault(new Locale(this.getLocale()));
                }
                if (this.m_bInitSwing && this.isNoBoldFont()) {
                    JSwingHelper.unBoldAllFonts();
                }
                this.doLoad(properties);
                this.m_version = string2;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string) {
        Properties properties = new Properties();
        properties.setProperty(DEBUG, Boolean.toString(this.m_bDebug));
        properties.setProperty(NOBOLDFONT, Boolean.toString(this.m_bNoBoldFont));
        properties.setProperty(LOCALE, this.m_locale);
        properties.setProperty(LOOKANDFEEL, this.m_lookAndFeel);
        properties.setProperty(RESBUNDLEFILE, this.m_resBundleFile);
        properties.setProperty(CHECKUPDATE, Boolean.toString(this.m_bCheckUpdate));
        properties.setProperty(VERSION, this.m_version);
        this.doSave(properties);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, this.getComment());
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public ResourceBundle getResBundle() {
        return this.m_resBundle;
    }

    public String getResBundleString(String string) {
        return this.m_resBundle.getString(string);
    }

    public String getResBundleString(String string, boolean bl) {
        String string2 = this.getResBundleString(string);
        if (bl) {
            string2.replace("\\n", "\n");
            string2.replace("\\t", "\t");
        }
        return string2;
    }

    public void setIsDebug(boolean bl) {
        this.m_bDebug = bl;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }

    public boolean isNoBoldFont() {
        return this.m_bNoBoldFont;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public void setLocale(String string) {
        this.m_locale = string;
    }

    public void setLookAndFeel(String string) {
        this.m_lookAndFeel = string;
    }

    public String getLookAndFeel() {
        return this.m_lookAndFeel;
    }

    public boolean isCheckUpdate() {
        return this.m_bCheckUpdate;
    }

    public void setCheckUpdate(boolean bl) {
        this.m_bCheckUpdate = bl;
    }

    public String getResBundleFile() {
        return this.m_resBundleFile;
    }

    public boolean init(String string) {
        return this.init(string, null, null);
    }

    public boolean init(String string, String string2) {
        return this.init(string, string2, null);
    }

    public boolean init(String string, String string2, String string3) {
        block9: {
            if (this.m_bInitSwing) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            String string4 = null;
            if (this.m_resBundleFile != null) {
                string4 = this.getResBundleFile().trim();
            }
            try {
                if (string4 != null && string4.length() > 0) {
                    final String string5 = string4 + ".properties";
                    this.m_resBundle = ResourceBundle.getBundle(string4, Locale.getDefault(), new ClassLoader(){

                        public InputStream getResourceAsStream(String string) {
                            if (string.equals(string5)) {
                                try {
                                    return new FileInputStream(string);
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    // empty catch block
                                }
                            }
                            return null;
                        }
                    });
                } else {
                    this.m_resBundle = ResourceBundle.getBundle(string);
                }
            }
            catch (MissingResourceException missingResourceException) {
                JOptionPane.showMessageDialog(null, string3 != null ? string3 : "No resource file was found!\nThe program will terminate now!", string2 != null ? string2 : "Error", 0);
            }
            if (this.m_bInitSwing) {
                try {
                    UIManager.setLookAndFeel(this.getLookAndFeel());
                }
                catch (Exception exception) {
                    if (!this.isDebug()) break block9;
                    System.err.print("Unable to set look and feel: " + this.getLookAndFeel() + " " + exception.toString());
                }
            }
        }
        return this.m_resBundle != null;
    }

    public static String toString(Dimension dimension) {
        return String.format(Locale.US, "%d,%d", dimension.width, dimension.height);
    }

    public static Dimension fromString(String string, String string2) {
        Dimension dimension = null;
        String[] stringArray = string.split(",");
        if (stringArray.length > 1) {
            try {
                dimension = new Dimension(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (dimension == null && (stringArray = string2.split(",")).length > 1) {
            try {
                dimension = new Dimension(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dimension;
    }
}

