/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import jexifviewer.PngEncoder;
import shared.cvshelper.Cvs;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/PngEncoderB.java,v 1.3 2010/04/02 12:12:13 reiner Exp $")
public class PngEncoderB
extends PngEncoder {
    private static final byte[] PLTE = new byte[]{80, 76, 84, 69};
    protected BufferedImage image;
    protected WritableRaster wRaster;
    protected int tType;

    public PngEncoderB() {
        this(null, false, 0, 0);
    }

    public PngEncoderB(BufferedImage bufferedImage) {
        this(bufferedImage, false, 0, 0);
    }

    public PngEncoderB(BufferedImage bufferedImage, boolean bl) {
        this(bufferedImage, bl, 0, 0);
    }

    public PngEncoderB(BufferedImage bufferedImage, boolean bl, int n) {
        this(bufferedImage, bl, n, 0);
    }

    public PngEncoderB(BufferedImage bufferedImage, boolean bl, int n, int n2) {
        this.image = bufferedImage;
        this.encodeAlpha = bl;
        this.setFilter(n);
        if (n2 >= 0 && n2 <= 9) {
            this.compressionLevel = n2;
        }
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.pngBytes = null;
    }

    public byte[] pngEncode(boolean bl) {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (this.image == null) {
            System.err.println("pngEncode: image is null; returning null");
            return null;
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.image = this.image;
        if (!this.establishStorageInfo()) {
            System.err.println("pngEncode: cannot establish storage info");
            return null;
        }
        this.pngBytes = new byte[(this.width + 1) * this.height * 3 + 200];
        this.maxPos = 0;
        this.bytePos = this.writeBytes(byArray, 0);
        this.writeHeader();
        if (this.writeImageData()) {
            this.writeEnd();
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.maxPos);
        } else {
            System.err.println("pngEncode: writeImageData failed => null");
            this.pngBytes = null;
        }
        return this.pngBytes;
    }

    public byte[] pngEncode() {
        return this.pngEncode(this.encodeAlpha);
    }

    protected boolean establishStorageInfo() {
        this.wRaster = this.image.getRaster();
        int n = this.wRaster.getNumDataElements();
        this.tType = this.wRaster.getTransferType();
        if (this.tType == 0 && n == 4 || this.tType == 3 && n == 1 || this.tType == 1 && n == 1) {
            this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        } else if (this.tType == 0 && n == 1) {
            this.bytesPerPixel = 1;
            this.encodeAlpha = false;
        } else {
            System.err.println("PNG encoder cannot establish storage info:");
            System.err.println("  TransferType == " + this.tType);
            System.err.println("  NumDataElements == " + n);
            return false;
        }
        return true;
    }

    protected void writeHeader() {
        int n = this.bytePos = this.writeInt4(13, this.bytePos);
        this.bytePos = this.writeBytes(IHDR, this.bytePos);
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.bytePos = this.writeInt4(this.width, this.bytePos);
        this.bytePos = this.writeInt4(this.height, this.bytePos);
        this.bytePos = this.writeByte(8, this.bytePos);
        this.bytePos = this.bytesPerPixel != 1 ? this.writeByte(this.encodeAlpha ? 6 : 2, this.bytePos) : this.writeByte(3, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.crc.reset();
        this.crc.update(this.pngBytes, n, this.bytePos - n);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected void writePalette(IndexColorModel indexColorModel) {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        byte[] byArray4 = new byte[768];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        for (int i = 0; i < 256; ++i) {
            byArray4[i * 3] = byArray[i];
            byArray4[i * 3 + 1] = byArray2[i];
            byArray4[i * 3 + 2] = byArray3[i];
        }
        this.bytePos = this.writeInt4(768, this.bytePos);
        this.bytePos = this.writeBytes(PLTE, this.bytePos);
        this.crc.reset();
        this.crc.update(PLTE);
        this.bytePos = this.writeBytes(byArray4, this.bytePos);
        this.crc.update(byArray4);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected boolean writeImageData() {
        int n = this.height;
        int n2 = 0;
        int n3 = this.image.getType();
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        if (this.bytesPerPixel == 1) {
            this.writePalette((IndexColorModel)this.image.getColorModel());
        }
        try {
            while (n > 0) {
                int n4 = Math.min(Short.MAX_VALUE / (this.width * (this.bytesPerPixel + 1)), n);
                n4 = Math.max(n4, 1);
                byte[] byArray = new byte[this.width * n4 * this.bytesPerPixel + n4];
                if (this.filter == 1) {
                    this.leftBytes = new byte[16];
                }
                if (this.filter == 2) {
                    this.priorRow = new byte[this.width * this.bytesPerPixel];
                }
                Object object = this.wRaster.getDataElements(0, n2, this.width, n4, null);
                byte[] byArray2 = null;
                int[] nArray = null;
                short[] sArray = null;
                if (this.tType == 0) {
                    byArray2 = (byte[])object;
                } else if (this.tType == 3) {
                    nArray = (int[])object;
                } else if (this.tType == 1) {
                    sArray = (short[])object;
                }
                int n5 = 0;
                int n6 = 0;
                int n7 = 1;
                for (int i = 0; i < this.width * n4; ++i) {
                    int n8;
                    if (i % this.width == 0) {
                        byArray[n5++] = (byte)this.filter;
                        n7 = n5;
                    }
                    if (this.bytesPerPixel == 1) {
                        byArray[n5++] = byArray2[n6++];
                    } else if (this.tType == 0) {
                        byArray[n5++] = byArray2[n6++];
                        byArray[n5++] = byArray2[n6++];
                        byArray[n5++] = byArray2[n6++];
                        if (this.encodeAlpha) {
                            byArray[n5++] = byArray2[n6++];
                        } else {
                            ++n6;
                        }
                    } else if (this.tType == 1) {
                        n8 = sArray[n6++];
                        if (n3 == 8) {
                            byArray[n5++] = (byte)(n8 >> 8 & 0xF8);
                            byArray[n5++] = (byte)(n8 >> 2 & 0xFC);
                        } else {
                            byArray[n5++] = (byte)(n8 >> 7 & 0xF8);
                            byArray[n5++] = (byte)(n8 >> 2 & 0xF8);
                        }
                        byArray[n5++] = (byte)(n8 << 3 & 0xF8);
                    } else {
                        n8 = nArray[n6++];
                        byArray[n5++] = (byte)(n8 >> 16 & 0xFF);
                        byArray[n5++] = (byte)(n8 >> 8 & 0xFF);
                        byArray[n5++] = (byte)(n8 & 0xFF);
                        if (this.encodeAlpha) {
                            byArray[n5++] = (byte)(n8 >> 24 & 0xFF);
                        }
                    }
                    if (i % this.width != this.width - 1 || this.filter == 0) continue;
                    if (this.filter == 1) {
                        this.filterSub(byArray, n7, this.width);
                    }
                    if (this.filter != 2) continue;
                    this.filterUp(byArray, n7, this.width);
                }
                deflaterOutputStream.write(byArray, 0, n5);
                n2 += n4;
                n -= n4;
            }
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n9 = byArray.length;
            this.crc.reset();
            this.bytePos = this.writeInt4(n9, this.bytePos);
            this.bytePos = this.writeBytes(IDAT, this.bytePos);
            this.crc.update(IDAT);
            this.bytePos = this.writeBytes(byArray, n9, this.bytePos);
            this.crc.update(byArray, 0, n9);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
            deflater.finish();
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
    }
}

