fail_exit()
{
	echo 'FAILED!'
	exit 1
}

T='--------------------------------------+'

./b91enc --version || fail_exit
echo -n '

extracting test files...'
echo '?/9f4iG0)z4jY;<$:B$AvWAAoB:CgALvDCeR+t<vs?JIdPSQ;L5lB3S' | ./b91dec | bunzip2 > bit0.dat && \
echo '?/9f4iG0)z4jZgv|?AUYRAgA%AAAUA:y5L9LcoHE8HJI_yGIJ>T' | ./b91dec | bunzip2 > bit1.dat && \
echo '71kS$5F/VZC0+Zw,c%df~>T1XkEvl{weS1NQ@@<EsB7?HV[3U(PhH}H)<LB9_E.4R)1I9W;Ce";rDlheie/
X*Jh)bS+Jj]iu8V}b61nw32m:"$2@F)s(3LV,n5M?D=NZ9cM,9dV2t_eN#CVg4n@?Zx@FuNG2z|4iLzZvXbx*v_4M
.ij4Cu=x~WzlpmRKXl3%kWqxx{wo38|Skh/q&;}D#~|Ng3$Gaw>3Gd*`P2p~<hXL_x?V:^0wcZ3x/LpEtP<]gaCm6
O]D:}u%LONIl2iohu8h6ZXN+3ZS*w"r:8[U?B{?}mt@+<W24O"FA_#^(L$:Tg}#BYwqZc&uT_o,BSG4boOe]ij8fV
8f/]aBW37mJIfH7uE=l)_y}F*^UA_L9,XPP<jSCN9y4ua|2jhD]E$}>)^4>yP{Y9MFo.Q2=Mmsk:"lhR%87Ey_GRP
7hn_L73QVn>5CK0{6eHmBBtzP05[`PG3*"+n(bE$S";_b^gU5D87O,QjqW<sS}3&CyTDB~hH,oTOV/My7[vP&mg=W
sDWjXHh2+q,pmh{AK4U!#n6@VfZFA!]p7E;_gWX_Q#!>3wVc(_T8_:O{8P$9~{n7"SiU;Ca{w_;HB6L&u2W8M>ScI
aP#E.:novN/#Mk$STQeM^dSp5~JKkb3[t<MeaHgV_*vy=W#0B$3pH6/;q9]C<v=}2IewY6{PigoQ"b[:7+;!k8kv[
!M@y}I~m%fm&x?S5]CDM&>5_*3q&V/Z7aVdFP<K[R"RkdOfN/.8>J#P&TR3#`W+;&GpWk9CHq%R|fV~(K:g6_Du~m
j7S?;hnI$xFkGTDRJSJ#NNu_;(]ud#<HI7isnSR@,6ftg8D;$+[j8}mr7lrAijly3cxX7+l3[)@.c7Vk`#kEB,g,P
>f3{1Q|;jH4l{Ql^mi]*jH>mCqmSW,Bx4^MBrnOtoa4gbM7m3S:OMQ4nt.un+)Zelc,Eoa|c!yN"3dV3b9YY2opW=
VS&}g7RI#0g?^mT#@#;Q%kmT2gGX8.*H;^Dywb$(o(t;/_#j8Vi*djlobF!Xw)B2lLV_sio/`z1zu^+^m9D~At(<w
RDd6[tY/gsu(CNd#j*do&Id|iCGCBG$FD4(JUlb"~O8E`."F<SdvvP;Xfn?V:uVP,I(XD|@)5KVNwx2k/`&vyXrnl
Ots<a+&YHAL[Wyn,Zc*r3&.=8w~+PIs}.bioO`|D,52ku,daF"WA&nT)!"j&!EiNJ{y.%`Ba3R.f,#rF4qH07uekh
qd"o]wvyXzrC_i#pC9+KWV5Nh},s^3|R0EV4g?#KJvp^V_.w$GAXf0,SU#=Z)ugj4k@T&A$/JVzgkwqJX9lx,YuFf
1whB6~5[P^DGQN@}nhPX>UH|,6o=j6kT(=Cz8q6(FBOm~&+F*,IgYH;XtV+,ejB".y`K9!2VxGi?YeQs+q9Ses]Qt
RzDX;Oyx]$Tcm;[GT4Auh}yN+%:}Q_xv5_B[/q30b!qFIn>w{^w`Qa99`=r0<Ew]RDY0qgDvOBKh?sKz=uxOY8Tv{
c4;c)QQ3*ilu6I?W$}5M[K1UA29,xzD;<;%y*=b$X8[Z^Cb~QPagi;{[sEk(Ttm3.@Gjm%@ii*Cl{&>eo&uZFyq*`
dg.h"YJiW)t5BaO;?liP7Y|)o|]9KwM`rZO1p#<WohA$KEPZU3rm"!_WNwMg[Yj{9MbgNFkygUc4rb*:k:z;)qV+g
W]t76>}zYnX|.C(+P.RXy>T0XG^58"DO8Su/5MElg)J>eU,BjzB5}et|m+4>$GdR<(_[PUxc^o|c2L{w~mE@SZ.FH
;(=m1zJIMyYbz8z0=gf*;)WDk:3@7^YN&i1|MVarqV)qe]x9kJ)OPi&F``3?|P:(Fg$1(P2{xf0yf$WBU!.YmwYIT
F)^pdagK0(P~/96zGoD,QZlX]"`h/U`^ZWZeJ.c:XQ!WAz(Z|&2/E3)*V?vAb>?MUV5*T8i3u)apx`5<8J`bopXm>
*J,^8m.Ldfyj~KR#mt*&Z3a]N9WUT+^c2*@07TM:ATg(D)YMiSR[RTll_7DB3.HhUzKL:N0.:%J,<(_$0Ab{``OaN
43R:29/1$KXzs2%58B]G,h*r$Z/PqQqwh*sY.o(;Kkqw`1N^;JFk!;^?V+6/7irU+h._wN},b?.O.8t#:prfx9ZEE
t2AWg56N]g6MF0Bs7X^07[RwvgwxT@4RLk#SXzXj74XT93xa=$c0Sgi6z{apd:[5sDmwG;&jKSGGR.=c9qS$u[S:y
wM|buns:@)g|V@|QGD9wipn#u*HCFK7W}iD}f|E{h@PR@2+m%nN>u+"+>x&3iF+0`2GE03Gg;K`[.E[X4Swjchxf6
LusH!p1)[}$SyFI"w|fztPfp*<~6Bu&1(.0XH68BX?a9mFcGoT>~qd7qtf)+v.o9(IAL7|jz32K"9d1Nh*1},xK<T
VZa!xDsn66YUg~,En93Xg9u2c~?o~=,#$e]~KHG&tBM)bOvSN:0GHsZ|u$6523G(6wxlo_eqx!<CzIScE~pC+2;1W
:G^D7,k+do4Wr+4j4|Q:vj]c?J+Wz:Lyn<+W)8]>nvFBHnD&1fv9+h,+nww+PRv7I2wU)B`nty%~eJ2OvRIa^k@T2
*Y:8fa@pLgwFy,[Ea$di~YWC]4)j&3=B0nZn())A|p,70Y02g3ArYWjs+U' | ./b91enc -do rnd0.dat && \
./b91enc --decode -o rnd1.dat rnd0.dat && echo ' OK' || fail_exit

echo "
basE91 encode files:

+-- best case --$T"
./b91enc -m 5k -vv --output=bit0.b91 bit0.dat
echo "+-- worst case -$T"
./b91enc -m 3k -vv --output=bit1.b91 bit1.dat
echo "+-- random data $T"
./b91enc -m 96 -vv --output=rnd0.b91 rnd0.dat
./b91enc -m 72 -vv --output=rnd1.b91 rnd1.dat

echo '
comparing check sums...'
cksum rnd?.dat *.b91 | while read C S F
do
	echo -n "$F	"
	case $F in
		rnd0.dat) V='15559944992141';;
		rnd1.dat) V='3514104192626';;
		bit0.b91) V='33531953171198370';;
		bit1.b91) V='5394938771290552';;
		rnd0.b91) V='32051515602633';;
		rnd1.b91) V='2018291165770';;
	esac
	test $V = "$C$S" && echo OK || exit 1
done || fail_exit
echo "
basE91 decode and compare:

+-- best case --$T"
fold -w 83 bit0.b91 | ./b91dec -vvm 2K | cmp bit0.dat && echo PASSED || fail_exit
echo "+-- worst case -$T"
fold -w 79 bit1.b91 | ./b91dec -vvm 1K | cmp bit1.dat && echo PASSED || fail_exit
echo "+-- random data $T"
fold -w 73 rnd0.b91 | ./b91dec -vvm 89 | cmp rnd0.dat && echo PASSED || fail_exit
fold -w 71 rnd1.b91 | ./b91dec -vvm 73 | cmp rnd1.dat && echo PASSED || fail_exit

echo '
================
all tests passed
================
'
