public class RAMDisk implements BlockDevice {

  private static final int DEFAULTBLOCKSIZE = 256,
  			   DEFAULTNUMBEROFBLOCKS = 200;

  private int blockSize, numberOfBlocks;
  private byte[] storage;

  public RAMDisk () {
    this (DEFAULTBLOCKSIZE, DEFAULTNUMBEROFBLOCKS);
  }

  public RAMDisk (int b, int n) {
    blockSize = b;
    numberOfBlocks = n;
    storage = new byte[blockSize * numberOfBlocks];
  }

  public void readBlock (byte[] buffer, int block) {
    int blockindex = block * blockSize;
    for (int i = 0; i < blockSize; i++)
      buffer[i] = storage[blockindex + i];
  }

  public void writeBlock (byte[] buffer, int block) {
    int blockindex = block * blockSize;
      for (int i = 0; i < blockSize; i++)
        storage[blockindex + i] = buffer[i]; 
  }

  public int getBlockSize () {
    return blockSize;
  }

  public int getNumberOfBlocks () {
    return numberOfBlocks;
  }

}

