/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.FileNode;
import com.hbworks.dirpane.TreeFileSystemModel;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class LoadQueue {
    Vector queue;
    TreeFileSystemModel model;

    public LoadQueue(TreeFileSystemModel model) {
        this.model = model;
        this.queue = new Vector();
    }

    public synchronized void add(Vector nodesToLoad, int loadType) {
        int i = 0;
        while (i < nodesToLoad.size()) {
            FileNode node = (FileNode)nodesToLoad.elementAt(i);
            this.add(node, loadType);
            ++i;
        }
    }

    private void add(FileNode node, int loadType) {
        if (this.queue.contains(node)) {
            return;
        }
        this.queue.addElement(node);
        this.queue.addElement(new Integer(loadType));
    }

    public synchronized void remove(FileNode node) {
        if (!this.queue.contains(node)) {
            return;
        }
        int index = this.queue.indexOf(node);
        Integer I = (Integer)this.queue.elementAt(index + 1);
        this.queue.removeElement(node);
        this.queue.removeElement(I);
    }

    public synchronized void clear() {
        this.queue.removeAllElements();
    }

    public synchronized void load(FileNode node) {
        if (!this.queue.contains(node)) {
            return;
        }
        if (!node.isLoading() && !node.hasChildrenLoaded()) {
            this.model.loadChildren(node);
        }
    }

    public synchronized void nodeLoaded(final FileNode node) {
        if (!this.queue.contains(node)) {
            return;
        }
        int index = this.queue.indexOf(node);
        final Integer I = (Integer)this.queue.elementAt(index + 1);
        this.remove(node);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LoadQueue.this.model.fireNodeLoaded(node);
            }
        });
        if (!this.queue.isEmpty()) {
            this.load((FileNode)this.queue.firstElement());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LoadQueue.this.model.fireLoadingEnded(node, (int)I);
                }
            });
        }
    }
}

