/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.ColumnIdentifier;
import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.FileSystemModel;
import com.hbworks.dirpane.TableDirectoryPane;
import com.hbworks.dirpane.event.LoadingListener;
import com.hbworks.dirpane.event.TableLoadingEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class TableDirectoryModel
extends FileSystemModel
implements TableModel {
    protected TableDirectoryPane directoryPane;
    private Vector columnTypes;
    private String[] columnNames;
    private Object[] columnIdentifiers;
    protected transient Vector directoryRowsCache = null;
    protected transient Vector fileRowsCache = null;
    private Vector sortingColumns = new Vector();
    private boolean ascending = true;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$swing$event$TableModelListener;
    static /* synthetic */ Class class$com$hbworks$dirpane$event$LoadingListener;

    protected TableDirectoryModel(TableDirectoryPane pane, Class[] columnTypes) {
        this(pane, columnTypes, null);
    }

    protected TableDirectoryModel(TableDirectoryPane pane, Class[] columnTypes, String[] columnNames) {
        this.directoryPane = pane;
        this.setColumnTypesAndNames(columnTypes, columnNames);
    }

    protected void setColumnTypesAndNames(Class[] types, String[] names) {
        Vector<Class> v = new Vector<Class>();
        v.addElement(class$java$io$File == null ? (class$java$io$File = TableDirectoryModel.class$("java.io.File")) : class$java$io$File);
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                Class type = types[i];
                if (this.testForFileSubType(type)) {
                    this.setFileSubType(type);
                    v.setElementAt(type, 0);
                } else {
                    v.addElement(type);
                }
                ++i;
            }
        }
        this.columnNames = names == null || v.size() != names.length ? this.createDefaultColumnNames(v) : names;
        this.columnTypes = v;
        this.createColumnIdentifiers();
    }

    protected String[] createDefaultColumnNames(Vector v) {
        String[] array = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            String id;
            String classname = ((Class)v.elementAt(i)).getName();
            int j = classname.lastIndexOf(".");
            array[i] = id = classname.substring(j + 1);
            ++i;
        }
        return array;
    }

    private void createColumnIdentifiers() {
        this.columnIdentifiers = new Object[this.getColumnCount()];
        int i = 0;
        while (i < this.getColumnCount()) {
            this.columnIdentifiers[i] = new ColumnIdentifier(this.getColumnClass(i), this.getColumnName(i), i);
            ++i;
        }
    }

    private boolean testForFileSubType(Class type) {
        if (type == null) {
            return false;
        }
        if (type == (class$java$io$File == null ? (class$java$io$File = TableDirectoryModel.class$("java.io.File")) : class$java$io$File)) {
            return true;
        }
        Class superclass = type.getSuperclass();
        while (superclass != (class$java$io$File == null ? TableDirectoryModel.class$("java.io.File") : class$java$io$File)) {
            if (superclass == (class$java$lang$Object == null ? TableDirectoryModel.class$("java.lang.Object") : class$java$lang$Object)) break;
            superclass = superclass.getSuperclass();
        }
        return superclass == (class$java$io$File == null ? (class$java$io$File = TableDirectoryModel.class$("java.io.File")) : class$java$io$File);
    }

    protected void setFileSystem(FileSystem newFileSystem) {
        super.setFileSystem(newFileSystem);
        this.invalidateRowsCache();
        Class fileType = newFileSystem.getFileSubType();
        if (this.testForFileSubType(fileType)) {
            this.columnTypes.setElementAt(fileType, 0);
            this.createColumnIdentifiers();
        }
    }

    protected abstract Object[] createRowForFile(File var1);

    protected void invalidateRowsCache() {
        this.directoryPane.clearSelection();
        this.directoryRowsCache = null;
        this.fileRowsCache = null;
        this.fireTableDataChanged();
    }

    public int directoryCacheSize() {
        if (this.directoryRowsCache == null) {
            return 0;
        }
        return this.directoryRowsCache.size();
    }

    public void refresh() {
        this.refresh(this.getCurrentDirectory());
    }

    public void refresh(File dir) {
        this.invalidateRowsCache();
        this.validateRowsCache(dir);
    }

    protected abstract void validateRowsCache(File var1);

    public boolean directoryCacheContains(Object o) {
        if (this.directoryRowsCache != null) {
            return this.directoryRowsCache.contains(o);
        }
        return false;
    }

    public boolean fileCacheContains(Object o) {
        if (this.fileRowsCache != null) {
            return this.fileRowsCache.contains(o);
        }
        return false;
    }

    public int indexOf(Object o) {
        if (this.directoryCacheContains(o)) {
            return this.directoryRowsCache.indexOf(o);
        }
        if (this.fileCacheContains(o)) {
            return this.fileRowsCache.indexOf(o) + this.directoryCacheSize();
        }
        return -1;
    }

    protected void addRow(Object[] row) {
        int index = -1;
        boolean isDir = this.isTraversable((File)row[0]);
        if (isDir) {
            this.directoryRowsCache.addElement(row);
            index = this.directoryCacheSize() - 1;
        } else {
            this.fileRowsCache.addElement(row);
            index = this.directoryCacheSize() + this.fileRowsCache.size() - 1;
        }
        this.fireTableRowsInserted(index, index);
    }

    protected void removeRow(Object[] row) {
        int index = this.indexOf(row);
        if (index == -1) {
            return;
        }
        if (index < this.directoryCacheSize()) {
            this.directoryRowsCache.removeElementAt(index);
        } else {
            int fileIndex = index - this.directoryCacheSize();
            this.fileRowsCache.removeElementAt(fileIndex);
        }
        this.fireTableRowsDeleted(index, index);
    }

    protected void replaceRow(Object[] newRow, int oldindex) {
        if (oldindex == -1) {
            return;
        }
        if (oldindex < this.directoryCacheSize()) {
            this.directoryRowsCache.setElementAt(newRow, oldindex);
        } else {
            int oldFileIndex = oldindex - this.directoryCacheSize();
            this.fileRowsCache.setElementAt(newRow, oldFileIndex);
        }
        this.fireTableRowsUpdated(oldindex, oldindex);
    }

    public Class[] getColumnTypes() {
        Object[] a = new Class[this.columnTypes.size()];
        this.columnTypes.copyInto(a);
        return a;
    }

    public Vector getColumnTypesVector() {
        return this.columnTypes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Object[] getColumnIdentifiers() {
        return this.columnIdentifiers;
    }

    protected void replaceColumnNamesBy(String[] newcolumnNames) {
        if (newcolumnNames == null || newcolumnNames.length != this.columnNames.length) {
            return;
        }
        System.arraycopy(newcolumnNames, 0, this.columnNames, 0, this.columnNames.length);
        this.updateColumnIdentifiers();
    }

    private void updateColumnIdentifiers() {
        int i = 0;
        while (i < this.getColumnCount()) {
            ((ColumnIdentifier)this.columnIdentifiers[i]).setColumnName(this.getColumnName(i));
            ++i;
        }
    }

    public int getColumnCount() {
        return this.columnTypes.size();
    }

    public int getRowCount() {
        int dirRows = 0;
        int fileRows = 0;
        if (this.directoryRowsCache != null) {
            dirRows = this.directoryRowsCache.size();
        }
        if (this.fileRowsCache != null) {
            fileRows = this.fileRowsCache.size();
        }
        return dirRows + fileRows;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public boolean isCellEditable(int row, int column) {
        if (!this.directoryPane.isEditable()) {
            return false;
        }
        return column == 0;
    }

    public Object getValueAt(int row, int column) {
        Object[] r = row < this.directoryCacheSize() ? (Object[])this.directoryRowsCache.elementAt(row) : (Object[])this.fileRowsCache.elementAt(row -= this.directoryCacheSize());
        return r[column];
    }

    public abstract void setValueAt(Object var1, int var2, int var3);

    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = TableDirectoryModel.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = TableDirectoryModel.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, l);
    }

    public Object getColumnIdentifier(int column) {
        return this.columnIdentifiers[column];
    }

    public Class getColumnClass(int column) {
        if (column > -1 && column < this.columnTypes.size()) {
            return (Class)this.columnTypes.elementAt(column);
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = TableDirectoryModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public int getIndexOfColumnClass(Class columnClass) {
        return this.columnTypes.indexOf(columnClass);
    }

    public Vector getAllRows() {
        int i;
        Vector allRows = new Vector();
        if (this.directoryRowsCache != null) {
            i = 0;
            while (i < this.directoryRowsCache.size()) {
                allRows.addElement(this.directoryRowsCache.elementAt(i));
                ++i;
            }
        }
        if (this.fileRowsCache != null) {
            i = 0;
            while (i < this.fileRowsCache.size()) {
                allRows.addElement(this.fileRowsCache.elementAt(i));
                ++i;
            }
        }
        return allRows;
    }

    public Object[] getRowForFile(File file) {
        int index = this.getRowIndexOfFile(file);
        if (index != -1) {
            return this.getRowAt(index);
        }
        return null;
    }

    public int getRowIndexOfFile(File file) {
        File f;
        Object[] row;
        int i;
        int index = -1;
        if (this.directoryRowsCache != null) {
            i = 0;
            while (i < this.directoryRowsCache.size()) {
                row = (Object[])this.directoryRowsCache.elementAt(i);
                f = (File)row[0];
                if (file.equals(f)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index == -1 && this.fileRowsCache != null) {
            i = 0;
            while (i < this.fileRowsCache.size()) {
                row = (Object[])this.fileRowsCache.elementAt(i);
                f = (File)row[0];
                if (file.equals(f)) {
                    index = this.directoryCacheSize() + i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    public Object[] getRowAt(int index) {
        if (index < this.directoryCacheSize()) {
            return (Object[])this.directoryRowsCache.elementAt(index);
        }
        return (Object[])this.fileRowsCache.elementAt(index -= this.directoryCacheSize());
    }

    public File getFileAtRow(int index) {
        Object[] row = this.getRowAt(index);
        return (File)row[0];
    }

    public Object getObjectAtRow(Class objecttype, int index) {
        int column = this.columnTypes.indexOf(objecttype);
        Object[] row = this.getRowAt(index);
        return row[column];
    }

    protected void fireLoadingStarted(File dir) {
        Object[] listeners = this.listenerList.getListenerList();
        TableLoadingEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$hbworks$dirpane$event$LoadingListener == null ? TableDirectoryModel.class$("com.hbworks.dirpane.event.LoadingListener") : class$com$hbworks$dirpane$event$LoadingListener)) {
                if (e == null) {
                    e = new TableLoadingEvent(this, 0, dir);
                }
                ((LoadingListener)listeners[i + 1]).loadingChanged(e);
            }
            i -= 2;
        }
    }

    protected void fireLoadingEnded(File dir) {
        Object[] listeners = this.listenerList.getListenerList();
        TableLoadingEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$hbworks$dirpane$event$LoadingListener == null ? TableDirectoryModel.class$("com.hbworks.dirpane.event.LoadingListener") : class$com$hbworks$dirpane$event$LoadingListener)) {
                if (e == null) {
                    e = new TableLoadingEvent(this, 1, dir);
                }
                ((LoadingListener)listeners[i + 1]).loadingChanged(e);
            }
            i -= 2;
        }
    }

    protected void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    protected void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    protected void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    protected void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    protected void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    protected void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$TableModelListener == null ? TableDirectoryModel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) {
                ((TableModelListener)listeners[i + 1]).tableChanged(e);
            }
            i -= 2;
        }
    }

    public Vector sortRowsByColumn(Vector rows, int column) {
        return this.sortRowsByColumn(rows, column, true);
    }

    public Vector sortRowsByColumn(Vector rows, int column, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        return this.sortRows(rows);
    }

    private Vector sortRows(Vector rows) {
        Object[][] rowsarray = new Object[rows.size()][this.columnNames.length];
        rows.copyInto((Object[])rowsarray);
        this.sort(rowsarray);
        Vector<Object[]> v = new Vector<Object[]>(rowsarray.length);
        int i = 0;
        while (i < rowsarray.length) {
            v.addElement(rowsarray[i]);
            ++i;
        }
        return v;
    }

    public void sortModelByColumn(int column) {
        this.sortModelByColumn(column, true);
    }

    public void sortModelByColumn(int column, boolean ascending) {
        this.directoryPane.setSorting(true);
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sortModel();
    }

    private void sortModel() {
        if (this.sortingColumns.isEmpty()) {
            this.sortingColumns.addElement(new Integer(0));
        }
        if (this.directoryRowsCache != null) {
            this.directoryRowsCache = this.sortRows(this.directoryRowsCache);
        }
        if (this.fileRowsCache != null) {
            this.fileRowsCache = this.sortRows(this.fileRowsCache);
        }
        this.directoryPane.setSorting(false);
        if (this.directoryRowsCache != null || this.fileRowsCache != null) {
            this.fireTableDataChanged();
        }
    }

    private void sort(Object[][] a) {
        Object[][] aux = (Object[][])a.clone();
        this.mergeSort(aux, a, 0, a.length);
    }

    private void mergeSort(Object[][] src, Object[][] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            int i = low;
            while (i < high) {
                int j = i;
                while (j > low && this.compareRows(dest[j - 1], dest[j]) > 0) {
                    TableDirectoryModel.swap(dest, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = (low + high) / 2;
        this.mergeSort(dest, src, low, mid);
        this.mergeSort(dest, src, mid, high);
        if (this.compareRows(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int i = low;
        int p = low;
        int q = mid;
        while (i < high) {
            dest[i] = q >= high || p < mid && this.compareRows(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void swap(Object[][] x, int a, int b) {
        Object[] t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private int compareRows(Object[] row1, Object[] row2) {
        int level = 0;
        while (level < this.sortingColumns.size()) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result != 0) {
                return this.ascending ? result : -result;
            }
            ++level;
        }
        return 0;
    }

    protected abstract int compareRowsByColumn(Object[] var1, Object[] var2, int var3);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

