/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.BasicFileSystem;
import com.hbworks.dirpane.FileNode;
import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.FileSystemModel;
import com.hbworks.dirpane.TreeDirectoryPane;
import com.hbworks.dirpane.event.LoadingEvent;
import com.hbworks.dirpane.event.LoadingListener;
import com.hbworks.dirpane.event.TreeLoadingEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeFileSystemModel
extends FileSystemModel
implements TreeModel {
    protected TreeDirectoryPane directoryPane;
    protected FileNode rootNode = null;
    protected Hashtable tableOfNodes = new Hashtable();
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;
    static /* synthetic */ Class class$com$hbworks$dirpane$event$LoadingListener;

    protected TreeFileSystemModel(TreeDirectoryPane pane, String rootPath) {
        this.directoryPane = pane;
        this.rootNode = this.createRootNode(rootPath);
        this.loadChildren(this.rootNode);
    }

    protected FileNode createRootNode(String rootPath) {
        File systemRoot = this.getFileSystemRoot();
        FileNode systemRootNode = this.createFileNode(systemRoot);
        if (rootPath != null) {
            if (rootPath.equals("")) {
                return systemRootNode;
            }
            if (this.getFileSystem().equals(BasicFileSystem.windowsFileSystem) && rootPath.equalsIgnoreCase(systemRoot.getPath())) {
                return systemRootNode;
            }
            File root = this.createFileObject(rootPath);
            if (!this.doesFileExist(root)) {
                return systemRootNode;
            }
            FileNode rootNode = this.createFileNode(root);
            boolean rootExists = this.belongsToFileSystem(root);
            if (rootExists) {
                this.removeFromTableOfNodes(systemRoot.getPath());
                return rootNode;
            }
            return systemRootNode;
        }
        return systemRootNode;
    }

    protected void putIntoTableOfNodes(String path, FileNode node) {
        this.tableOfNodes.put(path.toLowerCase(), node);
    }

    protected FileNode getFromTableOfNodes(String path) {
        if (path == null) {
            return null;
        }
        return (FileNode)this.tableOfNodes.get(path.toLowerCase());
    }

    protected void removeFromTableOfNodes(String path) {
        this.tableOfNodes.remove(path.toLowerCase());
    }

    public void removeNode(FileNode node) {
        this.removeDescendantsOfNode(node);
    }

    public void removeDescendantsOfNode(FileNode node) {
        Enumeration<TreeNode> subtree = node.depthFirstEnumeration();
        Vector<FileNode> v = new Vector<FileNode>();
        while (subtree.hasMoreElements()) {
            FileNode child = (FileNode)subtree.nextElement();
            if (child.equals(node)) continue;
            v.addElement(child);
        }
        Vector clone = (Vector)v.clone();
        int i = 0;
        while (i < clone.size()) {
            FileNode n = (FileNode)clone.elementAt(i);
            this.removeNodeFromParent(n);
            this.directoryPane.removeFromAutoRefresher(n.getFile());
            this.removeFromTableOfNodes(n.getPathString());
            ++i;
        }
        node.setChildrenLoaded(false);
        node.setSorted(false);
        node.setLoading(false);
    }

    public void refresh() {
        this.refresh(this.getCurrentDirectory());
    }

    public void refresh(File parent) {
        FileNode node = this.getFromTableOfNodes(parent.getPath());
        if (node != null) {
            this.refresh(node);
        }
    }

    public void refresh(FileNode node) {
        this.fireLoadingStarted(new TreePath(this.getPathToRoot(node)));
        this.removeDescendantsOfNode(node);
        File[] contents = this.getContentsOfFile(node.getFile());
        node.setEmpty(contents.length == 0);
        node.setContents(contents);
        node.setLoading(true);
        int i = 0;
        while (i < contents.length) {
            File f = contents[i];
            FileNode n = this.createFileNode(f);
            this.addNodeTo(n, node);
            ++i;
        }
        node.setLoading(false);
        node.setChildrenLoaded(true);
        node.sortChildren();
        node.setSorted(true);
        this.fireNodeLoaded(node);
        this.reload(node);
        this.fireNodeLoaded(node);
        this.fireLoadingEnded(node, -1);
    }

    public void refreshAll() {
        this.directoryPane.blockAutoRefresher();
        this.directoryPane.clearAutoRefresher();
        this.directoryPane.prepareForRebuild();
        Enumeration all = this.tableOfNodes.elements();
        this.fireLoadingStarted(new TreePath(this.rootNode.getPath()));
        while (all.hasMoreElements()) {
            FileNode node = (FileNode)all.nextElement();
            if (node.isLeaf()) continue;
            File[] contents = this.getContentsOfFile(node.getFile());
            node.setEmpty(contents.length == 0);
            node.setContents(contents);
            if (!node.hasChildrenLoaded()) continue;
            node.removeAllChildren();
            node.setChildrenLoaded(false);
            node.setSorted(false);
            node.setLoading(true);
            int i = 0;
            while (i < contents.length) {
                File f = contents[i];
                FileNode n = this.getFromTableOfNodes(f.getPath());
                if (n == null) {
                    n = this.createFileNode(f);
                }
                this.addNodeTo(n, node);
                ++i;
            }
            node.setLoading(false);
            node.setChildrenLoaded(true);
            node.sortChildren();
            node.setSorted(true);
            this.directoryPane.addToAutoRefresher(node.getFile());
            this.fireNodeLoaded(node);
            this.reload(node);
        }
        this.directoryPane.unblockAutoRefresher();
        this.fireLoadingEnded(this.rootNode, 2);
    }

    protected void setFileSystem(FileSystem newFileSystem) {
        super.setFileSystem(newFileSystem);
        this.tableOfNodes.clear();
        this.rootNode = this.createRootNode(null);
        this.currentDirectory = newFileSystem.getFileSystemRoot();
        this.loadChildren(this.rootNode);
        this.reload();
    }

    protected abstract FileNode createFileNode(File var1);

    public File[] getContentsOfFile(File file) {
        int i;
        File[] contents = this.getFiles(file, this.directoryPane.isFileHidingEnabled());
        if (this.fileSorter != null) {
            this.fileSorter.sort(contents);
        }
        Vector<File> files = new Vector<File>(contents.length);
        if (this.directoryPane.getFileSelectionMode() == 1) {
            i = 0;
            while (i < contents.length) {
                File f = contents[i];
                if (f instanceof BasicFileSystem.WindowsDrive && f.getPath().equals("A:\\")) {
                    files.addElement(f);
                } else {
                    boolean isTraversable = this.isTraversable(f);
                    boolean isAccepted = this.directoryPane.accept(f);
                    if (isAccepted && isTraversable) {
                        files.addElement(f);
                    }
                }
                ++i;
            }
        } else if (this.directoryPane.getFileSelectionMode() == 0) {
            i = 0;
            while (i < contents.length) {
                File f = contents[i];
                if (!(f instanceof BasicFileSystem.WindowsDrive) || !f.getPath().equals("A:\\")) {
                    boolean isTraversable = this.isTraversable(f);
                    boolean isAccepted = this.directoryPane.accept(f);
                    if (isAccepted && !isTraversable) {
                        files.addElement(f);
                    }
                }
                ++i;
            }
        } else if (this.directoryPane.getFileSelectionMode() == 2) {
            i = 0;
            while (i < contents.length) {
                File f = contents[i];
                if (f instanceof BasicFileSystem.WindowsDrive && f.getPath().equals("A:\\")) {
                    files.addElement(f);
                } else {
                    boolean isAccepted = this.directoryPane.accept(f);
                    if (isAccepted) {
                        files.addElement(f);
                    }
                }
                ++i;
            }
        } else {
            return new File[0];
        }
        Object[] a = new File[files.size()];
        files.copyInto(a);
        return a;
    }

    public boolean isEmptyFile(File file) {
        File[] contents = this.getContentsOfFile(file);
        return contents.length == 0;
    }

    public FileNode getCurrentNode() {
        File curDir = this.getCurrentDirectory();
        if (curDir == null) {
            return null;
        }
        String curPath = curDir.getPath();
        FileNode curNode = this.getFromTableOfNodes(curPath);
        if (curNode == null) {
            curNode = this.createFileNode(curDir);
        }
        return curNode;
    }

    public TreePath getCurrentPath() {
        FileNode curNode = this.getCurrentNode();
        if (curNode == null) {
            return null;
        }
        TreePath path = new TreePath(this.getPathToRoot(curNode));
        return path;
    }

    public File getFile(FileNode node) {
        if (node == null) {
            return null;
        }
        return node.getFile();
    }

    public File getFile(TreePath path) {
        if (path == null) {
            return null;
        }
        FileNode node = (FileNode)path.getLastPathComponent();
        return node.getFile();
    }

    protected void setRoot(String newRootPath) {
        this.tableOfNodes.clear();
        this.rootNode = null;
        this.rootNode = this.createRootNode(newRootPath);
        this.currentDirectory = this.rootNode.getFile();
        this.loadChildren(this.rootNode);
        this.reload();
    }

    public Object getRoot() {
        return this.rootNode;
    }

    public int getChildCount(Object aNode) {
        FileNode parent = (FileNode)aNode;
        if (this.isLeaf(parent)) {
            return 0;
        }
        if (this.isEmpty(parent)) {
            return 0;
        }
        return parent.getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((FileNode)parent).getIndex((FileNode)child);
    }

    public Object getChild(Object parent, int index) {
        return ((FileNode)parent).getChildAt(index);
    }

    public boolean isLeaf(Object node) {
        return ((FileNode)node).isLeaf();
    }

    public abstract void valueForPathChanged(TreePath var1, Object var2);

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = TreeFileSystemModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = TreeFileSystemModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public boolean isEmpty(Object node) {
        if (node == null) {
            return true;
        }
        return ((FileNode)node).isEmpty();
    }

    public boolean isChildOf(FileNode parentNode, FileNode childNode) {
        return this.getIndexOfChild(parentNode, childNode) != -1;
    }

    public FileNode[] getPathToRoot(FileNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected FileNode[] getPathToRoot(FileNode aNode, int depth) {
        FileNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new FileNode[depth];
        } else {
            ++depth;
            if (aNode == this.rootNode) {
                retNodes = new FileNode[depth];
            } else {
                FileNode parentNode = (FileNode)aNode.getParent();
                retNodes = this.getPathToRoot(parentNode, depth);
            }
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public boolean isDescendantOfRoot(File childFile) {
        if (childFile == null || this.rootNode == null) {
            return false;
        }
        File rootFile = this.rootNode.getFile();
        File parentFile = childFile;
        do {
            if (!parentFile.equals(rootFile)) continue;
            return true;
        } while ((parentFile = this.getParentDirectory(parentFile)) != null);
        return false;
    }

    protected abstract void loadChildren(FileNode var1);

    protected abstract void loadPath(FileNode var1, int var2);

    public void addNodeTo(FileNode newChild, FileNode parent) {
        parent.add(newChild);
        int[] newIndexs = new int[]{parent.getIndex(newChild)};
        parent.setSorted(false);
        parent.setEmpty(false);
        this.nodesWereInserted(parent, newIndexs);
    }

    public void replaceNodeInto(FileNode newChild, FileNode parent, int index) {
        parent.replace(newChild, index);
        int[] newIndexs = new int[]{index};
        parent.setSorted(false);
        this.nodesChanged(parent, newIndexs);
    }

    public void removeNodeFromParent(FileNode node) {
        FileNode parent = (FileNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(childIndex[0]);
        removedArray[0] = node;
        parent.setEmpty(this.isEmptyFile(parent.getFile()));
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    public void nodeChanged(FileNode node) {
        int anIndex;
        FileNode parent;
        if (this.listenerList != null && node != null && (parent = (FileNode)node.getParent()) != null && (anIndex = parent.getIndex(node)) != -1) {
            int[] cIndexs = new int[]{anIndex};
            parent.setSorted(false);
            this.nodesChanged(parent, cIndexs);
        }
    }

    public void nodeStructureChanged(FileNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    public void reload() {
        this.reload(this.rootNode);
    }

    public void reload(FileNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    protected void fireNodeLoaded(FileNode node) {
        Object[] listeners = this.listenerList.getListenerList();
        LoadingEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$hbworks$dirpane$event$LoadingListener == null ? TreeFileSystemModel.class$("com.hbworks.dirpane.event.LoadingListener") : class$com$hbworks$dirpane$event$LoadingListener)) {
                if (e == null) {
                    e = new LoadingEvent(node, 1);
                }
                ((LoadingListener)listeners[i + 1]).loadingChanged(e);
            }
            i -= 2;
        }
    }

    protected void fireLoadingStarted(TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeLoadingEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$hbworks$dirpane$event$LoadingListener == null ? TreeFileSystemModel.class$("com.hbworks.dirpane.event.LoadingListener") : class$com$hbworks$dirpane$event$LoadingListener)) {
                if (e == null) {
                    e = new TreeLoadingEvent(this, 0, path);
                }
                ((LoadingListener)listeners[i + 1]).loadingChanged(e);
            }
            i -= 2;
        }
    }

    protected void fireLoadingEnded(FileNode node, int loadType) {
        Object[] nodes = this.getPathToRoot(node);
        TreePath path = new TreePath(nodes);
        this.fireLoadingEnded(path, loadType);
    }

    protected void fireLoadingEnded(TreePath path, int loadType) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeLoadingEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$hbworks$dirpane$event$LoadingListener == null ? TreeFileSystemModel.class$("com.hbworks.dirpane.event.LoadingListener") : class$com$hbworks$dirpane$event$LoadingListener)) {
                if (e == null) {
                    e = new TreeLoadingEvent(this, 1, loadType, path);
                }
                ((LoadingListener)listeners[i + 1]).loadingChanged(e);
            }
            i -= 2;
        }
    }

    public void nodesWereInserted(FileNode node, int[] childIndices) {
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            int counter = 0;
            while (counter < cCount) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
                ++counter;
            }
            this.fireFileNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
        }
    }

    public void nodesWereRemoved(FileNode node, int[] childIndices, Object[] removedChildren) {
        if (node != null && childIndices != null) {
            this.fireFileNodesRemoved(this, this.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    public void nodesChanged(FileNode node, int[] childIndices) {
        int cCount;
        if (node != null && childIndices != null && (cCount = childIndices.length) > 0) {
            Object[] cChildren = new Object[cCount];
            int counter = 0;
            while (counter < cCount) {
                cChildren[counter] = node.getChildAt(childIndices[counter]);
                ++counter;
            }
            this.fireFileNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
        }
    }

    protected void fireFileNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$TreeModelListener == null ? TreeFileSystemModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
            }
            i -= 2;
        }
    }

    protected void fireFileNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$TreeModelListener == null ? TreeFileSystemModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
            }
            i -= 2;
        }
    }

    protected void fireFileNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$TreeModelListener == null ? TreeFileSystemModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
            }
            i -= 2;
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$TreeModelListener == null ? TreeFileSystemModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (e == null) {
                    e = new TreeModelEvent(source, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
            }
            i -= 2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

