/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.comp;

import com.hbworks.dirpane.TreeDirectoryPane;
import com.hbworks.dirpane.TreeFileSystemModel;
import com.hbworks.dirpane.comp.DirectoryComboBox;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;

public class TreeDirectoryComboBox
extends DirectoryComboBox {
    static final long serialVersionUID = 8775594888638125719L;

    public TreeDirectoryComboBox() {
        this((TreeDirectoryPane)null);
    }

    public TreeDirectoryComboBox(TreeDirectoryPane pane) {
        super(pane);
    }

    protected DirectoryComboBox.DirectoryComboBoxModel createDirectoryComboBoxModel() {
        return new TreeDirectoryComboBoxModel();
    }

    protected PropertyChangeListener createDirectoryChangedListener() {
        return new TreeDirectoryChangedListener();
    }

    private class TreeDirectoryChangedListener
    implements PropertyChangeListener {
        private TreeDirectoryChangedListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            File f;
            String name = e.getPropertyName();
            if (name == "fileSystemChanged" || name == "rootChanged") {
                TreeDirectoryComboBox.this.model = TreeDirectoryComboBox.this.createDirectoryComboBoxModel();
                TreeDirectoryComboBox.this.setModel(TreeDirectoryComboBox.this.model);
            }
            if ((name == "directoryChanged" || name == "syncSlaveDirectory") && (f = (File)e.getNewValue()) != null && f != TreeDirectoryComboBox.this.selectedDirectory && TreeDirectoryComboBox.this.pane.getModel().belongsToFileSystem(f)) {
                if (!((TreeFileSystemModel)TreeDirectoryComboBox.this.pane.getModel()).isDescendantOfRoot(f)) {
                    return;
                }
                TreeDirectoryComboBox.this.model.addItem(f);
            }
        }
    }

    protected class TreeDirectoryComboBoxModel
    extends DirectoryComboBox.DirectoryComboBoxModel {
        public TreeDirectoryComboBoxModel() {
            this.directories.removeAllElements();
            TreeDirectoryComboBox.this.root = ((TreeDirectoryPane)TreeDirectoryComboBox.this.pane).getRoot().getFile();
            this.directories.addElement(TreeDirectoryComboBox.this.root);
            File[] children = TreeDirectoryComboBox.this.pane.getFiles(TreeDirectoryComboBox.this.root, TreeDirectoryComboBox.this.pane.isFileHidingEnabled());
            if (TreeDirectoryComboBox.this.pane.getFileSorter() != null) {
                TreeDirectoryComboBox.this.pane.getFileSorter().sort(children);
            }
            int i = 0;
            while (i < children.length) {
                if (TreeDirectoryComboBox.this.pane.isTraversable(children[i])) {
                    this.directories.addElement(children[i]);
                }
                ++i;
            }
        }
    }
}

