/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.plaf;

import com.hbworks.dirpane.TableDirectoryPane;
import com.hbworks.dirpane.plaf.DirectoryPaneUI;
import com.hbworks.dirpane.resources.LocalizedStringTable;
import com.hbworks.misc.GlassPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class TableDirectoryPaneUI
extends DirectoryPaneUI {
    protected TableDirectoryPane directoryPane;
    protected JTable table;
    private String Mbytes = null;
    private String Kbytes = null;

    public void installUI(JComponent c) {
        super.installUI(c);
        this.Mbytes = LocalizedStringTable.getString("TableDirectoryPaneUI.Mbytes");
        this.Kbytes = LocalizedStringTable.getString("TableDirectoryPaneUI.Kbytes");
        this.installColors();
    }

    public void uninstallUI(JComponent c) {
        this.Mbytes = null;
        this.Kbytes = null;
        this.uninstallColors();
        super.uninstallUI(c);
    }

    protected void installColors() {
        if (this.paneBackground == null) {
            this.paneActiveBackground = this.directoryPane.getBackground();
            this.paneNotActiveBackground = this.directoryPane.getNotActiveBackground();
            this.paneBackground = this.directoryPane.isGrayoutEnabled() ? (this.directoryPane.isActivePane() ? this.paneActiveBackground : this.paneNotActiveBackground) : this.paneActiveBackground;
            Color fg = this.directoryPane.getForeground();
            this.paneForeground = fg == null ? UIManager.getColor("Table.foreground") : fg;
            Color sfg = this.directoryPane.getSelectionForeground();
            this.paneSelectionForeground = sfg == null ? UIManager.getColor("Table.selectionForeground") : sfg;
            Color sbg = this.directoryPane.getSelectionBackground();
            this.paneSelectionBackground = sbg == null ? UIManager.getColor("Table.selectionBackground") : sbg;
        }
    }

    protected void uninstallColors() {
        this.paneBackground = null;
        this.paneForeground = null;
        this.paneActiveBackground = null;
        this.paneNotActiveBackground = null;
        this.paneSelectionForeground = null;
        this.paneSelectionBackground = null;
    }

    protected JComponent createGlassPaneFor(Container c) {
        return new CoverGlass(c);
    }

    public TableDirectoryPane getDirectoryPane() {
        return this.directoryPane;
    }

    public JTable getUITable() {
        return this.table;
    }

    public String getMbytesString() {
        return this.Mbytes;
    }

    public String getKbytesString() {
        return this.Kbytes;
    }

    public void setMbytesString(String mb) {
        this.Mbytes = mb;
    }

    public void setKbytesString(String kb) {
        this.Kbytes = kb;
    }

    protected class CoverGlass
    extends GlassPanel {
        public CoverGlass(Container c) {
            super(c);
            this.setVisible(false);
        }

        public void processMouseEvent(MouseEvent e) {
            if (e.getID() == 501) {
                TableDirectoryPaneUI.this.directoryPane.setActivePane(true);
                if ((e.getModifiers() & 4) > 0) {
                    super.processMouseEvent(e);
                } else {
                    MouseEvent targetEvent = SwingUtilities.convertMouseEvent(this, e, this.targetContainer);
                    int targetX = targetEvent.getX();
                    int targetY = targetEvent.getY();
                    Component x = SwingUtilities.getDeepestComponentAt(this.targetContainer, targetX, targetY);
                    boolean hitScrollBar = false;
                    if (x instanceof JScrollBar) {
                        hitScrollBar = true;
                    }
                    if (hitScrollBar || TableDirectoryPaneUI.this.directoryPane.isSelectionEmpty()) {
                        super.processMouseEvent(e);
                    } else {
                        e.consume();
                    }
                }
            } else if (e.getID() == 502) {
                super.processMouseEvent(e);
            }
        }
    }
}

