/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.examples.rmi;

import java.io.File;

public final class RemoteFile
extends File {
    File remoteRoot;

    RemoteFile(File remoteRoot, String pathname) throws IllegalArgumentException {
        super(pathname);
        this.remoteRoot = remoteRoot;
        if (!this.isDescendantOf(pathname, remoteRoot.getPath())) {
            throw new IllegalArgumentException(pathname + ": no descendant of server root.");
        }
    }

    RemoteFile(File remoteRoot, String parent, String child) throws IllegalArgumentException {
        super(parent, child);
        this.remoteRoot = remoteRoot;
        if (!this.isDescendantOf(parent, remoteRoot.getPath())) {
            throw new IllegalArgumentException(parent + ": no descendant of server root.");
        }
    }

    RemoteFile(File remoteRoot, File parent, String child) throws IllegalArgumentException {
        super(parent, child);
        this.remoteRoot = remoteRoot;
        if (!this.isDescendantOf(parent.getPath(), remoteRoot.getPath())) {
            throw new IllegalArgumentException(parent.getPath() + ": no descendant of server root.");
        }
    }

    public String getParent() {
        String parent = super.getParent();
        if (parent.equals(this.remoteRoot.getParent())) {
            parent = null;
        }
        return parent;
    }

    private boolean isDescendantOf(String childPath, String remotePath) {
        if (childPath == null || childPath == "") {
            return false;
        }
        String parentPath = childPath;
        do {
            if (!parentPath.equals(remotePath)) continue;
            return true;
        } while ((parentPath = this.getParentPath(parentPath)) != null);
        return false;
    }

    private String getParentPath(String path) {
        int index = path.lastIndexOf(File.separatorChar);
        if (index < 0) {
            return null;
        }
        return path.substring(0, index);
    }
}

