/*
 * Decompiled with CFR 0.152.
 */
package de.dlcc.callnotify;

import de.dlcc.callnotify.CallData;
import de.dlcc.callnotify.CallNotifyMessage;
import de.dlcc.callnotify.CallNotifyServer;
import de.dlcc.callnotify.ListenClient;
import de.dlcc.callnotify.MessageSender;
import de.dlcc.callnotify.ObjectListener;
import de.dlcc.callnotify.ObjectReceiver;
import de.dlcc.callnotify.RegisteredClients;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.InetAddress;
import java.util.Enumeration;

public class CallNotifyBroker
implements ObjectReceiver {
    RegisteredClients clients;
    int listenPort;
    int sendPort;
    long startTime;
    CallNotifyMessage msg;
    MessageSender ms;
    String execOnRing = null;
    String execOnRingFilter = null;

    public CallNotifyBroker(int n, int n2, String string, String string2) {
        this.listenPort = n;
        this.sendPort = n2;
        this.execOnRing = string;
        this.execOnRingFilter = string2;
        this.clients = new RegisteredClients();
        ObjectListener objectListener = new ObjectListener(n, this);
        objectListener.start();
        System.out.println("Broker initialized");
        this.startTime = System.currentTimeMillis();
    }

    public void newObject(Object object) {
        this.msg = (CallNotifyMessage)object;
        int n = this.msg.getType();
        switch (n) {
            case 1: {
                this.registerClient(this.msg.getInetAddress());
                break;
            }
            case 2: {
                this.deregisterClient(this.msg.getInetAddress());
                break;
            }
            case 3: {
                InetAddress inetAddress = this.msg.getInetAddress();
                this.registerClient(inetAddress);
                break;
            }
            case 8: {
                this.addPBEntry(this.msg.getDetails());
                break;
            }
            case 10: {
                this.sendStatus(this.msg.getInetAddress());
                break;
            }
            case 12: {
                this.sendLast(this.msg.getInetAddress());
            }
        }
    }

    public boolean incomingCall(CallData callData) {
        Object object;
        Enumeration enumeration = this.clients.elements();
        this.msg = new CallNotifyMessage(7, callData.getAll(), null);
        while (enumeration.hasMoreElements()) {
            object = new MessageSender(((ListenClient)enumeration.nextElement()).getAddress(), this.msg, this.listenPort, this.sendPort);
            ((Thread)object).start();
        }
        if (this.execOnRing != null && callData.getAll().indexOf(this.execOnRingFilter) > -1) {
            object = Runtime.getRuntime();
            Process process = null;
            try {
                process = ((Runtime)object).exec(this.execOnRing);
            }
            catch (Exception exception) {
                System.out.println("Error running custom process on call!");
            }
        }
        return true;
    }

    public void registerClient(InetAddress inetAddress) {
        ListenClient listenClient = new ListenClient(inetAddress);
        int n = this.clients.addClient(listenClient);
        if (n == 0) {
            System.out.println("Registered client " + inetAddress.getHostAddress());
            this.msg = new CallNotifyMessage(4, "", null);
            this.ms = new MessageSender(inetAddress, this.msg, this.listenPort, this.sendPort);
            this.ms.start();
        } else if (n == 1) {
            this.msg = new CallNotifyMessage(4, "", null);
            this.ms = new MessageSender(inetAddress, this.msg, this.listenPort, this.sendPort);
            this.ms.start();
        } else {
            System.out.println("Rejected client " + inetAddress.getHostAddress());
            this.msg = new CallNotifyMessage(5, "", null);
            this.ms = new MessageSender(inetAddress, this.msg, this.listenPort, this.sendPort);
            this.ms.start();
        }
    }

    public void deregisterClient(InetAddress inetAddress) {
        ListenClient listenClient = new ListenClient(inetAddress);
        if (this.clients.removeClient(listenClient)) {
            System.out.println("Deregistered client " + inetAddress.getHostAddress());
        } else {
            System.out.println("Couldn't deregister client " + inetAddress.getHostAddress());
        }
    }

    public void sendLast(InetAddress inetAddress) {
        String[] stringArray = new String[10];
        String string = "";
        int n = 0;
        boolean bl = false;
        try {
            String string2;
            FileReader fileReader = new FileReader(CallNotifyServer.callerLog);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (n == 10) {
                    n = 0;
                    bl = true;
                }
                stringArray[n] = string2;
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Error reading logfile.");
            exception.printStackTrace();
            return;
        }
        if (bl) {
            int n2 = 0;
            while (n2 < 10) {
                string = stringArray[(n2 + n) % 10] + "\n" + string;
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                string = stringArray[n3] + "\n" + string;
                ++n3;
            }
        }
        this.msg = new CallNotifyMessage(13, string, null);
        this.ms = new MessageSender(inetAddress, this.msg, this.listenPort, this.sendPort);
        this.ms.start();
    }

    public void sendStatus(InetAddress inetAddress) {
        long l = (System.currentTimeMillis() - this.startTime) / 1000L;
        long l2 = l / 86400L;
        long l3 = (l %= 86400L) / 3600L;
        long l4 = (l %= 3600L) / 60L;
        long l5 = l %= 60L;
        String string = Long.toString(l3);
        String string2 = Long.toString(l4);
        String string3 = Long.toString(l5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        String string4 = "Status Information:\nUptime " + l2 + " days, " + string + ":" + string2 + ":" + string3 + "\n" + this.clients.size() + " registered client(s):\n";
        if (this.clients.size() > 20) {
            string4 = string4 + "(too many to list)";
        } else {
            Enumeration enumeration = this.clients.elements();
            while (enumeration.hasMoreElements()) {
                string4 = string4 + ((ListenClient)enumeration.nextElement()).getAddressString() + "\n";
            }
        }
        this.msg = new CallNotifyMessage(11, string4, null);
        this.ms = new MessageSender(inetAddress, this.msg, this.listenPort, this.sendPort);
        this.ms.start();
    }

    public void addPBEntry(String string) {
    }
}

