/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import mindbright.security.Cipher;
import mindbright.security.KeyPair;
import mindbright.security.RSAPrivateKey;
import mindbright.security.RSAPublicKey;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHDataInputStream;
import mindbright.ssh.SSHDataOutputStream;

public class SSHRSAKeyFile {
    int cipherType;
    RSAPublicKey pubKey;
    String fileComment;
    byte[] encrypted;
    static final String privFileId = "SSH PRIVATE KEY FILE FORMAT 1.1\n";

    public static void createKeyFile(KeyPair keyPair, String string, String string2, String string3) throws IOException {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        SSHDataOutputStream sSHDataOutputStream = new SSHDataOutputStream(byteArrayOutputStream);
        byte[] byArray = new byte[2];
        SSH.secureRandom().nextBytes(byArray);
        sSHDataOutputStream.writeByte(byArray[0]);
        sSHDataOutputStream.writeByte(byArray[1]);
        sSHDataOutputStream.writeByte(byArray[0]);
        sSHDataOutputStream.writeByte(byArray[1]);
        sSHDataOutputStream.writeBigInteger(rSAPrivateKey.getD());
        sSHDataOutputStream.writeBigInteger(rSAPrivateKey.getU());
        sSHDataOutputStream.writeBigInteger(rSAPrivateKey.getP());
        sSHDataOutputStream.writeBigInteger(rSAPrivateKey.getQ());
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byArray = new byte[8 - byArray2.length % 8 + byArray2.length];
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        byArray2 = byArray;
        int n = 3;
        Cipher cipher = Cipher.getInstance(SSH.cipherClasses[n][0]);
        cipher.setKey(string);
        byArray2 = cipher.encrypt(byArray2);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        sSHDataOutputStream = new SSHDataOutputStream(fileOutputStream);
        sSHDataOutputStream.writeBytes(privFileId);
        sSHDataOutputStream.writeByte(0);
        sSHDataOutputStream.writeByte(n);
        sSHDataOutputStream.writeInt(0);
        sSHDataOutputStream.writeInt(0);
        sSHDataOutputStream.writeBigInteger(((RSAPublicKey)keyPair.getPublic()).getN());
        sSHDataOutputStream.writeBigInteger(((RSAPublicKey)keyPair.getPublic()).getE());
        sSHDataOutputStream.writeString(string3);
        sSHDataOutputStream.write(byArray2, 0, byArray2.length);
        sSHDataOutputStream.close();
    }

    public SSHRSAKeyFile(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        SSHDataInputStream sSHDataInputStream = new SSHDataInputStream(fileInputStream);
        byte[] byArray = new byte[privFileId.length()];
        sSHDataInputStream.readFully(byArray);
        String string2 = new String(byArray);
        sSHDataInputStream.readByte();
        if (!string2.equals(privFileId)) {
            throw new IOException("RSA key file corrupt");
        }
        this.cipherType = sSHDataInputStream.readByte();
        if (SSH.cipherClasses[this.cipherType][0] == null) {
            throw new IOException("Ciphertype " + this.cipherType + " in key-file not supported");
        }
        sSHDataInputStream.readInt();
        sSHDataInputStream.readInt();
        BigInteger bigInteger = sSHDataInputStream.readBigInteger();
        BigInteger bigInteger2 = sSHDataInputStream.readBigInteger();
        this.pubKey = new RSAPublicKey(bigInteger2, bigInteger);
        this.fileComment = sSHDataInputStream.readString();
        byte[] byArray2 = new byte[8192];
        int n = sSHDataInputStream.read(byArray2);
        sSHDataInputStream.close();
        this.encrypted = new byte[n];
        System.arraycopy(byArray2, 0, this.encrypted, 0, n);
    }

    public String getComment() {
        return this.fileComment;
    }

    public RSAPublicKey getPublic() {
        return this.pubKey;
    }

    public RSAPrivateKey getPrivate(String string) {
        RSAPrivateKey rSAPrivateKey = null;
        Cipher cipher = Cipher.getInstance(SSH.cipherClasses[this.cipherType][0]);
        cipher.setKey(string);
        byte[] byArray = cipher.decrypt(this.encrypted);
        SSHDataInputStream sSHDataInputStream = new SSHDataInputStream(new ByteArrayInputStream(byArray));
        try {
            byte by = sSHDataInputStream.readByte();
            byte by2 = sSHDataInputStream.readByte();
            byte by3 = sSHDataInputStream.readByte();
            byte by4 = sSHDataInputStream.readByte();
            if (by != by3 || by2 != by4) {
                return null;
            }
            BigInteger bigInteger = sSHDataInputStream.readBigInteger();
            BigInteger bigInteger2 = sSHDataInputStream.readBigInteger();
            BigInteger bigInteger3 = sSHDataInputStream.readBigInteger();
            BigInteger bigInteger4 = sSHDataInputStream.readBigInteger();
            sSHDataInputStream.close();
            rSAPrivateKey = new RSAPrivateKey(this.pubKey.getE(), this.pubKey.getN(), bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }
        catch (IOException iOException) {
            rSAPrivateKey = null;
        }
        return rSAPrivateKey;
    }
}

