/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.ssh;

import com.isnetworks.ssh.AbstractFileBrowser;
import com.isnetworks.ssh.FileDisplay;
import com.isnetworks.ssh.FileListItem;
import com.isnetworks.ssh.SSHException;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import mindbright.ssh.SSHPropertyHandler;

public class LocalFileBrowser
extends AbstractFileBrowser {
    private File mCurrentDirectory;

    public LocalFileBrowser(FileDisplay fileDisplay, SSHPropertyHandler sSHPropertyHandler) {
        super(fileDisplay, sSHPropertyHandler);
    }

    public void initialize() throws SSHException {
        this.changeDirectory(this.mPropertyHandler.getSSHHomeDir());
    }

    public void refresh() throws SSHException {
        Vector<FileListItem> vector = new Vector<FileListItem>();
        if (this.mCurrentDirectory.getParent() != null) {
            vector.addElement(new FileListItem("..", "unknown", true));
        }
        String[] stringArray = this.mCurrentDirectory.list();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(new FileListItem(new File(this.mCurrentDirectory, stringArray[n])));
            ++n;
        }
        FileListItem.sort(vector);
        try {
            this.mFileDisplay.setFileList(vector, this.mCurrentDirectory.getCanonicalPath());
        }
        catch (IOException iOException) {
            throw new SSHException("Unable to refresh file list");
        }
    }

    public void makeDirectory(String string) throws SSHException {
        File file = new File(this.mCurrentDirectory, string);
        if (!file.mkdirs()) {
            throw new SSHException("Unable to make directory: " + file.getAbsolutePath());
        }
        this.refresh();
    }

    public void delete(FileListItem[] fileListItemArray) throws SSHException {
        int n = 0;
        while (n < fileListItemArray.length) {
            File file = new File(fileListItemArray[n].getParent(), fileListItemArray[n].getName());
            if (!file.delete()) {
                throw new SSHException("Unable to delete " + fileListItemArray[n].getAbsolutePath() + " - may not have permission or directory may not be empty");
            }
            ++n;
        }
        this.refresh();
    }

    public void changeDirectory(String string) throws SSHException {
        File file = new File(string);
        if (!file.exists()) {
            throw new SSHException("Directory " + string + " does not exist or you do not have permission to access it.");
        }
        if (file.isFile()) {
            throw new SSHException(string + " a file, not a directory.");
        }
        this.mCurrentDirectory = file;
        this.refresh();
    }

    public void rename(FileListItem fileListItem, String string) throws SSHException {
        File file;
        File file2 = new File(fileListItem.getParent(), fileListItem.getName());
        if (!file2.renameTo(file = new File(this.mCurrentDirectory, string))) {
            throw new SSHException("Unable to rename file " + fileListItem.getAbsolutePath() + " to " + fileListItem.getParent() + string);
        }
        this.refresh();
    }

    public void fileDoubleClicked(FileListItem fileListItem) throws SSHException {
        if (fileListItem.isDirectory()) {
            File file = null;
            file = fileListItem.getName().equals("..") ? new File(this.mCurrentDirectory.getParent()) : new File(fileListItem.getParent(), fileListItem.getName());
            if (!file.exists() || !file.isDirectory()) {
                throw new SSHException("Unable to open directory: " + file.getAbsolutePath());
            }
            this.mCurrentDirectory = file;
            this.refresh();
        }
    }
}

