/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import mindbright.security.Cipher;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHCommandShell;
import mindbright.ssh.SSHConsole;
import mindbright.ssh.SSHInteractiveClient;
import mindbright.terminal.Terminal;
import mindbright.terminal.TerminalClipboard;
import mindbright.terminal.TerminalListener;
import mindbright.terminal.TerminalWin;

public final class SSHStdIO
implements TerminalListener,
TerminalClipboard,
SSHConsole {
    static Toolkit toolkit;
    SSHCommandShell commandShell = null;
    Container ownerContainer;
    SSHChannelController controller = null;
    SSHInteractiveClient client;
    TerminalWin term;
    Cipher sndCipher = null;
    String ownerName;
    boolean selectionAvailable = false;
    boolean escapeForced = false;
    Boolean readLineLock = new Boolean(false);
    boolean pressedCtrlD;
    boolean isReadingLine;
    boolean echoStar;
    String readLineStr;
    protected boolean isConnected = false;
    static Clipboard localClipboard;
    SSHExternalMessage extMsg = null;

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setTerminal(TerminalWin terminalWin) {
        this.term = terminalWin;
        if (terminalWin != null) {
            terminalWin.addTerminalListener(this);
            terminalWin.addTerminalClipboard(this);
        }
    }

    public void setClient(SSHInteractiveClient sSHInteractiveClient) {
        this.client = sSHInteractiveClient;
    }

    public void setOwnerContainer(Container container) {
        this.ownerContainer = container;
        if (toolkit == null) {
            toolkit = Toolkit.getDefaultToolkit();
        }
    }

    public void setOwnerName(String string) {
        this.ownerName = string;
    }

    public boolean hasCommandShell() {
        return this.commandShell != null;
    }

    public void enableCommandShell(boolean bl) {
        if (bl) {
            try {
                Class<?> clazz = Class.forName("mindbright.ssh.SSHCommandShellImpl");
                this.commandShell = (SSHCommandShell)clazz.newInstance();
                this.commandShell.setStdIO(this);
            }
            catch (Throwable throwable) {
                this.println("");
                this.println("The local command-shell is not available in this distribution.");
            }
        } else {
            this.commandShell = null;
        }
    }

    public void wantCommandShell() {
        this.escapeForced = true;
    }

    public void breakPromptLine(String string) {
        if (this.isReadingLine) {
            Boolean bl = this.readLineLock;
            synchronized (bl) {
                this.extMsg = new SSHExternalMessage(string);
                this.readLineLock.notify();
            }
        }
    }

    public String readLine(String string) {
        Boolean bl = this.readLineLock;
        synchronized (bl) {
            if (string != null) {
                this.readLineStr = string;
                this.term.write(string);
            } else {
                this.readLineStr = "";
            }
            this.isReadingLine = true;
            try {
                this.readLineLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isReadingLine = false;
        }
        return this.readLineStr;
    }

    public String promptLine(String string, String string2, boolean bl) throws IOException {
        Object object;
        String string3 = null;
        this.pressedCtrlD = false;
        if (this.term != null) {
            this.term.setAttribute(1, true);
            this.term.write(string);
            this.term.setAttribute(1, false);
            this.echoStar = bl;
            string3 = this.readLine(string2);
            this.echoStar = false;
        } else {
            object = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(string);
            string3 = ((BufferedReader)object).readLine();
            if (string3 == null || string3.length() > 0 && string3.charAt(0) == '\u0004') {
                this.pressedCtrlD = true;
            }
        }
        if (this.extMsg != null) {
            object = this.extMsg;
            this.extMsg = null;
            throw object;
        }
        if ((this.commandShell != null || this.client.isDumb()) && this.pressedCtrlD) {
            this.pressedCtrlD = false;
            throw new CtrlDPressedException();
        }
        return string3;
    }

    public void updateTitle() {
        int n = 0;
        int n2 = 0;
        if (this.term == null || this.ownerContainer == null) {
            return;
        }
        String string = null;
        string = this.term.getTitle();
        if (string == null) {
            n = this.term.rows();
            n2 = this.term.cols();
            if (this.client.isOpened()) {
                string = this.client.propsHandler.getProperty("usrname");
                string = string + "@" + this.client.propsHandler.getProperty("server");
                string = string + " <" + this.client.getServerVersion() + ">";
            } else {
                string = this.ownerName;
            }
            string = string + " [" + n2 + "x" + n + "]";
            if (!this.client.activateTunnels) {
                string = string + " (CLONE)";
            }
        }
        if (this.ownerContainer instanceof Frame) {
            ((Frame)this.ownerContainer).setTitle(string);
        }
    }

    public Terminal getTerminal() {
        return this.term;
    }

    public void stdoutWriteString(byte[] byArray) {
        if (this.isConnected) {
            this.print(new String(byArray));
        }
    }

    public void stderrWriteString(byte[] byArray) {
        if (this.isConnected) {
            this.print(new String(byArray));
        }
    }

    public void print(String string) {
        if (this.term != null) {
            this.term.write(string);
        } else {
            System.out.print(string);
        }
    }

    public void println(String string) {
        if (this.term != null) {
            this.term.write(string + "\n\r");
        } else {
            System.out.println(string);
        }
    }

    public void serverConnect(SSHChannelController sSHChannelController, Cipher cipher) {
        this.controller = sSHChannelController;
        this.sndCipher = cipher;
        this.isConnected = true;
    }

    public void serverDisconnect(String string) {
        this.controller = null;
        this.sndCipher = null;
        this.isConnected = false;
        this.println(string);
    }

    public void typedChar(char c) throws IOException {
        if (this.isConnected) {
            if (this.escapeForced || this.commandShell != null && this.commandShell.escapeSequenceTyped(c)) {
                this.escapeForced = false;
                this.commandShell.launchCommandShell();
            } else {
                this.client.stdinWriteChar(c);
            }
        } else {
            Boolean bl = this.readLineLock;
            synchronized (bl) {
                if (this.isReadingLine) {
                    if (c == '\u0004' && this.commandShell != null) {
                        this.pressedCtrlD = true;
                        this.readLineLock.notify();
                    } else if (c == '\u007f' || c == '\b') {
                        if (this.readLineStr.length() > 0) {
                            boolean bl2 = false;
                            if (this.readLineStr.charAt(this.readLineStr.length() - 1) < ' ') {
                                bl2 = true;
                            }
                            this.readLineStr = this.readLineStr.substring(0, this.readLineStr.length() - 1);
                            this.term.write('\b');
                            if (bl2) {
                                this.term.write('\b');
                            }
                            this.term.write(' ');
                            if (bl2) {
                                this.term.write(' ');
                            }
                            this.term.write('\b');
                            if (bl2) {
                                this.term.write('\b');
                            }
                        } else {
                            this.term.doBell();
                        }
                    } else if (c == '\r') {
                        this.readLineLock.notify();
                        this.term.write("\n\r");
                    } else {
                        this.readLineStr = this.readLineStr + c;
                        if (this.echoStar) {
                            this.term.write('*');
                        } else {
                            this.term.write(c);
                        }
                    }
                }
            }
        }
    }

    public void sendBytes(byte[] byArray) throws IOException {
        if (this.isConnected) {
            this.client.stdinWriteString(byArray);
        } else {
            int n = 0;
            while (n < byArray.length) {
                this.typedChar((char)byArray[n]);
                ++n;
            }
        }
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
        if (this.isConnected) {
            this.client.signalWindowChanged(n, n2, n3, n4);
        }
        this.updateTitle();
    }

    public void setSelection(String string) {
        Clipboard clipboard = SSHStdIO.getClipboard();
        if (clipboard == null || this.term == null) {
            return;
        }
        if (string == null) {
            string = "";
        }
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    public String getSelection() {
        Clipboard clipboard = SSHStdIO.getClipboard();
        String string = null;
        if (clipboard == null || this.term == null) {
            return string;
        }
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                try {
                    toolkit.beep();
                }
                catch (Throwable throwable) {}
            }
        } else {
            try {
                toolkit.beep();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string;
    }

    public void selectionAvailable(boolean bl) {
        this.selectionAvailable = bl;
        this.client.updateMenus();
    }

    static synchronized Clipboard getClipboard() {
        Clipboard clipboard;
        if (localClipboard == null) {
            try {
                clipboard = toolkit.getSystemClipboard();
            }
            catch (Throwable throwable) {
                clipboard = localClipboard = new Clipboard("MindTerm-local-clipboard");
            }
        } else {
            clipboard = localClipboard;
        }
        return clipboard;
    }

    static {
        localClipboard = null;
    }

    public static class SSHExternalMessage
    extends IOException {
        public SSHExternalMessage(String string) {
            super(string);
        }
    }

    public static class CtrlDPressedException
    extends IOException {
    }
}

