/*
 * Decompiled with CFR 0.152.
 */
package mindbright.terminal;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import mindbright.terminal.Terminal;
import mindbright.terminal.TerminalClipboard;
import mindbright.terminal.TerminalDefProps;
import mindbright.terminal.TerminalInterpreter;
import mindbright.terminal.TerminalListener;
import mindbright.terminal.TerminalMenuHandler;
import mindbright.terminal.TerminalXTerm;

public final class TerminalWin
extends Canvas
implements Terminal,
KeyListener,
AdjustmentListener,
MouseListener,
MouseMotionListener,
ComponentListener,
FocusListener {
    boolean metaKeyKludge = false;
    boolean ctrlKeyKludge = false;
    boolean tildeTypedKludge = false;
    boolean tildePressedKludge = false;
    boolean pendingShow = true;
    static final boolean DEBUG = false;
    static final boolean DEBUGKEYEVENT = false;
    public static final int GRAVITY_SOUTHWEST = 0;
    public static final int GRAVITY_NORTHWEST = 1;
    public static final int MIN_ROWS = 2;
    public static final int MIN_COLS = 8;
    public static final int MAX_COLS = 512;
    public static final int MAX_ROWS = 512;
    TerminalListener listener;
    TerminalClipboard clipboard;
    TerminalInterpreter interpreter;
    FixedScrollbar scrollbar = null;
    boolean haveScrollbar = false;
    PopupMenu popupmenu;
    Panel myPanel;
    Frame ownerFrame;
    public int popupButton = 4;
    TerminalMenuHandler menuHandler;
    String title = null;
    Properties props;
    boolean propsChanged;
    String savedGeomPos = "";
    boolean insideConstructor;
    byte bsCharacter;
    byte delCharacter;
    boolean haveFocus;
    boolean repaintPending = false;
    boolean cursorHollow = false;
    boolean cursorDrawn = false;
    boolean complexScroll;
    boolean fullRefresh;
    int dirtyTop;
    int dirtyBottom;
    int dirtyLeft;
    int dirtyRight;
    int resizeGravity;
    int rows;
    int cols;
    int vpixels;
    int hpixels;
    int borderWidth = 2;
    int borderHeight = 2;
    int windowTop;
    int windowBottom;
    int windowLeft;
    int windowRight;
    int charWidth;
    int charHeight;
    int charMaxAscent;
    int charMaxDescent;
    int charLeading;
    int baselineIndex;
    int curRow = 0;
    int curCol = 0;
    int lastCursorRow;
    int lastCursorCol;
    int selectRowAnchor;
    int selectColAnchor;
    int selectRowLast;
    int selectColLast;
    boolean hasSelection;
    boolean selectReverse;
    String selectDelims;
    int selectClickRow = -1;
    boolean selectClickState;
    long lastLeftClick = 0L;
    int curAttr = 32768;
    int curRowSave;
    int curColSave;
    int curAttrSave;
    Color origBgColor;
    Color origFgColor;
    Color cursorColor;
    public static final Color[] termColors = new Color[]{Color.black, Color.red.darker(), Color.green.darker(), Color.yellow.darker(), Color.blue.darker(), Color.magenta.darker(), Color.cyan.darker(), Color.white, Color.darkGray, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white};
    public static final String[] termColorNames = new String[]{"black", "red", "green", "yellow", "blue", "magenta", "cyan", "white", "i_black", "i_red", "i_green", "i_ yellow", "i_blue", "i_magenta", "i_cyan", "i_white"};
    char[][] screen;
    int[][] attributes;
    int saveLines;
    int visTop = 0;
    int saveVisTop = 0;
    public static final int ATTR_CHARNOTDRAWN = 0;
    public static final int ATTR_LINEDRAW = 256;
    public static final int ATTR_SELECTED = 4096;
    public static final int ATTR_CHARDRAWN = 32768;
    public static final int MASK_ATTR = 65535;
    public static final int MASK_FGCOL = 0xFF0000;
    public static final int MASK_BGCOL = -16777216;
    public static final int SHIFT_FGCOL = 16;
    public static final int SHIFT_BGCOL = 24;
    public static final char[] spacerow = new char[512];
    public static final int[] zerorow = new int[512];
    boolean[] tabStops = new boolean[512];
    boolean[] termOptions = new boolean[18];
    Image memImage;
    Graphics memGraphics;
    Dimension memImageSize;
    public Font plainFont;
    public Font boldFont;
    boolean waitForMore = false;
    boolean insideUpdate = false;

    public TerminalWin(Frame frame, TerminalInterpreter terminalInterpreter, Properties properties) throws IllegalArgumentException {
        this.ownerFrame = frame;
        this.interpreter = terminalInterpreter;
        terminalInterpreter.setTerminal(this);
        this.insideConstructor = true;
        this.setProperties(properties, true);
        this.insideConstructor = false;
        this.propsChanged = false;
        this.resetTabs();
        frame.addComponentListener(this);
        this.addKeyListener(this);
        this.addComponentListener(this);
        this.addFocusListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public TerminalWin(Frame frame, TerminalInterpreter terminalInterpreter) throws IllegalArgumentException, NoSuchElementException {
        this(frame, terminalInterpreter, TerminalDefProps.defaultProperties);
    }

    public void setMenus(TerminalMenuHandler terminalMenuHandler) {
        this.menuHandler = terminalMenuHandler;
    }

    public TerminalMenuHandler getMenus() {
        return this.menuHandler;
    }

    public void updateMenus() {
        if (this.menuHandler != null) {
            this.menuHandler.update();
        }
    }

    public void setProperties(Properties properties, boolean bl) throws IllegalArgumentException, NoSuchElementException {
        String string;
        String string2;
        String string3;
        Enumeration enumeration;
        Properties properties2 = this.props;
        this.props = new Properties(TerminalDefProps.defaultProperties);
        if (bl && properties2 != null) {
            enumeration = ((Hashtable)properties2).keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = properties2.getProperty(string3);
                ((Hashtable)this.props).put(string3, string2);
            }
        }
        enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = properties.getProperty(string3);
            if (TerminalDefProps.isProperty(string3)) continue;
            throw new NoSuchElementException("unknown terminal-property '" + string3 + "'");
        }
        int n = this.termOptions.length;
        while (n < TerminalDefProps.defaultPropDesc.length) {
            string3 = TerminalDefProps.defaultPropDesc[n][0];
            string2 = properties.getProperty(string3);
            if (string2 == null) {
                string2 = this.props.getProperty(string3);
            }
            if (!bl && properties2 != null) {
                string = properties2.getProperty(string3);
                this.setProperty(string3, string2, !string2.equals(string));
            } else {
                this.setProperty(string3, string2, this.insideConstructor);
            }
            ++n;
        }
        n = 0;
        while (n < this.termOptions.length) {
            string3 = TerminalDefProps.defaultPropDesc[n][0];
            string2 = properties.getProperty(string3);
            if (string2 == null) {
                string2 = this.props.getProperty(string3);
            }
            if (!bl && properties2 != null) {
                string = properties2.getProperty(string3);
                this.setProperty(string3, string2, !string2.equals(string));
            } else {
                this.setProperty(string3, string2, this.insideConstructor);
            }
            ++n;
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public boolean getPropsChanged() {
        return this.propsChanged;
    }

    public void setPropsChanged(boolean bl) {
        this.propsChanged = bl;
    }

    public void setProperty(String string, String string2) throws IllegalArgumentException, NoSuchElementException {
        this.setProperty(string, string2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setProperty(String string, String string2, boolean bl) throws IllegalArgumentException, NoSuchElementException {
        boolean bl2 = false;
        String string3 = this.getProperty(string);
        if (string3 != null && string3.equals(string2)) {
            bl2 = true;
            if (!bl) {
                return;
            }
        }
        int n = 0;
        while (n < this.termOptions.length) {
            if (TerminalDefProps.defaultPropDesc[n][0].equals(string)) break;
            ++n;
        }
        if (n < this.termOptions.length) {
            if (!string2.equals("true") && !string2.equals("false")) {
                throw new IllegalArgumentException("value for '" + string + "' must be 'true' or 'false'");
            }
            this.setOption(n, new Boolean(string2));
        } else if (string.equals("te")) {
            if (this.interpreter instanceof TerminalXTerm) {
                ((TerminalXTerm)this.interpreter).setTerminalType(string2);
            }
        } else if (string.equals("fn")) {
            this.setFont(string2, Integer.parseInt(this.getProperty("fs")));
        } else {
            if (string.equals("fs")) {
                try {
                    this.setFont(this.getProperty("fn"), Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value for '" + string + "' must be an integer");
                }
            }
            if (string.equals("sl")) {
                try {
                    int n2 = Integer.parseInt(string2);
                    if (n2 < 0 || n2 > 8192) {
                        throw new NumberFormatException();
                    }
                    this.setSaveLines(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value for '" + string + "' must be an integer (0-8192)");
                }
            }
            if (string.equals("sb")) {
                if (this.myPanel != null) {
                    if (string2.equals("left") || string2.equals("right")) {
                        if (this.scrollbar != null) {
                            this.myPanel.remove(this.scrollbar);
                            if (string2.equals("right")) {
                                this.myPanel.add((Component)this.scrollbar, "East");
                            } else {
                                this.myPanel.add((Component)this.scrollbar, "West");
                            }
                            this.haveScrollbar = true;
                            this.updateScrollbarValues();
                            this.scrollbar.setWindowSide(string2);
                            this.ownerFrame.pack();
                            this.requestFocus();
                        }
                    } else {
                        if (!string2.equals("none")) throw new IllegalArgumentException("scrollbar can be right, left or none");
                        if (this.scrollbar != null) {
                            this.myPanel.remove(this.scrollbar);
                        }
                        this.ownerFrame.pack();
                        this.requestFocus();
                        this.haveScrollbar = false;
                    }
                }
            } else if (string.equals("bg") || string.equals("fg") || string.equals("cc")) {
                Color color;
                try {
                    color = Character.isDigit(string2.charAt(0)) ? TerminalWin.getTermRGBColor(string2) : TerminalWin.getTermColor(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("valid colors: 'color-name' or '<r>,<g>,<b>'");
                }
                if (string.equals("bg")) {
                    this.origBgColor = color;
                    this.setBackground(this.origBgColor);
                } else if (string.equals("cc")) {
                    this.cursorColor = color;
                } else {
                    this.origFgColor = color;
                    this.setForeground(this.origFgColor);
                }
                this.makeAllDirty(false);
            } else if (string.equals("rg")) {
                int n3;
                if (string2.equals("top")) {
                    n3 = 1;
                } else {
                    if (!string2.equals("bottom")) throw new IllegalArgumentException("reszize gravity can be 'top' or 'bottom'");
                    n3 = 0;
                }
                this.resizeGravity = n3;
            } else if (string.equals("de")) {
                if (string2.equals("DEL")) {
                    this.delCharacter = (byte)127;
                } else {
                    if (!string2.equals("BS")) throw new IllegalArgumentException("delete character can be 'DEL' or 'BS'");
                    this.delCharacter = (byte)8;
                }
            } else if (string.equals("bs")) {
                if (string2.equals("DEL")) {
                    this.bsCharacter = (byte)127;
                } else {
                    if (!string2.equals("BS")) throw new IllegalArgumentException("backspace character can be 'DEL' or 'BS'");
                    this.bsCharacter = (byte)8;
                }
            } else if (string.equals("gm")) {
                this.setGeometry(string2, true);
            } else {
                if (!string.equals("sd")) throw new NoSuchElementException("unknown terminal-property '" + string + "'");
                if (string2.charAt(0) != '\"' || string2.charAt(string2.length() - 1) != '\"') {
                    string2 = "\"" + string2 + "\"";
                }
                this.selectDelims = string2.substring(1, string2.length());
            }
        }
        ((Hashtable)this.props).put(string, string2);
        if (bl2) return;
        this.propsChanged = true;
        this.updateMenus();
    }

    public static Color getTermRGBColor(String string) throws NumberFormatException {
        int n = string.indexOf(44);
        int n2 = string.lastIndexOf(44);
        if (n == -1 || n2 == -1) {
            throw new NumberFormatException();
        }
        int n3 = Integer.parseInt(string.substring(0, n).trim());
        int n4 = Integer.parseInt(string.substring(n + 1, n2).trim());
        int n5 = Integer.parseInt(string.substring(n2 + 1).trim());
        Color color = new Color(n3, n4, n5);
        return color;
    }

    public static Color getTermColor(String string) throws IllegalArgumentException {
        int n = 0;
        while (n < termColors.length) {
            if (termColorNames[n].equalsIgnoreCase(string)) break;
            ++n;
        }
        if (n == termColors.length) {
            throw new IllegalArgumentException("Unknown color: " + string);
        }
        return termColors[n];
    }

    public void setGeometry(String string, boolean bl) throws IllegalArgumentException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = string.indexOf(120);
        int n6 = string.indexOf(43);
        int n7 = string.indexOf(45);
        if (n7 != -1) {
            n6 = n6 > n7 || n6 == -1 ? n7 : n6;
        }
        try {
            if (n5 == -1) {
                throw new Exception();
            }
            n4 = Integer.parseInt(string.substring(0, n5).trim());
            n3 = Integer.parseInt(string.substring(n5 + 1, n6 == -1 ? string.length() : n6).trim());
            n2 = 2 * this.borderWidth + this.charWidth * n4;
            n = 2 * this.borderHeight + this.charHeight * n3;
            if (n6 != -1) {
                n7 = string.indexOf(43, n6 + 1);
                if (n7 == -1 && (n7 = string.indexOf(45, n6 + 1)) == -1) {
                    throw new Exception();
                }
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Insets insets = this.ownerFrame.getInsets();
                int n8 = this.haveScrollbar ? this.scrollbar.getSize().width : 0;
                int n9 = Integer.parseInt(string.substring(n6 + 1, n7).trim());
                int n10 = Integer.parseInt(string.substring(n7 + 1).trim());
                if (string.charAt(n6) == '-') {
                    n9 = dimension.width - n2 - n9 - insets.left - insets.right - n8;
                }
                if (string.charAt(n7) == '-') {
                    n10 = dimension.height - n - n10 - insets.top - insets.bottom;
                }
                this.savedGeomPos = string.substring(n6).trim();
                if (this.isShowing()) {
                    ((Component)this.ownerFrame).setLocation(n9, n10);
                }
            } else {
                this.savedGeomPos = "";
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("geometry must be '<cols>x<rows>[position]', e.g. '80x24+0-0'");
        }
        if (bl) {
            this.setSize(n2, n);
            if (this.isShowing()) {
                this.componentResized(null);
                this.ownerFrame.pack();
                this.requestFocus();
            } else {
                this.pendingShow = true;
                this.setWindowSize(n3, n4);
                this.resetWindow();
                this.clearScreen();
            }
        }
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    private final void setFont(String string, int n) {
        this.plainFont = new Font(string, 0, n);
        this.boldFont = new Font(string, 1, n);
        super.setFont(this.plainFont);
        this.getDimensionOfText(0, 0);
        if (this.isShowing()) {
            this.componentResized(null);
        }
    }

    public void setFont(Font font) {
        this.setFont(font.getName(), font.getSize());
    }

    public void setTitle(String string) {
        this.title = string;
        this.signalWindowChanged(this.rows, this.cols, this.vpixels, this.hpixels);
    }

    public String getTitle() {
        return this.title;
    }

    public void setPopupButton(int n) {
        switch (n) {
            case 1: {
                this.popupButton = 16;
                break;
            }
            case 2: {
                this.popupButton = 8;
                break;
            }
            case 3: {
                this.popupButton = 4;
                break;
            }
        }
    }

    public PopupMenu getPopupMenu(String string) {
        if (this.popupmenu != null) {
            return this.popupmenu;
        }
        this.popupmenu = new PopupMenu(string);
        this.add(this.popupmenu);
        return this.popupmenu;
    }

    void updateScrollbarValues() {
        if (this.haveScrollbar) {
            this.scrollbar.setValues(this.visTop, this.rows, 0, this.saveVisTop + this.rows);
            this.scrollbar.setBlockIncrement(this.rows);
        }
    }

    public Panel getPanelWithScrollbar() {
        if (this.myPanel != null) {
            return this.myPanel;
        }
        this.haveScrollbar = true;
        this.scrollbar = new FixedScrollbar(1);
        this.updateScrollbarValues();
        this.scrollbar.addAdjustmentListener(this);
        this.myPanel = new Panel(new BorderLayout());
        this.myPanel.add((Component)this, "Center");
        String string = this.getProperty("sb");
        if (string.equals("left")) {
            this.myPanel.add((Component)this.scrollbar, "West");
        } else if (string.equals("right")) {
            this.myPanel.add((Component)this.scrollbar, "East");
        } else {
            this.haveScrollbar = false;
        }
        if (this.haveScrollbar) {
            this.scrollbar.setWindowSide(string);
        }
        return this.myPanel;
    }

    private final void setSaveLines(int n) {
        int n2 = this.saveLines;
        boolean bl = false;
        n = n < 0 ? 0 : n;
        int n3 = n = n > 8192 ? 8192 : n;
        if (this.saveLines != n) {
            int n4;
            int n5;
            char[][] cArray = this.screen;
            int[][] nArray = this.attributes;
            this.saveLines = n;
            try {
                this.setWindowSize(this.rows, this.cols);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.saveLines = n2;
                this.setWindowSize(this.rows, this.cols);
                bl = true;
            }
            int n6 = 0;
            if (n2 < this.saveLines) {
                n5 = 0;
                n4 = n2 + this.rows;
            } else if (this.saveVisTop <= this.saveLines) {
                n5 = 0;
                n4 = this.saveVisTop + this.rows;
            } else {
                n5 = this.saveVisTop - this.saveLines;
                n4 = this.saveLines + this.rows;
                this.saveVisTop -= n5;
            }
            System.arraycopy(cArray, n5, this.screen, n6, n4);
            System.arraycopy(nArray, n5, this.attributes, n6, n4);
            this.visTop = this.saveVisTop;
            this.updateScrollbarValues();
            if (bl) {
                bl = false;
                this.write("\n\rOut of memory allocating scrollback buffer, reverting to " + this.saveLines + " lines!");
            }
        }
    }

    public void clearSaveLines() {
        char[][] cArray = this.screen;
        int[][] nArray = this.attributes;
        this.setWindowSize(this.rows, this.cols);
        int n = this.saveVisTop;
        System.arraycopy(cArray, this.saveVisTop, this.screen, 0, this.rows);
        System.arraycopy(nArray, this.saveVisTop, this.attributes, 0, this.rows);
        this.saveVisTop = 0;
        this.visTop = 0;
        this.updateScrollbarValues();
        this.makeAllDirty(true);
    }

    public void setWindowSize(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.screen = new char[n + this.saveLines][n2];
        this.attributes = new int[n + this.saveLines][n2];
    }

    public void setInterpreter(TerminalInterpreter terminalInterpreter) {
        if (terminalInterpreter != null) {
            this.interpreter = terminalInterpreter;
        }
    }

    public String terminalType() {
        return this.interpreter.terminalType();
    }

    public int rows() {
        return this.rows;
    }

    public int cols() {
        return this.cols;
    }

    public int vpixels() {
        return this.vpixels;
    }

    public int hpixels() {
        return this.hpixels;
    }

    protected final void makeAllDirty(boolean bl) {
        this.updateDirtyArea(0, 0, this.rows, this.cols);
        if (bl && this.isShowing()) {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.update(graphics);
            }
        } else {
            this.repaint();
        }
    }

    protected final void updateDirtyArea(int n, int n2, int n3, int n4) {
        if (n < this.dirtyTop) {
            this.dirtyTop = n;
        }
        if (n3 > this.dirtyBottom) {
            this.dirtyBottom = n3;
        }
        if (n2 < this.dirtyLeft) {
            this.dirtyLeft = n2;
        }
        if (n4 > this.dirtyRight) {
            this.dirtyRight = n4;
        }
    }

    public final synchronized void write(char c) {
        int n;
        if (this.visTop != this.saveVisTop && this.termOptions[6]) {
            this.repaintPending = false;
            this.visTop = this.saveVisTop;
            if (this.haveScrollbar) {
                this.scrollbar.setValue(this.visTop);
            }
            this.updateDirtyArea(0, 0, this.rows, this.cols);
        }
        if ((n = this.interpreter.interpretChar(c)) != -1) {
            c = (char)n;
            if (this.curCol == this.cols) {
                if (this.termOptions[1]) {
                    ++this.curRow;
                    this.curCol = 0;
                    if (this.curRow == this.windowBottom) {
                        this.scrollUp(1);
                        this.curRow = this.windowBottom - 1;
                    }
                } else {
                    --this.curCol;
                }
            }
            if (this.termOptions[3]) {
                this.insertChars(1);
            }
            this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.curCol + 1);
            int n2 = this.visTop + this.curRow;
            this.attributes[n2][this.curCol] = this.curAttr;
            this.screen[n2][this.curCol++] = c;
        }
        this.repaint();
    }

    public final synchronized void write(char[] cArray, int n, int n2) {
        this.waitForMore = true;
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.write(cArray[n4]);
            ++n4;
        }
    }

    public final synchronized void write(byte[] byArray, int n, int n2) {
        this.waitForMore = true;
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.write((char)byArray[n4]);
            ++n4;
        }
    }

    public final void write(String string) {
        char[] cArray = string.toCharArray();
        this.write(cArray, 0, cArray.length);
    }

    public void writeLineDrawChar(char c) {
        if (this.curCol == this.cols) {
            if (this.termOptions[1]) {
                ++this.curRow;
                this.curCol = 0;
                if (this.curRow == this.windowBottom) {
                    this.scrollUp(1);
                    this.curRow = this.windowBottom - 1;
                }
            } else {
                --this.curCol;
            }
        }
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.curCol + 1);
        int n = this.visTop + this.curRow;
        this.attributes[n][this.curCol] = this.curAttr | 0x100;
        this.screen[n][this.curCol++] = c;
    }

    public void addTerminalListener(TerminalListener terminalListener) {
        this.listener = terminalListener;
    }

    public void addTerminalClipboard(TerminalClipboard terminalClipboard) {
        this.clipboard = terminalClipboard;
    }

    public final void sendBytes(byte[] byArray) {
        if (this.listener != null) {
            try {
                this.listener.sendBytes(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void doBell() {
        if (this.termOptions[13]) {
            this.setOption(0, !this.termOptions[0]);
            this.setOption(0, !this.termOptions[0]);
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit != null) {
                try {
                    toolkit.beep();
                }
                catch (Exception exception) {
                    this.setOption(13, true);
                    this.doBell();
                }
            }
        }
    }

    public void doBS() {
        this.cursorBackward(1);
    }

    public void doTab() {
        if (this.curCol < this.windowRight) {
            int n = this.curCol + 1;
            while (n < this.windowRight) {
                if (this.tabStops[n]) break;
                ++n;
            }
            this.curCol = n < this.windowRight ? n : this.windowRight - 1;
        }
    }

    public void doTabs(int n) {
        while (n-- > 0) {
            this.doTab();
        }
    }

    public void doBackTabs(int n) {
        if (this.curCol > 0 && n >= 0) {
            int n2 = this.curCol - 1;
            while (n2 >= 0) {
                if (this.tabStops[n2] && --n == 0) break;
                --n2;
            }
            this.curCol = n2 < 0 ? 0 : n2;
        }
    }

    public void setTab(int n) {
        this.tabStops[n] = true;
    }

    public void clearTab(int n) {
        this.tabStops[n] = false;
    }

    public void resetTabs() {
        int n = 0;
        while (n < 512) {
            this.tabStops[n] = n % 8 == 0;
            ++n;
        }
    }

    public void clearAllTabs() {
        int n = 0;
        while (n < 512) {
            this.tabStops[n] = false;
            ++n;
        }
    }

    public void doCR() {
        this.curCol = this.windowLeft;
    }

    public void doLF() {
        ++this.curRow;
        if (this.curRow == this.windowBottom) {
            this.scrollUp(1);
            this.curRow = this.windowBottom - 1;
        }
        if (this.termOptions[11] && this.termOptions[4]) {
            this.doCR();
        }
    }

    public void resetInterpreter() {
        this.interpreter.vtReset();
        this.makeAllDirty(true);
    }

    public void resetWindow() {
        this.windowTop = 0;
        this.windowBottom = this.rows;
        this.windowLeft = 0;
        this.windowRight = this.cols;
        this.complexScroll = false;
    }

    public void setWindow(int n, int n2) {
        this.setWindow(n, 0, n2, this.cols);
    }

    public void setWindow(int n, int n2, int n3, int n4) {
        this.windowTop = n;
        this.windowLeft = n2;
        this.windowBottom = n3;
        this.windowRight = n4;
        if (this.hasSelection) {
            int n5 = this.selectRowAnchor - this.visTop;
            int n6 = this.selectRowLast - this.visTop;
            if (n != 0 && (n5 >= 0 || n6 >= 0)) {
                if (!(n5 < n && n6 < n || n5 >= n3 && n6 >= n3)) {
                    this.clearSelection();
                }
            } else if (n5 >= n3 || n6 >= n3) {
                this.clearSelection();
            }
        }
        this.complexScroll = this.windowLeft != 0 || this.windowRight != this.cols;
    }

    public int getWindowTop() {
        return this.windowTop;
    }

    public int getWindowBottom() {
        return this.windowBottom;
    }

    public int getWindowLeft() {
        return this.windowLeft;
    }

    public int getWindowRight() {
        return this.windowRight;
    }

    public int getCursorV() {
        return this.curRow;
    }

    public int getCursorH() {
        return this.curCol;
    }

    public void cursorSetPos(int n, int n2, boolean bl) {
        int n3 = this.rows - 1;
        int n4 = this.cols - 1;
        int n5 = 0;
        int n6 = 0;
        if (bl) {
            n += this.windowTop;
            n3 = this.windowBottom - 1;
            n5 = this.windowTop;
            n2 += this.windowLeft;
            n4 = this.windowRight - 1;
            n6 = this.windowLeft;
        }
        if (n < n5) {
            n = n5;
        }
        if (n2 < n6) {
            n2 = n6;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        this.curRow = n;
        this.curCol = n2;
    }

    public void cursorUp(int n) {
        int n2 = this.curRow < this.windowTop ? 0 : this.windowTop;
        this.curRow -= n;
        if (this.curRow < n2) {
            this.curRow = n2;
        }
    }

    public void cursorDown(int n) {
        int n2 = this.curRow > this.windowBottom - 1 ? this.rows - 1 : this.windowBottom - 1;
        this.curRow += n;
        if (this.curRow > n2) {
            this.curRow = n2;
        }
    }

    public void cursorForward(int n) {
        this.curCol += n;
        if (this.curCol > this.windowRight) {
            this.curCol = this.windowRight;
        }
    }

    public void cursorBackward(int n) {
        this.curCol -= n;
        if (this.curCol < this.windowLeft) {
            if (this.termOptions[2]) {
                this.curCol = this.windowRight - (this.windowLeft - this.curCol);
                this.cursorUp(1);
            } else {
                this.curCol = this.windowLeft;
            }
        }
    }

    public void cursorIndex(int n) {
        if (this.curRow > this.windowBottom || this.curRow + n < this.windowBottom) {
            this.cursorDown(n);
        } else {
            int n2 = this.windowBottom - this.curRow;
            this.cursorDown(n2);
            this.scrollUp(n - n2 + 1);
        }
    }

    public void cursorIndexRev(int n) {
        if (this.curRow < this.windowTop || this.curRow - n >= this.windowTop) {
            this.cursorUp(n);
        } else {
            int n2 = this.curRow - this.windowTop;
            this.scrollDown(n - n2);
            this.cursorUp(n2);
        }
    }

    public void cursorSave() {
        this.curRowSave = this.curRow;
        this.curColSave = this.curCol;
        this.curAttrSave = this.curAttr;
    }

    public void cursorRestore() {
        this.curRow = this.curRowSave;
        this.curCol = this.curColSave;
        this.curAttr = this.curAttrSave;
    }

    public void scrollUp(int n) {
        int n2 = this.windowBottom - this.windowTop;
        int n3 = this.windowTop;
        if (this.complexScroll) {
            int n4;
            if (n < n2) {
                n3 = n2 - n + this.windowTop;
                n4 = this.windowTop;
                while (n4 < n3) {
                    System.arraycopy(this.screen[this.visTop + n4 + n], this.windowLeft, this.screen[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.visTop + n4 + n], this.windowLeft, this.attributes[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                    ++n4;
                }
            }
            n4 = n3;
            while (n4 < this.windowBottom) {
                System.arraycopy(spacerow, 0, this.screen[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                ++n4;
            }
        } else if (this.windowTop == 0 && this.windowBottom == this.rows && this.saveLines > 0) {
            int n5;
            int n6 = n5 = n < n2 ? n : n2;
            if (this.visTop + n5 > this.saveLines) {
                if (this.hasSelection) {
                    if (this.selectRowAnchor - n >= 0 && this.selectRowLast - n >= 0) {
                        this.selectRowAnchor -= n;
                        this.selectRowLast -= n;
                    } else {
                        this.clearSelection();
                    }
                }
                int n7 = n2 - n5;
                System.arraycopy(this.screen, n5, this.screen, 0, this.saveLines + n7);
                System.arraycopy(this.attributes, n5, this.attributes, 0, this.saveLines + n7);
                int n8 = n2 - n5;
                while (n8 < n2) {
                    this.screen[this.saveLines + n8] = new char[this.cols];
                    this.attributes[this.saveLines + n8] = new int[this.cols];
                    ++n8;
                }
            } else {
                this.visTop += n5;
                this.saveVisTop = this.visTop;
                this.updateScrollbarValues();
            }
        } else {
            if (n < n2) {
                n3 = n2 - n + this.windowTop;
                System.arraycopy(this.screen, this.visTop + this.windowTop + n, this.screen, this.visTop + this.windowTop, n2 - n);
                System.arraycopy(this.attributes, this.visTop + this.windowTop + n, this.attributes, this.visTop + this.windowTop, n2 - n);
            }
            int n9 = n3;
            while (n9 < this.windowBottom) {
                this.screen[this.visTop + n9] = new char[this.cols];
                this.attributes[this.visTop + n9] = new int[this.cols];
                ++n9;
            }
        }
        this.updateDirtyArea(this.windowTop, this.windowLeft, this.windowBottom, this.windowRight);
    }

    public void scrollDown(int n) {
        int n2 = this.windowBottom - this.windowTop;
        int n3 = this.windowBottom;
        if (this.complexScroll) {
            int n4;
            if (n < n2) {
                n3 = this.windowTop + n;
                n4 = this.windowBottom - 1;
                while (n4 >= n3) {
                    System.arraycopy(this.screen[this.visTop + n4 - n], this.windowLeft, this.screen[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.visTop + n4 - n], this.windowLeft, this.attributes[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                    --n4;
                }
            }
            n4 = this.windowTop;
            while (n4 < n3) {
                System.arraycopy(spacerow, 0, this.screen[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.visTop + n4], this.windowLeft, this.windowRight - this.windowLeft);
                ++n4;
            }
        } else {
            if (n < n2) {
                n3 = this.windowTop + n;
                System.arraycopy(this.screen, this.visTop + this.windowTop, this.screen, this.visTop + this.windowTop + n, n2 - n);
                System.arraycopy(this.attributes, this.visTop + this.windowTop, this.attributes, this.visTop + this.windowTop + n, n2 - n);
            }
            int n5 = this.windowTop;
            while (n5 < n3) {
                this.screen[this.visTop + n5] = new char[this.cols];
                this.attributes[this.visTop + n5] = new int[this.cols];
                ++n5;
            }
        }
        this.updateDirtyArea(this.windowTop, 0, this.windowBottom, this.cols);
    }

    public void clearBelow() {
        this.clearRight();
        int[] nArray = new int[this.cols];
        int n = 0;
        while (n < this.cols) {
            nArray[n] = this.curAttr & 0xFFFF00C0;
            ++n;
        }
        n = this.curRow + 1;
        while (n < this.windowBottom) {
            this.screen[this.visTop + n] = new char[this.cols];
            this.attributes[this.visTop + n] = new int[this.cols];
            System.arraycopy(nArray, 0, this.attributes[this.visTop + n], 0, this.cols);
            ++n;
        }
        this.updateDirtyArea(this.curRow, 0, this.windowBottom, this.cols);
    }

    public void clearAbove() {
        this.clearLeft();
        int[] nArray = new int[this.cols];
        int n = 0;
        while (n < this.cols) {
            nArray[n] = this.curAttr & 0xFFFF00C0;
            ++n;
        }
        n = this.windowTop;
        while (n < this.curRow) {
            this.screen[this.visTop + n] = new char[this.cols];
            this.attributes[this.visTop + n] = new int[this.cols];
            System.arraycopy(nArray, 0, this.attributes[this.visTop + n], 0, this.cols);
            ++n;
        }
        this.updateDirtyArea(this.windowTop, 0, this.curRow, this.cols);
    }

    public void clearScreen() {
        int[] nArray = new int[this.cols];
        int n = 0;
        while (n < this.cols) {
            nArray[n] = this.curAttr & 0xFFFF00C0;
            ++n;
        }
        n = this.windowTop;
        while (n < this.windowBottom) {
            this.screen[this.saveVisTop + n] = new char[this.cols];
            this.attributes[this.saveVisTop + n] = new int[this.cols];
            System.arraycopy(nArray, 0, this.attributes[this.saveVisTop + n], 0, this.cols);
            ++n;
        }
        this.dirtyTop = 0;
        this.dirtyBottom = this.rows;
        this.dirtyLeft = 0;
        this.dirtyRight = this.cols;
        this.repaint();
    }

    public void clearRight() {
        System.arraycopy(spacerow, 0, this.screen[this.visTop + this.curRow], this.curCol, this.cols - this.curCol);
        int n = this.curCol;
        while (n < this.cols) {
            this.attributes[this.visTop + this.curRow][n] = this.curAttr & 0xFFFF00C0;
            ++n;
        }
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.cols);
    }

    public void clearLeft() {
        System.arraycopy(spacerow, 0, this.screen[this.visTop + this.curRow], 0, this.curCol);
        int n = 0;
        while (n < this.curCol) {
            this.attributes[this.visTop + this.curRow][n] = this.curAttr & 0xFFFF00C0;
            ++n;
        }
        this.dirtyLeft = 0;
        this.updateDirtyArea(this.curRow, 0, this.curRow + 1, this.curCol);
    }

    public void clearLine() {
        this.screen[this.visTop + this.curRow] = new char[this.cols];
        this.attributes[this.visTop + this.curRow] = new int[this.cols];
        int n = 0;
        while (n < this.cols) {
            this.attributes[this.visTop + this.curRow][n] = this.curAttr & 0xFFFF00C0;
            ++n;
        }
        this.dirtyLeft = 0;
        this.dirtyRight = this.cols;
        this.updateDirtyArea(this.curRow, 0, this.curRow + 1, this.cols);
    }

    public void eraseChars(int n) {
        if (n > this.cols - this.curCol) {
            n = this.cols - this.curCol;
        }
        System.arraycopy(spacerow, 0, this.screen[this.visTop + this.curRow], this.curCol, n);
        int n2 = 0;
        while (n2 < n) {
            this.attributes[this.visTop + this.curRow][this.curCol + n2] = this.curAttr & 0xFFFF00C0;
            ++n2;
        }
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow, this.curCol + n);
    }

    public void insertChars(int n) {
        int n2 = this.windowRight;
        if (this.curCol < this.windowLeft || this.curCol > this.windowRight) {
            return;
        }
        if (this.curCol + n < this.windowRight) {
            n2 = this.curCol + n;
            System.arraycopy(this.screen[this.visTop + this.curRow], this.curCol, this.screen[this.visTop + this.curRow], n2, this.windowRight - n2);
            System.arraycopy(this.attributes[this.visTop + this.curRow], this.curCol, this.attributes[this.visTop + this.curRow], n2, this.windowRight - n2);
        }
        System.arraycopy(spacerow, 0, this.screen[this.visTop + this.curRow], this.curCol, n2 - this.curCol);
        int n3 = this.curCol;
        while (n3 < n2) {
            this.attributes[this.visTop + this.curRow][n3] = this.curAttr & 0xFFFF00C0;
            ++n3;
        }
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.windowRight);
    }

    public void deleteChars(int n) {
        int n2 = this.curCol;
        if (this.curCol < this.windowLeft || this.curCol > this.windowRight) {
            return;
        }
        if (this.curCol + n < this.windowRight) {
            n2 = this.windowRight - n;
            System.arraycopy(this.screen[this.visTop + this.curRow], this.curCol + n, this.screen[this.visTop + this.curRow], this.curCol, n2 - this.curCol);
            System.arraycopy(this.attributes[this.visTop + this.curRow], this.curCol + n, this.attributes[this.visTop + this.curRow], this.curCol, n2 - this.curCol);
        }
        System.arraycopy(spacerow, 0, this.screen[this.visTop + this.curRow], n2, this.windowRight - n2);
        int n3 = n2;
        while (n3 < this.windowRight) {
            this.attributes[this.visTop + this.curRow][n3] = this.curAttr & 0xFFFF00C0;
            ++n3;
        }
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.windowRight);
    }

    public void insertLines(int n) {
        int n2 = this.windowBottom;
        if (this.curRow < this.windowTop || this.curRow > this.windowBottom) {
            return;
        }
        if (this.complexScroll) {
            int n3;
            if (this.curRow + n < this.windowBottom) {
                n2 = this.curRow + n;
                n3 = this.windowBottom - 1;
                while (n3 >= n2) {
                    System.arraycopy(this.screen[this.visTop + n3 - n], this.windowLeft, this.screen[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.visTop + n3 - n], this.windowLeft, this.attributes[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                    --n3;
                }
            }
            n3 = this.curRow;
            while (n3 < n2) {
                System.arraycopy(spacerow, 0, this.screen[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                ++n3;
            }
        } else {
            if (this.curRow + n < this.windowBottom) {
                n2 = this.curRow + n;
                System.arraycopy(this.screen, this.visTop + this.curRow, this.screen, this.visTop + n2, this.windowBottom - n2);
                System.arraycopy(this.attributes, this.visTop + this.curRow, this.attributes, this.visTop + n2, this.windowBottom - n2);
            }
            int[] nArray = new int[this.cols];
            int n4 = 0;
            while (n4 < this.cols) {
                nArray[n4] = this.curAttr & 0xFFFF00C0;
                ++n4;
            }
            n4 = this.curRow;
            while (n4 < n2) {
                this.screen[this.visTop + n4] = new char[this.cols];
                this.attributes[this.visTop + n4] = new int[this.cols];
                System.arraycopy(nArray, 0, this.attributes[this.visTop + n4], 0, this.cols);
                ++n4;
            }
        }
        this.updateDirtyArea(this.curRow, 0, this.windowBottom, this.cols);
    }

    public void deleteLines(int n) {
        int n2 = this.curRow;
        if (this.curRow < this.windowTop || this.curRow > this.windowBottom) {
            return;
        }
        if (this.complexScroll) {
            int n3;
            if (this.curRow + n < this.windowBottom) {
                n2 = this.windowBottom - n - 1;
                n3 = this.curRow;
                while (n3 <= n2) {
                    System.arraycopy(this.screen[this.visTop + n3 + n], this.windowLeft, this.screen[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.visTop + n3 + n], this.windowLeft, this.attributes[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                    ++n3;
                }
            }
            n3 = n2;
            while (n3 < this.windowBottom) {
                System.arraycopy(spacerow, 0, this.screen[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.visTop + n3], this.windowLeft, this.windowRight - this.windowLeft);
                ++n3;
            }
        } else {
            if (this.curRow + n < this.windowBottom) {
                n2 = this.windowBottom - n;
                System.arraycopy(this.screen, this.visTop + this.curRow + n, this.screen, this.visTop + this.curRow, n2 - this.curRow);
                System.arraycopy(this.attributes, this.visTop + this.curRow + n, this.attributes, this.visTop + this.curRow, n2 - this.curRow);
            }
            int[] nArray = new int[this.cols];
            int n4 = 0;
            while (n4 < this.cols) {
                nArray[n4] = this.curAttr & 0xFFFF00C0;
                ++n4;
            }
            n4 = n2;
            while (n4 < this.windowBottom) {
                this.screen[this.visTop + n4] = new char[this.cols];
                this.attributes[this.visTop + n4] = new int[this.cols];
                System.arraycopy(nArray, 0, this.attributes[this.visTop + n4], 0, this.cols);
                ++n4;
            }
        }
        this.updateDirtyArea(this.curRow, 0, this.windowBottom, this.cols);
    }

    public void setOption(int n, boolean bl) {
        if (n > this.termOptions.length || n < 0) {
            return;
        }
        ((Hashtable)this.props).put(TerminalDefProps.defaultPropDesc[n][0], String.valueOf(bl));
        switch (n) {
            case 0: {
                if (bl == this.termOptions[n]) break;
                this.termOptions[n] = bl;
                Color color = this.origBgColor;
                this.origBgColor = this.origFgColor;
                this.origFgColor = color;
                this.makeAllDirty(true);
                break;
            }
            case 9: {
                this.repaint();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 15: {
                if (this.termOptions[n] == bl || !this.termOptions[16]) break;
                this.setProperty("gm", (bl ? 132 : 80) + "x" + this.rows + this.savedGeomPos);
                this.cursorSetPos(0, 0, false);
                break;
            }
            case 16: {
                if (this.menuHandler == null) break;
                this.menuHandler.setEnabledOpt(15, bl);
            }
        }
        this.termOptions[n] = bl;
        if (this.menuHandler != null) {
            this.menuHandler.setStateOpt(n, bl);
        }
    }

    public boolean getOption(int n) {
        if (n > this.termOptions.length || n < 0) {
            return false;
        }
        return this.termOptions[n];
    }

    public void setAttribute(int n, boolean bl) {
        this.curAttr = bl ? (this.curAttr |= n) : (this.curAttr &= ~n);
    }

    public boolean getAttribute(int n) {
        return (this.curAttr & n) == n;
    }

    public void setForegroundColor(int n) {
        if (n >= 0 && n < 8) {
            if ((this.curAttr & 1) != 0) {
                n += 8;
            }
            this.curAttr &= 0xFF00FFBF;
            this.curAttr |= 0x40 | n << 16;
        } else {
            this.curAttr &= 0xFFFFFFBF;
        }
    }

    public void setBackgroundColor(int n) {
        if (n >= 0 && n < 8) {
            this.curAttr &= 0xFFFF7F;
            this.curAttr |= 0x80 | n << 24;
        } else {
            this.curAttr &= 0xFFFFFF7F;
        }
    }

    public void clearAllAttributes() {
        this.curAttr = 32768;
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
        if (this.listener != null) {
            this.listener.signalWindowChanged(n, n2, n3, n4);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '~': {
                if (this.tildePressedKludge) break;
                this.tildeTypedKludge = true;
                c = '~';
                if (this.termOptions[11]) {
                    this.write(c);
                }
                if (this.listener != null) {
                    try {
                        this.listener.typedChar(c);
                    }
                    catch (IOException iOException) {}
                    break;
                }
                this.typedChar(c);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        int n3 = keyEvent.getKeyChar();
        boolean bl = false;
        if (this.specialKeyHandler(n3, n, n2)) {
            return;
        }
        this.interpreter.keyHandler(n, n2);
        if (n3 != 65535 && n3 != 0) {
            int n4 = this.keyKludgeFilter((char)n3, n, n2);
            if (n4 == -1) {
                return;
            }
            n3 = (char)n4;
            if (this.termOptions[11]) {
                this.write((char)n3);
            }
            if (this.listener != null) {
                try {
                    if ((n3 == 10 || n3 == 13) && this.termOptions[4]) {
                        n3 = 10;
                        this.listener.typedChar('\r');
                    }
                    this.listener.typedChar((char)n3);
                }
                catch (IOException iOException) {}
            } else {
                this.typedChar((char)n3);
            }
            if (this.visTop != this.saveVisTop && this.termOptions[5]) {
                this.visTop = this.saveVisTop;
                if (this.haveScrollbar) {
                    this.scrollbar.setValue(this.visTop);
                }
                this.makeAllDirty(false);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 18: {
                this.metaKeyKludge = false;
                break;
            }
            case 17: {
                this.ctrlKeyKludge = false;
            }
        }
    }

    final boolean specialKeyHandler(int n, int n2, int n3) {
        boolean bl = false;
        switch (n2) {
            case 18: {
                if (this.ctrlKeyKludge) {
                    this.ctrlKeyKludge = false;
                } else {
                    this.metaKeyKludge = true;
                }
                bl = true;
                break;
            }
            case 17: {
                this.ctrlKeyKludge = true;
                bl = true;
                break;
            }
            case 8: {
                byte[] byArray = new byte[]{this.bsCharacter};
                this.sendBytes(byArray);
                bl = true;
                break;
            }
            case 127: {
                byte[] byArray = new byte[]{this.delCharacter};
                this.sendBytes(byArray);
                bl = true;
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                if (n3 != 1 && !this.termOptions[7]) break;
                this.localPageCtrlKeys(n2);
                bl = true;
                break;
            }
            case 155: {
                if (n3 == 1) {
                    this.doPaste();
                    bl = true;
                    break;
                }
                if (n3 != 2) break;
                this.doCopy();
                bl = true;
                break;
            }
            case 16: 
            case 20: {
                bl = true;
            }
        }
        return bl;
    }

    final int keyKludgeFilter(char n, int n2, int n3) {
        int n4;
        block25: {
            block24: {
                n4 = n;
                if ((n3 & 2) == 0) break block24;
                switch (n2) {
                    case 77: {
                        n4 = 13;
                        break;
                    }
                    case 32: {
                        if (this.termOptions[14]) {
                            n4 = 0;
                            break;
                        }
                        break block25;
                    }
                    default: {
                        if (n2 >= 65 && n2 <= 90) {
                            n4 = this.ctrlAlphaKey(n2);
                            break;
                        }
                        if (n == 64) {
                            n4 = 0;
                            break;
                        }
                        if (n == 91) {
                            n4 = 27;
                            break;
                        }
                        if (n == 92) {
                            n4 = 28;
                            break;
                        }
                        if (n == 93) {
                            n4 = 29;
                            break;
                        }
                        if (n == 94) {
                            n4 = 30;
                            break;
                        }
                        if (n == 95) {
                            n4 = 31;
                            break;
                        }
                        break block25;
                    }
                }
                break block25;
            }
            if (n4 == 10 && n2 == 10 && !this.ctrlKeyKludge) {
                n4 = 13;
            } else if (n == 126) {
                if (!this.tildeTypedKludge) {
                    this.tildePressedKludge = true;
                } else {
                    n4 = -1;
                }
            } else if (n == 65535) {
                n4 = -1;
            } else if (n == 65406) {
                n4 = -1;
            }
            if (n4 != -1 && this.metaKeyKludge && this.listener != null) {
                try {
                    this.listener.typedChar('\u001b');
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return n4;
    }

    final int ctrlAlphaKey(int n) {
        int n2 = 0;
        switch (n) {
            case 65: {
                n2 = 1;
                break;
            }
            case 66: {
                n2 = 2;
                break;
            }
            case 67: {
                n2 = 3;
                break;
            }
            case 68: {
                n2 = 4;
                break;
            }
            case 69: {
                n2 = 5;
                break;
            }
            case 70: {
                n2 = 6;
                break;
            }
            case 71: {
                n2 = 7;
                break;
            }
            case 72: {
                n2 = 8;
                break;
            }
            case 73: {
                n2 = 9;
                break;
            }
            case 74: {
                n2 = 10;
                break;
            }
            case 75: {
                n2 = 11;
                break;
            }
            case 76: {
                n2 = 12;
                break;
            }
            case 77: {
                n2 = 13;
                break;
            }
            case 78: {
                n2 = 14;
                break;
            }
            case 79: {
                n2 = 15;
                break;
            }
            case 80: {
                n2 = 16;
                break;
            }
            case 81: {
                n2 = 17;
                break;
            }
            case 82: {
                n2 = 18;
                break;
            }
            case 83: {
                n2 = 19;
                break;
            }
            case 84: {
                n2 = 20;
                break;
            }
            case 85: {
                n2 = 21;
                break;
            }
            case 86: {
                n2 = 22;
                break;
            }
            case 87: {
                n2 = 23;
                break;
            }
            case 88: {
                n2 = 24;
                break;
            }
            case 89: {
                n2 = 25;
                break;
            }
            case 90: {
                n2 = 26;
            }
        }
        return n2;
    }

    public void typedChar(char c) {
    }

    public final void localPageCtrlKeys(int n) {
        switch (n) {
            case 33: {
                this.visTop -= this.rows;
                if (this.visTop < 0) {
                    this.visTop = 0;
                }
                this.updateScrollbarValues();
                this.makeAllDirty(true);
                break;
            }
            case 34: {
                this.visTop += this.rows;
                if (this.visTop > this.saveVisTop) {
                    this.visTop = this.saveVisTop;
                }
                this.updateScrollbarValues();
                this.makeAllDirty(true);
                break;
            }
            case 36: {
                this.visTop = 0;
                this.updateScrollbarValues();
                this.makeAllDirty(true);
                break;
            }
            case 35: {
                this.visTop = this.saveVisTop;
                this.updateScrollbarValues();
                this.makeAllDirty(true);
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.haveFocus = true;
        this.updateFocusCursor();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.metaKeyKludge = false;
        this.ctrlKeyKludge = false;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.haveFocus = false;
        this.updateFocusCursor();
    }

    final synchronized void updateFocusCursor() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.hideCursor(graphics);
            this.showCursor(graphics);
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void emulateComponentShown() {
        this.componentShown(new ComponentEvent(this.ownerFrame, 0));
    }

    public synchronized void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() == this.ownerFrame && this.pendingShow && this.pendingShow) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pendingShow = false;
            this.setGeometry(this.getProperty("gm"), true);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public synchronized void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getSize();
        int n = (dimension.width - 2 * this.borderWidth) / this.charWidth;
        int n2 = (dimension.height - 2 * this.borderHeight) / this.charHeight;
        int n3 = this.cols;
        int n4 = this.rows;
        char[][] cArray = this.screen;
        int[][] nArray = this.attributes;
        if (this.pendingShow || componentEvent != null && componentEvent.getComponent() != this || n <= 0 || n2 <= 0) {
            return;
        }
        this.vpixels = dimension.height;
        this.hpixels = dimension.width;
        if (n != n3) {
            this.clearSelection();
        }
        if (n2 != this.rows || n != this.cols) {
            int n5;
            this.setWindowSize(n2, n);
            this.resetWindow();
            this.clearScreen();
            int n6 = n3 = n3 < n ? n3 : n;
            if (this.resizeGravity == 1) {
                n5 = (n4 < n2 ? n4 : n2) + this.saveVisTop;
                int n7 = 0;
                while (n7 < n5) {
                    System.arraycopy(cArray[n7], 0, this.screen[n7], 0, n3);
                    System.arraycopy(nArray[n7], 0, this.attributes[n7], 0, n3);
                    ++n7;
                }
            } else {
                int n8;
                int n9;
                int n10;
                int n11;
                if (this.hasSelection) {
                    this.selectRowAnchor += n2 - n4;
                    this.selectRowLast += n2 - n4;
                }
                if (n4 < n2) {
                    n11 = n2 - n4;
                    n10 = n4 + this.saveVisTop;
                    n9 = 0;
                    this.curRow += n11;
                    if (this.saveVisTop - n11 < 0) {
                        n8 = n11;
                    } else {
                        n8 = 0;
                        this.visTop -= n11;
                        this.saveVisTop -= n11;
                    }
                } else {
                    n11 = n4 - n2;
                    n8 = 0;
                    this.curRow -= n11;
                    if (this.curRow < 0) {
                        this.curRow = 0;
                    }
                    if (this.saveVisTop + n11 > this.saveLines) {
                        n10 = n2 + this.saveVisTop;
                        n9 = n11;
                    } else {
                        n10 = n4 + this.saveVisTop;
                        n9 = 0;
                        this.visTop += n11;
                        this.saveVisTop += n11;
                    }
                }
                n5 = 0;
                while (n5 < n10) {
                    System.arraycopy(cArray[n5 + n9], 0, this.screen[n5 + n8], 0, n3);
                    System.arraycopy(nArray[n5 + n9], 0, this.attributes[n5 + n8], 0, n3);
                    ++n5;
                }
            }
            if (this.curRow >= n2) {
                this.curRow = n2 - 1;
            }
            if (this.curCol >= n) {
                this.curCol = n - 1;
            }
            if (this.lastCursorRow >= n2 || this.lastCursorCol >= n) {
                this.cursorDrawn = false;
                this.cursorHollow = false;
            }
            this.updateScrollbarValues();
            this.signalWindowChanged(this.rows, this.cols, this.vpixels, this.hpixels);
            this.memGraphics = null;
            String string = this.cols + "x" + this.rows + this.savedGeomPos;
            this.propsChanged = true;
            ((Hashtable)this.props).put("gm", string);
            this.updateMenus();
            this.makeAllDirty(false);
            this.requestFocus();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        if (n >= 0 && n <= this.saveVisTop) {
            this.visTop = n;
            this.makeAllDirty(false);
        }
    }

    public void selectAll() {
        this.selectRowAnchor = 0;
        this.selectColAnchor = 0;
        this.selectRowLast = this.saveVisTop + this.curRow;
        this.selectColLast = this.curCol;
        this.makeSelection(this.selectRowAnchor, this.selectColAnchor, this.selectRowLast, this.selectColLast);
        this.hasSelection = true;
        if (this.clipboard != null) {
            this.clipboard.selectionAvailable(true);
            if (this.termOptions[17]) {
                this.doCopy();
            }
        }
    }

    public void makeSelection(int n, int n2, int n3, int n4) {
        if (n != n3) {
            int n5 = n2;
            while (n5 < this.cols) {
                int[] nArray = this.attributes[n];
                int n6 = n5++;
                nArray[n6] = nArray[n6] | 0x1000;
            }
            n5 = n + 1;
            while (n5 < n3) {
                int n7 = 0;
                while (n7 < this.cols) {
                    int[] nArray = this.attributes[n5];
                    int n8 = n7++;
                    nArray[n8] = nArray[n8] | 0x1000;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 <= n4) {
                int[] nArray = this.attributes[n3];
                int n9 = n5++;
                nArray[n9] = nArray[n9] | 0x1000;
            }
        } else {
            int n10 = n2;
            while (n10 <= n4) {
                int[] nArray = this.attributes[n];
                int n11 = n10++;
                nArray[n11] = nArray[n11] | 0x1000;
            }
        }
        n3 -= this.visTop;
        if ((n -= this.visTop) < 0) {
            n = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.updateDirtyArea(n, 0, n3 + 1, this.cols);
        this.repaint();
    }

    public void clearSelection(int n, int n2, int n3, int n4) {
        if (n != n3) {
            int n5 = n2;
            while (n5 < this.cols) {
                int[] nArray = this.attributes[n];
                int n6 = n5++;
                nArray[n6] = nArray[n6] & 0xFFFFEFFF;
            }
            n5 = n + 1;
            while (n5 < n3) {
                int n7 = 0;
                while (n7 < this.cols) {
                    int[] nArray = this.attributes[n5];
                    int n8 = n7++;
                    nArray[n8] = nArray[n8] & 0xFFFFEFFF;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 <= n4) {
                int[] nArray = this.attributes[n3];
                int n9 = n5++;
                nArray[n9] = nArray[n9] & 0xFFFFEFFF;
            }
        } else {
            int n10 = n2;
            while (n10 <= n4) {
                int[] nArray = this.attributes[n];
                int n11 = n10++;
                nArray[n11] = nArray[n11] & 0xFFFFEFFF;
            }
        }
        n3 -= this.visTop;
        if ((n -= this.visTop) < 0) {
            n = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.updateDirtyArea(n, 0, n3 + 1, this.cols);
        this.repaint();
    }

    public void clearSelection() {
        if (!this.hasSelection) {
            return;
        }
        if (this.selectReverse) {
            this.clearSelection(this.selectRowLast, this.selectColLast, this.selectRowAnchor, this.selectColAnchor);
        } else {
            this.clearSelection(this.selectRowAnchor, this.selectColAnchor, this.selectRowLast, this.selectColLast);
        }
        this.hasSelection = false;
        if (this.clipboard != null) {
            this.clipboard.selectionAvailable(false);
        }
    }

    final int mouseRow(int n) {
        int n2 = (n - this.borderHeight) / this.charHeight;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.rows) {
            n2 = this.rows - 1;
        }
        return n2;
    }

    final int mouseCol(int n) {
        int n2 = (n - this.borderWidth) / this.charWidth;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.cols) {
            n2 = this.cols - 1;
        }
        return n2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            this.requestFocus();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        long l = System.currentTimeMillis();
        int n = this.mouseRow(mouseEvent.getY());
        int n2 = this.mouseCol(mouseEvent.getX());
        if (mouseEvent.getModifiers() == (this.popupButton | 2) && this.popupmenu != null) {
            this.ctrlKeyKludge = false;
            this.popupmenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
        this.interpreter.mouseHandler(n, n2, true, mouseEvent.getModifiers());
        this.clearSelection();
        this.selectRowAnchor = n += this.visTop;
        this.selectColAnchor = n2;
        this.selectRowLast = n;
        this.selectColLast = n2;
        if (l - this.lastLeftClick < 250L) {
            this.doClickSelect(n, n2);
        } else {
            this.selectClickRow = -1;
            this.selectClickState = false;
        }
        this.lastLeftClick = l;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.mouseRow(mouseEvent.getY());
        int n2 = this.mouseCol(mouseEvent.getX());
        if (this.listener != null) {
            if (mouseEvent.getModifiers() == 16) {
                if (this.hasSelection) {
                    this.clipboard.selectionAvailable(true);
                    if (this.termOptions[17]) {
                        this.doCopy();
                    }
                }
            } else if (mouseEvent.getModifiers() == 8) {
                this.doPaste();
            }
        }
        this.interpreter.mouseHandler(n, n2, false, mouseEvent.getModifiers());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        int n = (mouseEvent.getY() - this.borderHeight) / this.charHeight;
        int n2 = (mouseEvent.getX() - this.borderWidth) / this.charWidth;
        if (n < 0) {
            n = 0;
        } else if (n >= this.rows) {
            n = this.rows - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.cols) {
            n2 = this.cols - 1;
        }
        if ((n += this.visTop) == this.selectRowLast && n2 == this.selectColLast) {
            return;
        }
        boolean bl = this.selectRowAnchor > n || this.selectRowAnchor == n && n2 < this.selectColAnchor;
        if (bl != this.selectReverse) {
            if (this.selectReverse) {
                this.clearSelection(this.selectRowLast, this.selectColLast, this.selectRowAnchor, this.selectColAnchor);
            } else {
                this.clearSelection(this.selectRowAnchor, this.selectColAnchor, this.selectRowLast, this.selectColLast);
            }
            this.selectReverse = bl;
            this.selectRowLast = this.selectRowAnchor;
            this.selectColLast = this.selectColAnchor;
        }
        boolean bl2 = this.selectRowLast > n || this.selectRowLast == n && n2 < this.selectColLast;
        if (this.selectReverse) {
            if (bl2) {
                this.makeSelection(n, n2, this.selectRowLast, this.selectColLast);
            } else {
                this.clearSelection(this.selectRowLast, this.selectColLast, n, n2);
            }
        } else if (bl2) {
            this.clearSelection(n, n2, this.selectRowLast, this.selectColLast);
        } else {
            this.makeSelection(this.selectRowLast, this.selectColLast, n, n2);
        }
        this.selectReverse = bl;
        this.selectRowLast = n;
        this.selectColLast = n2;
        this.hasSelection = this.selectRowAnchor != this.selectRowLast || this.selectColAnchor != this.selectColLast;
    }

    final int nextPrintedChar(int n, int n2) {
        int n3 = n2;
        while (n3 < this.cols) {
            if (this.screen[n][n3] != '\u0000') break;
            ++n3;
        }
        return n3;
    }

    final int prevPrintedChar(int n, int n2) {
        int n3 = n2;
        while (n3 >= 0) {
            if (this.screen[n][n3] != '\u0000') break;
            --n3;
        }
        return n3;
    }

    final String addSpaces(int n, int n2) {
        String string = "";
        int n3 = n2 - n;
        if (n2 == this.cols) {
            n3 = -1;
        }
        int n4 = 0;
        while (n4 <= n3) {
            string = string + " ";
            ++n4;
        }
        return string;
    }

    public String getSelection() {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.hasSelection) {
            return null;
        }
        String string = this.termOptions[8] ? "\r\n" : "\r";
        if (this.selectReverse) {
            n4 = this.selectRowLast;
            n3 = this.selectColLast;
            n2 = this.selectRowAnchor;
            n = this.selectColAnchor;
        } else {
            n4 = this.selectRowAnchor;
            n3 = this.selectColAnchor;
            n2 = this.selectRowLast;
            n = this.selectColLast;
        }
        String string2 = "";
        if (n4 != n2) {
            int n5;
            int n6 = n3;
            while (n6 < this.cols) {
                if (this.screen[n4][n6] == '\u0000') {
                    n5 = this.nextPrintedChar(n4, n6);
                    string2 = string2 + this.addSpaces(n6, n5);
                    n6 = n5 - 1;
                } else {
                    string2 = string2 + this.screen[n4][n6];
                }
                ++n6;
            }
            if (n6 == this.cols) {
                string2 = string2 + string;
            }
            n6 = n4 + 1;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < this.cols) {
                    if (this.screen[n6][n7] == '\u0000') {
                        n5 = this.nextPrintedChar(n6, n7);
                        string2 = string2 + this.addSpaces(n7, n5);
                        n7 = n5 - 1;
                    } else {
                        string2 = string2 + this.screen[n6][n7];
                    }
                    ++n7;
                }
                string2 = string2 + string;
                ++n6;
            }
            n6 = 0;
            while (n6 <= n) {
                if (this.screen[n2][n6] == '\u0000') {
                    n5 = this.nextPrintedChar(n2, n6);
                    string2 = string2 + this.addSpaces(n6, n5);
                    n6 = n5 - 1;
                } else {
                    string2 = string2 + this.screen[n2][n6];
                }
                ++n6;
            }
            if (n6 == this.cols) {
                string2 = string2 + string;
            }
        } else {
            int n8 = n3;
            while (n8 <= n) {
                if (this.screen[n4][n8] == '\u0000') {
                    int n9 = this.nextPrintedChar(n4, n8);
                    string2 = string2 + this.addSpaces(n8, n9);
                    n8 = n9 - 1;
                } else {
                    string2 = string2 + this.screen[n4][n8];
                }
                ++n8;
            }
            if (n8 == this.cols) {
                string2 = string2 + string;
            }
        }
        return string2;
    }

    public void doClickSelect(int n, int n2) {
        if (this.selectClickRow == n && this.selectClickState) {
            this.selectColAnchor = 0;
            this.selectColLast = this.cols - 1;
        } else {
            if (this.screen[n][n2] != '\u0000') {
                int n3 = n2;
                while (n3 >= 0) {
                    if (this.selectDelims.indexOf(this.screen[n][n3]) != -1 || this.screen[n][n3] == '\u0000') break;
                    --n3;
                }
                this.selectColAnchor = n3 + 1;
                n3 = n2;
                while (n3 < this.cols) {
                    if (this.selectDelims.indexOf(this.screen[n][n3]) != -1 || this.screen[n][n3] == '\u0000') break;
                    ++n3;
                }
                this.selectColLast = n3 - 1;
            } else {
                this.selectColAnchor = this.prevPrintedChar(n, n2) + 1;
                this.selectColLast = this.nextPrintedChar(n, n2) - 1;
            }
            this.selectColAnchor = this.selectColAnchor > n2 ? n2 : this.selectColAnchor;
            this.selectColLast = this.selectColLast < n2 ? n2 : this.selectColLast;
        }
        this.selectClickState = !this.selectClickState;
        this.selectClickRow = n;
        this.selectRowAnchor = n;
        this.selectRowLast = n;
        this.selectReverse = false;
        this.hasSelection = true;
        this.makeSelection(this.selectRowAnchor, this.selectColAnchor, this.selectRowLast, this.selectColLast);
    }

    public void doCopy() {
        if (this.clipboard != null) {
            this.clipboard.setSelection(this.getSelection());
        }
    }

    public void doPaste() {
        String string;
        if (this.clipboard != null && (string = this.clipboard.getSelection()) != null) {
            if (this.termOptions[11]) {
                this.write(string);
            }
            this.sendBytes(string.getBytes());
        }
    }

    public Dimension getDimensionOfText(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.charWidth = -1;
        this.charHeight = fontMetrics.getHeight();
        this.charMaxAscent = fontMetrics.getMaxAscent();
        this.charMaxDescent = fontMetrics.getMaxDescent();
        this.charLeading = fontMetrics.getLeading();
        this.baselineIndex = this.charMaxAscent + this.charLeading - 1;
        if (this.charWidth == -1) {
            this.charWidth = fontMetrics.charWidth('W');
        }
        return new Dimension(n2 * this.charWidth + 2 * this.borderHeight, n * this.charHeight + 2 * this.borderWidth);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getDimensionOfText(this.rows, this.cols);
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getDimensionOfText(2, 8);
    }

    public Dimension getMaximumSize() {
        return this.getDimensionOfText(512, 512);
    }

    protected final void clearDirtyArea(Graphics graphics, Graphics graphics2) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        boolean bl2 = bl = this.dirtyLeft == 0 && this.dirtyRight == this.cols && this.dirtyTop == 0 && this.dirtyBottom == this.rows;
        if (bl) {
            Dimension dimension = this.getSize();
            n4 = 0;
            n3 = 0;
            n2 = dimension.width;
            n = dimension.height;
        } else {
            n4 = this.borderWidth + this.charWidth * this.dirtyLeft;
            n3 = this.borderHeight + this.dirtyTop * this.charHeight;
            n2 = this.charWidth * (this.dirtyRight - this.dirtyLeft);
            n = this.charHeight * (this.dirtyBottom - this.dirtyTop);
        }
        graphics.setColor(this.origBgColor);
        graphics.fillRect(n4, n3, n2, n);
        graphics.setColor(this.origFgColor);
        graphics2.setClip(n4, n3, n2, n);
    }

    public void repaint() {
        if (!this.repaintPending && this.isShowing() && !this.pendingShow) {
            super.repaint();
            this.repaintPending = true;
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    final Rectangle getClipRect(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            Dimension dimension = this.getSize();
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        }
        return rectangle;
    }

    public synchronized void update(Graphics graphics) {
        Rectangle rectangle;
        if (this.hpixels == 0 || this.vpixels == 0) {
            Dimension dimension = this.getSize();
            this.vpixels = dimension.height;
            this.hpixels = dimension.width;
            if (this.hpixels == 0 || this.vpixels == 0) {
                return;
            }
        }
        int n = 1;
        while (this.waitForMore) {
            this.waitForMore = false;
            try {
                this.wait(n * 25);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n++ <= 3) continue;
            this.waitForMore = false;
        }
        if (this.memGraphics == null || this.memImageSize == null || this.hpixels != this.memImageSize.width || this.vpixels != this.memImageSize.height) {
            this.memImageSize = new Dimension(this.hpixels, this.vpixels);
            this.memImage = this.createImage(this.hpixels, this.vpixels);
        }
        this.memGraphics = this.memImage.getGraphics();
        if (!this.repaintPending) {
            this.dirtyTop = 0;
            this.dirtyBottom = this.rows;
            this.dirtyLeft = 0;
            this.dirtyRight = this.cols;
            rectangle = this.getClipRect(graphics);
            this.memGraphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.memGraphics.setColor(this.origBgColor);
            this.memGraphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.memGraphics.setColor(this.origFgColor);
        } else {
            if (this.dirtyTop == this.rows) {
                this.dirtyTop = this.curRow;
            }
            if (this.dirtyBottom == 0) {
                this.dirtyBottom = this.curRow + 1;
            }
            if (this.dirtyRight == 0) {
                this.dirtyRight = this.curCol + 1;
            }
            if (this.dirtyLeft == this.cols) {
                this.dirtyLeft = this.curCol;
            }
            this.clearDirtyArea(this.memGraphics, graphics);
            rectangle = this.getClipRect(graphics);
        }
        int n2 = this.dirtyTop;
        while (n2 < this.dirtyBottom) {
            int n3 = this.borderHeight + n2 * this.charHeight;
            int[] nArray = this.attributes[this.visTop + n2];
            char[] cArray = this.screen[this.visTop + n2];
            int n4 = this.dirtyLeft;
            while (n4 < this.dirtyRight) {
                int n5 = nArray[n4];
                int n6 = n5 & 0xFFFF;
                if (n6 != 0) {
                    int n7 = this.borderWidth + this.charWidth * n4;
                    if ((n5 & 0x10) != 0 ^ (n5 & 0x1000) != 0) {
                        if ((n5 & 0x40) != 0) {
                            this.memGraphics.setColor(termColors[(n5 & 0xFF0000) >>> 16]);
                        }
                        this.memGraphics.fillRect(n7, n3, this.charWidth, this.charHeight);
                        if ((n5 & 0x80) != 0) {
                            this.memGraphics.setColor(termColors[(n5 & 0xFF000000) >>> 24]);
                        } else {
                            this.memGraphics.setColor(this.origBgColor);
                        }
                    } else {
                        if ((n5 & 0x80) != 0) {
                            this.memGraphics.setColor(termColors[(n5 & 0xFF000000) >>> 24]);
                            this.memGraphics.fillRect(n7, n3, this.charWidth, this.charHeight);
                            this.memGraphics.setColor(this.origFgColor);
                        }
                        if ((n5 & 0x40) != 0) {
                            this.memGraphics.setColor(termColors[(n5 & 0xFF0000) >>> 16]);
                        }
                    }
                    if ((n6 & 0x8000) != 0) {
                        if ((n5 & 0x100) != 0) {
                            this.drawLineDrawChar(this.memGraphics, n7, n3, this.baselineIndex, cArray[n4]);
                        } else if ((n5 & 1) != 0) {
                            this.memGraphics.setFont(this.boldFont);
                            this.memGraphics.drawChars(cArray, n4, 1, n7, n3 + this.baselineIndex);
                            this.memGraphics.setFont(this.plainFont);
                        } else {
                            this.memGraphics.drawChars(cArray, n4, 1, n7, n3 + this.baselineIndex);
                        }
                        if ((n5 & 4) != 0) {
                            this.memGraphics.drawLine(n7, n3 + this.baselineIndex, n7 + this.charWidth, n3 + this.baselineIndex);
                        }
                    }
                    this.memGraphics.setColor(this.origFgColor);
                }
                ++n4;
            }
            ++n2;
        }
        graphics.drawImage(this.memImage, 0, 0, this);
        Rectangle rectangle2 = new Rectangle(this.borderWidth + this.charWidth * this.lastCursorCol, this.borderHeight + this.lastCursorRow * this.charHeight, this.charWidth, this.charHeight);
        if (!rectangle.intersects(rectangle2)) {
            graphics.setClip(0, 0, this.hpixels, this.vpixels);
            this.hideCursor(graphics);
        } else {
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            graphics.setClip(0, 0, this.hpixels, this.vpixels);
            if (!rectangle3.equals(rectangle2) && !this.insideUpdate) {
                graphics.setColor(this.origBgColor);
                graphics.fillRect(0, 0, this.hpixels, this.vpixels);
                graphics.setColor(this.origFgColor);
                this.insideUpdate = true;
                this.update(graphics);
                this.insideUpdate = false;
                return;
            }
        }
        this.showCursor(graphics);
        this.repaintPending = false;
        this.dirtyTop = this.rows;
        this.dirtyBottom = 0;
        this.dirtyLeft = this.cols;
        this.dirtyRight = 0;
    }

    final synchronized void hideCursor(Graphics graphics) {
        if (this.cursorDrawn) {
            int n = this.borderWidth + this.charWidth * this.lastCursorCol;
            int n2 = this.borderHeight + this.lastCursorRow * this.charHeight;
            if ((this.attributes[this.visTop + this.lastCursorRow][this.lastCursorCol] & 0x10) != 0) {
                graphics.setColor(this.origFgColor);
            } else {
                graphics.setColor(this.origBgColor);
            }
            graphics.setXORMode(this.cursorColor);
            if (this.cursorHollow) {
                graphics.drawRect(n, n2, this.charWidth, this.charHeight - 1);
            } else {
                graphics.fillRect(n, n2, this.charWidth, this.charHeight);
            }
            graphics.setColor(this.origFgColor);
            graphics.setPaintMode();
            this.cursorDrawn = false;
        }
    }

    final synchronized void showCursor(Graphics graphics) {
        if (this.termOptions[9] && this.curCol < this.cols && this.curRow < this.rows) {
            int n = this.borderWidth + this.charWidth * this.curCol;
            int n2 = this.borderHeight + this.curRow * this.charHeight;
            graphics.setColor(this.cursorColor);
            if ((this.attributes[this.visTop + this.curRow][this.curCol] & 0x10) != 0) {
                graphics.setXORMode(this.origFgColor);
            } else {
                graphics.setXORMode(this.origBgColor);
            }
            if (this.haveFocus) {
                graphics.fillRect(n, n2, this.charWidth, this.charHeight);
                this.cursorHollow = false;
            } else {
                graphics.drawRect(n, n2, this.charWidth, this.charHeight - 1);
                this.cursorHollow = true;
            }
            graphics.setPaintMode();
            this.cursorDrawn = true;
            this.lastCursorRow = this.curRow;
            this.lastCursorCol = this.curCol;
        }
    }

    final void drawLineDrawChar(Graphics graphics, int n, int n2, int n3, char c) {
        int n4 = n + this.charWidth / 2;
        int n5 = n2 + this.charHeight / 2;
        int n6 = n + this.charWidth;
        int n7 = n2 + this.charHeight;
        switch (c) {
            case ' ': 
            case '_': {
                break;
            }
            case '}': {
                char[] cArray = new char[]{'\u00a3'};
                graphics.drawChars(cArray, 0, 1, n, n2 + n3);
                break;
            }
            case '.': {
                break;
            }
            case ',': {
                break;
            }
            case '+': {
                break;
            }
            case '-': {
                break;
            }
            case 'h': {
                break;
            }
            case '~': {
                break;
            }
            case 'a': {
                break;
            }
            case 'f': {
                char[] cArray = new char[]{'\u00b0'};
                graphics.drawChars(cArray, 0, 1, n, n2 + n3);
                break;
            }
            case '`': {
                int[] nArray = new int[4];
                int[] nArray2 = new int[4];
                nArray[0] = n4;
                nArray2[0] = n2;
                nArray[1] = n6;
                nArray2[1] = n5;
                nArray[2] = n4;
                nArray2[2] = n7;
                nArray[3] = n;
                nArray2[3] = n5;
                graphics.fillPolygon(nArray, nArray2, 4);
                break;
            }
            case 'z': {
                break;
            }
            case '{': {
                break;
            }
            case 'i': {
                break;
            }
            case 'y': {
                break;
            }
            case '|': {
                break;
            }
            case 'g': {
                char[] cArray = new char[]{'\u00b1'};
                graphics.drawChars(cArray, 0, 1, n, n2 + n3);
                break;
            }
            case 'o': {
                graphics.drawLine(n, n2, n6, n2);
                break;
            }
            case 'p': {
                break;
            }
            case 'r': {
                break;
            }
            case 's': {
                graphics.drawLine(n, n7, n6, n7);
                break;
            }
            case '0': {
                break;
            }
            case 'l': {
                graphics.drawLine(n4, n7, n4, n5);
                graphics.drawLine(n4, n5, n6, n5);
                break;
            }
            case 'k': {
                graphics.drawLine(n, n5, n4, n5);
                graphics.drawLine(n4, n5, n4, n7);
                break;
            }
            case 'm': {
                graphics.drawLine(n4, n2, n4, n5);
                graphics.drawLine(n4, n5, n6, n5);
                break;
            }
            case 'j': {
                graphics.drawLine(n4, n2, n4, n5);
                graphics.drawLine(n4, n5, n, n5);
                break;
            }
            case 'q': {
                graphics.drawLine(n, n5, n6, n5);
                break;
            }
            case 'x': {
                graphics.drawLine(n4, n2, n4, n7);
                break;
            }
            case 'n': {
                graphics.drawLine(n4, n2, n4, n7);
                graphics.drawLine(n, n5, n6, n5);
                break;
            }
            case 'u': {
                graphics.drawLine(n4, n2, n4, n7);
                graphics.drawLine(n, n5, n4, n5);
                break;
            }
            case 't': {
                graphics.drawLine(n4, n2, n4, n7);
                graphics.drawLine(n4, n5, n6, n5);
                break;
            }
            case 'v': {
                graphics.drawLine(n, n5, n6, n5);
                graphics.drawLine(n4, n5, n4, n2);
                break;
            }
            case 'w': {
                graphics.drawLine(n, n5, n6, n5);
                graphics.drawLine(n4, n5, n4, n7);
                break;
            }
        }
    }

    static {
        int n = 0;
        while (n < 512) {
            TerminalWin.spacerow[n] = 32;
            TerminalWin.zerorow[n] = 0;
            ++n;
        }
    }

    class FixedScrollbar
    extends Scrollbar {
        protected boolean onRight = true;

        public FixedScrollbar(int n) {
            super(n);
        }

        public void setBounds(Rectangle rectangle) {
            this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            this.reshape(n, n2, n3, n4);
        }

        public void reshape(int n, int n2, int n3, int n4) {
            if (this.onRight) {
                ++n;
                ++n4;
            } else {
                --n;
            }
            super.reshape(n, --n2, n3, ++n4);
        }

        public void setWindowSide(String string) {
            this.onRight = string.equals("right");
        }
    }
}

