/*
 * Decompiled with CFR 0.152.
 */
package mindbright.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import mindbright.util.Base64;
import mindbright.util.HexDump;
import mindbright.util.StringUtil;

public final class ASCIIArmour {
    public static final int DEFAULT_LINE_LENGTH = 70;
    String EOL = "\r\n";
    String headerLine;
    Hashtable headerFields;
    String tailLine;
    boolean blankHeaderSep;
    int lineLen;
    boolean haveChecksum;
    boolean unknownHeaderLines;
    String headerLinePrePostFix;

    public ASCIIArmour(String string, String string2, boolean bl, int n) {
        this.headerLine = string;
        this.tailLine = string2;
        this.blankHeaderSep = bl;
        this.lineLen = n;
        this.unknownHeaderLines = false;
        this.headerFields = new Hashtable();
    }

    public ASCIIArmour(String string, String string2) {
        this(string, string2, false, 70);
    }

    public ASCIIArmour(String string) {
        this(string, string);
        this.unknownHeaderLines = true;
    }

    public void setCanonicalLineEnd(boolean bl) {
        this.EOL = bl ? "\r\n" : "\n";
    }

    public Hashtable getHeaderFields() {
        return this.headerFields;
    }

    public String getHeaderField(String string) {
        return (String)this.headerFields.get(string);
    }

    public void setHeaderField(String string, String string2) {
        this.headerFields.put(string, string2);
    }

    public byte[] encode(byte[] byArray) {
        return this.encode(byArray, 0, byArray.length);
    }

    public byte[] encode(byte[] byArray, int n, int n2) {
        if (this.unknownHeaderLines) {
            return null;
        }
        int n3 = n2 / 3 * 4;
        StringBuffer stringBuffer = new StringBuffer(this.headerLine.length() + this.tailLine.length() + n3 + n3 / this.lineLen + 512);
        stringBuffer.append(this.headerLine);
        stringBuffer.append(this.EOL);
        stringBuffer.append(this.printHeaders());
        if (this.blankHeaderSep) {
            stringBuffer.append(this.EOL);
        }
        byte[] byArray2 = Base64.encode(byArray, n, n2);
        int n4 = 0;
        while (n4 < byArray2.length) {
            int n5 = this.lineLen;
            if (n4 + n5 > byArray2.length) {
                n5 = byArray2.length - n4;
            }
            String string = new String(byArray2, n4, n5);
            stringBuffer.append(string);
            stringBuffer.append(this.EOL);
            n4 += this.lineLen;
        }
        if (this.haveChecksum) {
            // empty if block
        }
        stringBuffer.append(this.tailLine);
        stringBuffer.append(this.EOL);
        return stringBuffer.toString().getBytes();
    }

    public void encode(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.encode(byArray, n, n2);
        outputStream.write(byArray2);
    }

    public void encode(OutputStream outputStream, byte[] byArray) throws IOException {
        this.encode(outputStream, byArray, 0, byArray.length);
    }

    public byte[] decode(byte[] byArray) {
        return this.decode(byArray, 0, byArray.length);
    }

    public byte[] decode(byte[] byArray, int n, int n2) {
        CharSequence charSequence;
        String string = new String(byArray, n, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        while (!bl && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.startsWith(this.headerLine)) continue;
            bl = true;
        }
        this.headerFields = new Hashtable();
        String string3 = null;
        while (!bl2 && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string3 != null) {
                charSequence = (String)this.headerFields.get(string3);
                this.headerFields.put(string3, (String)charSequence + StringUtil.trimRight(string2));
                string3 = null;
                continue;
            }
            int n3 = string2.indexOf(58);
            if (n3 < 0) {
                bl2 = true;
                continue;
            }
            String string4 = string2.substring(0, n3).trim();
            String string5 = string2.substring(n3 + 1).trim();
            if (string5.charAt(0) == '\"' && string5.charAt(string5.length() - 1) == '\\') {
                string3 = string4;
                string5 = string5.substring(0, string5.length() - 1);
            }
            this.headerFields.put(string4, string5);
        }
        if (this.blankHeaderSep) {
            // empty if block
        }
        charSequence = new StringBuffer();
        while (!bl3) {
            if (string2.startsWith(this.tailLine)) {
                bl3 = true;
                continue;
            }
            ((StringBuffer)charSequence).append(string2);
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                continue;
            }
            return null;
        }
        byArray = Base64.decode(((StringBuffer)charSequence).toString().getBytes());
        return byArray;
    }

    public byte[] decode(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < 2) {
            int n2 = inputStream.read();
            if (n2 == -1) {
                throw new IOException("Premature EOF, corrupt ascii-armour");
            }
            if (n2 == 13) continue;
            if (n2 != 10) {
                stringBuffer.append((char)n2);
                continue;
            }
            String string = new String(stringBuffer);
            if (n == 0) {
                if (string.startsWith(this.headerLine)) {
                    stringBuffer2.append(string);
                    stringBuffer2.append(this.EOL);
                    ++n;
                }
            } else {
                stringBuffer2.append(string);
                stringBuffer2.append(this.EOL);
                if (string.startsWith(this.tailLine)) {
                    ++n;
                }
            }
            stringBuffer.setLength(0);
        }
        return this.decode(stringBuffer2.toString().getBytes());
    }

    public String printHeaders() {
        Enumeration enumeration = this.headerFields.keys();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append(": ");
            String string2 = (String)this.headerFields.get(string);
            if (string2.charAt(0) == '\"' && string.length() + 2 + string2.length() > this.lineLen) {
                int n = this.lineLen - (string.length() + 2);
                stringBuffer.append(string2.substring(0, n));
                stringBuffer.append("\\");
                stringBuffer.append(this.EOL);
                string2 = string2.substring(n);
            }
            stringBuffer.append(string2);
            stringBuffer.append(this.EOL);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        byte[] byArray = "Hej svejs i lingonskogen!!!".getBytes();
        ASCIIArmour aSCIIArmour = new ASCIIArmour("---- BEGIN GARBAGE ----", "---- END GARBAGE ----");
        aSCIIArmour.setHeaderField("Subject", "mats");
        aSCIIArmour.setHeaderField("Comment", "\"this is a comment\"");
        byte[] byArray2 = aSCIIArmour.encode(byArray);
        System.out.println("Encoded block:");
        System.out.println(new String(byArray2));
        System.out.println("Decoded: " + new String(aSCIIArmour.decode(byArray2)));
        System.out.println("Headers:");
        System.out.println(aSCIIArmour.printHeaders());
        byArray2 = "---- BEGIN SSH2 PUBLIC KEY ----\r\nSubject: root\r\nComment: \"host key for hal, accepted by root Mon Sep 20 1999 10:10:02 +0100\"\r\nAAAAB3NzaC1kc3MAAACBAKpCbpj86G+05T53tn6Y+tJ1N87Kx2RbQTDC48LWHYNRZ3c4He\r\n0tmQNFbyg14m/dYrdBI0GxPWQH0RYuyL5YLhBrcscmdz7Ca8buEgehcQULlAJ1P0gZ3hvW\r\nqru55vgU8O0kZVNGSsA+cmXRpq689W6RU0u9qaW03FNdeH7tTq/1AAAAFQDCLg54vUWNe0\r\nn5kMFnEH/DiV5dgQAAAIEAmlOAXHQ/3nrFDnLiTIfCkCvAj/P2rMQUViYXXi9cQ+Qd8Ie5\r\nTmyFJ6t9iJQZ6x3HlScGfQOJcD4h4ydxuXr+rRd6yi48kSB5/g3EscL+6+LMYdMGSGA2ni\r\nl1Vpjm49xZHxHlvTQ+KExk6Pcyb9D5zTW9uoOTBA08SPpYAlbZ4+MAAACAKEeiebGmZg5x\r\nsbxQt6HUPU3Cov9KeXw98qmn4Rr2ENWSTriwl8uxoD8wCuURHaJ61YX5spAj4QkVESqc7Y\r\nNBcZgpST0sUWCF0rNPZm8D6K0hgaUmtfrUJ6EzwxqfKH3YduMHFz5RSv492TSZvKKv+Ucb\r\nX4hEjfmP6SKc+Q4wGaQ=\r\n---- END SSH2 PUBLIC KEY ----\r\n".getBytes();
        aSCIIArmour = new ASCIIArmour("---- BEGIN SSH2 PUBLIC KEY ----", "---- END SSH2 PUBLIC KEY ----");
        byte[] byArray3 = null;
        try {
            aSCIIArmour = new ASCIIArmour("---- BEGIN SSH2 ENCRYPTED PRIVATE KEY ----", "---- END SSH2 ENCRYPTED PRIVATE KEY ----");
            byArray3 = aSCIIArmour.decode(new FileInputStream("/home/matsa/tstkey.prv"));
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
        }
        System.out.println("Decoded: ");
        HexDump.hexDump(byArray3, 0, byArray3.length);
        System.out.println("Headers:");
        System.out.println(aSCIIArmour.printHeaders());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("/home/matsa/tstkey2.prv");
            aSCIIArmour.setCanonicalLineEnd(false);
            aSCIIArmour.encode(fileOutputStream, byArray3);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
        }
    }
}

