/***************************************************/
/*  MMINSTAL.CMD : Build MathMate Desktop objects  */
/***************************************************/

Address CMD

'@echo off'

Parse Arg target_dir .

If Pos('?',target_dir) <> 0 Then
   Call Usage

If target_dir = '' Then Do
   Say 'Enter path where to install MathMate'
   Parse Pull target_dir .
   If target_dir = '' Then Call Usage
End

Call RXFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

Call Setlocal

Parse Source . . CmdFile .
SourceFile = FileSpec("drive",CmdFile) || ,
             FileSpec("path",CmdFile) || 'mmdata.exe'

If \FileExists(SourceFile) Then
      Call ErrorMsg 'File "' || SourceFile || '" not found'

If LastPos("\",target_dir) <> Length(target_dir) Then
   target_dir = target_dir || "\"

Parse Upper Value FileSpec("drive",target_dir) With Drive

If WordPos(Drive,SysDriveMap('C:','USED')) = 0 Then
   Call ErrorMsg 'Drive "' || Drive || '" not detected'

Path = DelStr(FileSpec("path",target_dir),1,1)

Drive
'cd \'

Do Forever
   Parse Var Path loc_dir '\' Path
   If loc_dir = "" Then Leave
   If Directory(loc_dir) <> "" Then Iterate
   If SysMkDir(loc_dir) <> 0 Then
      Call ErrorMsg 'Cannot create directory "' || loc_dir || '"'
   Call Directory loc_dir
End

/* Copy files */

Say 'Copying source files...'

SourceFile' -uo > nul'
If rc <> 0 Then
   Call ErrorMsg 'The source file is corrupted'

Say 'Adding Workplace Shell Objects...'

iconparm  = 'ICONFILE=' || target_dir || 'mm.ico;'

classname = 'WPFolder'
title     = 'MathMate 1.1 for OS/2'
location  = '<WP_DESKTOP>'
setup     = 'OBJECTID=<MM_FOLDER>;' || iconparm
Call SysCreateObject classname, title, location, setup, 'r'

iconparm  = 'ICONFILE=' || target_dir || 'mathmate.ico;'

classname = 'WPProgram'
title     = 'MathMate 1.1'
location  = '<MM_FOLDER>'
setup     = 'EXENAME='target_dir'mathmate.exe;' ||,
            'PROGTYPE=PM;' ||,
            'STARTUPDIR=' || target_dir || ';' || iconparm
Call SysCreateObject classname, title, location, setup, 'r'

classname = 'WPProgram'
title     = 'MathMate Information'
location  = '<MM_FOLDER>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=' || target_dir || 'mathmate.inf;' ||,
            'STARTUPDIR=' || target_dir || ';' 
Call SysCreateObject classname, title, location, setup, 'r'

Say 'Installation complete'
Say ''

Call SysDropFuncs

'Type readme'
Say ''

Call Endlocal

Exit

/*
 * FileExists
 */

FileExists:
   return( stream( arg(1), 'c', 'query exists' ) <> '' )

/*
 * Usage
 */

Usage:
   Say ''
   Say 'Usage: mminstal [target_dir]'
   Say ''
   Say '   target_dir  = path where to install MathMate'
   Say ''
   Say 'This program builds various Workplace Shell objects'
   Say 'needed to run MathMate.'
   Exit

/*
 * ErrorMsg
 */

ErrorMsg:
   Say ''
   Say Arg(1)
   Call Endlocal
   Call SysDropFuncs
   Exit
