/* WorkPlaceCalendar - Year Calendar Builder v0.8 */
/* by Frank Wochatz <mail@subsys.de> */

parse arg year

/* check parameter */
year = strip(year)

if year = "" then year = left(date('S'),4)

if datatype(year) >< 'NUM' | length(year) >< 4 then do
say 'Invalid parameter. Must be a 4 digit year number, e.g. 2007'
pull dummy
exit
end


/* folder setup ------------------------------*/

/* size.font, e.g. "10.System VIO" */
iconfont="10.System VIO"

/* background color, RGB values, space seperated, e.g. for white "255 255 255" */
bgcolor="255 255 255" 

/* -------------------------------------------*/


parse source . . ScriptFile
inst_drive = filespec("D", ScriptFile)
inst_path = filespec("P", scriptfile)
installpath=inst_drive||inst_path

language = left(Value('Lang',,'OS2ENVIRONMENT'),2)

Select
when language = 'nl' | language = 'de' then Calendarstring = 'Kalender'
when language = 'fr' then Calendarstring = 'Calendrier'
otherwise then Calendarstring = 'Calendar'
end

/* create year folder */
Call SysCreateObject 'WPFolder', Calendarstring year, '<WP_DESKTOP>', 'OBJECTID=<WPCALENDAR'||year||'>;ICONVIEW=FLOWED;ICONFONT='||iconfont||';BACKGROUND=(none),T,1,C,'||bgcolor, 'Update'


do i = 1 to 12
m = 13-i
call  WPCALENDAR.CMD '/D:'||year||right(m,2,'0')||'01 /Y:1' '/O:WP_CALENDAR'||year||right(m,2,'0')
end

/* open calendar folder */
call SysOpenObject '<WPCALENDAR'||year||'>',0,"TRUE"