/***************************************************************************\
 *
 * PROGRAMMNAME: HOPF6036
 * -------------
 *
 * VERSION: 4.4
 * --------
 *
 * MODULNAME: INIT
 * ----------
 *
 * BESCHREIBUNG: Initialisierungsmodul fr Device Driver
 * -------------
 *
 * HINWEISE:
 * ---------
 *
 * FUNKTIONEN:
 * -----------
 *   cini
 *
 *  Ver.    Date      Comment
 *  ----    --------  -------
 *  4.10          97  Erste Version
 *  4.40    06-21-00  y2k-Bugfix
 *
 *  Copyright (C) noller & breining software 1995...2000
 *
\******************************************************************************/
#define INCL_DOSFILEMGR
#define INCL_DOSPROCESS
#define STDOUT      1
#define STDIN       0
#define STDERROR    2
#define READONLY_FLAG 0
#include <os2.h>
#include "common.h"

#pragma check_stack (off)

extern short portaddr;
extern short intervall;
extern short utcflag;
extern short offset;

int getTime (void);

short cini ( unsigned char far* strCfg)
{
    SHORT sCnt;
    SHORT sError;

    sCnt=0;
    sError = FALSE;

    while (strCfg[sCnt] != '\0')
    {
        if ((strCfg[sCnt] == '-') || (strCfg[sCnt] == '/'))
        {
            sCnt++;
            switch (strCfg[sCnt])
            {
                case 'P':
                case 'p':
                    do
                    {
                        sCnt++;
                    } while (strCfg[sCnt] == ' ');
                    if ((strCfg[sCnt] == ':') || (strCfg[sCnt] == '='))
                    {
                       do
                       {
                           sCnt++;
                       } while (strCfg[sCnt] == ' ');
                       portaddr = hextoint (&(strCfg[sCnt]));
                    }
                    break;

                case 'I':
                case 'i':
                    do
                    {
                        sCnt++;
                    } while (strCfg[sCnt] == ' ');
                    if ((strCfg[sCnt] == ':') || (strCfg[sCnt] == '='))
                    {
                       do
                       {
                           sCnt++;
                       } while (strCfg[sCnt] == ' ');
                       intervall = atoi (& (strCfg[sCnt]));
                    }
                    break;

                case 'U':
                case 'u':
                    utcflag = 1;
                    break;

                case 'O':
                case 'o':
                    do
                    {
                        sCnt++;
                    } while (strCfg[sCnt] == ' ');
                    if ((strCfg[sCnt] == ':') || (strCfg[sCnt] == '='))
                    {
                       do
                       {
                           sCnt++;
                       } while (strCfg[sCnt] == ' ');
                       offset = atoi (& (strCfg[sCnt]));
                    }
                    break;

                default:
                    sError = TRUE;
                    printtoscreen ("HOPF6036 - Treiber:\r\nUngltiger Parameter in Config.sys angegeben\r\n");
                    break;
            }
        }
        sCnt++;
    }
    getTime ();

    return sError;
}

