#define	USE_OS2_TOOLKIT_HEADERS		/* Toolkit for OS/2 gp */
#define INCL_GPI
#define INCL_DOS
#define INCL_WIN
#define INCL_DOSSEMAPHORES
#define INCL_ERRORS
#define	__IBMC__	// ꂪƁAToolkit*.h16bitRpCƎv

#include	<string.h>
#include	<process.h>
#include	<setjmp.h>
#include	<os2.h>
#include	"K-Clock.h"


HAB		Hab; 				// AJ[ubNnh
HMQ		Hmq;				// bZ[WL[nh
QMSG	Qmsg;				// bZ[W\
HWND	Hwnd, HwndC;		// EBhEnh(t[,NCAg)
HWND	HwndPopM;			// |bvAbvj[

HDC		HdcMem;				// memory device context haldle
HPS		HpsMem;				// memory presentation space haldle
HBITMAP	HbmMem;				// Ɋ蓖Ă bitmap handle

BOOL	FFlush = FALSE;
BOOL	FCapture = FALSE;	// mouseLv`[
BOOL	FDrag = FALSE;		// drag
POINTL	PtlMouIni;			// hbOJnmousëʒu
POINTL	PtlWinBef;			// hbOJnwindoẅʒu
POINTL	PtlWnd;				// EBhD̈ʒu

ULONG	UlCount = 0;		// ׊Ďp̃JE^[
HEV		HevTime;			// timerThread()gĂevent semaphore

// fW^tHg
FONTPOS	FpTime, FpMem1, FpMem2, FpColon, FpBar, FpBlank;
// t[ł̊ep[c̔zu
POINTL	PtlHour, PtlColon, PtlMin, PtlMem, PtlBar;

SIZEL	SzlFrame;			// t[̃TCY

ULONG	CxDT, CyDT;			// fXNgbv̉𑜓x

BOOL	FIdle;				// ׊ĎXbh͗VxԃNX
BOOL	FFloatTop;			// ɎOɕ\
ULONG	FlSize;				// CS_LARGE : , CS_SMALL : 
ULONG	UlSwapLimit;		// x\swapfilẽTCY
ULONG	FlDotBlink;			// 0:-Ԃ̃R_, 1:_܂

jmp_buf	Jb;					// Wv buffer(C`L(^^;)


BOOL	makeBMP( void );
BOOL	destroyBMP( void );
MRESULT EXPENTRY clientWinProc( HWND, USHORT, MPARAM, MPARAM );
MRESULT EXPENTRY procPaint( HWND, USHORT, MPARAM, MPARAM );
MRESULT EXPENTRY procShow( HWND, USHORT, MPARAM, MPARAM );
MRESULT EXPENTRY procCommand( HWND, USHORT, MPARAM, MPARAM );
void	timerThread();
void	chkLoadThread();
ULONG	querySwapPath( char * );
void	allHalftone( void );
BOOL	getOption( int, char ** );
void	errQuitWin( UCHAR* );
void	errQuitDos( UCHAR*, APIRET );
BOOL	readIni( void );
void	writeIni( void );
void	showHelp( void );
void	setWindow( void );



/***************************************************************************
	main : 
***************************************************************************/
main(int argc, char *argv[])
{
//	ULONG	flCreate =  FCF_TITLEBAR | FCF_SYSMENU | FCF_NOBYTEALIGN
	ULONG	flCreate =  FCF_NOBYTEALIGN | FCF_TASKLIST | FCF_BORDER
						| FCF_ICON | FCF_AUTOICON;

	CHAR	szClass [] = "K-Clock-Window";

	/* initialize PM usage */
	if ( ( Hab = WinInitialize(0) ) == NULLHANDLE )	exit(1);
	/* bZ[WL[쐬 */
	if ( ( Hmq = WinCreateMsgQueue(Hab, 0) ) == NULLHANDLE ){
		WinTerminate( Hab );
		DosBeep( 600, 50 );
		exit(1);
	}

	WinRegisterClass( Hab, szClass, (PFNWP)clientWinProc, CS_SIZEREDRAW, 0 );

	Hwnd = WinCreateStdWindow( HWND_DESKTOP, WS_ANIMATE, &flCreate,
				szClass, "K-Clock", 0L, NULLHANDLE, ID_K_CLOCK, &HwndC );

	if ( !readIni() )					goto quit01;
	if ( !getOption( argc, argv ) )		goto quit01;
	if ( setjmp( Jb ) != 0 )			goto quit01;

	makeBMP();

	setWindow();

	_beginthread( (PVOID)chkLoadThread, NULL, 16384, NULL );
	_beginthread( (PVOID)timerThread, NULL, 32768, NULL );

	while ( WinGetMsg( Hab, &Qmsg, NULLHANDLE, 0, 0)) {
			WinDispatchMsg (Hab, &Qmsg);
	}

	destroyBMP();
	writeIni();

quit01:
	WinDestroyMsgQueue( Hmq );	/* destroy message queue */
	WinTerminate( Hab );		/* terminate PM usage */
}


/***************************************************************************
	setWindow : NEBhDʒuZbg
	parm	: (void)
	ret		: (BOOL)TRUE
***************************************************************************/
void
setWindow()
{
	RECTL	rcl;
	long	cx, cy;
	rcl.xLeft = rcl.yBottom = 0;
	rcl.xRight = SzlFrame.cx, rcl.yTop = SzlFrame.cy;
//	rcl.xRight = CX_BUFPS, rcl.yTop = CY_BUFPS;
	WinCalcFrameRect( Hwnd, &rcl, FALSE );
	cx = rcl.xRight - rcl.xLeft, cy = rcl.yTop - rcl.yBottom;
	if ( PtlWnd.x < 0 )	PtlWnd.x = 0;
	if ( PtlWnd.x + cx > CxDT )		PtlWnd.x = CxDT - cx;
	if ( PtlWnd.y < 0 )	PtlWnd.y = 0;
	if ( PtlWnd.y + cy > CyDT )		PtlWnd.y = CyDT - cy;
	WinSetWindowPos( Hwnd, NULLHANDLE, PtlWnd.x, PtlWnd.y, cx, cy,
			SWP_SHOW | SWP_MOVE | SWP_SIZE );
}


/***************************************************************************
	getOption : NIvVǂݍ
	parm	: main()̂̂Ɠ
	ret		: (BOOL)TRUE
***************************************************************************/
BOOL
getOption( int argc, char **argv )
{
	short	i;
	char	c, *pc;
	char	*ret = NULL;

	for( i = 1; i < argc; i++ ){
		if( *argv[i] == '-' || *argv[i] == '/' ){
			c = toupper( argv[i][1] );
			switch( c ){
			case 'S':		// TCYw
				if ( (c = toupper(argv[i][2])) == 'S' )	FlSize = CS_SMALL;
				else if ( c == 'L' )					FlSize = CS_LARGE;
				break;
			case 'C':		// load thread ̗D揇ʃNXw
				if ( (c = toupper(argv[i][2])) == 'N' )	FIdle = FALSE;
				else if ( c == 'I' )					FIdle = TRUE;
				break;
			case 'L':		// Xbvt@CTCYxl
				UlSwapLimit = atoi( &argv[i][2] ) << 20;
				break;
			case 'F':		// ɍłOɕ\
				if ( (c = argv[i][2]) == '+' )	FFloatTop = TRUE;
				else if ( c == '-' )			FFloatTop = FALSE;
				break;
			case 'B':		// R_
				if ( (c = argv[i][2]) == '+' )	FlDotBlink = 0;
				else if ( c == '-' )			FlDotBlink = 1;
				break;
			case 'H':
			case '?':
				showHelp();
				return( FALSE );
			}
		}
	}
	return( TRUE );
}


/***************************************************************************
	showHelp : about\
	parm	: (void)
	ret		: (void)
***************************************************************************/
void
showHelp()
{
	UCHAR	aucBuf[512];
	UCHAR	*puc;

	// string resource  Œ 256bytes Ȃ̂ŁA2ɕĂ
	WinLoadString( Hab, 0, ID_K_CLOCK, sizeof(aucBuf), aucBuf );
	puc = strchr( aucBuf, '\0' );
	WinLoadString( Hab, 0, ID_K_CLOCK+1, sizeof(aucBuf), puc );
	WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, aucBuf,
		"K-Clock 1.01 - usage", 0,
		MB_OK | MB_INFORMATION | MB_SYSTEMMODAL | MB_MOVEABLE);
				
}


/***************************************************************************
	clientWinProc : EBhDbZ[W
	parm	: 
	ret		: 
***************************************************************************/
MRESULT EXPENTRY
clientWinProc( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	static BOOL	fTime = TRUE;

	switch (msg) {
	case WM_SHOWINFO:
		if ( fTime )	return( procShow( hwnd, msg, mp1, mp2 ) );
		else			return( FALSE );
	case WM_BUTTON2CLICK:
		{
		ULONG	x, y;
		x = SHORT1FROMMP(mp1), y = SHORT2FROMMP(mp1);
		WinPopupMenu( HwndC, HwndC, HwndPopM, x, y, MID_MOVEEDGE, 
			PU_VCONSTRAIN | PU_HCONSTRAIN | PU_KEYBOARD | PU_MOUSEBUTTON1
			| PU_SELECTITEM );
		return (MRESULT) TRUE;
		}
	case WM_BUTTON1DOWN:
		{
		DATETIME	dt;
		RECTL	rcl;
		POINTL	aptl[3];
		union {	SHOWINFO si; ULONG ul; } usi;
		union {	CHGINFO ci;  ULONG ul; } uci;
		if ( FCapture )	return( FALSE );
		FCapture = WinSetCapture( HWND_DESKTOP, hwnd );
		WinSetActiveWindow( HWND_DESKTOP, hwnd );
		fTime = FALSE;
		usi.ul = uci.ul = 0;
		uci.ci.hour10 = uci.ci.hour1
		= uci.ci.min10 = uci.ci.min1
		= uci.ci.mem = uci.ci.load = 1;
		DosGetDateTime( &dt );
		usi.si.hour10 = dt.month / 10;
		usi.si.hour1 = dt.month % 10;
		usi.si.min10 = dt.day / 10;
		usi.si.min1 = dt.day % 10;
		usi.si.load = dt.weekday + 1;
		usi.si.mem = dt.year % 100;
		aptl[0] = PtlColon;
		aptl[1].x = aptl[0].x + FpColon.ptlFont.x;
		aptl[1].y = aptl[0].y + FpColon.ptlFont.y;
		aptl[2] = FpColon.ptlSrcTop, aptl[2].x += FpColon.lShift;
		GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
		rcl.xLeft = aptl[0].x,		rcl.xRight = aptl[1].x;
		rcl.yBottom = aptl[0].y,	rcl.yTop = aptl[1].y;
		WinInvalidateRect( hwnd, &rcl, FALSE );
		procShow( hwnd, WM_SHOWINFO,
				MPFROMLONG(uci.ul), MPFROMLONG(usi.ul) );
		return( FALSE );
		}
	case WM_BUTTON1UP:
		if ( !FCapture )	return( FALSE );
		WinSetCapture( HWND_DESKTOP, NULLHANDLE );
		FCapture = FALSE;
		FFlush = TRUE;
		DosPostEventSem( HevTime );
		fTime = TRUE;
		return( FALSE );
	case WM_BUTTON1DBLCLK:
		WinSendMsg (hwnd, WM_CLOSE, 0L, 0L);
		return( (MRESULT)TRUE );
	case WM_BEGINDRAG:
		if ( FCapture )	return( FALSE );
		FCapture = WinSetCapture( HWND_DESKTOP, hwnd );
		if ( !FCapture )	return( FALSE );
		FDrag = TRUE;
		{
		SWP		swp;
		WinQueryWindowPos( Hwnd, &swp );
		PtlMouIni.x = SHORT1FROMMP(mp1);
		PtlMouIni.y = SHORT2FROMMP(mp1);
		PtlWinBef.x = swp.x;
		PtlWinBef.y = swp.y;
		}
		return( (MRESULT)TRUE );
	case WM_ENDDRAG:
		if ( !FCapture )	return( FALSE );
		WinSetCapture( HWND_DESKTOP, NULLHANDLE );
		FCapture = FALSE;
		FDrag = FALSE;
		return( (MRESULT)TRUE );
	case WM_MOUSEMOVE:
		if ( !FDrag ) return( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );
		{
		POINTL	ptl;
		ptl.x = PtlWinBef.x - PtlMouIni.x + (short)SHORT1FROMMP(mp1);
		ptl.y = PtlWinBef.y - PtlMouIni.y + (short)SHORT2FROMMP(mp1);
		if ( ptl.x == PtlWinBef.x && ptl.y == PtlWinBef.y )
			return( (MRESULT)TRUE );
		WinSetWindowPos( Hwnd, NULLHANDLE, ptl.x, ptl.y, 0, 0, SWP_MOVE );
		PtlWinBef = ptl;
		}
		return( (MRESULT)TRUE );
	case WM_COMMAND:
		return( procCommand( hwnd, msg, mp1, mp2 ) );
	case WM_ERASEBACKGROUND:
		return (MRESULT) TRUE;
		break;
	case WM_PAINT:
		return( procPaint( hwnd, msg, mp1, mp2 ) );
	case WM_CREATE:
		HwndPopM = WinLoadMenu( HWND_OBJECT, NULLHANDLE, IDM_POPUP1 );
		return( FALSE );
	default:
		return( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );
	}
	return (MRESULT) FALSE;
}


/***************************************************************************
	procCommand : WM_COMMAND ̏
	parm	: 
	ret		: (MRESULT)FALSE
***************************************************************************/
MRESULT EXPENTRY
procCommand (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 )
{
	switch ( SHORT1FROMMP(mp1) ) {
	case MID_QUIT:
		WinSendMsg (hwnd, WM_CLOSE, 0L, 0L);
		return( FALSE );
	case MID_USAGE:
		showHelp();
		return( FALSE );
	case MID_MOVE_RT:
	case MID_MOVE_RB:
	case MID_MOVE_LT:
	case MID_MOVE_LB:
		{
		SWP	swp;
		ULONG	x, y;
		WinQueryWindowPos( Hwnd, &swp );
		switch ( SHORT1FROMMP(mp1) ) {
		case MID_MOVE_RT:
			x = CxDT - swp.cx, y = CyDT - swp.cy;	break;
		case MID_MOVE_RB:
			x = CxDT - swp.cx, y = 0;				break;
		case MID_MOVE_LT:
			x = 0, y = CyDT - swp.cy;				break;
		case MID_MOVE_LB:
			x = y = 0;								break;
		}
		WinSetWindowPos( Hwnd, NULLHANDLE, x, y, 0, 0, SWP_MOVE );
		}
	}
	return( FALSE );
}


/***************************************************************************
	procShow : WM_SHOWINFO (IWi) ̏
	parm	: 
	ret		: (MRESULT)FALSE
***************************************************************************/
MRESULT EXPENTRY
procShow( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	static ULONG	ulLoadBef = 100;	// 킴ƖȒlĂ
	static ULONG	ulMemBef = 1000;	// 
	static ULONG	ulLoadAlarm = 0;
	static ULONG	ulMemAlarm = 0;
	union {	CHGINFO ci;  ULONG ul; } uci;
	union {	SHOWINFO si; ULONG ul; } usi;
	POINTL	aptl[3];
	RECTL	rcl;

	if ( FFloatTop )
		WinSetWindowPos( Hwnd, HWND_TOP, 0, 0, 0, 0, SWP_ZORDER );

	uci.ul = LONGFROMMP( mp1 ), usi.ul = LONGFROMMP( mp2 );

	if ( uci.ci.load ) {
		ULONG	ul = usi.si.load;
		POINTL ptl = FpBar.ptlSrcTop;
		if ( ul > 8 ) ulLoadAlarm = 10, ul = 8, ulLoadBef = 100;
		if ( ulLoadAlarm )	ulLoadAlarm--, ptl.x += FpBar.lShift;
		if ( ul != ulLoadBef ) {
			ulLoadBef = ul;
			if ( ul > 0 ) {
				aptl[0] = PtlBar;
				aptl[1].x = aptl[0].x + FpBar.ptlFont.x * ul;
				aptl[1].y = aptl[0].y + FpBar.ptlFont.y;
				aptl[2] = ptl;
				GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
			}
			if ( ul < 8 ) {
				aptl[0] = PtlBar;
				aptl[0].x += FpBar.ptlFont.x * ul;
				aptl[1].x = aptl[0].x + FpBar.ptlFont.x * (8 - ul);
				aptl[1].y = aptl[0].y + FpBar.ptlFont.y;
				aptl[2] = FpBlank.ptlSrcTop;
				GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
			}
			rcl.xLeft = PtlBar.x,	rcl.xRight = aptl[1].x;
			rcl.yBottom = PtlBar.y,	rcl.yTop = aptl[1].y;
			WinInvalidateRect( hwnd, &rcl, FALSE );
		}
	}
	if ( uci.ci.dot ) {
		aptl[0] = PtlColon;
		aptl[1].x = aptl[0].x + FpColon.ptlFont.x;
		aptl[1].y = aptl[0].y + FpColon.ptlFont.y;
		if ( usi.si.dot )	aptl[2] = FpColon.ptlSrcTop;
		else				aptl[2] = FpBlank.ptlSrcTop;
		GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
		rcl.xLeft = aptl[0].x,		rcl.xRight = aptl[1].x;
		rcl.yBottom = aptl[0].y,	rcl.yTop = aptl[1].y;
		WinInvalidateRect( hwnd, &rcl, FALSE );
	}
	if ( uci.ci.mem ) {
		ULONG	ul = usi.si.mem;
		FONTPOS *pfp = &FpMem1;
		if ( ul & 512 ) ulMemAlarm = 5, ul &= 511;
		if ( ulMemAlarm )	pfp = &FpMem2, ulMemAlarm--;
		if ( ul != ulMemBef ) {
			ulMemBef = ul;
			aptl[0] = PtlMem;
			aptl[1].x = aptl[0].x + FpMem1.ptlFont.x;
			aptl[1].y = aptl[0].y + FpMem1.ptlFont.y;
			aptl[2] = pfp->ptlSrcTop;
			aptl[2].x = pfp->ptlSrcTop.x + FpMem1.ptlFont.x * (ul/100);
			GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
			aptl[0].x = aptl[1].x;
			aptl[1].x = aptl[0].x + FpMem1.ptlFont.x;
			aptl[2].x = pfp->ptlSrcTop.x + FpMem1.ptlFont.x * ((ul/10)%10);
			GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
			aptl[0].x = aptl[1].x;
			aptl[1].x = aptl[0].x + FpMem1.ptlFont.x;
			aptl[2].x = pfp->ptlSrcTop.x + FpMem1.ptlFont.x * (ul%10);
			GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
			rcl.xLeft = PtlMem.x,	rcl.xRight = aptl[1].x;
			rcl.yBottom = PtlMem.y,	rcl.yTop = aptl[1].y;
			WinInvalidateRect( hwnd, &rcl, FALSE );
		}
	}
	if ( uci.ci.hour10 ) {
		ULONG	ul = usi.si.hour10;
		if ( ul & 4 )	ul += 6;
		aptl[0] = PtlHour;
		aptl[1].x = aptl[0].x + FpTime.ptlFont.x;
		aptl[1].y = aptl[0].y + FpTime.ptlFont.y;
		aptl[2] = FpTime.ptlSrcTop, aptl[2].x += FpTime.ptlFont.x * ul;
		GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
		rcl.xLeft = aptl[0].x,		rcl.xRight = aptl[1].x;
		rcl.yBottom = aptl[0].y,	rcl.yTop = aptl[1].y;
		WinInvalidateRect( hwnd, &rcl, FALSE );
	}
	if ( uci.ci.hour1 ) {
		ULONG	ul = usi.si.hour1;
		aptl[0] = PtlHour;
		aptl[0].x += FpTime.ptlFont.x;
		aptl[1].x = aptl[0].x + FpTime.ptlFont.x;
		aptl[1].y = aptl[0].y + FpTime.ptlFont.y;
		aptl[2] = FpTime.ptlSrcTop, aptl[2].x += FpTime.ptlFont.x * ul;
		GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
		rcl.xLeft = aptl[0].x,		rcl.xRight = aptl[1].x;
		rcl.yBottom = aptl[0].y,	rcl.yTop = aptl[1].y;
		WinInvalidateRect( hwnd, &rcl, FALSE );
	}
	if ( uci.ci.min10 ) {
		ULONG	ul = usi.si.min10;
		if ( ul & 8 )	ul += 2;
		aptl[0] = PtlMin;
		aptl[1].x = aptl[0].x + FpTime.ptlFont.x;
		aptl[1].y = aptl[0].y + FpTime.ptlFont.y;
		aptl[2] = FpTime.ptlSrcTop, aptl[2].x += FpTime.ptlFont.x * ul;
		GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
		rcl.xLeft = aptl[0].x,		rcl.xRight = aptl[1].x;
		rcl.yBottom = aptl[0].y,	rcl.yTop = aptl[1].y;
		WinInvalidateRect( hwnd, &rcl, FALSE );
	}
	if ( uci.ci.min1 ) {
		ULONG	ul = usi.si.min1;
		aptl[0] = PtlMin;
		aptl[0].x += FpTime.ptlFont.x;
		aptl[1].x = aptl[0].x + FpTime.ptlFont.x;
		aptl[1].y = aptl[0].y + FpTime.ptlFont.y;
		aptl[2] = FpTime.ptlSrcTop, aptl[2].x += FpTime.ptlFont.x * ul;
		GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
		rcl.xLeft = aptl[0].x,		rcl.xRight = aptl[1].x;
		rcl.yBottom = aptl[0].y,	rcl.yTop = aptl[1].y;
		WinInvalidateRect( hwnd, &rcl, FALSE );
	}

	return( FALSE );
}


/***************************************************************************
	procPaint : WM_PAINT̏
	parm	: gĂ܂
	ret		: (MRESULT)FALSE
***************************************************************************/
MRESULT EXPENTRY
procPaint( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	HPS		hps;
	RECTL	rclInv;
	POINTL	aptl[3];
	long	l;

	hps = WinBeginPaint( hwnd, NULLHANDLE, &rclInv );
	aptl[0].x = aptl[2].x = rclInv.xLeft;
	aptl[0].y = aptl[2].y = rclInv.yBottom;
	aptl[1].x = rclInv.xRight;
	aptl[1].y = rclInv.yTop;
	l = GpiBitBlt( hps, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
	WinEndPaint( hps );
	if ( l == GPI_ERROR ) {
		ERRORID	ei = WinGetLastError( Hab );
		DosBeep( 3000, 30 );
		if ( ei == PMERR_PS_BUSY ){
			WinInvalidateRect( hwnd, &rclInv, FALSE );
		}
	}

	return( FALSE );
}


/***************************************************************************
	icat : l𕶎ɕϊstrcat()
	parm	: (UCHAR*)^[Qbg, (ULONG)l
	ret		: (void)
	rem		: sprintf()g΍ςނƂłcBEXẼTCY4
			  ȂĂ܂̂ŁcB
***************************************************************************/
void
icat( UCHAR *pucT, ULONG ulS ) {
	UCHAR	*puc;
	ULONG	ul, i;
	puc = strchr( pucT, '\0' );

	for ( i = 0; i < 4; i++ ) {
		ul = (ulS & 0xf000)>>12;
		if ( ul < 10 )	*puc++ = '0' + ul;
		else			*puc++ = 'a' + ul - 10;
		ulS <<= 4;
	}
	*puc = '\0';
}


/***************************************************************************
	errQuitWin : Win`() etc. ŒvIG[N̑Eop
	parm	: (UCHAR*)API
	ret		: (void)킯Ȃ
***************************************************************************/
void
errQuitWin( UCHAR *aucAPI )
{
	UCHAR	buf[256];
	ERRORID	ei;

	ei = ERRORIDERROR( WinGetLastError( Hab ) );
//	sprintf( buf, "%s()ŃG[܂B\nrc=0x%04x", aucAPI, ei );
	strcpy( buf, aucAPI );
	strcat( buf, "()ŃG[܂B\nrc=0x" );
	icat( buf, ei );
	WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, buf, "K-Clock", 0,
					MB_OK | MB_ERROR | MB_SYSTEMMODAL | MB_MOVEABLE);
	longjmp( Jb, 1 );
}


/***************************************************************************
	errQuitDos : Dos`()ŒvIG[N̑Eop
	parm	: (UCHAR*)API, (APIRET)̂Ƃ̕Ԃl
	ret		: (void)킯Ȃ
***************************************************************************/
void
errQuitDos( UCHAR *aucAPI, APIRET rc )
{
	UCHAR	buf[256];

//	sprintf( buf, "%s()ŃG[܂B\nrc=0x%04x", aucAPI, rc );
	strcpy( buf, aucAPI );
	strcat( buf, "()ŃG[܂B\nrc=0x" );
	icat( buf, rc );
	WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, buf, "K-Clock", 0,
					MB_OK | MB_ERROR | MB_SYSTEMMODAL | MB_MOVEABLE);
	longjmp( Jb, 1 );
}


/***************************************************************************
	writeIni : init@Cǂݍ
	parm	: (void)
	ret		: (BOOL)TRUE
***************************************************************************/
void
writeIni()
{
	HINI	hini;
	SWP		swp;
	UCHAR	aucIni[] = {"K-Clock.ini"};
	WinQueryWindowPos( Hwnd, &swp );
	PtlWnd.x = swp.x, PtlWnd.y = swp.y;
	// PrfOpenProfile( Hab, "K-Clock.ini" ) Ƃ͂łȂ̂Œ!!!!!
	hini = PrfOpenProfile( Hab, aucIni );
	PrfWriteProfileData( hini, "01", "PtlWnd", &PtlWnd, sizeof(POINTL) );
	PrfWriteProfileData( hini, "01", "FIdle", &FIdle, sizeof(BOOL) );
	PrfWriteProfileData( hini, "01", "FFloatTop", &FFloatTop, sizeof(BOOL) );
	PrfWriteProfileData( hini, "01", "FlSize", &FlSize, sizeof(ULONG) );
	PrfWriteProfileData( hini, "01", "FlDotBlink", &FlDotBlink, sizeof(ULONG));
	PrfWriteProfileData(hini, "01", "UlSwapLimit", &UlSwapLimit,sizeof(ULONG));
	PrfCloseProfile( hini );
}


/***************************************************************************
	readIni : init@Cǂݍ
	parm	: (void)
	ret		: (BOOL)TRUE
***************************************************************************/
BOOL
readIni()
{
	HINI	hini;
	BOOL	rc;
	ULONG	size;
	HDC		hdcScr;
	HPS		hpsDT;
	UCHAR	aucIni[] = {"K-Clock.ini"};

	hdcScr = GpiQueryDevice (hpsDT = WinGetPS (HWND_DESKTOP));
	DevQueryCaps( hdcScr, CAPS_WIDTH, 1L, &CxDT);
	DevQueryCaps( hdcScr, CAPS_HEIGHT, 1L, &CyDT);
	WinReleasePS( hpsDT );

	// PrfOpenProfile( Hab, "K-Clock.ini" ) Ƃ͂łȂ̂Œ!!!!!
	hini = PrfOpenProfile( Hab, aucIni );
	if ( hini == NULLHANDLE )	errQuitWin( "PrfOpenProfile" );
	size = (ULONG)sizeof(POINTL);
	rc = PrfQueryProfileData( hini, "01", "PtlWnd", &PtlWnd, &size);
	if ( rc==FALSE )	PtlWnd.x = PtlWnd.y = 200;
	size = (ULONG)sizeof(BOOL);
	rc = PrfQueryProfileData( hini, "01", "FIdle", &FIdle, &size);
	if ( rc==FALSE )	FIdle = TRUE;
	size = (ULONG)sizeof(BOOL);
	rc = PrfQueryProfileData( hini, "01", "FFloatTop", &FFloatTop, &size);
	if ( rc==FALSE )	FFloatTop = FALSE;
	size = (ULONG)sizeof(ULONG);
	rc = PrfQueryProfileData( hini, "01", "FlSize", &FlSize, &size);
	if ( rc==FALSE )	FlSize = CS_UNKNOWN;
	size = (ULONG)sizeof(ULONG);
	rc = PrfQueryProfileData( hini, "01", "UlSwapLimit", &UlSwapLimit, &size);
	if ( rc==FALSE )	UlSwapLimit = 0;
	size = (ULONG)sizeof(ULONG);
	rc = PrfQueryProfileData( hini, "01", "FlDotBlink", &FlDotBlink, &size);
	if ( rc==FALSE )	FlDotBlink = 0;
	PrfCloseProfile( hini );
	return( TRUE );
}


/***************************************************************************
	destroyBMP : makeBMP()ō쐬DC,PS,BMPJ
	parm	: (void)
	ret		: (BOOL)TRUE
	rem		: ܂AǂAvZX_ŏɊJ
			  łǂˁcB
***************************************************************************/
BOOL
destroyBMP()
{
	GpiDeleteBitmap( HbmMem );
	GpiDestroyPS( HpsMem );
	DevCloseDC( HdcMem );
	return( TRUE );
}


/***************************************************************************
	makeBMP : \[Xbmp쐬AœWJĂ
	parm	: (void)
	ret		: (BOOL)TRUE
	rem		: 炩 memory PS ɓWJĂƂŁA\XVɂ
			  ̒KvȂ̂]邾ōςނ悤ɂȂB
***************************************************************************/
BOOL
makeBMP()
{
	SIZEL	sizel;
	PBITMAPFILEHEADER2	pbfh2;
	BITMAPINFOHEADER2	bih2;
	long	i, j;
	POINTL	aptl[4];
	APIRET	rc;
	UCHAR	*puc;
	UCHAR	aucBmpInfBuf[ sizeof(BITMAPINFO2) + 4*22 ];
	PBITMAPINFO2	pbi2;
	ULONG	ulID_frame, ulID_time, ulID_mem, ulID_bar, ulID_colon;

	if ( FlSize == CS_UNKNOWN ) {
		if ( CxDT > 800 )	FlSize = CS_LARGE;
		else				FlSize = CS_SMALL;
	}

	if ( FlSize == CS_LARGE ) {
		ulID_frame = RB_FRAME_L;
		ulID_time = RB_DIGIT_M;
		ulID_mem = RB_DIGIT_S;
		ulID_bar = RB_BAR_L;
		ulID_colon = RB_COLON_L;
	}
	else {
		ulID_frame = RB_FRAME_S;
		ulID_time = RB_DIGIT_S;
		ulID_mem = RB_DIGIT_P;
		ulID_bar = RB_BAR_S;
		ulID_colon = RB_COLON_S;
	}

	// memory\u, memory\Ԃ쐬
	{
	DEVOPENSTRUC	dop = { NULL, "DISPLAY", NULL, NULL, NULL, NULL,
							NULL, NULL, NULL };
	HdcMem = DevOpenDC( Hab, OD_MEMORY, "*",
				5L, (PDEVOPENDATA)&dop, NULLHANDLE );
	if ( HdcMem == DEV_ERROR )	errQuitWin( "DevOpenDC" );
	}
	sizel.cx = CX_BUFPS, sizel.cy = CY_BUFPS;
	HpsMem = GpiCreatePS( Hab, HdcMem, &sizel,
			PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC );
	if ( HpsMem == GPI_ERROR )	errQuitWin( "GpiCreatePS" );

	// ۂbitmap쐬AHpsMemɊ蓖ĂB
	// bitmap蓖ĂĂȂƁAGpiDrawBits() etc.͎gȂB
	memset( &bih2, 0, sizeof( BITMAPINFOHEADER2 ) );
	bih2.cbFix = sizeof( BITMAPINFOHEADER2 );
	bih2.cx = CX_BUFPS, bih2.cy = CY_BUFPS;
	bih2.cPlanes = 1;
	// cBitCount = 8ƂƁAȂ PMERR_INSUFFICIENT_MEMORY oVXe
	// B(ʂ256F\łĂB)
//	bih2.cBitCount = 8;
	bih2.cBitCount = 4;
	HbmMem = GpiCreateBitmap( HpsMem, &bih2, 0L, NULL, NULL );
	if ( HbmMem == GPI_ERROR )	errQuitWin( "GpiCreateBitmap" );
	{
	HBITMAP	hbm;
	hbm = GpiSetBitmap( HpsMem, HbmMem );
	if ( hbm == HBM_ERROR ) {
		// ȏ͕Kv? łA"GpiDel.B.(GpiSetB.())"Ƃ
		// PMERR_HBITMAP_BUSYôŁAÔ߁B
		DosSleep( 50 );
		hbm = GpiSetBitmap( HpsMem, HbmMem );
		if ( hbm == HBM_ERROR ) errQuitWin( "GpiSetBitmap" );
	}
	}

	// gpep[c̈ʒuATCY
	FpTime.ptlSrcTop.x = 0, FpTime.ptlSrcTop.y = 80;
	FpMem1.ptlSrcTop.x = 0, FpMem1.ptlSrcTop.y = 120;
	FpMem2.ptlSrcTop.x = 0, FpMem2.ptlSrcTop.y = 140;
	FpColon.ptlSrcTop.x = 200, FpColon.ptlSrcTop.y = 0;
	FpBar.ptlSrcTop.x = 0, FpBar.ptlSrcTop.y = 160;
	FpBlank.ptlSrcTop.x = 240, FpBlank.ptlSrcTop.y = 0;

	// t[ǂݍ
	rc = DosGetResource( NULLHANDLE, RAWBITMAP, ulID_frame, (PPVOID)&pbfh2 );
	if ( rc != NO_ERROR ) {
		DosBeep( 1000, 50 );
		DosSleep( 100 );
		rc = DosGetResource(NULLHANDLE, RAWBITMAP, ulID_frame, (PPVOID)&pbfh2);
		if ( rc != NO_ERROR )	errQuitDos( "DosGetResource", rc );
	}
	aptl[2].x = aptl[2].y = 0;
	SzlFrame.cx = aptl[3].x = pbfh2->bmp2.cx;
	SzlFrame.cy = aptl[3].y = pbfh2->bmp2.cy;
	aptl[0].x = 0, aptl[0].y = 0;
	aptl[1].x = aptl[0].x + aptl[3].x - 1;
	aptl[1].y = aptl[0].y + aptl[3].y - 1;
	i = GpiDrawBits( HpsMem, ((BYTE*)pbfh2 + pbfh2->offBits),
			(PBITMAPINFO2)&(pbfh2->bmp2), 4, aptl, ROP_SRCCOPY, BBO_IGNORE );
	if ( i == GPI_ERROR ) {
		DosBeep( 1000, 50 );
		DosSleep( 100 );
		i = GpiDrawBits( HpsMem, ((BYTE*)pbfh2 + pbfh2->offBits),
			(PBITMAPINFO2)&(pbfh2->bmp2), 4, aptl, ROP_SRCCOPY, BBO_IGNORE );
		if ( i == GPI_ERROR )	errQuitWin( "GpiDrawBits" );
	}

	// (M)쐬
	DosGetResource( NULLHANDLE, RAWBITMAP, ulID_time, (PPVOID)&pbfh2 );
	aptl[3].x = pbfh2->bmp2.cx, aptl[3].y = pbfh2->bmp2.cy;
	FpTime.ptlFont = aptl[3];
	FpTime.lShift = aptl[3].x * 10, FpTime.lHalf = aptl[3].x * 20;
	aptl[2].x = aptl[2].y = 0;
	puc = (UCHAR*)&(pbfh2->bmp2) + pbfh2->bmp2.cbFix;
	memcpy( aucBmpInfBuf, &(pbfh2->bmp2), sizeof(aucBmpInfBuf) );
	pbi2 = (PBITMAPINFO2)aucBmpInfBuf;
	for ( i = 0; i < 21; i++ ) {
		ULONG	ul = AulDigFont[i];
		RGB2	*prgb2 = &(pbi2->argbColor[1]);
		for ( j = 0; j < 7; j++ ) {
			if ( ul & 2 ) {
				*prgb2++ = Argb2DigNrm[0], *prgb2++ = Argb2DigNrm[1];
				*prgb2++ = Argb2DigNrm[2];
			}
			else if ( ul & 1 ) {
				*prgb2++ = Argb2DigNrm[2], *prgb2++ = Argb2DigNrm[3];
				*prgb2++ = Rgb2DigBlk;
			}
			else {
				*prgb2++ = Rgb2DigBlk, *prgb2++ = Rgb2DigBlk;
				*prgb2++ = Rgb2DigBlk;
			}
			ul >>= 4;
		}
		// aptl[0]:ʐ̍, aptl[1]:ʐ̉E
		// aptl[0]:ʌ̍, aptl[2]:ʌ̕ʗ̈̃TCY!!!!!
		aptl[0].x = i * FpTime.ptlFont.x, aptl[0].y = FpTime.ptlSrcTop.y;
		aptl[1].x = aptl[0].x + aptl[3].x - 1;
		aptl[1].y = aptl[0].y + aptl[3].y - 1;
		GpiDrawBits( HpsMem, ((BYTE*)pbfh2 + pbfh2->offBits),
			pbi2, 4, aptl, ROP_SRCCOPY, BBO_IGNORE );
	}

	// (S)쐬
	DosGetResource( NULLHANDLE, RAWBITMAP, ulID_mem, (PPVOID)&pbfh2 );
	aptl[3].x = pbfh2->bmp2.cx, aptl[3].y = pbfh2->bmp2.cy;
	FpMem1.ptlFont = FpMem2.ptlFont = aptl[3];
	FpMem1.lShift = FpMem2.lShift = aptl[3].x * 10;
	FpMem1.lHalf = FpMem2.lHalf = aptl[3].x * 20;
	aptl[2].x = aptl[2].y = 0;
	puc = (UCHAR*)&(pbfh2->bmp2) + pbfh2->bmp2.cbFix;
	memcpy( aucBmpInfBuf, &(pbfh2->bmp2), sizeof(aucBmpInfBuf) );
	pbi2 = (PBITMAPINFO2)aucBmpInfBuf;
	for ( i = 0; i < 21; i++ ) {
		ULONG	ul = AulDigFont[i];
		RGB2	*prgb2 = &(pbi2->argbColor[1]);
		for ( j = 0; j < 7; j++ ) {
			if ( ul & 2 ) {
				*prgb2++ = Argb2DigGrn[0], *prgb2++ = Argb2DigGrn[1];
				*prgb2++ = Argb2DigGrn[2];
			}
			else if ( ul & 1 ) {
				*prgb2++ = Argb2DigGrn[2], *prgb2++ = Argb2DigGrn[3];
				*prgb2++ = Rgb2DigBlk;
			}
			else {
				*prgb2++ = Rgb2DigBlk, *prgb2++ = Rgb2DigBlk;
				*prgb2++ = Rgb2DigBlk;
			}
			ul >>= 4;
		}
		// aptl[0]:ʐ̍, aptl[1]:ʐ̉E
		// aptl[0]:ʌ̍, aptl[2]:ʌ̕ʗ̈̃TCY!!!!!
		aptl[0].x = i * FpMem1.ptlFont.x, aptl[0].y = FpMem1.ptlSrcTop.y;
		aptl[1].x = aptl[0].x + aptl[3].x - 1;
		aptl[1].y = aptl[0].y + aptl[3].y - 1;
		GpiDrawBits( HpsMem, ((BYTE*)pbfh2 + pbfh2->offBits),
			pbi2, 4, aptl, ROP_SRCCOPY, BBO_IGNORE );
	}
	for ( i = 0; i < 21; i++ ) {
		ULONG	ul = AulDigFont[i];
		RGB2	*prgb2 = &(pbi2->argbColor[1]);
		for ( j = 0; j < 7; j++ ) {
			if ( ul & 2 ) {
				*prgb2++ = Argb2DigRed[0];
				*prgb2++ = Argb2DigRed[1];
				*prgb2++ = Argb2DigRed[2];
			}
			else if ( ul & 1 ) {
				*prgb2++ = Argb2DigRed[2], *prgb2++ = Argb2DigRed[3];
				*prgb2++ = Rgb2DigBlk;
			}
			else {
				*prgb2++ = Rgb2DigBlk;
				*prgb2++ = Rgb2DigBlk;
				*prgb2++ = Rgb2DigBlk;
			}
			ul >>= 4;
		}
		// aptl[0]:ʐ̍, aptl[1]:ʐ̉E
		// aptl[0]:ʌ̍, aptl[2]:ʌ̕ʗ̈̃TCY!!!!!
		aptl[0].x = i * FpMem2.ptlFont.x, aptl[0].y = FpMem2.ptlSrcTop.y;
		aptl[1].x = aptl[0].x + aptl[3].x - 1;
		aptl[1].y = aptl[0].y + aptl[3].y - 1;
		GpiDrawBits( HpsMem, ((BYTE*)pbfh2 + pbfh2->offBits),
			pbi2, 4, aptl, ROP_SRCCOPY, BBO_IGNORE );
	}

	// _Otǂݍ
	DosGetResource( NULLHANDLE, RAWBITMAP, ulID_bar, (PPVOID)&pbfh2 );
	aptl[2].x = aptl[2].y = 0;
	aptl[3].x = pbfh2->bmp2.cx, aptl[3].y = pbfh2->bmp2.cy;
	FpBar.ptlFont = aptl[3], FpBar.ptlFont.x /= 24;
	FpBar.lShift = FpBar.ptlFont.x * 8;
	FpBar.lHalf = FpBar.ptlFont.x * 16;
	aptl[0] = FpBar.ptlSrcTop;
	aptl[1].x = aptl[0].x + aptl[3].x - 1;
	aptl[1].y = aptl[0].y + aptl[3].y - 1;
	GpiDrawBits( HpsMem, ((BYTE*)pbfh2 + pbfh2->offBits),
			(PBITMAPINFO2)&(pbfh2->bmp2), 4, aptl, ROP_SRCCOPY, BBO_IGNORE );

	// Rǂݍ
	DosGetResource( NULLHANDLE, RAWBITMAP, ulID_colon, (PPVOID)&pbfh2 );
	aptl[2].x = aptl[2].y = 0;
	aptl[3].x = pbfh2->bmp2.cx, aptl[3].y = pbfh2->bmp2.cy;
	FpColon.ptlFont = aptl[3], FpColon.ptlFont.x /= 3;
	FpColon.lShift = FpColon.ptlFont.x, FpColon.lHalf = FpColon.ptlFont.x * 2;
	aptl[0] = FpColon.ptlSrcTop;
	aptl[1].x = aptl[0].x + aptl[3].x - 1;
	aptl[1].y = aptl[0].y + aptl[3].y - 1;
	GpiDrawBits( HpsMem, ((BYTE*)pbfh2 + pbfh2->offBits),
			(PBITMAPINFO2)&(pbfh2->bmp2), 4, aptl, ROP_SRCCOPY, BBO_IGNORE );

	if ( FlSize == CS_LARGE ) {
		PtlHour.x = PtlHour.y = 10;
		PtlColon = PtlHour, PtlColon.x += FpTime.ptlFont.x * 2;
		PtlMin = PtlColon, PtlMin.x += FpColon.ptlFont.x;
		PtlMem.x = 101, PtlMem.y = 48;
		PtlBar.x = 10, PtlBar.y = 55;
	}
	else {
		PtlHour.x = PtlHour.y = 6;
		PtlColon = PtlHour, PtlColon.x += FpTime.ptlFont.x * 2;
		PtlMin = PtlColon, PtlMin.x += FpColon.ptlFont.x;
		PtlMem.x = 54, PtlMem.y = 26;
		PtlBar.x = 6, PtlBar.y = 29;
	}

	allHalftone();

	return( TRUE );
}


/***************************************************************************
	allHalftone : S\n[tg[
	parm	: (void)
	ret		: (void)
	rem		: ł͕\pobt@ɓ]邾Ȃ̂ŁAʓrʕ\̂߂
			  ƂKvBƂÅ֐͕\O1񂾂Ă΂̂B
***************************************************************************/
void
allHalftone( void )
{
	POINTL	aptl[3];
	ULONG	i;

	aptl[0] = PtlHour;
	aptl[2] = FpTime.ptlSrcTop, aptl[2].x += FpTime.lHalf;
	for ( i = 0; i < 2; i++ ) {
		aptl[1].x = aptl[0].x + FpTime.ptlFont.x;
		aptl[1].y = aptl[0].y + FpTime.ptlFont.y;
		GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
		aptl[0].x = aptl[1].x;
	}
	aptl[1].x = aptl[0].x + FpColon.ptlFont.x;
	aptl[1].y = aptl[0].y + FpColon.ptlFont.y;
	aptl[2] = FpColon.ptlSrcTop, aptl[2].x += FpColon.lHalf;
	GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
	aptl[0].x = aptl[1].x;
	aptl[2] = FpTime.ptlSrcTop, aptl[2].x += FpTime.lHalf;
	for ( i = 0; i < 2; i++ ) {
		aptl[1].x = aptl[0].x + FpTime.ptlFont.x;
		aptl[1].y = aptl[0].y + FpTime.ptlFont.y;
		GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
		aptl[0].x = aptl[1].x;
	}
	aptl[0] = PtlBar;
	aptl[1].x = aptl[0].x + FpBar.ptlFont.x * 8;
	aptl[1].y = aptl[0].y + FpBar.ptlFont.y;
	aptl[2] = FpBar.ptlSrcTop, aptl[2].x += FpBar.lHalf;
	GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );

	aptl[0] = PtlMem;
	aptl[2] = FpMem1.ptlSrcTop, aptl[2].x += FpMem1.lHalf;
	for ( i = 0; i < 3; i++ ) {
		aptl[1].x = aptl[0].x + FpMem1.ptlFont.x;
		aptl[1].y = aptl[0].y + FpMem1.ptlFont.y;
		GpiBitBlt( HpsMem, HpsMem, 3, aptl, ROP_SRCCOPY, 0 );
		aptl[0].x = aptl[1].x;
	}
}


/***************************************************************************
	querySwapPath : SWAPPER.DAT̈ʒu擾
	parm	: (char*) SWAPPER.DAT  full path Ė߂
	ret		: (ULONG) A: = 1 ƂƂ́ASWAPPER.DAT̂hCu
***************************************************************************/
ULONG
querySwapPath( char *szSwapFile )
{
	APIRET	rc;
	ULONG	ulSwapDrv, ul;
	ULONG	ulOpenMode;
	HFILE	hf;
	FILESTATUS3	*pfs3;
	char	szConfigsys[13];
	char	*pc, *pc2, *pcTar, *pcNext;
	char	*pcBuf;
	FILESTATUS3	fs3;

	rc = DosQuerySysInfo( QSV_BOOT_DRIVE, QSV_BOOT_DRIVE,
									&ul, sizeof(ULONG) );
	*szConfigsys = ul + 'A' - 1;
	strcpy( szConfigsys + 1, ":\\CONFIG.SYS" );

	DosQueryPathInfo( szConfigsys, FIL_STANDARD,
											&fs3, sizeof(fs3) );
	DosAllocMem( &pcBuf, fs3.cbFile + 3,
		PAG_READ | PAG_WRITE | PAG_COMMIT | OBJ_TILE );
	memset( pcBuf, 0, fs3.cbFile + 3 );

	ulOpenMode = OPEN_ACCESS_READONLY | OPEN_SHARE_DENYWRITE
				 | OPEN_FLAGS_FAIL_ON_ERROR | OPEN_FLAGS_SEQUENTIAL
				 | OPEN_FLAGS_NOINHERIT;
	rc = DosOpen( szConfigsys, &hf, &ul, 0L, 0L, OPEN_ACTION_OPEN_IF_EXISTS,
					ulOpenMode, NULL );
	if ( rc != NO_ERROR ) {
		DosFreeMem( pcBuf );
		return( 0 );
	}
	DosRead( hf, pcBuf, fs3.cbFile, &ul );
	DosClose( hf );

	pcNext = pcBuf; 
	for (;;){
		pcTar = pc = pcNext;
		ul = 0;
		while ( *pc != 0x0a && *pc != '\0' )	pc++, ul++;
		if ( *pc == '\0' && ul == 0 )	break;
		*pc = '\0';
		pcNext = pc+1;
		pc = pcTar;
		while ( *pc == ' ' || *pc == '\t' )	pc++;
		if ( (ULONG)pc - (ULONG)pcTar + 9 < ul ) {
			pc[8] = '\0';
			if ( stricmp( pc, "SWAPPATH" ) == 0 ){
				pc += 9;
				while ( *pc == ' ' || *pc == '=' )	pc++;
				pc2 = pc;
				while ( *pc != ' ' && *pc != '\0' )	pc++;
				*pc = '\0';
				strcpy( szSwapFile, pc2 );
				if ( pc[-1] != '\\' )	strcat(szSwapFile,"\\swapper.dat");
				else					strcat( szSwapFile, "swapper.dat");
				ulSwapDrv = (ULONG)(*szSwapFile - 'A' + 1 );
				if ( ulSwapDrv > 26 )
					ulSwapDrv = (ULONG)(*szSwapFile - 'a' + 1 );
				break;
			}
		}
	}
	DosClose( hf );
	DosFreeMem( pcBuf );

	return( ulSwapDrv );
}



/***************************************************************************
	timerTread : vAׁALgpʑE\XVbZ[WM
	parm	: (void)
	ret		: (void)
	rem		: v̂߂ɕʃXbhETime-Critical classœ삷B
			  ^C}[ɂ 0.5s 1񓮍삷
***************************************************************************/
void
timerThread()
{
	APIRET	rc;
	HTIMER	htm;
	ULONG	ul;
	ULONG	ulLoop = 1;
	DATETIME	dt;
	UCHAR	ucS, ucM, ucH;
	ULONG	ulcUsedMem;
	ULONG	ulSwapDrv, ulcPhysMem, ulcAvailMem, ulcSwapDrvFree;
	ULONG	ulcSwapFile, ulcSwapFileBef;
	char	szSwapFile[CCHMAXPATH];
	FILESTATUS3	*pfs3;
	union {	SHOWINFO si; ULONG ul; } usi;
	union {	CHGINFO ci;  ULONG ul; } uci;
	BOOL	fTimeChg;
	ULONG	ulLoadBef = 0;
	UCHAR	acBuf[256];

	// timer p event semaphore
	rc = DosCreateEventSem( NULL, &HevTime, DC_SEM_SHARED, FALSE );

	ulSwapDrv = querySwapPath( szSwapFile );
	rc = DosQuerySysInfo( QSV_TOTPHYSMEM, QSV_TOTPHYSMEM,
									&ulcPhysMem, sizeof(ULONG) );
	pfs3 = (FILESTATUS3*)acBuf;
	rc = DosQueryPathInfo( szSwapFile, FIL_STANDARD, acBuf, sizeof(acBuf));
	ulcSwapFileBef = pfs3->cbFile;

	// xx.00b(ɋ߂)Ƀ^C}[n
	DosGetDateTime( &dt );
	DosSleep( ( 100 - dt.hundredths)*10 + 500 );
	rc = DosStartTimer( 500, HevTime, &htm );
	DosSleep( 10 );

	// timernOɂĂ܂ƁAǂ킯ԊuZȂĂ܂̂ŁA
	// timernTime-Critical class Ɉڍs
	DosSetPriority( PRTYS_THREAD, PRTYC_TIMECRITICAL, -31, 0 );

	// āAn[tg[Ԃ̕\𒷈Ă킯łB
	DosWaitEventSem( HevTime, SEM_INDEFINITE_WAIT );
	DosResetEventSem( HevTime, &ul );
	UlCount = 0;
	DosGetDateTime( &dt );
	usi.ul = uci.ul = 0;
	uci.ci.dot = uci.ci.hour10 = uci.ci.hour1 = uci.ci.min10 = uci.ci.min1 = 1;
	usi.si.dot = 0, 
	usi.si.hour10 = dt.hours / 10;
	usi.si.hour1 = dt.hours % 10;
	usi.si.min10 = dt.minutes / 10;
	usi.si.min1 = dt.minutes % 10;
	ucS = dt.seconds, ucM = dt.minutes, ucH = dt.hours;
	WinPostMsg( Hwnd, WM_SHOWINFO, MPFROMLONG(uci.ul), MPFROMLONG(usi.ul) );

	// C[v
	for ( ;; ) {
		DosWaitEventSem( HevTime, SEM_INDEFINITE_WAIT );
		DosResetEventSem( HevTime, &ul );
		usi.ul = uci.ul = 0;
		uci.ci.load = 1;
		ul = 8 - UlCount;
		if ( ul > 8 )	ul = 0;
		usi.si.load = (ul + ulLoadBef)/2;
		ulLoadBef = ul;
		UlCount = 0;
		if ( FFlush ) {
			ulLoop = 1;
			ucS = ucM = ucH = 255;
			FFlush = FALSE;
		}

		if ( (ulLoop & 1) == 0 ) {
			uci.ci.dot = 1, usi.si.dot = FlDotBlink;
		}
		else {
//			usi.ul = uci.ul = 0;
			uci.ci.dot = 1, usi.si.dot = 1;

			rc = DosQuerySysInfo( QSV_TOTAVAILMEM, QSV_TOTAVAILMEM,
										&ulcAvailMem, sizeof(ULONG) );
			rc = DosQueryFSInfo( ulSwapDrv, FSIL_ALLOC, acBuf, 40 );
			ulcSwapDrvFree = *(ULONG*)(&acBuf[4]) * *(ULONG*)(&acBuf[12])
								* *(USHORT*)(&acBuf[16]);
			rc = DosQueryPathInfo( szSwapFile, FIL_STANDARD,
											acBuf, sizeof(acBuf));
			ulcSwapFile = pfs3->cbFile;
			ulcUsedMem = ulcSwapDrvFree + ulcSwapFile + ulcPhysMem;
			if ( ulcUsedMem > (512<<20) )	ulcUsedMem = 512<<20;
			ulcUsedMem -= ulcAvailMem;
			uci.ci.mem = 1;
			usi.si.mem = ulcUsedMem>>20;
			if ( UlSwapLimit != 0 ) {
				if ( UlSwapLimit < ulcSwapFile ) usi.si.mem |= 512;
			}
			else if ( ulcSwapFileBef < ulcSwapFile ) usi.si.mem |= 512;
			ulcSwapFileBef = ulcSwapFile;

			fTimeChg = FALSE;
			DosGetDateTime( &dt );
			if ( ucS != dt.seconds )	ucS = dt.seconds;
			if ( ucM != dt.minutes ) {
				fTimeChg = TRUE;
				if ( ucM = 255 ) {
					usi.si.min1 = dt.minutes%10 + 10;
					usi.si.min10 = dt.minutes/10 + 8;
					uci.ci.min1 = uci.ci.min10 = 1;
				}
				else {
					if ( ucM%10 != dt.minutes%10 ) {
						usi.si.min1 = dt.minutes%10 + 10;
						uci.ci.min1 = 1;
					}
					if ( ucM/10 != dt.minutes/10 ) {
						usi.si.min10 = dt.minutes/10 + 8;
						uci.ci.min10 = 1;
					}
				}
				ucM = dt.minutes;
			}
			if ( ucH != dt.hours ) {
				fTimeChg = TRUE;
				if ( ucH == 255 ) {
					usi.si.hour1 = dt.hours%10 + 10;
					usi.si.hour10 = dt.hours/10 + 4;
					uci.ci.hour1 = uci.ci.hour10 = 1;
				}
				else {
					if ( ucH%10 != dt.hours%10 ) {
						usi.si.hour1 = dt.hours%10 + 10;
						uci.ci.hour1 = 1;
					}
					if ( ucH/10 != dt.hours/10 ) {
						usi.si.hour10 = dt.hours/10 + 4;
						uci.ci.hour10 = 1;
					}
				}
				ucH = dt.hours;
			}
		// c\̂߂Ɂc
			if ( fTimeChg ) {
				WinPostMsg( Hwnd, WM_SHOWINFO,
						MPFROMLONG(uci.ul), MPFROMLONG(usi.ul) );
				DosSleep( 150 );
				usi.si.min1 -= 10;
				usi.si.min10 -= 8;
				usi.si.hour1 -= 10;
				usi.si.hour10 -= 4;
				uci.ci.dot = 0;
			}
		}
		WinPostMsg( Hwnd, WM_SHOWINFO,
				MPFROMLONG(uci.ul), MPFROMLONG(usi.ul) );
		ulLoop++;
	}
}


/***************************************************************************
	chkLoadThread : ׌v
	parm	: (void)
	ret		: (void)
	rem		: ^C}[ɂ 60ms(63ms) 1񓮍삷B
			  s˂񐔂ŁAׂ𑪒肷B
***************************************************************************/
void
chkLoadThread()
{
	HEV		hev;
	HTIMER	htm;
	APIRET	rc;
	ULONG	ul;

	// load p event semaphore
	rc = DosCreateEventSem( NULL, &hev, DC_SEM_SHARED, FALSE );
	rc = DosStartTimer( 60, hev, &htm );

	if ( FIdle )	DosSetPriority( PRTYS_THREAD, PRTYC_IDLETIME, -31, 0 );

	for ( ;; ) {
		DosWaitEventSem( hev, SEM_INDEFINITE_WAIT );
		DosResetEventSem( hev, &ul );
		UlCount++;
	}
}

