#include<os2.h>
#include"sintable.h"
#include<math.h>
#include<stdio.h>

#define RADIOUS_LARGE	0.06
#define RADIOUS_SMALL	0.02
#define R	(1.0-RADIOUS_LARGE)

#define GAP 3

#define M_PI 3.14159265358979323846

extern "C"{
#include"Module.h"
struct Analog{
    int		oldMin, oldHour;
    LONG	colorShadow, ptnShadow;
    LONG	colorCircle, lcolorCircle, ptnCircle;
    LONG	colorNeedle, lcolorNeedle, ptnNeedle;
    };

// TƂ̑傫

void drawCircles
	( HPS hps, ULONG orgX, ULONG orgY, ULONG half, LONG dro )
{
    for( int i=0; i<60; i+=5 ){
	POINTL pt;
	LONG r = (LONG)((float)half * R);
	pt.x = (ULONG)((LONG)(r * Cos[i])>>16) + orgX;
	pt.y = (ULONG)((LONG)(r * Sin[i])>>16) + orgY;
	GpiMove( hps, &pt );
	float a = half * RADIOUS_LARGE;
	GpiFullArc( hps, dro, ((ULONG)a)<<16 );
	}
};


// PƂ̓_
void drawDots
	( HPS hps, ULONG orgX, ULONG orgY, ULONG half, LONG dro )
{
    for( int i=0; i<60; i++ ){
	if( i%5 == 0 ) continue;
	POINTL pt;
	LONG r = (LONG)((float)half * R);
	pt.x = (ULONG)((LONG)(r * Cos[i])>>16) + orgX;
	pt.y = (ULONG)((LONG)(r * Sin[i])>>16) + orgY;
	GpiMove( hps, &pt );
	float a = half * RADIOUS_SMALL;
	GpiFullArc( hps, dro, ((ULONG)a)<<16 );
	}
};


void rotate
	( const POLYGON& src, POLYGON& dest,
	  double orgX, double orgY, double magnify, double min )
{
    double Sin = sin( M_PI*min/30.0 );
    double Cos = cos( M_PI*min/30.0 );

    dest.ulPoints = src.ulPoints;
    for( int i=0; i<src.ulPoints; i++ ){
	double x, y;
	x = magnify * src.aPointl[i].x;
	y = magnify * src.aPointl[i].y;
	dest.aPointl[i].x = (ULONG)(  x * Cos + y * Sin + orgX);
	dest.aPointl[i].y = (ULONG)( -x * Sin + y * Cos + orgY);
	}
};


// j
#define LNDL_POINTS 5	// j`̓_
#define SNDL_POINTS 5	// Zj`̓_
const static POINTL needleL[LNDL_POINTS] = {	// j
	{  0, 100 },
	{ -8, 0 },
	{  0,-20 },
	{  8, 0 },
	{  0, 100 }
	};
const static POLYGON ndlL = { LNDL_POINTS, needleL };

const static POINTL needleS[LNDL_POINTS] = {	// Zj
	{  0, 70 },
	{ -10, 0 },
	{  0,-15 },
	{  10, 0 },
	{  0, 70 }
	};
const static  POLYGON ndlS = { SNDL_POINTS, needleS };

void drawNeedle
	( HPS hps, ULONG orgX, ULONG orgY, ULONG half, 
	  ModuleInfo* info, BOOL real )
{
    POINTL rotNeedleL[LNDL_POINTS];
    POLYGON rotNdlL;
    rotNdlL.aPointl = rotNeedleL;
    POINTL rotNeedleS[SNDL_POINTS];
    POLYGON rotNdlS;
    rotNdlS.aPointl = rotNeedleS;

    double hour = info->datetime.hours;
    double min = info->datetime.minutes;

    // ]̍W𓾂
    rotate( ndlS, rotNdlS,
	(double)orgX, (double)orgY, (double)half/100.0, 
	hour*5.0 + min/12.0 );
    rotate( ndlL, rotNdlL,
	(double)orgX, (double)orgY, (double)half/100.0,
	min );

    // Zj`
    GpiMove( hps, rotNdlS.aPointl );
    rotNdlS.ulPoints--;
    rotNdlS.aPointl++;
    if( real ){
	GpiSetPattern ( hps, ((Analog*)info->buffer)->ptnShadow ) ;
	GpiSetColor( hps, ((Analog*)info->buffer)->colorNeedle );
	GpiPolygons( hps, 1, &rotNdlS, POLYGON_BOUNDARY, POLYGON_INCL );
	GpiSetColor( hps, ((Analog*)info->buffer)->lcolorNeedle );
	GpiPolyLine( hps, rotNdlS.ulPoints, rotNdlS.aPointl );
    }else{
	GpiSetPattern ( hps, ((Analog*)info->buffer)->ptnShadow ) ;
	GpiSetColor( hps, ((Analog*)info->buffer)->colorShadow );
	GpiPolygons( hps, 1, &rotNdlS, POLYGON_BOUNDARY, POLYGON_INCL );
	}

    // j`
    GpiMove( hps, rotNdlL.aPointl );
    rotNdlL.ulPoints--;
    rotNdlL.aPointl++;
    if( real ){
	GpiSetPattern ( hps, ((Analog*)info->buffer)->ptnNeedle ) ;
	GpiSetColor( hps, ((Analog*)info->buffer)->colorNeedle );
	GpiPolygons( hps, 1, &rotNdlL, POLYGON_BOUNDARY, POLYGON_INCL );
	GpiSetColor( hps, ((Analog*)info->buffer)->lcolorNeedle );
	GpiPolyLine( hps, rotNdlL.ulPoints, rotNdlL.aPointl );
    }else{
	GpiSetPattern ( hps, ((Analog*)info->buffer)->ptnShadow ) ;
	GpiSetColor( hps, ((Analog*)info->buffer)->colorShadow );
	GpiPolygons( hps, 1, &rotNdlL, POLYGON_BOUNDARY, POLYGON_INCL );
	}
};


ULONG  PC2drawTime( HPS hps, ModuleInfo* minfo )
{
    ULONG x1, y1, x2, y2, half, orgX, orgY;
    // Shadow
    x1 = GAP;	y1 = 0;
    x2 = minfo->width;	y2 = minfo->height - GAP;
    orgX = (x1+x2)>>1;	orgY = (y1+y2)>>1;
    half = (minfo->width<minfo->height) ?
	(minfo->width-GAP) >> 1 : (minfo->height-GAP) >> 1;
    GpiSetLineType( hps, LINETYPE_INVISIBLE );
    GpiSetLineWidth( hps, LINEWIDTH_NORMAL );
    GpiSetPattern ( hps, ((Analog*)minfo->buffer)->ptnShadow ) ;
    GpiSetColor( hps, ((Analog*)minfo->buffer)->colorShadow );
    drawCircles( hps, orgX, orgY, half, DRO_OUTLINEFILL );
    drawNeedle( hps, orgX, orgY, half, minfo, FALSE );

    // Real
    x1 = 0;	y1 = GAP;
    x2 = minfo->width-GAP;	y2 = minfo->height;
    orgX = (x1+x2)>>1;	orgY = (y1+y2)>>1;
    half = (minfo->width<minfo->height) ?
	(minfo->width-GAP) >> 1 : (minfo->height-GAP) >> 1;
    GpiSetLineType( hps, LINETYPE_SOLID );
    GpiSetLineWidth( hps, LINEWIDTH_NORMAL );
    GpiSetPattern ( hps, ((Analog*)minfo->buffer)->ptnCircle );
    GpiSetColor( hps, ((Analog*)minfo->buffer)->colorCircle );
    drawCircles( hps, orgX, orgY, half, DRO_OUTLINEFILL );
    drawDots( hps, orgX, orgY, half, DRO_OUTLINEFILL );
    GpiSetColor( hps, ((Analog*)minfo->buffer)->lcolorCircle );
    drawCircles( hps, orgX, orgY, half, DRO_OUTLINE );
    drawDots( hps, orgX, orgY, half, DRO_OUTLINE );
    drawNeedle( hps, orgX, orgY, half, minfo, TRUE );

    return 0;
};


ULONG PC2trigger( ModuleInfo* minfo )
{
    Analog* inf = (Analog*)(minfo->buffer);
    int oldMin = inf->oldMin;
    int oldHour = inf->oldHour;
    int min = minfo->datetime.minutes;
    int hour = minfo->datetime.hours;
    if( oldMin != min || oldHour != hour ){
	inf->oldMin = min;
	inf->oldHour = hour;
	return TRG_CALLDRAW;
	}

    return 0;
};


ULONG PC2init( HINI hini, ModuleInfo* minfo )
{
    Analog* analog = (Analog*)(minfo->buffer);
    int i[4];
    char string[1024];

    analog->colorShadow = CLR_BLACK;
    analog->ptnShadow = PATSYM_HALFTONE;

    analog->colorCircle = CLR_PALEGRAY;
    analog->lcolorCircle = CLR_BLACK;
    analog->ptnCircle = PATSYM_SOLID;

    analog->colorNeedle = CLR_PALEGRAY;
    analog->lcolorNeedle = CLR_BLACK;
    analog->ptnNeedle = PATSYM_HALFTONE;

    // e̐F
    PrfQueryProfileString(
	hini, "Dial1.0", "Shadow", "", string, 1024 );
    if( sscanf( string, "%d %d", i, i+1 ) == 2 ){
	analog->colorShadow = i[0];
	analog->ptnShadow = i[1];
	}

    // ڐ̐F
    PrfQueryProfileString(
	hini, "Dial1.0", "Circle", "", string, 1024 );
    if( sscanf( string, "%d %d %d", i, i+1, i+2 ) == 3 ){
	analog->colorCircle = i[0];
	analog->lcolorCircle = i[1];
	analog->ptnCircle = i[2];
	}

    // j̐F
    PrfQueryProfileString(
	hini, "Dial1.0", "Needle", "", string, 1024 );
    if( sscanf( string, "%d %d %d", i, i+1, i+2 ) == 3 ){
	analog->colorNeedle = i[0];
	analog->lcolorNeedle = i[1];
	analog->ptnNeedle = i[2];
	}

    // \ʒu
    PrfQueryProfileString(
	hini, "Dial1.0", "WinPostion", "0 0 150 150", string, 1024 );
    if( sscanf( string, "%d %d %d %d", i, i+1, i+2, i+3 ) == 4 ){
	WinSetWindowPos(
	    minfo->hwndFrame,
	    HWND_TOP,
	    i[0], i[1], i[2], i[3],
	    SWP_NOADJUST | SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ZORDER);
	}
};


ULONG PC2saveSettings( HINI hini, ModuleInfo* minfo )
{
    char string[1024];
    Analog* analog = (Analog*)(minfo->buffer);

    // e̐F
    sprintf( string, "%d %d",
	(int)analog->colorShadow, (int)analog->ptnShadow );
    PrfWriteProfileString(
	hini, "Dial1.0", "Shadow", string );

    // ڐ̐F
    sprintf( string, "%d %d %d",
      (int)analog->colorCircle, (int)analog->lcolorCircle,
      (int)analog->ptnCircle );
    PrfWriteProfileString(
	hini, "Dial1.0", "Circle", string );

    // j̐F
    sprintf( string, "%d %d %d",
      (int)analog->colorNeedle, (int)analog->lcolorNeedle,
      (int)analog->ptnNeedle );
    PrfWriteProfileString(
	hini, "Dial1.0", "Needle", string );

    // \ʒu
    SWP swp;
    WinQueryWindowPos( minfo->hwndFrame, &swp );
    sprintf( string, "%d %d %d %d",
	(int)swp.x, (int)swp.y, (int)swp.cx, (int)swp.cy );
    PrfWriteProfileString(
	hini, "Dial1.0", "WinPostion", string );
};


ULONG PC2terminate( ModuleInfo* minfo )
{
    return 0;
};


MRESULT APIENTRY PC2ModuleProcedure
    ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    switch( msg ){
    case MDL_ID:
      return MRFROMP( MDLID_V100 );

    case MDL_TITLE:
      return MRFROMP( "WAiOv" );

    case MDL_INIT:
      return MRFROMLONG(
	PC2init( LONGFROMMP(mp1), (ModuleInfo*)PVOIDFROMMP(mp2) ) );

    case MDL_TERMINATE:
      return MRFROMLONG( PC2terminate( (ModuleInfo*)PVOIDFROMMP(mp1) ) );

    case MDL_SAVESETTINGS:
      return MRFROMLONG(
        PC2saveSettings(LONGFROMMP(mp1),(ModuleInfo*)PVOIDFROMMP(mp2)) );

    case MDL_DRAW:
      return MRFROMLONG(
        PC2drawTime( LONGFROMMP(mp1), (ModuleInfo*)PVOIDFROMMP(mp2 ) ) );

    case MDL_TRIGGER:
      return MRFROMLONG( PC2trigger( (ModuleInfo*)PVOIDFROMMP(mp1) ) );
    }

    return 0;
  }

// End of extern"C"
}
