#include "BMP.h"
#include "PC2.h"
#include "defines.h"
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


BMP :: BMP( HAB hab, unsigned char* filename )
{
    this->hdc = NULLHANDLE;
    this->hps = NULLHANDLE;
    this->w = this->h = 0;

    this->read( hab, filename );
}


BMP :: BMP( HAB hab, FILE* fp )
{
    this->hdc = NULLHANDLE;
    this->hps = NULLHANDLE;
    this->w = this->h = 0;

    this->read( hab, fp );
}


BMP :: ~BMP()
{
    this->erase();
}


void BMP :: erase()
{
    if( this->hbm != NULLHANDLE ) GpiDeleteBitmap( this->hbm );
    if( this->hps != NULLHANDLE ) GpiDestroyPS( this->hps );
    if( this->hdc != NULLHANDLE ) DevCloseDC( this->hdc );
    this->hps = this->hdc = this->hbm = NULLHANDLE;
    this->w = this->h = 0;
}



void BMP :: read( HAB hab, unsigned char* filename )
{
    if( filename == NULL ) return;

    FILE *fp = fopen( (const char*)filename, "rb" );
    if( fp == NULL ){
      unsigned char* cp = filename + strlen((const char*)filename);
      for( ; *cp != '\\' && *cp != '/' && cp != filename; cp-- );
      if( cp != filename ) cp++;
      char newFilename[1280];
      getcwd( newFilename, 1024 );
      strcat( newFilename, "\\" );
      strcat( newFilename, (char*)cp );
      fp = fopen( (const char*)newFilename, "rb" );
//      if( fp == NULL ) return;
      if( fp == NULL ){
	this->loadDefaultBMP(hab);
	return;
      }
    }

    // ǂ炱̃o[Wstrcpy̓oOĂ݂H
//    strncpy( (char*)filename, &(this->bmpfile[0]), 1000 );
    for( int i=0; i<1024 ; i++ ){
	this->bmpfile[i] = *( filename + i );
	if( this->bmpfile[i] == '\0' ) break;
	}

    this->read( hab, fp );

    fclose( fp );
}


void BMP :: read( HAB hab, FILE *fp )
{
    // Check if fp is BMP file
    BITMAPFILEHEADER2	header;
    fseek( fp, 0L, SEEK_SET );
    fread( &header, sizeof(BITMAPFILEHEADER2), 1, fp );
    if( header.usType != BFT_BMAP ) return;

    // Create virtual device context and its PS
    DEVOPENSTRUC dop =
	{NULL, "DISPLAY", NULL, NULL, NULL, NULL, NULL, NULL, NULL};
    SIZEL  sizl={0, 0};
    HDC newHdc = DevOpenDC(
		    hab, OD_MEMORY, "*", 5L, (PDEVOPENDATA)&dop, NULLHANDLE );
    HPS newHps = GpiCreatePS(hab, newHdc, &sizl, GPIA_ASSOC | PU_PELS);
    HBITMAP newHbm;

    // Load bitmap
    fseek( fp, 0L, SEEK_END );
    long filesize = ftell( fp );
    void* buffer = (void*)(new char[filesize]);
    fseek( fp, 0L, SEEK_SET );
    fread( buffer, filesize, 1, fp );

    void* vp = (void*)(&(((PBITMAPFILEHEADER2)buffer)->bmp2));
    newHbm = GpiCreateBitmap(
		newHps,
		&(header.bmp2),
		CBM_INIT,
		(PBYTE)(buffer+header.offBits),
		(PBITMAPINFO2)vp );

    if( newHbm == NULLHANDLE ){
	GpiDestroyPS( newHps );
	DevCloseDC( newHdc );
	this->w = this->h = 0;
    } else {
	this->erase();
	this->hdc = newHdc;
	this->hps = newHps;
	this->hbm = newHbm;

	BITMAPINFOHEADER bmpInfoHeader;
	GpiQueryBitmapParameters( this->hbm, &bmpInfoHeader );
	this->w = bmpInfoHeader.cx;
	this->h = bmpInfoHeader.cy;
	}

    delete( buffer );

    return;
}


void BMP :: init( HAB hab, HINI ini )
{
    char string[1024];

    PrfQueryProfileString(
	ini, "BMP1.0", "Bitmap", (char*)DEFAULT_BMP, string, 1024 );
    this->read( hab, (unsigned char*)string );
}


void BMP :: writeIni( HINI ini )
{
    PrfWriteProfileString( ini, "BMP1.0", "Bitmap", this->bmpfile );
}


void BMP :: loadDefaultBMP( HAB hab )
{
  // Create virtual device context and its PS
  DEVOPENSTRUC dop =
    {NULL, "DISPLAY", NULL, NULL, NULL, NULL, NULL, NULL, NULL};
  SIZEL  sizl={0, 0};
  this->hdc = DevOpenDC
    ( hab, OD_MEMORY, "*", 5L, (PDEVOPENDATA)&dop, NULLHANDLE );
  this->hps = GpiCreatePS(hab, this->hdc, &sizl, GPIA_ASSOC | PU_PELS);

  this->hbm = GpiLoadBitmap(hps, NULLHANDLE, IDBMP_ABOUT, 
		      ABOUTBMP_WIDTH, ABOUTBMP_HEIGHT );

  BITMAPINFOHEADER bmpInfoHeader;
  GpiQueryBitmapParameters( this->hbm, &bmpInfoHeader );
  this->w = bmpInfoHeader.cx;
  this->h = bmpInfoHeader.cy;
}
