#ifndef CLASS_TimeView
#define CLASS_TimeView

#include "ClockMgr.h"
#include "TransWin.h"
#include "DLModule.h"

class Module : public TransparentWindow
{
  protected:
    HLIB hlib;
    ModuleInfo module;
    virtual ULONG trigger();
    void drawTime( HPS hps, ULONG width, ULONG height );
    MRESULT APIENTRY (*pPC2ModuleProcedure)( HWND, ULONG, MPARAM, MPARAM );
/*
    ULONG APIENTRY (*pPC2drawTime)( HPS, ModuleInfo* );
    ULONG APIENTRY (*pPC2trigger)( ModuleInfo* );
    ULONG APIENTRY (*pPC2init)( HINI, ModuleInfo* );
    ULONG APIENTRY (*pPC2saveSettings)( HINI, ModuleInfo* );
    ULONG APIENTRY (*pPC2terminate)( ModuleInfo* );
*/
    inline ULONG PC2drawTime( HPS hps, ModuleInfo* minfo )
      { return LONGFROMMR((*pPC2ModuleProcedure)(
	   this->hwndClient, MDL_DRAW, MPFROMLONG(hps), MPFROMP(minfo))); };
    inline ULONG PC2trigger( ModuleInfo* minfo )
      { return LONGFROMMR((*pPC2ModuleProcedure)(
	   this->hwndClient, MDL_TRIGGER, MPFROMP(minfo), 0)); };
    inline ULONG PC2init( HINI hini, ModuleInfo* minfo )
      { return LONGFROMMR((*pPC2ModuleProcedure)(
          this->hwndClient, MDL_INIT, MPFROMLONG(hini), MPFROMP(minfo)));};
    inline ULONG PC2saveSettings( HINI hini, ModuleInfo* minfo )
      { return LONGFROMMR((*pPC2ModuleProcedure)(
	   this->hwndClient, MDL_SAVESETTINGS,
	   MPFROMLONG(hini), MPFROMP(minfo))); };
    inline ULONG PC2terminate( ModuleInfo* minfo )
      { return LONGFROMMR((*pPC2ModuleProcedure)(
	   this->hwndClient, MDL_TERMINATE, MPFROMP(minfo), 0)); };
  public:
    Module( ClockManager*, HAB, HWND );
   ~Module( );
    virtual MRESULT EXPENTRY clientProc( HWND, ULONG, MPARAM, MPARAM );
    void init( PSZ, HINI );
    void writeIni( HINI );
    inline BOOL isReady(){
      return (this->pPC2ModuleProcedure == NULL) ? FALSE : TRUE;};
};

#endif
