// config file params
#define CFG_FILE_NAME        "news.cfg"

#define GROUPFILE_LIST_TOK   "name_of_groupfile_list"
#define GROUPFILE_LIST_DEF   "groups.lst"

#define GROUPFILE_USE_TOK    "name_of_groupfile_use"
#define GROUPFILE_USE_DEF    "groups.use"

#define LASTREAD_TOK         "name_of_lastread_index_file"
#define LASTREAD_DEF         "lastread.idx"


typedef struct st_call
{
// input
  int  port_number;
  int  listflag;
  int  noheadflag;
  int  nobodyflag;
  int  nostatflag;
  int  max_threads;
  char newsserver_name     [255];
  char authinfo            [255];
  char groupfile_name_list [255];
  char groupfile_name_use  [255];
  char lastread_name       [255];
  void (* message_callback) ( unsigned long typ, unsigned long num, char *msg, struct st_call *call );
// output
  int  gcnt;
  int  threadcounter;
  int  rc;
  char error_str           [255];
// internal
  FILE *group_file_handle;
  HMTX sema_handle1;
  HMTX sema_handle2;
  void *gui_pointer; // free for use for gui application

} news_callst;


int   news_init             (news_callst *call);
int   news_get_list         (news_callst *call);
int   news_get_news         (news_callst *call);
int   news_ready            (news_callst *call);
int   news_get_error_number (news_callst *call);
char *news_get_error_str    (news_callst *call);
int   news_exit             (news_callst *call);




