/* ------------------------------------------------------------------------
 *
 *       BBBBBBBB    IIIIIIIIII  NN      NN  DDDDDDDD
 *       BB     BB       II      NNN     NN  DD     DD
 *       BB      BB      II      NNNN    NN  DD      DD
 *       BB     BB       II      NN NN   NN  DD      DD
 *       BBBBBBBB        II      NN  NN  NN  DD      DD
 *       BB     BB       II      NN   NN NN  DD      DD
 *       BB      BB      II      NN    NNNN  DD      DD
 *       BB     BB       II      NN     NNN  DD     DD
 *       BBBBBBBB    IIIIIIIIII  NN      NN  DDDDDDDD
 *
 *       Copyright 1998 by ELSA AG, Aachen (Germany)
 *
 *       @Project : v24 util routinen
 *       @System  :
 *       @Modul   : v24util.c
 *       @Prefix  : v24util
 *       @Hardware: Intel
 *       @Compiler: MSVC 6.0
 *       @Library : s. #include...
 *       @Author  : wf
 *       @Info    : Erstellt fr serielle CAPI
 *       @Status  : %
 *
 * ------------------------------------------------------------------------
 *       @History :
 * 141298 /wf       - Angelegt
 * ------------------------------------------------------------------------ */

/** -----------------------------------------------------------------------
 * Ansteuerung des VCOMM unter WIN32
 * ------------------------------------------------------------------------ */

/*---- include area --------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <windows.h>

#define _gsp
//#include "p:\bind\master\ios\common.src\iosdef.h"
#include "bastypes.h"
#include "v24util.h"
#include "strutil.h"
#include "com.h"
#include "os.h"

/*---- define area ---------------------------------------------------------*/

#define AT_CMD_TIMEOUT 1800L

/*---- macro area ----------------------------------------------------------*/

/*---- typedef area --------------------------------------------------------*/

/*---- data area -----------------------------------------------------------*/

/*---- function area -------------------------------------------------------*/

/* ------------------------------------------------------------------------
 * @Function:
 * @Job     :
 * @Info    :
 * @Result  :
 * @Family  :
 * @Example :
 * @Status  :
 * ------------------------------------------------------------------------ */

tU32 xV24UtilSentCmdTestResp
(tU32 Handle,
 char *CommandStr,
 char *ReqResp,
 char *Response)
{
  tU8  TmpStr[256];
  tU32 StartTime;
  tU8  ReadChar[2] = {0};

  strcpy (Response,"");
  OsSleep(200);
  xComClearRxTxBuff(Handle);

  strcpy (TmpStr, CommandStr);
  if (TmpStr[strlen(TmpStr)-1] != '\r') strcat (TmpStr,"\r");

  xComWriteBlock(Handle, TmpStr,(short)strlen(TmpStr), 0);

  StartTime = OsGetTickCount();

  while ((StartTime + AT_CMD_TIMEOUT) > OsGetTickCount())
  {
    if (xComReadDataAvailable(Handle))
    {
      xComReadChar (Handle, &ReadChar[0], 0);
      strcat (Response, ReadChar);
      if (strstr(Response, ReqResp))
      {
        xComClearRxTxBuff(Handle);

        if (strstr(Response,TmpStr))
          strcpy (Response, Response + strlen (TmpStr)+2);
        return (V24UTIL_SENT_COMMAND_SUCCESS);
      }
    }
    else
    {
      OsSleep(1);
    }
  }
  xComClearRxTxBuff(Handle);
  return (V24UTIL_SENT_COMMAND_ERROR);
}


/* ------------------------------------------------------------------------
 * @Function:
 * @Job     :
 * @Info    :
 * @Result  :
 * @Family  :
 * @Example :
 * @Status  :
 * ------------------------------------------------------------------------ */

tU32 xV24UtilSentCommand
(tU32 Handle,
 char *CommandStr)

{
  tU8 Response[255];

  return (xV24UtilSentCmdTestResp(Handle, CommandStr, "OK\r\n", Response));
}


/* ------------------------------------------------------------------------
 * @Function:
 * @Job     :
 * @Info    :
 * @Result  :
 * @Family  :
 * @Example :
 * @Status  :
 * ------------------------------------------------------------------------ */

tU32 xV24UtilGetAtResponse
(tU32 Handle,
 char *CommandStr,
 char *Response)

{
  return (xV24UtilSentCmdTestResp(Handle, CommandStr, "OK\r\n", Response));
}

/* ------------------------------------------------------------------------
 * @Function:
 * @Job     :
 * @Info    :
 * @Result  :
 * @Family  :
 * @Example :
 * @Status  :
 * ------------------------------------------------------------------------ */

tU32 xV24UtilGetDevDescription
(tU32 Handle,
 char* DevDsc)

{
  tU8 Response[2048];

  strcpy (DevDsc, DEV_DSC_TA_MODEM_UNKNOWN);

  xV24UtilGetAtResponse (Handle, "ATI6", Response);

  if (strstr(Response, "ELSA ") == Response)  // ELSA AG
  {
    StringOneLine (Response);
    strcpy (DevDsc, Response);
    return (V24UTIL_GET_DEV_DESCRIPTION_SUCCESS);
  }
  else if (strstr(Response, "Ports active:") == Response) // CFOS
  {
    xV24UtilGetAtResponse (Handle, "ATI", Response);
    strcpy (Response, strstr(Response,"cFos"));
    *(strstr(Response,".")+3) = 0;
    StringOneLine (Response);
    strcpy (DevDsc, Response);
    return (V24UTIL_GET_DEV_DESCRIPTION_SUCCESS);
  }

  xV24UtilGetAtResponse (Handle, "ATI3", Response); // RVS

  StringOneLine (Response);
  if (StringHasAlpha(Response))
  {
    strcpy (DevDsc, Response);
    return (V24UTIL_GET_DEV_DESCRIPTION_SUCCESS);
  }


  return (V24UTIL_GET_DEV_DESCRIPTION_ERROR);
}

/* ------------------------------------------------------------------------
 * @Function:
 * @Job     :
 * @Info    :
 * @Result  :
 * @Family  :
 * @Example :
 * @Status  :
 * ------------------------------------------------------------------------ */

tU32 xV24UtilSearchModem
(tU32 FromComPort,
 tU32 ToComPort,
 char *FoundComPort,
 char *DevDsc)

{
  tU32 Cnt;
  tU32 Handle;
  tComEnumDev Dev = {0};

  strcpy (FoundComPort,"COMx:");
  strcpy (DevDsc, DEV_DSC_TA_MODEM_UNKNOWN);

  for (Cnt = FromComPort; Cnt <= ToComPort; Cnt++)
  {
    FoundComPort[3] = (tU8)(Cnt+48);
    strcpy (Dev.cDevNam, FoundComPort);
    if (!xComOpenDev (&Handle, &Dev))
    {
      if (xComCanWrite(Handle))
      {
        if (!xV24UtilSentCommand(Handle, "AT"))
        {
          xV24UtilGetDevDescription (Handle, DevDsc);
          xComCloseDev(Handle);
          OsSleep(200);
          return (V24UTIL_SEARCH_MODEM_SUCCESS);
        }
      }
    }
  }
  xComCloseDev(Handle);
  OsSleep(200);
  strcpy (FoundComPort, "");
  return (V24UTIL_SEARCH_MODEM_ERROR);
}

/* ------------------------------------------------------------------------ */


