/* FV.CMD - View and rename all new FAX files
 *
 * Usage:  FV [PATTERN]
 * PATTERN: optional file search pattern, default is: FREC????
 *          you can view specific FAXes by specifying this pattern.
 *          E.g.: fv waldmann
 *                this will show you all files waldmann*.tif
 *
 *                fv waldmann_9612
 *                this will show you all files waldmann_9612*.tif
 *                
 * - you have to change the variable settings at the top of this script
 *   to match your setup
 *
 * - you should use HPFS (if you use FAT, you have to change longfnamesflag
 *   to 0 to let this script generate stupid 8.3 filenames)
 *
 *   Examples for generated filenames for a FAX that arrived 31.12.95 at
 *   23:59:58, if you enter Waldmann_Thomas as new filename :
 *
 *     HPFS: Waldmann_Thomas_953112_235958.TIF
 *     FAT : WALD1231.TIF
 *
 * - if you do not rename a FAX after viewing, FV will present it to you
 *   again and again until you rename it ...
 *
 * - you should use it with FAXVIEW of Harald Pollack
 *
 * Freeware written 11. - 15.01.96 by Thomas Waldmann, 2:2474/400
 *
 */

/******************** variable settings *************************************/

this           = 'H:\CL\FV.CMD'      /* path/filename of THIS script        */

faxpath        = 'H:\CL'             /* path to search for new FAX files    */

faxpattern     = 'FREC????.TIF'      /* search pattern for new FAX files    */

faxviewpath    = 'H:\CL\faxview.exe' /* path/filename of FAX viewer         */

faxviewoptions = '-FASTDRAW -B'      /* options of FAX viewer - filename of */
                                     /* FAX file will be DIRECTLY appended. */
                                     /* if you have problems, try: '-B'     */

waitflag       = 1                   /* 1 = wait for ENTER after renaming   */
                                     /* 0 = don't wait                      */

longfnamesflag = 1                   /* 1 = use long filenames (HPFS)       */
                                     /* 0 = use 8.3  filenames (FAT)        */

/****************************************************************************/

arg arg1 argrest

if arg1\="ISWINDOWED" then   /* if fv.cmd isn't started with this argument, */
  do                         /* it will invoke itself in a windowed session */
    '@start /c /win' this 'ISWINDOWED' arg1 argrest
    exit
  end

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

if argrest\="" then
  faxpattern=strip(argrest)||"*.TIF"
  
call SysFileTree faxpath||'\'||faxpattern, 'fax', 'FO'
if fax.0>0 then
  do i=1 to fax.0
    call FaxView fax.i
  end
else
  do
    say 'No new FAXes! Press ENTER to continue ...'
    pull dummy
  end
exit

FaxView:
  parse arg fname
  say
  say 'Viewing FAX file' fname '...'
  '@'faxviewpath faxviewoptions||fname
  say 'Renaming of FAX file' fname '...'
  if longfnamesflag then
    say '- HPFS: _YYMMDD_hhmmss.TIF will be appended automagically.'
  else
    do
    say '- FAT : MMDD.TIF will be appended automagically.'
    say '        If you enter more than 4 characters for the new name,'
    say '        your input will be truncated after the first 4 chars.'
    end
  say '- Empty input keeps old name.'  
  call charout ,'Enter new name: >'
  parse pull newfnameprefix
  len = length(newfnameprefix)
  if len>0 then
    do
      if (\longfnamesflag) & (len>4) then
        newfnameprefix = substr(newfnameprefix,1,4)
      parse value(stream(fname,'c','query datetime')) with mm'-'dd'-'yy'  'hh':'ii':'ss
      if longfnamesflag then
        newfname = newfnameprefix||'_'||yy||mm||dd||'_'hh||ii||ss||'.TIF' 
      else
        newfname = newfnameprefix||mm||dd||'.TIF'
      say 'Renaming' fname 'to' newfname
      '@ren' fname newfname '>NUL'
      if waitflag then
        do
          say 'Press ENTER to continue ...'
          pull dummy
        end
    end
  return
  
/******************************* EOF ****************************************/
