/****************************************************************/
/* Searches all directories for documentation files, and        */
/* constructs program objects for them.                         */
/*                                                              */
/*       Programmer:      P. Moylan                             */
/*       Last modified:   12 September 2001                     */
/*                                                              */
/*     Usage:         finddoc drive extensions                  */
/*     For example:   finddoc D: html inf                       */
/*                                                              */
/*     If no drive is specified, all drives are scanned.        */
/*     If no extensions are specified, then we look for         */
/*      extensions in the list 'DefaultToFind' (see below).     */
/*                                                              */
/*  Remark: the slowness of this program appears to be because  */
/*  of a WPS limitation: SysCreateObject performs badly when a  */
/*  a folder contains many objects.  One way around the problem */
/*  is to clear your web browser cache before running this      */
/*  program, because typically it will turn out that you have   */
/*  large numbers of HTML files that are of no interest to      */
/*  anybody.                                                    */
/*                                                              */
/****************************************************************/

DefaultToFind = 'HLP INF PDF HTM HTML'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
call WPToolsLoadFuncs

/* Parse the command arguments. */

DriveSpec = ''
parse arg ToFind
IF POS(':', ToFind) = 2 THEN DO
    parse var ToFind DriveSpec ToFind
END
IF ToFind = '' THEN ToFind = DefaultToFind

/* Create a desktop folder to hold the results. */

IF \SysCreateObject( 'WPFolder',,
        'Documentation',,
        '<WP_DESKTOP>',,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONVIEW=FLOWED,INVISIBLE,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,NORMAL;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID=<AllDoc_folder>',,
        'Update') THEN DO
    SAY "Could not create result folder"
    EXIT
END

DO WHILE ToFind \= ''
    parse var ToFind extension ToFind
    CALL ScanForExt TRANSLATE(extension) DriveSpec
END /*DO UNTIL*/

/* All finished. */

SAY "Finished.  The results are in folder 'Documentation' on the desktop."
Exit

/******************************************************/
/* Procedure to collect the details for one file type */
/******************************************************/

ScanForExt: PROCEDURE EXPOSE ObjCount
    parse arg extension Drives

    /* Create a subfolder to hold the results. */

    folderID = '<AllDoc_folder'extension'>'
    CALL SysCreateObject 'WPFolder',,
            extension,,
            '<AllDoc_folder>',,
            'NOPRINT=YES;'||,
            'DEFAULTVIEW=CONTENTS;'||,
            'SELFCLOSE=1;'||,
            'ICONVIEW=FLOWED,INVISIBLE,NORMAL;'||,
            'DETAILSVIEW=MINI;'||,
            'TREEVIEW=LINES,NORMAL;'||,
            'ALWAYSSORT=YES;'||,
            'OBJECTID='folderID,,
            'Update'

    /* Opening the folder seems to speed up the program, but  */
    /* I don't know why.  Uncomment the following line to see */
    /* what I mean.                                           */

    CALL SysOpenObject folderID, "Icon", 1

    /* Find the viewer associated with this file type. */

    mask = '*.'extension
    code = SysIni('USER', 'PMWP_ASSOC_FILTER', mask)
    IF code = 'ERROR:' THEN code = '0'

    /* If multiple associations, take only the first. */

    PARSE VAR code code '0'X rubbish

    /* Find the executable name for this object. */

    rc=WPToolsQueryObject('#'D2X(code),,,"Setup")
    IF rc = 1 THEN
        parse var Setup Rubbish1'EXENAME='filename';'Rubbish2
    ELSE filename = 'E.EXE'
    SAY ''
    SAY "Viewer for "mask" is "filename

    /* Scan the specified drive, or all readable drives */
    /* if no drive is specified.                        */

    IF Drives = '' THEN Drives = SysDriveMap('C', 'USED')
    do while Drives \= ''
        parse var Drives ThisDrive Drives
        if SysDriveInfo(ThisDrive) \= '' then
           call CheckDrive ThisDrive extension filename folderID
    end

    return

/************************************************/
/* Procedure to check one drive.                */
/************************************************/

CheckDrive: PROCEDURE EXPOSE DotCount ObjCount
    parse arg Drive ext viewer folderID
    DotCount = 0
    ObjCount = 0
    SAY 'Checking drive 'Drive' '
    call ScanDir Drive, ext, viewer, folderID
    CALL LineOut ,''
    return

/************************************************/
/* Procedure to check a specified directory and */
/* its subdirectories.                          */
/************************************************/

ScanDir: PROCEDURE EXPOSE DotCount ObjCount
    parse arg ThisDir, ext, viewer, folderID
    CALL Progress
    call SysFileTree ThisDir'\*.'ext, 'file', 'FO'
    DO j=1 to file.0
         CALL AddFile ThisDir, file.j, viewer, folderID, ext
    END
    DROP file.
    call SysFileTree ThisDir'\*', 'file', 'DO'
    DO j=1 to file.0
         CALL ScanDir file.j, ext, viewer, folderID
    END
    DROP file.
    return

/********************************************************/
/* Procedure to put a progress indicator on the screen. */
/********************************************************/

Progress: PROCEDURE EXPOSE DotCount
    IF DotCount > 700 THEN DO
        CALL LineOut ,''
        DotCount = 0
    END
    ELSE DO
        IF DotCount // 10 = 0 THEN
            CALL CharOut ,'.'
        DotCount = DotCount + 1
    END
    return

/********************************************************/
/* Procedure to create a program object for viewing the */
/* file that is given as an argument.                   */
/********************************************************/

AddFile: PROCEDURE EXPOSE ObjCount
    parse arg Dir, FileName, viewer, folderID, ext
    DO FOREVER
        parse var FileName head'\'tail
        IF tail = '' THEN LEAVE
        FileName = tail
    END /*do forever*/

    /* For some file types, we can deduce the title from contents. */

    SELECT
        WHEN ext = 'HLP' THEN
            Title = InfTitle(Dir'\'FileName)
        WHEN ext = 'INF' THEN
            Title = InfTitle(Dir'\'FileName)
        WHEN ext = 'HTM' THEN DO
                FileName = Dir'\'FileName
                Title = HtmlTitle(FileName)
                FileName = 'file://'FileName
            END
        WHEN ext = 'HTML' THEN DO
                FileName = Dir'\'FileName
                Title = HtmlTitle(FileName)
                FileName = 'file://'FileName
            END
        OTHERWISE
            Title = Filename
    END /* select */

    IF Title = '' THEN Title = FileName

    Title0 = Title
    Setup = 'EXENAME='viewer';STARTUPDIR='Dir';PARAMETERS='Filename
    Try = 0
    ObjCount = ObjCount + 1
    IF ObjCount > 40 THEN DO
        CALL CharOut ,'*'
        CALL SysSleep 3
        ObjCount = 0
    END
    DO until (ans\=0) | (Try > 99)
        /*CALL CharOut ,'A'*/
        ans = SysCreateObject( 'WPProgram', Title, folderID, Setup, 'F' )
        /*CALL CharOut ,'B'*/
        if ans = 0 then do
            Title = Title0||':'||Try
            Try = Try + 1
        END
    END
    RETURN

/*********************************/
/* Work out Title of an INF file */
/*********************************/

InfTitle: PROCEDURE
    parse arg FileName
    title = CHARIN(FileName, 1, 619)
    CALL Stream FileName, 'C', 'CLOSE'
    IF LEFT(title, 3) \= 'HSP' THEN RETURN ''
    title = RIGHT(title, 512)
    title = STRIP(title, 'B', '0'X)
    j = POS('0'X, title)
    IF j>0 THEN title = LEFT(title, j-1)
    RETURN title

/**********************************/
/* Work out Title of an HTML file */
/**********************************/

HtmlTitle: PROCEDURE
    parse arg FileName

    k = 0
    CALL Stream FileName, 'C', 'open read'
    DO FOREVER
        IF STREAM(FileName, 'S') \= 'READY' THEN LEAVE
        buffer = LINEIN(FileName)
        k = POS('<TITLE>', buffer)
        IF k = 0 THEN k = POS('<title>', buffer)
        IF k \= 0 THEN LEAVE
    END
    CALL Stream FileName, 'C', 'CLOSE'

    IF buffer = '' THEN RETURN ''

    /*SAY 'k='k', buffer='buffer*/
    IF k>0 THEN buffer = DELSTR(buffer, 1, k+6)
    k = POS('</TITLE>', buffer)
    IF k = 0 THEN k = POS('</title>', buffer)
    IF k \= 0 THEN buffer = DELSTR(buffer, k)

    RETURN buffer

/******************************************************************/

