/*
$VerboseHistory: aliasedt.e$
 *
 * *****************  Version 2  *****************
 * User: Clark       Date: 01/08/1998  Time:10:34a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:34a
 * Comment:
 * Fixed potential infinit loop problem.
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:07:24a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 07:24a
 * Comment:
 * Changed message box to use question mark icon
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

//DIALOG BOX MAY BE SHOWN MODELESSLY

/*
p_user's:

   _ok.p_user - is the hash table that holds the aliases.  Every function that
                needs it saves and restores it.

   _ctlae_alias_list.p_user - This is the last alias that was edited.  It is
                              saved so that before we fill in the alias selected
                              in the alias list box, we can save the last one
                              that was edited.

   _ctlae_edit_window.p_user - Modify flag.
*/
struct ALIAS_TYPE{
   _str value[];
};

defeventtab _alias_editor_form

_ctlae_ok.on_create()
{
   ALIAS_TYPE alias_table:[];

   ALIAS_TYPE junk;junk.value[0]=0;
   alias_table:[0]=junk;alias_table._deleteel(0);

   aliasfilename=arg(1);
   if (aliasfilename=='') {
      aliasfilename=_ALIAS_FILE;
   }
   path=slick_path_search(aliasfilename);
   if (path=="") {
      aliasfilename=_config_path():+strip_filename(aliasfilename,"P");
   } else {
      aliasfilename=path;
   }
   aliasfilename=absolute(aliasfilename);

   load_alias_file(aliasfilename,alias_table);
   p_active_form.p_caption='Alias Editor - 'aliasfilename;
   parse _default_font(CFG_WINDOW_TEXT) with fname','fsize','fflags','.
   _ctlae_edit_window.p_font_name=fname;
   _ctlae_edit_window.p_font_size=fsize;
   _ctlae_edit_window.p_font_bold=fflags&F_BOLD;
   _ctlae_edit_window.p_font_italic=fflags&F_ITALIC;
   _ctlae_edit_window.p_font_strike_thru=fflags&F_STRIKE_THRU;
   _ctlae_edit_window.p_font_underline=fflags&F_UNDERLINE;
   _ctlae_ok.p_user=alias_table;
   wid=p_window_id;p_window_id=_control _ctlae_alias_list.p_cb_list_box;
   for (i._makeempty();;) {
      alias_table._nextel(i);
      if (i._isempty()) break;
      _lbadd_item(i);
   }
   _lbsort();
   _lbtop();_lbselect_line();
   p_window_id=_control _ctlae_param_list;
   _col_width(0,1500);
   _col_width(1,3500);
   p_window_id=wid;
   _ctlae_alias_list.call_event(CHANGE_OTHER,defeventtab _alias_editor_form._ctlae_alias_list,ON_CHANGE,'E');
}

static _str ProcessEscapeSequences(_str alias)
{
   _str AliasOut='';
   for (i=1;;++i) {
      if (i>length(alias)) break;
      ch=substr(alias,i,1);
      if (ch=='%') {
         _str ch2=substr(alias,i+1,1);
         switch (ch2) {
         case '\':
            _str ch3=upcase(substr(alias,i+2,1));
            if (ch3=='L' || ch3=='S') {
               i+=2;
               continue;
            }
            AliasOut=AliasOut:+substr(alias,i,3);
            i+=2;
            break;
         default:
            _str EndChar='%';
            if (ch2=='(') EndChar=')';
            AliasOut=AliasOut:+substr(alias,i,2);
            i+=2;
            for (;;) {
               ch=substr(alias,i,1);
               AliasOut=AliasOut:+ch;
               if (i>length(alias) || ch==EndChar) break;
               ++i;
            }
            break;
         }
      }else{
         AliasOut=AliasOut:+ch;
      }
   }
   return(AliasOut);
}

//static void reallign(ALIAS_TYPE &alias)
static void reallign(_str (&alias)[])
{
   size=alias._length();
   if (size==1) {
#if 0
      alias[0]=stranslate(alias[0],'','%\s');
      alias[0]=stranslate(alias[0],'','%\S');
#else
      alias[0]=ProcessEscapeSequences(alias[0]);
#endif
      alias[0]=strip(alias[0],'l');
      if (substr(alias[0],1,1)=='(') alias[0]='%\L'alias[0];
      //This is a hack so that we can tell the paramaterized aliases from ones
      //that just start with a "("
      return;
   }

   //Is is a parameterized alias?
   isparameterized=substr(alias[0],1,1)=='(';

   //Now, lets line them up
   //First, make sure all are indented as far as first.
   firstaliasbodyline=0;
   if (isparameterized) {
      for (i=0;i<size;++i) {
         if (strip(alias[i])==')') {
            firstaliasbodyline=i+1;
            break;
         }
      }
   }
   firstnonblank=pos('~[ ]',alias[0],1,'r');
   for (i=1;i<size;++i) {
      curfirstnonblank=pos('~[ ]',alias[i],1,'r');
      if (curfirstnonblank<firstnonblank) {
         difference=firstnonblank-curfirstnonblank;
         alias[i]=substr('',1,difference,' '):+alias[i];
      }
   }

   //Next, find out which line has the fewest leading spaces, and eliminate
   //that many from the beginning of each line
   leastblanks='';
   for (i=firstaliasbodyline;i<size;++i) {
      numblanks=pos('~[ ]',alias[i],1,'r')-1;
      if (leastblanks==''||numblanks<leastblanks) {
         leastblanks=numblanks;
      }
   }
   for (i=firstaliasbodyline;i<size;++i) {
      alias[i]=substr(alias[i],leastblanks+1 );
      //alias[i]=stranslate(alias[i],'','%\s');
      //alias[i]=stranslate(alias[i],'','%\S');
      alias[i]=ProcessEscapeSequences(alias[i]);
   }

   if (!isparameterized && substr(alias[0],1,1)=='(') {
      alias[0]='%\L'alias[0];
   }
}

static int load_alias_file(_str filename,ALIAS_TYPE (&hashtab):[])
{
   _ctlae_edit_window.p_user=0;
   _ctlae_param_list.p_user=0;
   mou_hour_glass(1);
   inmem=1;
   orig_view_id=p_view_id;
   status=_open_temp_view(filename,alias_view_id,orig_view_id,' +b ');
   if (status) {
      inmem=0;
      status=_open_temp_view(filename,alias_view_id,orig_view_id);
      if (status) {
         p_view_id=orig_view_id;
         mou_hour_glass(0);
         return status;
      }
   }
   p_view_id=alias_view_id;
   top();up();
   while (!search('^?@( |$|\()','@r')){
      get_line(line);
      p=pos('( |$|\()',line,1,'r');
      name=substr(line,1,p-1);
      if (pos('$',line,1,'r')==pos(name,line,1,'r')+1) {
         if(down())break;
         continue;
      }
      value_count=0;
      if (!hashtab._indexin(name)) {
         for (;;) {
            if (p) {
               if (substr(line,p,1)=='(') {
                  hashtab:[name].value[value_count]=substr(line,p);
               }else{
                  value=substr(line,p+1);
                  prefix=substr('',1,p,' ');
                  hashtab:[name].value[value_count]=prefix:+substr(line,p+1);
               }
               for (;;) {
                  done=down();
                  if (done) break;
                  ++value_count;
                  get_line(line);
                  lastline=substr(line,1,1)!=' ';
                  if (lastline) break;
                  hashtab:[name].value[value_count]=line;
               }
            }
            break;
         }
      }else{
         if(down()) break;
         continue;
      }
      reallign(hashtab:[name].value);
      if (done) break;
      _begin_line();
   }
   if (inmem) {
      p_view_id=alias_view_id;
      p_buf_flags&=~HIDE_BUFFER;//Got set by _open_temp_view
      _quit_view();
      p_view_id=orig_view_id;
   }else{
      p_view_id=orig_view_id;
      _delete_temp_view(alias_view_id);
   }
   mou_hour_glass(0);
   return(0);
}

int _ctlae_alias_list.on_change(int reason)
{
   ALIAS_TYPE alias_table:[];
   alias_table=_ctlae_ok.p_user;
   //_str alias[];
   _str alias[];

   switch (reason) {
   case CHANGE_CLINE:
   case CHANGE_OTHER:
   case CHANGE_SELECTED:
      p_cb_list_box._lbselect_line();
      if (_ctlae_alias_list.p_user==_ctlae_alias_list.p_cb_list_box._lbget_text()
          && arg(2)!=1) {
         return(0);
      }
      wid=p_window_id;p_window_id=_ctlae_edit_window;
      save_pos(p);
      p_line=0;
      if (!search('\t','r@')) {
         _message_box(nls("You cannot put tab characters in an alias.  Use %\\i for indenting - This will cause the alias to expand with tabs for buffers where Indent With Tabs is turned on."));
         _ctlae_alias_list.p_cb_list_box._lbsearch(_ctlae_alias_list.p_user);
         _ctlae_alias_list.p_cb_list_box._lbselect_line();
         return(1);
      }
      restore_pos(p);
      isparameterized=0;offset=0;
      // IF there are any aliases
      if (_ctlae_alias_list.p_cb_list_box.p_line) {
         // IF we need to save the previous alias value
         if (_ctlae_alias_list.p_user!='' &&
            (p_modify || _ctlae_param_list.p_user)) {
            if (!p_Noflines) {//Dan added to handle the "No Line" case 10:37am 5/22/1996
               insert_line('');
            }
            if (_ctlae_param_list.p_Noflines) {
               _ctlae_param_list.p_user=0;
               isparameterized=1;
               wid=p_window_id;p_window_id=_ctlae_param_list;
               _lbtop();_lbup();
               while (!_lbdown()) {
                  ++offset;
                  parse _lbget_text() with varname"\t"prompt"\t"init;
                  if (p_line-1) {
                     alias[p_line-1]=' 'varname' "'prompt'" 'init;
                  }else{
                     alias[p_line-1]='('varname' "'prompt'" 'init;
                  }
               }
               alias[p_line]=' )';
               ++offset;
               p_window_id=wid;
            }
            top();up();
            while (!down()) {
               get_line(line);
               if (substr(line,1,1)=='(') {
                  line='%\L'line;
               }
               p=pos('\%\(:v\)',line,1,'r');
               while (p) {
                  if (p) {
                     lp=pos(')',line,p);
                     varwp=substr(line,p,lp-p+1);
                     varwop=substr(varwp,3,length(varwp)-3);
                     _ctlae_param_list.save_pos(q);
                     _ctlae_param_list._lbtop();
                     status=_ctlae_param_list.search('^?'varwop"\t",'@ir');
                     if (status&&get_env(varwop)==''&&rc==STRING_NOT_FOUND_RC) {
                        _message_box(nls("Warning:\n\nThere is no environment variable or parameter for '%s'",varwop));
                     }
                     _ctlae_param_list.restore_pos(q);
                  }
                  p=pos('\%\(:v\)',line,lp+1,'r');
               }
               if (line=='') line='%\l';
               if (p_line>1 || offset) {
                  alias[p_line-1+offset]=/*prefix:+*/line;
               }else{
                  if (!(p_line-1) && substr(line,1,1)=='(') {
                     alias[p_line-1+offset]='%\L'line;
                  }else{
                     alias[p_line-1+offset]=line;
                  }
               }
            }
            alias_table:[_ctlae_alias_list.p_user].value=alias;
         }else if (p_modify) {
            _ctlae_edit_window.p_user=1;
         }

         // Switch to the new alias
         _ctlae_alias_list.p_user=_ctlae_alias_list.p_cb_list_box._lbget_text();
         _lbclear();
         _ctlae_param_list._lbclear();
         //lastevent=event2name(test_event());
         alias=alias_table:[strip(_ctlae_alias_list.p_cb_list_box._lbget_text())].value;
         format=alias._varformat();
         for (i=0;i<alias._length();++i) {
            if (i) {
               line=alias[i];//substr(alias[i],2);
            }else{
               if (substr(alias[i],1,1)=='(') {
                  i+=fill_in_params(alias);
                  continue;
               }else if (substr(alias[i],1,3)=='%\L') {
                  line=substr(alias[i],4);
               }else{
                  line=alias[i];
               }
               //line=alias[i];
            }
            insert_line(line);
         }
         top();
         _begin_line();
         if (!p_Noflines) insert_line('');
         p_modify=0;
      }
      p_window_id=_ctlae_param_list;
      _lbtop();
      _lbselect_line();
      p_window_id=wid;
   }
   enabled='';
   if (!_ctlae_edit_window.p_enabled && _ctlae_alias_list.p_cb_list_box.p_Noflines) {
      enabled=1;
   } else if (_ctlae_edit_window.p_enabled && !_ctlae_alias_list.p_cb_list_box.p_Noflines) {
      enabled=0;
   }
   if (enabled!='') {
      _ctlae_edit_window.p_enabled=enabled;
      _ctlae_delete.p_enabled=enabled;
      _ctlae_param_list.p_enabled=enabled;
      _ctlae_param_add.p_enabled=enabled;
      _ctlae_param_remove.p_enabled=enabled;
      _ctlae_param_edit.p_enabled=enabled;
      _ctlae_param_up.p_enabled=enabled;
      _ctlae_param_down.p_enabled=enabled;
   }
   _ctlae_ok.p_user=alias_table;
   return(0);
}

static int fill_in_params(_str alias[])
{
   for (i=0;i<alias._length();++i) {
      found=-1;
      if (strip(alias[i]==')')) {
         found=i;break;
      }
   }
   if (found<0) {
      for (i=0;i<alias._length();++i) {
         if (pos(')',alias[i])) {
            found=i;break;
         }
      }
   }
   if (found<0) {
      //Warn user or something (there is no closing paren
      _beep();
      _message_box(nls("PROBLEM"));
   }
   for (i=0;i<alias._length();++i) {
      if (strip(alias[i])==')') break;
      if (substr(alias[i],1,1)=='(') {
         line=substr(alias[i],2);
      }else{
         line=alias[i];
      }
      parse line with varname '"' prompt '"' init;
      _ctlae_param_list._lbadd_item(strip(varname)"\t"strip(prompt)"\t"strip(init));
   }
   return(i);
}

static int write_alias_file(_str filename,ALIAS_TYPE (&alias_table):[])
{
   //ALIAS_TYPE alias_table;
   inmem=1;
   status=_open_temp_view(filename,alias_view_id,orig_view_id,'+b');
   if (status) {
      inmem=0;
      status=_open_temp_view(filename,alias_view_id,orig_view_id);
      if (status) {
         orig_view_id=_create_temp_view(alias_view_id);
         p_buf_name=absolute(filename);
      }
   }
   p_view_id=alias_view_id;
   _lbclear();
   //_str alias[];
   for (name._makeempty();;) {
      alias_table._nextel(name);
      if (name._isempty()) break;
      curalias=alias_table:[name].value;
      size=curalias._length();
      isparameterized=substr(curalias[0],1,1)=='(';
      if (isparameterized) {
         //First we'll write out all the parameter stuff
         insert_line(name:+curalias[0]);
         count=1;
         do {
            line=strip(curalias[count]);
            line=substr('',1,length(name' '),' '):+line;
            insert_line(line);
         } while ( strip(curalias[count++])!=')' );
         //Now do the body part
         for (i=count;i<size;++i) {
            if (i==count && substr(curalias[i],1,1)==' ') {
               curalias[i]='%\L':+curalias[i];
            }
            if (last_char(curalias[i])==' ') {
               curalias[i]=curalias[i]'%\S';
            }
            insert_line(' 'curalias[i]);
         }
      }else{
         if (substr(curalias[0],1,1)==' ') {
            curalias[0]='%\L'curalias[0];
         }
//         if (last_char(curalias[0])==' ') {
//            curalias[0]=curalias[0]'%\S';
//         }
//         insert_line(name' 'curalias[0]);
//         prefix=substr('',1,length(name),' ');
         prefix._makeempty();
         for (i=0;i<size;++i) {
            if (last_char(curalias[i])==' ') {
               curalias[i]=curalias[i]'%\S';
            }
            if (i) {
               insert_line(prefix' 'curalias[i]);
            }else{
               insert_line(name' 'curalias[0]);
               prefix=substr('',1,length(name),' ');
            }
         }
      }
   }
   status=_save_file('+O 'filename);//Backup options?
   if (status) {
      _message_box(nls("Could not save file %s.\n\n%s",filename,get_message(status)));
      return(status);
   }
   if (inmem) {
      p_buf_flags&=~HIDE_BUFFER;//Was hidden by _open_temp_view
      _quit_view();
      p_view_id=orig_view_id;
   }else{
      orig_view_id=p_view_id;
      _delete_temp_view(alias_view_id);
   }
   return(status);
}

static int lastpixel_y(wid)
{
   return(wid.p_y+wid.p_height);
}

void _ctlae_ok.lbutton_up()
{
   fid=p_active_form;
   ALIAS_TYPE alias_table:[];
   int status=_ctlae_alias_list.call_event(CHANGE_OTHER,1,_ctlae_alias_list,ON_CHANGE,'');
   if (status) {
      return;
   }
   alias_table=_ctlae_ok.p_user;
   parse p_active_form.p_caption with 'Alias Editor - 'aliasfilename;
   aliasfilename=strip(maybe_quote_filename(aliasfilename));
   status=write_alias_file(aliasfilename,alias_table);
   fid._delete_window(status);
}

int _validnewaliasname(_str name,typeless *hashtabptr)
{
   if (pos(" |\t",name,1,'r')) {
      _message_box(nls("Alias names may not contain whitespace."));
      return(1);
   }
   if (hashtabptr->_indexin(name)) {
      _message_box(nls("An alias %s already exists.",name));
      return(1);
   }
   return(0);
}

void _ctlae_new.lbutton_up()
{
   ALIAS_TYPE alias_table:[];
   alias_table=_ctlae_ok.p_user;
   result=show('-modal _textbox_form',
               'Enter New Alias Name',
               0,//Flags,
               '',//Tb width
               '',//help item
               '',//reserved
               '',//retrieve name
               '-e _validnewaliasname:'(&alias_table)' Alias Name:');
   if (result=='') return;
   _ctlae_edit_window.p_user=1;
   newaliasname=strip(_param1);
   // alias_table:[newaliasname][0][0]
   //trace
   alias_table:[newaliasname].value[0]='';
   wid=p_window_id;p_window_id=_ctlae_alias_list.p_cb_list_box;
   _lbdeselect_all();
   _lbadd_item(newaliasname);
   _lbsort();
   _lbsearch(newaliasname);
   // This call centers the line in the list box.
   set_scroll_pos(p_left_edge,p_client_height intdiv 2);
   _lbselect_line();
   p_window_id=wid;
   x=_ctlae_ok.p_user;

   _ctlae_alias_list.call_event(CHANGE_OTHER,defeventtab _alias_editor_form._ctlae_alias_list,ON_CHANGE,'E');
   //Dan added this to save blank aliases 10:20am 5/22/1996
   //_ctlae_alias_list.p_user=newaliasname;

   //Dan added this to save blank aliases 10:20am 5/22/1996
   _ctlae_edit_window.p_modify=1;

   _ctlae_edit_window._set_focus();
}

void _ctlae_delete.lbutton_up()
{
   ALIAS_TYPE alias_table:[];
   alias_table=_ctlae_ok.p_user;
   _ctlae_edit_window.p_user=1;
   wid=p_window_id;p_window_id=_ctlae_alias_list.p_cb_list_box;
   name=_lbget_text();
   _lbdelete_item();
   alias_table._deleteel(name);
   _lbdeselect_all();
   _ctlae_alias_list.call_event(CHANGE_SELECTED,defeventtab _alias_editor_form._ctlae_alias_list,ON_CHANGE,'E');
   _lbselect_line();
   if (!p_Noflines) {
      _ctlae_edit_window._lbclear();
   }
   p_window_id=wid;
   _ctlae_ok.p_user=alias_table;
}

void _ctlae_cancel.lbutton_up()
{
   if (_ctlae_edit_window.p_user||_ctlae_edit_window.p_modify) {
      parse p_active_form.p_caption with 'Alias Editor - 'aliasfilename;
      aliasfilename=strip(maybe_quote_filename(aliasfilename));
      result=_message_box(nls("%s has been modified.\n\nExit anyway?",aliasfilename),
                          '',
                          MB_YESNO|MB_ICONQUESTION);
      if (result!=IDYES) return;
   }
   p_active_form._delete_window();
}

int _validnewparamcheck(_str str,_str fieldnum)
{
   parse fieldnum with fieldnum '$' data
   switch (fieldnum) {
   case 1://Varname
      wid=data;
      if (!isid_valid(str)) {
         _message_box(nls("%s is not a valid identifier.",str));
         return(1);
      }
      status=wid.search('^?'str"\t",'@ir');
      if (!status) {
         _message_box(nls("%s already exists.",str));
         return(1);
      }
      return(0);
   case 2://Prompt
      if (str=='') {
         _message_box(nls("You must specify a prompt."));
         return(1);
      }
      if (pos('"',str)) {
         _message_box(nls("Prompt may not contain quotes."));
         return(1);
      }
      return(0);
   case 3://Varname, don't check to see if exists
      if (!isid_valid(str)) {
         _message_box(nls("%s is not a valid identifier.",str));
         return(1);
      }
      return(0);
   }
   return(0)
}

void _ctlae_param_add.lbutton_up()
{
   result=show('-modal _textbox_form',
               'Enter Alias Parameter',
               0,//Flags,
               '',//Tb width
               '',//help item
               '',//reserved
               '',//retrieve name
               '-e _validnewparamcheck:1$'_ctlae_param_list' Parameter Name:',
               '-e _validnewparamcheck:2 Prompt:',
               'Initial Value:');
   if (result=='') return;
   varname=_param1;
   promptstr=_param2;
   initval=_param3;
   wid=p_window_id;p_window_id=_ctlae_param_list;
   _lbdeselect_line();
   _lbadd_item(varname"\t"promptstr"\t"initval);
   _lbselect_line();
   p_window_id=wid;
   _ctlae_param_list.p_user=1;
}

void _ctlae_param_edit.lbutton_up()
{
   if (!_ctlae_param_list.p_Noflines) return;
   parse _ctlae_param_list._lbget_text() with varname"\t"promptstr"\t"initval;
   result=show('-modal _textbox_form',
               'Edit Alias Parameter',
               0,//Flags,
               '',//Tb width
               '',//help item
               '',//reserved
               '',//retrieve name
               '-e _validnewparamcheck:3 Parameter Name:'varname,
               '-e _validnewparamcheck:2 Prompt:'promptstr,
               'Initial Value:'initval);
   if (result=='') return;
   varname=_param1;
   promptstr=_param2;
   initval=_param3;
   _ctlae_param_list._lbset_item(varname"\t"promptstr"\t"initval);
   _ctlae_param_list.p_user=1;
}

static void upbutton(int line)
{
   if (p_Noflines<=1) {
      return;
   }
   p_line=line;
   item=_lbget_text();
   _lbdelete_item();
   if (p_line!=p_Noflines) {
      _lbup();
   }
   if (p_line<1) {
      _lbbottom();
   }else{
      if (line-1) {
         while (p_line>=line-1) {
            _lbup();
         }
      }
   }
   _lbadd_item(item);
   _lbselect_line();
}

static void downbutton(int line)
{
   p_line=line;
   line=_lbget_text();
   onbottom=p_line==p_Noflines;
   _lbdelete_item();
   if (onbottom) {
      _lbtop();
      _lbup();
   }
   _lbadd_item(line);
   _lbselect_line();
}

_ctlae_param_up.lbutton_up()
{
   _ctlae_edit_window.p_user=1;
   _ctlae_param_list.p_user=1;
   line=_ctlae_param_list.p_line;
   _ctlae_param_list.upbutton(line);
}

_ctlae_param_down.lbutton_up()
{
   _ctlae_edit_window.p_user=1;_ctlae_param_list.p_user=1;
   line=_ctlae_param_list.p_line;
   _ctlae_param_list.downbutton(line);
}

void _ctlae_param_remove.lbutton_up()
{
   wid=p_window_id;p_window_id=_ctlae_param_list;
   _lbdeselect_line();
   _lbdelete_item();
   _lbselect_line();
   _ctlae_edit_window.p_user=1;
   _ctlae_param_list.p_user=1;
   p_window_id=wid;
}

static void set_vis_all(int parentwid,boolean vis_val)
{
   wid=first=parentwid.p_child;
   for (;;) {
      wid.p_visible=vis_val;
      wid=wid.p_next;
      if (wid==first) break;
   }
}

static void children_visible(int widlist){set_vis_all(widlist,1);}

static void children_invisible(int widlist){set_vis_all(widlist,0);}

void _alias_editor_form.on_resize()
{
   border_width=p_active_form.p_width-_dx2lx(p_xyscale_mode,p_active_form.p_client_width);
   border_height=p_active_form.p_height-_dy2ly(p_xyscale_mode,p_active_form.p_client_height);
   button_buffer=(_ctlae_param_add.p_y-lastpixel_y(_ctlae_param_list));
   new_y=p_active_form.p_height-_ctlae_param_add.p_height-(button_buffer intdiv 2)-border_height;
   _control _ctlae_param_labelpn;
   _control _ctlae_param_labelps;
   _control _ctlae_param_labeliv;
   _control _ctlae_help;
   children_invisible(p_active_form)
   _ctlae_param_add.p_y=_ctlae_param_remove.p_y=_ctlae_param_edit.p_y=_ctlae_param_up.p_y=_ctlae_param_down.p_y=new_y;
   _ctlae_param_list.p_y=new_y-_ctlae_param_list.p_height-button_buffer;
   _ctlae_param_list.p_width=p_active_form.p_width-(_ctlae_param_list.p_x*2)-border_width;
   _ctlae_param_labelpn.p_y=_ctlae_param_labelps.p_y=_ctlae_param_labeliv.p_y=(_ctlae_param_list.p_y-_ctlae_param_labelpn.p_height);
   _ctlae_param_labelt.p_y=_ctlae_param_labelpn.p_y-_ctlae_param_labelt.p_height;
   _ctlae_labeldiv.p_y=_ctlae_param_labelt.p_y-_ctlae_labeldiv.p_height;
   _ctlae_labeldiv.p_x=0;_ctlae_labeldiv.p_width=p_active_form.p_width;
   button_y=_ctlae_labeldiv.p_y-_ctlae_ok.p_height-button_buffer;
   _ctlae_ok.p_y=_ctlae_new.p_y=_ctlae_delete.p_y=_ctlae_cancel.p_y=_ctlae_help.p_y=button_y
   children_visible(p_active_form);
   _ctlae_alias_list.p_height=_ctlae_ok.p_y-_ctlae_alias_list.p_x-button_buffer;
   _ctlae_edit_window.p_height=_ctlae_ok.p_y-_ctlae_alias_list.p_x-button_buffer;
   _ctlae_edit_window.p_width=_ctlae_param_list.p_width-_ctlae_edit_window.p_x+_ctlae_param_list.p_x;
}
_command int edit_extension_alias()
{
   if (arg(1)!='') {
      ext=refer_ext(_file_case(strip(arg(1))));
   }else{
      ext=p_extension;
   }
   index=find_index('def-alias-'ext,MISC_TYPE);
   if (!index) {
      _message_box(nls("No alias file for extension %s.",ext));
      return(1);
   }
   filename=name_info(index);
   if (filename=='') {
      _message_box(nls("No alias file for extension %s.",ext));
      return(1);
   }
   result=show('-modal _alias_editor_form',filename);
   return(0);
}
