/*
$VerboseHistory: c.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:07:43a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 07:42a
 * Comment:
 * Fixed problem with maybe_split_insert_line enter
 * key binding when in C mode.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:37p
 * Comment:
 * Adding new 3.0 stuff
*/
/*
  Don't modify this code unless defining extension specific
  aliases does not suite your needs.   For example, if you
  want your brace style to be:

       if () {
          }

  Use the Extension Options dialog box ("Other", "Configuration...",
  "File Extension Setup...") and press the the "Alias" button to
  display the Alias Editor dialog box.  Press the New button, type
  "if" for the name of the alias and press <Enter>.  Enter the
  following text into the upper right editor control:

       if (%\c) {
       %\i}

  The  %\c indicates where the cursor will be placed after the
  "if" alias expanded.  The %\i specifies to indent by the
  Extension Specific "Syntax Indent" amount define in the
  Extension Options dialog box.  Check the "Indent With Tabs"
  check box on the Extension Options dialog box if you want
  the %\i option to indent using tab characters.

*/
/*
  Options for C syntax expansion/indenting may be accessed from the
  Extension Options dialog ("Other", "Configuration...",
  "File Extension Setup...").

  The extension specific options is a string of five numbers separated
  with spaces with the following meaning:

    Position       Option
       1             Syntax indent amount
       2             expansion on/off.
       3             Minimum abbreviation.  Defaults to 1.  Specify large
                     value to avoid abbreviation expansion.
       4             Indent after open parenthesis.  Effects argument
                     lists and if/while/switch.
       5             begin/end style.  Begin/end style may be 0,1, or 2
                     as show below.  Add 4 to the begin end style if you
                     want braces inserted when syntax expansion occurs
                     (main and do insert braces anyway).  Typing a begin
                     brace, '{', inserts an end brace when appropriate
                     (unless you unbind the key).  If you want a blank
                     line inserted in between, add 8 to the begin end
                     style.  Default is 4.

                      Style 0
                          if () {
                             ++i;
                          }

                      Style 1
                          if ()
                          {
                             ++i;
                          }

                      Style 2
                          if ()
                            {
                            ++i;
                            }


       6             Indent first level of code.  Default is 1.
                     Specify 0 if you want first level statements to
                     start in column 1.
       7             Main style.  Main style may be 0,1, or 2 which
                     correspond to old C style, ansi C, or no expansion.
                     Default is 0.
       8             Indent CASE from SWITCH.  Default is 0.  Specify
                     1 if you want CASE statements indented from the
                     SWITCH statement. Begin/end style 2 not supported.
       9             Not always present.
                     UseContOnParameters
*/

#include 'slick.sh'

#define STYLE1_FLAG 1
#define STYLE2_FLAG 2
#define BRACE_INSERT_FLAG 4
#define BRACE_INSERT_LINE_FLAG 8
#define NO_SPACE_BEFORE_PAREN 16   // "if(" or "if ("

#define TK_ID 1
#define TK_NUMBER 1
#define TK_STRING 2
static _str gtkinfo;
static _str gtk;

#define C_COMMON_END_OF_STATEMENT_RE 'if|while|switch|for|case|default|public|private|protected|static|class|break|continue|do|else|goto|try|catch|return'

#define JAVA_MORE_END_OF_STATEMENT_RE 'abstract|final|native|synchronized|throw|volatile'
#define C_MORE_END_OF_STATEMENT_RE 'auto|enum|extern|register|struct|typedef|delete|finally|friend|inline|operator|overload|virtual|using|template|asm|throw|namespace'
#define RUL_MORE_END_OF_STATEMENT_RE 'abort|begin|downto|elseif|end|endfor|endif|endprogram|endswitch|endwhile|exit|function|program|prototype|repeat|step|then|to|typedef|until'

#define JAVA_NOT_FUNCTION_WORDS ' catch do for if return synchronized switch throw while '
#define C_NOT_FUNCTION_WORDS  ' int long double float boolean short unsigned char __asm __declspec __except catch do for if return sizeof typeid switch throw while with template const_cast static_cast dynamic_cast reinterpret_cast '
#define RUL_NOT_FUNCTION_WORDS  ' abort case downto elseif exit for goto if return step switch to until while '

#define C_BUILTIN_TYPES ' boolean char double float int long short signed unsigned void '
#define RUL_BUILTIN_TYPES ' BOOL BYREF CHAR HWND INT LIST LONG LPSTR NUMBER POINTER SHORT STRING '

// style3 refers to out C extension options dialog
int def_style3_indent_all_braces;

_command void c_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode('c');
}
_command void java_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode('java');
}
boolean _in_comment(...)
{
   if (p_lexer_name=='') {
      return(0);
   }
   in_ml_comment=arg(1);
   if (in_ml_comment==1) {
      color=_clex_find(0,'g');
      if (color==CFG_COMMENT) {
         // This code does not work when cursor is inbetween start chars
         // chars of mlcomment. i.e. "/<cursor>*" cursor is inbetween / and *.
         orig_modify=p_modify;
         get_line(line);
         orig_col=p_col;
         replace_line(expand_tabs(line,1,orig_col-1,'s'));
         insert_line(' 'expand_tabs(line,orig_col,-1,'s'));
         p_col=1;
         color=_clex_find(0,'g');
         if (!_delete_line()) {
            up();
         }
         replace_line(line);
         p_col=orig_col;
         p_modify=orig_modify;
      }
   } else {
      color=_clex_find(0,'g');
   }
#if 0
   if (color=='' && p_col>1) {
      left();
      color=_clex_find(0,'g');
      right();
   }
#endif
   return(color==CFG_COMMENT);
}
_command void c_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl . indent_case .
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) || _c_expand_enter(p_SyntaxIndent,expand,be_style,indent_fl,indent_case) ) {
      call_root_key(ENTER);
   } else if (_argument=='') {
      _undo('S');
   }

}
static int find_class_col()
{
   save_pos(p);
   status=search('class|[{}]','@-r');
   nest_level=0;
   for (;;) {
      if (status) {
         restore_pos(p);
         return(0);
      }
      cfg=_clex_find(0,'g');
      if (nest_level>=0 || cfg!=CFG_KEYWORD) {
         ch=get_text();
         if (ch=='{') {
            --nest_level;
         } else if (ch=='}') {
            ++nest_level;
         }
         status=repeat_search();
         continue;
      }
      first_non_blank();
      col=p_col;
      restore_pos(p);
      return(col);
   }
}
boolean _c_do_colon()
{
   if (p_col<=2) return(true);
   orig_col=p_col;
   left();left();
   cfg=_clex_find(0,'g');
   if (cfg==CFG_KEYWORD) {
      word=cur_word(junk);
      if (word=='public' || word=='private' || word=='protected' ) {
         first_non_blank();
         if (p_col!=orig_col-length(word)-1) {
            p_col=orig_col;
            return(true);
         }
         class_col=find_class_col();
         if (!class_col) {
            p_col=orig_col;
            return(true);
         }
         get_line(line);
         replace_line(indent_string(class_col-1):+strip(line,'L'));
         p_col=class_col+length(word)+1;
         return(false);
      }
   }
#if 1
   orig_linenum=p_line;
   save_pos(p);
   begin_col=c_begin_stat_col(false /* No RestorePos */,
                              false /* Don't skip first begin statement marker */,
                              false /* Don't return first non-blank */);
   // IF we found the beginning of this statement and it starts on
   //    the same line as the colon
   if (begin_col && p_line==orig_linenum) {
      word=cur_word(junk);
      if (word=='case' || word=='default') {
         first_non_blank();
         // IF the 'case' word is the first non-blank on this line
         if (p_col==begin_col) {
            parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl . indent_case .;
            get_line(cur_line);
            col=_c_last_switch_col();
            if ( col) {
               if ((indent_case && indent_case!='') || (be_style&STYLE2_FLAG)) {
                  col=col+p_SyntaxIndent
               }
               new_cur_line=indent_string(col-1):+strip(cur_line,'L');
               replace_line(new_cur_line);
               // adjust cursor column based on new length of line
               p_col=orig_col+length(new_cur_line)-length(cur_line);
            } else {
               p_col=orig_col;
            }
            return(false);
         }
      }
   }
   restore_pos(p);
#endif
   p_col=orig_col;
   return(true);
}
defeventtab c_keys
def ':'=c_colon
_command void c_colon() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   keyin(':');
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .
   if (!command_state()) {
      left();cfg=_clex_find(0,'g');
      right();
   }
   if ( command_state() || p_SyntaxIndent<0 ||
      _in_comment() || cfg==CFG_STRING) {
   } else {
      if (_c_do_colon() &&
          (def_codehelp_flags&VSCODEHELPFLAG_AUTO_LIST_MEMBERS)
         ) {
         _do_list_members(true,false);
      }
   /*} else if (_argument=='') {
      _undo('S');*/
   }
}
_command void c_space() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   was_space=(last_event():==' ')
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
         c_expand_space(p_SyntaxIndent,be_style,indent_fl) ) {
      if ( was_space ) {
         if ( command_state() ) {
            call_root_key(' ');
         } else {
            keyin(' ');
         }
      }
   } else if (_argument=='') {
      _undo('S');
   }
}
_command void c_begin() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_CMDLINE)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .;
   if (!command_state() && p_col>1) {
      left();cfg=_clex_find(0,'g');right();
   }
   if ( command_state() || cfg==CFG_STRING || _in_comment() || !expand ||
       c_expand_begin(expand,p_SyntaxIndent,be_style,indent_fl) ) {
      call_root_key('{');
   } else if (_argument=='') {
      _undo('S');
   }

}
_command void c_endbrace() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl . indent_case .
   if (!command_state() && p_col>1) {
      left();cfg=_clex_find(0,'g');right();
   }
   keyin('}');
   if ( command_state() || cfg==CFG_STRING || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment() ) {
   } else if (_argument=='') {
      get_line(line);
      if (line=='}') {
         col=c_endbrace_col(be_style);
         if (col) {
            replace_line(indent_string(col-1):+'}');
            p_col=col+1;
         }
      }
      _undo('S');
   }
}
/*

   look for beginning of statement by searching for the following
        '{', '}', ';', ':', 'if', 'while','switch','for', 'with' (perl)

   If a non-alpha symbol is found, we look ahead for the first a non-blank
   character that is not in a comment.

   NOTE:  Calling this function for code like the following will
      find the beginning of the code block and not the statement:

      <Find Here>for (...) ++i<Cursor Here>
      <Find Here>if/while (...) ++i<Cursor Here>
*/
int c_begin_stat_col(boolean RestorePos,boolean SkipFirstHit,boolean ReturnFirstNonBlank,...)
{
   orig_linenum=p_line;orig_col=p_col;
   FailIfNoPrecedingText=(arg(4)!="");
   AlreadyRecursed=(arg(5)!="");
   FailWithMinus1_IfNoTextAfterCursor=(arg(6)!="");
   //ReturnCurColIfCursorBetweenOpenBraceAndEOF=1;
   save_pos(p);
   status=search('[{};:()]|with|if|while|switch|for','-R@');
   nesting=0;
   hit_top=false;
   MaxSkipPreprocessing=VSCODEHELP_MAXSKIPPREPROCESSING;
   for (;;) {
      if (status) {
         top();
         hit_top=true;
      } else {
         cfg=_clex_find(0,'g');
         if (cfg==CFG_COMMENT || cfg==CFG_STRING) {
            SkipFirstHit=false;
            status=repeat_search();
            continue;
         }
         switch (get_text()) {
         case '(':
            FailIfNoPrecedingText=false;
            if (nesting>0) {
               --nesting;
            }
            SkipFirstHit=false;
            status=repeat_search();
            continue;
         case ')':
            FailIfNoPrecedingText=false;
            ++nesting;
            SkipFirstHit=false;
            status=repeat_search();
            continue;
         }
         if (SkipFirstHit || nesting) {
            FailIfNoPrecedingText=false;
            SkipFirstHit=false;
            status=repeat_search();
            continue;
         }
         if (_in_c_preprocessing()) {
            --MaxSkipPreprocessing;
            if (MaxSkipPreprocessing<=0) {
               status=STRING_NOT_FOUND_RC;
               continue;
            }
            SkipFirstHit=false;
            begin_line();
            status=repeat_search();
            continue;
         }

         ch=get_text();
         if (!AlreadyRecursed && ch:==':') {
            save_pos(p2);
            if (p_col!=1) {
               left();
               // IF we are seeing  classname::name
               if (get_text()==':') {
                  status=repeat_search();
                  continue;
               }
               right();
            }
            col=c_begin_stat_col(false,true,false,"",1);
            word=cur_word(junk);
            if (word=='case' || word=='default' || word=='public' || word=='private' || word=='protected') {
               restore_pos(p2);
               right();
            }
         } else {
            if (isalpha(ch)) {
               if(cfg!=CFG_KEYWORD) {
                  if (cfg!=CFG_STRING && cfg!=CFG_COMMENT) {
                     FailIfNoPrecedingText=false;
                  }
                  status=repeat_search();
                  continue;
               }
            } else {
               right();
            }
         }
      }
      status=_clex_skip_blanksNpp();
      if (status) {
         restore_pos(p);
         /*
             Would could have an open brace followed by blanks and eof.
         */
         if (!hit_top) {
            if (!FailWithMinus1_IfNoTextAfterCursor) {
               return(p_col);
            }
            return(-1);
         }
         return(0);
      }
      /*
          We could have the following:

            class name:public name2 {

          recurse to look for "case" keyword

      */
      if (ReturnFirstNonBlank) {
         first_non_blank();
      }
      col=p_col;
      if (hit_top && FailIfNoPrecedingText && (p_line>orig_linenum || (p_line==orig_linenum)&& p_col>orig_col)) {
         return(0);
      }
      if (RestorePos) {
         restore_pos(p);
      }
      return(col);
   }

}

/*

   On entry, the cursor is sitting on a } (close brace)

   static void
      main () /* this is a test */ {
   }
   static void main /* this is a test */
     ()
   {
   }

   for (;;) {     for (;;)        for (;;)
                  {                  {
                  }                  }
   }
   style 0        style 1         style 2

   Returns column where end brace should go.
   Returns 0 if this function does not know the column where the
   end brace should go.
*/
int c_endbrace_col(int be_style)
{
   return(c_endbrace_col2(be_style,style3_MustBackIndent));
}
int c_endbrace_col2(int be_style,boolean &style3_MustBackIndent)
{
   style3_MustBackIndent=false;
   if (p_lexer_name=='') {
      return(0);
   }
   save_pos(p);
   --p_col;
   // Find matching begin brace
   status=_find_matching_paren(def_pmatch_max_diff);
   if (status) {
      restore_pos(p);
      return(0);
   }
   // Assume end brace is at level 0
   if (p_col==1) {
      restore_pos(p);
      return(1);
   }
   save_pos(p2);
   begin_brace_col=p_col;
   // Check if the first char before open brace is close paren
   col= find_block_col();
   //messageNwait('col='col);
   if (!col) {
      restore_pos(p2);
#if 0
      if ((be_style & STYLE2_FLAG) && def_style3_indent_all_braces) {
         // check if this parenthesis is on a line by itself;
         get_line(line);
         if (line=="{") {
            style3_MustBackIndent=true;
            first_non_blank();
            col=p_col;
            restore_pos(p);
            return(col);
         }
      }
#endif
      col=c_begin_stat_col(true,true,true);
      restore_pos(p);
      if ((be_style & STYLE2_FLAG) && def_style3_indent_all_braces) {
         style3_MustBackIndent=true;
         parse name_info(_edit_window().p_index) with . .;
         col+=p_SyntaxIndent;
      }
      return(col);
   }
   style3_MustBackIndent=true;
   style=(be_style & (STYLE1_FLAG|STYLE2_FLAG));
   if ((be_style & (STYLE2_FLAG))) {
      restore_pos(p);
      //return(begin_brace_col);
      parse name_info(_edit_window().p_index) with . .
      return(col+p_SyntaxIndent);
   }
   restore_pos(p);
   return(col);
}
/*

    When this function fails the cursor is not necessarily
    placed at the top or bottom of the buffer.  This needs
    to be corrected.  However, we don't want to break
    the select_proc() function.
*/
int _clex_skip_blanks(...)
{
   search_options='@r'arg(1);
   clex_options='n'stranslate(lowcase(arg(1)),'','m');
   clex_options=stranslate(clex_options,'','h');
   for (;;) {
      // search for non-blank character
      status=search('[~ \t]','@r'search_options);
      if (status) return(1);
      if (_in_comment()) {
         status=_clex_find(COMMENT_CLEXFLAG,'n'clex_options);
         if (status) {
            /* This changes was made for select_proc() */
            if (pos('-',arg(1))) {
               top();
            } else {
               bottom();
            }
            return(1);
         }
         continue;
      }
      return(0);
   }

}
static int find_block_col()
{
   --p_col;
   if (_clex_skip_blanks('-')) return(0);
   if (get_text()!=')') {
      if (_clex_find(0,'g')!=CFG_KEYWORD) {
         return(0);
      }
      word=cur_word(col);
      if (word=='do' || word=='else') {
         first_non_blank();
         return(p_col);
         //return(p_col-length(word)+1);
      }
      return(0);
   }
   // Here we match round parens. ()
   status=_find_matching_paren(def_pmatch_max_diff);
   if (status) return(0);
   if (p_col==1) return(1);
   --p_col;

   if (_clex_skip_blanks('-')) return(0);
   /*if (_clex_find(0,'g')!=CFG_KEYWORD) {
      return(0);
   }
   */
   word=cur_word(col);
   if (pos(' 'word' ',' with for if switch while ')) {
      first_non_blank();
      return(p_col);
      //return(p_col-length(word)+1);
   } else if (p_extension=='java') {
      // Check if we have a new construct
      p_col=_text_colc(col,'I');
      if (p_col>1) {
         left();
         if (_clex_skip_blanks('-')) return(0);
         word=cur_word(col);
         if (word=='new') {
            p_col=_text_colc(col,'I');
            col=p_col;
            first_non_blank();
            if (col!=p_col) {
               p_col+=p_SyntaxIndent;
            }
            return(p_col);
         }
      }
   }
   return(0);
}
#define EXPAND_WORDS (' #define #elif #else #endif #error #if #ifdef #ifndef':+\
                ' #include #pragma #undef else typedef static struct class union public private protected ')

#define JAVA_ONLY_EXPAND_WORDS ' final import '

static _str space_words[]={'#define', '#elif',   '#else', '#endif',  '#error','#if','#ifdef',
                      '#ifndef', '#include','#pragma','#undef', 'break', 'case','class',
                      'continue','default', 'do',     'else',   'for',   'if',  'main','printf',
                      'private','protected','public','return',   'struct', 'switch', 'typedef','union', 'while'};

static _str java_space_words[]={'break', 'case','class',
                      'continue','default', 'do',     'else',   'for',   'if',  'main',
                      'private','protected','public','return',   'struct', 'switch', 'typedef','union', 'while',
                      // Add java keywords
                      /*'final','import'*/
                      };
static _str javascript_space_words[]={'break', 'case',
                      'continue','default', 'do', 'else',   'for',
                      'if', 'return', 'switch','while',
                      'export','function', 'import', 'var', 'with',
                      };

_str _skip_pp

c_get_info(var Noflines,var cur_line,var first_word,var last_word,
                          var rest,var non_blank_col,var semi,var prev_semi)
{
   save_pos(old_pos);
   first_word='';last_word='';non_blank_col=p_col;
   orig_col=p_col;
   for (j=0;  ; ++j) {
      get_line cur_line
      if (arg(9)!='') {
         _begin_line();
         i=verify(cur_line,' '\t);
         if ( i ) p_col=text_col(cur_line,i,'I');
         bool=cur_line!='' && (substr(strip(cur_line),1,1)!='#' || _skip_pp=='') && _clex_find(0,'g')!=CFG_COMMENT;
      } else {
         bool=cur_line!='' && (substr(strip(cur_line),1,1)!='#' || _skip_pp=='');
      }
      if ( bool){
         parse cur_line with line '/*' /* Strip comment on current line. */
         parse line with line '//' /* Strip comment on current line. */
         parse line with before_brace '{' +0 last_word
         parse strip(line,'L') with first_word '[({:; \t]','r' +0 rest
         last_word=strip(last_word)
         parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl . indent_case .;
         syntax_indent=p_SyntaxIndent;
         if (last_word=='{' && !(be_style & STYLE2_FLAG)) {
            save_pos(p2);
            p_col=text_col(before_brace);
            _clex_skip_blanks('-');
            status=1;
            if (get_text()==')') {
               status=_find_matching_paren(def_pmatch_max_diff);
            }
            if (!status) {
               status=1;
               if (p_col==1) {
                  up();_end_line();
               } else {
                  left
               }
               _clex_skip_blanks('-');
               if (_clex_find(0,'g')==CFG_KEYWORD) {
                  kwd=cur_word(junk);
                  status=!pos(' 'kwd' ',' with if while switch for ');
               }
            }
            if (status) {
               non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I')
               restore_pos(p2);
            } else {
               get_line(line);
               non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I')
               /* Use non blank of start of if, do, while, which, or for. */
            }
         } else {
            non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I')
         }
         Noflines=j;
         break;
      }
      if ( up() ) {
         restore_pos(old_pos);
         return(1);
      }
      if (j>=100) {
         restore_pos(old_pos);
         return(1);
      }
   }
   if (arg(9)!='') {
      if (!j) p_col=orig_col;
   }
   p='';
   if ( j ) {
      p=1;
   }
   semi=stat_has_semi(p);
   prev_semi=prev_stat_has_semi();
   restore_pos(old_pos);
   return(0);
}
boolean _in_c_preprocessing()
{
   save_pos(p);
   //get_line(line);line=strip(line,'L');
   for (;;) {
      get_line(line);line=strip(line,'L');
      if (substr(line,1,1)=="#") {
         restore_pos(p);
         return(true);
      }
      up();
      if (_on_line0()) {
         restore_pos(p);
         return(false);
      }
      //get_line(line);line=strip(line,'L');
      _end_line();left();
      if (get_text()=='\') {
      //if (last_char(line)=='\') {
         _end_line();left();
         cfg=_clex_find(0,'g');
         if (cfg==CFG_COMMENT && cfg==CFG_STRING) {
            restore_pos(p);
            return(false);
         }
      } else {
         restore_pos(p);
         return(false);
      }
   }

}
/* Returns non-zero number if pass through to enter key required */
_str _c_expand_enter(syntax_indent,expand,be_style,indent_fl,indent_case)
{
   save_pos(p);
   orig_linenum=p_line;
   orig_col=p_col;
   enter_cmd=name_on_key(ENTER);
   if (enter_cmd=='nosplit-insert-line') {
      _end_line();
   }
   if (_in_c_preprocessing()) {
      restore_pos(p);
      return(1);
   }
   begin_col=c_begin_stat_col(false /* No RestorePos */,
                              false /* Don't skip first begin statement marker */,
                              false /* Don't return first non-blank */,
                              1  /* Return 0 if no code before cursor. */,
                              '',
                              1
                              );
   if (!begin_col /*|| (p_line>orig_linenum)*/) {
      restore_pos(p);
      return(1);
   }
   status=0
   style1=be_style & STYLE1_FLAG;
   style2=be_style & STYLE2_FLAG;
   LineEndsWithBrace=0;
   if (_modename_eq(p_mode_name,'Java')) {
      java=1;
   } else if (_modename_eq(p_mode_name,'JavaScript')) {
      java=2;
   }
   if (p_line>orig_linenum) {
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      _clex_skip_blanksNpp("-");
      LineEndsWithBrace= (orig_linenum==p_line && get_text()=='{');
      first_non_blank();
   } else if (p_line==orig_linenum && begin_col<0) {
      LineEndsWithBrace= (orig_linenum==p_line && get_text()=='{');
      first_non_blank();
   }
   first_word_col=p_col;
   first_word=cur_word(junk);
   get_line(cur_line);
   BeginningOfStatementOnSameLine=(orig_linenum==p_line);
   restore_pos(p);
   enter_cmd=name_on_key(ENTER);
   if ( expand && BeginningOfStatementOnSameLine &&
        !(_expand_tabsc(orig_col)!="" &&
          (name_on_key(ENTER):=='split-insert-line' ||
           (name_on_key(ENTER):=='maybe-split-insert-line' && _insert_state())
          )
        )
        ) {
      if ( cur_line=='main' && !java) {
         status=c_insert_main();
      } else if ( first_word=='for' && name_on_key(ENTER):=='nosplit-insert-line' ) {
         if ( name_on_key(ENTER):=='nosplit-insert-line' ) {
            /* tab to fields of C for statement */
            p_col=orig_col;
            line=expand_tabs(cur_line);
            semi1_col=pos(';',line,p_col);
            if ( semi1_col>0 && semi1_col>=p_col ) {
               p_col=semi1_col+1;
            } else {
               semi2_col=pos(';',line,semi1_col+1)
               if ( (semi2_col>0) && (semi2_col>=p_col) ) {
                  p_col=semi2_col+1;
               } else {
                  status=1;
               }
            }
         } else {
            status=1;
         }
      } else if ( (first_word=='case' || first_word=='default') &&
                 (orig_col>first_word_col ||
                  enter_cmd=='nosplit-insert-line') ) {
         eol='';
         if(enter_cmd:=='split-insert-line' || (enter_cmd=='maybe-split-insert-line' && _insert_state())){
            get_line(orig_line);
            eol=expand_tabs(orig_line,p_col,-1,'s');
            replace_line(expand_tabs(orig_line,1,p_col-1,'s'));
         }
         /* Indent case based on indent of switch. */
         col=_c_last_switch_col();
         if ( col && eol:=='') {
            if ((indent_case && indent_case!='') || (be_style&STYLE2_FLAG)) {
               col=col+syntax_indent;
            }
            replace_line(indent_string(col-1):+""strip(cur_line,'L'));
            _end_line();
         }
         indent_on_enter(syntax_indent);
         if (eol:!='') {
            replace_line(indent_string(p_col-1):+eol);
         }
      } else if ( first_word=='switch' && LineEndsWithBrace) {
         down();
         get_line(line);
         up();
         extra_case_indent=0;
         if ((indent_case && indent_case!='') || (be_style&STYLE2_FLAG)) {
            extra_case_indent=syntax_indent;
         }
         if ( pos('}',line) > 0 ) {
            indent_on_enter(syntax_indent);
            get_line(line);
            if ( line=='' ) {
               col=p_col-syntax_indent;
               replace_line(indent_string(col-1+extra_case_indent)'case :');
               _end_line;left();
            }
         } else {
            indent_on_enter(syntax_indent)
            get_line(line);
            if ( line=='' ) {
               col=p_col-syntax_indent;
               replace_line(indent_string(col-1+extra_case_indent)'case :');
               _end_line;left();
            }
         }
     } else {
       status=1;
     }
   } else {
     status=1;
   }
   if ( status ) {  /* try some more? Indenting only. */
      status=0;
      col=c_indent_col2(0,0);
      indent_on_enter('',col);
   }
   return(status)
}
// Return column position on switch or 0 if not found
int _c_last_switch_col()
{
   if (p_lexer_name=='') {
      return(0);
   }
   save_pos(p);
   // Find switch at same brace level
   // search for begin brace,end brace, and switch not in comment or string
   status=search('\{|\}|switch','@r-');
   level=0;
   for (;;) {
      if (status) {
         restore_pos(p);
         return(0);
      }
      word=get_text(match_length(),match_length('S'));
      color=_clex_find(0,'g');
      //messageNwait('word='word);
      if (color!=CFG_STRING && color!=CFG_COMMENT) {
         switch (word) {
         case '}':
            --level;
            break;
         case '{':
            ++level;
            break;
         default:
            if (color==CFG_KEYWORD && level== 1) {
               result=p_col;
               restore_pos(p);
               return(result);
            }
         }
      }
      status=repeat_search();
   }
}

static int NoSyntaxIndentCase(int non_blank_col,int orig_linenum,int orig_col,typeless p,int syntax_indent)
{
   //_message_box("This case not handled yet");
   // Smart paste should set the non_blank_col
   if (non_blank_col) {
      //messageNwait("fall through case 1");
      restore_pos(p);
      return(non_blank_col);
   }
   restore_pos(p);
   begin_stat_col=c_begin_stat_col(false /* No RestorePos */,
                                   false /* Don't skip first begin statement marker */,
                                   true  /* Don't return first non-blank */
                                   );

   if (begin_stat_col && (p_line<orig_linenum ||
                          (p_line==orig_linenum && p_col<=orig_col)
                         )
      ) {
#if 0
      /*
          We could have code at the top of a file like the following:

             int myproc(int i)<ENTER>

             int myvar=<ENTER>
             class foo :<ENTER>
                public name2

      */
      //messageNwait("fall through case 2");
      restore_pos(p);
      return(begin_stat_col);
#endif
      /*
         Check if partial statement ends with close paren.  This
         could be a function declaration.

         Another to handle this is to to indent any way and then
         move the open brace to the correct colmun position when
         the users types it.
      */
      save_pos(p2);
      p_line=orig_linenum;p_col=orig_col;
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      _clex_skip_blanksNpp("-");
      ch=get_text();
      if (ch:==")") {
         restore_pos(p);
         return(begin_stat_col);
      }
      restore_pos(p2);
      /*
         Here we have something like
         int i;
            int k,<ENTER>
               <Cursor goes here>
               OR
         VOID<ENTER>
         <Cursor goes here>myproc()
      */
      col=p_col;
      // Here we assume that functions start in column 1 and
      // variable declarations or statement continuations do not.
      // This seems to be a common solution.
      if (p_col==1 && ch!=',') {
         restore_pos(p);
         return(col);
      }
      nextline_indent=syntax_indent;
      restore_pos(p);
      return(col+nextline_indent);
   }
   restore_pos(p);
   get_line(line);line=expand_tabs(line);
   if (line=="") {
      restore_pos(p);
      return(p_col);
   }
   //messageNwait("fall through case 3");
   first_non_blank();
   col=p_col;
   restore_pos(p);
   return(col);
}
/*
   Skip blanks and preprocessing
*/
int _clex_skip_blanksNpp(...)
{
   MaxSkipPreprocessing=VSCODEHELP_MAXSKIPPREPROCESSING;
   backwards=pos('-',arg(1));
   for (;;) {
      status=_clex_skip_blanks(arg(1));
      if (status) {
         return(status);
      }
      /*if (p_line>FailIfPastLinenum) {
         messageNwait("p_line="p_line" FailIfPastLinenum="FailIfPastLinenum);
         return(STRING_NOT_FOUND_RC);
      }*/
      if (!_in_c_preprocessing()) {
         return(status);
      }
      --MaxSkipPreprocessing;
      if (MaxSkipPreprocessing<=0) {
         return(STRING_NOT_FOUND_RC);
      }
      if (backwards) {
         up();_end_line();
      } else {
         _end_line();
      }
   }
}
static int HandlePartialStatement(int statdelim_linenum,
                                  int sameline_indent,
                                  int nextline_indent,
                                  int orig_linenum,int orig_col)
{
   orig_ch=get_text();
   save_pos(orig_pos);
   //linenum=p_line;col=p_col;

   /*
       Note that here we don't return first non-blank to handle the
       following case:

       for (;
            ;<ENTER>) {

       However, this does effect the following unusual case
           if (i<j) {abc;<ENTER>def;
           <end up here which is not correct>

       We won't worry about this case because it is unusual.
   */
   begin_stat_col=c_begin_stat_col(false /* No RestorePos */,
                                   false /* Don't skip first begin statement marker. */,
                                   false /* Don't return first non-blank */,
                                   '',
                                   '',
                                   1   // Fail if no text after cursor
                                   );
   if (begin_stat_col>0 && (p_line<orig_linenum || (p_line==orig_linenum && p_col<orig_col))
        /* && (linenum!=p_line || col!=p_col) */
      ) {
      // Now get the first non-blank column.
      begin_stat_col=c_begin_stat_col(false /* No RestorePos */,
                                      false /* Don't skip first begin statement marker. */,
                                      true /* Return first non-blank */
                                      );
      /*
         Check if partial statement ends with close paren.  This
         could be a function declaration.

         Another to handle this is to to indent any way and then
         move the open brace to the correct colmun position when
         the users types it.
      */
      save_pos(p);
      p_line=orig_linenum;p_col=orig_col;
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      _clex_skip_blanksNpp("-");
      ch=get_text();
      if (ch:==")") {
         return(begin_stat_col);
      }
      if (orig_ch:=='}' && ch:==',' && statdelim_linenum==p_line) {
         /*
             Also check if this line ends with a comma and handle the
             case where the user is in a declaration list like
             the following.

             MYSTRUCT array[]={
                {a,b,c},<ENTER>
                a,
                {a,b,c},<ENTER>
                {a,b,c},a,b,<ENTER>
                {a,{a,b,c}},<ENTER>
                d,
                {a,
                 {a,b,c}},
                 x,<ENTER>
                },
                b,
         */
         restore_pos(orig_pos);
         status=_find_matching_paren(def_pmatch_max_diff);
         if (!status) {
            first_non_blank();
            return(p_col);
         }
      }
      restore_pos(p);
      /*
         IF semicolon is on same line as extra characters

         Example
            {b=<ENTER>
      */
      if (p_line==statdelim_linenum) {
         return(begin_stat_col+sameline_indent);
      }
      /*
         Here we have something like
         int i;
            int k,<ENTER>
               <Cursor goes here>
               OR
         VOID<ENTER>
         <Cursor goes here>myproc()
      */
      col=p_col;
      // Here we assume that functions start in column 1 and
      // variable declarations or statement continuations do not.
      // This seems to be a common solution.
      if (p_col==1 && ch!=',') {
         return(col);
      }
      return(col+nextline_indent);
   }
   return(0);
}
/*
     All parameters are ignored except non_blank_col.  Specify
     non_blank_col==0 if you want it ignored too.

     NOTE:  The caller should check if the user is calling this
     function when inside a comment (use _in_comment(1) function).
*/
int c_indent_col(int non_blank_col,boolean pasting_open_brace2)
{
   return(c_indent_col2(non_blank_col,pasting_open_brace2));
}
/*


*/
static int c_indent_col2(int non_blank_col,boolean pasting_open_brace2)
{
   orig_col=p_col;
   orig_linenum=p_line;
   save_pos(p);
   parse name_info(p_index) with . expand . . be_style indent_fl . indent_case UseContOnParameters .;
   syntax_indent=p_SyntaxIndent;
   if ( syntax_indent<=0) {
      // Find non-blank-col
      return(NoSyntaxIndentCase(non_blank_col,orig_linenum,orig_col,p,0));
   }
   style1=be_style & STYLE1_FLAG;
   style2=be_style & STYLE2_FLAG;

   if (pasting_open_brace2) {
      // Look for for,while,switch
      typeless p2;
      save_pos(p2);
      col= find_block_col();
      restore_pos(p2);
      if (col) {
         restore_pos(p);
         if (style2) {
            return(col+syntax_indent);
         }
         return(col);
      }
      /*
          Note:
             pasting open brace does not yet work well
             for style2 when pasting brace out side class/while/for/switch blocks.
             Braces are not indented.

             pasting open brace does not yet work well
             for style2!=2 when pasting braces for a class.  Braces
             end up indented when they are not supposed to be.
      */
   }
/*
   beginning of statement
     {,},;,:

   cases
     -  in-comment or in-string
     - for (;;) <ENTER>


     - myproc(myproc() <ENTER>
     - myproc(a,<ENTER>
     - myproc(a);
     - if/while/for/switch (...) <ENTER>
     - (col1)myproc(a)<ENTER>
     - (col>1)myproc(a)<ENTER>
     - (col>1)myproc(a)<ENTER>
     - case a: <ENTER>
     - default: <ENTER>
     -  if (...) {<ENTER>
     -  if (...) <ENTER>
     -  if (...) ++i; else <ENTER>
     -  if (...) ++i; else <ENTER>
     -  myproc (...) {<ENTER>
     -  statement;
         {<ENTER>
     -  if (a && b
     -  if (a && b,b
     -  <ENTER>  no code above
     -  int a,
     -  if {
           }<ENTER>
     -  {
        }<ENTER>
     - for (;<ENTER>;<ENTER>)
     - for (<ENTER>;;<ENTER>)
     - for (i=1;i<j;<ENTER>
     - if (a<b) {
          x=1;
       } else if( sfsdfd) {<ENTER>}

     {sdfsdf;
      ddd


*/


   enter_cmd=name_on_key(ENTER);
   if (enter_cmd=='nosplit-insert-line') {
      _end_line();
   }
   /*
       Handle a few special cases where line begins with
         close brace, "case", "default","public", "private",
         and "protected".
   */
   {
      typeless p2;
      save_pos(p2);
      first_non_blank();
      if (orig_col<=p_col) {
         cfg=_clex_find(0,'g');
         if (cfg!=CFG_COMMENT && cfg!=CFG_STRING) {
            ch=get_text();
            if (ch=="}") {
               right();
               col=c_endbrace_col(be_style);
               if (col) {
                  restore_pos(p);
                  return(col);
               }
            } else if (cfg==CFG_KEYWORD) {
               word=cur_word(junk);
               if (word=='public' || word=='private' || word=='protected') {
                  class_col=find_class_col();
                  if (class_col) {
                     restore_pos(p);
                     return(class_col);
                  }
               } else if (word=='case' || word=='default') {
                  col=_c_last_switch_col();
                  if ( col) {
                     if ((indent_case && indent_case!='') || (be_style&STYLE2_FLAG)) {
                        col=col+syntax_indent;
                     }
                     restore_pos(p);
                     return(col);
                  }
               }

            }
         }
      }
      restore_pos(p2);
   }

   nesting=0;OpenParenCol=0;
   if (p_col==1) {
      up();_end_line();
   } else {
      left();
   }
   MaxSkipPreprocessing=VSCODEHELP_MAXSKIPPREPROCESSING;

   status=search("[{;}:()]|with|if|while|for|switch","@r-");
   for (;;) {
      if (status) {
         if (nesting<0) {
            restore_pos(p);
            return(OpenParenCol+1/*+def_c_space_after_paren*/);
         }
         return(NoSyntaxIndentCase(non_blank_col,orig_linenum,orig_col,p,syntax_indent));
      }

      cfg=_clex_find(0,'g');
      if (cfg==CFG_COMMENT || cfg==CFG_STRING) {
         status=repeat_search();
         continue;
      }

      ch=get_text();
      switch (ch) {
      case '(':
         if (!nesting && !OpenParenCol) {
            typeless p3;
            save_pos(p3);
#if 1
            save_search(ss1,ss2,ss3,ss4);
            col=p_col;
            ++p_col;
            status=_clex_skip_blanksNpp();


            if (!(UseContOnParameters==1) &&
                !status && (p_line<orig_linenum ||
                            (p_line==orig_linenum && p_col<orig_col)
                           )) {
               col=p_col-1;
            } else {
               /*
                  case: Use continuation indent instead of lining up on
                  open paren.
                  
                  aButton.addActionListener(<Enter here. No args follow>
                      a,
                      b,
               */
               restore_pos(p3);
               goto_point(_nrseek()-1);
               //if (_clex_skip_blanks('-')) return(0);
               //word=cur_word(junk);
               c_prev_sym();
               if (gtk==TK_ID && !pos(' 'gtkinfo' ',' with for if switch while ')) {
                  restore_pos(p3);
                  first_non_blank();
                  col=p_col+p_SyntaxIndent-1;
               } 
            }
            restore_search(ss1,ss2,ss3,ss4);
#else
            save_search(ss1,ss2,ss3,ss4);
            col=p_col;
            ++p_col;
            status=_clex_skip_blanksNpp();
            if (!status && (p_line<orig_linenum ||
                            (p_line==orig_linenum && p_col<=orig_col)
                           )) {
               col=p_col-1;
            }
            restore_search(ss1,ss2,ss3,ss4);
#endif
            OpenParenCol=col;
            restore_pos(p3);
         }
         --nesting;
         status=repeat_search();
         continue;
      case ')':
         ++nesting;
         status=repeat_search();
         continue;
      default:
         if (nesting<0) {
            //messageNwait("nesting case");
            restore_pos(p);
            return(OpenParenCol+1/*+def_c_space_after_paren*/);
         }
      }
      if (nesting ) {
         status=repeat_search();
         continue;
      }
      if (_in_c_preprocessing()) {
         begin_line();
         status=repeat_search();
         continue;
      }
      //messageNwait("c_indent_col2: ch="ch);
      switch (ch) {
      case '{':
         //messageNwait("case {");
         openbrace_col=p_col;
         statdelim_linenum=p_line;
         /*
            Could have
              for (;
                    ;) {<ENTER>

              myproc ( xxxx ) {<ENTER>

              myproc (xxx ) {
                 int i,<ENTER>

              {<ENTER>

              else {<ENTER>

              else
                 {<ENTER>

              class name : public name2 {<ENTER>

              if ( xxx ) {<ENTER>

              if ( xxx )
                 {<ENTER>

              if ( xxx )
              {<ENTER>

              int array[]={
                 a,
                 b,<ENTER>

         */
         save_pos(p2);

         /*
            Check for the array/struct initialization case by
            check for equal sign before open brace.  This won't
            work if preprocessing is present.

              int array[]={
                 a,
                 b,<ENTER>
                 int a,
                 b,
                 c,


            also check for enum declaration like
               enum {
                 a,
                 b,
            or
               enum XXX {
                  a,
                  b,

         */
         if (p_col==1) {
            up();_end_line();
         } else {
            left();
         }
         _clex_skip_blanksNpp('-');
         cfg=_clex_find(0,'g');
         in_init=(get_text()=='=') || (cfg==CFG_KEYWORD && cur_word(junk)=='enum');
         if (!in_init && cfg==CFG_WINDOW_TEXT && pos('[a-zA-Z0-9_$]',get_text(),1,'r')) {
            status=search("[^a-zA-Z0-9_$]","@-R");
            if (!status) {
               _clex_skip_blanksNpp('-');
               if (_clex_find(0,'g')==CFG_KEYWORD && cur_word(junk)=='enum') {
                  in_init=1;
               }
            }
         }
         if (in_init) {
            restore_pos(p2);
            begin_stat_col=c_begin_stat_col(false /* No RestorePos */,
                                            true /* skip first begin statement marker */,
                                            true /* return first non-blank */
                                            );
            restore_pos(p2);
            // Now check if there are any characters between the
            // beginning of the previous statement and the original
            // cursor position
            col=HandlePartialStatement(statdelim_linenum,
                                       syntax_indent,0,
                                       orig_linenum,orig_col);
            if (col) {
               restore_pos(p);
               return(col);
            }
         }

         restore_pos(p2);

         if (p_col==1) {
            up;_end_line();
         } else {
            left();
         }
         _clex_skip_blanksNpp('-');
         status=1;
         if (get_text()==')') {
            status=_find_matching_paren(def_pmatch_max_diff);
            save_pos(p3);
         }
         if (!status) {
            status=1;
            if (p_col==1) {
               up();_end_line();
            } else {
               left();
            }
            _clex_skip_blanksNpp('-');
            if (_clex_find(0,'g')==CFG_KEYWORD) {
               kwd=cur_word(junk);
               status=!pos(' 'kwd' ',' with if while switch for catch ');
               // IF this is the beginning of a "if/while/switch/for" block
               if (!status) {
                  first_non_blank();
                  block_col=p_col;
                  // Now check if there are any characters between the
                  // beginning of the previous statement and the original
                  // cursor position
                  restore_pos(p2);


                  col=HandlePartialStatement(statdelim_linenum,
                                             syntax_indent,syntax_indent,
                                             orig_linenum,orig_col);
                  if (col) {
                     restore_pos(p);
                     return(col);
                  }

                  restore_pos(p);
                  return(block_col+syntax_indent);
               }
            } else if (p_extension=='java') {
               /*
                   
                   // case 1:  just blanks after open paren.  Use continuation indent.
                   aButton.addActionListener(
                       a,
                       b,
                       new ActionListener() {
                           public void actionPerformed(ActionEvent e) {
                               createdButtonFired(buttonIndex);
                           }
                       },
                       b,
                       );
                  // case 2:  First argument is new constructor
                  aButton.addActionListener(new ActionListener() {
                          public void actionPerformed(ActionEvent e) {
                              createdButtonFired(buttonIndex);
                          }
                      },
                      b,
                      );
               
               */
               // Check if we have a new construct
               kwd=cur_word(col);
               p_col=_text_colc(col,'I');
               if (p_col>1) {
                  left();
                  if (_clex_skip_blanks('-')) return(0);
                  word=cur_word(col);
                  if (word=='new') {
                     p_col=_text_colc(col,'I');
                     col=p_col;
                     first_non_blank();
                     if (col!=p_col) {
                        p_col+=p_SyntaxIndent;
                     }
                     col=p_col+p_SyntaxIndent;
                     restore_pos(p);
                     return(col);
                  }
               }
            }

            // Now check if there are any characters between the
            // beginning of the previous statement and the original
            // cursor position
            restore_pos(p2);
            col=HandlePartialStatement(statdelim_linenum,
                                       syntax_indent,syntax_indent,
                                       orig_linenum,orig_col);
            if (col) {
               restore_pos(p);
               return(col);
            }

            //  This open brace is to a function or method or some
            //  very strange preprocessing.
            restore_pos(p2); // Restore cursor to open brace
            first_non_blank();
            if (p_col==openbrace_col) {
               begin_stat_col=openbrace_col;
            } else {
               restore_pos(p3); // Restore cursor to open paren
               begin_stat_col=c_begin_stat_col(false /* No RestorePos */,
                                               false /* Don't skip first begin statement marker */,
                                               false /* Don't return first non-blank */
                                               );
               if ((be_style & STYLE2_FLAG) && def_style3_indent_all_braces) {
                  begin_stat_col+=syntax_indent;
               }
            }

            if (begin_stat_col==1 && !indent_fl) {
               restore_pos(p);
               return(1);
            }
            restore_pos(p);
            if ((be_style & STYLE2_FLAG) && def_style3_indent_all_braces) {
               return(begin_stat_col);
            }
            return(begin_stat_col+syntax_indent);
         }
         restore_pos(p2);
         // Now check if there are any characters between the
         // beginning of the previous statement and the original
         // cursor position


         // Now check if there are any characters between the
         // beginning of the previous statement and the original
         // cursor position
         restore_pos(p2);
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }

         /*
             Probably have one of these case here

              {<ENTER>

              else {<ENTER>

              else
                 {<ENTER>

              class name : public name2 {<ENTER>

              if (a<b) x=1; else {<ENTER>}

              if (a<b) {
                 x=1;
              } else {<ENTER>}

         */
         restore_pos(p2);
         if (style2) {
            first_non_blank();
            // IF the open brace is the first character in the line
            if (openbrace_col==p_col) {

               begin_stat_col=c_begin_stat_col(false /* No RestorePos */,
                                               true /* skip first begin statement marker */,
                                               true /* return first non-blank */
                                               );
               // IF there is stuff between the previous statement and
               //    this statement, we must be in a class/struct
               //    definition.  IF/While/FOR Etc. cases have been
               //    handled above.
               if (openbrace_col!=p_col || statdelim_linenum!=p_line) {
                  restore_pos(p);
                  return(begin_stat_col+syntax_indent);
               }
               // We could check here for extra stuff after the
               // open brace
               restore_pos(p);
               return(openbrace_col);
            }
            restore_pos(p2);
         }
         begin_stat_col=c_begin_stat_col(false /* No RestorePos */,
                                         true /* skip first begin statement marker */,
                                         true /* return first non-blank */
                                         );
         restore_pos(p);
         return(begin_stat_col+syntax_indent);

      case ';':
         //messageNwait("case ;");
         save_pos(p2);
         statdelim_linenum=p_line;
         begin_stat_col=c_begin_stat_col(false /* RestorePos */,
                                    true /* skip first begin statement marker */,
                                    true /* return first non-blank */
                                    );
         /* IF there is extra stuff before the beginning of this
               statement
            Example
                x=1;y=2;<ENTER>
                       OR
                for (x=1;<ENTER>
            NOTE:  The following code fragrament does not work
                   properly.
                for (i=1;i<j;++i) ++i;<ENTER>
                for (i=1;
                     i<j;<ENTER>
         */
         word=cur_word(junk);
         if (word=='for') {
            // Here we try to indent after open brace for
            // loop unless the cursor is after the close paren.
            get_line(line);line=expand_tabs(line);
            col=pos('(',line);
            if (!col) {
               col=p_col;
               restore_pos(p);
               return(col+syntax_indent);
            }
            p_col=col;
            status=find_matching_paren();
            // IF cursor is after close paren of for loop
            if (!status && (orig_linenum>p_line ||
                            (p_line==orig_linenum && orig_col>p_col)
                           )
               ) {
               // Cursor is after close paren of for loop.
               restore_pos(p);
               return(begin_stat_col);
            }
            // Align cursor after open brace of for loop
            restore_pos(p);
            return(col+1);
         }
         restore_pos(p2);

         // Now check if there are any characters between the
         // beginning of the previous statement and the original
         // cursor position
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }
         restore_pos(p);
         return(begin_stat_col);
      case '}':
         //messageNwait("case }");
         /*
            Don't forget to test

            if (i<j)
               {
               }<ENTER>

            if (i<j)
               {
               }
            else
               {
               }<ENTER>


         */
         statdelim_linenum=p_line;
         save_pos(p2);

         /* Now check if there are any characters between the
            beginning of the previous statement and the original
            cursor position

            Could have
              struct name {
              } name1, <ENTER>

              myproc() {
              }
                 int i,<ENTER>
         */
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }

         /*
             Handle the following cases
             for (;;)
                 {
                 }<ENTER>

                 {
                 }<ENTER>

             MYRECORD array[]={
                {a,b,c}<ENTER>

             MYRECORD array[]={
                {a,b,c}
                ,{a,b,c}<ENTER>

         */
         restore_pos(p2);
         ++p_col;
         col=c_endbrace_col2(be_style,style3_MustBackIndent);
         if (col) {
            if (!style2 || !style3_MustBackIndent) {
               restore_pos(p);
               return(col);
            }
            col-=syntax_indent;
            if (col<1) col=1;
            restore_pos(p);
            return(col);
         }
         restore_pos(p2);
         if (!style2 || !style3_MustBackIndent) {
            col=p_col;
            restore_pos(p);
            return(col);
         }
         col=p_col-syntax_indent;
         if (col<1) col=1;
         restore_pos(p);
         return(col);
      case ':':
         //messageNwait("case :");
         if (p_extension=='e'){
            // Watch out for :==,:!=, :+, :<=, :>=
            ch=get_text(1,(int)point('s')+1)
            if(ch=='=' || ch=='!' || ch=='<' || ch=='>' || ch=='+') {
               status=repeat_search();
               continue;
            }
         }
         if (p_col!=1) {
            left();
            if (get_text()==":") {
               status=repeat_search();
               continue;
            }
            right();
         }



         save_pos(p2);

         /* Now check if there are any characters between the
            beginning of the previous statement and the original
            cursor position

            Could have
             case 'a':
                 int i,<ENTER>
         */
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }



         restore_pos(p2);


         /*

             default:<ENTER>
             case ???:<ENTER>
             (abc)? a: b;<ENTER>
             class1::name<ENTER>
             class name1:public<ENTER>
         */
         begin_stat_col=c_begin_stat_col(false /* RestorePos */,
                                    true /* skip first begin statement marker */,
                                    true /* return first non-blank */,
                                    1
                                    );

         if (p_line==orig_linenum) {
            word=cur_word(junk);
            if (word=='case' || word=='default') {
               first_non_blank();
               // IF the 'case' word is the first non-blank on this line
               if (p_col==begin_stat_col) {
                  col=p_col;
                  restore_pos(p);
                  return(col);
               }
            }
         }
         restore_pos(p);
         return(begin_stat_col+syntax_indent);
      default:
         if (cfg==CFG_KEYWORD) {
            /*
               Cases
                 if ()
                    if () <ENTER>
                 for <ENTER>

            */
            first_non_blank();
            col=p_col+syntax_indent;
            restore_pos(p);
            return(col);
         }
      }

      status=repeat_search();
   }

}
static int c_expand_space(syntax_indent,be_style,indent_fl)
{
   status=0;
   get_line(orig_line);
   line=strip(orig_line,'T');
   orig_word=strip(line);
   if ( p_col!=text_col(line)+1 ) {
      return(1);
   }
   if_special_case=0;
   aliasfilename='';
   java=0;
   if (_modename_eq(p_mode_name,'Java')) {
      java=1;
   } else if (_modename_eq(p_mode_name,'JavaScript')) {
      java=2;
   }
   if (java==2) {
      word=min_abbrev2(orig_word,javascript_space_words,name_info(p_index),aliasfilename)
   } else if (java) {
      word=min_abbrev2(orig_word,java_space_words,name_info(p_index),aliasfilename)
   } else {
      word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename)
   }
   if (aliasfilename!=''&&word!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   if ( word=='') {
      // Check for } else
      parse orig_line with first_word second_word rest
      if (first_word=='}' && second_word!='' && rest=='' && second_word:==substr('els',1,length(second_word))) {
         keyin(substr('else ',length(second_word)+1));
         return(0)
      }
      // Check for else if or } else if
      if (first_word=='else' && orig_word==substr('else if',1,length(orig_word))) {
         word='else if';
         if_special_case=1;
      } else if (second_word=='else' && rest!='' && orig_word==substr('} else if',1,length(orig_word))) {
         word='} else if';
         if_special_case=1;
      } else if (first_word=='}else' && second_word!='' && orig_word==substr('}else if',1,length(orig_word))) {
         word='}else if';
         if_special_case=1;
      } else {
         return(1);
      }
   }
   maybespace=(be_style & NO_SPACE_BEFORE_PAREN)?'':' ';
   line=substr(line,1,length(line)-length(orig_word)):+word;
   width=text_col(line,length(line)-length(word)+1,'i')-1;
   style1=be_style & STYLE1_FLAG;
   style2=be_style & STYLE2_FLAG;
   e1=' {';
   if (! (word=='do' && !style2 && !style1) ) {
      if ( (be_style & (STYLE1_FLAG|STYLE2_FLAG)) ||
         ! (be_style & BRACE_INSERT_FLAG) ) {
         e1='';
      }
   }
   if ( word=='main' ) {
      if (java) {
         save_pos(p);
         col=find_class_col();
         restore_pos(p);
         // If there is no class in this file
         if (!col) {
            replace_line("public class "strip_filename(p_buf_name,"pe")" {");
            width=syntax_indent;
            insert_line(indent_string(width)'public static void main (String args[]) {');
         } else {
            replace_line(indent_string(width)'public static void main (String args[]) {');
         }
         insert_line('');
         insert_line(indent_string(width)'}');
         if (!col) {
            insert_line("}");
            up();
         }
         up;p_col=width+((indent_fl)?syntax_indent:0)+1;
         return(0);
      } else {
         status=c_insert_main()
      }
   } else if ( word=='if' || if_special_case) {
      replace_line line:+maybespace:+'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   } else if ( word=='for' || (word=='with' && java==2)) {
      replace_line line:+maybespace'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   } else if ( word=='while' ) {
      replace_line line:+maybespace'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   } else if ( (word=='public' || word=='private' || word=='protected') && !java) {
      replace_line(line':');_end_line();
      _c_do_colon();
   } else if ( word=='switch' ) {
      replace_line(line:+maybespace'()'e1);
      maybe_insert_braces(syntax_indent,be_style,width,word)
   } else if ( word=='do' ) {
      // Always insert braces for do loop unless braces are on separate
      // line from do and while statements
      replace_line(line:+e1);
      if ( ! style2 ) {
         if (style1 ) {
            insert_line(indent_string(width)'{');
         }
         insert_line(indent_string(width)'} while':+maybespace'(  );');
         up();
      } else if ( style2 ) {
         if (be_style & BRACE_INSERT_FLAG) {
            insert_line(indent_string(width+syntax_indent)'{');
            insert_line(indent_string(width+syntax_indent)'}');
            insert_line(indent_string(width)'while':+maybespace'(  );');
            up(2);
            syntax_indent=0;
         } else {
            insert_line(indent_string(width)'while'maybespace:+'(  );');
            up(1);
            //syntax_indent=0
         }
      }
      nosplit_insert_line();
      p_col=p_col+syntax_indent;
   } else if ( word=='printf' ) {
      replace_line(indent_string(width)'printf("');
      _end_line();
   } else if ( java==2 && (word=='export' || word=='function' || word=='import' || word=='var')) {
      replace_line(indent_string(width)word' ');_end_line();
   } else if ( word=='return' ) {
      if (orig_word=='return') {
         keyin(' ');
      } else {
         replace_line(indent_string(width)'return');
         _end_line();
      }
   } else if ( word=='continue' || word=='break' ) {
      // Java allows labels to follow continue or break
      if (java) {
         if (orig_word==word) {
            replace_line(indent_string(width)word' ');
         } else {
            replace_line(indent_string(width)word);
         }
      } else {
         replace_line(indent_string(width)word';');
      }
      _end_line();
   } else if ( word=='case' ) {
      if ( name_on_key(ENTER):=='nosplit-insert-line' ) {
         replace_line(indent_string(width)word' :');
         _end_line;_c_do_colon();p_col=p_col-1;
         if ( ! _insert_state() ) _insert_toggle();
      } else {
#if 1
         // Code which inserts case
         replace_line(indent_string(width)word' :');
         _end_line();_c_do_colon();_rubout();
#else
         // Code which inserts case and colon and
         // puts user in insert mode.
         replace_line(indent_string(width)word' :');
         _end_line();_c_do_colon();p_col=p_col-1;
         if ( ! _insert_state() ) _insert_toggle();
#endif
      }
   } else if ( word=='default' ) {
      replace_line(indent_string(width)word':');_end_line();
      _c_do_colon();
   } else if ( pos(' 'word' ',EXPAND_WORDS) ) {
      replace_line(indent_string(width)word' ');
      _end_line();
   } else if (java==1 && pos(' 'word' ',JAVA_ONLY_EXPAND_WORDS) ) {
      replace_line(indent_string(width)word' ');
      _end_line();
   } else {
     status=1;
   }
   return(status);
}
static _str xlat_class_name(_str class_name)
{
   if (p_extension=='java') {
      i=lastpos('.',class_name);
      if (i) {
         class_name=substr(class_name,1,i-1):+VS_TAGSEPARATOR_package:+substr(class_name,i+1);
      }
   } else {
      i=lastpos('::',class_name);
      if (i) {
         class_name=substr(class_name,1,i-1):+VS_TAGSEPARATOR_package:+substr(class_name,i+2);
      }
   }
   return(class_name);
}
static _str parse_java_class_name()
{
   class_name="";
   while (gtk==TK_ID || gtk=='.') {
      class_name=class_name:+gtkinfo;
      c_next_sym();
      //save_pos(p4);
   }
   return(xlat_class_name((class_name)));
}
static int parse_class_definition(_str &class_name,_str &implement_list,int &vsImplementFlags,typeless &AfterKeyinPos=null)
{
   if (p_extension=="c") {
      vsImplementFlags=VSIMPLEMENT_ABSTRACT;
   } else {
      vsImplementFlags=0;
   }
   class_name="";
   implement_list="";
   indent_col=0;
   left();
   brace_nrseek=_nrseek();
   if (p_col==1) {
      up();_end_line();
   } else {
      left();
   }
   if (p_extension=='java') {
      if (_clex_skip_blanks('-')) return(0);
      if (get_text()==')') {
         // Here we match round parens. ()
         status=_find_matching_paren(def_pmatch_max_diff);
         if (status) {
            return(0);
         }
         if (p_col==1) {
            up();_end_line();
         } else {
            left();
         }
         c_prev_sym();
         // This could be java new anonymous class
         //if (_clex_skip_blanks('-')) return(0);

         if (gtk==TK_ID && pos(' 'gtkinfo' ',' for if switch while new ')) {
            return(0);
         }
         implement_list="";
         //typeless p4;
         while (gtk==TK_ID || gtk=='.') {
            if (gtkinfo=='new') {
               break;
            }
            implement_list=gtkinfo:+implement_list;
            c_prev_sym();
            //save_pos(p4);
         }
         if (gtkinfo!='new') {
            return(0);
         }
         implement_list=xlat_class_name(implement_list);
         search("new");
         col=p_col;
         first_non_blank();
         if (col!=p_col) {
            if (AfterKeyinPos!=null) {
               save_pos(t1);
               restore_pos(AfterKeyinPos);
               down();
               get_line(line);
               if (line=='}') {
                  first_non_blank();
                  col=p_col+p_SyntaxIndent-1;
                  replace_line(indent_string(col)'}');
               }
               restore_pos(t1);
            }
            p_col+=p_SyntaxIndent;
         }
         indent_col=p_col+p_SyntaxIndent-1;
      }
   }
   if (!indent_col) {
      indent_col=c_begin_stat_col(false,false,false);
      if (!indent_col) {
         return(0);
      }
      indent_col+=p_SyntaxIndent-1;
      // parse words before "class" keyword
      c_next_sym();
      for (;;) {
         if (gtk!=TK_ID) {
            return(0);
         }
         word=gtkinfo;
         if (word=='class') {
            break;
         }
         if (word=='abstract') {
            vsImplementFlags=VSIMPLEMENT_ABSTRACT;
         }
         c_next_sym();
      }
      c_next_sym();
      if (gtk!=TK_ID) {
         return(0);
      }
      class_name=gtkinfo;
      //goto_point(_nrseek()+length(word);
      //if (_clex_skip_blanks()) return(0);
      c_next_sym();
      if (p_extension=='java') {
         if (gtk!=TK_ID) {
            return(0);
         }
         if (gtkinfo=='extends') {
            c_next_sym();
            class_name=parse_java_class_name();
            if (class_name=="") {
               return(0);
            }
            implement_list=class_name;
         }
         if (gtkinfo=='implements') {
            for (;;) {
               c_next_sym();
               if (gtk!=TK_ID) {
                  break;
               }
               class_name=parse_java_class_name();
               if (class_name=="") {
                  return(1);
               }
               if (implement_list=="") {
                  implement_list=class_name;
               } else {
                  implement_list=implement_list';'class_name;
               }
               if (gtk!=',') {
                  break;
               }
            }
         }
      } else {
         if (gtk!=':') {
            return(0);
         }
         for (;;) {
            c_next_sym();
            // skip keywords like public
            while (gtk==TK_ID) {
               left();
               if (_clex_find(0,'g')!=CFG_KEYWORD) {
                  right();
                  break;
               }
               right();
               c_next_sym();
            }
            if (gtk!=TK_ID && gtk!='::') {
               return(0);
            }
            inherit_class_name='';
            while (gtk==TK_ID || gtk=='::') {
               inherit_class_name=inherit_class_name:+gtkinfo;
               c_next_sym();
            }
            inherit_class_name=xlat_class_name(inherit_class_name);
            if (gtk=='<') {
               int nesting=0;
               for (;;) {
                  inherit_class_name=inherit_class_name:+gtkinfo;
                  if (gtk=='<') {
                     ++nesting;
                  } else if (gtk=='>') {
                     --nesting;
                     if (nesting<=0) {
                        c_next_sym();
                        break;
                     }
                  } else if (gtk=='{') {
                     return(0);
                  }
                  c_next_sym();
               }
            }
            if (implement_list=="") {
               implement_list=inherit_class_name;
            } else {
               implement_list=implement_list';'inherit_class_name;
            }
            if (gtk!=',') {
               break;
            }
         }
      }
      if (gtkinfo!='{' || _nrseek()-1!=brace_nrseek) {
         return(0);
      }
   }
   return(indent_col);
}
static int c_expand_begin(expand,syntax_indent,be_style,indent_fl)
{
   brace_indent=0;
   keyin('{');
   get_line(line);
   pcol=text_col(line,p_col,'P');
   last_word='';

   save_pos(AfterKeyinPos);
   old_linenum=p_line;old_col=p_col;
   status=_clex_skip_blanks();
   end_brace_is_last_char=status || p_line>old_linenum;
   restore_pos(AfterKeyinPos);

   if ( line!='{' ) {
      if (!end_brace_is_last_char) {
         return(0);
      }
   } else if ( ! (be_style & STYLE2_FLAG) ) {
      /*
          Now that "class name<ENTER>" usually indents, we need
          the begin brace to be moved correctly to align under the
          "class" keyword.
      */
      save_pos(p);
      left();
      //begin_brace_col=p_col;
      col= find_block_col();
      if (!col) {
         restore_pos(p);left();
         col=c_begin_stat_col(true,true,true);
      } else {
         // Indenting for class/struct/interface/variable initialization
         /*style=(be_style & STYLE2_FLAG);
         if (style!=0) {
            col=begin_brace_col;
         }*/
      }
      restore_pos(p);
      if (col) {
         replace_line(indent_string(col-1)'{');
         _end_line();save_pos(AfterKeyinPos);
      }

   } else if ( (be_style & STYLE2_FLAG) ) {
      /*
         A few customers like the way 1.7 let them type braces
         for functions indented.

         Brief does not do this.

      */
      /*
          Now that "class name<ENTER>" usually indents, we need
          the begin brace to be moved correctly to align under the
          "class" keyword.
      */
      save_pos(p);
      left();
      begin_brace_col=p_col;
      col= find_block_col();
      if (!col) {
         restore_pos(p);left();
         col=c_begin_stat_col(true,true,true);
         if ((be_style & STYLE2_FLAG) && def_style3_indent_all_braces) {
            col+=syntax_indent;
         }
      } else {
         // Indenting for class/struct/interface/variable initialization
         style=(be_style & (STYLE1_FLAG|STYLE2_FLAG));
         if (style!=0) {
            col=begin_brace_col;
         }
      }
      restore_pos(p);
      if (col) {
         replace_line(indent_string(col-1)'{');
         _end_line();save_pos(AfterKeyinPos);
      }

   }
   first_non_blank();
   if ( expand ) {
      col=p_col-1;
      if ( (col && (be_style & STYLE2_FLAG)) || (! (indent_fl+col)) ) {
         syntax_indent=0;
      }
      insert_line(indent_string(col+brace_indent));
      c_endbrace();
      restore_pos(AfterKeyinPos);//_end_line();
      if ((be_style & BRACE_INSERT_LINE_FLAG) ) {
         _end_line();
         c_enter();
      }
#if 0
      if ( be_style & BRACE_INSERT_LINE_FLAG ) {
         insert_line indent_string(col+syntax_indent)
      }
      insert_line indent_string(col+brace_indent)'}'
      up;_end_line
#endif
   }
   save_pos(done_pos);
   if (p_extension=='c' || p_extension=='java') {
      restore_pos(AfterKeyinPos);
      indent_col=parse_class_definition(class_name,implement_list,vsImplementFlags,AfterKeyinPos);
      if (!indent_col) {
         restore_pos(done_pos);
         return(0);
      }
      restore_pos(AfterKeyinPos);
      /*
         For simplicity, remove blank line that was inserted
      */
      if (expand && (be_style & BRACE_INSERT_LINE_FLAG) ) {
         down();
         _delete_line();
         restore_pos(AfterKeyinPos);
      }
      int count;
      //messageNwait('class_name='class_name' implement_list='implement_list);
      count=_do_default_get_implement_list(class_name, implement_list, vsImplementFlags);
      lastext="";
      int index=0;
      boolean CursorDone=false;
      int c_access_flags = VS_TAGFLAG_private;
      for (match_id=1;match_id<=count;++match_id) {
         tag_get_match(match_id,tag_file,tag_name,type_name,file_name,line_no,class_name,
                       tag_flags,signature,return_type);
         // Can't we get source comments?
         _str header_list[];header_list._makeempty();
         _ExtractTagComments(header_list,2000,tag_name,file_name,line_no,
                             type_name, class_name, indent_col);
         // generate the match signature for this function, not a prototype
         int akpos=_c_generate_match_signature(match_id,c_access_flags,header_list,
                                               indent_col,brace_indent,false);
         if (!CursorDone) {
            CursorDone=true;
            AfterKeyinPos = akpos;
         }
      }
      down();
      get_line(cur_line);
      if (p_extension=='c' && cur_line=='}') {
         replace_line(strip(cur_line,'T'):+';');
      }
      restore_pos(AfterKeyinPos);
   }
   return(0)
}
// Returns the necessary cursor position
int _c_generate_match_signature(int match_id, int &c_access_flags,
                                _str (&header_list)[],
                                int indent_col, int begin_col,
                                boolean make_proto=false,
                                boolean in_class_scope=true)
{
   // get the information about this match
   tag_get_match(match_id,tag_file,tag_name,type_name,file_name,
                 line_no,class_name,tag_flags,signature,return_type);

   // generate access specifier keywords
   _str before_return='';
   boolean is_java = false;
   if (p_extension=='java') {
      is_java=true;
      switch (tag_flags & VS_TAGFLAG_access) {
      case VS_TAGFLAG_public:
         strappend(before_return,'public ');
         break;
      case VS_TAGFLAG_package:
         //strappend(before_return,'package ');
         // package is default scope for Java
         break;
      case VS_TAGFLAG_protected:
         strappend(before_return,'protected ');
         break;
      case VS_TAGFLAG_private:
         // yes, this can not happen
         strappend(before_return,'private ');
         break;
      }
   } else if (p_extension=='c' && in_class_scope) {
      if ((tag_flags & VS_TAGFLAG_access) != c_access_flags) {
         c_access_flags = (tag_flags & VS_TAGFLAG_access);
         switch (c_access_flags) {
         case VS_TAGFLAG_public:
         case VS_TAGFLAG_package:
            insert_line(indent_string(begin_col)"public:");
            break;
         case VS_TAGFLAG_protected:
            insert_line(indent_string(begin_col)"protected:");
            break;
         case VS_TAGFLAG_private:
            // yes, this can not happen
            insert_line(indent_string(begin_col)"private:");
            break;
         }
      }
   }

   // generate comment block
   for (i=0;i<header_list._length();++i) {
      insert_line(header_list[i]);
   }

   // other keywords before return type
   if (!in_class_scope && 
       file_eq(file_name,p_buf_name) && 
       pos('h',get_extension(p_buf_name))) {
      strappend(before_return,'inline ');
   }
   if (in_class_scope && (tag_flags & VS_TAGFLAG_static)) {
      strappend(before_return,'static ');
   }
   if (tag_flags & VS_TAGFLAG_native) {
      strappend(before_return,'native ');
   }
   if ((tag_flags & VS_TAGFLAG_virtual) && !is_java && in_class_scope) {
      strappend(before_return,'virtual ');
   }
   if (tag_flags & VS_TAGFLAG_final) {
      strappend(before_return,'final ');
   }
   if (tag_flags & VS_TAGFLAG_synchronized) {
      strappend(before_return,'synchronized ');
   }
   if (tag_flags & VS_TAGFLAG_transient) {
      strappend(before_return,'transient ');
   }

   // prepend qualified class name for C++
   if (tag_flags & VS_TAGFLAG_operator) {
      tag_name = 'operator 'tag_name;
   }
   if (!in_class_scope && class_name!='' && p_extension=='c') {
      class_name = stranslate(class_name,'::',':');
      class_name = stranslate(class_name,'::','/');
      tag_name   = class_name '::' tag_name;
   }

   // compute keywords falling in after the signature
   // (TBD) do something with 'throw'
   _str after_sig='';
   if (tag_flags & VS_TAGFLAG_mutable) {
      strappend(before_return,' mutable');
   }
   if (tag_flags & VS_TAGFLAG_const) {
      strappend(after_sig, ' const');
   }
   if (tag_flags & VS_TAGFLAG_volatile) {
      strappend(after_sig,' volatile');
   }

   // finally, insert the line
   _str punctuation = (make_proto)? ';':' {';
   return_type = (return_type=='')? '':return_type:+' ';
   insert_line(indent_string(indent_col):+before_return:+
               return_type:+tag_name:+'('signature')':+after_sig:+punctuation);
   save_pos(AfterKeyinPos);
   if (!make_proto) {
      insert_line(indent_string(indent_col):+'}');
   }
   return (AfterKeyinPos);
}
int _java_generate_match_signature(int match_id, int &c_access_flags,
                                   _str (&header_list)[],
                                   int indent_col, int begin_col,
                                   boolean make_proto=false)
{
   return _c_generate_match_signature(match_id,c_access_flags,header_list,
                                      indent_col,begin_col,make_proto);
}
int _js_generate_match_signature(int match_id, int &c_access_flags,
                                 _str (&header_list)[],
                                 int indent_col, int begin_col,
                                 boolean make_proto=false)
{
   return _c_generate_match_signature(match_id,c_access_flags,header_list,
                                      indent_col,begin_col,make_proto);
}
int _e_generate_match_signature(int match_id, int &c_access_flags,
                                _str (&header_list)[],
                                int indent_col, int begin_col,
                                boolean make_proto=false)
{
   return _c_generate_match_signature(match_id,c_access_flags,header_list,
                                      indent_col,begin_col,make_proto);
}
#if 0
/*
    Returns 0 if successful.  Set parents_list to "" if
    the current class does not inherit or implement any classes.
    
    VSCODEHELPRC_CURRENT_BLOCK_IS_NOT_CLASS
*/
int _c_get_class_parents(_str &parents_list)
{
   save_pos(p);
   restore_pos(p);
   int nesting=0;
   status=search('[{}]','-@rxcs');
   for (;;) {

   }
   
}
_command void override_method()
{
  
   // Determine current class 
   index=find_index('_'p_extension'_get_class_parents',PROC_TYPE);


}
#endif
static _str prev_stat_has_semi()
{
   status=1
   up;
   if ( ! rc ) {
      col=p_col;_end_line;get_line line
      parse line with line '\#|/\*|//','r'
      /* parse line with line '{' +0 last_word */
      /* parse line with first_word rest */
      /* status=stat_has_semi() or line='}' or line='' or last_word='{' or first_word='case' */
      line=strip(line,'T');
      if (last_char(line)==')') {
         save_pos(p);
         p_col=text_col(line);
         status=_find_matching_paren(def_pmatch_max_diff);
         if (!status) {
            status=search('[~( \t]','@-r');
            if (!status) {
               if (!_clex_find(0,'g')==CFG_KEYWORD) {
                  status=1;
               } else {
                  kwd=cur_word(junk);
                  status=!pos(' 'kwd' ',' if do while switch for ');
               }
            }
         }
         restore_pos(p);
      } else {
         status=last_char(line)!=')' && ! pos('(\}|)else$',line,1,'r')
      }
      down
      p_col=col
   }
   return(status)
}
static _str stat_has_semi()
{
   get_line line
   parse line with line '/*'
   parse line with line '/\*|//','r'
   line=strip(line,'T')
   name=name_on_key(ENTER)
   return((last_char(line):==';' || last_char(line):=='}') &&
            (
               ! (( name=='split-insert-line' ||
                     (name=='maybe-split-insert-line' && _insert_state())
                    ) && (p_col<=text_col(line) && arg(1)=='')
                   )
            )
         )

}
static void maybe_insert_braces(syntax_indent,be_style,width,word)
{
   col=width+length(word)+3
   if (be_style & NO_SPACE_BEFORE_PAREN) --col;
   if ( be_style & STYLE2_FLAG ) {
      width=width+syntax_indent
   }
   if ( be_style & BRACE_INSERT_FLAG ) {
      up_count=1
      if ( be_style & (STYLE1_FLAG|STYLE2_FLAG) ) {
         up_count=up_count+1
         insert_line  indent_string(width)'{'
      }
      if ( be_style & BRACE_INSERT_LINE_FLAG ) {
         up_count=up_count+1
         insert_line indent_string(width+syntax_indent)
      }
      insert_line indent_string(width)'}'
      up up_count;
   }
   p_col=col
   if ( ! _insert_state() ) { _insert_toggle }
}
/*
   It is no longer necessary to modify this function to
   create your own main style.  Just define an extension
   specific alias.  See comment at the top of this file.

   NOTE: This function is not called for java.
*/
static _str c_insert_main()
{
   parse name_info(p_index) with . . . . be_style indent_fl main_style .;
   syntax_indent=p_SyntaxIndent;
   if ( ! indent_fl ) {
      syntax_indent=0
   }
   if ( main_style==2 ) {
      return(1)
   }
   maybespace=(be_style & NO_SPACE_BEFORE_PAREN)?'':' ';
   if ( ! main_style ) {
      replace_line  'main':+maybespace'(argc, argv)'
      insert_line indent_string(syntax_indent):+'int argc;'
      insert_line indent_string(syntax_indent):+'char *argv[];'
   } else {
#if __UNIX__
      // GNU c++ wants int return type
      replace_line  'int main':+maybespace'(int argc, char *argv[])'
#else
      replace_line  'void main':+maybespace'(int argc, char *argv[])'
#endif
   }
   insert_line('{');
   insert_line('');
   insert_line('}');
   up;p_col=syntax_indent+1;
   return(0)
}
#if 0
_str _java_get_heading()
{
   return(_c_get_heading());
}
_str _c_get_heading()
{
   save_pos(p);
   startpos=_nrseek();
   status=search("(","h@");
   for (;;) {
      if (status) break;
      cfg=_clex_find(0,"g");
      if (cfg!=CFG_COMMENT && cfg!=CFG_STRING) {
         break;
      }
      status=repeat_search();
   }
   if (status) {
      restore_pos(p);
      get_line(line);
      return(line);
   }
   status=_find_matching_paren(def_pmatch_max_diff);
   if (status) {
      restore_pos(p);
      get_line(line);
      return(line);
   }
   endpos=_nrseek();
   text=get_text(endpos-startpos+1,startpos);
   restore_pos(p);
   // Strip comments from the text
   result="";
   for (;;) {
      // grab the line
      if (text=="") break;
      parse text with before "[\r\n]#","r" text;
      parse before with before '//|/\*',"r" +0 rest
      first2=substr(rest,1,2);
      if (first2=="/*") {
         // Look for terminating "*/" in remaining text.
         text=rest:+"\n":+text;
         i=pos("*/",text,3);
         if (!i) {
            text="";
         } else {
            text=substr(text,i+2);
         }
      }
      //5:36pm 8/27/1996 Dan added fix for list tags across line boundries
#if 1
      if (result!='') {
         if (pos(':a',last_char(result),1,'r')) {
            result=result' 'strip(before);
         }else{
            result=result:+strip(before);
         }
      }else{
         result=result:+strip(before);
      }
#else
      result=result:+strip(before);
#endif
   }
   return(result);
}
#endif
int _have_auto_codehelp()
{
   ext=p_extension;
   return(find_index('_'ext'_get_idexp',PROC_TYPE));
}
defeventtab c_keys
def '('=auto_functionhelp_key
def '<'=auto_functionhelp_key
def '.'=auto_codehelp_key
def '>'=auto_codehelp_key
def 'C- '=codehelp_complete
int _e_get_idexp(_str (&errorArgs)[],
                 boolean PossibleOperator,
                 _str &prefixexp,
                 _str &lastid,int &lastidstart_col,
                 int &lastidstart_offset,
                 int &info_flags,
                 typeless &otherinfo
                )
{
   return(_c_get_idexp(errorArgs,PossibleOperator,prefixexp,lastid,lastidstart_col,lastidstart_offset,info_flags,otherinfo));
}
int _java_get_idexp(_str (&errorArgs)[],
                    boolean PossibleOperator,
                    _str &prefixexp,
                    _str &lastid,int &lastidstart_col,
                    int &lastidstart_offset,
                    int &info_flags,
                    typeless &otherinfo
                    )
{
   return(_c_get_idexp(errorArgs,
                       PossibleOperator,
                       prefixexp,
                       lastid,
                       lastidstart_col,
                       lastidstart_offset,
                       info_flags,
                       otherinfo));
}
int _js_get_idexp(_str (&errorArgs)[],
                  boolean PossibleOperator,
                  _str &prefixexp,
                  _str &lastid,int &lastidstart_col,
                  int &lastidstart_offset,
                  int &info_flags,
                  typeless &otherinfo
                  )
{
   return(_c_get_idexp(errorArgs,PossibleOperator,prefixexp,lastid,lastidstart_col,lastidstart_offset,info_flags,otherinfo));
}
/*
   REMARKS:
      caller must check whether text is in a comment
      or string.
      for now, set info_flags to 0.  In the future we could
      have a LASTID_FOLLOWED_BY_PAREN flag and optionally do an
      exact match instead of a prefix match.

   POSSIBLE FUTURE ENHANCEMENTS
      Smart assignments where we check required result type
      Smart function argument where we check required result type
      Smart java throws where we know we need something that derives from exception.

   This function is called when:

     possibly operator typed like -> or ( or .
        return 1 if not valid operator
        return 1 if expression too complex or invalid context

     Identifier just typed (curr char not id) or on identifier

   Example
     PossibleOperator==true
        a[1].b.c.<Here>

           prefixexp="a[].b.c."
           lastid=""
           lastidstart_col=column after last dot
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

        x=A::B::MYCLASS(Noflines);   // C++ ambiguity only. Most common case
           prefixexp="A::B::"
           lastid="MYCLASS"
           lastidstart_col=column is M of MYCLASS
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN

           This could be a function or a converter

        x=A::B::
           prefixexp="A::B::"
           lastid=""
           lastidstart_col=column after last :
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

           This could be a function or a converter

        f(x,y).a[1].b.c.method(<Here>
           return 1 --> expression too complex

           prefixexp="f(x,y).a[1].b.c."
           lastid="method"
           lastidstart_col=column after last dot
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN


        MYCLASS *p=new MYCLASS(<Here>
           prefixexp="new"
           lastid="MYCLASS"
           lastidstart_col=column is M of MYCLASS
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN

(java)   innerclass ic=j.new innerclass().<Here>
           prefixexp="j.new innerclass()."
           lastid=""
           lastidstart_col=column after last dot
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

(java)   innerclass ic=j.new innerclass(<Here>
           prefixexp="j.new"
           lastid="innerclass"
           lastidstart_col=column is 'i' of innerclass
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN

        MYCLASS::MYCLASS(int x,int y):a(x),b(<Here>
           prefixexp=""
           lastid="b"
           lastidstart_col=column is at b
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_IN_INITIALIZER_LIST|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN
           otherinfo="MYCLASS"

           Only list members of MYCLASS and base classes

        MYCLASS():a(<Here>
           prefixexp=""
           lastid="a"
           lastidstart_col=column is at a
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_MAYBE_IN_INITIALIZER_LIST|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN
           otherinfo="MYCLASS"

           We are in an initializer list only if the class
           name in otherinfo matches the context class.

           Only list members of MYCLASS and base classes if
           we are in an initializer list, otherwise treat
           this case like the typical VSAUTOCODEINFO_DO_FUNCTION_HELP
           case.

        MYCLASS method(<Here>

           prefixexp=""
           lastid="method"
           lastidstart_col=column of 'm' character of method
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_VAR_OR_PROTOTYPE_DECL|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN
           otherinfo="MYCLASS"

           This is either a variable definition or a prototype

           Hopefully, it is sufficient to display function help
           for the MYCLASS constructors. It not, the caller could do
           nothing unless  we are in the context of function code.


     PossibleOperator==false

        a[1].b.c.id<Here>

           prefixexp="a[].b.c."
           lastid="id"
           lastidstart_col=column after last dot
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

        a[1].b.c.<here>id

           prefixexp="a[].b.c."
           lastid="id"
           lastidstart_col=column after last dot
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

        <here>

           prefixexp=""
           lastid=""
           lastidstart_col=column same as cursor
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

        a[1].b.c<here>.id

           prefixexp="a[].b."
           lastid="c"
           lastidstart_col=column at c
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

        f(<here>+id

           prefixexp=""
           lastid=""
           lastidstart_col=column after (
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS


   RETURN
     return 0 if successful
     return 1 if expression too complex
     return 2 if not valid operator


*/
int _c_get_idexp(_str (&errorArgs)[],
                 boolean PossibleOperator,
                 _str &prefixexp,
                 _str &lastid,int &lastidstart_col,
                 int &lastidstart_offset,
                 int &info_flags,
                 typeless &otherinfo
                )
{
   //say("_c_get_idexp: ");
   errorArgs._makeempty();
   _str not_function_words=C_NOT_FUNCTION_WORDS;
   boolean isjava=false;
   boolean slickc=false;
   boolean iscpp=false;
   boolean javascript=false;
   boolean isperl=false;
   boolean isrul=false;
   switch (lowcase(p_mode_name)) {
   case 'java':
      isjava=true;
      not_function_words=JAVA_NOT_FUNCTION_WORDS;
      break;
   case 'slick-c':
      slickc=true;
      break;
   case 'c':
      iscpp=true;
      break;
   case 'javascript':
      javascript=true;
      not_function_words=JAVA_NOT_FUNCTION_WORDS;
      break;
   case 'perl':
      isperl=true;
      break;
   case 'InstallScript':
      isrul=true;
      not_function_words=RUL_NOT_FUNCTION_WORDS;
      break;
   }
   otherinfo="";
   info_flags=VSAUTOCODEINFO_DO_LIST_MEMBERS;
   save_pos(orig_pos);
   // Only want auto-list members on _ for Slick-C when type
   // property "p_"
   if ( PossibleOperator &&  slickc &&
        get_text(1,(int)point('s')-1)=='_' &&
        (
           get_text(1,(int)point('s')-2)!='p' || 
            pos('['p_word_chars']',get_text(1,(int)point('s')-3),1,'r')
        )
      ) {
      restore_pos(orig_pos);
      return(1);
   }
   if (PossibleOperator && !(slickc && get_text(1,(int)point('s')-1)=='_')) {
      left();
      ch=get_text();
      switch (ch) {
      case ':':
         if (!(iscpp || isperl)|| get_text(1,(int)point('s')-1)!=':') {
            restore_pos(orig_pos);
            return(1);
         }
      case '>':
      case '.':
         orig_col=p_col;
         if (ch=='.') {
            // Watch out for parse <exp> with a . b .
            if (slickc && get_text(1,(int)point('s')-1)=='') {
               restore_pos(orig_pos);
               return(1);
            }
            // Screen out floating point.  1.0 
            if (isdigit(get_text(1,(int)point('s')-1))) {
               // Check if identifier before . is a number
               typeless p2;
               save_pos(p2);
               left();
               search('[~'p_word_chars']\c|^\c','-r@');
               if (isdigit(get_text())) {
                  restore_pos(orig_pos);
                  return(1);
               }
               restore_pos(p2);

            }
            get_line(line);
            if (pos('^[ \t]*\#include',line,1,'r')) {
               // Screen out -->  #include <iostream.h>
               restore_pos(orig_pos);
               return(1);
            }
            right();
         } else if (ch==':') {
            right();
         } else {
            if (isjava || javascript) {
               restore_pos(orig_pos);
               return(1);
            }
            if (get_text(1,(int)point('s')-1)!='-') {
               restore_pos(orig_pos);
               return(1);
            }
            right();
         }
         // get the id after the dot
         // IF we are on a id character
         if (pos('['p_word_chars']',get_text(),1,'r')) {
            start_col=p_col;start_offset=point('s');
            search('[~'p_word_chars']|$','r@');
            lastid=_expand_tabsc(start_col,p_col-start_col);
            lastidstart_col=start_col;
            lastidstart_offset=start_offset;
         } else {
            lastid="";
            lastidstart_col=p_col;
            lastidstart_offset=(int)point('s');
         }
         p_col=orig_col;
         break;
      case '<':
      case '(':
         if (ch=='(') {
            info_flags=VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN|VSAUTOCODEINFO_DO_FUNCTION_HELP;
            lastidstart_col=p_col;  // need this for function pointer case
         } else {
            if (javascript || isjava || slickc || isrul || get_text(1,(int)point('s')-1)=='<') {
               restore_pos(orig_pos);
               return(1);
            }
            info_flags=VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST|VSAUTOCODEINFO_DO_FUNCTION_HELP;
         }
         left();
         // IF languages has preprocessing
         if (iscpp || slickc || isrul || isjava) {
            search('[~ \t]|^','-r@');
         } else {
            _clex_skip_blanks('-');
         }
         // maybe there was a function pointer expression
         if (ch=='(' && (get_text()==')' || get_text()==']') && !isjava && !javascript) {
            // If we really have a cast like (char *)(p+1) don't worry about it
            //typeless p2;
            //save_pos(p2);
            end_offset=point('s');
            for (;;) {
               if (find_matching_paren()) {
                  restore_pos(orig_pos);
                  return(1);
               }
               start_offset=point('s');
               // IF languages has preprocessing
               if (iscpp || slickc || isrul || isjava) {
                  // required ]( or )( to be on same line
                  left();
                  search('[~ \t]|^','-r@');
               } else {
                  if (p_col==1) {
                     up();_end_line();
                  } else {
                     left();
                  }
                  _clex_skip_blanks('-');
               }
               ch=get_text();
               if (ch!=')' && ch!=']') {
                  if (pos('[~'p_word_chars']',get_text(),1,'r')) {
                     info_flags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_IN_FUNCTION_POINTER_ARGLIST;
                     prefixexp=get_text(end_offset-start_offset+1,start_offset);
                     //say('prefixexp='prefixexp);
                     lastid="";

                     restore_pos(orig_pos);
                     return(0);
                  }
                  status=_c_get_idexp(errorArgs,false,prefixexp,lastid,junklastidstart_col,lastidstart_offset,info_flags,otherinfo);
                  //say('status='status' p='point('s'));
                  if (status) {
                     restore_pos(orig_pos);
                     return(1);
                  }
                  info_flags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_IN_FUNCTION_POINTER_ARGLIST;
                  prefixexp=prefixexp:+lastid:+get_text(end_offset-start_offset+1,start_offset);
                  //say('prefixexp='prefixexp);
                  lastid="";

                  restore_pos(orig_pos);
                  return(0);
               }
            }
         }
         if (pos('[~'p_word_chars']',get_text(),1,'r')) {
            restore_pos(orig_pos);
            //say("ID returns 5");
            return(1);
         }
         end_col=p_col+1;
         search('[~'p_word_chars']\c|^\c','-r@');
         lastid=_expand_tabsc(p_col,end_col-p_col);
         lastidstart_col=p_col;
         lastidstart_offset=(int)point('s');
         if (pos(' 'lastid' ',not_function_words)) {
            restore_pos(orig_pos);
            return(1);
         }
         if(p_col==1) {
            up();_end_line();
         } else {
            left();
         }
         break;
      default:
         restore_pos(orig_pos);
         return(1);
      }
   } else {
      // IF we are not on an id character.
      ch=get_text();
#if 0
      if (ch=='.' || (!isjava && !javascript && ch=='>' && get_text(1,(int)point('s')-1)=='-' ) ) {
         right();
         ch=get_text();
         //lastid='';
         //lastidstart_col=p_col+1;
      } else if (!isjava && !javascript && ch=='-' && get_text(1,(int)point('s')+1)=='>') {
         right();right();
         ch=get_text();
      }
#endif
      done=0;
      if (pos('[~'p_word_chars']',ch,1,'r')) {
         left();
         ch=get_text();
         if (ch=='.' || 
             (!isjava && !javascript && ch=='>' && get_text(1,(int)point('s')-1)=='-' ) ||
             ((iscpp || isperl) && ch==':' && get_text(1,(int)point('s')-1)==':') ||
             (isperl && ch=="'")
            ) {
            lastid='';
            lastidstart_col=p_col+1;
            lastidstart_offset=(int)point('s')+1;
            done=1;
         }
      }
      if (!done) {
         // IF we are not on an id character.
         if (pos('[~'p_word_chars']',get_text(),1,'r')) {
            restore_pos(orig_pos);
            prefixexp='';
            lastid="";
            lastidstart_col=p_col;
            lastidstart_offset=(int)point('s');

            gtk=c_prev_sym();
            if (gtk==TK_ID && !slickc && !isperl && !javascript) {
               prefixexp=lowcase(gtkinfo)' ';
               switch (lowcase(gtkinfo)) {
               case 'goto':
                  info_flags|=VSAUTOCODEINFO_IN_GOTO_STATEMENT;
                  break;
               case 'throw':
                  info_flags|=VSAUTOCODEINFO_IN_THROW_STATEMENT;
                  break;
               default:
                  prefixexp='';
                  break;
               }
            }
            restore_pos(orig_pos);
            return(0);
         }
         search('[~'p_word_chars']|$','r@');
         end_col=p_col;
         // Check if this is a function call
         search('[~ \t]|$','r@');
         if (get_text()=='(') {
            info_flags|=VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN;
         }
         p_col=end_col;

         left();
         search('[~'p_word_chars']\c|^\c','-r@');
         lastid=_expand_tabsc(p_col,end_col-p_col);
         lastidstart_col=p_col;
         lastidstart_offset=(int)point('s');
         if(p_col==1) {
            up();_end_line();
         } else {
            left();
         }
      }
      //if (slickc && (PossibleOperator && lastid!='p_')
      if (slickc && (PossibleOperator && last_char(lastid)!='_')
          /*||substr(lastid,1,2)!='p_' */
          ) {
         restore_pos(orig_pos);
         return(1);
      }
   }
   prefixexp='';
   gtk=c_prev_sym();
   hit_colon_colon=0;
   if (gtk=='::' && iscpp) {
      for (;;) {
         hit_colon_colon=1;
         prefixexp=gtkinfo:+prefixexp;
         gtk=c_prev_sym_same_line();
         if (gtk!=TK_ID) {
            if (gtk=='>') {
               add_template_args(prefixexp);
               if (gtk!=TK_ID) {
                  // have     NO-ID-HERE <a,b,c>::
                  restore_pos(orig_pos);
                  return(1);
               }
            } else {
               break;
            }
         }
         prefixexp=gtkinfo:+prefixexp;
         gtk=c_prev_sym_same_line();
         if (gtk!='::') {
            break;
         }
      }
   }
   if (info_flags& VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST) {
      if (gtk==',' || gtk=='{' || gtk==';' || gtk=='' || gtk=='}' ||
          _skip_template_prefix_word()) {
         restore_pos(orig_pos);
         return(0);
      }
      restore_pos(orig_pos);
      return(1);
   }
   // IF we could be in a declaration list
   if (iscpp && (gtk==',' || (gtk==TK_ID && gtkinfo!='new' && gtkinfo!='goto' && gtkinfo!='throw') || gtk==':' || gtk=='>')) {
      /*
         Check for the following cases:
            int a,b,c(<Here>
            [myclass::]myclass(...): a(1),b(1),c(<Here>
            TEMPLATECLASS<...>  a,b,c(<Here>
            MYTYPE id<Here>
      */
      status=parse_constructor_or_initializer(prefixexp,lastid,lastidstart_offset,info_flags,otherinfo);
      //messageNwait('p_buf_name='p_buf_name);
      restore_pos(orig_pos);
      return(status);
   }
   status=c_before_id(isjava||javascript,prefixexp,lastid,info_flags);
   restore_pos(orig_pos);
   return(status);
}

/*
  Current token must be >
*/
static void add_template_args(_str &prefixexp)
{
   nesting=0;
   for (;;) {
      prefixexp=gtkinfo:+prefixexp;
      if (gtk=='>') {
         ++nesting;
      } else if (gtk=='<') {
         --nesting;
         if (nesting<=0) {
            c_prev_sym();
            return;
         }
      }
      c_prev_sym();
   }
}
/*
   Check for the following cases:
      int a,b,c(<Here>
      [myclass::]myclass(...): a(1),b(1),c(<Here>
*/
static int parse_constructor_or_initializer(_str prefixexp,
                                            _str lastid,
                                            int lastidstart_offset,
                                            int &info_flags,
                                            typeless &otherinfo
                                            )
{
   check_for_var_decl_or_colon=0;
outer_loop:
   for (;;) {
      if (gtk=='>') {
         if (!_probablyTemplateArgList(FunctionNameStartOffset)) {
            return(0);
            //return(1);
         }
         status=_c_fcthelp_get(errorArgs,
                               FunctionHelp_list,
                    FunctionHelp_list_changed,
                    FunctionHelp_cursor_x,
                    FunctionHelp_HelpWord,
                    FunctionNameStartOffset,
                    VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST_TEST
                   )
         if (status) {
            return(1);
         }
         goto_point(FunctionNameStartOffset);
         gtk='>';
         break;
      }
      // IF maybe inializer list case
      if (gtk==':') {
         save_pos(colon_paren_pos);
         c_prev_sym();
         if (gtk!=')') {
            // We are not in an initializer list
            if (check_for_var_decl_or_colon) {
               restore_pos(colon_paren_pos);gtk=':';
               break outer_loop;
            }
            return(0);
         }
         goto_point((int)point('s')+1);
         status=find_matching_paren();
         if (status) {
            // We are not in an initializer list
            if (check_for_var_decl_or_colon) {
               restore_pos(colon_paren_pos);gtk=':';
               break outer_loop;
            }
            return(0);
         }
         if (p_col==1) {
            up();_end_line();
         } else {
            left();
         }
         c_prev_sym();
         if (gtk!=TK_ID) {
            // We are not in an initializer list
            if (check_for_var_decl_or_colon) {
               restore_pos(colon_paren_pos);gtk=':';
               break outer_loop;
            }
            return(0);
         }
         otherinfo=gtkinfo;
         c_prev_sym();
         if (gtk=='::') {
            // We are definitely in an initializer list
            for (;;) {
               otherinfo=gtkinfo:+otherinfo;
               gtk=c_prev_sym_same_line();
               if (gtk!=TK_ID) {
                  // This should not happen.
                  break;
               }
               otherinfo=gtkinfo:+otherinfo;
               gtk=c_prev_sym_same_line();
               if (gtk!='::') {
                  break;
               }
            }
            info_flags|=VSAUTOCODEINFO_IN_INITIALIZER_LIST;
            return(0);
         }
         info_flags|=VSAUTOCODEINFO_MAYBE_IN_INITIALIZER_LIST;
         return(0);
      }
      for (;;) {
         if (gtk==')') {
            save_pos(close_paren_pos);
            goto_point((int)point('s')+1);
            status=find_matching_paren();
            if (status) {
               // We are lost
               return(0);
            }
            if (p_col==1) {
               up();_end_line();
            } else {
               left();
            }
            c_prev_sym();
            if (gtk==TK_ID) {
               if (pos(' 'gtkinfo' ',' catch for if switch throw while ')) {
                  //End of statement
                  restore_pos(close_paren_pos);gtk=')';
                  //refresh();_message_box('c');
                  break outer_loop;
               }
               c_prev_sym();
            }
         }
         // for (MYCLASS x;...)  OR we are not in a variable declaration.
         if (gtk=='(') {
            save_pos(open_paren_pos);
            c_prev_sym_same_line();
            if (gtk!=TK_ID || gtkinfo!='for') {
               //restore_pos(open_paren_pos);gtk='(';
               //break outer_loop;
               // This is not a variable declaration.
               return(0);
            }
            restore_pos(open_paren_pos);gtk='(';
            break outer_loop;
         }
         // case ...:  OR default:  OR (exp)? ...: OR    class a:
         if (gtk==':') {
            check_for_var_decl_or_colon=1;
            break;
         }
         // IF we definitely hit end of statement
         if (gtk==';' || gtk=='{' || gtk=='}' || gtk=='') {
            break outer_loop;
         }
         // IF we are in a #define
         if (_in_c_preprocessing()) {
            c_next_sym();
            break outer_loop;
         }
         //if (gtk=='#') {
         //   // We are lost
         //   return(0);
         //}
         c_prev_sym();
      }
   }
   if (gtk!='>') {
      if (gtk!='') {
         if (p_col>_text_colc()) {
            down();_begin_line();
            ++p_col;
         } else {
            goto_point((int)point('s')+2);
         }
      }
   }
   count=lastidstart_offset-(int)point('s');
   text=get_text(count):+lastid'(1);';
   classlist=stranslate(strip(prefixexp,'T',':'),':','::');
   if (classlist=='') {
      varname=lastid'(gvar)';
   } else {
      varname=lastid'('classlist':gvar)';
   }
   orig_view_id=_create_temp_view(temp_view_id);
   //xx::yy::y
   //varname=id'('
   _insert_text(text);
   top();
   //_message_box(varname' text='text);
   int index = find_index('c_proc_search',PROC_TYPE);
   if (index_callable(index)) {
      status=c_proc_search(varname,1,'c');
   } else {
      status=1;
   }
   coloncolon='';
   if (!status) {
      if (get_text(1,(int)point('s')-1)==':' &&
          get_text(1,(int)point('s')-2)==':'
          ) {
         coloncolon='::';
      }
   }
   _delete_temp_view(temp_view_id);
   if (!status) {
      /*
         A  B(
      */
      //_message_box('Need new tag_decompose_tag code to get return type into otherinfo');
      _str signature='',return_type='';

      tag_tree_decompose_tag(varname, proc_name, class_name, type_name, tag_flags, signature, return_type);
      info_flags|=VSAUTOCODEINFO_VAR_OR_PROTOTYPE_DECL;
      otherinfo=coloncolon:+return_type;
   }
   activate_view(orig_view_id);
   return(0);
}
static _str c_next_sym()
{
   if (p_col>_text_colc()) {
      if(down()) return('');
      _begin_line();
   }
   ch=get_text();
   if (ch=='' || (ch=='/' && _clex_find(0,'g')==CFG_COMMENT)) {
      status=_clex_skip_blanks();
      if (status) {
         gtk=gtkinfo='';
         return(gtk);
      }
      return(c_next_sym());
   }
   if ((ch=='"' || ch=="'" ) && _clex_find(0,'g')==CFG_STRING) {
      start_col=p_col;
      start_line=p_line;
      status=_clex_find(STRING_CLEXFLAG,'n');
      if (status) {
         _end_line();
      } else if (p_col==1) {
         up();_end_line();
      }
      gtk=TK_STRING;
      gtkinfo=_expand_tabsc(start_col,p_col-start_col+1);
      return(gtk);
   }
   if (pos('['p_word_chars']',ch,1,'r')) {
      start_col=p_col;
      if(_clex_find(0,'g')==CFG_NUMBER) {
         for (;;) {
            if (p_col>_text_colc()) break;
            right();
            if(_clex_find(0,'g')!=CFG_NUMBER) {
               break;
            }
         }
         gtk=TK_NUMBER;
         gtkinfo=_expand_tabsc(start_col,p_col-start_col+1);
         return(gtk);
      }
      search('[~'p_word_chars']|$','@r');
      gtk=TK_ID;
      gtkinfo=_expand_tabsc(start_col,p_col-start_col);
      return(gtk);
   }
   right();
   if (ch=='-' && get_text()=='>') {
      right();
      gtk=gtkinfo='->';
      return(gtk);

   }
   if (ch==':' && get_text()==':') {
      right();
      gtk=gtkinfo='::';
      return(gtk);
   }
   gtk=gtkinfo=ch;
   return(gtk);

}
static _str c_prev_sym_same_line()
{
   //messageNwait('h0 gtk='gtk);
   if (gtk!='(' && gtk!='::') {
      return(c_prev_sym());
   }
   // Only force same line for Slick-C and C++ and InstallScript
   if (p_extension!="c" && p_extension!='e' && p_extension !='rul') {
      return(c_prev_sym());
   }
   orig_linenum=p_line;
   result=c_prev_sym();
   //messageNwait('h1 gtkinfo='gtkinfo);
   if (p_line!=orig_linenum && (p_col<=_text_colc() || p_line!=orig_linenum-1) ) {
      //messageNwait('h2');
      gtk=gtkinfo="";
      return(gtk);
   }
   return(result);
}
static _str c_prev_sym()
{
   ch=get_text();
   if (ch=="\n" || ch=="\r" || ch=='' || (ch=='/' && _clex_find(0,'g')==CFG_COMMENT)) {
      status=_clex_skip_blanks('-');
      if (status) {
         gtk=gtkinfo='';
         return(gtk);
      }
      return(c_prev_sym());
   }
   if (pos('['p_word_chars']',ch,1,'r')) {
      end_col=p_col+1;
      if(_clex_find(0,'g')==CFG_NUMBER) {
         for (;;) {
            if (p_col==1) break;
            left();
            if(_clex_find(0,'g')!=CFG_NUMBER) {
               right();
               break;
            }
         }
         gtk=TK_NUMBER;
         gtkinfo=_expand_tabsc(p_col,end_col-p_col);
      } else {
         search('[~'p_word_chars']\c|^\c','@r-');
         gtk=TK_ID;
         gtkinfo=_expand_tabsc(p_col,end_col-p_col);
      }
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      return(gtk);
   }
   if (p_col==1) {
      up();_end_line();
      if (_on_line0()) {
         gtk=gtkinfo="";
         return(gtk);
      }
      gtk=gtkinfo=ch;
      if (p_extension=="pl" && ch=="'") {
         gtk=gtkinfo='::';
      }
      return(gtk);
   }
   left();
   if (ch=='>' && get_text()=='-') {
      left();
      gtk=gtkinfo='->';
      return(gtk);

   }
   if (p_extension=="pl" && ch=="'") {
      gtk=gtkinfo='::';
      return(gtk);
   }
   if (ch==':' && get_text()==':') {
      left();
      gtk=gtkinfo='::';
      return(gtk);
   }
   gtk=gtkinfo=ch;
   return(gtk);

}
static int c_before_dot(int isjava,_str &prefixexp,_str &lastid)
{
outer_loop:
   for (;;) {
      switch (gtk) {
      case ']':
         prefixexp='[]':+prefixexp;
         right();
         status=find_matching_paren();
         if (status) {
            return(1);
         }
         left();
         gtk=c_prev_sym();
         if (gtk!=']') {
            if (gtk!=TK_ID) {
               if (gtk==')') {
                  continue;
               }
               return(1);
            }
            prefixexp=gtkinfo:+prefixexp;
            gtk=c_prev_sym();
            if (isjava && gtkinfo=='new') {
               prefixexp='new ':+prefixexp;
               gtk=c_prev_sym();
            }
            return(2);  // continue
         }
         break;
      case ')':
         nest_level=0;
         for (count=0;;++count) {
            if (count>200) {
               return(1);
            }
            if (gtk:=='') {
               return(1);
            }
            if (gtk==']') {
               prefixexp='[]':+prefixexp;
               right();
               status=find_matching_paren();
               if (status) {
                  return(1);
               }
               left();
            } else {
               if (gtk==TK_ID) {
                  prefixexp=gtkinfo' ':+prefixexp;
               } else {
                  prefixexp=gtkinfo:+prefixexp;
               }
            }
            if (gtk=='(') {
               --nest_level;
               if (nest_level<=0) {
                  gtk=c_prev_sym_same_line();
                  if (gtk!=TK_ID) {

                     if (gtk==']') {
                        continue outer_loop;
                     }
                     if (gtk==')') {
                        continue;
                     }
                     if (gtk=='') {
                        return(0);
                     }
                     return(0);
#if 0
                     // IF Not function pointer? (*pfn)()->a
                     if (gtk!=')') {
                        return(0);
                     }

                     for (;;) {
                        if (gtk:=='') {
                           return(1);
                        }
                        if (gtk==']') {
                           prefixexp='[]':+prefixexp;
                           right();
                           status=find_matching_paren();
                           if (status) {
                              return(1);
                           }
                           left();
                        } else {
                           prefixexp=gtkinfo:+prefixexp;
                        }
                        if (gtk=='(') {
                           --nest_level;
                           if (nest_level<=0) {
                              return(0);
                           }
                        }
                        gtk=c_prev_sym_same_line();
                     }
#endif
                  }
                  prefixexp=gtkinfo:+prefixexp;
                  gtk=c_prev_sym_same_line();
                  if (isjava && gtkinfo=='new') {
                     prefixexp='new ':+prefixexp;
                     gtk=c_prev_sym();
                  }
                  return(2);// Tell call to continue processing
               }
            } else if (gtk==')') {
               ++nest_level;
            }
            gtk=c_prev_sym();
         }
         break;
      default:
         return(1);
      }
   }
   return(1);
}
static int c_before_id(int isjava,_str &prefixexp,_str &lastid,int &info_flags)
{
   for (;;) {
      switch (gtk) {
      case '->':
         if (isjava) {
            return(0);
         }
      case '.':
         prefixexp=gtkinfo:+prefixexp;
         gtk=c_prev_sym();
         if (gtk!=TK_ID) {
            status=c_before_dot(isjava,prefixexp,lastid);
            if (status!=2) {
               return(status);
            }
         } else {
            prefixexp=gtkinfo:+prefixexp;
            gtk=c_prev_sym();
         }
         break;
      case '::':
         if (!isjava) {
            for (;;) {
               prefixexp=gtkinfo:+prefixexp;
               gtk=c_prev_sym_same_line();
               if (gtk!=TK_ID) {
                  if (gtk=='<') {
                     add_template_args(prefixexp);
                     if (gtk!=TK_ID) {
                        return(1);
                     }
                  } else {
                     return(0);
                  }
               }
               prefixexp=gtkinfo:+prefixexp;
               gtk=c_prev_sym_same_line();
               if (gtk!='::') {
                  return(0);
               }
            }
            return(0);
         }
      case TK_ID:
         if (gtkinfo=='new') {
            gtk=c_prev_sym();
            prefixexp='new ':+prefixexp;
            if (!isjava || gtk!='.') {
               return(0);
            }
            continue;
         } else if (gtkinfo=='goto') {
            info_flags |= VSAUTOCODEINFO_IN_GOTO_STATEMENT;
         } else if (gtkinfo=='throw') {
            info_flags |= VSAUTOCODEINFO_IN_THROW_STATEMENT;
         }
         return(0);

      default:
         return(0);

      }
   }
}
static int _c_parse_return_type(_str (&errorArgs)[], typeless tag_files,
                                _str symbol, _str search_class_name,
                                _str file_name, _str return_type, boolean isjava,
                                _str &match_type, int &pointer_count,
                                _str (&template_args):[], boolean &istemplate,
                                int &c_return_flags, _str &match_tag, int depth=0)
{
   //say("_c_parse_return_type("symbol","search_class_name","return_type","file_name","depth")");
   boolean found_seperator = false;
   boolean allow_local_class= true;
   _str orig_return_type = return_type;
   _str found_type = '';
   match_type = '';

   // if this is not a template, make sure template args are wiped out
   _str package_name = '';
   if (!istemplate) {
      template_args._makeempty();
   }
   //istemplate=false;

   while (return_type != '') {
      p = pos('^ @{\:\:|\:\[|\[|\]|[.<>*&()]|:v|\@:i:v|\@:i}', return_type, 1, 'r');
      if (p <= 0) {
         break;
      }
      p = pos('S0');
      n = pos('0');
      ch = substr(return_type, p, n);
      return_type = substr(return_type, p+n);
      //say("return ch="ch" return_type="return_type);
      //say("package_name="package_name" ch="ch);
      switch (ch) {
      case '::':
         found_seperator = true;
         if (found_type == '') {
            c_return_flags |= VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
            allow_local_class=false;
         } else {
            allow_local_class=true;
         }
         break;
      case '.':
         if (isjava) {
            if (pos('/',package_name)) {
               new_package_name = stranslate(package_name,'.','/');
               if (tag_check_for_package(new_package_name, tag_files, true, true)) {
                  package_name = new_package_name :+ '/';
               }
            } else if (package_name != '' && tag_check_for_package(package_name, tag_files, true, true)) {
               package_name = package_name :+ '/';
            } else {
               package_name = package_name :+ '.';
            }
         }
         break;
      case '*':
         if (found_type != '') {
            pointer_count++;
         }
         //say("PARSE *, pointer_count="pointer_count);
         break;
      case '&':
         break;
      case ':[':
         if (!match_brackets(return_type, num_args)) {
            errorArgs[1] = orig_return_type;
            return VSCODEHELPRC_BRACKETS_MISMATCH;
         }
         c_return_flags |= VSCODEHELP_RETURN_TYPE_HASHTABLE;
         pointer_count++;
         //say("PARSE:[], pointer_count="pointer_count);
         break;
      case '[':
         if (!match_brackets(return_type, num_args)) {
            errorArgs[1] = orig_return_type;
            return VSCODEHELPRC_BRACKETS_MISMATCH;
         }
         c_return_flags |= VSCODEHELP_RETURN_TYPE_ARRAY;
         pointer_count++;
         //say("PARSE[], pointer_count="pointer_count);
         break;
      case ']':
         break;
      case '(':
         if (!match_parens(return_type, parenexp, num_args)) {
            // this is not good
            errorArgs[1] = orig_return_type;
            return VSCODEHELPRC_PARENTHESIS_MISMATCH;
         }
         while (pos('[', parenexp)) {
            parenexp = substr(parenexp, pos('S')+1);
            if (!match_brackets(parenexp, num_args)) {
               errorArgs[1] = orig_return_type;
               return VSCODEHELPRC_BRACKETS_MISMATCH;
            }
            pointer_count++;
         }
         break;
      case ')':
         break;
      case '<':
         // first try to match leading < with > for template arguments
         _str template_parms[];
         template_parms._makeempty();
         if (!match_templates(return_type, template_parms)) {
            errorArgs[1] = orig_return_type;
            return VSCODEHELPRC_TEMPLATE_ARGS_MISMATCH;
         }
         // now look up the current class, is it a template?
         _str template_sig='';
         tag_split_class_name(found_type, found_inner, found_outer);
         //say("_c_parse_return_type: inner="found_inner" outer="found_outer);
         if (!tag_check_for_template(found_inner, found_outer, true, 
                                    tag_files, template_sig)) {

            if (p_extension :!= 'c' || found_outer!='' ||
                !tag_check_for_template(found_inner, "std", true, 
                                        tag_files, template_sig)) {
               errorArgs[1] = found_inner;
               return VSCODEHELPRC_NOT_A_TEMPLATE_CLASS;
            }
         }
         //say("CLASS="found_type" TEMPLATE_SIG="template_sig);
         // now create hash table of formal params to actual
         if (found_type :!= search_class_name) {
            template_args._makeempty();
            int  i=0, arg_pos  = 0;
            _str argument = cb_next_arg(template_sig, arg_pos, 1);
            while (argument != '') {
               // just keep the last word of the argument string (kludge)
               //say("cb_next_arg returns "argument);
               while (argument != '') {
                  int p = pos('^ @{:v|?}', argument, 1, 'r');
                  int n = pos('0');
                  if (!p) {
                     break;
                  }
                  p = pos('S0');
                  id = substr(argument, p, n);
                  argument = substr(argument, p+n);
                  //say("ID="id" ARG="argument);
                  if (pos(' *=',argument,1,'r')==1) {
                     //say("argument=" substr(argument, pos('')+1)" len="template_parms._length()" i="i);
                     if (i >= template_parms._length()) {
                        template_parms[i] = substr(argument, pos('')+1);
                        //say("TP[i] = "template_parms[i]);
                     }
                     argument='';
                  }
               }
               if (i >= template_parms._length()) {
                  break;
               }
               //say("TEMPLATE ARG: "id"-->"template_parms[i]);
               template_args:[id] = template_parms[i++];
               argument = cb_next_arg(template_sig, arg_pos, 0);
            }
         }
         istemplate = true;
         break;
      case '>':
         break;

      case 'extern':
      case 'struct':
      case 'class':
      case 'interface':
      case 'union':
         if (!_modename_eq(p_mode_name,"InstallScript")) {
            if (ch:=='volatile') {
               c_return_flags |= VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY;
            } else if (ch:=='const') {
               c_return_flags |= VSCODEHELP_RETURN_TYPE_CONST_ONLY;
            }
            break;
         }
         // drop through, treat as a plain identifier
      case 'POINTER':
         if (_modename_eq(p_mode_name,"InstallScript") && 
             ch:=='POINTER' && found_type!='') {
            pointer_count++;
            break;
         }
      case 'BYREF':
         if (_modename_eq(p_mode_name,"InstallScript") && ch:=='BYREF') {
            break;
         }
         // drop through, treat as a plain identifier

      default:
         // this must be an identifier
         // try simple macro substitution
         //say("XXXXXXXXXXXXXXXXXXX, return_type="return_type);
         //if (_MatchSymbolAsDefine(ch, ch)) {
         _UpdateContext(true);
         if (!isjava && tag_check_for_define(ch, 0, tag_files, ch)) {
            switch (ch) {
            case '':
            case 'extern':
            case 'struct':
            case 'class':
            case 'interface':
            case 'union':
               continue;
            case 'volatile':
               c_return_flags |= VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY;
               continue;
            case 'const':
               c_return_flags |= VSCODEHELP_RETURN_TYPE_CONST_ONLY;
               continue;
            }
         }
         if (pos('::*',return_type)==1) {
            return_type='';
            break;
         }
         // try template argument substitution
         _str actual_arg = template_args:[ch];
         if (!actual_arg._isempty() && actual_arg != ch) {
            return_type = actual_arg ' ' return_type;
            //say("RETURN_TYPE="return_type);
            continue;
         }
         package_name = package_name :+ ch;
         if (found_type != '' && allow_local_class && found_seperator) {
            found_type = found_type :+ VS_TAGSEPARATOR_class :+ ch;
            found_seperator = false;
         } else {
            found_type = ch;
         }
      }
   }
   //say("maybe searching for local class");
   //say("search_class="search_class_name" found_type="found_type);
   _str qualified_name = found_type;
   if (isjava && pos('/', package_name)) {
      found_type = package_name;
   }
   if (allow_local_class) {// && (search_class_name == '' || search_class_name == cur_class_name)) {
      //say("JJJJJJ found_type="found_type" return_type="return_type" search_class="search_class_name);
      _str inner_name, outer_name;
      tag_split_class_name(found_type, inner_name, outer_name);
      //say("found_type="found_type" inner_name="inner_name" outer_name="outer_name);
      qualified_name='';
      if (length(outer_name) < length(search_class_name)) {
         //say("inner_name="inner_name" search_class="search_class_name);
         outer_name = tag_join_class_name(inner_name, search_class_name, tag_files, true);
         //say("outer_name="outer_name);
         qualified_name = outer_name;
         if (outer_name :== '' && search_class_name :!= '' && found_type :!= inner_name) {
            outer_name = found_type;
         }
      }
      if (qualified_name=='') {
         //say("JJJJJJJ inner_name="inner_name" outer_name="outer_name);
         qualified_name = _QualifySymbolName(inner_name, outer_name, file_name, true);
         //say("JJJJJJJ qualify="qualified_name" symbol="symbol" class="search_class_name);
      }
      if (qualified_name=='') {
         qualified_name = found_type;
      }
   }
   if (!isjava) {
      // try to handle typedefs
      //say("check for typedef, qualified_name="qualified_name" found_type="found_type);
      if (depth < VSCODEHELP_MAXRECURSIVETYPESEARCH) {
         tag_split_class_name(qualified_name, qualified_inner, qualified_outer);
         //say("_c_parse_return_type: inner="qualified_inner" outer="qualified_outer);
         if (tag_check_for_typedef(/*found_type*/qualified_inner, tag_files, true)) {
            //say(qualified_name" is a typedef");
            int orig_const_only    = (c_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY);
            int orig_volatile_only = (c_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY);
            //say("istemplate="istemplate);
            status = _c_get_return_type_of(errorArgs, tag_files, qualified_inner, qualified_outer,
                                           0, isjava, VS_TAGFILTER_TYPEDEF, false,
                                           qualified_name, pointer_count,
                                           template_args, istemplate,
                                           c_return_flags, match_tag, depth+1);
            if (!(c_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY)) {
               c_return_flags |= orig_const_only;
            }
            if (!(c_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY)) {
               c_return_flags |= orig_volatile_only;
            }
            if (status) {
               return status;
            }
         }
         //say("qualify = "qualified_name" found_type="found_type);
      } else {
         errorArgs[1] = found_type;
         return VSCODEHELPRC_RETURN_TYPE_NOT_FOUND;
      }
   }
   if (qualified_name == '' && 
       (c_return_flags & (VSCODEHELP_RETURN_TYPE_ARRAY|VSCODEHELP_RETURN_TYPE_HASHTABLE)) &&
       (_modename_eq(p_mode_name,"javascript") || 
        _modename_eq(p_mode_name,"slick-c"))) {
      qualified_name = found_type;
   }
   if (qualified_name == '') {
      _str builtin_types = C_BUILTIN_TYPES;
      if (p_extension == 'rul') {
         builtin_types = RUL_BUILTIN_TYPES;
      }
      if (pos(' 'found_type' ',builtin_types)) {
         errorArgs[1] = symbol;
         errorArgs[2] = orig_return_type;
         match_type   = found_type;
         return VSCODEHELPRC_BUILTIN_TYPE;
      }
   }

   match_type = qualified_name;
   //say("_c_parse_return_type returns "match_type);
   if (match_type == '') {
      errorArgs[1] = found_type;
      return VSCODEHELPRC_RETURN_TYPE_NOT_FOUND;
   }
   return 0;
}
static int _check_control_name(int wid, _str name)
{
   if (wid.p_object != OI_SSTAB_CONTAINER && wid.p_object!=OI_FORM) {
      //say("_check_control_name: name="name" p_name="wid.p_name);
      _str widname = stranslate(wid.p_name, '-', '_');
      if (widname == name) {
         return wid;
      }
   }
   return 0;
}
static int _c_get_return_type_of(_str (&errorArgs)[], typeless tag_files,
                                 _str symbol, _str search_class_name,
                                 int min_args, boolean isjava,
                                 int pushtag_mask, boolean maybe_class_name,
                                 _str &match_type, int &pointer_count,
                                 _str (&template_args):[], boolean &istemplate,
                                 int &c_return_flags, _str &match_tag,
                                 int depth=0)
{
   //say("_c_get_return_type_of("symbol","search_class_name")");

   // initialize c_return_flags
   c_return_flags &= ~(VSCODEHELP_RETURN_TYPE_CONST_ONLY|
                       VSCODEHELP_RETURN_TYPE_STATIC_ONLY|
                       VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY|
                       VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS|
                       VSCODEHELP_RETURN_TYPE_ARRAY|
                       VSCODEHELP_RETURN_TYPE_HASHTABLE
                      );
   if (search_class_name == '::') {
      c_return_flags |= VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
      search_class_name = '';
   }

   // get the current class from the context
   _str cur_class_name='';
   int cur_tag_flags=0;
   int context_id = tag_current_context();
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_class, context_id, cur_class_name);
      tag_get_detail2(VS_TAGDETAIL_context_flags, context_id, cur_tag_flags);
      tag_get_detail2(VS_TAGDETAIL_context_type,  context_id, cur_tag_type);
      tag_get_detail2(VS_TAGDETAIL_context_name, context_id, cur_tag_name);
      if (tag_tree_type_is_class(cur_tag_type) || tag_tree_type_is_package(cur_tag_type)) {
         _str no_tag_files[]; no_tag_files._makeempty();
         cur_class_name = tag_join_class_name(cur_tag_name, cur_class_name, no_tag_files, true);
      }
   }

   // special case keyword 'this'
   if (symbol :== 'this') {
      if (search_class_name :== '' && context_id > 0 && 
          !(cur_tag_flags & VS_TAGFLAG_static)) {
         c_return_flags |= VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS;
         if (cur_tag_flags & VS_TAGFLAG_const) {
            c_return_flags |= VSCODEHELP_RETURN_TYPE_CONST_ONLY;
         } else {
            c_return_flags &= ~VSCODEHELP_RETURN_TYPE_CONST_ONLY;
         }
         if (cur_tag_flags & VS_TAGFLAG_volatile) {
            c_return_flags |= VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY;
         } else {
            c_return_flags &= ~VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY;
         }
         c_return_flags &= ~VSCODEHELP_RETURN_TYPE_STATIC_ONLY;
         // attempt to resolve the class name to a package
         // need this for C++ namespaces
         tag_split_class_name(cur_class_name,inner_name,outer_name);
         match_type=_QualifySymbolName(inner_name,outer_name,p_buf_name,true);
         if (match_type=='' || match_type==inner_name) {
            match_type = cur_class_name;
         }
         pointer_count = (isjava)? 0 : 1;
         return 0;
      } else if (isjava && search_class_name != '') {
         c_return_flags &= ~(VSCODEHELP_RETURN_TYPE_CONST_ONLY|
                             VSCODEHELP_RETURN_TYPE_STATIC_ONLY|
                             VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY|
                             VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS|
                             VSCODEHELP_RETURN_TYPE_ARRAY|
                             VSCODEHELP_RETURN_TYPE_HASHTABLE
                            );
         match_type = search_class_name;
         pointer_count = 0;
         return 0;
      }
   }

   int num_matches = _c_match_return_type_of(errorArgs,tag_files,
                                             symbol,search_class_name,
                                             isjava, pushtag_mask, 
                                             c_return_flags);
   // check for error condition
   if (num_matches < 0) {
      return num_matches;
   }

   // resolve the type of the matches
   match_tag = '';
   int orig_return_flags = c_return_flags;
   int status = _c_get_type_of_matches(errorArgs, tag_files, symbol,
                                       search_class_name, cur_class_name,
                                       min_args, isjava, maybe_class_name,
                                       match_type, pointer_count, template_args,
                                       istemplate, c_return_flags, match_tag, depth);
   if (!status && (orig_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY)) {
      c_return_flags |= VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
   }
   return status;
}
static int _c_match_return_type_of(_str (&errorArgs)[], typeless tag_files,
                                   _str symbol, _str search_class_name,
                                   boolean isjava, int pushtag_mask,
                                   int c_return_flags)
{
   //say("_c_match_return_type_of("symbol","search_class_name")");

   // Attempt to qualify symbols to their appropriate package for Java
   if (isjava && search_class_name=='') {
      search_class_name = _QualifySymbolName(symbol, search_class_name, p_buf_name, true);
      tag_split_class_name(search_class_name, junk, search_class_name);
   }
   //say("2 before previous_id="symbol" match_class="search_class_name);

   // try to find match for 'symbol' within context, watch for
   // C++ global designator (leading ::)
   int i, num_matches = 0;
   tag_clear_matches();
   if (c_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY) {
      //say("_c_match_return_type_of: matching globals");
      tag_list_context_globals(0, 0, symbol, true, tag_files, pushtag_mask,
                               VS_TAGCONTEXT_ONLY_non_static,
                               num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS, true, true);
   } else {
      //say("matching class symbols, search_class="search_class_name" symbol="symbol" pushtag_mask="pushtag_mask);
      _MatchSymbolInContext(symbol, search_class_name,
                            num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                            pushtag_mask, true, true,
                            false, false, true, true);
   }

   // return the number of matches
   //say("num_matches="num_matches);
   return num_matches;
}
static int _c_get_type_of_matches(_str (&errorArgs)[], typeless tag_files,
                                  _str symbol, _str search_class_name,
                                  _str cur_class_name, int min_args,
                                  boolean isjava, boolean maybe_class_name,
                                  _str &match_type, int &pointer_count,
                                  _str (&template_args):[], boolean &istemplate,
                                  int &c_return_flags, _str &match_tag,
                                  int depth=0)
{
   //say("_c_get_type_of_matches("symbol","search_class_name")");

   // filter out matches based on number of arguments
   _str matchlist[];
   matchlist._makeempty();
   int num_matches = tag_get_num_of_matches();
   //say("_c_get_type_of_matches num="num_matches", depth="depth);
   for (i=1; i<=num_matches; i++) {
      tag_get_match(i,tag_file,proc_name,type_name,file_name,line_no,class_name,tag_flags,signature,return_type);
      //say("XXX proc_name="proc_name" min_args="min_args" return_type="return_type" type_name="type_name" class_name="class_name);
      // check that number of argument matches.
      if (min_args > 0 && tag_tree_type_is_func(type_name)) {
         int num_args = 0;
         int def_args = 0;
         int ff=1;
         for (;;) {
            _str parm = cb_next_arg(signature, arg_pos, ff);
            if (parm == '') {
               break;
            }
            if (pos('=', parm)) {
               def_args++;
            }
            if (parm :== '...') {
               num_args = min_args;
               break;
            }
            num_args++;
            ff=0;
         }
         // this prototype doesn't take enough arguments?
         if (num_args < min_args) {
            continue;
         }
         // this prototype requires too many arguments?
         if (num_args - def_args > min_args) {
            continue;
         }
      } else if (type_name=='typedef') {
         // skip over recursive typedefs
         parse return_type with p1 ' ' p2;
         if (symbol==return_type || symbol==p2) {
            continue;
         }
      }
      if ((tag_flags & VS_TAGFLAG_operator) && class_name :!= search_class_name) {
         continue;
      }
      //say("WHERE proc_name="proc_name" class="class_name" return_type="return_type);
      if (match_tag == '') {
         match_tag = tag_tree_compose_tag(proc_name, class_name, type_name, tag_flags, signature, return_type);
         //say("MATCH TAG="match_tag);
      }
      if (tag_tree_type_is_class(type_name)) {
         return_type = proc_name;
      }
      if (return_type != '') {
         matchlist[matchlist._length()] = proc_name "\t" class_name "\t" file_name "\t" return_type;
      } else {
         num_matches--;
      }
   }

   // for each match in list, (have to do it this way because
   // _c_parse_return_type()) uses the context match set.
   match_type = '';
   int match_pointer_count = 0;
   _str found_template_args:[];
   boolean found_istemplate = istemplate;
   for (i=0; i<matchlist._length(); i++) {

      parse matchlist[i] with proc_name "\t" class_name "\t" file_name "\t" return_type;
      //say("HERE proc_name="proc_name" class="class_name" return_type="return_type);

      int found_return_flags      = 0;
      int found_pointer_count = 0;
      _str found_type = '';
      found_template_args = template_args;
      found_istemplate    = istemplate;
      status = _c_parse_return_type(errorArgs, tag_files, proc_name, class_name,
                                    file_name, return_type, isjava,
                                    found_type, found_pointer_count,
                                    found_template_args, found_istemplate,
                                    found_return_flags, match_tag, depth);
      if (status) {
         return status;
      }
      //say("**found_type="found_type" match_type="match_type" flags="found_return_flags);
      if (found_type != '') {

         if (match_type == '') {
            match_type = found_type;
            //_message_box("new match type="match_type);
            c_return_flags = found_return_flags;
            pointer_count += found_pointer_count;
            //say("RETURN, pointer_count="pointer_count" found_pointer_count="found_pointer_count" found_type="found_type);
            match_pointer_count = found_pointer_count;
         } else {
            // different opinions on static_only or const_only, chose more general
            if (!(found_return_flags & VSCODEHELP_RETURN_TYPE_STATIC_ONLY)) {
               c_return_flags &= ~VSCODEHELP_RETURN_TYPE_STATIC_ONLY;
            }
            if (!(found_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY)) {
               c_return_flags &= ~VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY;
            }
            if (!(found_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY)) {
               c_return_flags &= ~VSCODEHELP_RETURN_TYPE_CONST_ONLY;
            }
            if (!(found_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY)) {
               c_return_flags &= ~VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
            }
            c_return_flags |= (found_return_flags | VSCODEHELP_RETURN_TYPE_ARRAY);
            c_return_flags |= (found_return_flags | VSCODEHELP_RETURN_TYPE_HASHTABLE);
            if (match_type :!= found_type || match_pointer_count != found_pointer_count) {
               // different return type, this sucks.
               //say("MATCH_TYPE="match_type" FOUND_TYPE="found_type);
               errorArgs[1] = symbol;
               return VSCODEHELPRC_OVERLOADED_RETURN_TYPE;
            }
         }
      }
   }
   template_args._makeempty();
   istemplate = found_istemplate;
   if (found_istemplate) {
      template_args = found_template_args;
   }

   //_message_box("OUT OF LOOP");
   //say("maybe class name, num_matches="num_matches);
   // Java syntax like Class.blah... or C++ style iostream::blah
   if (maybe_class_name && num_matches==0) {
      //say("111 searching for class name, symbol="symbol" class="search_class_name);
      _MatchSymbolInContext(symbol, search_class_name,
                            num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                            VS_TAGFILTER_PACKAGE|VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE|VS_TAGFILTER_UNION|VS_TAGFILTER_PACKAGE,
                            true, !(c_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY), 
                            false, false, true, true);
      //say("found "num_matches" matches");
      if (num_matches > 0) {
         tag_get_match(1, x_tag_file, x_tag_name, x_type_name, x_file_name, x_line_no, x_class_name, x_tag_flags, x_signature, x_return_type);
         //say("X tag="x_tag_name" class="x_class_name" type="x_type_name);
         match_type = symbol;
         if (search_class_name == '' || search_class_name == cur_class_name) {
            _str outer_class_name = cur_class_name;
            int local_matches=0;
            while (outer_class_name != '') {
               _MatchSymbolInContext(match_type, cur_class_name,
                                     local_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                     VS_TAGFILTER_PACKAGE|VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE|VS_TAGFILTER_UNION,
                                     true, !(c_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY), 
                                     false, false, true, true);
               //say("222 match_type="match_type" cur_class_name="cur_class_name" num_matches="local_matches);
               if (local_matches > 0) {
                  tag_get_match(1, rel_tag_file, rel_tag_name, rel_type_name, rel_file_name, rel_line_no, rel_class_name, rel_tag_flags, rel_signature, rel_return_type);
                  match_type = tag_join_class_name(match_type, rel_class_name, tag_files, true);
                  //say("type_name="rel_type_name" MATCH_TYPE="match_type);
                  if (isjava) {
                     c_return_flags |= VSCODEHELP_RETURN_TYPE_STATIC_ONLY;
                  }
                  break;
               }
               tag_split_class_name(outer_class_name, junk, outer_class_name);
            }
         } else if (search_class_name != '') {
            match_type = tag_join_class_name(match_type, search_class_name, tag_files, true);
            if (isjava) {
               c_return_flags |= VSCODEHELP_RETURN_TYPE_STATIC_ONLY;
            }
         }
      }
   }

   // see if 'symbol' is a control for Slick-C
   if ((num_matches==0 || match_type=='') && _modename_eq(p_mode_name,"slick-c")) {
      // maybe should just search source here...
      _str eventtab_name = '';
      save_pos(p);
      save_search(p1,p2,p3,p4);
      if (!search('^ *defeventtab +{:v}','@-r')) {
         eventtab_name = get_text(match_length('0'),match_length('S0'));
         eventtab_name=stranslate(eventtab_name,'-','_');
      }
      restore_search(p1,p2,p3,p4);
      restore_pos(p);

      //say("_c_get_type_of_matches: tab="eventtab_name);
      _str name_symbol = stranslate(symbol,'-','_');
      int wid=_find_formobj(eventtab_name,'E');
      if (!wid) {
         wid = find_index(eventtab_name,oi2type(OI_FORM));
      }
      if (wid) {
         wid = _for_each_control(wid,_check_control_name,'H',name_symbol);
      }
      //say("_c_get_type_of_matches: wid="wid);
      if (wid) {
         match_type = '';
         int t = wid.p_object;
         if (t == OI_MDI_FORM)             match_type = '_mdi_form';
         else if (t == OI_FORM)            match_type = '_form';
         else if (t == OI_TEXT_BOX)        match_type = '_text_box';
         else if (t == OI_CHECK_BOX)       match_type = '_check_box';
         else if (t == OI_COMMAND_BUTTON)  match_type = '_command_button';
         else if (t == OI_RADIO_BUTTON)    match_type = '_radio_button';
         else if (t == OI_FRAME)           match_type = '_frame';
         else if (t == OI_LABEL)           match_type = '_label';
         else if (t == OI_LIST_BOX)        match_type = '_list_box';
         else if (t == OI_HSCROLL_BAR)     match_type = '_hscroll_bar';
         else if (t == OI_VSCROLL_BAR)     match_type = '_vscroll_bar';
         else if (t == OI_COMBO_BOX)       match_type = '_combo_box';
         else if (t == OI_HTHELP)          match_type = '_hthelp';
         else if (t == OI_PICTURE_BOX)     match_type = '_picture_box';
         else if (t == OI_IMAGE)           match_type = '_image';
         else if (t == OI_GAUGE)           match_type = '_gauge';
         else if (t == OI_SPIN)            match_type = '_spin';
         else if (t == OI_MENU)            match_type = '_menu';
         else if (t == OI_MENU_ITEM)       match_type = '_window';
         else if (t == OI_TREE_VIEW)       match_type = '_tree_view';
         else if (t == OI_SSTAB)           match_type = '_sstab';
         else if (t == OI_DESKTOP)         match_type = '_window';
         else if (t == OI_SSTAB_CONTAINER) match_type = '_sstab_container';
         else if (t == OI_EDITOR)          match_type = '_editor';
         //say("t="t" match_type="match_type);
         if (match_type != '') {
            return 0;
         }
      } 
   }

   // no matches?
   if (num_matches == 0) {
      //say("_c_get_type_of_matches: no symbols found");
      errorArgs[1] = symbol;
      return VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }

   // check if we should list private class members
   //say("_c_get_type_of_matches: match_type="match_type" cur_class="cur_class_name);
   int class_pos = pos(cur_class_name,match_type);
   if (tag_current_context()==0) {
      // not sure why anymore
      c_return_flags |= VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS;
   } else {
      // current method is from same class, then we have private access
      int class_pos = lastpos(cur_class_name,match_type);
      if (class_pos>0 && class_pos+length(cur_class_name)==length(match_type)+1) {
         if (class_pos==1) {
            c_return_flags |= VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS;
         } else if (substr(match_type,class_pos-1,1)==VS_TAGSEPARATOR_package) {
            // maybe class comes from imported namespace
            _str import_name = substr(match_type,1,class_pos-2);
            int import_id = tag_find_context(import_name,true,true,false,'');
            while (import_id > 0) {
               tag_get_detail2(VS_TAGDETAIL_context_type,import_id,import_type);
               if (import_type == 'import' || import_type == 'package' ||
                   import_type == 'library' || import_type == 'program') {
                  c_return_flags |= VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS;
                  break;
               }
               import_id = tag_next_context(import_name,true,true,false,'');
            }
         }
      }
   }
   //say("_c_get_type_of_matches() returns "match_type" pointers="pointer_count);
   return 0;
}
// pull prefix off of prefixexp until matching bracket, paren, or lt/gt
static boolean match_generic(_str &prefixexp, _str &parenexp, int &num_args,
                             _str start_close_seperator)
{
   //say("match_generic()");
   _str start_char = substr(start_close_seperator, 1, 1);
   _str close_char = substr(start_close_seperator, 2, 1);
   _str seperator  = substr(start_close_seperator, 3, 1);
   int nesting = 1;
   parenexp = '';
   num_args=1;
   prefixexp = strip(prefixexp,'L');
   for (p=1;;p++) {
      ch = substr(prefixexp, p, 1);
      //say("match_generic: prefixexp="prefixexp" ch="ch);
      if (ch:==start_char) {
         //say("found start char");
         nesting++;
      } else if (ch:==close_char) {
         //say("found close char");
         nesting--;
         if (!nesting) {
            p--;
            break;
         }
      } else if (ch:==seperator) {
         //say("found seperator");
         if (nesting==1) {
            num_args++;
         }
      } else {
         int np = pos(":q|'\\*?'|:v|?", prefixexp, p, 'r');
         if (!np) {
            num_args=0;
            prefixexp = substr(prefixexp, p);
            return false;
         }
         p = np + pos('') - 1;
      }
   }
   if (p<=0) {
      num_args--;
   } else {
      parenexp = substr(prefixexp, 1, p);
   }
   prefixexp = substr(prefixexp, p+2);
   return true;
}
boolean match_parens(_str &prefixexp, _str &parenexp, int &num_args)
{
   return match_generic(prefixexp, parenexp, num_args, '(),');
}
static boolean match_templates(_str &prefixexp, _str (&template_parms)[])
{
   _str parenexp = '';
   boolean result = match_generic(prefixexp, parenexp, num_args, '<>,');
   template_parms._makeempty();
   if (result) {
      int  arg_pos  = 0;
      _str argument = cb_next_arg(parenexp, arg_pos, 1);
      while (argument != '') {
         //say("cb_next_arg returns "argument);
         template_parms[template_parms._length()] = argument;
         argument = cb_next_arg(parenexp, arg_pos, 0);
      }
   }
   return result;
}
boolean match_brackets(_str &prefixexp, int &num_args)
{
   return match_generic(prefixexp, parenexp, num_args, '[],');
}
// returns true if match was found, false otherwise
static _str _c_get_expr_token(_str &prefixexp)
{
   // get next token from expression
   int p = pos('^ @{->(\*|)|\.\*|\:\:|<<|>>|\&\&|\|\||[<>=\|\&\*\+-/~\^\%](=|)|:v|[()\.]|\[|\]}', prefixexp, 1, 'r');
   if (!p) {
      return '';
   }
   p = pos('S0');
   int n = pos('0');
   _str ch = substr(prefixexp, p, n);
   prefixexp = substr(prefixexp, p+n);
   return ch;
}
static int _c_get_type_of_part(_str (&errorArgs)[], typeless tag_files, boolean isjava,
                               _str &previous_id, _str ch,
                               _str &prefixexp, _str &full_prefixexp,
                               _str (&template_args):[], boolean &istemplate,
                               _str &match_class, int &pointer_count, int &reference_count,
                               int &c_return_flags, _str &match_tag, int depth=0)
{
   //say("_c_get_type_of_part("previous_id","ch","prefixexp","full_prefixexp")");
   // was the previous identifier a builtin type?
   _str current_id = previous_id;
   boolean previous_builtin = false;
   _str builtin_types = C_BUILTIN_TYPES;
   if (p_extension=='rul') {
      builtin_types = RUL_BUILTIN_TYPES;
   }
   if (pos(previous_id,builtin_types)) {
      previous_builtin=true;
   }

   // number of arguments in paren or brackets group
   int num_args = 0;

   // is the current token a builtin?
   if (pos(ch,builtin_types)) {
      previous_builtin=true;
      previous_id = ch;
      return 0;
   }

   // process token
   switch (ch) {
   case '->':     // pointer to member
      if (previous_id != '') {
         status = _c_get_return_type_of(errorArgs, tag_files,
                                        previous_id, match_class, 0,
                                        isjava, VS_TAGFILTER_ANYDATA, true,
                                        match_class, pointer_count,
                                        template_args, istemplate,
                                        c_return_flags, match_tag);
         //say("match_class="match_class" pointer_count="pointer_count" status="status);
         if (status) {
            return status;
         }
         previous_id = '';
      }
      //say("pointer_count="pointer_count);
      if (pointer_count != 1) {
         if (pointer_count < 1) {
            if (!isjava) {
               //say("TRYING TO FIND OPERATOR ->");
               status = _c_get_return_type_of(errorArgs,tag_files,
                                              '->', match_class, 0,
                                              false, VS_TAGFILTER_ANYPROC,
                                              false, match_class, pointer_count,
                                              template_args, istemplate,
                                              c_return_flags, match_tag);
               if (status) {
                  match_class='';
               }
               previous_id = '';
            }
            if (match_class == '') {
               errorArgs[1] = '->';
               errorArgs[2] = current_id;
               return (VSCODEHELPRC_DASHGREATER_FOR_NON_POINTER);
            }
            break;
         } else {
            errorArgs[1] = '->';
            errorArgs[2] = current_id;
            return (VSCODEHELPRC_DASHGREATER_FOR_PTR_TO_POINTER);
         }
      }
      pointer_count = 0;
      break;

   case '.':     // member access operator
      if (previous_id != '') {
         //say("before previous_id="previous_id" match_class="match_class);
         status = _c_get_return_type_of(errorArgs, tag_files,
                                        previous_id, match_class, 0, isjava,
                                        VS_TAGFILTER_ANYSTRUCT|VS_TAGFILTER_ANYDATA, true,
                                        match_class, pointer_count,
                                        template_args, istemplate,
                                        c_return_flags, match_tag);
         // special case for array, hash tables in slick-C, javascript
         //say("status="status" p_mode_name="p_mode_name" c-return_flags="c_return_flags);
         // unknown variable used in slick-c 'DOT' expression, then just skip it
         if (_modename_eq(p_mode_name,"slick-c") && 
             depth < VSCODEHELP_MAXRECURSIVETYPESEARCH &&
             (status == VSCODEHELPRC_BUILTIN_TYPE ||
              status == VSCODEHELPRC_NO_SYMBOLS_FOUND)) {
            return _c_get_type_of_prefix(errorArgs, prefixexp, match_class, false,
                                         pointer_count, c_return_flags,
                                         match_tag, depth+1);
         }
         if (status) {
            return status;
         }
         previous_id = '';
         //say("after previous_id="previous_id" match_class="match_class" pointer_count="pointer_count);
      }
      if (pointer_count > 0) {
         //say("checking pointer count > 0");
         if (_modename_eq(p_mode_name,"javascript")) {
            match_class = "Array";
            pointer_count = 0;
         } else if (_modename_eq(p_mode_name,"slick-c")) {
            if (c_return_flags & VSCODEHELP_RETURN_TYPE_ARRAY) {
               match_class = '_array';
               pointer_count = 0;
            } else if (c_return_flags & VSCODEHELP_RETURN_TYPE_HASHTABLE) {
               match_class = '_hashtable';
               pointer_count = 0;
            } else {
               errorArgs[1] = '.';
               errorArgs[2] = current_id;
               return(VSCODEHELPRC_DOT_FOR_POINTER);
            }
         } else {
            errorArgs[1] = '.';
            errorArgs[2] = current_id;
            return(VSCODEHELPRC_DOT_FOR_POINTER);
         }
      } else if (pointer_count < 0) {
         errorArgs[1] = full_prefixexp;
         return(VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX);
      }
      break;

   case '::':    // static member or global scope indicator
      //say(":: previous_id="previous_id" match_class="match_class);
      if (previous_id == '' && match_class=='') {
         c_return_flags |= VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
         match_class = '::';
         //say("XX match_class=::");
      } else if (previous_id != '') {
         status = _c_get_return_type_of(errorArgs, tag_files,
                                        previous_id, match_class, 0,
                                        isjava, VS_TAGFILTER_ANYDATA, true,
                                        match_class, pointer_count,
                                        template_args, istemplate,
                                        c_return_flags, match_tag);
         //say(":: match_class="match_class" status="status);
         //if (status) {
         //   return status;
         //}
         // THIS could be just a class qualification for making an
         // assignment to a pointer to member or pointer to member func.
         // SO, we have to list everything, not just statics.
         // ALSO, the class could be a base class qualification for a
         // function call BASE::myvirtualfunc();
         if (status && tag_check_for_typedef(previous_id, tag_files, true)) {
            //say(previous_id" is a typedef");
            int orig_const_only    = (c_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY);
            int orig_volatile_only = (c_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY);
            status = _c_get_return_type_of(errorArgs, tag_files,
                                           previous_id, match_class, 0,
                                           isjava, VS_TAGFILTER_TYPEDEF, true,
                                           match_class, pointer_count,
                                           template_args, istemplate,
                                           c_return_flags, match_tag);
            //say(":: match_class="match_class" status="status);
            if (!(c_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY)) {
               c_return_flags |= orig_const_only;
            }
            if (!(c_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY)) {
               c_return_flags |= orig_volatile_only;
            }
         }
         if (status) {
            return status;
         }
         previous_id = '';
      } else {
         //say(":: already processed previous ID");
      }
      break;

   case 'new':   // new keyword
      // Just ignore 'new' if we don't know what to do with it
      if (depth==0 && !pos('[(.-]',prefixexp,1,'r')) {
         break;
      }
      p = pos('^:b{:v}:b', prefixexp, 1, 'r');
      if (!p) {
         // this is not good news...
         //say("return from new");
         errorArgs[1] = 'new ' prefixexp;
         return VSCODEHELPRC_INVALID_NEW_EXPRESSION;
      }
      ch = substr(prefixexp, pos('S0'), pos('0'));
      prefixexp = substr(prefixexp, p+pos(''));
      match_class = ch;
      if (substr(prefixexp, 1, 1):=='(') {
         prefixexp = substr(prefixexp, 2);
         if (!match_parens(prefixexp, parenexp, num_args)) {
            // this is not good
            //say("return from new 2");
            errorArgs[1] = 'new 'ch' 'prefixexp;
            return VSCODEHELPRC_PARENTHESIS_MISMATCH;
         }
      }
      previous_id = '';
      if (!isjava) {
         pointer_count=1;
      }
      break;

   case '[':     // array subscript introduction
      if (!match_brackets(prefixexp, num_args)) {
         // this is not good
         //say("return from [");
         errorArgs[1] = full_prefixexp;
         return VSCODEHELPRC_BRACKETS_MISMATCH;
      }
      if (previous_id != '') {
         current_id = previous_id;
         status = _c_get_return_type_of(errorArgs, tag_files,
                                        previous_id, match_class, 0,
                                        isjava, VS_TAGFILTER_ANYDATA, false,
                                        match_class, pointer_count,
                                        template_args, istemplate,
                                        c_return_flags, match_tag);
         if (status) {
            return status;
         }
         previous_id = '';
      }
      if (pointer_count <= 0) {
         if (!isjava) {
            //say("TRYING TO FIND OPERATOR []");
            status = _c_get_return_type_of(errorArgs,tag_files,
                                           '[]', match_class, 0,
                                           false, VS_TAGFILTER_ANYPROC,
                                           false, match_class, pointer_count,
                                           template_args, istemplate,
                                           c_return_flags, match_tag);
            if (status) {
               return status;
            }
            previous_id = '';
         }
         if (match_class == '') {
            errorArgs[1] = current_id;
            return (VSCODEHELPRC_SUBSCRIPT_BUT_NOT_ARRAY_TYPE);
         }
         break;
      }
      pointer_count--;
      //say("PREFIX[], pointer_count="pointer_count);
      break;

   case ']':     // array subscript close
      // what do I do here?
      break;

   case '(':     // function call, cast, or expression grouping
      if (!match_parens(prefixexp, cast_type, num_args)) {
         // this is not good
         //say("return from (");
         errorArgs[1] = full_prefixexp;
         return VSCODEHELPRC_PARENTHESIS_MISMATCH;
      }
      if (previous_id != '') {
         //say("GOT HERE 1");
         if (previous_builtin) {
            //say("GOT HERE 2");
            match_class = previous_id;
            pointer_count = 0;
         } else {
            //say("GOT HERE 3, previous_id="previous_id" match_class="match_class" num_args="num_args);
            // this was a function call or new style function pointer
            status = _c_get_return_type_of(errorArgs,tag_files,previous_id, 
                                           match_class, num_args, isjava, 
                                           VS_TAGFILTER_ANYPROC|VS_TAGFILTER_ANYDATA, false,
                                           new_match_class, pointer_count,
                                           template_args, istemplate,
                                           c_return_flags, match_tag);
            //say("status="status" pointer_count="pointer_count" match_tag="match_tag);
            if (status && status!=VSCODEHELPRC_NO_SYMBOLS_FOUND) {
               return status;
            }
            // did we find a variable of a function or function pointer?
            boolean is_function=false;
            if (match_tag != '') {
               _str ts='',tr='';
               tag_tree_decompose_tag(match_tag, tn,cn,tt,tf,ts,tr);
               if (tag_tree_type_is_func(tt) || pos('(',tr)) {
                  is_function=true;
               }
            }
            //say("3 new_match_class="new_match_class);
            // could not find match class, maybe this is a function-style cast?
            if (!isjava && new_match_class == '') {
               //say("GOT HERE 4");
               int num_matches = 0;
               _MatchSymbolInContext(previous_id, match_class, 
                                     num_matches, VSCODEHELP_MAXFINDCONTEXTTAGS, 
                                     VS_TAGFILTER_ANYSTRUCT|VS_TAGFILTER_TYPEDEF, true,
                                     true, false, true, true, true);
               if (num_matches > 0) {
                  //say("_c_get_type_of_prefix: "previous_id" is a struct or typedef");
                  _str dummy_tag = '';
                  status = _c_parse_return_type(errorArgs, tag_files, '', '', p_buf_name,
                                                previous_id, isjava,
                                                match_class, pointer_count,
                                                template_args, istemplate,
                                                c_return_flags, dummy_tag);
                  if (!status) {
                     is_function = true;
                  }
               } else if (match_class != '') {
                  pointer_count = 0;
               }
               //say("4 match_class="match_class" status="status" pointer_count="pointer_count);
            } else {
               //say("GOT HERE 5");
               match_class = new_match_class;
               previous_id='';
            }
            // maybe they have function call operator
            //say("GOT HERE 6, match_class="match_class)
            if (!isjava && match_class != '' && !status && !is_function) {
               status = _c_get_return_type_of(errorArgs,tag_files,'()', 
                                              match_class, num_args,
                                              isjava, VS_TAGFILTER_ANYPROC, false,
                                              match_class, pointer_count,
                                              template_args, istemplate,
                                              c_return_flags, match_tag);
               if (status && status != VSCODEHELPRC_BUILTIN_TYPE && 
                   status != VSCODEHELPRC_NO_SYMBOLS_FOUND) {
                  return status;
               }
               //say("8 match_class="match_class" status="status" pointer="pointer_count);
            }
            //say("GOT HERE 10");
            previous_id = '';
         }
      } else {
         //say("cast_type="cast_type" prefixexp="prefixexp);
         // perhaps a function pointer call
         if (pos('^\*{:v|[(]}',cast_type,1,'r') && pos('(',prefixexp)==1) {
            //say("think it's a function pointer");
            cast_type = substr(cast_type, 2);
            status = _c_get_type_of_prefix(errorArgs, cast_type, match_class,
                                           isjava, pointer_count, 
                                           c_return_flags, match_tag, depth+1);
            if (status) {
               return status;
            }
            //say("PFN: match_class="match_class"prefixexp="prefixexp" cast_type="cast_type);
            prefixexp = substr(prefixexp, 2);
            //say("33333prefixexp="prefixexp);
            if (!match_parens(prefixexp, cast_type, num_args)) {
               // this is not good
               //say("return from (");
               errorArgs[1] = full_prefixexp;
               return VSCODEHELPRC_PARENTHESIS_MISMATCH;
            }
         } else if (pos("([-][>]|[.])[*]", cast_type, 1, 'r') && pos('(',prefixexp)==1) {
            // this is a pointer to member function invocation
            //say("think it's a pointer to member function");
            status = _c_get_type_of_prefix(errorArgs, cast_type, match_class,
                                           isjava, pointer_count,
                                           c_return_flags, match_tag, depth+1);
            if (status) {
               return status;
            }
            //say("PFMF: match_class="match_class"prefixexp="prefixexp" cast_type="cast_type);
            prefixexp = substr(prefixexp, 2);
            //say("33333prefixexp="prefixexp);
            if (!match_parens(prefixexp, cast_type, num_args)) {
               // this is not good
               //say("return from (");
               errorArgs[1] = full_prefixexp;
               return VSCODEHELPRC_PARENTHESIS_MISMATCH;
            }
         } else if (pos("^[*&(]@:v",prefixexp,1,'r')) {
            // a cast will be followed by an identifier, (, *, or &
            //say("think it's a cast, depth="depth);
            if (depth > 0) {
               _str dummy_tag;
               status = _c_parse_return_type(errorArgs, tag_files, '', '', p_buf_name,
                                             cast_type, isjava,
                                             match_class, pointer_count,
                                             template_args, istemplate,
                                             c_return_flags, dummy_tag);
               //say("CAST: match_class="match_class"prefixexp="prefixexp" cast_type="cast_type" status="status);
               prefixexp='';
               return status;
            }
            // otherwise, just ignore the cast
         } else if (!pos('(',cast_type) && pos(',',cast_type)) {
            // this looks like an argument list, check for operator
            // function call.
            status = _c_get_return_type_of(errorArgs,tag_files,'()', 
                                           match_class, num_args,
                                           isjava, VS_TAGFILTER_ANYPROC, false,
                                           match_class, pointer_count,
                                           template_args, istemplate,
                                           c_return_flags, match_tag);
            if (status) {
               return status;
            }
         } else {
            // not a cast, must be an expression, go recursive
            //say("think it's an expression, cast_type="cast_type);
            status = _c_get_type_of_prefix(errorArgs, cast_type, match_class,
                                           isjava, pointer_count,
                                           c_return_flags, match_tag, depth+1);
            if (status) {
               return status;
            }
            //say("EXPR: match_class="match_class"prefixexp="prefixexp" cast_type="cast_type);
         }
      }
      break;

   case ')':
      // what do I do here?
      errorArgs[1] = full_prefixexp;
      return VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX;

   case 'this':
      status = _c_get_return_type_of(errorArgs, tag_files, ch, '', 0,
                                     isjava, VS_TAGFILTER_ANYDATA,
                                     false, match_class, pointer_count,
                                     template_args, istemplate, c_return_flags, match_tag);
      if (status) {
         return status;
      }
      previous_id = '';
      if (!isjava) {
         pointer_count = 1;
      }
      break;

   case '->*':   // pointer to member function
   case '.*':    // binds left-to-right, type of rhs is result
      previous_id = '';
      match_class='';
      break;

   case '*':     // dereference pointer
   case '&':     // get reference to object
      if (!isjava) {
         if (ch:=='*') {
            reference_count--;
            break;
         } else if (ch:=='&') {
            reference_count++;
            break;
         }
      }
      // drop through to operator overloading case

   case '<':
      if (ch:=='<' && !isjava && match_generic(prefixexp, templateexp, num_args, '<>,') && previous_id :!= '') {
         int orig_globals_only = (c_return_flags * VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY);
         status = _c_get_return_type_of(errorArgs, tag_files, previous_id, match_class,
                                        0, isjava, VS_TAGFILTER_ANYDATA, true,
                                        match_class, pointer_count,
                                        template_args, istemplate,
                                        c_return_flags, match_tag);
         c_return_flags &= ~VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
         c_return_flags |= orig_globals_only;
         //say("<> match_class="match_class" status="status" prefixexp="prefixexp" istemplate="istemplate);
         if (!status) {
            previous_id = '';
            break;
         }
      }
      // drop through to operator overloading case

   case '=':     // binary operators within expression
   case '-':
   case '+':
   case '/':
   case '%':
   case '^':
   case '<<':
   case '>>':
   case '&&':
   case '|':
   case '||':
   case '<=':
   case '>=':
   case '==':
   case '>':   // '<' is needed for templates, above
      if (depth <= 0) {
         errorArgs[1] = full_prefixexp;
         return VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX;
      }
      if (!isjava) {
         if (previous_id != '') {
            match_tag = '';
            status = _c_get_return_type_of(errorArgs, tag_files, 
                                           previous_id, match_class, 0,
                                           isjava, VS_TAGFILTER_ANYDATA, true,
                                           match_class, pointer_count,
                                           template_args, istemplate,
                                           c_return_flags, match_tag);
            if (status) {
               return status;
            }
            previous_id = '';
         }
         // check for operator overloading
         if (match_class != '') {
            status = _c_get_return_type_of(errorArgs, tag_files, ch, match_class, 0,
                                           isjava, VS_TAGFILTER_ANYPROC, true,
                                           new_match_class, pointer_count,
                                           template_args, istemplate,
                                           c_return_flags, match_tag);
            if (status && status!=VSCODEHELPRC_NO_SYMBOLS_FOUND) {
               return status;
            }
            if (!status) {
               match_class = new_match_class;
            }
         }
         if (match_class == '') {
            errorArgs[1] = full_prefixexp;
            return VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX;
         }
         prefixexp = '';  // breaks us out of loop
      }
      break;
      // drop through, treat it as a an identifier

   case 'super':
      if (isjava && ch:=='super') {
         status = _c_get_return_type_of(errorArgs, tag_files, 'this', '', 0, 
                                        isjava, VS_TAGFILTER_ANYDATA, false, 
                                        match_class, pointer_count,
                                        template_args, istemplate,
                                        c_return_flags, match_tag);
         if (status) {
            return status;
         }
         parents = cb_get_normalized_inheritance(match_class, tag_dbs, tag_files, true);
         parse parents with match_class ';' parents;
         // add each of them to the list also
         orig_db = tag_current_db();
         while (parents != '') {
            parse parents with p1 ';' parents;
            parse tag_dbs with t1 ';' tag_dbs
            status = tag_read_db(t1);
            if (status) {
               continue;
            }
            // add transitively inherited class members
            tag_split_class_name(p1, match_class, outer_class);
            status = tag_find_tag(match_class, 'class', outer_class);
            if (!status) {
               match_class = p1;
               break;
            }
         }
         previous_id = '';
         break;
      }
      // drop through, treat as a plain identifier

   case 'outer':
      if (isjava && ch:=='outer') {
         status = _c_get_return_type_of(errorArgs, tag_files, 'this', '', 0, 
                                        isjava, VS_TAGFILTER_ANYDATA, false,
                                        match_class, pointer_count,
                                        template_args, istemplate,
                                        c_return_flags, match_tag);
         if (status) {
            return status;
         }
         tag_split_class_name(match_class, junk, match_class);
         previous_id = '';
         break;
      }
      // drop through and treat as a plain identifier

   case 'operator':
      if (!isjava && ch :== 'operator') {
         prefixexp = strip(prefixexp,'L');
         int pp = pos('(',prefixexp,2);
         if (pp > 0) {
            ch = strip(substr(prefixexp,1,pp-1));
            prefixexp = substr(prefixexp,pp+1);
            //say("***prefixexp="prefixexp" ch="ch);
            if (!match_parens(prefixexp, dummy_args, num_args)) {
               // this is not good
               //say("return from (");
               errorArgs[1] = full_prefixexp;
               return VSCODEHELPRC_PARENTHESIS_MISMATCH;
            }
            status = _c_get_return_type_of(errorArgs, tag_files, ch, 
                                           match_class, num_args,
                                           isjava, VS_TAGFILTER_ANYPROC, false,
                                           match_class, pointer_count,
                                           template_args, istemplate,
                                           c_return_flags, match_tag);
            if (status) {
               return status;
            }
            previous_id='';
         } else {
            ch = strip(prefixexp);
            prefixexp='';
         }
         break;
      }
      // drop through, treat it as an identifier

   default:
      // this must be an identifier (or drop-through case)
      match_tag = '';
      previous_id = ch;
      var_filters = VS_TAGFILTER_VAR|VS_TAGFILTER_PROPERTY;
      if (match_class == '') {
         var_filters |= VS_TAGFILTER_LVAR|VS_TAGFILTER_GVAR;
      }
      if (isjava || p_extension == 'pl') {
         // search ahead and try to match up package name
         _str package_name = previous_id;
         _str orig_prefix  = prefixexp;
         while (orig_prefix != '') {
            //say("package_name="package_name);
            if (tag_check_for_package(package_name, tag_files, true, true)) {
               match_class = package_name;
               previous_id = '';
               //say("found package "package_name);
               prefixexp = orig_prefix;
            }
            ch = _c_get_expr_token(orig_prefix);
            //say("prefixexp = "orig_prefix" ch="ch);
            if (ch != '.' && ch != '::') {
               break;
            }
            _str sepch=ch;
            ch = _c_get_expr_token(orig_prefix);
            //say("prefixexp = "orig_prefix" ch="ch);
            if (ch == '' || !isid_valid(ch)) {
               break;
            }
            package_name = package_name :+ sepch :+ ch;
         }
      }
      break;
   }

   // successful so far, cool.
   //say("_c_get_type_of_part: success");
   return 0;
}
int _c_get_type_of_prefix(_str (&errorArgs)[], _str prefixexp, 
                          _str &match_class, boolean isjava,
                          int &pointer_count, int &c_return_flags,
                          _str &match_tag, int depth=0)
{
   //say("_c_get_type_of_prefix("prefixexp")");

   // initiialize return values
   match_class    = '';
   pointer_count  = 0;
   c_return_flags = 0;

   // loop variables
   typeless tag_files       = tags_filenamea(p_extension);
   _str     full_prefixexp  = prefixexp;
   _str     previous_id     = '';
   int      reference_count = 0;
   boolean  found_define    = false;
   boolean  istemplate      = false;
   _str     template_args:[];
   template_args._makeempty();

   // save the arguments, for retries later
   _str     orig_prefixexp       = prefixexp;
   typeless orig_template_args   = template_args;
   boolean  orig_istemplate      = istemplate;
   _str     orig_match_class     = match_class;
   int      orig_pointer_count   = pointer_count;
   int      orig_reference_count = reference_count;
   int      orig_c_return_flags  = c_return_flags;
   _str     orig_match_tag       = match_tag;
   _str     orig_previous_id     = previous_id;

   // process the prefix expression, token by token, delegate
   // most of processing to recursive func _c_get_type_of_part
   while (prefixexp != '') {

      // get next token from expression
      _str ch = _c_get_expr_token(prefixexp);
      //say("get prefixexp = "prefixexp" ch="ch);
      if (ch == '') {
         // don't recognize something we saw
         errorArgs[1] = full_prefixexp;
         return(VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX);
      }

      // process this part of the prefix expression
      status = _c_get_type_of_part(errorArgs, tag_files, isjava,
                                   previous_id, ch, prefixexp, full_prefixexp,
                                   template_args, istemplate, match_class,
                                   pointer_count, reference_count, 
                                   c_return_flags, match_tag, depth);

      if (status && found_define) {
         //say("FAIL and retry with "orig_previous_id" instead of "previous_id);
         // try the original ID, not what the define said it was
         prefixexp       = orig_prefixexp;
         previous_id     = orig_previous_id;
         template_args   = orig_template_args;
         istemplate      = orig_istemplate;
         match_class     = orig_match_class;
         pointer_count   = orig_pointer_count;
         reference_count = orig_reference_count;
         match_tag       = orig_match_tag;
         status = _c_get_type_of_part(errorArgs, tag_files, isjava,
                                      previous_id, ch, prefixexp, full_prefixexp,
                                      template_args, istemplate, match_class,
                                      pointer_count, reference_count, 
                                      c_return_flags, match_tag, depth);
      }
      if (status) {
         return status;
      }

      // check if 'previous' ID was a define
      found_define = false;
      orig_previous_id = previous_id;
      if (!isjava && isid_valid(previous_id)) {
         tag_check_for_define(previous_id, p_line, tag_files, previous_id);
         if (previous_id != orig_previous_id) {
            found_define=true;
         }
      }

      // save the arguments, for retries later
      orig_prefixexp       = prefixexp;
      orig_template_args   = template_args;
      orig_istemplate      = istemplate;
      orig_match_class     = match_class;
      orig_pointer_count   = pointer_count;
      orig_reference_count = reference_count;
      orig_c_return_flags  = c_return_flags;
      orig_match_tag       = match_tag;
   }

   if (previous_id != '') {
      //say("before previous_id="previous_id" match_class="match_class);
      int var_filters = VS_TAGFILTER_ANYDATA;
      if (!isjava) {
         var_filters |= VS_TAGFILTER_ANYPROC;
      }

      status = _c_get_return_type_of(errorArgs, tag_files, previous_id, match_class, 0,
                                     isjava, var_filters, true,
                                     match_class, pointer_count,
                                     template_args, istemplate,
                                     c_return_flags, match_tag);
      if (status && found_define) {
         // try the original ID, not what the define said it was
         prefixexp       = orig_prefixexp;
         template_args   = orig_template_args;
         istemplate      = orig_istemplate;
         match_class     = orig_match_class;
         pointer_count   = orig_pointer_count;
         reference_count = orig_reference_count;
         match_tag       = orig_match_tag;
         previous_id     = orig_previous_id;

         status = _c_get_return_type_of(errorArgs, tag_files, previous_id, match_class, 0,
                                        isjava, var_filters, true,
                                        match_class, pointer_count,
                                        template_args, istemplate,
                                        c_return_flags, match_tag);
      }
      if (status) {
         return status;
      }
      previous_id = '';
      //say("after previous_id="previous_id" match_class="match_class" match_tag="match_tag);
   }
   pointer_count += reference_count;

   //say("_c_get_type_of_prefix: returns "match_class);
   return 0;
}
int _js_MaybeBuildTagFile(int &tfindex)
{
   ext='js';
   tfindex=find_index('def-tagfiles-'ext,MISC_TYPE);
   // IF the user does not have an extension specific tag file for Slick-C
   status=0;
   name_part='js.vtg';
   tagfilename=absolute(_config_path():+name_part);
   if (!tfindex || !pos(name_part,name_info(tfindex),1,_fpos_case) ||
       tag_read_db(tagfilename)==FILE_NOT_FOUND_RC) {
      // Tag the Slick-C macros
      tag_close_db(tagfilename);
      //status=tag_create_db(filename);
      slickc_filename=path_search('maketags'_macro_ext,'VSLICKMACROS');
      if (slickc_filename=="") {
         slickc_filename=path_search('maketags'_macro_ext'x','VSLICKMACROS');
      }
      if (slickc_filename!='') {
         path=strip_filename(slickc_filename,'n');
         extra_file=get_env('VSROOT'):+'builtins.'ext;
         status=shell('maketags -t -n "JavaScript Builtins" -o 'maybe_quote_filename(tagfilename)' 'maybe_quote_filename(extra_file));
         set_exttagfiles("js "tagfilename,true);
         _config_modify|=CFGMODIFY_DEFDATA;
         tfindex=find_index('def-tagfiles-'ext,MISC_TYPE);
         //_TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
         //_TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
         //stop();
         //_message('abort');
         //return(0);
      } else {
         status=1;
      }
   }
   return(status);
}
int _js_insert_context_tags(_str (&errorArgs)[],int editorctl_wid,_str prefixexp,_str lastid,_str lastid_prefix,int lastidstart_offset,_str expected_type,int info_flags,typeless otherinfo)
{
   //say("_js_insert_context_tags("prefixexp","lastid","lastid_prefix")");
   // id followed by paren, then limit search to functions
   errorArgs._makeempty();
   boolean funcs_only = false;
   if (info_flags & VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN) {
      funcs_only = true;
   }

   // watch out for unwelcome 'new' as prefix expression
   if (strip(prefixexp)=='new') {
      prefixexp='';
   }

   // set up for (possibly) incremental update
   cb_prepare_expand(0, p_window_id, TREE_ROOT_INDEX);
   int status, first_index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);

   // get the current class and current package from the context
   _str tag_files[];
   tag_files = tags_filenamea(editorctl_wid.p_extension);
   editorctl_wid._UpdateContext(true);
   editorctl_wid._UpdateLocals(true);
   _str cur_class_name = '';
   _str cur_package_name = '';
   int context_id = editorctl_wid.tag_current_context();
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, cur_type_name);
      tag_get_detail2(VS_TAGDETAIL_context_class, context_id, cur_class_name);
      if (tag_tree_type_is_class(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, class_name);
         //cur_class_name = editorctl_wid._JoinClassWithOuter(class_name, cur_class_name, true, true);
         cur_class_name = tag_join_class_name(class_name, cur_class_name, tag_files, true);
      }
      if (tag_tree_type_is_package(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, cur_package_name);
      } else if (pos(VS_TAGSEPARATOR_package, cur_class_name)) {
         cur_package_name = substr(cur_class_name, 1, pos('S')-1);
      }
   }

   // get list of only javascript tag files
   _str js_tag_files[]; js_tag_files._makeempty();
   for (i=0; i<tag_files._length(); i++) {
      status = tag_read_db(tag_files[i]);
      if (!status) {
         status = tag_find_file(file_name);
         if (refer_ext(lowcase(get_extension(file_name)))!='js') {
            continue;
         }
         js_tag_files[js_tag_files._length()] = tag_files[i];
      }
   }

   // how many of each category did we find?
   int locals_count  = 0;
   int symbols_count = 0;
   int members_count = 0;
   int classes_count = 0;
   static _str    classes_lastid;
   static _str    symbols_lastid;
   static _str    members_lastid;
   static boolean classes_truncated;
   static boolean symbols_truncated;
   static boolean members_truncated;
   if (first_index <= 0) {
      symbols_truncated = true;
      members_truncated = true;
      classes_truncated = true;
   }

   // no prefix expression, update globals and symbols from current context
   if (prefixexp == '') {
      int locals_root  = 0;
      int symbols_root = 0;
      int members_root = 0;
      int classes_root = 0;

      // first time here, set up categories, otherwise, find them...
      if (first_index <= 0) {
         // FIRST TIME INSERTING ITEMS
         _TreeSetUserInfo(TREE_ROOT_INDEX, 0); // do not search/sort root level
         locals_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals,   TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         symbols_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_buffer,   TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         members_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         classes_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_classes,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);

         // insert locals and 'this' if there is class context
         if (!funcs_only) {
            _str this_class_name = editorctl_wid._MatchThisOrSelf();
            if (this_class_name != '') {
               this_class_name = stranslate(this_class_name, '.', '/');
               this_class_name = stranslate(this_class_name, '.', ':');
               tag_tree_insert_tag(p_window_id,locals_root,0,1,0,'this','var','',0,'',0,this_class_name);
               locals_count++;
            }
         }
         editorctl_wid._CodeHelpListContextLocals(p_window_id,locals_root,js_tag_files,
                                                  lastid,lastid_prefix,'',
                                                  VS_TAGFILTER_ANYTHING,VS_TAGCONTEXT_ANYTHING,
                                                  locals_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
      } else {
         // INCREMENTAL UPDATE
         locals_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals);
         symbols_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_buffer);
         members_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members);
         classes_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_classes);
         // for non-incremental items, count the actual number of items
         if (locals_root > 0) {
            locals_count = _TreeGetNumChildren(locals_root);
         }
      }

      // update the members in the current context
      if (members_truncated || pos(members_lastid, lastid_prefix)!=1) {
         if (members_root > 0) {
            _TreeBeginUpdate(members_root);
            if (cur_class_name != '') {
               editorctl_wid._ListMembersInContext(p_window_id, members_root, false, 
                                                   funcs_only, false, false, false, false, 
                                                   members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
               if (editorctl_wid.p_LangCaseSensitive &&
                   _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members) > 0) {
                  editorctl_wid._ListMembersInContext(p_window_id, members_root, false, 
                                                      funcs_only, false, false, false, true, 
                                                      members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
               }
            } else {
               editorctl_wid._CodeHelpListContextGlobals(p_window_id,members_root,false,js_tag_files,
                                                         lastid,lastid_prefix,
                                                         VS_TAGFILTER_ANYTHING-VS_TAGFILTER_ANYSTRUCT,
                                                         VS_TAGCONTEXT_ONLY_non_static,
                                                         members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            }
            _TreeEndUpdate(members_root);
         }
         members_lastid = lastid_prefix;
         members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;
      } else {
         members_count = 1;
      }

      // update the symbols from current buffer, give case-sensitive matches preference
      if (symbols_truncated || pos(symbols_lastid, lastid_prefix)!=1) {
         if (symbols_root > 0) {
            _TreeBeginUpdate(symbols_root);
            _str no_tag_files[]; no_tag_files._makeempty();
            editorctl_wid._CodeHelpListContextGlobals(p_window_id,symbols_root,
                                                      true,no_tag_files,lastid,lastid_prefix,
                                                      VS_TAGFILTER_ANYTHING,VS_TAGCONTEXT_ANYTHING,
                                                      symbols_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            _TreeEndUpdate(symbols_root);
         }
         symbols_lastid = lastid_prefix;
         symbols_truncated = (symbols_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      } else {
         symbols_count=1;
      }

      // update the classes, make sure that case-sensitive matches get preference
      if (classes_truncated || pos(classes_lastid, lastid_prefix)!=1) {
         if (classes_root > 0) {
            _TreeBeginUpdate(classes_root);
            editorctl_wid.tag_list_globals_of_type(p_window_id, classes_root, js_tag_files,
                                                   VS_TAGTYPE_class, 0, 0, 
                                                   classes_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            _TreeEndUpdate(classes_root);
         }
         classes_lastid = lastid_prefix;
         classes_truncated = (classes_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      } else {
         classes_count=1;
      }

      // all done
      errorArgs[1] = lastid;
      int total_count = locals_count+members_count+symbols_count+classes_count;
      return (total_count>0)? 0 : VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }

   // nothing important has changed, so no incremental update
   if (!members_truncated && pos(members_lastid, lastid_prefix)==1) {
      return 0;
   }

   // prefix expression is not null, so no categories, just list memebers
   _TreeSetUserInfo(TREE_ROOT_INDEX, 1);
   _TreeBeginUpdate(TREE_ROOT_INDEX);

   // maybe prefix expression is a package name or prefix of package name
   if (pos("^[$_a-zA-Z0-9.]@$", prefixexp, 1, 'r') &&
      //editorctl_wid._MatchSymbolAsPackage(prefixexp:+lastid, false, true)) {
      tag_check_for_package(prefixexp:+lastid, tag_files, false, true)) {
      editorctl_wid.tag_list_context_packages(p_window_id,TREE_ROOT_INDEX,prefixexp,tag_files,
                                              members_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                              false,true);
      _TreeSortCaption(TREE_ROOT_INDEX, 'u');
      members_count = 0;
      int index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
      int start = length(prefixexp)+1;
      while (index > 0) {
         _str caption = _TreeGetCaption(index);
         if (pos(prefixexp, caption)!=1) {
            next_index = _TreeGetNextSiblingIndex(index);
            _TreeDelete(index);
            index = next_index;
            continue;
         }
         caption = substr(caption, start);
         _TreeSetCaption(index, caption);
         //say("trimmed caption="caption);
         index = _TreeGetNextSiblingIndex(index);
         members_count++;
      }
   }

   int c_return_flags=0;
   _str dummy_tag = '';
   status = editorctl_wid._c_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                                true, pointer_count,
                                                c_return_flags, dummy_tag);
   if (!status) {
      int context_flags = VS_TAGCONTEXT_ONLY_inclass;
      if (pos(cur_package_name'/',match_class)) {
         context_flags |= VS_TAGCONTEXT_ALLOW_package;
      }
      if (c_return_flags & VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS) {
         context_flags |= VS_TAGCONTEXT_ACCESS_private;
      }
      if (c_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY) {
         context_flags |= VS_TAGCONTEXT_ONLY_const;
      }
      if (c_return_flags & VSCODEHELP_RETURN_TYPE_STATIC_ONLY) {
         context_flags |= VS_TAGCONTEXT_ONLY_static;
      }
      editorctl_wid._ListSymbolsInClass('' /*lastid*/, match_class,
                                        p_window_id, TREE_ROOT_INDEX, 0,
                                        members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                        VS_TAGFILTER_ANYTHING, context_flags,
                                        false, false);
   }
   if (members_count == 0) {
      editorctl_wid._CodeHelpListAnySymbols(p_window_id, TREE_ROOT_INDEX, js_tag_files,
                                            lastid, lastid_prefix,
                                            VS_TAGFILTER_ANYTHING, VS_TAGCONTEXT_ANYTHING,
                                            members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
   }
   _TreeEndUpdate(TREE_ROOT_INDEX);

   // Return 0 indicating success if anything was found
   members_lastid = lastid_prefix;
   members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;
   errorArgs[1] = lastid;
   return (members_count == 0)? VSCODEHELPRC_NO_SYMBOLS_FOUND:0;
}
int _java_insert_context_tags(_str (&errorArgs)[],int editorctl_wid,_str prefixexp,_str lastid,_str lastid_prefix,int lastidstart_offset,_str expected_type,int info_flags,typeless otherinfo)
{
   //say("_java_insert_context_tags("prefixexp","lastid","lastid_prefix")");
   // id followed by paren, then limit search to functions
   errorArgs._makeempty();
   boolean funcs_only = false;
   if (info_flags & VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN) {
      funcs_only = true;
   }

   // watch out for unwelcome 'new' as prefix expression
   if (strip(prefixexp)=='new') {
      prefixexp='';
   }

   // set up for (possibly) incremental update
   cb_prepare_expand(0, p_window_id, TREE_ROOT_INDEX);
   int status, first_index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);

   // get the current class and current package from the context
   typeless tag_files = tags_filenamea(editorctl_wid.p_extension);
   editorctl_wid._UpdateContext(true);
   editorctl_wid._UpdateLocals(true);
   _str cur_class_name = '';
   _str cur_package_name = '';
   int context_id = editorctl_wid.tag_current_context();
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, cur_type_name);
      tag_get_detail2(VS_TAGDETAIL_context_class, context_id, cur_class_name);
      if (tag_tree_type_is_class(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, class_name);
         //cur_class_name = editorctl_wid._JoinClassWithOuter(class_name, cur_class_name, true, true);
         cur_class_name = tag_join_class_name(class_name, cur_class_name, tag_files, true);
      }
      if (tag_tree_type_is_package(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, cur_package_name);
         cur_class_name = cur_package_name;
      } else if (pos(VS_TAGSEPARATOR_package, cur_class_name)) {
         cur_package_name = substr(cur_class_name, 1, pos('S')-1);
      }
   }

   // how many of each category did we find?
   int locals_count  = 0;
   int members_count = 0;
   int classes_count = 0;
   int package_count = 0;
   static _str    package_lastid;
   static _str    classes_lastid;
   static _str    members_lastid;
   static boolean package_truncated;
   static boolean classes_truncated;
   static boolean members_truncated;
   if (first_index <= 0) {
      members_truncated = true;
      classes_truncated = true;
      package_truncated = true;
   }

   // no prefix expression, update globals and members from current context
   if (prefixexp == '') {
      int locals_root  = 0;
      int members_root = 0;
      int classes_root = 0;
      int package_root = 0;

      // first time here, set up categories, otherwise, find them...
      if (first_index <= 0) {
         // FIRST TIME INSERTING ITEMS
         _TreeSetUserInfo(TREE_ROOT_INDEX, 0); // do not search/sort root level
         locals_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals,   TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         members_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         classes_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_classes,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         package_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_packages, TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         int abstract_count = 0;

         // insert locals and 'this' if there is class context
         if (!funcs_only) {
            _str this_class_name = editorctl_wid._MatchThisOrSelf();
            if (this_class_name != '') {
               this_class_name = stranslate(this_class_name, '.', '/');
               this_class_name = stranslate(this_class_name, '.', ':');
               tag_tree_insert_tag(p_window_id,locals_root,0,1,0,'this','var','',0,'',0,this_class_name);
               locals_count++;
            }
         }
         editorctl_wid._CodeHelpListContextLocals(p_window_id,locals_root,tag_files,
                                                  lastid,lastid_prefix,'',
                                                  VS_TAGFILTER_ANYTHING,VS_TAGCONTEXT_ANYTHING,
                                                  locals_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
      } else {
         // INCREMENTAL UPDATE
         locals_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals);
         members_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members);
         classes_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_classes);
         package_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_packages);
         // for non-incremental items, count the actual number of items
         if (locals_root > 0) {
            locals_count = _TreeGetNumChildren(locals_root);
         }
      }

      // update the members in the current context
      if (members_truncated || pos(members_lastid, lastid_prefix)!=1) {
         if (members_root > 0) {
            _TreeBeginUpdate(members_root);
            editorctl_wid._ListMembersInContext(p_window_id, members_root, false, 
                                                funcs_only, false, false, false, false, 
                                                members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            if (_TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members) > 0) {
               if (members_count < VSCODEHELP_MAXLISTMEMBERSSYMBOLS) {
                  editorctl_wid._ListMembersInContext(p_window_id, members_root, false, 
                                                      funcs_only, false, false, false, true, 
                                                      members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
               }
            }
            if (_TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members) > 0) {
               _TreeEndUpdate(members_root);
            }
         }
         members_lastid = lastid_prefix;
         members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;
      } else if (members_root > 0 && _TreeSearch(members_root,lastid_prefix,'P')>0) {
         members_count = 1;
      }

      // update the classes, make sure that case-sensitive matches get preference
      if (classes_truncated || pos(classes_lastid, lastid_prefix)!=1) {
         if (classes_root > 0) {
            _TreeBeginUpdate(classes_root);
            // java.lang is always imported
            editorctl_wid._ListSymbolsInClass(lastid_prefix,'java.lang',p_window_id,classes_root,0,classes_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS, VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE,VS_TAGCONTEXT_ACCESS_public, false, true);
            if (classes_count < VSCODEHELP_MAXLISTGLOBALSYMBOLS) {
               editorctl_wid._ListSymbolsInClass('','java.lang',p_window_id,classes_root,0,classes_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS, VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE,VS_TAGCONTEXT_ACCESS_public, false, true);
            }
            // look for other imports and global classes in this file
            int num_matches = tag_get_num_of_context();
            for (i=1; i<=num_matches; i++) {
               tag_get_detail2(VS_TAGDETAIL_context_class, i, class_name);
               if (class_name == '' || class_name :== cur_package_name) {
                  tag_get_detail2(VS_TAGDETAIL_context_type, i, type_name);
                  if (type_name :== 'class' || type_name :== 'interface') {
                     tag_tree_insert_fast(p_window_id, classes_root, VS_TAGMATCH_context, i, 0, 1, 0, 0, 0);
                  } else if (type_name :== 'import' || type_name:=='package') {
                     tag_get_detail2(VS_TAGDETAIL_context_name, i, proc_name);
                     if (pos('.*', proc_name) || type_name:=='package') {
                        proc_name = substr(proc_name, 1, pos('S')-1);
                        editorctl_wid._ListSymbolsInClass(lastid_prefix,proc_name,p_window_id,classes_root,0,classes_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS, VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE,VS_TAGCONTEXT_ACCESS_public, false, true);
                        if (classes_count < VSCODEHELP_MAXLISTGLOBALSYMBOLS) {
                           editorctl_wid._ListSymbolsInClass('',proc_name,p_window_id,classes_root,0,classes_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS, VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE,VS_TAGCONTEXT_ACCESS_public, false, true);
                        }
                     } else {
                        proc_name = substr(proc_name, 1+lastpos('.',proc_name));
                        tag_tree_insert_tag(p_window_id, classes_root, 0, 1, 0, proc_name, 'class', '', 0, '', 0, '');
                     }
                  }
               }
            }
            _TreeEndUpdate(classes_root);
         }
         classes_lastid = lastid_prefix;
         classes_truncated = (classes_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      } else if (classes_root > 0 && _TreeSearch(classes_root,lastid_prefix,'P')>0) {
         classes_count = 1;
      }

      // update the members from current buffer, 
      // give case-sensitive matches preference
      if (package_truncated || pos(package_lastid, lastid_prefix)!=1) {
         if (package_root > 0) {
            _TreeBeginUpdate(package_root);
            // java.lang is always imported
            tag_tree_insert_tag(p_window_id, package_root, 0, 1, 0, 'java.lang', 'package', '', 0, '', 0, '');
            package_count++;
            // list other available classes matching prefix
            if (lastid_prefix == '') {
               editorctl_wid.tag_list_globals_of_type(p_window_id, package_root, tag_files, VS_TAGTYPE_package, 0, 0, package_count, VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            } else {
               editorctl_wid.tag_list_context_packages(p_window_id, package_root, lastid_prefix, tag_files, package_count, VSCODEHELP_MAXLISTGLOBALSYMBOLS, false, true);
            }
            // list explicitely imported packages and current package
            int num_matches = tag_get_num_of_context();
            for (i=1; i<=num_matches; i++) {
               tag_get_detail2(VS_TAGDETAIL_context_type, i, type_name);
               if (type_name :== 'package') {
                  tag_tree_insert_fast(p_window_id, package_root, VS_TAGMATCH_context, i, 0, 1, 0, 0, 0);
               } else if (type_name :== 'import') {
                  tag_get_detail2(VS_TAGDETAIL_context_name, i, proc_name);
                  if (pos('.*', proc_name)) {
                     proc_name = substr(proc_name, 1, pos('S')-1);
                     tag_tree_insert_tag(p_window_id, package_root, 0, 1, 0, proc_name, 'import', '', 0, '', 0, '');
                  }
               }
            }
            _TreeEndUpdate(package_root);
         }
         package_lastid = lastid_prefix;
         package_truncated = (package_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      } else if (package_root > 0 && _TreeSearch(package_root,lastid_prefix,'P')>0) {
         package_count = 1;
      }

      // all done
      errorArgs[1] = lastid;
      int total_count = locals_count+members_count+classes_count+package_count;
      return (total_count>0)? 0 : VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }

   // prefix expression is not null, so no categories, just list memebers
   if (!members_truncated && pos(members_lastid, lastid_prefix)==1) {
      return 0;
   }
   _TreeSetUserInfo(TREE_ROOT_INDEX, 1);
   _TreeBeginUpdate(TREE_ROOT_INDEX);

   // remove unwelcome new operator
   if (pos("new ",prefixexp)==1) {
      prefixexp=substr(prefixexp,4);
   }

   // maybe prefix expression is a package name or prefix of package name
   if (pos("^[$_a-zA-Z0-9.]@$", prefixexp, 1, 'r') &&
      tag_check_for_package(prefixexp:+lastid, tag_files, false, true)) {
      //say("got here");
      editorctl_wid.tag_list_context_packages(p_window_id,TREE_ROOT_INDEX,prefixexp,tag_files,members_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS,false,true);
      _TreeSortCaption(TREE_ROOT_INDEX, 'u');
      members_count = 0;
      int index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
      int start = length(prefixexp)+1;
      while (index > 0) {
         _str caption = _TreeGetCaption(index);
         //say("raw caption="caption);
         if (pos(prefixexp, caption)!=1 || length(caption)<=start) {
            next_index = _TreeGetNextSiblingIndex(index);
            _TreeDelete(index);
            index = next_index;
            continue;
         }
         caption = substr(caption, start);
         _TreeSetCaption(index, caption);
         //say("trimmed caption="caption);
         index = _TreeGetNextSiblingIndex(index);
         members_count++;
      }
   }

   int c_return_flags=0;
   _str dummy_tag = '';
   if (prefixexp != '') {
      status = editorctl_wid._c_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                                   true, pointer_count,
                                                   c_return_flags, dummy_tag);
      //say("match_class="match_class);
      if (status && members_count==0) {
         return status;
      }
   } else {
      status = 0;
   }
   if (!status) {
      int context_flags = VS_TAGCONTEXT_ONLY_inclass;
      if (pos(cur_package_name'/',match_class) ||
          (!pos(VS_TAGSEPARATOR_package,match_class) && 
           !pos(VS_TAGSEPARATOR_package,cur_class_name))) {
         context_flags |= VS_TAGCONTEXT_ALLOW_package;
      }
      if (c_return_flags & VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS) {
         context_flags |= VS_TAGCONTEXT_ACCESS_private;
      }
      if (c_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY) {
         context_flags |= VS_TAGCONTEXT_ONLY_const;
      }
      if (c_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY) {
         context_flags |= VS_TAGCONTEXT_ONLY_volatile;
      }
      if (c_return_flags & VSCODEHELP_RETURN_TYPE_STATIC_ONLY) {
         context_flags |= VS_TAGCONTEXT_ONLY_static;
      }
      editorctl_wid._ListSymbolsInClass('' lastid_prefix, match_class,
                                        p_window_id, TREE_ROOT_INDEX, 0,
                                        members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                        VS_TAGFILTER_ANYTHING, context_flags,
                                        false, false);
      if (members_count < VSCODEHELP_MAXLISTMEMBERSSYMBOLS) {
         editorctl_wid._ListSymbolsInClass('' /*lastid*/, match_class,
                                           p_window_id, TREE_ROOT_INDEX, 0,
                                           members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                           VS_TAGFILTER_ANYTHING, context_flags,
                                           false, false);
      }
   }
   _TreeEndUpdate(TREE_ROOT_INDEX);
   members_lastid = lastid_prefix;
   members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;

   // Return 0 indicating success if anything was found
   errorArgs[1] = (lastid!='')? lastid : prefixexp;
   return (members_count == 0)? VSCODEHELPRC_NO_SYMBOLS_FOUND:0;
}
int _c_insert_context_tags(_str (&errorArgs)[],int editorctl_wid,_str prefixexp,_str lastid,_str lastid_prefix,int lastidstart_offset,_str expected_type,int info_flags,typeless otherinfo)
{
   //say("_c_insert_context_tags("prefixexp","lastid","lastid_prefix")");
   // id followed by paren, then limit search to functions
   errorArgs._makeempty();
   int context_flags = 0;
   boolean data_only = false;
   boolean funcs_only = false;
   if (info_flags & VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN) {
      funcs_only = true;
   }

   // watch out for unwelcome 'new' as prefix expression
   if (strip(prefixexp)=='new') {
      prefixexp='';
   }

   // set up for (possibly) incremental update
   cb_prepare_expand(0, p_window_id, TREE_ROOT_INDEX);
   int status, first_index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);

   // get the current class from the context
   typeless tag_files = tags_filenamea(editorctl_wid.p_extension);
   editorctl_wid._UpdateContext(true);
   editorctl_wid._UpdateLocals(true);
   _str cur_class_name = '';
   int context_id = editorctl_wid.tag_current_context();
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, cur_type_name);
      tag_get_detail2(VS_TAGDETAIL_context_class, context_id, cur_class_name);
      if (tag_tree_type_is_class(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, class_name);
         //cur_class_name = editorctl_wid._JoinClassWithOuter(class_name, cur_class_name, true, true);
         cur_class_name = tag_join_class_name(class_name, cur_class_name, tag_files, true);
      } else if (tag_tree_type_is_package(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, cur_class_name);
      }
   }

   // context is a goto statement?
   if (info_flags & VSAUTOCODEINFO_IN_GOTO_STATEMENT) {
      int labels_count=0;
      _TreeSetUserInfo(TREE_ROOT_INDEX, 1); // do search/sort root level
      _CodeHelpListLabels(p_window_id,TREE_ROOT_INDEX,'','',labels_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
      return (labels_count>0)? 0 : VSCODEHELPRC_NO_LABELS_DEFINED;
   }

   // how many of each match did we find?
   int params_count  = 0;
   int locals_count  = 0;
   int symbols_count = 0;
   int members_count = 0;
   int globals_count = 0;
   int imports_count = 0;
   static _str    globals_lastid;
   static _str    symbols_lastid;
   static _str    members_lastid;
   static _str    imports_lastid;
   static boolean symbols_truncated;
   static boolean globals_truncated;
   static boolean members_truncated;
   static boolean imports_truncated;
   if (first_index <= 0) {
      symbols_truncated = true;
      globals_truncated = true;
      members_truncated = true;
      imports_truncated = true;
   }

   // no prefix expression, update globals and symbols from current context
   if (prefixexp == '') {
      int params_root  = 0;
      int locals_root  = 0;
      int members_root = 0;
      int symbols_root = 0;
      int globals_root = 0;
      int imports_root = 0;

      // first time here, set up categories, otherwise, find them...
      if (first_index <= 0) {

         if ((info_flags & VSAUTOCODEINFO_IN_INITIALIZER_LIST) ||
             ((info_flags & VSAUTOCODEINFO_MAYBE_IN_INITIALIZER_LIST) &&
              otherinfo:==cur_class_name)) {
            // INITIALIZER LIST OF CLASS CONSTRUCTOR
            _TreeSetUserInfo(TREE_ROOT_INDEX, 1); // sort root level
            editorctl_wid._ListMembersInContext(p_window_id, TREE_ROOT_INDEX, 
                                                true, false, true, false,
                                                false, false, members_count, 
                                                VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            if (members_count < VSCODEHELP_MAXLISTMEMBERSSYMBOLS) {
               editorctl_wid._ListMembersInContext(p_window_id, TREE_ROOT_INDEX, 
                                                   false, true, false, true,
                                                   false, false, members_count,
                                                   VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            }
            errorArgs[1] = lastid;
            return (members_count==0)? VSCODEHELPRC_NO_SYMBOLS_FOUND:0;

         } else {
            // FIRST TIME INSERTING ITEMS
            _TreeSetUserInfo(TREE_ROOT_INDEX, 0); // do not search/sort root level
            locals_root   = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
            params_root   = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_params,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
            template_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_params,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
            if (cur_class_name != '') {
               members_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members, TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
            }
            symbols_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_buffer,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
            globals_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_globals, TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
            imports_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_imports, TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);

            // insert locals and 'this' if there is class context
            if (!funcs_only) {
               _str this_class_name = editorctl_wid._MatchThisOrSelf();
               if (this_class_name != '') {
                  this_class_name = stranslate(this_class_name, '::', '/');
                  this_class_name = stranslate(this_class_name, '::', ':');
                  tag_tree_insert_tag(p_window_id,locals_root,0,1,0,'this','var','',0,'',0,this_class_name'*const');
                  locals_count++;
               }
            }
            editorctl_wid._CodeHelpListContextLocals(p_window_id,locals_root,tag_files,
                                                     lastid,lastid_prefix,'',
                                                     VS_TAGFILTER_ANYTHING,VS_TAGCONTEXT_ANYTHING,
                                                     locals_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            // insert parameters of #define statement or template class
            editorctl_wid._ListParametersOfDefine(p_window_id, params_root, 
                                                  params_count, 
                                                  VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            editorctl_wid._ListParametersOfTemplate(p_window_id, template_root,
                                                    true, params_count,
                                                    VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
         }
      } else {
         // INCREMENTAL UPDATE
         locals_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals);
         params_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_params);
         symbols_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_buffer);
         members_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members);
         globals_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_globals);
         imports_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_imports);
         // for non-incremental items, count the actual number of items
         if (locals_root > 0) {
            locals_count = _TreeGetNumChildren(locals_root);
         }
         if (params_root > 0) {
            params_count = _TreeGetNumChildren(params_root);
         }
         if (members_root > 0) {
            members_count = _TreeGetNumChildren(members_root);
         }
         if (imports_root > 0) {
            imports_count = _TreeGetNumChildren(imports_root);
         }
      }

      // update the symbols from current buffer, give case-sensitive matches preference
      if (symbols_truncated || pos(symbols_lastid, lastid_prefix)!=1) {
         if (symbols_root > 0) {
            _TreeBeginUpdate(symbols_root);
            _str no_tag_files[]; no_tag_files._makeempty();
            context_flags = 0;
            if (funcs_only) context_flags |= VS_TAGCONTEXT_ONLY_funcs;
            editorctl_wid._CodeHelpListContextGlobals(p_window_id,symbols_root,
                                                      true,no_tag_files,lastid,lastid_prefix,
                                                      VS_TAGFILTER_ANYTHING,context_flags,
                                                      symbols_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            if (symbols_count==0 && context_flags!=0) {
               // desparate, try again
               context_flags = 0;
               editorctl_wid._CodeHelpListContextGlobals(p_window_id,symbols_root,
                                                         true,no_tag_files,lastid,lastid_prefix,
                                                         VS_TAGFILTER_ANYTHING,context_flags,
                                                         symbols_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            }
            _TreeEndUpdate(symbols_root);
         }
         symbols_lastid = lastid_prefix;
         symbols_truncated = (symbols_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      }

      // update the globals, make sure that case-sensitive matches get preference
      //say("trunc="globals_truncated"glid="globals_lastid"lp="lastid_prefix);
      if (globals_truncated || pos(globals_lastid, lastid_prefix)!=1) {
         if (globals_root > 0) {
            _TreeBeginUpdate(globals_root);
            context_flags = VS_TAGCONTEXT_ONLY_non_static;
            if (funcs_only) context_flags |= VS_TAGCONTEXT_ONLY_funcs;
            editorctl_wid._CodeHelpListContextGlobals(p_window_id,globals_root,
                                                      true,tag_files,lastid,lastid_prefix,
                                                      VS_TAGFILTER_ANYTHING,context_flags,
                                                      globals_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            if (globals_count==0 && context_flags!=0) {
               // desparate, try again
               context_flags = 0;
               editorctl_wid._CodeHelpListContextGlobals(p_window_id,globals_root,
                                                         true,tag_files,lastid,lastid_prefix,
                                                         VS_TAGFILTER_ANYTHING,context_flags,
                                                         globals_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            }
            _TreeEndUpdate(globals_root);
         }
         globals_lastid = lastid_prefix;
         globals_truncated = (globals_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      }

      // update the symbols from current buffer, 
      // give case-sensitive matches preference
      if (members_truncated || pos(members_lastid, lastid_prefix)!=1) {
         if (members_root > 0) {
            _TreeBeginUpdate(members_root);
            editorctl_wid._ListMembersInContext(p_window_id, members_root, 
                                                data_only, funcs_only, 
                                                false, false, false, true,
                                                members_count, 
                                                VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            editorctl_wid._ListMembersInContext(p_window_id, members_root, 
                                                data_only, funcs_only, 
                                                false, false, false, false,
                                                members_count, 
                                                VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            _TreeEndUpdate(members_root);
         }
         members_lastid = lastid_prefix;
         members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;
      }

      // update the symbols imported into current buffer, 
      // give case-sensitive matches preference
      if (imports_truncated || pos(imports_lastid, lastid_prefix)!=1) {
         if (imports_root > 0) {
            _TreeBeginUpdate(imports_root);
            int i,n=tag_get_num_of_context();
            for (i=1; i<=n; i++) {
               tag_get_detail2(VS_TAGDETAIL_context_type,i,type_name);
               if (type_name:=='import') {
                  tag_tree_insert_fast(p_window_id,imports_root,VS_TAGMATCH_context,i,0,-1,0,0,0);
                  tag_get_detail2(VS_TAGDETAIL_context_name,i,import_name);
                  if (tag_check_for_package(import_name,tag_files,true,true)) {
                     context_flags = 0;
                     if (funcs_only) context_flags |= VS_TAGCONTEXT_ONLY_funcs;
                     editorctl_wid.tag_list_class_tags(p_window_id,imports_root,tag_files,
                                                       lastid_prefix,import_name,
                                                       VS_TAGFILTER_ANYTHING,context_flags,
                                                       imports_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                                       false, false);
                     if (imports_count==0 && context_flags!=0) {
                        editorctl_wid.tag_list_class_tags(p_window_id,imports_root,tag_files,
                                                          lastid_prefix,import_name,
                                                          VS_TAGFILTER_ANYTHING,VS_TAGCONTEXT_ANYTHING,
                                                          imports_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                                          false, false);
                     }
                  }
               }
            }
            _TreeEndUpdate(imports_root);
            if (imports_count==0) {
               _TreeDelete(imports_root);
               imports_root=0;
            }
         }
         imports_lastid = lastid_prefix;
         imports_truncated = (imports_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;
      }

      // all done
      errorArgs[1] = lastid;
      int total_count = params_count+symbols_count+locals_count+globals_count+members_count+imports_count;
      return (total_count>0)? 0 : VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }

   // already up to date?
   if (!members_truncated && pos(members_lastid, lastid_prefix)==1) {
      return 0;
   }

   // analyse prefix expression to determine effective class type
   int c_return_flags = 0;
   _str dummy_tag = '';
   status = editorctl_wid._c_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                                false, pointer_count, 
                                                c_return_flags, dummy_tags);
   //say("MATCH_CLASS="match_class" status="status" c_return_flags="c_return_flags);
   if (status) {
      return status;
   }
   context_flags = VS_TAGCONTEXT_ONLY_inclass;
   if (c_return_flags & VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS) {
      context_flags |= VS_TAGCONTEXT_ACCESS_private;
   }
   if (c_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY) {
      context_flags |= VS_TAGCONTEXT_ONLY_const;
   }
   if (c_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY) {
      context_flags |= VS_TAGCONTEXT_ONLY_volatile;
   }
   if (c_return_flags & VSCODEHELP_RETURN_TYPE_STATIC_ONLY) {
      context_flags |= VS_TAGCONTEXT_ONLY_static;
   }
   if (!(c_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY)) {
      context_flags |= VS_TAGCONTEXT_ALLOW_locals;
   }
   _TreeSetUserInfo(TREE_ROOT_INDEX, 1); // search/sort root level
   _TreeBeginUpdate(TREE_ROOT_INDEX);
   editorctl_wid._ListSymbolsInClass(lastid, match_class,
                                     p_window_id, TREE_ROOT_INDEX, 0,
                                     members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                     VS_TAGFILTER_ANYTHING, context_flags,
                                     false, true);
   if (lastid != lastid_prefix) {
      editorctl_wid._ListSymbolsInClass(lastid_prefix, match_class,
                                        p_window_id, TREE_ROOT_INDEX, 0,
                                        members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                        VS_TAGFILTER_ANYTHING, context_flags,
                                        false, true);
   }
   if (lastid_prefix != '') {
      editorctl_wid._ListSymbolsInClass('' /*lastid*/, match_class,
                                        p_window_id, TREE_ROOT_INDEX, 0,
                                        members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                        VS_TAGFILTER_ANYTHING, context_flags,
                                        false, false);
   }
   _TreeEndUpdate(TREE_ROOT_INDEX);
   members_lastid = lastid_prefix;
   members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;

   // Return 0 indicating success if anything was found
   if (members_count <= 0) {
      errorArgs[1] = (lastid == '')? match_class : lastid;
      return VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }
   return 0;
}

// Replace the current word (if any) with the selected context tag
// This extension-specific callback is responsible for:
//   - deleting the previous word (search_string)
//   - inserting the new word according to language rules
//   - arrange to start function help if appropriate
// Arguments:
//    editorctl_wid  -- window ID of current editor control
//    start_col      -- start colume of identifier to replace
//    search_string  -- identifier to replace
//    caption        -- selected context tag (caption as shown in dialog)
//    terminationKey -- key pressed to terminate list help
//    info_flags     -- context tagging flags (check followed by paren)
// Returns:
//    void
//
void _c_replace_context_tag(int relative_col,
                            _str search_string, _str caption,
                            _str terminationKey, int info_flags)
{
   //say("_c_replace_context_tag: "search_string","caption")");
   
   // does this caption have a parenthesis? (is it a function?)
   _str argument_char = '';
   if (pos('(', caption)) {
      caption = substr(caption, 1, pos('S')-1);
      typeless tag_files = tags_filenamea(p_extension);
      //if (_MatchSymbolAsTemplate(caption,template_sig)) {
      if (tag_check_for_template(caption, '', true, tag_files, template_sig)) {
         // a template class!
         argument_char = '<';
      } else {
         // just a plain old function
         argument_char = '(';
      }
   }

   // set up for doing the string replacement
   int start_col=p_col-relative_col;
   int replace_length = length(search_string);
   p_col=start_col;
   _str line;
   get_line(line);
   //say("*** _c_replace_context_tag: whole line="line);

   // was the old search string an operator (explicitly)
   boolean had_operator = false;
   if (search_string :== 'operator') {
      had_operator = true;
      _str end_line = substr(line, start_col);
      if (pos('^operator[~a-z]*\(', end_line, 1, 'r')) {
         replace_length = pos('')-1;
         info_flags |= VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN;
      }
   }

   // is the new caption an operator?
   //say("** replace_length="replace_length);
   boolean remove_dot = false;
   if (p_col > 0 && !had_operator && pos('operator ',caption)==1) {

      //say("**** replacing with an operator="caption);
      // check if there is a '.' just before the current word
      line = substr(line, 1, p_col-1);
      //say("_c_replace_context_tag: line="line);
      
      if (pos('[.][ \t]*$', line,1,'r')) {
         int num_chars_before = pos(''); 
         //say("NUM_CHARS="num_chars_before);
         p_col -= num_chars_before;

         // parse out the actual operator name
         _str op;
         parse caption with 'operator ' op;
         switch (op) {
         case '[]':  // subscript
            replace_length+=num_chars_before;
            argument_char='';
            caption = '[';
            remove_dot=true;
            break;
         case '': // function call (technically (), but blown away from before)
            replace_length+=num_chars_before;
            argument_char='(';
            caption = '';
            remove_dot=true;
            break;
         case '->':  // replace with actual operator
         case '++':
         case '--':
         case '~':
         case '!':
         case '+':
         case '*':
         case '&':
         case '->*':
         case '/':
         case '%':
         case '<<':
         case '>>':
         case '<':
         case '>':
         case '<=':
         case '>=':
         case '==':
         case '!=':
         case '^':
         case '|':
         case '&&':
         case '||':
         case '*=':
         case '/=':
         case '%=':
         case '+=':
         case '-=':
         case '<<=':
         case '>>=':
         case '|=':
         case '^=':
         case '=':
         case ',':
            replace_length+=num_chars_before;
            argument_char='';
            caption = op;
            remove_dot=true;
            break;
         case 'new':
         case 'delete':
         default:
            break;  // can't handle this case, no way.
         }
      }
   }
   if (!remove_dot) {
      p_col=start_col;
   }

   //say("replace_length="replace_length);
   // set up the start column and replace the current word
   if (replace_length > 0) {
      _delete_text(replace_length);
   }
   if (terminationKey:==' ' && (def_codehelp_flags & VSCODEHELPFLAG_SPACE_INSERTS_SPACE)) {
      caption=caption' ';
   }
   _insert_text(caption);

   // if we have an open paren, then insert open paren and go directly
   // into function help, unless name is already followed by a paren.
   // kind of language specific...
   if (argument_char!='' && terminationKey=="" && 
       !(info_flags&VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN) &&
       (def_codehelp_flags& VSCODEHELPFLAG_INSERT_OPEN_PAREN)
       ) {
      last_event(argument_char);
      auto_functionhelp_key();
   }
}

// Replace the current word (if any) with the selected context tag
// This extension-specific callback is responsible for:
//   - deleting the previous word (search_string)
//   - inserting the new word according to language rules
//   - arrange to start function help if appropriate
// Arguments:
//    editorctl_wid  -- window ID of current editor control
//    start_col      -- start colume of identifier to replace
//    search_string  -- identifier to replace
//    caption        -- selected context tag (caption as shown in dialog)
//    terminationKey -- key pressed to terminate list help
//    info_flags     -- context tagging flags (check followed by paren)
// Returns:
//    void
//
void _java_replace_context_tag(int relative_col,
                               _str search_string, _str caption,
                               _str terminationKey, int info_flags)
{
   //say("_java_replace_context_tag: "search_string","caption")");
   
   // does this caption have a parenthesis? (is it a function?)
   _str argument_char = '';
   if (pos('(', caption)) {
      caption = substr(caption, 1, pos('S')-1);
      argument_char = '(';
   } else if (pos('.',caption) && terminationKey=='.') {
      caption = substr(caption,1,pos('S')-1);
   }

   // set up the start column and replace the current word
   p_col=p_col-relative_col;
   int replace_length = length(search_string);
   if (replace_length > 0) {
      _delete_text(replace_length);
   }
   if (terminationKey:==' ' && (def_codehelp_flags & VSCODEHELPFLAG_SPACE_INSERTS_SPACE)) {
      caption=caption' ';
   }
   _insert_text(caption);

   // if we have an open paren, then insert open paren and go directly
   // into function help, unless name is already followed by a paren.
   // kind of language specific...
   if (argument_char!='' && terminationKey=="" && 
       !(info_flags&VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN) &&
       (def_codehelp_flags& VSCODEHELPFLAG_INSERT_OPEN_PAREN)
       ) {
      last_event(argument_char);
      auto_functionhelp_key();
   }
}

// Replace the current word (if any) with the selected context tag
// This extension-specific callback is responsible for:
//   - deleting the previous word (search_string)
//   - inserting the new word according to language rules
//   - arrange to start function help if appropriate
// Arguments:
//    editorctl_wid  -- window ID of current editor control
//    start_col      -- start colume of identifier to replace
//    search_string  -- identifier to replace
//    caption        -- selected context tag (caption as shown in dialog)
//    terminationKey -- key pressed to terminate list help
//    info_flags     -- context tagging flags (check followed by paren)
// Returns:
//    void
//
void _js_replace_context_tag(int relative_col,
                             _str search_string, _str caption,
                             _str terminationKey, int info_flags)
{
   //say("_js_replace_context_tag: "search_string","caption")");

   // does this caption have a parenthesis? (is it a function?)
   _str argument_char = '';
   if (pos('(', caption)) {
      caption = substr(caption, 1, pos('S')-1);
      argument_char = '(';
   }

   // set up for doing the string replacement
   int start_col=p_col-relative_col;
   int replace_length = length(search_string);
   p_col=start_col;
   _str line;
   get_line(line);

   // is the new caption an operator?
   //say("** replace_length="replace_length);
   boolean remove_dot = false;
   if (p_col > 0 && pos('operator ',caption)==1) {

      //say("**** replacing with an operator="caption);
      // check if there is a '.' just before the current word
      line = substr(line, 1, p_col-1);
      if (pos('[.][ \t]*$', line,1,'r')) {
         int num_chars_before = pos(''); 
         //say("NUM_CHARS="num_chars_before);
         p_col -= num_chars_before;

         // parse out the actual operator name
         _str op;
         parse caption with 'operator ' op;
         if (op == '[]') {
            replace_length+=num_chars_before;
            argument_char='';
            caption = '[';
            remove_dot=true;
         }
      }
   }
   if (!remove_dot) {
      p_col=start_col;
   }

   //say("replace_length="replace_length);
   // set up the start column and replace the current word
   if (replace_length > 0) {
      _delete_text(replace_length);
   }
   _insert_text(caption);

   // if we have an open paren, then insert open paren and go directly
   // into function help, unless name is already followed by a paren.
   // kind of language specific...
   if (argument_char!='' && terminationKey=="" && 
       !(info_flags&VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN)) {
      last_event(argument_char);
      auto_functionhelp_key();
   }
}

int _e_find_context_tags(_str (&errorArgs)[],_str prefixexp,
                         _str lastid,int lastidstart_offset,
                         int info_flags,typeless otherinfo,
                         boolean find_parents,int max_matches,
                         boolean exact_match,boolean case_sensitive)
{
   return(_c_find_context_tags(errorArgs,prefixexp,lastid,lastidstart_offset,info_flags,otherinfo,false,max_matches,exact_match,case_sensitive));
}
int _java_find_context_tags(_str (&errorArgs)[],_str prefixexp,
                            _str lastid,int lastidstart_offset,
                            int info_flags,typeless otherinfo,
                            boolean find_parents,int max_matches,
                            boolean exact_match, boolean case_sensitive)
{
   //say "_java_find_context_tags"
   errorArgs._makeempty();
   errorArgs[1] = lastid;
   typeless tag_files = tags_filenamea(p_extension);
   int num_matches=0;
   _str match_class='';
   if (prefixexp!='') {
      if (pos("^[$_a-zA-Z0-9.]@$", prefixexp, 1, 'r') &&
          //_MatchSymbolAsPackage(prefixexp:+lastid, true, true)) {
          tag_check_for_package(prefixexp:+lastid, tag_files, true, case_sensitive)) {
         match_class = '';
         lastid = prefixexp:+lastid;
      } else {
         _str dummy_tag = '';
         int c_return_flags = 0;
         int status = _c_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                            true, pointer_count,
                                            c_return_flags, dummy_tag);
         if (status) {
            return status;
         }
      }
   }

   // try to match the symbol in the current context
   tag_clear_matches();
   _MatchSymbolInContext(lastid, match_class,
                         num_matches, max_matches,
                         VS_TAGFILTER_ANYTHING, true, true, 
                         find_parents, true, exact_match, true);
   if (num_matches == 0 && !case_sensitive) {
      _MatchSymbolInContext(lastid, match_class,
                            num_matches, max_matches,
                            VS_TAGFILTER_ANYTHING, true, true, 
                            find_parents, true, exact_match, false);
   }

   // Return 0 indicating success if anything was found
   errorArgs[1] = lastid;
   return (num_matches == 0)? VSCODEHELPRC_NO_SYMBOLS_FOUND:0;
}
int _js_find_context_tags(_str (&errorArgs)[],_str prefixexp,
                          _str lastid,int lastidstart_offset,
                          int info_flags,typeless otherinfo,
                          boolean find_parents,int max_matches,
                          boolean exact_match,boolean case_sensitive)
{
   return(_java_find_context_tags(errorArgs,prefixexp,lastid,lastidstart_offset,info_flags,otherinfo,false,max_matches,exact_match,case_sensitive));
}
int _c_find_context_tags(_str (&errorArgs)[],_str prefixexp,
                         _str lastid,int lastidstart_offset,
                         int info_flags,typeless otherinfo,
                         boolean find_parents,int max_matches,
                         boolean exact_match,int case_sensitive)
{
   //say("_c_find_context_tags: max_matches="max_matches);
   errorArgs._makeempty();
   // check language mode
   boolean isjava=false;
   if (_modename_eq(p_mode_name,'Java')) {
      isjava=true;
   }
   boolean slickc=false;
   if ( _modename_eq(p_mode_name,"slick-c") ) {
      slickc=true;
   }

   //say "_c_find_context_tags"
   int num_matches=0;
   _str match_class='';
   _str dummy_tag='';
   int c_return_flags = 0;
   if (prefixexp!='') {
      int status = _c_get_type_of_prefix(errorArgs, prefixexp, match_class, isjava,
                                         pointer_count, c_return_flags, dummy_tag);
      //say("match_class="match_class" status="status);
      if (status) {
         return status;
      }
   }

   // try to match the symbol in the current context
   tag_clear_matches();
   _MatchSymbolInContext(lastid, match_class,
                         num_matches, max_matches,
                         VS_TAGFILTER_ANYTHING, true,
                         !(c_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY), 
                         find_parents, false, exact_match, true);
   // try case insensitive match
   if (num_matches == 0 && !case_sensitive) {
      _MatchSymbolInContext(lastid, match_class,
                            num_matches, max_matches,
                            VS_TAGFILTER_ANYTHING, true,
                            !(c_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY), 
                            find_parents, false, exact_match, false);
   }
   if (num_matches == 0 && !exact_match && (slickc || isjava)) {
      _MatchSymbolInContext(lastid, match_class,
                            num_matches, max_matches,
                            VS_TAGFILTER_ANYTHING, false,
                            !(c_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY), 
                            find_parents, false, exact_match, case_sensitive);
   }

   // Return 0 indicating success if anything was found
   errorArgs[1] = lastid;
   return (num_matches == 0)? VSCODEHELPRC_NO_SYMBOLS_FOUND:0;
}
int _e_fcthelp_get_start(_str (&errorArgs)[],
                         boolean OperatorTyped,
                         boolean cursorInsideArgumentList,
                         int &FunctionNameOffset,
                         int &ArgumentStartOffset,
                         int &flags
                         )
{
   return(_c_fcthelp_get_start(errorArgs,OperatorTyped,cursorInsideArgumentList,FunctionNameOffset,ArgumentStartOffset,flags));
}
int _java_fcthelp_get_start(_str (&errorArgs)[],
                            boolean OperatorTyped,
                            boolean cursorInsideArgumentList,
                            int &FunctionNameOffset,
                            int &ArgumentStartOffset,
                            int &flags
                           )
{
   return(_c_fcthelp_get_start(errorArgs,OperatorTyped,cursorInsideArgumentList,FunctionNameOffset,ArgumentStartOffset,flags));
}
int _js_fcthelp_get_start(_str (&errorArgs)[],
                          boolean OperatorTyped,
                          boolean cursorInsideArgumentList,
                          int &FunctionNameOffset,
                          int &ArgumentStartOffset,
                          int &flags
                         )
{
   return(_c_fcthelp_get_start(errorArgs,OperatorTyped,cursorInsideArgumentList,FunctionNameOffset,ArgumentStartOffset,flags));
}
static boolean _skip_template_prefix_word()
{
   return(gtk==TK_ID &&
           (gtkinfo:=='const' ||
            gtkinfo:=='static' ||
            gtkinfo:=='volatile' ||
            gtkinfo:=='typedef' ||
            gtkinfo:=='virtual' ||
            gtkinfo:=='new' ||
            gtkinfo:=='inline' ||
            gtkinfo:=='register' ||
            gtkinfo:=='friend' ||
            gtkinfo:=='extern' ||
            gtkinfo:=='public' ||
            gtkinfo:=='private' ||
            gtkinfo:=='protected' ||
            gtkinfo:=='mutable' ||
            gtkinfo:=='explicit'
           )
          );

}
static boolean _probablyTemplateArgList(int &FunctionNameStartOffset)
{
   if (!_modename_eq(p_mode_name,"c")) {
      return(false);
   }
   /*
      Check if we are in a template argument list
      [::][id::]id<  dsf<
   */
   begin_col=c_begin_stat_col(false /* No RestorePos */,
                              false /* Don't skip first begin statement marker */,
                              false /* Don't return first non-blank */);
   if (!begin_col) {
      return(0);
   }
   FunctionNameStartOffset=(int)point('s');
   c_next_sym();
   for (;;) {
      if (!_skip_template_prefix_word()) {
         break;
      }
      _clex_skip_blanks();
      FunctionNameStartOffset=(int)point('s');
      c_next_sym();
   }
   if (gtk=='::') {
      gtk=c_next_sym();
   }
   for (;;) {
      if (gtk!=TK_ID) {
         return(0);
      }
      gtk=c_next_sym();
      if (gtk!='::') {
         break;
      }
      gtk=c_next_sym();
   }
   if (gtk!='<') {
      return(0);
   }
   /*
      Assume we are actually inside a template argument list.
      Let _c_get_idexp and _c_fcthelp_get do the rest of the
      work.
   */
   return(1);
}
/*
   PARAMETERS
      OperatorTyped     When true, user has just typed last character of operator.
                        Example
                             p-><Cursor Here>
                        This should be false if cursorInsideArgumentList
                        is true.
      cursorInsideArgumentList
                        When true, user requested function help when
                        the cursor was inside an argument list.

                        Example
                          MessageBox(...,<Cursor Here>...)

                        Here we give help on MessageBox
      FunctionNameOffset  OUTPUT. Offset to start of function name.

      ArgumentStartOffset OUTPUT. Offset to start of first argument

  RETURN CODES
      0    Successful
      VSCODEHELPRC_CONTEXT_NOT_VALID
      VSCODEHELPRC_NOT_IN_ARGUMENT_LIST
      VSCODEHELPRC_NO_HELP_FOR_FUNCTION
*/
int _c_fcthelp_get_start(_str (&errorArgs)[],
                         boolean OperatorTyped,
                         boolean cursorInsideArgumentList,
                         int &FunctionNameOffset,
                         int &ArgumentStartOffset,
                         int &flags
                         )
{
   errorArgs._makeempty();
   boolean isjava=false;
   boolean slickc=false;
   boolean iscpp=false;
   boolean isrul=false;
   _str not_function_words=C_NOT_FUNCTION_WORDS;
   switch (lowcase(p_mode_name)) {
   case 'java':
      isjava=true;
      not_function_words=JAVA_NOT_FUNCTION_WORDS;
      break;
   case 'slick-c':
      slickc=true;
      break;
   case 'c':
      iscpp=1;
      break;
   case 'installscript':
      isrul=true;
      not_function_words=RUL_NOT_FUNCTION_WORDS;
      break;
   }
   //say("_c_fcthelp_get_start");
   flags=0;
   //if (cursorInsideArgumentList || OperatorTyped)
   save_pos(orig_pos);
   orig_seek=point('s');
   int first_less_than_seek=0;
   {
      if (OperatorTyped && last_event()=='<') {
         first_less_than_seek=orig_seek-1;
         flags|=VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST;
      } else {
         if (iscpp &&
             !ginFunctionHelp && cursorInsideArgumentList) {
            status=search('[;}{()<]','-r@xcs');
            if (!status) {
               ch=get_text();
               if (ch=='<') {
                  first_less_than_seek=(int)point('s');
                  left();
                  if (get_text()!='<') { // Have << or < at beginning of line
                     _clex_skip_blanks('-');
                     status=_c_get_idexp(junk,false,junk_prefixexp,junk_lastid,junk_lastidstart_col,junk_lastidstart_offset,junk_info_flags,junk_otherinfo);
                     if (!status) {
                        flags|=VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST;
                     }
                  }
               }
            }
            restore_pos(orig_pos);
         }

      }
#if 0
      ch=get_text();
      if (ch==')' ||
          (OperatorTyped && (ch=='(' || ch==';' || ch=='{'))) {
         if(p_col==1){up();_end_line();} else {left();}
      }
#endif
      orig_col=p_col;orig_line=p_line;
      if (flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST) {
         // Just look for beginning of statement
         status=search('[;}{]','-r@xcs');
      } else {
         status=search('[;}{()]','-r@xcs');
      }
      if (!status && p_line==orig_line && p_col==orig_col) {
         status=repeat_search();
      }
      ArgumentStartOffset= -1;
      for (;;) {
         if (status) {
            if (flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST) {
               c_begin_stat_col(false,0,false);
            }
            //say('break '_nrseek());
            break;
         }
         ch=get_text();
         //say("CCH="ch);
         if (ch=='(') {
            save_pos(p);
            if(p_col==1){up();_end_line();} else {left();}
            save_search(p1,p2,p3,p4);
            _clex_skip_blanks('-');
            restore_search(p1,p2,p3,p4);
            ch=get_text();
            word=cur_word(junk);
            restore_pos(p);
            if (pos('['p_word_chars']',ch,1,'r')) {
               if (pos(' 'word' ',not_function_words)) {
                  if (OperatorTyped && ArgumentStartOffset== -1) {
                     return(VSCODEHELPRC_CONTEXT_NOT_VALID);
                  }
                  break;
               }
               ArgumentStartOffset=(int)point('s')+1;
            } else {
               /*
                  OperatorTyped==TRUE
                      Avoid give help when have
                      myproc(....4+( <CursorHere>

               */
               if (OperatorTyped && ArgumentStartOffset== -1 &&
                   ch!=')' &&   // (*pfn)(a,b,c)  OR  f(x)(a,b,c)
                   ch!=']'      // calltab[a](a,b,c)
                  ){
                  return(VSCODEHELPRC_CONTEXT_NOT_VALID);
               }
               if (ch==')' || ch==']') {
                  ArgumentStartOffset=(int)point('s')+1;
               }
            }
         } else if (ch==')') {
            status=find_matching_paren();
            if (status) {
               restore_pos(orig_pos);
               return(1);
            }
            save_pos(p);
            if(p_col==1){up();_end_line();} else {left();}
            save_search(p1,p2,p3,p4);
            _clex_skip_blanks('-');
            restore_search(p1,p2,p3,p4);
            word=cur_word(junk);
            if (pos(' 'word' ',' if while catch switch ')) {
               break;
            }
            restore_pos(p);
         } else  {
            break;
         }
         status=repeat_search();
      }
      if (ArgumentStartOffset<0) {
         if (!(flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST)) {
            return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
         }
      } else {
         goto_point(ArgumentStartOffset);
      }
   }
   if (flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST) {
      status=search('<','r@xcs');
#if 1
      while (!status) {
         if (point('s')>=first_less_than_seek) {
            break;
         }
         typeless localp;
         save_pos(localp);
         if (p_col==1) {
            up();_end_line();
         } else {
            left();
         }
         c_prev_sym();
         restore_pos(localp);
         if(gtk!=TK_ID || gtkinfo!='template') {
            break;
         }
         right();
         status=search('<','r@xcs');
      }
#else
      if (!status) {
         typeless localp;
         save_pos(localp);
         if (p_col==1) {
            up();_end_line();
         } else {
            left();
         }
         c_prev_sym();
         if(gtk==TK_ID && gtkinfo=='template') {
            restore_pos(localp);right();
            status=search('<','r@xcs');
         } else {
            restore_pos(localp);
         }
      }
#endif
      right();
   }
   ArgumentStartOffset=(int)point('s');
   left();
   if (get_text()=='<' && !isjava && !slickc && !isrul) {
      save_pos(p2);
      status=_probablyTemplateArgList(junk);
      restore_pos(p2);
      if (status) {
         flags|=VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST;
      } else {
         if (!(flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST)) {
            return(1);
         }
      }
   } else {
      if (flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST) {
         return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
      }
   }
   left();
   search('[~ \t]|^','-r@');
   if (pos('[~'p_word_chars']',get_text(),1,'r')) {
      ch=get_text();
      if (!(flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST) &&
          (ch==')' || ch==']')) {
         FunctionNameOffset=ArgumentStartOffset-1;
         return(0);
      } else {
         return(VSCODEHELPRC_CONTEXT_NOT_VALID);
      }
   } else {
      end_col=p_col+1;
      search('[~'p_word_chars']\c|^\c','-r@');
      cfg=_clex_find(0,'g');    //x(*a.b)
      lastid=_expand_tabsc(p_col,end_col-p_col);
      FunctionNameOffset=(int)point('s');
   }
   /*if (cursorInsideArgumentList) {
      restore_pos(orig_pos);
   } */
   if (pos(' 'lastid' ',not_function_words)) {
      return(VSCODEHELPRC_CONTEXT_NOT_VALID);
   }
   return(0);
}
static boolean _e_match_procs(_str match_symbol)
{
   index= find_index(match_symbol,PROC_TYPE|COMMAND_TYPE);
   if (!index || !index_callable(index)) {
      return false;
   }

   int module_index = index_callable(index);
   _str module_name = name_name(module_index);
   _str proc_name   = name_name(index);
   if (module_name == '') {
      return false;
   }

   proc_name= translate(proc_name,'_','-');
   ext=get_extension(module_name);
   if (! file_eq('.'ext,_macro_ext)) {
      module_name= substr(module_name,1,length(module_name)-length(ext)-1):+_macro_ext;
   }
   filename= slick_path_search(module_name);
   if ( filename=='' ) {
     return false;
   }

   // search for the proc
   int line_no = 0;
   inmem=1;
   status=_open_temp_view(filename,temp_view_id,orig_view_id,'+b');
   if (status) {
      inmem=0;
      status=_open_temp_view(filename,temp_view_id,orig_view_id);
      if (!status) select_edit_mode();
   }
   if (status) {
      return false;
   }
   //say("search_proc="proc_name);
   status=e_proc_search(proc_name,1)
   if (inmem) {
      p_buf_flags&=~HIDE_BUFFER;
      _quit_view();
      p_view_id=orig_view_id;
   }else{
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
   }

   if (!status) {
      int tag_flags = 0;
      _str signature = '';
      _str return_type = '';
      int line_no = p_RLine;
      //say("proc_name="proc_name);
      tag_tree_decompose_tag(proc_name, tag_name, class_name, type_name, tag_flags, signature, return_type);
      tag_insert_match('',tag_name, type_name, filename, line_no, class_name, tag_flags, return_type :+ VS_TAGSEPARATOR_args :+ signature);
      return true;
   }
   return false;
}
int _e_fcthelp_get(_str (&errorArgs)[],
                      VSAUTOCODE_ARG_INFO (&FunctionHelp_list)[],
                      boolean &FunctionHelp_list_changed,
                      int &FunctionHelp_cursor_x,
                      _str &FunctionHelp_HelpWord,
                      int FunctionNameStartOffset,
                      int flags
                      )
{
   return(_c_fcthelp_get(errorArgs,
                         FunctionHelp_list,FunctionHelp_list_changed,
                         FunctionHelp_cursor_x,
                         FunctionHelp_HelpWord,
                         FunctionNameStartOffset,flags));
}
int _java_fcthelp_get(_str (&errorArgs)[],
                      VSAUTOCODE_ARG_INFO (&FunctionHelp_list)[],
                      boolean &FunctionHelp_list_changed,
                      int &FunctionHelp_cursor_x,
                      _str &FunctionHelp_HelpWord,
                      int FunctionNameStartOffset,
                      int flags
                      )
{
   return(_c_fcthelp_get(errorArgs,
                         FunctionHelp_list,FunctionHelp_list_changed,
                         FunctionHelp_cursor_x,
                         FunctionHelp_HelpWord,
                         FunctionNameStartOffset,flags));
}
int _js_fcthelp_get(  _str (&errorArgs)[],
                      VSAUTOCODE_ARG_INFO (&FunctionHelp_list)[],
                      boolean &FunctionHelp_list_changed,
                      int &FunctionHelp_cursor_x,
                      _str &FunctionHelp_HelpWord,
                      int FunctionNameStartOffset,
                      int flags
                      )
{
   return(_c_fcthelp_get(errorArgs,
                         FunctionHelp_list,FunctionHelp_list_changed,
                         FunctionHelp_cursor_x,
                         FunctionHelp_HelpWord,
                         FunctionNameStartOffset,flags));
}
/*
   PARAMETERS
      FunctionHelp_list    (Input/Ouput)
                           Structure is initially empty.
                              FunctionHelp_list._isempty()==true
                           You may set argument lengths to 0.
                           See VSAUTOCODE_ARG_INFO structure in slick.sh.
      FunctionHelp_list_changed   (Output) Indicates whether the data in
                                  FunctionHelp_list has been changed.
                                  Also indicates whether current
                                  parameter being edited has changed.
      FunctionHelp_cursor_x  (Output) Indicates the cursor x
                             position in pixels relative to the
                             edit window where to display the
                             argument help.

      FunctionNameStartOffset,ArgumentEndOffset
                              (INPUT) The text between these two
                              end points needs to be parsed
                              to determine the new argument
                              help.
   RETURN
     Returns 0 if we want to continue with function argument
     help.  Otherwise a non-zero value is returned and a
     message is usually displayed.

   REMARKS
     If there is no help for the first function, a non-zero value
     is returned and message is usually displayed.

     If the end of the statement is found, a non-zero value is
     returned.  This happens when a user to the closing brace
     to the outer most function caller or does some weird
     paste of statements.

     If there is no help for a function and it is not the first
     function, FunctionHelp_list is filled in with a message
         FunctionHelp_list._makeempty();
         FunctionHelp_list[0].proctype=message;
         FunctionHelp_list[0].argstart[0]=1;
         FunctionHelp_list[0].arglength[0]=0;

  RETURN CODES
     1   Not a valid context
     (not implemented yet)
     10   Context expression too complex
     11   No help found for current function
     12   Unable to evaluate context expression
*/
static _str gLastContext_FunctionName;
static int gLastContext_FunctionOffset;
int _c_fcthelp_get(_str (&errorArgs)[],
                   VSAUTOCODE_ARG_INFO (&FunctionHelp_list)[],
                   boolean &FunctionHelp_list_changed,
                   int &FunctionHelp_cursor_x,
                   _str &FunctionHelp_HelpWord,
                   int FunctionNameStartOffset,
                   int flags
                   )
{
   errorArgs._makeempty();
   //say("_c_fcthelp_get");
   // avoid recalculating the expression when we don't have to
   static _str prev_prefixexp;
   static _str prev_otherinfo;
   static int  prev_info_flags;
   static int  prev_ParamNum;

   // check language mode
   _str common=C_COMMON_END_OF_STATEMENT_RE;
   boolean isjava=false;
   boolean slickc=false;
   boolean javascript=false;
   boolean isrul=false;
   if (_modename_eq(p_mode_name,'Java')) {
      isjava=true;
      common='[,#{};()]|'common'|'JAVA_MORE_END_OF_STATEMENT_RE;
   } else if ( _modename_eq(p_mode_name,"slick-c")) {
      slickc=true;
      common='[,#{};()]|'common'|'C_MORE_END_OF_STATEMENT_RE;
   } else if ( _modename_eq(p_mode_name,"JavaScript")) {
      javascript=true;
      common='[,{};()[]|'common'|'JAVA_MORE_END_OF_STATEMENT_RE;
   } else if ( _modename_eq(p_mode_name,"InstallScript")) {
      isrul=true;
      common='[,;()[]|'common'|'RUL_MORE_END_OF_STATEMENT_RE;
   } else {
      if (flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST) {
         // for now, we don't try to handle parens in template argument lists
         common='[,#{};<>]|'common'|'C_MORE_END_OF_STATEMENT_RE;
      } else {
         common='[,#{};()]|'common'|'C_MORE_END_OF_STATEMENT_RE;
      }
   }

   FunctionHelp_list_changed=0;
   if(FunctionHelp_list._isempty()) {
      FunctionHelp_list_changed=1;
      gLastContext_FunctionName="";
      gLastContext_FunctionOffset=-1;
   }

   cursor_offset=point('s');
   save_pos(p);
   orig_left_edge=p_left_edge;
   goto_point(FunctionNameStartOffset);
   // enum, struct class
   status=search(common,'r@xcs');
   //boolean found_function_pointer=false;
   int preprocessing_top=0;
   int preprocessing_ParamNum_stack[];
   int preprocessing_offset_stack[];
   int ParamNum_stack[];
   int offset_stack[];  // offset of this function open parenthesis
   int stack_top=0;
   ParamNum_stack[stack_top]=0;
   nesting=0;
   for (;;) {
      if (status) {
         break;
      }
      ch=get_text();
      //say('ch='ch);
      //say('cursor_offset='cursor_offset' p='point('s'));
      if (cursor_offset<=point('s')) {
         break;
      }
      if (ch==',') {
         ++ParamNum_stack[stack_top];
         status=repeat_search();
         continue;
      }
      if (ch==')') {
         --stack_top;
         if (stack_top<=0 /*&& (!found_function_pointer && stack_top<0)*/) {
            // The close paren has been entered for the outer most function
            // We are done.
            restore_pos(p);
            return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
         }
         //found_function_pointer = false;
         status=repeat_search();
         continue;
      }
      if (ch=='>') {
         --stack_top;
         if (stack_top<=0) {
            // The close paren has been entered for the outer most function
            // We are done.
            restore_pos(p);
            return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
         }
         status=repeat_search();
         continue;
      }
      if (ch=='(') {
         // Determine if this is a new function
         ++stack_top;
         ParamNum_stack[stack_top]=1;
         offset_stack[stack_top]=(int)point('s');
         /*if (get_text(2)=='(*') {
            found_function_pointer = true;
         } */
         status=repeat_search();
         continue;
      }
      if (ch=='[') {
         status=find_matching_paren();
         if (status) {
            restore_pos(p);
            return(VSCODEHELPRC_BRACKETS_MISMATCH);
         }
         status=repeat_search();
         continue;
      }
      if (ch=='<') {
         // Determine if this is a new function
         ++stack_top;
         ParamNum_stack[stack_top]=1;
         offset_stack[stack_top]=(int)point('s');
         status=repeat_search();
         continue;
      }
      if (ch=='}' || ch==';') {
         restore_pos(p);
         return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
      }
      if (ch=='#' || ch=='{' || (pos('[~'p_word_chars']',get_text(1,match_length('s')-1),1,'r') &&
                                 pos('[~'p_word_chars']',get_text(1,match_length('s')+match_length()),1,'r'))
          ) {
         // IF this could be enum, struct, or class
         if (stack_top>1 && (ch=='e' || ch=='s' || ch=='c')) {
            word=cur_word(junk);
            if (word=='enum' || word=='struct' || word=='class' || word=='typedef') {
               status=repeat_search();
               continue;
            }
         }
         // IF we need to check for conditional preprocessing
         if (/*!isjava &&*/ !javascript && ch=='#' && stack_top>0) {
            right();
            word=cur_word(junk);
            if (word=='if' || word=='ifdef' || word=='ifndef') {
               // IF we are in conditional preprocessing.
               ++preprocessing_top;
               preprocessing_ParamNum_stack[preprocessing_top]=ParamNum_stack[stack_top];
               preprocessing_offset_stack[preprocessing_top]=offset_stack[stack_top];
               status=repeat_search();
               continue;
            } else if (word=='elif' || word=='else') {
               if (preprocessing_top && stack_top>0 &&
                   preprocessing_offset_stack[preprocessing_top]==offset_stack[stack_top]
                   ) {
                  ParamNum_stack[stack_top]=preprocessing_ParamNum_stack[preprocessing_top];
                  status=repeat_search();
                  continue;
               }

            } else if (word=='endif') {
               if (preprocessing_top) {
                  --preprocessing_top;
               }
               status=repeat_search();
               continue;
            } else if (word!='define' && word!='undef' && word!='include' &&
                       word!='pragma' && word!='error') {
               status=repeat_search();
               continue;
            }
         }
         restore_pos(p);
         return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
      }
      status=repeat_search();
   }
   if (flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST_TEST) {
      restore_pos(p);
      return(0);
   }
   typeless tag_files = tags_filenamea(p_extension);
   lastid="";
   for (;;--stack_top) {
      if (stack_top<=0) {
         restore_pos(p);
         return(VSCODEHELPRC_NO_HELP_FOR_FUNCTION);
      }
      goto_point(offset_stack[stack_top]+1);
      if (flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST) {
         // Don't allow any failures
         while (stack_top>1) {
            offset_stack._deleteel(1);ParamNum_stack._deleteel(1);
            --stack_top;
         }
         left();left();
         if (p_extension=="pl") {
            status=_pl_get_idexp(junk,false,prefixexp,lastid,lastidstart_col,lastidstart_offset,info_flags,otherinfo);
         } else {
            status=_c_get_idexp(junk,false,prefixexp,lastid,lastidstart_col,lastidstart_offset,info_flags,otherinfo);
         }
         info_flags|=VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST;
      } else {
         if (p_extension=="pl") {
            status=_pl_get_idexp(junk,true,prefixexp,lastid,lastidstart_col,lastidstart_offset,info_flags,otherinfo);
         } else {
            status=_c_get_idexp(junk,true,prefixexp,lastid,lastidstart_col,lastidstart_offset,info_flags,otherinfo);
         }
      }
      errorArgs[1] = lastid;

      if (_chdebug) {
         say('prefixexp='prefixexp' lastid='lastid' lastidstart_col='lastidstart_col' info_flags='dec2hex(info_flags)' otherinfo='otherinfo' status='status);
      }
      if (!status) {
         // get parameter number and cursor position
         ParamNum=ParamNum_stack[stack_top];
         set_scroll_pos(orig_left_edge,p_col);

         // check if anything has changed
         if (prev_prefixexp :== prefixexp &&
            gLastContext_FunctionName :== lastid &&
            gLastContext_FunctionOffset :== lastidstart_col &&
            prev_otherinfo :== otherinfo &&
            prev_info_flags == info_flags &&
            prev_ParamNum   == ParamNum) {
            FunctionHelp_cursor_x=(lastidstart_col-p_col)*p_font_width+p_cursor_x;
            break;
         }

         // find matching symbols
         //say('lastid='lastid' prefixexp='prefixexp' ParamNum='ParamNum' otherinfo='otherinfo);
         int tag_flags=0;
         boolean globals_only=false;
         _str signature='';
         _str return_type='';
         _str match_list[];
         _str match_symbol = lastid;
         _str match_class="";
         _str match_tag = "";
         int  match_flags = VS_TAGFILTER_ANYPROC;
         if (!isjava && !javascript && !isrul) {
            if (!slickc && (info_flags & VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST)) {
               match_flags = VS_TAGFILTER_STRUCT;
            }
            match_flags |= VS_TAGFILTER_DEFINE;
            no_of_matches = tag_check_for_define(lastid, p_line, tag_files, match_symbol);
            //say("tag_check_for_define, lastid="lastid" match_symbol="match_symbol"matches="no_of_matches);
         }

         // find symbols matching the given class
         int num_matches = 0;
         tag_clear_matches();
         // this may be a variable MYCLASS a(
         if (info_flags & VSAUTOCODEINFO_VAR_OR_PROTOTYPE_DECL) {
            otherinfo    = stranslate(otherinfo,':','::');
            parse otherinfo with otherinfo '<' . ;
            tag_split_class_name(otherinfo, match_symbol, match_class);
            cmatch_class = tag_join_class_name(match_symbol, match_class, tag_files, true);
            //say("111 match_symbol="match_symbol" match_class="cmatch_class);
            tag_clear_matches();
            _ListSymbolsInClass(match_symbol, cmatch_class, 0, 0, 0,
                                num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                VS_TAGFILTER_ANYPROC,
                                VS_TAGCONTEXT_ANYTHING|VS_TAGCONTEXT_ALLOW_locals|VS_TAGCONTEXT_ONLY_inclass,
                                true, true);
            if (num_matches <= 0) {
               match_symbol = lastid;
            }
         }

         // initializer list of constructor MYCLASS::MYCLASS() : BASECLASS(<here>
         if (info_flags & (VSAUTOCODEINFO_IN_INITIALIZER_LIST|VSAUTOCODEINFO_MAYBE_IN_INITIALIZER_LIST)) {
            otherinfo    = stranslate(otherinfo,':','::');
            tag_split_class_name(otherinfo,junk,match_class);
            if (match_class == '') {
               match_class = otherinfo;
            }
            match_symbol = lastid;
            //say("match_symbol="match_symbol" match_class="match_class);
            tag_clear_matches();
            _ListSymbolsInClass(match_symbol, match_class, 0, 0, 0,
                                num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                VS_TAGFILTER_ANYPROC/*|VS_TAGFILTER_ANYSTRUCT*/,
                                VS_TAGCONTEXT_ANYTHING|VS_TAGCONTEXT_ALLOW_locals|VS_TAGCONTEXT_ONLY_inclass,
                                true, true);
            //say("num_matches="num_matches" here 2");
         }

         // analyse prefix epxression to determine effective class
         if (num_matches == 0) {
            //say("xxx prefixexp="prefixexp" match_symbol="match_symbol);
            //if (prefixexp=='new') {
            //   say("_c_fcthelp_get: new");
            //   prefixexp='';
            //}
            if (pos('new ',prefixexp) == 1) {
               // handle 'new' expressions as a special case
               _str outer_class = substr(prefixexp, 5);
               if (last_char(outer_class)==':') {
                  outer_class = substr(outer_class, 1, length(outer_class)-2);
               }
               if (last_char(outer_class)=='.') {
                  outer_class = substr(outer_class, 1, length(outer_class)-1);
               }
               outer_class = stranslate(outer_class, ':', '::');
               //say("match_symbol="match_symbol" outer_class="outer_class);
               if (outer_class=='') {
                  match_class = _QualifySymbolName(match_symbol, '', p_buf_name, true);
               } else {
                  match_class = tag_join_class_name(match_symbol, outer_class, tag_files, true);
               }
               //say("match_class = "match_class);
               pointer_count = 1;
               status = 0;
            } else if (prefixexp != '') {
               int pointer_count=0;
               int c_return_flags=0;
               status = _c_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                              isjava||javascript, pointer_count,
                                              c_return_flags, match_tag);
               //say("_c_get_type_of_prefix returns "match_class" status="status" match_tag="match_tag);
               if (status && (slickc || javascript)) {
                  // oh, well, we tried...
                  status = 0;
               }
               if (status && (status!=VSCODEHELPRC_BUILTIN_TYPE || lastid!='')) {
                  restore_pos(p);
                  return status;
               }
               if (c_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY) {
                  globals_only = true;
               }
            }
            tag_clear_matches();
            // try to find 'lastid' as a member of the 'match_class'
            // within the current context
            if (lastid != '') {
               _MatchSymbolInContext(match_symbol, match_class,
                                     num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                     match_flags, true, !globals_only, 
                                     false, false, true, true);
               if (num_matches==0 && lastid!=match_symbol) {
                  match_symbol=lastid;
                  _MatchSymbolInContext(match_symbol, match_class,
                                        num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                        match_flags, true, !globals_only, 
                                        false, false, true, true);
               }
            }
            // try variables, maybe there's a function pointer out there
            if (lastid != '' && !isjava && !javascript && num_matches == 0) {
               //say("_c_fcthelp_get: 1, symbol="match_symbol" class="match_class);
               // try to find 'lastid' as a data member which may be a function
               // pointer in 'match_class', using shorthand call notation
               tag_clear_matches();
               _MatchSymbolInContext(match_symbol, match_class,
                                     num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                     VS_TAGFILTER_ANYDATA, true,
                                     !globals_only, false, false, true, true);
               int m;
               for (m=1; m<=num_matches; m++) {
                  tag_get_detail2(VS_TAGDETAIL_match_return,m,tr);
                  if (pos('(',tr)) {
                     break;
                  }
               }
               if (m > num_matches && !slickc) {
                  // Maybe this is a call to operator (), function call,
                  // for some class instance?
                  //say("_c_fcthelp_get: maybe function call operator");
                  _str template_args:[];template_args._makeempty();
                  int pointer_count=0;
                  int c_return_flags=0;
                  boolean istemplate=false;
                  status = _c_get_return_type_of(errorArgs,tag_files,
                                                 match_symbol,match_class,
                                                 0,isjava||javascript||isrul,
                                                 VS_TAGFILTER_ANYDATA,false,
                                                 match_type, pointer_count,
                                                 template_args, istemplate,
                                                 c_return_flags, match_tag);
                  if (!status && match_type!='') {
                     // OK, 'lastid' is a class instance, try to find operator ()
                     num_matches = 0;
                     tag_clear_matches();
                     //say("_c_fcthelp_get: 5, match_type="match_type);
                     _MatchSymbolInContext('()', match_type,
                                           num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                           VS_TAGFILTER_ANYPROC, true, !globals_only, 
                                           false, false, true, true);
                  }
               }
            }
            if (lastid == '' && match_tag != '') {
               _str tr='', ts='';
               tag_tree_decompose_tag(match_tag, tn,tc,tt,tf,ts,tr);
               tag_clear_matches();
               tag_insert_match('',tn,tt,'',0,tc,tf,tr:+VS_TAGSEPARATOR_args:+ts);
               num_matches = 1;
               //say("tn="tn" tc="tc" tt="tt" tf="tf" ts="ts);
               if (match_class!='' && !pos('(',tr)) {
                  int pointer_count=0;
                  _str template_args:[];
                  template_args._makeempty();
                  boolean istemplate=false;
                  int c_return_flags=0;
                  status = _c_get_return_type_of(errorArgs,tag_files,'()',match_class,
                                                 0,false,VS_TAGFILTER_ANYPROC,
                                                 false,match_class,pointer_count,
                                                 template_args,istemplate,
                                                 c_return_flags, match_tag);
                  if (!status) {
                     tag_tree_decompose_tag(match_tag, tn,tc,tt,tf,ts,tr);
                     tag_clear_matches();
                     tag_insert_match('',tn,tt,'',0,tc,tf,tr:+VS_TAGSEPARATOR_args:+ts);
                  }
               }
            }
            if (slickc && num_matches == 0 && _e_match_procs(match_symbol)) {
               // probably don't need to do this anymore
               //say("_c_fcthelp_get: 2");
               num_matches = 1;
            }
            if ((slickc || javascript) && num_matches == 0) {
               // fallback case for slick-C, ignore prefix expression
               //say("trying again, flags="match_flags);
               //say("_c_fcthelp_get: 3");
               tag_clear_matches();
               _MatchSymbolInContext(match_symbol, '',
                                     num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                     match_flags, true, !globals_only, 
                                     false, false, true, true);
            }
            if ((slickc || javascript) && num_matches == 0) {
               // double-fallback for slick-C and Javascript, ignoring prefix
               // expression and class scoping completely
               tag_clear_matches();
               tag_list_any_symbols(0, 0, match_symbol, tag_files,
                                    VS_TAGFILTER_ANYPROC, VS_TAGCONTEXT_ONLY_non_static,
                                    num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                    true, true);
            }
            //if (match_symbol == '') {
               // this could be a function pointer call, last_id is empty string
               //say("***** NOW WHAT!!! *****");
            //}
         } else {
            lastid = match_symbol;
         }

         //say("_c_fcthelp_get: num_matches="tag_get_num_of_matches());

         // check if the symbol was on the kill list for this extension
         if (_check_killfcts(match_symbol, match_class, flags)) {
            continue;
         }

         // remove duplicates from the list of matches
         int unique_indexes[]; unique_indexes._makeempty();
         if (!isrul) {
            removeDuplicateFunctions(unique_indexes);
         } else {
            for (i=0; i<tag_get_num_of_matches(); i++) {
               unique_indexes[i]=i+1;
            }
         }

         int num_unique = unique_indexes._length();
         for (i=0; i<num_unique; i++) {
            j = unique_indexes[i];
            tag_get_match(j,tag_file,proc_name,type_name,
                          file_name,line_no,class_name,tag_flags,
                          signature,return_type);
            // maybe kick out if already have match or more matches to check
            if (match_list._length()>0 || i+1<num_unique) {
               if (file_eq(file_name,p_buf_name) && line_no:==p_line) {
                  continue;
               }
               if (tag_tree_type_is_class(type_name)) {
                  continue;
               }
               if (signature=='' && (tag_flags & VS_TAGFLAG_extern)) {
                  continue;
               }
               if (type_name :== 'define') {
                  if (signature == '') {
                     continue;
                  }
               }
            }
            if (tag_flags & VS_TAGFLAG_operator) {
               proc_name = "operator "proc_name;
            }
            if (class_name != '') {
               if (javascript || isjava || slickc) {
                  proc_name = class_name '.' proc_name;
               } else {
                  proc_name = class_name '::' proc_name;
               }
            }
            if (tag_tree_type_is_func(type_name)) {
               if (signature == 'void' && !isjava && !javascript && !isrul) {
                  signature = '';
               }
            } else if (type_name :== 'define') {
               return_type = '#define';
            }
            if (!isrul) {
               type_name='proc';
            }
            match_list[match_list._length()] = proc_name "\t" type_name "\t" signature "\t" return_type;
            //say("match_list[i] = "match_list[match_list._length()-1]);
         }

         // get rid of any duplicate entries
         match_list._sort();
         _aremove_duplicates(match_list, false);
         if (isrul) {
            _rul_merge_and_remove_duplicates(match_list);
         }

         // get comments for this function
         _str function_comments=''
         if (0 && (def_codehelp_flags & VSCODEHELPFLAG_DISPLAY_FUNCTION_COMMENTS) && match_list._length()>=1) {
            _ExtractTagComments2(0,refer_ext(lowcase(get_extension(file_name))),
                                 function_comments, 10, proc_name, file_name, line_no);
            translate_html(function_comments);
            if (pos("\n\n",function_comments)) {
               function_comments = substr(function_comments, 1, pos('S')-1);
            }
            if (pos("\n@",function_comments)) {
               function_comments = substr(function_comments, 1, pos('S')-1);
            }
         }

         // translate functions into struct needed by function help
         boolean have_matching_params = false;
         if (match_list._length()>0) {
            FunctionHelp_list._makeempty();
            FunctionHelp_HelpWord = match_symbol;

            //say("FunctionHelp_cursor_x="FunctionHelp_cursor_x" lastid="lastid);
            for (i=0; i<match_list._length(); i++) {
               k = FunctionHelp_list._length();
               if (k >= VSCODEHELP_MAXFUNCTIONHELPPROTOS) break;
               parse match_list[i] with match_tag_name "\t" match_type_name "\t" signature "\t" return_type;
               //say("tag="match_tag_name" sig="signature" ret="return_type);
               if (substr(signature, 1, 1) == '<' && !slickc && !isjava && !javascript) {
                  signature = substr(signature, 2);
                  FunctionHelp_list[k].prototype = return_type' 'match_tag_name'<'signature'>';
               } else {
                  FunctionHelp_list[k].prototype = return_type' 'match_tag_name'('signature')';
               }
               if (function_comments != '' && i==match_list._length()-1) {
                  strappend(FunctionHelp_list[k].prototype, "\n\n"function_comments);
               }
               int base_length = length(return_type) + length(match_tag_name) + 2;
               FunctionHelp_list[k].argstart[0]=length(return_type)+1;
               FunctionHelp_list[k].arglength[0]=length(match_tag_name);
               FunctionHelp_list[k].ParamNum=ParamNum;
               FunctionHelp_list[k].ParamType='';
               //++base_length;

               // parse signature and map out argument ranges
               int  arg_pos  = 0;
               _str argument = cb_next_arg(signature, arg_pos, 1);
               while (argument != '') {
                  //say("argument="argument);
                  j = FunctionHelp_list[k].argstart._length();
                  FunctionHelp_list[k].argstart[j]=base_length+arg_pos;
                  FunctionHelp_list[k].arglength[j]=length(argument);
                  if (j == ParamNum) {
                     // parse out the return type of the current parameter
                     _str psextn = p_extension;
                     int psindex = find_index(psextn'_proc_search',PROC_TYPE);
                     int orig_view_id=_create_temp_view(temp_view_id);
                     _insert_text(argument';');
                     top();
                     if (index_callable(psindex)) {
                        pvarname='';
                        status=call_index(pvarname,1,psextn,psindex);
                        if (!status) {
                           ds=param_type='';
                           tag_tree_decompose_tag(pvarname,dt,dc,dy,tf,ds,param_type);
                           FunctionHelp_list[k].ParamType=param_type;
                        }
                     }
                     _delete_temp_view(temp_view_id);
                     p_view_id = orig_view_id;
                  }
                  argument = cb_next_arg(signature, arg_pos, 0);
               }
               if (ParamNum != 1 && j < ParamNum) {
                  if (have_matching_params) {
                     FunctionHelp_list._deleteel(k);
                  }
               } else {
                  if (!have_matching_params) {
                     VSAUTOCODE_ARG_INFO func_arg_info = FunctionHelp_list[k];
                     FunctionHelp_list._makeempty();
                     FunctionHelp_list[0] = func_arg_info;
                  }
                  have_matching_params = true;
               }
            }
            // Found some matches?
            if (FunctionHelp_list._length() > 0) {
               if (prev_ParamNum!=ParamNum) {
                  FunctionHelp_list_changed=1;
               }
               prev_prefixexp  = prefixexp;
               prev_otherinfo  = otherinfo;
               prev_info_flags = info_flags;
               prev_ParamNum   = ParamNum;
               FunctionHelp_cursor_x=(lastidstart_col-p_col)*p_font_width+p_cursor_x;
               break;
            }
         }
      }
   }
   if (lastid!=gLastContext_FunctionName || gLastContext_FunctionOffset!=lastidstart_offset) {
      FunctionHelp_list_changed=1;
      gLastContext_FunctionName=lastid;
      gLastContext_FunctionOffset=lastidstart_offset;
   }
   restore_pos(p);
   return(0);
}


static _str strip_names(_str filename,int count)
{
   while (count-->0) {
      if (last_char(filename)==FILESEP) {
         filename=substr(filename,1,length(filename)-1);
      }
      filename=strip_filename(filename,'N');
   }
   return(filename);
}
#if !__UNIX__
int def_vtg_tornado=1;
int def_vtg_prismplus=1;
int _c_MaybeBuildTagFile(int &tfindex)
{
   AddTornadoTagFile();
   AddPrismPlusTagFile();
   tfindex=0;
   return(0);
}
static int AddPrismPlusTagFile()
{
   if (substr(machine(),1,2):!='NT' || !def_vtg_prismplus) {
      return(1);
   }
   path=_ntGetRegistryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Integrated Systems, Inc.\\pRISM+","PPC","ISI_PRISM_DIR",1);
   if (path=="") {
      path=_ntGetRegistryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Integrated Systems, Inc.\\pRISM+","MIPS","ISI_PRISM_DIR",1);
      if (path=="") {
         path=_ntGetRegistryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Integrated Systems, Inc.\\pRISM+","x86","ISI_PRISM_DIR",1);
         if (path=="") {
         }
      }
   }
   if (path=="") {
      return(1);
   }
   if (last_char(path)!=FILESEP) {
      path=path:+FILESEP;
   }


   ext='c';
   tfindex=find_index('def-tagfiles-'ext,MISC_TYPE);
   // IF the user does not have an extension specific tag file for Slick-C
   status=0;
   name_part='prismp.vtg';
   tagfilename=absolute(_config_path():+name_part);
   //say('name_info='name_info(tfindex));
   if (!tfindex || !pos(name_part,name_info(tfindex),1,_fpos_case) ||
       tag_read_db(tagfilename)==FILE_NOT_FOUND_RC) {
      tag_close_db(tagfilename);
      slickc_filename=path_search('maketags'_macro_ext,'VSLICKMACROS');
      if (slickc_filename=="") {
         slickc_filename=path_search('maketags'_macro_ext'x','VSLICKMACROS');
      }
      if (slickc_filename!='') {
         //status=shell('maketags -n "Tornado Run-Times" -t -o 'maybe_quote_filename(tagfilename)' 'maybe_quote_filename(path:+'*.c')' 'maybe_quote_filename(path:+'*.h'));
         status=shell('maketags -n "pRISM+ Run-Times" -t -o 'maybe_quote_filename(tagfilename)' 'maybe_quote_filename(path:+'*.h'));
         set_exttagfiles("c "tagfilename,true);
         _config_modify|=CFGMODIFY_DEFDATA;
         /*if (!tfindex) {
            tfindex=insert_name('def-tagfiles-'ext,MISC_TYPE,_encode_vsroot(tagfilename,true,false));
         } else {
            set_name_info(tfindex,_encode_vsroot(tagfilename,true,false));
         }
         _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
         _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
         */
      } else {
         status=1;
      }
   }
   return(status);
}
static int AddTornadoTagFile()
{
   if (substr(machine(),1,2):!='NT' || !def_vtg_tornado) {
      return(1);
   }
   command=_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\TornadoSourceType\\shell\\open\\command","");
   if (command=="") {
      return(1);
   }
   // command has --> H:\Tornado\host\X86-WI~1\bin\tornado.exe "%1"
   command=parse_file(command);
   path=strip_names(command,4);

   ext='c';
   tfindex=find_index('def-tagfiles-'ext,MISC_TYPE);
   // IF the user does not have an extension specific tag file for Slick-C
   status=0;
   name_part='tornado.vtg';
   tagfilename=absolute(_config_path():+name_part);
   //say('name_info='name_info(tfindex));
   if (!tfindex || !pos(name_part,name_info(tfindex),1,_fpos_case) ||
       tag_read_db(tagfilename)==FILE_NOT_FOUND_RC) {
      tag_close_db(tagfilename);
      slickc_filename=path_search('maketags'_macro_ext,'VSLICKMACROS');
      if (slickc_filename=="") {
         slickc_filename=path_search('maketags'_macro_ext'x','VSLICKMACROS');
      }
      if (slickc_filename!='') {
         //status=shell('maketags -n "Tornado Run-Times" -t -o 'maybe_quote_filename(tagfilename)' 'maybe_quote_filename(path:+'*.c')' 'maybe_quote_filename(path:+'*.h'));
         status=shell('maketags -n "Tornado Run-Times" -t -o 'maybe_quote_filename(tagfilename)' 'maybe_quote_filename(path:+'*.h'));
         set_exttagfiles("c "tagfilename,true);
         _config_modify|=CFGMODIFY_DEFDATA;
         /*if (!tfindex) {
            tfindex=insert_name('def-tagfiles-'ext,MISC_TYPE,_encode_vsroot(tagfilename,true,false));
         } else {
            set_name_info(tfindex,_encode_vsroot(tagfilename,true,false));
         }
         _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
         _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
         */
      } else {
         status=1;
      }
   }
   return(status);
}
#endif

