#include "slick.sh"

vsjava_format(_str,int,_str,int,int,_str,int);
vsc_format(_str,int,_str,int,int,_str,int);
vsslickc_format(_str,int,_str,int,int,_str,int);

struct scheme_s {
   int options:[];
};

#define CFDEBUG_WINDOW   0
#define CFDEBUG_FILE     0

#define CFDEBUGFLAG_WINDOW 0x1000
#define CFDEBUGFLAG_FILE   0x2000

#define CFFLAG_REMEMBER_SEEKPOS 0x8000

#define CF_INI_FILENAME      "format.ini"
#define CF_USER_INI_FILENAME "uformat.ini"

#define CF_DEFAULT_SCHEME_NAME "Default"
#define CF_NONE_SCHEME_NAME    "(None)"

static _str _cf_ini_filename;
static _str _cf_user_ini_filename;

// Used by c_beautify()
static int _options:[];

// Used by form
static int  _form_options:[];
static int  _orig_form_options:[];   // Save this for the Reset button
static _str _form_ext;
static _str _orig_ext;
static scheme_s _schemes:[];         // Read-only schemes
static scheme_s _user_schemes:[];    // User schemes
static _str _cur_scheme;             // Last scheme used
static _str _orig_scheme;            // Save this for the Reset button

static int _suspend_modify;
#define CHANGING_SCHEMES _ctl_scheme_save.p_user

#define CFCOMMENT_STATE_SPECIFIC 0
#define CFCOMMENT_STATE_ABSOLUTE 1
#define CFCOMMENT_STATE_RELATIVE 2

#define CFPADCONDITION_STATE_INSERT   0
#define CFPADCONDITION_STATE_REMOVE   1
#define CFPADCONDITION_STATE_NOCHANGE 2

//static int _mycheck_tabs(int :[]);
//static int _get_scheme(scheme_s (&):[],_str);
//static int _format(int :[],_str,_str,_str,_str,int,_str);

/*
int _OnUpdate_gui_beautify(CMDUI &cmdui,int target_wid,_str command)
{
   if (target_wid && target_wid._isEditorCtl() &&
       p_ReadOnly
       ) {
      return(MF_GRAYED);
   }
   return(MF_ENABLED);
}
*/
_command gui_beautify() name_info(','VSARG2_EDITORCTL)
{
   if( !_isEditorCtl() ) {
      ext=show('-modal _beautify_extension_form');
      if( ext=='' ) {
         // User cancelled
         return('');
      }
      orig_ext=ext;
      index=find_index("_"ext"_beautify_form",oi2type(OI_FORM));
      if( !index ) {
         if( _beautify_check_support(ext) ) {
            _message_box("Can't find form: ":+"_"ext"_beautify_form");
            return('');
         }
         // Double check the new extension
         index=find_index("_"ext"_beautify_form",oi2type(OI_FORM));
         if( !index ) {
            _message_box("Can't find form: ":+"_"ext"_beautify_form");
            return('');
         }
      }
      show("-modal "index,ext,orig_ext);
      return('');
   }
   _exit_scroll();
   ext=p_extension;
   orig_ext=ext;
   index=find_index("_"ext"_beautify_form",oi2type(OI_FORM));
   if( !index ) {
      if( _beautify_check_support(ext) ) {
         ext=show('-modal _beautify_extension_form');
         if( ext=='' ) {
            // User cancelled
            return('');
         }
         /* User has specified that they want this buffer treated as if it
          * had this extension.
          */
         orig_ext=ext;
      }
      
      // Double check the new extension
      if( _beautify_check_support(ext) ) {
         _message_box("Can't find form: ":+"_"ext"_beautify_form","Error",MB_OK|MB_ICONEXCLAMATION);
         return('');
      }
      index=find_index("_"ext"_beautify_form",oi2type(OI_FORM));
      if( !index ) {
         _message_box("Can't find form: ":+"_"ext"_beautify_form");
         return('');
      }
      
      show("-modal "index,ext,orig_ext);
      return('');
   }
   // Need to pass in ext and orig_ext because this could be an editor control
   show("-modal "index,ext,orig_ext);
}

/* Return value=2 means there was an error beautifying and calling function should
 * get the error message with vscf_iserror()
 */
_command int c_format,c_beautify(...) name_info(','VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   struct scheme_s s:[];
   s._makeempty();

   if( p_Nofhidden ) {
      show_all();
   }

   use_form_options= (arg(3)!='');

   old_modify=p_modify;   // Save in the case of doing the entire buffer so we can set it back when we "undo"
   old_left_edge=p_left_edge;
   old_cursor_y=p_cursor_y;
   save_pos(p);

   infilename='';
   outfilename='';
   inview_id= (isinteger(arg(1)))?(arg(1)):(0);
   editorctl_wid=p_window_id;
   if (!_isEditorCtl()) {
      editorctl_wid=0;
   }

   // Do the current buffer
   if( !use_form_options ) {
      if( !_isEditorCtl() ) {
         _message_box('No buffer!');
         return(1);
      }
      ext=p_extension;
      orig_ext=ext;
      if( _beautify_check_support(ext) ) {
         _message_box('Beautifying not supported for this extension');
         return(1);
      }

      if( _init_ini_files() ) return(1);

      // Sync with extension options?
      status=_ini_get_value(_cf_user_ini_filename,'common','sync_ext_options',sync_ext_options,'1')
      if( status ) sync_ext_options=true;
      
      // Get [<ext>-scheme-Default] section and put into s
      writedefaultoptions=_get_user_scheme(s,'Default',orig_ext);
      status=_init_options(s:[CF_DEFAULT_SCHEME_NAME].options,sync_ext_options,orig_ext);
      if( status ) {
         _message_box('Error setting options');
         return(1);
      }
      if( writedefaultoptions ) {
         /* If we are here, then (for some reason) there were no default options
          * in the user scheme file, so write the default options
          */
         status=_write_scheme(s:[CF_DEFAULT_SCHEME_NAME].options,sync_ext_options,orig_ext:+'-scheme-':+CF_DEFAULT_SCHEME_NAME);
         if( status ) {
            _message_box('Failed to write default options to ':+CF_USER_INI_FILENAME);
            return(1);
         }
      }
   } else {
      ext=_form_ext;
      orig_ext=_orig_ext;   // The correct DLL function will not get called unless we set this properly
      s:[CF_DEFAULT_SCHEME_NAME].options=_options;
   }

   if( _mycheck_tabs(editorctl_wid,s:[CF_DEFAULT_SCHEME_NAME].options) ) return(1);

   // Switch to temp view
   orig_view_id=p_view_id;
   if( inview_id ) {
      p_view_id=inview_id;
   }

   // Make a temp file to use as the input source file
   infilename=mktemp();
   if( infilename=='' ) {
      _message_box('Error creating temp file');
      return(1);
   }
   status=_save_file('+o ':+infilename);   // This is the source file
   if( status ) {
      _message_box('Error creating temp file "':+infilename'".  ':+get_message(status));
      return(1);
   }
   start_linenum=p_line;
   //messageNwait('start_linenum='start_linenum);
   bottom();
   last_line_was_bare=(_line_length()==_line_length(1));
   #if 1
   // Create a temporary view for beautifier output *with* p_undo_steps=0
   arg2='+td';   // DOS \r\n linebreak
   if( length(p_newline)==1 ) {
      if( substr(p_newline,1,1)=='\r' ) {
         arg2='+tm';   // Macintosh \r linebreak
      } else {
         arg2='+tu';   // UNIX \n linebreak
      }
   }
   status=_create_temp_view(output_view_id,arg2);
   if( status=='' ) {
      _message_box('Error creating temp view');
      return(1);
   }
   _delete_line();
   #else
   insert_line('');
   insertion_linenum=p_line;
   _delete_text(-2);   // Get rid of any newline chars on the line
   #endif

   start_indent=arg(2);
   if( !isinteger(start_indent) || start_indent<0 ) {
      start_indent=0;
   }

   mou_hour_glass(1);
   status=_format(s:[CF_DEFAULT_SCHEME_NAME].options,
                  orig_ext,
                  infilename,
                  0,   // Input view id
                  outfilename,
                  start_indent,
                  start_linenum);
   mou_hour_glass(0);

   // Cleanup temp files that were created
   delete_file(infilename);   // Delete the temp file
   if( !vscf_QLineLength() ) {
      // Get rid of the zero-length line at the bottom
      _delete_line();
   }

   msg=vscf_iserror();
   if( msg!='' ) {
      #if 1
      _delete_temp_view(output_view_id);
      if( inview_id ) {
         p_view_id=inview_id;   // Do this instead of orig_view_id so we can set the error line number correctly
      } else {
         p_view_id=orig_view_id;
      }
      #else
      // Get rid of the text we just inserted
      p_line=insertion_linenum;
      p_col=1;
      _delete_text(-2);
      _delete_line();   // Get rid of the truly empty line
      if( last_line_was_bare ) {
         // The last line of the file had no newline at the end, so fix it
         _end_line();
         _delete_text(-2);
      }
      p_modify=old_modify;
      restore_pos(p);

      // Switch back to original view
      if( inview_id ) {
         p_view_id=orig_view_id;
      }
      #endif

      // Show the message and position at the error
      if( isinteger(msg) ) {
         // Got one of the *_RC constants in rc.sh
         msg=get_message(msg);
      } else {
         parse msg with linenum ':' .;
         if( isinteger(linenum) ) {   // Just in case
            p_line=linenum;
         }
      }
      if( inview_id ) {
         #if 1
         /* Don't show the error yet.  Let c_beautify_selection() do that, otherwise
          * the linenumber it displays will be completely wrong
          */
         p_view_id=inview_id;
         return(2);
         #else
         // We were beautifying a temp view, so switch back to original view so things don't look funky
         p_view_id=orig_view_id;
         _message_box(msg);
         p_view_id=inview_id;
         #endif
      } else {
         _message_box(msg);
      }
      return(2);
   } else {
      #if 1
      // Everything is good, so clear the temp view and put the beautiful stuff in
      mark=_alloc_selection();
      if( mark<0 ) {
         _message_box(get_message(mark));
         _delete_temp_view(output_view_id);
         p_view_id=orig_view_id;
         return(1);
      }
      if( inview_id ) {
         p_view_id=inview_id;
      } else {
         p_view_id=orig_view_id;
      }
      _lbclear();   // _lbclear() does a _delete_selection(), so don't have to worry about a lot of undo steps
      p_view_id=output_view_id;
      top();
      _select_line(mark);
      bottom();
      _select_line(mark);
      if( inview_id ) {
         p_view_id=inview_id;
      } else {
         p_view_id=orig_view_id;
      }
      _copy_to_cursor(mark);
      _free_selection(mark);
      bottom();
      if( last_line_was_bare ) {
         // The last line of the file had no newline at the end, so fix it
         _end_line();
         _delete_text(-2);
      }
      #if 1
      adjusted_linenum=vscf_adjusted_linenum();
      //messageNwait('adjusted_linenum='adjusted_linenum);
      p_line= (adjusted_linenum)?(adjusted_linenum):(1);   // Don't allow line 0
      _begin_line();
      set_scroll_pos(old_left_edge,old_cursor_y);
      #else
      bottom();   /* HERE - replace this line with code to put cursor at adjusted position */
      #endif
      _delete_temp_view(output_view_id);
      #else
      // Everything is good, so get rid of the old text above
      top();
      mark=_alloc_selection();
      if( mark<0 ) {
         // Last ditch attempt to put things back the way they were
         _undo();
         _message_box(get_message(mark));
         return(1);
      }
      _select_line(mark);
      p_line=insertion_linenum-1;
      _select_line(mark);
      _delete_selection(mark);
      bottom();   /* HERE - replace this line with code to put cursor at adjusted position */
      #endif
   }

   // Switch back to original view
   if( inview_id ) {
      //p_view_id=orig_view_id;
   }

   return(0);
}

static int _format(int  p:[],
                   _str ext,
                   _str infilename,
                   _str inview_id,
                   _str outfilename,
                   int  start_indent,
                   int  start_linenum)
{
   flags=_merge_flags(p);

   debugfilename="";
   vse_flags=0;
   if( CFDEBUG_WINDOW || CFDEBUG_FILE ) {
      if( CFDEBUG_WINDOW ) {
         vse_flags|=CFDEBUGFLAG_WINDOW;
      }
      if( CFDEBUG_FILE ) {
         vse_flags|=CFDEBUGFLAG_FILE;
      }
   }

   if( ext=="java" ) {
      status=vsjava_format(infilename,
                           (int)inview_id,
                           outfilename,
                           start_indent,
                           start_linenum,
                           flags,
                           vse_flags
                           );
   } else if( ext=="e" ) {
      status=vsslickc_format(infilename,
                             (int)inview_id,
                             outfilename,
                             start_indent,
                             start_linenum,
                             flags,
                             vse_flags
                             );
   } else {
      status=vsc_format(infilename,
                        (int)inview_id,
                        outfilename,
                        start_indent,
                        start_linenum,
                        flags,
                        vse_flags
                        );
   }

   return(0);
}

static int _find_begin_context(mark,var sl,var el)
{
   old_sl=sl;
   old_el=el;

   _begin_select(mark);
   _begin_line();   // Goto to beginning of line so not fooled by start of comment

   /* If we are in the middle of a multi-line comment,
    * then skip to beginning of it
    */
   if( _in_comment(1) ) {
      if( p_line==1 ) {   // SHOULD NEVER GET HERE
         // There is no way we will find the beginning of this comment
         _message_box("Cannot find beginning of context:\r\r":+
                      "  Cannot find beginning of comment at line 1");
         sl=0;
         el=0;
         return(1)
      }
      up();
      while( p_line && _clex_find(0,'G')==CFG_COMMENT ) {
         up();
      }
      if( _clex_find(0,'G')==CFG_COMMENT ) {
         // We are at the top of file
         _message_box("Cannot find beginning of context:\r\r":+
                      "  Cannot find beginning of comment at line 1");
         sl=0;
         el=0;
         return(1);
      }
      _end_line();
      // Check to see if we are ON the multiline comment
      if( _clex_find(0,'G')!=CFG_COMMENT ) {
         down();   // Move back onto the first line of the comment
      }
   } else {
      /* If we are in the middle of multi-line preprocessing,
       * then skip to beginning of it
       */

      // Get the whole thing started with some fake values
      prev_lastch='\';
      while( prev_lastch=='\' ) {
         if( !up() ) {
            if( p_line ) {
               get_line(prev_line);
               if( prev_line=='' ) {
                  // Blank line, we're done
                  prev_lastch='';
                  continue;
               }
               prev_line=strip(prev_line,'B');
               prev_lastch=substr(prev_line,length(prev_line),1);
               continue;
            } else {
               // At top of file, so start at line 1
               sl=1;

               // Reset the selection
               _deselect(mark);
               p_line=sl;
               _select_line(mark);
               p_line=el;
               _select_line(mark);

               p_line=sl;

               return(0);
            }
         } else {
            // At top of file, so start at line 1
            sl=1;

            // Reset the selection
            _deselect(mark);
            p_line=sl;
            _select_line(mark);
            p_line=el;
            _select_line(mark);

            p_line=sl;

            return(0);
         }
      }
      down();   // Move down by 1 to correct for the last call to up()
   }
   sl=p_line;
   if( sl!=old_sl ) {
      // Reset the selection
      _deselect(mark);
      p_line=sl;
      _select_line(mark);
      p_line=el;
      _select_line(mark);
   }

   old_mark=_duplicate_selection('');
   _end_select(mark);
   _end_line();
   _show_selection(mark);
   status=search('^[ \t]@\#[ \t]@(endif|else|elif)','@rm-');
   _show_selection(old_mark);
   if( !status ) {
      // Found a #endif/#else/#elif, so match with the correct #if
      pp_line=p_line;
      if( pp_line<2 ) {
         // We cannot possibly find the matching #if
         _message_box("Cannot find beginning of context:\r\r":+
                      "  Cannot find matching #if at line ":+pp_line);
         sl=0;
         el=0;
         return(1);
      }
      up();
      _end_line();
      _show_selection(mark);
      status=search('^[ \t]@\#[ \t]@{#0(endif|if|ifdef|ifndef)}','@r-');
      nesting=0;
      while( !status ) {
         word=get_text(match_length('0'),match_length('S0'));
         if( word!='endif' /*&& !nesting*/ ) {
            if( !nesting ) break;   // Found it
            --nesting;
         } else {
            ++nesting;
         }
         status=repeat_search();
      }
      _show_selection(old_mark);
      if( status ) {
         // We never found the matching #if, so bail
         sl=0;
         el=0;
         _message_box("Cannot find beginning of context:\r\r":+
                      "  Cannot find matching #if at line ":+pp_line);
         return(1);
      }

      // If we got here, then that means we found the matching #if/#ifdef/#ifndef
      if( p_line<sl ) {
         /* The #if/#ifdef/#ifndef is outside the selection,
          * so move up to it.  Don't extend the selection since
          * this is only context and we don't want to actually
          * beautify it
          */
      } else {
         _begin_select(mark);
      }
   } else {
      _begin_select(mark);
   }

   //_begin_select(mark);
   status=0;
   // Determine if we can even call prev_proc()
   //ext=refer_ext(_file_case(get_extension(p_buf_name)),p_buf_name);
   ext=p_extension;
   idx=find_index(ext'-proc-search',PROC_TYPE);
   if( !index_callable(idx) ) {
      status=1;
   }
   while( !status ) {
      status=prev_proc(1);
      if( p_line>sl ) {
         // We are still inside the selection, need to go further up
         continue;
      }
      break;
   }
   if( status ) top();

   return(0);
}

static int _find_end_context(mark,var sl,var el)
{
   old_sl=sl;
   old_el=el;

   _end_select(mark);
   _end_line();   // Goto end of line so not fooled by start of comment

   /* If we are in the middle of a multi-line comment,
    * then skip to end of it
    */
   if( _in_comment(1) ) {
      if( down() ) {   // SHOULD NEVER GET HERE
         // There is no way that this multi-line comment has an end
         _message_box("Cannot find end of context:\r\r":+
                      "  Cannot find end of comment at line ":+p_line);
         sl=0;
         el=0;
         return(1);
      }
      _begin_line();
      while( _clex_find(0,'G')==CFG_COMMENT ) {
         if( down() ) break;   // Comment might extend to bottom of file
         _begin_line();
      }
      if( _clex_find(0,'G')==CFG_COMMENT ) {
         // We are at the bottom of file
         _message_box("Cannot find end of context:\r\r":+
                      "  Cannot find end of comment at line ":+p_line);
         sl=0;
         el=0;
         return(1);
      }
      up();   // Move back onto the last line of the comment
   } else {
      /* If we are in the middle of multi-line preprocessing,
       * then skip to end of it
       */

      lastch='';
      get_line(line);
      if( line!='' ) {
          line=strip(line,'B');
          //firstch=substr(line,1,1);
          lastch=substr(line,length(line),1);
      }
      while( lastch=='\' ) {
         if( !down() ) {
            get_line(line);
            if( line=='' ) {
               // Blank line, we're done
               lastch='';
               continue;
            }
            line=strip(line,'B');
            //firstch=substr(line,1,1);
            lastch=substr(line,length(line),1);
         } else {
            // At bottom of file
            el=p_line;

            // Reset the selection
            _deselect(mark);
            p_line=sl;
            _select_line(mark);
            p_line=el;
            _select_line(mark);

            return(0);
         }
      }
   }
   el=p_line;
   if( el!=old_el ) {
      // Reset the selection
      _deselect(mark);
      p_line=sl;
      _select_line(mark);
      p_line=el;
      _select_line(mark);
   }

   #if 0   // Don't care about dangling #elif/#else/#endif
   old_mark=_duplicate_selection('');
   _end_select(mark);
   _end_line();
   _show_selection(mark);
   status=search('^[ \t]@\#[ \t]@(endif|else|elif)','@rm-');
   _show_selection(old_mark);
   if( !status ) {
      // Found a #endif/#else/#elif, so match with the correct #if
      pp_line=p_line;
      if( pp_line<2 ) {
         // We cannot possibly find the matching #if
         sl=0;
         el=0;
         return(1);
      }
      up();
      _end_line();
      _show_selection(mark);
      status=search('^[ \t]@\#[ \t]@{#0(endif|if|ifdef|ifndef)}','@r-');
      nesting=0;
      while( !status ) {
         word=get_text(match_length('0'),match_length('S0'));
         if( word!='endif' && !nesting ) {
            if( !nesting ) {
               // Found it
               break;
            }
            --nesting;
         }
         ++nesting;
         status=repeat_search();
      }
      _show_selection(old_mark);
      if( status ) {
         // We never found the matching #if, so bail
         #if 1
         sl=0;
         el=0;
         _message_box("Cannot find beginning of context:\r\r":+
                      "  Cannot find matching #if at line ":+pp_line);
         return(1);
         #else
         // We never found the matching #if, so don't beautify
         el=pp_line-1;
         if( el!=old_el ) {
            // Reset the selection
            _deselect(mark);
            p_line=sl;
            _select_line(mark);
            p_line=el;
            _select_line(mark);
         }
         #endif
      }

      // If we got here, then that means we found the matching #if/#ifdef/#ifndef
      if( p_line<sl ) {
         // The #if/#ifdef/#ifndef is outside the selection, so include it in the selection
         sl=p_line;

         // Reset the selection
         _deselect(mark);
         p_line=sl;
         _select_line(mark);
         p_line=el;
         _select_line(mark);
      }
   }
   #endif

   //_end_select(mark);
   #if 0
   status=0;
   // Determine if we can even call next_proc()
   ext=p_extension;
   idx=find_index(ext'-proc-search',PROC_TYPE);
   if( !index_callable(idx) ) {
      status=1;
   }
   while( !status ) {
      status=next_proc(1);
      if( p_line<el ) {
         // We are still inside the selection, need to go further down
         continue;
      }
      break;
   }
   if( status ) bottom();
   #endif

   return(0);
}

static int _create_context_view(var temp_view_id,
                                var context_mark,
                                var soc_linenum,   // StartOfContext line number
                                var last_line_was_bare)
{
   last_line_was_bare=0;
   save_pos(p);
   old_linenum=p_line;
   orig_mark=_duplicate_selection('');
   context_mark=_duplicate_selection();
   mark=_alloc_selection();
   if( mark<0 ) {
      _free_selection(context_mark);
      return(mark);
   }
   stype=_select_type();
   if( stype!='LINE' ) {
      // Change the duplicated selection into a LINE selection
      if( stype=='CHAR' ) {
         _get_selinfo(start_col,end_col,dummy);
         if( end_col==1 ) {
            // Throw out the last line of the selection
            _deselect(context_mark);
            _begin_select();
            startmark_linenum=p_line;
            _select_line(context_mark);
            _end_select();
            // Check to be sure it's not a case of a character-selection of 1 char on the same line
            if( p_line!=startmark_linenum ) {
               up();
            }
            _select_line(context_mark);
         } else {
            _select_type(context_mark,'T','LINE');
         }
      } else {
         _select_type(context_mark,'T','LINE');
      }
   }

   // Define the line boundaries of the selection
   _begin_select(context_mark);
   sl=p_line;   // start line
   _end_select(context_mark);
   el=p_line;   // end line
   orig_sl=sl;
   orig_el=el;

   // Find the top context
   if( _find_begin_context(context_mark,sl,el) ) {
      if( !sl || !el ) {
         /* Probably in the middle of a comment/preprocessing that
          * extended to the bottom of file, so could do nothing
          */
         _free_selection(context_mark);
         _free_selection(mark);
         restore_pos(p);
         return(1);
      }
      top();
   }
   tl=p_line;   // Top line
   //soc_linenum=tl;
   soc_linenum=sl;
   diff=old_linenum-tl;
   _select_line(mark);
   _begin_select(context_mark);
   first_non_blank();
   start_indent=p_col-1;

   // Find the bottom context
   if( _find_end_context(context_mark,sl,el) ) {
      if( !sl || !el ) {
         _free_selection(context_mark);
         _free_selection(mark);
         restore_pos(p);
         return(1);
      }
      bottom();
   }
   _select_line(mark);
   _end_select(context_mark);

   // Check to see if last line was bare of newline
   last_line_was_bare= (_line_length()==_line_length(1));

   //messageNwait('orig_sl='orig_sl'  orig_el='orig_el'  tl='tl'  sl='sl'  el='el);

   // Create a temporary view to hold the code selection and move it there
   arg2='+td';   // DOS \r\n linebreak
   if( length(p_newline)==1 ) {
      if( substr(p_newline,1,1)=='\r' ) {
         arg2='+tm';   // Macintosh \r linebreak
      } else {
         arg2='+tu';   // UNIX \n linebreak
      }
   }
   orig_view_id=_create_temp_view(temp_view_id,arg2);
   if( orig_view_id=='' ) return(1);
   _copy_to_cursor(mark);
   _free_selection(mark);       // Can free this because it was never shown
   top();up();
   insert_line('/* CFORMAT-SUSPEND-WRITE */');
   down();
   p_line=sl-tl+1;   // +1 to compensate for the previously inserted line at the top
   insert_line('/* CFORMAT-RESUME-WRITE */');
   p_line=el-tl+1+2;   // +2 to compensate for the 2 previously inserted lines
   insert_line('/* CFORMAT-SUSPEND-WRITE */');
   top();
   p_line=p_line+diff+2;   // +2 to adjust for the CFORMAT-SUSPEND-WRITE and CFORMAT-RESUME-WRITE above
   //messageNwait('p_line='p_line'  diff='diff);
   #if 0   // DEBUG
   _save_file('+o temp.out');
   #endif
   p_view_id=orig_view_id;

   return(0);
}

static void _delete_context_selection(context_mark)
{
   /* If we were on the last line, then beautified text will get inserted too
    * early in the buffer
    */
   _end_select();
   last_line_was_empty=0;
   if( down() ) {
      last_line_was_empty=1;   // We are on the last line of the file
   } else {
      up();
   }

   _begin_select(context_mark);
   _begin_line();

   // Now delete the originally selected lines
   _delete_selection(context_mark);
   _free_selection(context_mark);   // Can free this because it was never shown
   if( !last_line_was_empty ) up();

   #if 0
   /* If we were on the last line, then beautified text will get inserted too
    * early in the buffer
    */
   if( do_empty ) {
      // Stick an EMPTY (yes, truly empty) line at the end of the buffer
      insert_line('');
      _delete_text(-2);   // Delete to end of buffer (this will get the newline)
   }
   #endif

   return;
}

_command int c_format_selection,c_beautify_selection(...) name_info(','VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   if( !select_active() ) {
      return(c_format());
   }

   save_pos(p);
   orig_view_id=p_view_id;
   old_left_edge=p_left_edge;
   old_cursor_y=p_cursor_y;

   _begin_select();
   tom_linenum=p_line;
   restore_pos(p);

   // Find the context
   if( _create_context_view(temp_view_id,context_mark,soc_linenum,last_line_was_bare) ) {
      _message_box('Failed to derive context for selection');
      return(1);
   }

   #if 1
   start_indent=0;
   #endif
   restore_pos(p);   // Do this before calling c_format() so don't end up somewhere funky
   status=c_format(temp_view_id,start_indent,arg(1));
   if( !status ) {
      p_view_id=orig_view_id;
      old_mark=_duplicate_selection('');
      mark=_alloc_selection();
      if( mark<0 ) {
         _delete_temp_view(temp_view_id);
         _message_box(get_message(mark));
         return(mark);
      }

      /* Delete the selection and position cursor so we are sure
       * we start inserting beautified text at the correct place
       */
      _delete_context_selection(context_mark);

      // Get the beautified text from the temp view
      p_view_id=temp_view_id;
      new_linenum=p_line;
      top();
      _select_line(mark);
      bottom();
      _select_line(mark);
      p_view_id=orig_view_id;
      _copy_to_cursor(mark);
      _end_select(mark);
      _free_selection(mark);
      #if 1
      // Check to see if we need to strip off the last newline
      if( last_line_was_bare ) {
         _end_line();
         _delete_text(-2);
      }
      #endif
      /* -2 to correct for the
       * CFORMAT-SUSPEND-WRITE and CFORMAT-RESUME-WRITE directives
       * in the temp view.
       */
      //messageNwait('new_linenum='new_linenum'  soc_linenum='soc_linenum);
      //new_linenum=new_linenum+soc_linenum-1-2;
      //new_linenum=new_linenum+tom_linenum-1-2;
      //new_linenum=new_linenum+tom_linenum-1;
      new_linenum=new_linenum+soc_linenum-1;
      p_line=new_linenum;
      set_scroll_pos(old_left_edge,old_cursor_y);
      /* HERE - Need to account for extended selection because started/ended
       * in the middle of a comment/preprocessing.  Need to do an adjustment.
       */
   } else {
      #if 1
      if( status==2 ) {
         /* There was an error, so transform the error line number
          * from the temp view into the correct line number
          */
         error_linenum=p_line;
         p_view_id=orig_view_id;
         _deselect();
         /* -2 to correct for the
          * CFORMAT-SUSPEND-WRITE and CFORMAT-RESUME-WRITE directives
          * in the temp view.
          */
         error_linenum=error_linenum+soc_linenum-1-2;
         //messageNwait('soc_linenum='soc_linenum'  error_linenum='error_linenum);
         if( error_linenum>0 ) {
            p_line=error_linenum;
         }
         set_scroll_pos(old_left_edge,old_cursor_y);
         msg=vscf_iserror();
         if( isinteger(msg) ) {
            // Got one of the *_RC constants in rc.sh
            msg=get_message(msg);
         } else {
            parse msg with . ':' msg;
            msg=error_linenum:+':':+msg;
         }
         _message_box(msg);
      }
      #endif
   }

   // Cleanup
   _delete_temp_view(temp_view_id);

   return(status);
}

static int _mycheck_tabs(int editorctl_wid,int p:[])
{
   // Check to see if the current buffer's tab settings differ from the (syntax_indent && indent_with_tabs)
   if( p:["indent_with_tabs"] && editorctl_wid ) {
      if( editorctl_wid.p_tabs!='' ) {
         parse editorctl_wid.p_tabs with t1 t2 .;
      }
      interval=t2-t1;
      if( interval!=p:["tabsize"] ) {
         status=_message_box("Your current buffer's tab settings do not match your chosen tab size.\r\r":+
                             "OK will change your current buffer's tab settings to match those you have chosen",
                             "",
                             MB_OKCANCEL);
         if( status==IDOK ) {
            editorctl_wid.p_tabs='+':+p:["tabsize"];
         } else {
            return(1);
         }
      }
   }

   return(0);
}

#define CFFLAG_INDENT_CASE           "ic"     /* indent-case                       */
#define CFFLAG_INDENT_FL             "if"     /* indent-first-level                */
#define CFFLAG_INDENT_WITH_TABS      "it"     /* indent-with-tabs                  */
#define CFFLAG_NOSPACE_BEFORE_PAREN  "nsp"    /* nospace-before-paren              */
#define CFFLAG_PAD_CONDITION         "pc"     /* pad-condition                     */
#define CFFLAG_NOPAD_CONDITION       "npc"    /* nopad-condition                   */
#define CFFLAG_EAT_BLANK_LINES       "eb"     /* eat-blank-lines                   */
#define CFFLAG_INDENT_PP             "ip"     /* indent-preprocessing              */
#define CFFLAG_CUDDLE_ELSE           "ce"     /* cuddle-else                       */
#define CFFLAG_BESTYLE_ON_FUNCTIONS  "bf"     /* bestyle-on-functions              */
#define CFFLAG_NOSPACE_BEFORE_BRACE  "nsb"    /* nospace-before-brace              */
#define CFFLAG_EAT_PP_SPACE          "eps"    /* eat-preprocessing-space           */
#define CFFLAG_INDENT_COMMENTS       "isc"    /* indent-standalone-comments        */
#define CFFLAG_USE_RELATIVE_INDENT   "icr"    /* indent-trailing-comments-relative */
#define CFFLAG_ALIGN_ON_PARENS       "ap"     /* align-on-parens                   */
#define CFFLAG_ALIGN_ON_EQUAL        "ae"     /* align-on-equal                    */
#define CFFLAG_INDENT_COL1_COMMENTS  "ic1"    /* indent-col1-comments              */
#define CFFLAG_PARENS_ON_RETURN      "pr"     /* parens-on-return                  */
#define CFFLAG_BRACE_STYLE           "bs"     /* brace-style                       */
#define CFFLAG_SYNTAX_INDENT         "si"     /* syntax-indent                     */
#define CFFLAG_BRACE_INDENT          "bi"     /* brace-indent                      */
#define CFFLAG_STATEMENT_COMMENT_COL "scc"    /* statement-comment-col             */
#define CFFLAG_DECL_COMMENT_COL      "dcc"    /* decl-comment-col                  */
#define CFFLAG_TABSIZE               "ts"     /* tabsize                           */
#define CFFLAG_ORIG_TABSIZE          "ots"    /* orig_tabsize                      */
#define CFFLAG_CONTINUATION_INDENT   "ci"     /* continuation-indent               */

static _str _merge_flags(int p:[])
{
   return(((p:["indent_case"])          ?('+'):('-')) :+ CFFLAG_INDENT_CASE          :+' ':+
          ((p:["indent_fl"])            ?('+'):('-')) :+ CFFLAG_INDENT_FL            :+' ':+
          ((p:["indent_with_tabs"])     ?('+'):('-')) :+ CFFLAG_INDENT_WITH_TABS     :+' ':+
          ((p:["nospace_before_paren"]) ?('+'):('-')) :+ CFFLAG_NOSPACE_BEFORE_PAREN :+' ':+
          ((p:["pad_condition"])        ?('+'):('-')) :+ CFFLAG_PAD_CONDITION        :+' ':+
          ((p:["nopad_condition"])      ?('+'):('-')) :+ CFFLAG_NOPAD_CONDITION      :+' ':+
          ((p:["eat_blank_lines"])      ?('+'):('-')) :+ CFFLAG_EAT_BLANK_LINES      :+' ':+
          ((p:["indent_pp"])            ?('+'):('-')) :+ CFFLAG_INDENT_PP            :+' ':+
          ((p:["cuddle_else"])          ?('+'):('-')) :+ CFFLAG_CUDDLE_ELSE          :+' ':+
          ((p:["bestyle_on_functions"]) ?('+'):('-')) :+ CFFLAG_BESTYLE_ON_FUNCTIONS :+' ':+
          ((p:["nospace_before_brace"]) ?('+'):('-')) :+ CFFLAG_NOSPACE_BEFORE_BRACE :+' ':+
          ((p:["eat_pp_space"])         ?('+'):('-')) :+ CFFLAG_EAT_PP_SPACE         :+' ':+
          ((p:["indent_comments"])      ?('+'):('-')) :+ CFFLAG_INDENT_COMMENTS      :+' ':+
          ((p:["use_relative_indent"])  ?('+'):('-')) :+ CFFLAG_USE_RELATIVE_INDENT  :+' ':+
          ((p:["align_on_parens"])      ?('+'):('-')) :+ CFFLAG_ALIGN_ON_PARENS      :+' ':+
          ((p:["align_on_equal"])       ?('+'):('-')) :+ CFFLAG_ALIGN_ON_EQUAL       :+' ':+
          ((p:["indent_col1_comments"]) ?('+'):('-')) :+ CFFLAG_INDENT_COL1_COMMENTS :+' ':+
          ((p:["parens_on_return"])     ?('+'):('-')) :+ CFFLAG_PARENS_ON_RETURN     :+' ':+
          '-':+CFFLAG_BRACE_STYLE           :+' ':+p:["be_style"]              :+' ':+
          '-':+CFFLAG_SYNTAX_INDENT         :+' ':+p:["syntax_indent"]         :+' ':+
          '-':+CFFLAG_BRACE_INDENT          :+' ':+p:["brace_indent"]          :+' ':+
          '-':+CFFLAG_STATEMENT_COMMENT_COL :+' ':+p:["statement_comment_col"] :+' ':+
          '-':+CFFLAG_DECL_COMMENT_COL      :+' ':+p:["decl_comment_col"]      :+' ':+
          '-':+CFFLAG_TABSIZE               :+' ':+p:["tabsize"]               :+' ':+
          '-':+CFFLAG_ORIG_TABSIZE          :+' ':+p:["orig_tabsize"]          :+' ':+
          '-':+CFFLAG_CONTINUATION_INDENT   :+' ':+p:["continuation_indent"]
         );
}

#define BESTYLE1_FLAG 1
#define BESTYLE2_FLAG 2

#define CFBESTYLE0_FLAG 1
#define CFBESTYLE1_FLAG 2
#define CFBESTYLE2_FLAG 4

static int _init_options(int (&p):[],int sync_ext_options,_str ext)
{
   msg='';
   idx=find_index('def-options-':+ext,MISC_TYPE);
   if( !idx ) {
      _message_box('No option information for extension ':+ext);
      return(1);
   }

   parse name_info(idx) with syntax_indent . . . flags indent_fl . indent_case .;

   // options don't always specify value for indent_case
   if(indent_case=="") indent_case=0;

   if( sync_ext_options || !isinteger(p:["syntax_indent"]) || p:["syntax_indent"]<0 ) {
      if( !isinteger(syntax_indent) || syntax_indent<0 ) {
         _message_box('Invalid syntax indent value');
         return(1);
      }
      p:["syntax_indent"]=syntax_indent;   // Set to default value
   }

   if( sync_ext_options || !isinteger(p:["be_style"]) ||
       p:["be_style"]<0 || p:["be_style"]>4 ) {
      be_style= flags&(BESTYLE1_FLAG|BESTYLE2_FLAG);
      if( !isinteger(be_style) || be_style<0 || be_style>2 ) {
         _message_box('Invalid Begin/End style');
         return(1);
      }
      /* The 3 styles are indexed 0x1,0x2,0x4 (not 0,1,2) in cformat.dll
       * because 0 means no brace style
       */
      switch( be_style ) {
      case 0:
         be_style=CFBESTYLE0_FLAG;   // The first begin/end style (Kernigan&Richie)
         break;
      case 1:
         be_style=CFBESTYLE1_FLAG;
         break;
      case 2:
         be_style=CFBESTYLE2_FLAG;
         break;
      default:
         be_style=0;   // SHOULD NEVER GET HERE
      }
      p:["be_style"]=be_style;
   }

   if( sync_ext_options || !isinteger(p:["indent_fl"]) ) p:["indent_fl"]=indent_fl;
   if( sync_ext_options || !isinteger(p:["indent_case"]) ) p:["indent_case"]=indent_case;
   if( sync_ext_options || !isinteger(p:["nospace_before_paren"]) ) p:["nospace_before_paren"]= (flags&16)?(1):(0);

   if( !isinteger(p:["eat_blank_lines"]) ) {
      p:["eat_blank_lines"]=0;
   }

   #if 1
   // For now, there will be no separate brace_indent amount
   if( p:["be_style"]==CFBESTYLE2_FLAG ) {
      p:["brace_indent"]=p:["syntax_indent"];
   } else {
      p:["brace_indent"]=0;
   }
   #else
   if( !isinteger(p:["brace_indent"]) ) {
      p:["brace_indent"]=0;
   }
   #endif

   if( !isinteger(p:["indent_pp"]) ) {
      p:["indent_pp"]=1;   // Default to ON
   }

   if( !isinteger(p:["statement_comment_col"]) ) {
      p:["statement_comment_col"]=0;
   }

   if( !isinteger(p:["decl_comment_col"]) ) {
      p:["decl_comment_col"]=0;
   }

   if( !isinteger(p:["cuddle_else"]) ) {
      p:["cuddle_else"]=(int)(p:["be_style"]==CFBESTYLE0_FLAG);
   }

   if( !isinteger(p:["bestyle_on_functions"]) ) {
      p:["bestyle_on_functions"]=0;
   }

   if( !isinteger(p:["indent_comments"]) ) {
      p:["indent_comments"]=1;   // Default to ON
   }

   if( !isinteger(p:["use_relative_indent"]) ) {
      p:["use_relative_indent"]=1;   // Default to ON
   }

   if( !isinteger(p:["align_on_parens"]) ) {
      p:["align_on_parens"]=1;   // Default to ON
   }

   if( !isinteger(p:["align_on_equal"]) ) {
      p:["align_on_equal"]=1;   // Default to ON
   }

   if( !isinteger(p:["indent_col1_comments"]) ) {
      p:["indent_col1_comments"]=0;   // Default to OFF
   }

   if( !isinteger(p:["parens_on_return"]) ) {
      p:["parens_on_return"]=0;   // Default to OFF
   }

   /* NOTE:  Padding condition actually has 3 states:  INSERT_PADDING, REMOVE_PADDING,
    *        and LEAVE_PADDING_ALONE.  It is easier to make 2 separate options
    *        (pad_condition and nopad_condition), and, if neither of these are ON,
    *        then use the default case (leave padding alone).
    */
   if( !isinteger(p:["pad_condition"]) ) {
      p:["pad_condition"]=0;   // Default to OFF
   }

   if( !isinteger(p:["nopad_condition"]) ) {
      p:["nopad_condition"]=0;   // Default to OFF
   }

   p:["nospace_before_brace"]=0;   // HERE - don't support this option yet

   idx=find_index('def-setup-':+ext,MISC_TYPE);
   if( !idx ) {
      _message_box('No setup information for extension');
      return(1);
   }
   parse name_info(idx) with 'MN=' mode_name ','\
     'TABS=' tabs ',' 'MA=' margins ',' 'KEYTAB=' keytab_name ','\
     'WW='word_wrap_style ',' 'IWT='indent_with_tabs ','\
     'ST='show_tabs ',' 'IN='indent_style ','\
     'WC='word_chars',' 'LN='lexer_name',' 'CF='color_flags','\
     'LNL='line_numbers_len',';

   if( sync_ext_options || !isinteger(p:["indent_with_tabs"]) ) {
      p:["indent_with_tabs"]=indent_with_tabs;
   }
   // TEST - p:["indent_with_tabs"]=1;

   if( !isinteger(p:["continuation_indent"]) || p:["continuation_indent"]<0 ) {
      p:["continuation_indent"]=0;
      // TEST - p:["continuation_indent"]=10
   }

   if( !isinteger(p:["eat_pp_space"]) ) {
      p:["eat_pp_space"]=1;   // Default to ON
   }

   if( !isinteger(p:["tabsize"]) || p:["tabsize"]<0 ) {
      p:["tabsize"]=p:["syntax_indent"];
   }

   if( !isinteger(p:["orig_tabsize"]) || p:["orig_tabsize"]<0 ) {
      p:["orig_tabsize"]=p:["syntax_indent"];
   }
   
   return(0);
}

// This function derives a backup filename from an input filename
static _str _make_backup()
{
   orig_filename=strip(arg(1),'B','"');
#if __UNIX__
   return(orig_filename:+'.~');
#else
   ext=get_extension(orig_filename);
   filename=strip_filename(orig_filename,'I');
   if(ext==''){
      //File had No Extension
      return(filename:+'.__~');
   }
   if( length(ext)==1 ) {
      //File had one character extension
      return(filename:+'.':+ext:+'_~');
   }
   return(filename:+'.':+substr(ext,1,2):+'~':+substr(ext,4));
#endif
}

_command say(...)
{
   say(arg(1));
}

defeventtab _c_beautify_form
_ctl_go.on_create(...)
{
   ext=arg(1);
   _orig_ext=arg(2);
   scheme_s s:[];
   
   s._makeempty();

   _suspend_modify=0;
   CHANGING_SCHEMES=1;
   editorctl_wid=_form_parent();
   if ((editorctl_wid && !editorctl_wid._isEditorCtl()) ||
       (editorctl_wid._QReadOnly())) {
      editorctl_wid=0;
   }

   if( ext!='') {
      // Specific extension passed to form
      if( !editorctl_wid) {
         _ctl_go.p_enabled=0;
      }
   } else {
      if( !editorctl_wid) {
         // No extension passed to form
         _message_box('No Buffer');
         p_active_form._delete_window();
         return('');
      }
      _orig_ext=ext=_mdi.p_child.p_extension;
      
   }
   // The extension here may not match the buffer's extension.
   _form_ext=ext;

   if( _init_ini_files() ) {
      p_active_form._delete_window();
      return('');
   }
   status=_get_user_scheme(s,'Default',_orig_ext);

   _suspend_modify=1;
   status=_init_form(s:['Default'].options);
   _suspend_modify=0;
   if( status ) {
      _ctl_go.p_enabled=0;
      return('');
   }

   _form_options=s:['Default'].options;
   _orig_form_options=_form_options;   // Save this for the Reset button

   // Make the active tab the first tab
   _ctl_sstab.p_ActiveTab=0;
}

_c_beautify_form.on_load()
{
   // Set focus to "Beautify" button
   _ctl_go._set_focus();
}

_ctl_go.on_destroy()
{
}

_ctl_go.lbutton_up()
{
   // Save the user default and dialog settings
   status=call_event(_control _ctl_save,LBUTTON_UP);
   if( status ) {
      return('');
   }

   // Check to see if the current buffer's tab settings matches the tab size chosen
   if( _mycheck_tabs(_form_parent(),_form_options) ) {
      return('');
   }

   do_selection=0;
   if( _ctl_selection_only.p_enabled && _ctl_selection_only.p_value ) {
      do_selection=1;
   }
   editorctl_wid=_form_parent();;
   wid=p_window_id;
   p_active_form._delete_window();
   
   p_window_id=editorctl_wid;
   if( do_selection ) {
      c_beautify_selection(1);
   } else {
      c_beautify('','',1);   // arg(3) says use static array _options:[]
   }

   #if 0
   p_window_id=wid;
   p_active_form._delete_window();
   #endif
}

int _ctl_save.lbutton_up()
{
   sync_ext_options=_ctl_sync_ext_options.p_value;
   
   // Save the user dialog settings to [<_orig_ext>-scheme-Default] section of user schemes
   if( _get_form_scheme(_form_options) || _write_scheme(_form_options,sync_ext_options,_orig_ext:+'-scheme-Default') ) {
      return(1);
   }

   _options=_form_options;
   _adjust_scheme(_options);
   #if 0
   /* Some quick cleanup so that meaningless dialog options don't get stuck in
    * the default section of user ini file
    */
   _options._deleteel("disable_bestyle");
   _options._deleteel("statement_comment_state");
   _options._deleteel("pad_condition_state");

   //messageNwait('_form_ext='_form_ext'  _orig_ext='_orig_ext);
   if( _write_scheme(_options,_orig_ext:+'-scheme-':+CF_DEFAULT_SCHEME_NAME) ) {
      _message_box('Failed to write default options to ':+CF_USER_INI_FILENAME);
      return(1);
   }
   #endif

   // Save the last scheme name used
   scheme_name=_ctl_schemes_list.p_text;
   _ini_set_value(_cf_user_ini_filename,_orig_ext:+'-scheme-Default','last_scheme',scheme_name);

   /* Now write common options.  We do this after the call to _write_scheme()
    * because _write_scheme() gaurantees that the file will exist.
    */
   _ini_set_value(_cf_user_ini_filename,'common','sync_ext_options',sync_ext_options);

   // Configuration was saved, so change the "Cancel" caption to "Close"
   _ctl_cancel.p_caption='Cl&ose';

   return(0);
}

// arg(1)!='' means do a rename instead of a save
int _ctl_scheme_save.lbutton_up(...)
{
   old_name=_ctl_schemes_list.p_text;
   if( old_name==CF_NONE_SCHEME_NAME ) {
      old_name='';
   } else if( pos('(Modified)',old_name,1,'I') ) {
      parse old_name with old_name '(Modified)'
   }

   do_rename= (arg(1)!='');

   if( do_rename && !_user_schemes._indexin(old_name) ) {
      _message_box(nls("Can't find user scheme '%s'.  System schemes cannot be renamed",old_name));
      return(1);
   }

   // Prompt user for name of scheme
   count=0;
   system_schemes=' 'CF_DEFAULT_SCHEME_NAME' ';
   for( i._makeempty();; ) {
      _schemes._nextel(i);
      if( i._isempty() ) break;
      system_schemes=system_schemes:+' ':+i:+' ';
   }
   count=0;
   user_schemes='';
   for( i._makeempty();; ) {
      _user_schemes._nextel(i);
      if( i._isempty() ) break;
      if( i==CF_DEFAULT_SCHEME_NAME ) continue;
      user_schemes=user_schemes:+' ':+i:+' ';
   }
   name=show('-modal _beautify_save_scheme_form',old_name,do_rename,system_schemes,user_schemes);
   if( name=='' ) {
      // User cancelled
      return(0);
   }

   if( do_rename ) {
      // Delete the existing scheme
      _user_schemes._deleteel(old_name);
      _ini_delete_section(_cf_user_ini_filename,_orig_ext:+'-scheme-':+old_name);
      status=_ctl_schemes_list.p_cb_list_box._lbsearch(old_name,'I');
      if( !status ) {
         _ctl_schemes_list.p_cb_list_box._lbdelete_item();
         _ctl_schemes_list.p_cb_list_box._lbtop();
      }
   }

   // Save the user dialog settings to [<_form_ext>-scheme-<scheme name>] section of user schemes
   if( _get_form_scheme(_form_options) || _write_scheme(_form_options,0,_orig_ext:+'-scheme-'name) ) {
      _message_box('Failed to write scheme to ':+CF_USER_INI_FILENAME);
      return(1);
   }
   _suspend_modify=1;
   _ctl_schemes_list.p_text=name;
   if( _ctl_schemes_list.p_cb_list_box._lbsearch(name) ) {   // Is it already in the list?
      _ctl_schemes_list.p_cb_list_box._lbadd_item(name);
      _ctl_schemes_list.p_cb_list_box._lbsort();
   }
   _ctl_schemes_list.p_user='';   // Set this so _ctl_schemes_list.on_change doesn't try to save old scheme
   _suspend_modify=0;
   _user_schemes:[name].options=_form_options;

   return(0);
}

_ctl_scheme_rename.lbutton_up()
{
   call_event(1,_control _ctl_scheme_save,LBUTTON_UP,'W');
}

_ctl_scheme_delete.lbutton_up()
{
   old_name=_ctl_schemes_list.p_text;
   if( old_name==CF_NONE_SCHEME_NAME ) {
      _message_box('Cannot remove empty scheme');
      return('');
   } else if( !_user_schemes._indexin(old_name) ) {
      _message_box(nls("Can't find user scheme '%s'.  System schemes cannot be removed",old_name));
      return('');
   }

   // Delete the existing scheme
   _user_schemes._deleteel(old_name);
   _ini_delete_section(_cf_user_ini_filename,_orig_ext:+'-scheme-':+old_name);
   _suspend_modify=1;
   _ctl_schemes_list.p_text=CF_NONE_SCHEME_NAME;
   status=_ctl_schemes_list.p_cb_list_box._lbsearch(old_name,'I');
   if( !status ) {
      _ctl_schemes_list.p_cb_list_box._lbdelete_item();
      _ctl_schemes_list.p_cb_list_box._lbtop();
   }
   _ctl_schemes_list.p_user='';   // Set this so _ctl_schemes_list.on_change doesn't try to save old scheme
   _suspend_modify=0;
}

// p_user holds the previous scheme in case of error
_ctl_schemes_list.on_change(reason)
{
   if( reason==CHANGE_OTHER || !CHANGING_SCHEMES ) {
      /* Probably stuck a '(Modified)' on the end of the scheme name
       * OR
       * We are temporarily suspending ON_CHANGE for the scheme list
       */
      return('');
   }
   name=p_text;
   old_name=p_user;
   // IF name has not changed OR no scheme chosen
   if( name==old_name || name==CF_NONE_SCHEME_NAME ) {
      return('');
   }
   if( !_schemes._indexin(name) && !_user_schemes._indexin(name) ) {
      _message_box('Empty scheme!');
      p_text=old_name;
      return('');
   } else {
      if( pos('(Modified)',old_name,1,'I') ) {
         status=_message_box("You have a modified scheme.\r":+
                             "Do you wish to save it?",
                             "",MB_YESNOCANCEL|MB_ICONQUESTION);
         if( status==IDCANCEL ) {
            p_text=old_name;
            return('');
         } else if( status==IDYES ) {
            p_text=old_name;   // Put the old name in so we know which scheme to save
            status=call_event(_control _ctl_scheme_save,LBUTTON_UP);
            if( status ) {
               // There was a problem, so do not put the new name back in its place
               return('');
            }
            _ctl_schemes_list.p_text=name;   // Put it back
         }

      }
      _suspend_modify=1;
      CHANGING_SCHEMES=0;
      if( _schemes._indexin(name) ) {
         _init_form(_schemes:[name].options);
         _form_options=_schemes:[name].options;
      } else {
         _init_form(_user_schemes:[name].options);
         _form_options=_user_schemes:[name].options;
      }
      CHANGING_SCHEMES=1;
      _suspend_modify=0;
   }

   p_user=name;
}

_ctl_reset.lbutton_up()
{
   _ctl_schemes_list.p_text=_orig_scheme;
   _ctl_schemes_list.p_user='';   // Set this so _ctl_schemes_list.on_change doesn't try to save old scheme
   _suspend_modify=1;
   CHANGING_SCHEMES=0;
   _init_form(_orig_form_options);
   _form_options=_orig_form_options;
   CHANGING_SCHEMES=1;
   _suspend_modify=0;
}

static int _init_form(int (&p):[])
{
   // Sync with extension options?
   status=_ini_get_value(_cf_user_ini_filename,'common','sync_ext_options',sync_ext_options,'1')
   if( status ) sync_ext_options=true;
   if( sync_ext_options ) {
      _ctl_sync_ext_options.p_value=sync_ext_options;
   }
   
   if( _init_options(p,sync_ext_options,_orig_ext) ) {
      return(1);
   }

   /* Some form specific options that must be initialized eventhough
    * they are not on the main dialog
    */
   if( !isinteger(p:["disable_bestyle"]) ) p:["disable_bestyle"]=0;
   if( !isinteger(p:["statement_comment_state"]) ) p:["statement_comment_state"]=CFCOMMENT_STATE_RELATIVE;
   if( !isinteger(p:["pad_condition_state"]) ) p:["pad_condition_state"]=CFPADCONDITION_STATE_NOCHANGE;

   onCreateBEStyle(p);
   onCreateIndenting(p);
   onCreateComments(p);
   onCreateOther(p);
   if( CHANGING_SCHEMES ) onCreateSchemes();

   // Selection
   if( _mdi.p_child.select_active() ) {
      _ctl_selection_only.p_enabled=1;
      _ctl_selection_only.p_value=1;
   } else {
      _ctl_selection_only.p_enabled=0;
   }

   return(0);
}

// Begin/End Style
_ctl_disable_bestyle.lbutton_up(...)
{
   enabled= !(_ctl_disable_bestyle.p_value);
   _ctl_bestyle0.p_enabled=enabled;
   _ctl_bestyle1.p_enabled=enabled;
   _ctl_bestyle2.p_enabled=enabled;

   _modify_scheme();
}

// We only use this event to notify _schemes_list of a modification to current scheme
_ctl_bestyle0.lbutton_up()
{
   _modify_scheme();
}

static int onCreateBEStyle(int (&p):[])
{
   // Begin/end style
   _suspend_modify=1;

   if( !isinteger(p:["disable_bestyle"]) ) {
      p:["disable_bestyle"]=0;
   }
   _ctl_disable_bestyle.p_value=p:["disable_bestyle"];
   call_event(_control _ctl_disable_bestyle,LBUTTON_UP);
   _ctl_bestyle0.p_value=0;
   _ctl_bestyle1.p_value=0;
   _ctl_bestyle2.p_value=0;
   switch( p:["be_style"] ) {
   case CFBESTYLE0_FLAG:
      _ctl_bestyle0.p_value=1;
      break;
   case CFBESTYLE1_FLAG:
      _ctl_bestyle1.p_value=1;
      break;
   case CFBESTYLE2_FLAG:
      _ctl_bestyle2.p_value=1;
      break;
   }
   _ctl_nospace_before_paren.p_value=p:["nospace_before_paren"];
   _ctl_cuddle_else.p_value=p:["cuddle_else"];
   _ctl_bestyle_on_functions.p_value=p:["bestyle_on_functions"];

   _suspend_modify=0;

   return(0);
}

static int _get_bestyle_tab_scheme(int (&p):[])
{
   // Begin/end style
   p:["disable_bestyle"]=_ctl_disable_bestyle.p_value;
   p:["be_style"]= -1;   // Undefined
   if( _ctl_bestyle0.p_value ) {
      p:["be_style"]=CFBESTYLE0_FLAG;
   } else if( _ctl_bestyle1.p_value ) {
      p:["be_style"]=CFBESTYLE1_FLAG;
   } else if( _ctl_bestyle2.p_value ) {
      p:["be_style"]=CFBESTYLE2_FLAG;
   }
   p:["nospace_before_paren"]=_ctl_nospace_before_paren.p_value;
   p:["cuddle_else"]=_ctl_cuddle_else.p_value;
   p:["bestyle_on_functions"]=_ctl_bestyle_on_functions.p_value;

   return(0);
}


// Indenting

// We only use this event to notify _schemes_list of a modification to current scheme
_ctl_indent_with_tabs.lbutton_up()
{
   _modify_scheme();
}

// We only use this event to notify _schemes_list of a modification to current scheme
_ctl_syntax_indent.on_change()
{
   _modify_scheme();
}

static int onCreateIndenting(int (&p):[])
{
   // Indenting
   _suspend_modify=1;

   _ctl_indent_with_tabs.p_value=p:["indent_with_tabs"];
   _ctl_indent_fl.p_value=p:["indent_fl"];
   _ctl_indent_case.p_value=p:["indent_case"];
   _ctl_syntax_indent.p_text=p:["syntax_indent"];
   _ctl_continuation_indent.p_text=p:["continuation_indent"];
   _ctl_align_on_parens.p_value=p:["align_on_parens"];
   _ctl_align_on_equal.p_value=p:["align_on_equal"];
   #if 0
   p:["tabsize"]=p:["syntax_indent"];
   #else
   if( !isinteger(p:["tabsize"]) ) {
      p:["tabsize"]=p:["syntax_indent"];
   }
   #endif
   tabsize=p:["tabsize"];
   _ctl_tabsize.p_text=tabsize;
   #if 1
   p:["orig_tabsize"]=p:["syntax_indent"];
   #else
   if( !isinteger(p:["orig_tabsize"]) ) {
      p:["orig_tabsize"]=p:["syntax_indent"];
   }
   #endif
   orig_tabsize=p:["orig_tabsize"];
   _ctl_orig_tabsize.p_text=orig_tabsize;

   _suspend_modify=0;

   return(0);
}

static int _get_indenting_tab_scheme(int (&p):[])
{
   // Indenting
   indent_with_tabs=_ctl_indent_with_tabs.p_value;
   indent_fl=_ctl_indent_fl.p_value;
   indent_case=_ctl_indent_case.p_value;

   syntax_indent=_ctl_syntax_indent.p_text;
   if( !isinteger(syntax_indent) || syntax_indent<0 ) {
      _message_box('Invalid value for Syntax Indent');
      p_window_id=_ctl_syntax_indent;
      _set_sel(1,length(p_text)+1);_set_focus();
      return(1);
   }

   continuation_indent=_ctl_continuation_indent.p_text;
   if( !isinteger(continuation_indent) || continuation_indent<0 ) {
      _message_box('Invalid value for Continuation Indent');
      p_window_id=_ctl_continuation_indent;
      _set_sel(1,length(p_text)+1);_set_focus();
      return(1);
   }

   tabsize=_ctl_tabsize.p_text;
   if( !isinteger(tabsize) || tabsize<0 ) {
      _message_box('Invalid value for Tab Size');
      p_window_id=_ctl_tabsize;
      _set_sel(1,length(p_text)+1);_set_focus();
      return(1);
   } else if( syntax_indent!=tabsize ) {
      result=_message_box("You have selected tab stops which differ from the Syntax indent amount.\n\nAre you sure this is what you want?",
                          'Danger Will Robinson! Danger...  Danger',
                          MB_YESNOCANCEL|MB_ICONQUESTION);
      if( result==IDCANCEL || result==IDNO ) {
         p_window_id=_ctl_tabsize;
         _set_sel(1,length(p_text)+1);_set_focus();
         return(1);
      }
   }

   orig_tabsize=_ctl_orig_tabsize.p_text;
   if( !isinteger(orig_tabsize) || orig_tabsize<0 ) {
      _message_box('Invalid value for Original Tab Size');
      p_window_id=_ctl_orig_tabsize;
      _set_sel(1,length(p_text)+1);_set_focus();
      return(1);
   }

   align_on_parens=_ctl_align_on_parens.p_value;
   align_on_equal=_ctl_align_on_equal.p_value;

   // Now set the options
   p:["indent_with_tabs"]=indent_with_tabs;
   p:["indent_fl"]=indent_fl;
   p:["indent_case"]=indent_case;
   p:["syntax_indent"]=(int)syntax_indent;
   p:["continuation_indent"]=(int)continuation_indent;
   p:["tabsize"]=(int)tabsize;
   p:["orig_tabsize"]=(int)orig_tabsize;
   p:["align_on_parens"]=align_on_parens;
   p:["align_on_equal"]=align_on_equal;

   return(0);
}


// Comments
_ctl_abs_comment_col.lbutton_up()
{
   call_event(_control _ctl_statement_comment_col_enable,LBUTTON_UP);
}

_ctl_rel_comment_col.lbutton_up()
{
   call_event(_control _ctl_statement_comment_col_enable,LBUTTON_UP);
}

_ctl_statement_comment_col.on_change()
{
   _modify_scheme();
}

_ctl_statement_comment_col_enable.lbutton_up()
{
   // text box is enabled when check-box is checked
   _ctl_statement_comment_col.p_enabled= (_ctl_statement_comment_col_enable.p_value!=0);

   _modify_scheme();
}

_ctl_indent_comments.lbutton_up()
{
   _ctl_indent_col1_comments.p_enabled=(_ctl_indent_comments.p_value!=0);
   
   _modify_scheme();
}

static int onCreateComments(int (&p):[])
{
   // Comments
   _suspend_modify=1;

   _ctl_indent_comments.p_value=p:["indent_comments"];
   _ctl_indent_col1_comments.p_value=p:["indent_col1_comments"];
   col=p:["statement_comment_col"];
   _ctl_statement_comment_col.p_text=col;
   _ctl_statement_comment_col_enable.p_value=0;
   _ctl_abs_comment_col.p_value=0;
   _ctl_rel_comment_col.p_value=0;
   if( !isinteger(p:["statement_comment_state"]) ) {
      p:["statement_comment_state"]=CFCOMMENT_STATE_RELATIVE;
   }
   switch( p:["statement_comment_state"] ) {
   case CFCOMMENT_STATE_SPECIFIC:
      _ctl_statement_comment_col_enable.p_value=1;
      break;
   case CFCOMMENT_STATE_ABSOLUTE:
      _ctl_abs_comment_col.p_value=1;
      break;
   case CFCOMMENT_STATE_RELATIVE:
      _ctl_rel_comment_col.p_value=1;
      break;
   }
   call_event(_control _ctl_indent_comments,LBUTTON_UP);
   call_event(_control _ctl_statement_comment_col_enable,LBUTTON_UP);

   _suspend_modify=0;

   return(0);
}

static int _get_comments_tab_scheme(int (&p):[])
{
   // Comments
   indent_comments=_ctl_indent_comments.p_value;
   indent_col1_comments=_ctl_indent_col1_comments.p_value;
   statement_comment_col=_ctl_statement_comment_col.p_text;
   if( !isinteger(statement_comment_col) || statement_comment_col<0 ) {
      _message_box('Invalid value for Comment Column');
      p_window_id=_ctl_statement_comment_col;
      _set_sel(1,length(p_text)+1);_set_focus();
      return(1);
   }

   // Now set the options
   p:["indent_comments"]=indent_comments;
   p:["indent_col1_comments"]=indent_col1_comments;
   p:["statement_comment_col"]=(int)statement_comment_col;
   p:["statement_comment_state"]=-1;   // Undefined
   if( _ctl_statement_comment_col_enable.p_value ) {
      p:["statement_comment_state"]=CFCOMMENT_STATE_SPECIFIC;
   } else if( _ctl_abs_comment_col.p_value ) {
      p:["statement_comment_state"]=CFCOMMENT_STATE_ABSOLUTE;
   } else if( _ctl_rel_comment_col.p_value ) {
      p:["statement_comment_state"]=CFCOMMENT_STATE_RELATIVE;
   }
   p:["use_relative_indent"]=_ctl_rel_comment_col.p_value;

   return(0);
}


// Preprocessing, and Other
_ctl_indent_pp.lbutton_up()
{
   _modify_scheme();
}

_ctl_insert_padding.lbutton_up()
{
   _modify_scheme();
}

_ctl_remove_padding.lbutton_up()
{
   call_event(_control _ctl_insert_padding,LBUTTON_UP);
}

_ctl_leave_padding_alone.lbutton_up()
{
   call_event(_control _ctl_insert_padding,LBUTTON_UP);
}

static int onCreateOther(int (&p):[])
{
   _suspend_modify=1;

   // Preprocessing
   _ctl_indent_pp.p_value=p:["indent_pp"];
   _ctl_eat_pp_space.p_value=p:["eat_pp_space"];

   // Parens on return
   _ctl_parens_on_return.p_value=p:["parens_on_return"];

   // Pad condition
   _ctl_insert_padding.p_value=0;
   _ctl_remove_padding.p_value=0;
   _ctl_leave_padding_alone.p_value=0;
   if( !isinteger(p:["pad_condition_state"]) ) {
      p:["pad_condition_state"]=CFPADCONDITION_STATE_NOCHANGE;
   }
   //messageNwait('pad_condition_state='p:["pad_condition_state"]);
   switch( p:["pad_condition_state"] ) {
   case CFPADCONDITION_STATE_INSERT:
      _ctl_insert_padding.p_value=1;
      break;
   case CFPADCONDITION_STATE_REMOVE:
      _ctl_remove_padding.p_value=1;
      break;
   case CFPADCONDITION_STATE_NOCHANGE:
      _ctl_leave_padding_alone.p_value=1;
      break;
   }
   call_event(_control _ctl_insert_padding,LBUTTON_UP);

   _suspend_modify=0;

   return(0);
}

static int _get_other_tab_scheme(int (&p):[])
{
   // Preprocessing
   p:["indent_pp"]=_ctl_indent_pp.p_value;
   p:["eat_pp_space"]=_ctl_eat_pp_space.p_value;

   // Parens on return
   p:["parens_on_return"]=_ctl_parens_on_return.p_value;

   // Pad condition
   if( _ctl_insert_padding.p_value ) {
      p:["pad_condition_state"]=CFPADCONDITION_STATE_INSERT;
   } else if( _ctl_remove_padding.p_value ) {
      p:["pad_condition_state"]=CFPADCONDITION_STATE_REMOVE;
   } else if( _ctl_leave_padding_alone.p_value ) {
      p:["pad_condition_state"]=CFPADCONDITION_STATE_NOCHANGE;
   }
   p:["pad_condition"]=_ctl_insert_padding.p_value;
   p:["nopad_condition"]=_ctl_remove_padding.p_value;

   return(0);
}


// Schemes
static int onCreateSchemes()
{
   // Schemes
   _ctl_schemes_list.p_user='';
   _schemes._makeempty();
   _user_schemes._makeempty();

   // Get the last scheme used
   if( !_ini_get_value(_cf_user_ini_filename,_orig_ext:+'-scheme-Default','last_scheme',_cur_scheme) ) {
      #if 0   // Can't do this because _schemes and _user_schemes are not filled in yet
      // Check if scheme name is valid
      if( !_schemes._indexin(_cur_scheme) && !_user_schemes._indexin(_cur_scheme) ) {
         // Scheme does not exist
         _cur_scheme=CF_NONE_SCHEME_NAME;
      }
      #endif
   } else {
      _cur_scheme=CF_NONE_SCHEME_NAME;
   }
   _orig_scheme=_cur_scheme;   // Save this for the Reset button

   if( !_get_scheme(_schemes,'',_orig_ext) ) {
      for( i._makeempty();; ) {
         _schemes._nextel(i);
         if( i._isempty() ) break;
         _ctl_schemes_list.p_cb_list_box._lbadd_item(i);
      }
   }
   if( !_get_user_scheme(_user_schemes,'',_orig_ext) ) {
      for( i._makeempty();; ) {
         _user_schemes._nextel(i);
         if( i._isempty() ) break;
         // We don't want to blast the default scheme because it is already set
         if( i!=CF_DEFAULT_SCHEME_NAME ) {
            _ctl_schemes_list.p_cb_list_box._lbadd_item(i);
         }
      }
   }
   _ctl_schemes_list.p_cb_list_box._lbsort();
   _ctl_schemes_list.p_text=_cur_scheme;

   return(0);
}

static _str _maybe_create_user_ini_file()
{
   status=0;
   filenopath=CF_USER_INI_FILENAME;
   filename=_config_path():+filenopath;
   global_filename=slick_path_search(filenopath);
   if( global_filename!="" && file_match("-p "maybe_quote_filename(filename),1)=="" &&
       !file_eq(global_filename,filename) ) {
      // Make copy of global configuration file.
      copy_file(global_filename,filename);
   } else if( file_match("-p "maybe_quote_filename(filename),1)=="" ) {
      // Doesn't exist so create it
      orig_view_id=_create_temp_view(temp_view_id);
      p_buf_name=_config_path():+filenopath;
      insert_line(';');
      insert_line('; Options not currently implemented:');
      insert_line(';');
      insert_line('; decl_comment_col');
      insert_line('; nospace_before_brace');
      insert_line(';');
      insert_line(';');
      insert_line(';');
      insert_line('; Explanation of statement_comment_state:');
      insert_line(';   3-state radio button group for statement comment column');
      insert_line(';   Can be one of 3 values:');
      insert_line(';     0=column');
      insert_line(';     1=absolute');
      insert_line(';     2=relative');
      insert_line('');
      status=_save_file('+o');
      if( status ) {
         filename='';
      }
      activate_view(orig_view_id);
      _delete_temp_view(temp_view_id);
   }

   if( status ) {
      return('');
   }
   return(filename);
}

static int _write_scheme(int p:[],int sync_ext_options,section_name)
{
   status=0;

   if( sync_ext_options ) {
      parse section_name with ext '-' .;
      ext=refer_ext(ext);
      
      idx=find_index('def-options-':+ext,MISC_TYPE);
      if( !idx ) {
         _message_box('Warning: No option information for extension ':+ext,'Warning',MB_OK|MB_ICONEXCLAMATION);
      } else {
         parse name_info(idx) with syntax_indent o2 o3 o4 flags indent_fl o7 indent_case rest;
         
         // Syntax indent
         syntax_indent=p:["syntax_indent"];
         
         // Begin/end style
         flags= flags & ~(BESTYLE1_FLAG|BESTYLE2_FLAG);
         switch( p:["be_style"] ) {
         case CFBESTYLE1_FLAG:
            flags = flags | BESTYLE1_FLAG;
            break;
         case CFBESTYLE2_FLAG:
            flags = flags | BESTYLE2_FLAG;
         }
         flags = flags & ~(16);
         if( p:["nospace_before_paren"] ) {
            flags = flags | 16;
         }
         
         // Indent first level
         indent_fl=p:["indent_fl"];
         
         // Indent case from switch
         indent_case=p:["indent_case"];
         
         new_options=syntax_indent' 'o2' 'o3' 'o4' 'flags' 'indent_fl' 'o7' 'indent_case' 'rest;
         set_name_info(idx,new_options);
         _config_modify|=CFGMODIFY_DEFDATA;
      }
      
      
      idx=find_index('def-setup-':+ext,MISC_TYPE);
      if( !idx ) {
         _message_box('Warning: No setup information for extension','Warning',MB_OK|MB_ICONEXCLAMATION);
      } else {
         parse name_info(idx) with 'MN=' mode_name ','\
           'TABS=' tabs ',' 'MA=' margins ',' 'KEYTAB=' keytab_name ','\
           'WW='word_wrap_style ',' 'IWT='indent_with_tabs ','\
           'ST='show_tabs ',' 'IN='indent_style ','\
           'WC='word_chars',' 'LN='lexer_name',' 'CF='color_flags','\
           'LNL='line_numbers_len',';
         
         
         // Indent with tabs
         indent_with_tabs=p:["indent_with_tabs"];
         
         // Make sure all the values are legal
         _ext_init_values(ext,lexer_name,color_flags);
         if( !isinteger(line_numbers_len) ) {
            line_numbers_len=0;
         }
         if( word_chars=='' ) {
            word_chars='A-Za-z0-9_$';
         }
         if( word_wrap_style=='' ) {
            word_wrap_style=3;
         }
         if( show_tabs=='' ) {
            show_tabs=0;
         }
         if( indent_style=='' ) indent_style=INDENT_SMART;
         
         new_setup='MN=' mode_name ',':+
           'TABS=' tabs ',' 'MA=' margins ',' 'KEYTAB=' keytab_name ',':+
           'WW='word_wrap_style ',' 'IWT='indent_with_tabs ',':+
           'ST='show_tabs ',' 'IN='indent_style ',':+
           'WC='word_chars',' 'LN='lexer_name',' 'CF='color_flags',':+
           'LNL='line_numbers_len',';
           
         set_name_info(idx,new_setup);
         _config_modify|=CFGMODIFY_DEFDATA;
         _update_buffers(ext,new_setup);
      }
   }
   
   filename=_maybe_create_user_ini_file();
   if( filename=='' ) {
      _message_box('Error getting user file ':+CF_USER_INI_FILENAME);
      return(1);
   }

   orig_view_id=_create_temp_view(temp_view_id);
   if( orig_view_id=='' ) {
      _message_box('Error creating temp view');
      return(1);
   }

   // Write the values
   _delete_line();
   for( i._makeempty();; ) {
      p._nextel(i);
      if( i._isempty() ) break;
      //messageNwait('inserting p:['i']='p:[i]);
      insert_line(i:+'=':+p:[i]);
   }

   p_view_id=orig_view_id;

   // Do not need to use _delete_temp_view() because _ini_put_section() will get rid of it for us
   // Don't need to worry if the file does not exist, _ini_put_section() will create it
   status=_ini_put_section(filename,section_name,temp_view_id);
   if( status ) {
      _message_box(nls("Unable to update file %s.",filename)"  "get_message(status),"Error",MB_OK|MB_ICONEXCLAMATION);
      return(status);
   }
   
   return(0);
}

static int _get_form_scheme(int (&p):[])
{
   _get_bestyle_tab_scheme(_form_options);
   _get_indenting_tab_scheme(_form_options);
   _get_comments_tab_scheme(_form_options);
   _get_other_tab_scheme(_form_options);

   // Others not supported now, but have to be filled in
   p:["eat_blank_lines"]=0;
   p:["nospace_before_brace"]=0;
   p:["decl_comment_col"]=0;

   return(0);
}

/* Adust the values according to dialog settings so that they can be
 * passed to _format()
 */
static int _adjust_scheme(int (&p):[])
{
   // Begin/end style
   p:["brace_indent"]=0;
   if( p:["disable_bestyle"] ) {
      p:["be_style"]=0;
   } else if( p:["be_style"]==CFBESTYLE2_FLAG ) {
      p:["brace_indent"]=p:["syntax_indent"];
   }

   // Indenting
   indent=p:["syntax_indent"];
   if( !isinteger(indent) || indent<0 ) {
      p:["syntax_indent"]=3;   // Need to change this
   }
   indent=p:["continuation_indent"];
   if( !isinteger(indent) || indent<0 ) {
      p:["continuation_indent"]=0;
   }

   // Comments
   if( p:["statement_comment_state"]==CFCOMMENT_STATE_SPECIFIC ) {
      col=p:["statement_comment_col"];
      if( !isinteger(col) || col<0 ) {
         p:["statement_comment_col"]=0;
      }
   } else {
      p:["statement_comment_col"]=0;
   }

   return(0);
}

static boolean _user_scheme_exists(_str name,_str ext)
{
   boolean exists;
   
   if( _cf_ini_filename=='' || _open_temp_view(_cf_ini_filename,temp_view_id,orig_view_id) ) {
      return(false);
   }

   ss=ext:+'-scheme-':+name;
   exists= (_ini_find_section(ss)==0);

   // Delete the temp view
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   
   return(exists);
}

static int _get_scheme(scheme_s (&p):[],_str name,_str ext)
{
   if( _cf_ini_filename=='' || _open_temp_view(_cf_ini_filename,temp_view_id,orig_view_id) ) {
      return(1);
   }

   prefix=ext:+'-scheme-';
   _get_scheme2(p,prefix,name);

   // Delete the temp view
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);

   return(0);
}

static int _get_user_scheme(scheme_s (&p):[],_str name,_str ext)
{
   if( _cf_user_ini_filename=='' || _open_temp_view(_cf_user_ini_filename,temp_view_id,orig_view_id) ) {
      return(1);
   }

   prefix=ext:+'-scheme-';
   status=_get_scheme2(p,prefix,name);

   // Delete the temp view
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);

   return(status);
}

static int _get_scheme2(scheme_s (&p):[],prefix,_str name)
{
   ss='';
   if( name!='' ) {
      ss=prefix:+name;
   }

   top();
   found_one=0;
   do {
      if( _ini_find_section(ss) ) {
         break;
      }
      get_line(line);
      parse line with '[' section_name ']';
      parse section_name with (prefix) scheme_name;
      if( scheme_name=='' ) {
         // Not a valid scheme
         if( down() ) break;   // Bottom of file, so done!
         continue;
      }
      found_one=1;
      down();   // Move off the section line
      sl=p_line;
      // Now find the next section so we can bracket this section
      if( _ini_find_section('') ) {
         bottom();
      } else {
         up();   // Move off the the next section name
      }
      el=p_line;

      // Get the values
      p_line=sl;
      while( p_line<=el ) {
         get_line(line);
         line=strip(line,'L');
         if( line=='' || substr(line,1,1)==';' ) {
            // Blank line OR comment line
            if( down() ) break;  // Done!
            continue;
         }
         parse line with line ';' .;   // Get rid of a trailing comment (not sure if we need this)
         parse line with varname '=' val;
         if( val=='' || !isinteger(val) ) {
            if( down() ) break;   // Done!
            continue;   // Not a valid value
         }
         varname=lowcase(varname);
         p:[scheme_name].options:[varname]=val;
         if( down() ) break;   // Done!
      }
   } while( name=='' );

   if( !found_one ) {
      return(1);
   }
   return(0);
}

static void _modify_scheme()
{
   if( _suspend_modify ) return;   // Modification temporarily suspended
   name=_ctl_schemes_list.p_text;
   if( !pos('(Modified)',name,1,'I') && name!=CF_NONE_SCHEME_NAME ) {
      name=strip(name,'B'):+' (Modified)';
      _ctl_schemes_list.p_text=name;
      _ctl_schemes_list.p_user=name;
   }
}

static int _init_ini_files()
{
   _cf_ini_filename=slick_path_search(CF_INI_FILENAME);
   _cf_user_ini_filename=_maybe_create_user_ini_file();
   if( _cf_user_ini_filename=='' ) {
      _message_box('Cannot find or create configuration file "':+CF_USER_INI_FILENAME:+'"');
      return(1);
   }

   return(0);
}

static _str system_schemes;   // List of system schemes that are read-only
static _str user_schemes;     // List of user schemes that we must prompt to overwrite
defeventtab _beautify_save_scheme_form
// arg(1) is initial value of scheme name to save
// arg(2)!='' means to do a rename instead of a save
// arg(3)!='' is a list of system schemes (read-only)
// arg(4)!='' is a list of user schemes   (prompt for overwrite)
_ctl_save.on_create(...)
{
   if( arg(1)!='' ) {
      _ctl_schemes.p_text=arg(1);
   } else {
      _ctl_schemes.p_text='';
   }
   if( isinteger(arg(2)) && arg(2) ) {
      p_active_form.p_caption='Rename Scheme';
   }
   system_schemes='';
   user_schemes='';
   if( arg()>2 ) {
      system_schemes=arg(3);
   }
   if( arg()>3 ) {
      user_schemes=arg(4);
   }
   list=user_schemes;
   while( list!='' ) {
      parse list with name list;
      _ctl_schemes.p_cb_list_box._lbadd_item(name);
   }
   _ctl_schemes.p_cb_list_box._lbsort();
}

_ctl_save.on_destroy()
{
}

_ctl_schemes.on_change()
{
   name=_ctl_schemes.p_text;
   if( name!='' ) {
      _ctl_save.p_enabled=1;
   } else {
      _ctl_save.p_enabled=0;
   }
}

_ctl_save.lbutton_up()
{
   name=strip(_ctl_schemes.p_text,'B');
   if( pos(' 'name' ',system_schemes,1,'I') ) {
      _message_box('System schemes cannot be removed.');
      return('');
   }
   if( pos(' 'name' ',user_schemes,1,'I') ) {
      status=_message_box('Overwrite existing scheme "'name'"?','',MB_YESNO|MB_ICONQUESTION);
      if( status==IDNO ) {
         return('');
      }
   } else if( pos('(Modified)',name,1,'I') ) {
      // Invalid name, try again
      _message_box('Invalid name');
      return('');
   }
   p_active_form._delete_window(name);
}


// Converts .java and .e extensions to .c
#define DEFAULT_BEAUTIFIER_EXT  "c=c java=c e=c"   /* Valid beautifier extensions */
int _beautify_check_support(_str &ext)
{
   ext=eq_name2value(ext,DEFAULT_BEAUTIFIER_EXT);
   if( ext=='' ) {
      return(1);
   }

   return(0);
}

#define DEFAULT_BEAUTIFIER_LIST  "C/C++=c Java=java Slick-C=e"   /* Valid beautifier languages */
defeventtab _beautify_extension_form
_ctl_ok.on_create()
{
   list=DEFAULT_BEAUTIFIER_LIST;
   while( list!='' ) {
      parse list with name '=' . list;
      _ctl_language._lbadd_item(name);
   }
   _ctl_language._lbsort();
   _ctl_language._lbtop();
   _ctl_language._lbselect_line();
}

_ctl_ok.on_destroy()
{
}

_ctl_ok.lbutton_up()
{
   name=_ctl_language._lbget_seltext();
   ext=eq_name2value(name,DEFAULT_BEAUTIFIER_LIST);
   p_active_form._delete_window(ext);
}

_ctl_language.lbutton_double_click()
{
   call_event(_control _ctl_ok,LBUTTON_UP);
}

