#include "slick.sh"

   int def_codehelp_max_comments=200;
   boolean def_codehelp_html_comments=true;
   int def_codehelp_key_idle=50;
   int def_memberhelp_idle=50;

   static boolean ginListHelp;
   static boolean gListHelp_pending;
   static boolean gMemberHelp_pending;

   static _str gMemberHelp_last_tag_name;
   static int gMemberHelp_last_tag_file_id;
   static int gMemberHelp_last_file_id;
   static int gMemberHelp_last_line_no;

   static int gListHelpStartCol,gListHelpNoflines,gListHelpLineNum;
   static _str gListHelpStartText,gListHelpEndText;
   static _str gListHelpSearchString,gListHelpNewSearchString;
   static _str gListHelpSearchPrefix,gListHelpNewSearchPrefix;
   static _str gListHelpIgnoreCase;
   /**********  get_idexp results ******/
   static _str gListHelp_prefixexp;
   static _str gListHelp_lastid;
   static int gListHelp_lastidstart_col;
   static int gListHelp_lastidstart_offset;
   static int gListHelp_info_flags;
   static boolean gListHelp_OperatorTyped;
   static typeless gListHelp_otherinfo;
   /*********************************/

   static int gListHelp_form_wid;
   static int gMemberHelp_form_wid;
   static int gListHelp_insert_tags_index;
   static int geditorctl_wid,geditorctl_buf_id;
   // non-zero if user has selected tree item
   static int gListHelp_ctltree_wid;

   static int gFunctionHelp_form_wid;
   static int gFunctionHelp_fcthelp_get;
   static boolean gFunctionHelp_OperatorTyped;
   static boolean gFunctionHelp_FirstCall;
   static _str gFunctionHelp_HelpWord;

   static int gFunctionHelp_FunctionNameOffset;
   static int gFunctionHelp_FunctionLineOffset;
   static _str gFunctionHelp_starttext;
   static int gFunctionHelp_flags;

   static int gFunctionHelp_UpdateLineNumber,gFunctionHelp_UpdateLineCol;
   static VSAUTOCODE_ARG_INFO gFunctionHelp_list[];
   //static int gFunctionHelp_ParamNum;
   static int gFunctionHelp_cursor_y;

defeventtab codehelp_keys
def ESC=codehelp_key
def PGUP,PGDN=codehelp_key
def DOWN,C_K=codehelp_key
def UP,C_I=codehelp_key
def C_G=codehelp_key
def ENTER=codehelp_key
def TAB=codehelp_key
def 'A-.'=codehelp_key
def 'C-DOWN'=codehelp_key
def 'C-UP'=codehelp_key
def 'C- '=codehelp_key
//def \0-\127=
def ' '-\127=codehelp_key
//def '='=codehelp_key

definit()
{
   if (arg(1)!='L') {
      /* Editor initialization case. */
      ginListHelp=false;
      ginFunctionHelp=false;
      gListHelp_pending=false;
      gMemberHelp_pending=false;
      gFunctionHelp_pending=false;
#if 0
      gListHelpStartCol=0;
      gListHelpNoflines=0;
      gListHelpLineNum=0;
      gListHelpStartText='';
      gListHelpEndText='';
      gListHelpIgnoreCase='';

      gListHelpSearchString='';
      gListHelpSearchPrefix='';

      gListHelp_form_wid=0;
      gMemberHelp_form_wid=0;
      geditorctl_wid=0;
      geditorctl_buf_id=0;
      gListHelp_ctltree_wid=0;
#endif
   }
}

_command void auto_functionhelp_key() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   //say("auto_functionhelp_key()");
   keyin(last_event());
   if (!command_state()) {
      left();cfg=_clex_find(0,'g');
      right();
      if ((def_codehelp_flags&VSCODEHELPFLAG_AUTO_FUNCTION_HELP) &&
         !_in_comment() && cfg!=CFG_STRING ){
         _do_function_help(true,false);
      }
   }
}
_command void auto_codehelp_key() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   //say("auto_codehelp_key()");
   keyin(last_event());
   if (!command_state()) {
      left();cfg=_clex_find(0,'g');
      right();
      if ((def_codehelp_flags&VSCODEHELPFLAG_AUTO_LIST_MEMBERS) &&
         !_in_comment() && cfg!=CFG_STRING ){
         _do_list_members(true,false);
      }
   }
}
_command void codehelp_complete() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   //say("codehelp_complete()");
   if (!command_state()) {
      errorArgs._makeempty();
      _UpdateContext(true);
      status=_EmbeddedStart(orig_values,'');
      if (!index_callable(find_index(p_extension'_proc_search',PROC_TYPE))) {
         if (status==1) {
            _EmbeddedEnd(orig_values);
         }
         expand_alias();
         return;
      }
      left();cfg=_clex_find(0,'g');
      right();
      if (!_in_comment() && cfg!=CFG_STRING) {
         _do_complete();
      } else {
         expand_alias();
      }
      if (status==1) {
         _EmbeddedEnd(orig_values);
      }
   } else {
      expand_alias();
   }
}

static void get_line_comment(_str &comments)
{
   //say("get_line_comment: ");
   comments="";
   save_pos(orig_pos);
   _end_line();
   end_seek=_nrseek();
   left();
   if (_clex_find(0,'g')!=CFG_COMMENT) {
      restore_pos(orig_pos);
      return;
   }
   linenum=p_line;
   status=_clex_skip_blanks("h-");
   if (status || linenum!=p_line) {
      restore_pos(orig_pos);
      return;
   }
   comments=strip(get_text(end_seek-(int)point('s')-1,(int)point('s')+1));
   if (pos('['p_word_chars']',substr(comments,1,1),1,'r')) {
      parse comments with . comments;
      restore_pos(orig_pos);
      return;
   }
   ext=p_extension;
   orig_view_id=_create_temp_view(temp_view_id);
   select_edit_mode(ext);
   insert_line(comments);
   insert_line("");
   // IF this is an unterminated multi-line comment
   if (_clex_find(0,'g')==CFG_COMMENT) {
      j=pos('[ 'p_word_chars']',comments,1,'r');
      if (!j) {
         comments="";
         _delete_temp_view(temp_view_id);
         activate_view(orig_view_id);
         restore_pos(orig_pos);
         return;
      }
      comments=strip(substr(comments,j));
      _delete_temp_view(temp_view_id);
      activate_view(orig_view_id);
      restore_pos(orig_pos);
      return;
   }
   j=pos('[ 'p_word_chars']',comments,1,'r');
   if (!j) {
      comments="";
      _delete_temp_view(temp_view_id);
      activate_view(orig_view_id);
      restore_pos(orig_pos);
      return;
   }
   comments=strip(substr(comments,j));
   j=lastpos('[ 'p_word_chars'.]',comments,MAXINT,'r');
   if (!j) {
      comments="";
      _delete_temp_view(temp_view_id);
      activate_view(orig_view_id);
      restore_pos(orig_pos);
      return;
   }
   comments=strip(substr(comments,1,j));
   _delete_temp_view(temp_view_id);
   activate_view(orig_view_id);
   restore_pos(orig_pos);
}
void _do_default_get_tag_comments(_str tag_type,_str &comments,
                                  int line_limit=200, boolean line_comments=true)
{
   //say("_do_default_get_tag_comments("tag_type")");
   save_pos(orig_pos);
   comments='';
   if (line_comments) {
      get_line_comment(comments);
   }
   //say("_do_default_get_tag_comments: line="comments);
   if (comments!="") {
      if (!pos("\n",comments)) strappend(comments,"\n");
      if (p_extension!='pl' && !tag_tree_type_is_func(tag_type)) {
         return;
      }
   }
   status=_do_default_get_tag_header_comments(first_line,last_line);
   //say("_do_default_get_tag_comments: first="first_line" last="last_line);
   if (status) {
      return;
   }
   Noflines=last_line-first_line+1;
   if (Noflines>line_limit) Noflines=line_limit;
   _str list[];
   _str prefix='',revprefix='';
   p_line=first_line;
   int min_non_blank_col=100;
   int first_non_blank_col=0;
   for (i=0;i<Noflines;++i) {
      line=_expand_tabsc();
      //say("_do_default_get_tag_comments: line="line);
      if (!first_non_blank_col) {
         first_non_blank_col=pos('[^ ]',line,1,'r');
         if (!first_non_blank_col) {
            down();
            continue;
         }
      } else {
         j=pos('[^ ]',line,1,'r');
         if (j && j<first_non_blank_col) {
            first_non_blank_col=j;
         }
      }
      j=first_non_blank_col;
      if (substr(line,j,1):==' ' && substr(line,j+1,1):!=' ' &&
         !pos('[<'p_word_chars']',substr(line,j+1,1),1,'r')) {
         ++j;
      }
      j=pos('[ <'p_word_chars']',line,j,'r');
      if (!j) {
         if (list._length()) {
            list[list._length()]="";
         }
         down();
         continue;
      }
      prefix=strip(substr(line,1,j-1));
      if (prefix!='' && revprefix=='') {
         revprefix = prefix;
         if (length(revprefix)==2) {
            revprefix=substr(prefix,2,1):+substr(prefix,1,1);
         }
         revprefix=stranslate(revprefix,'}','{');
         revprefix=stranslate(revprefix,')','(');
         revprefix=stranslate(revprefix,']','[');
      }
      line=strip(substr(line,j),'T');
      if (revprefix!="" && length(line)>length(revprefix) &&
          substr(line,length(line)-length(revprefix)+1):==revprefix) {
         line=strip(substr(line,1,length(line)-length(revprefix)),'T');
      } else if (prefix!="" && length(line)>length(prefix) &&
          substr(line,length(line)-length(prefix)+1):==prefix) {
         line=strip(substr(line,1,length(line)-length(prefix)),'T');
      }
      if (line!="" || list._length()) {
         list[list._length()]=line;
      }
      non_blank_col=pos('[~ ]',line,1,'r');
      if (non_blank_col && non_blank_col<min_non_blank_col) {
         min_non_blank_col=non_blank_col;
      }
      down();
   }
   while (list._length() && list[list._length()-1]=="") {
      list._deleteel(list._length()-1);
   }
   for (i=0;i<list._length();++i) {
      comments=comments:+substr(list[i],min_non_blank_col):+"\n";
   }
   restore_pos(orig_pos);
}
/*
    On entry, cursor is on line,column of tag symbol.
    
    Returns 0 if header comment found and first_line,last_line
    set.  Otherwise, 1 is returned.
*/
int _do_default_get_tag_header_comments(int &first_line,int &last_line)
{
   save_pos(orig_pos);
   for (;;) {
      up();
      if (p_line==0) {
         return(1);
      }
      get_line(line);
      if (line!="") {
         break;
      }
   }
   // skip past leading spaces
   first_non_blank();
   if (_clex_find(0,'g')!=CFG_COMMENT) {
      restore_pos(orig_pos);
      return(1);
   }
   // Search for beginning of comments
   status=_clex_skip_blanks("h-");
   if (status) {
      top();
   } else {
      _end_line();  // Skip to end of line so we don't find comment after non-blank text.
      _clex_find(COMMENT_CLEXFLAG,"O");
   }
   first_line=p_line;
   // Find end of comment
   status=_clex_skip_blanks("h");
   if (status) {
      bottom();
   }
   last_line=p_line-1;
   restore_pos(orig_pos);
   return(0);
}
int _e_is_builtin_class(typeless tag_files, _str class_name)
{
   int i = 0;
   for (;;) {
      _str tag_filename = next_tag_filea(tag_files, i, false, true);
      if (tag_filename=='') {
         break;
      }
      if (tag_find_tag(class_name, 'class', '')==0) {
         return 1;
      }
   }
   return 0;
}
static int _insert_control_name(int wid, int tree_wid, int tree_index)
{
   if (wid.p_object != OI_SSTAB_CONTAINER && wid.p_name != '') {
      tag_tree_insert_tag(tree_wid, tree_index, 0, 1, 0, wid.p_name,
                          'control', '', 0, '', 0, '');
   }
   return 0;
}
int _e_insert_context_tags(_str (&errorArgs)[],int editorctl_wid,_str prefixexp,_str lastid,_str lastid_prefix,int lastidstart_offset,_str expected_type,int info_flags,typeless otherinfo)
{
   errorArgs._makeempty();
   errorArgs[1] = lastid;
   //say("_e_insert_context_tags("prefixexp","lastid","lastid_prefix")");
   // id followed by paren, then limit search to functions
   typeless tag_files = tags_filenamea(editorctl_wid.p_extension);
   editorctl_wid._UpdateContext(true);
   editorctl_wid._UpdateLocals(true);
   int context_flags = VS_TAGCONTEXT_ANYTHING;
   boolean funcs_only = false;
   if (info_flags & VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN) {
      funcs_only = true;
      context_flags |= VS_TAGCONTEXT_ONLY_funcs;
   }

   // set up for (possibly) incremental update
   cb_prepare_expand(0, p_window_id, TREE_ROOT_INDEX);
   int status, first_index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   // Is the current symbol a property name?
   static boolean showing_properties;
   if (pos('p_',lastid)==1 && prefixexp=='') {
      // first time in, or properties not currently displayed?
      if (first_index <= 0 || !showing_properties) {
         // insert built-in properties
         showing_properties = true;
         _TreeDelete(TREE_ROOT_INDEX, 'c');
         tag_tree_select_bitmap(0 /*public*/, 9 /*CB_type_property*/, leaf_flag, pic_prop);
         _TreeSetUserInfo(TREE_ROOT_INDEX, 1); // search/sort root level
         _str filename=_FindLexerFile('Slick-C');
         int ctltree_wid=p_window_id;
         status=_ini_get_section(filename,'Slick-C',temp_view_id);
         if (status) return(1);
         int orig_view_id=p_view_id;
         p_view_id=temp_view_id;
         top();up();
         while (!search('^keywords @=','@ri>')) {
            get_line(line);
            _end_line();
            parse line with 'keywords' '=' line;
            for (;;) {
               parse line with cur line;
               if (cur=='') break;
               if (substr(cur,1,2)=='p_') {
                  ctltree_wid._TreeAddItem(TREE_ROOT_INDEX,cur,TREE_ADD_AS_CHILD,pic_prop,pic_prop,-1);
               }
            }
         }
         p_view_id=orig_view_id;
         p_window_id=ctltree_wid;
      }
      // properties are now displayed
      return 0;
   }

   _str eventtab_name = '';
   int wid=0;
   editorctl_wid.save_pos(p);
   editorctl_wid.save_search(p1,p2,p3,p4);
   if (!editorctl_wid.search('^ *defeventtab +{:v}','@-r')) {
      eventtab_name = editorctl_wid.get_text(match_length('0'),match_length('S0'));
      _str dash_eventtab_name=stranslate(eventtab_name,'-','_');
      wid=_find_formobj(dash_eventtab_name,'E');
      if (!wid) {
         wid = find_index(dash_eventtab_name,oi2type(OI_FORM));
      }
   }
   editorctl_wid.restore_search(p1,p2,p3,p4);
   editorctl_wid.restore_pos(p);

   // not just displaying properties
   if (showing_properties) {
      showing_properties = false;
      _TreeDelete(TREE_ROOT_INDEX, 'c');
      first_index = 0;
   }
   int locals_count   = 0;
   int symbols_count  = 0;
   int globals_count  = 0;
   int controls_count = 0;
   static _str    globals_lastid;
   static _str    symbols_lastid;
   static boolean symbols_truncated;
   static boolean globals_truncated;

   // no prefix expression, update globals and symbols from current context
   if (prefixexp == '') {

      int locals_root    = 0;
      int symbols_root   = 0;
      int globals_root   = 0;
      int controls_root  = 0;

      // first time here, set up categories, otherwise, find them...
      if (first_index <= 0) {
         symbols_truncated  = true;
         globals_truncated  = true;
         _TreeSetUserInfo(TREE_ROOT_INDEX, 0); // do not search/sort root level
         locals_root   = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals,   TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         controls_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_controls, TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         symbols_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_buffer,   TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         globals_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_globals,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         editorctl_wid._CodeHelpListContextLocals(p_window_id,locals_root,tag_files,
                                                  lastid,lastid_prefix,'',
                                                  VS_TAGFILTER_ANYTHING,context_flags,
                                                  locals_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
      } else {
         symbols_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_buffer);
         globals_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_globals);
         locals_root   = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals);
         controls_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_controls);
         if (locals_root > 0) {
            locals_count = _TreeGetNumChildren(locals_root);
         }
         if (controls_root > 0) {
            controls_count = _TreeGetNumChildren(controls_root);
         }
      }

      // update the list of controls currently visible in the current event table
      if (controls_root > 0) {
         if (wid) {
            tag_tree_insert_tag(p_window_id, controls_root, 0, 1, 0, eventtab_name,
                                'form', '', 0, '', 0, '');
            _for_each_control(wid,_insert_control_name,'H',p_window_id, controls_root);
         }
         controls_count = _TreeGetNumChildren(controls_root);
         if (controls_count == 0) {
            _TreeDelete(controls_root);
         }
      } 

      // update the symbols from current buffer, give case-sensitive matches preference
      if (symbols_truncated || pos(symbols_lastid, lastid_prefix)!=1) {
         if (symbols_root > 0) {
            _TreeBeginUpdate(symbols_root);
            _str no_tag_files[]; no_tag_files._makeempty();
            editorctl_wid._CodeHelpListContextGlobals(p_window_id,symbols_root,true,no_tag_files,
                                                      lastid,lastid_prefix,VS_TAGFILTER_ANYTHING,
                                                      context_flags,symbols_count,
                                                      VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            _TreeEndUpdate(symbols_root);
         }
         symbols_lastid = lastid_prefix;
         symbols_truncated = (symbols_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      } else {
         symbols_count = 1;
      }

      // update the globals, make sure that case-sensitive matches get preference
      if (globals_truncated || pos(globals_lastid, lastid_prefix)!=1) {
         if (globals_root > 0) {
            _TreeBeginUpdate(globals_root);
            editorctl_wid._CodeHelpListContextGlobals(p_window_id,globals_root,true,tag_files,
                                                      lastid,lastid_prefix,VS_TAGFILTER_ANYTHING,
                                                      context_flags,globals_count,
                                                      VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            //// Slick-C builtins, just dump them in 'globals'
            if (globals_count < VSCODEHELP_MAXLISTGLOBALSYMBOLS) {
               editorctl_wid.tag_list_in_file(p_window_id, globals_root, lastid, tag_files,
                                              "builtins.e", VS_TAGFILTER_PROTO,
                                              context_flags|VS_TAGCONTEXT_ONLY_non_static,
                                              globals_count, VSCODEHELP_MAXLISTGLOBALSYMBOLS,
                                              false, true);
               editorctl_wid.tag_list_in_file(p_window_id, globals_root, lastid, tag_files,
                                              "builtins.e", VS_TAGFILTER_PROTO, 
                                              context_flags|VS_TAGCONTEXT_ONLY_non_static,
                                              globals_count, VSCODEHELP_MAXLISTGLOBALSYMBOLS,
                                              false, false);                  
            }
            _TreeEndUpdate(globals_root);
         }
         globals_lastid = lastid_prefix;
         globals_truncated = (globals_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      } else {
         globals_count = 1;
      }

      // all done
      int total_count = symbols_count+locals_count+globals_count+controls_count;
      return (total_count>0)? 0 : VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }

   // prefixexp is not empty, try to ascertain its type and list symbols matching
   if (first_index <= 0) {
      symbols_truncated  = true;
   }
   if (symbols_truncated || symbols_lastid != lastid_prefix) {
      _str match_class='';
      int pointer_count=0;
      int c_return_flags=0;
      _str dummy_tag='';
      status = editorctl_wid._c_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                                   false, pointer_count,
                                                   c_return_flags, dummy_tag);
      //say("match_class="match_class" status="status);
      if (status && status != VSCODEHELPRC_NO_SYMBOLS_FOUND &&
          status != VSCODEHELPRC_RETURN_TYPE_NOT_FOUND) {
         sybols_lastid = lastid_prefix;
         return status;
      }
      _TreeSetUserInfo(TREE_ROOT_INDEX, 1); // search/sort root level
      _TreeBeginUpdate(TREE_ROOT_INDEX);
      if (!status && match_class != '') {
         editorctl_wid._ListSymbolsInClass(lastid_prefix, match_class, 
                                           p_window_id, TREE_ROOT_INDEX, 0,
                                           symbols_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                           VS_TAGFILTER_ANYTHING, 
                                           VS_TAGCONTEXT_ACCESS_private,
                                           false, true);
         int match_symbols = symbols_count;
         editorctl_wid._ListSymbolsInClass('', match_class, 
                                           p_window_id, TREE_ROOT_INDEX, 0,
                                           symbols_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                           VS_TAGFILTER_ANYTHING, 
                                           VS_TAGCONTEXT_ACCESS_private,
                                           false, true);
         if (_e_is_builtin_class(tag_files,match_class)) {
            // form widget, list controls
            if (prefixexp == eventtab_name'.') {
               _for_each_control(wid,_insert_control_name,'H',p_window_id, TREE_ROOT_INDEX);
               symbols_count = _TreeGetNumChildren(TREE_ROOT_INDEX);
            }
            // find procs that belong to the control
            int i=tag_find_context(prefixexp, false, true);
            while (i > 0) {
               tag_get_detail2(VS_TAGDETAIL_context_type, i, type_name);
               if (tag_tree_type_is_func(type_name)) {
                  tag_get_detail2(VS_TAGDETAIL_context_name, i, tag_names);
                  tag_get_detail2(VS_TAGDETAIL_context_args, i, signature);
                  tag_get_detail2(VS_TAGDETAIL_context_flags, i, tag_flags);
                  tag_names = substr(tag_names, length(prefixexp)+1);
                  while (tag_names != '') {
                     parse tag_names with tag_name ',' tag_names;
                     if (tag_name != '') {
                        tag_tree_insert_tag(p_window_id,TREE_ROOT_INDEX,0,1,0,tag_name,type_name,'',0,'',tag_flags,signature);
                        symbols_count++;
                     }
                  }
               }
               i=tag_next_context(prefixexp, false, true);
            }
            if (match_symbols==0) {
               editorctl_wid.tag_list_context_globals(p_window_id, TREE_ROOT_INDEX,
                                                      lastid_prefix,true,tag_files,
                                                      VS_TAGFILTER_ANYPROC,VS_TAGCONTEXT_ANYTHING,
                                                      symbols_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                                      false, true);
               editorctl_wid.tag_list_context_globals(p_window_id, TREE_ROOT_INDEX,
                                                      lastid_prefix,true,tag_files,
                                                      VS_TAGFILTER_ANYPROC,VS_TAGCONTEXT_ANYTHING,
                                                      symbols_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                                      false, false);
            }
         }
      }
      // no matches found yet, just do a prefix match on 'lastid'
      if (symbols_count==0) {
         if (wid) {
            _for_each_control(wid,_insert_control_name,'H',p_window_id, TREE_ROOT_INDEX);
            symbols_count = _TreeGetNumChildren(TREE_ROOT_INDEX);
         }
         editorctl_wid._CodeHelpListAnySymbols(p_window_id, TREE_ROOT_INDEX, tag_files,
                                               lastid, lastid_prefix,
                                               VS_TAGFILTER_ANYTHING, VS_TAGCONTEXT_ANYTHING,
                                               symbols_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
      }
      _TreeEndUpdate(TREE_ROOT_INDEX);
      // update statics for next time in
      symbols_lastid = lastid_prefix;
      symbols_truncated = (symbols_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      errorArgs[1]=lastid;
      return (symbols_count>0)? 0 : VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }

   return 0;
}

int default_insert_context_tags(_str (&errorArgs)[],int editorctl_wid,_str prefixexp,_str lastid,_str lastid_prefix,int lastidstart_offset,_str expected_type,int info_flags,typeless otherinfo)
{
   errorArgs._makeempty();
   //say("default_insert_context_tags("prefixexp","lastid","lastid_prefix")");
   // id followed by paren, then limit search to functions
   typeless tag_files = tags_filenamea(editorctl_wid.p_extension);
   editorctl_wid._UpdateContext(true);
   editorctl_wid._UpdateLocals(true);

   // set up for (possibly) incremental update
   cb_prepare_expand(0, p_window_id, TREE_ROOT_INDEX);
   int status, first_index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
                            
   int locals_count   = 0;
   int symbols_count  = 0;
   int globals_count  = 0;

   // no prefix expression, update globals and symbols from current context
   static _str    globals_lastid;
   static _str    symbols_lastid;
   static boolean symbols_truncated;
   static boolean globals_truncated;
   int locals_root    = 0;
   int symbols_root   = 0;
   int globals_root   = 0;

   // first time here, set up categories, otherwise, find them...
   if (first_index <= 0) {
      symbols_truncated  = true;
      globals_truncated  = true;
      _TreeSetUserInfo(TREE_ROOT_INDEX, 0); // do not search/sort root level
      int list_locals_index = find_index(editorctl_wid.p_extension"_list_locals", PROC_TYPE);
      if (index_callable(list_locals_index)) {
         locals_root   = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals,   TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         editorctl_wid._CodeHelpListContextLocals(p_window_id,locals_root,tag_files,
                                                  lastid,lastid_prefix,'',
                                                  VS_TAGFILTER_ANYTHING,VS_TAGCONTEXT_ANYTHING,
                                                  locals_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
      }
      symbols_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_buffer,   TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
      globals_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_globals,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
   } else {
      symbols_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_buffer);
      globals_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_globals);
      locals_root   = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals);
      if (locals_root > 0) {
         locals_count = _TreeGetNumChildren(locals_root);
      }
   }

   // update the globals, make sure that case-sensitive matches get preference
   if (globals_truncated || pos(globals_lastid, lastid_prefix)!=1) {
      if (globals_root > 0) {
         _TreeBeginUpdate(globals_root);
         editorctl_wid._CodeHelpListContextGlobals(p_window_id,globals_root,true,tag_files,
                                                   lastid,lastid_prefix,VS_TAGFILTER_ANYTHING,
                                                   VS_TAGCONTEXT_ONLY_non_static,
                                                   globals_count, VSCODEHELP_MAXLISTGLOBALSYMBOLS);
         _TreeEndUpdate(globals_root);
      }
      globals_lastid = lastid_prefix;
      globals_truncated = (globals_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
   }

   // update the symbols from current buffer, give case-sensitive matches preference
   if (symbols_truncated || pos(symbols_lastid, lastid_prefix)!=1) {
      if (symbols_root > 0) {
         _TreeBeginUpdate(symbols_root);
         _str no_tag_files[]; no_tag_files._makeempty();
         editorctl_wid._CodeHelpListContextGlobals(p_window_id,symbols_root,
                                                   true,no_tag_files,lastid,lastid_prefix,
                                                   VS_TAGFILTER_ANYTHING,VS_TAGCONTEXT_ANYTHING,
                                                   symbols_count, VSCODEHELP_MAXLISTGLOBALSYMBOLS);
         if (symbols_count+globals_count+locals_count==0) {
            editorctl_wid.tag_list_context_globals(p_window_id, symbols_root, '',
                                                   true, no_tag_files, VS_TAGFILTER_ANYTHING,
                                                   VS_TAGCONTEXT_ANYTHING, symbols_count,
                                                   VSCODEHELP_MAXLISTGLOBALSYMBOLS,
                                                   false, false);
         }
         _TreeEndUpdate(symbols_root);
      }
      symbols_lastid = lastid_prefix;
      symbols_truncated = (symbols_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
   }

   // all done
   errorArgs[1] = lastid;
   int total_count = symbols_count+locals_count+globals_count;
   return (total_count>0)? 0 : VSCODEHELPRC_NO_SYMBOLS_FOUND;
}

int _do_default_fcthelp_get(  _str (&errorArgs)[],
                      VSAUTOCODE_ARG_INFO (&FunctionHelp_list)[],
                      boolean &FunctionHelp_list_changed,
                      int &FunctionHelp_cursor_x,
                      _str &FunctionHelp_HelpWord,
                      int FunctionNameStartOffset,
                      int flags
                      )
{
   return(_c_fcthelp_get(errorArgs,
                         FunctionHelp_list,FunctionHelp_list_changed,
                         FunctionHelp_cursor_x,
                         FunctionHelp_HelpWord,
                         FunctionNameStartOffset,flags));
}
int _do_default_fcthelp_get_start(_str (&errorArgs)[],
                            boolean OperatorTyped,
                            boolean cursorInsideArgumentList,
                            int &FunctionNameOffset,
                            int &ArgumentStartOffset,
                            int &flags
                           )
{
   return(_c_fcthelp_get_start(errorArgs,OperatorTyped,cursorInsideArgumentList,FunctionNameOffset,ArgumentStartOffset,flags));
}
void _do_function_help(boolean OperatorTyped,boolean DisplayImmediate,boolean cursorInsideArgumentList=false)
{
   //say("_do_function_help: ");
   if (ginFunctionHelp) {
      still_in_code_help();
   }
   if (ginListHelp) {
      TerminateListHelp(false);
   }
   if (ginFunctionHelp) {
      return;
   }
   ext=p_extension;
   MaybeBuildTagFile(ext);
   //TerminateCodeHelp(0,0);
   index=find_index('_'ext'_fcthelp_get_start',PROC_TYPE);
   if ( !index) {
#if 1
      return;
#else
      editorctl_wid=p_window_id;
      save_pos(orig_pos);
      status=_do_default_fcthelp_get_start(errorArgs,
                        OperatorTyped,
                        cursorInsideArgumentList,
                        FunctionNameOffset,
                        ArgumentStartOffset,
                        flags
                        );
#endif
                        
   } else {
      editorctl_wid=p_window_id;
      save_pos(orig_pos);
      status=call_index(errorArgs,
                        OperatorTyped,
                        cursorInsideArgumentList,
                        FunctionNameOffset,
                        ArgumentStartOffset,
                        flags,
                        index);
   }
   if (status) {
      if (!OperatorTyped) {
         msg=_CodeHelpRC(status,errorArgs);
         if (msg!='') {
            _message_box(msg);
         }
      }
      restore_pos(orig_pos);
      return;
   }
   if (_chdebug) {
      _message_box('fct_help_get_start: fnoffset='FunctionNameOffset' argstartofs='ArgumentStartOffset);
   }
   if (OperatorTyped) {
      flags |= VSAUTOCODEINFO_OPERATOR_TYPED;
   }
   goto_point(FunctionNameOffset);
   gFunctionHelp_OperatorTyped=OperatorTyped;
   gFunctionHelp_FirstCall=true;
   gFunctionHelp_FunctionNameOffset=FunctionNameOffset;
   gFunctionHelp_FunctionLineOffset=(int)point();
   gFunctionHelp_starttext=get_text(ArgumentStartOffset-gFunctionHelp_FunctionLineOffset,gFunctionHelp_FunctionLineOffset);
   gFunctionHelp_flags=flags;
   restore_pos(orig_pos);

   geditorctl_wid=p_window_id;
   geditorctl_buf_id=p_buf_id;
   p_ModifyFlags&=~MODIFYFLAG_FCTHELP_UPDATED;

   gFunctionHelp_list._makeempty();
   gFunctionHelp_fcthelp_get=find_index('_'ext'_fcthelp_get',PROC_TYPE);
   if ( !gFunctionHelp_fcthelp_get) {
#if 1
      return;
#else
      gFunctionHelp_fcthelp_get=find_index('_do_default_fcthelp_get',PROC_TYPE);
#endif
   }
   //DisplayImmediate=true;

   gFunctionHelp_form_wid=0;
   ginFunctionHelp=true;
   if (!DisplayImmediate && def_codehelp_idle) {
      gFunctionHelp_pending=true;
   } else {
      _update_function_help();
   }

   //TerminateCodeHelp(0,0);
}
static void TerminateFunctionHelp(boolean inOnDestroy)
{
   if (!ginFunctionHelp) return;
   if (_iswindow_valid(gFunctionHelp_form_wid)) {
      if (!inOnDestroy) {
         //focus_wid=_get_focus();
         gFunctionHelp_form_wid._delete_window();
         /*if (focus_wid && focus_wid!=gFunctionHelp_form_wid) {
            focus_wid._set_focus();
         } */
      }
   }
   gFunctionHelp_form_wid=0;
   ginFunctionHelp=0;
   if (_iswindow_valid(geditorctl_wid) &&
       geditorctl_wid._isEditorCtl() && !ginListHelp) {
      geditorctl_wid._RemoveEventtab(defeventtab codehelp_keys);
      geditorctl_wid=0;
   }
}
void _AddEventtab(int add_eventtab_index)
{
   count=0;
   etab_index=p_eventtab;
   found=false;
   for (;count<20;++count) {
      if (!etab_index) {
         break;
      }
      if (etab_index==add_eventtab_index) {
         found=true;
         break;
      }
      etab_index=eventtab_inherit(etab_index);
   }
   if (!found) {
      etab_index=p_eventtab;
      p_eventtab=add_eventtab_index;
      eventtab_inherit(add_eventtab_index,etab_index);
   }
   //say('add 'name_name(p_eventtab));
}
void _RemoveEventtab(int add_eventtab_index)
{
   count=0;
   prev_eventtab_index=0;
   etab_index=p_eventtab;
   found=false;
   for (;count<20;++count) {
      if (!etab_index) {
         break;
      }
      if (etab_index==add_eventtab_index) {
         found=true;
         break;
      }
      prev_eventtab_index=etab_index;
      etab_index=eventtab_inherit(etab_index);
   }
   if (!found) {
      return;
   }
   if (prev_eventtab_index) {
      eventtab_inherit(prev_eventtab_index,eventtab_inherit(add_eventtab_index));
   } else {
      p_eventtab=eventtab_inherit(add_eventtab_index);
   }
   //say('remove 'name_name(p_eventtab));
}
_str _CodeHelpCurWord(boolean &allHelpWorkDone)
{
   //say("_CodeHelpCurWord: ");
   allHelpWorkDone=false;
   if (!ginFunctionHelp || gFunctionHelp_FirstCall) {
      return("");
   }
   return(gFunctionHelp_HelpWord);
}
void _update_function_help()
{
   if ((p_ModifyFlags & MODIFYFLAG_FCTHELP_UPDATED) && 
       gFunctionHelp_UpdateLineNumber==p_line && 
       gFunctionHelp_UpdateLineCol==p_col
       ) {
      return;
   }
   status=call_index(errorArgs,
                     gFunctionHelp_list,
                     FunctionHelp_list_changed,
                     FunctionHelp_cursor_x,
                     gFunctionHelp_HelpWord,
                     gFunctionHelp_FunctionNameOffset,
                     gFunctionHelp_flags,
                     gFunctionHelp_fcthelp_get);
   if (status) {
      if (!gFunctionHelp_OperatorTyped &&
          (gFunctionHelp_FirstCall|| status!=VSCODEHELPRC_NOT_IN_ARGUMENT_LIST)) {
         msg=_CodeHelpRC(status,errorArgs);
         if (msg!='') {
            message(msg);
         }
      }
      TerminateCodeHelp(0,0);
      return;
   }
   gFunctionHelp_FirstCall=false;
   if (!gFunctionHelp_form_wid) {
      gFunctionHelp_form_wid=geditorctl_wid.show('-hidden -nocenter _function_help_form');
      FunctionHelp_list_changed=1;
   }
   p_ModifyFlags|=MODIFYFLAG_FCTHELP_UPDATED;
   gFunctionHelp_UpdateLineNumber=p_line;
   gFunctionHelp_UpdateLineCol=p_col;
   
   if (!FunctionHelp_list_changed /*&& ParamNum==gFunctionHelp_ParamNum */&&
       //gFunctionHelp_cursor_y==geditorctl_wid.p_cursor_y
       gFunctionHelp_cursor_y>=geditorctl_wid.p_cursor_y &&
       gFunctionHelp_form_wid.p_visible
       ) {
      return;
   }
   //say(!FunctionHelp_list_changed' '(ParamNum==gFunctionHelp_ParamNum)' '(gFunctionHelp_cursor_y>=geditorctl_wid.p_cursor_y)' 'gFunctionHelp_form_wid.p_visible);
   new_cursor_y=geditorctl_wid.p_cursor_y;
   if (!FunctionHelp_list_changed /*&& ParamNum!=gFunctionHelp_ParamNum */&&
       gFunctionHelp_cursor_y>=geditorctl_wid.p_cursor_y) {
      new_cursor_y=gFunctionHelp_cursor_y;
   }
   //gFunctionHelp_ParamNum=ParamNum;
   //say(FunctionHelp_list_changed' pn='ParamNum' 'gFunctionHelp_ParamNum' y='gFunctionHelp_cursor_y' 'geditorctl_wid.p_cursor_y);
   geditorctl_wid._AddEventtab(defeventtab codehelp_keys);
   text="";
   // Encode bold and italic args
   for (i=0;i<gFunctionHelp_list._length();++i) {
      jcount=gFunctionHelp_list[i].argstart._length();
      ParamNum=gFunctionHelp_list[i].ParamNum;
      if (ParamNum<0 || ParamNum>=jcount) {
         text=text:+gFunctionHelp_list[i].prototype:+"\n";
      } else {
         prototype=gFunctionHelp_list[i].prototype;
         start=gFunctionHelp_list[i].argstart[ParamNum];
         len=gFunctionHelp_list[i].arglength[ParamNum];
         text=text:+substr(prototype,1,start-1):+
            "\1<b>":+substr(prototype,start,len):+"\1</b>":+substr(prototype,start+len):+"\n";
      }
   }
   text=stranslate(text,'&&','&');
   //_message_box('text='text);
   gFunctionHelp_cursor_y=new_cursor_y;
   _nocheck _control picture1;
   gFunctionHelp_form_wid.picture1._DisplayFunctionHelp(
                        text,',',
                        (_twips_per_pixel_x()*4),(_twips_per_pixel_y()*2),
                        ((_screen_width()*_twips_per_pixel_x()) intdiv 3)*2,//_dx2lx(SM_TWIP,200),
                        _default_font(CFG_FUNCTION_HELP),
                        0x80000020,0x80000021,
                        ((_screen_height()*_twips_per_pixel_y()) intdiv 8),
                        200,
                        F_BOLD);
   _PositionNoFocusForm(geditorctl_wid,gFunctionHelp_form_wid,FunctionHelp_cursor_x,gFunctionHelp_cursor_y,p_font_height,0);
   gFunctionHelp_form_wid._ShowWindow(SW_SHOWNOACTIVATE);
}
// Current object needs to be editor control
// Returns 1 if this tag is on the kill list and operator typed.
int _check_killfcts(_str tag_name, _str class_name, int flags)
{
   // check if the symbol was on the kill list for this extension
   if (flags & VSAUTOCODEINFO_OPERATOR_TYPED) {
      //say("check kill list, symbol="match_symbol" class="match_class);
      _str search_class  = (class_name=='')? '' : class_name:+VS_TAGSEPARATOR_class;
      _str search_string = PATHSEP:+search_class:+tag_name:+PATHSEP;
      int Kindex=find_index('def-killfcts-'p_extension,MISC_TYPE);
      if (Kindex && pos(search_string, PATHSEP:+name_info(Kindex):+PATHSEP)) {
         // skip this one, it is on the kill list
         return 1;
      }
   }
   return 0;
}
int _OnUpdate_list_symbols(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED);
   }
   status=(index_callable(find_index(p_extension'_proc_search',PROC_TYPE)) );
   if (status) {
      return(MF_ENABLED);
   }
   return(MF_GRAYED);
}
_command void list_symbols() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   //say("list_symbols: ");
   if (_get_focus()!=p_window_id) {
      _beep();
      return;
   }
   _macro_delete_line();
   _do_list_members(false,true);
}
int _OnUpdate_function_argument_help(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED);
   }
   status=(index_callable(find_index('_'p_extension'_fcthelp_get_start',PROC_TYPE)) );
   if (status) {
      return(MF_ENABLED);
   }
   return(MF_GRAYED);
}
_command void function_argument_help() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   if (_get_focus()!=p_window_id) {
      _beep();
      return;
   }
   _do_function_help(false,true,true);
}
int _do_default_get_idexp(_str (&errorArgs)[],
                 boolean PossibleOperator,
                 _str &prefixexp,
                 _str &lastid,int &lastidstart_col,
                 int &lastidstart_offset,
                 int &info_flags,
                 typeless &otherinfo
                )
{
   errorArgs._makeempty();
   prefixexp='';
   lastid='';
   otherinfo="";
   info_flags=VSAUTOCODEINFO_DO_LIST_MEMBERS;
   save_pos(orig_pos);
   if (PossibleOperator) {
      left();
      ch=get_text();
      if (ch=='(') {
         info_flags=VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN|VSAUTOCODEINFO_DO_FUNCTION_HELP;
      } else {
         info_flags=VSAUTOCODEINFO_DO_FUNCTION_HELP;
      }
      lastidstart_col=p_col;  // need this for function pointer case
      left();
      search('[~ \t]|^','-r@');
      // maybe there was a function pointer expression
      if (pos('[~'p_word_chars']',get_text(),1,'r')) {
         restore_pos(orig_pos);
         //say("ID returns 1");
         return(1);
      }
      end_col=p_col+1;
      search('[~'p_word_chars']\c|^\c','-r@');
      lastid=_expand_tabsc(p_col,end_col-p_col);
      lastidstart_col=p_col;
      lastidstart_offset=(int)point('s');
   } else {
      // IF we are not on an id character.
      ch=get_text();
      done=0;
      // IF we are not on an id character.
      if (pos('[~'p_word_chars']',get_text(),1,'r')) {
         int first_col = 1;
         if (p_col > 1) {
            first_col=0;
            left();
         }
         if (pos('[~'p_word_chars']',get_text(),1,'r')) {
            right();
            if (get_text()=='(') {
               info_flags|=VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN;
            }
            prefixexp='';
            lastid="";
            lastidstart_col=p_col-first_col;
            lastidstart_offset=(int)point('s');
            done=1;
         }
      } 
      if(!done) {
         search('[~'p_word_chars']|$','r@');
         end_col=p_col;
         // Check if this is a function call
         search('[~ \t]|$','r@');
         if (get_text()=='(') {
            info_flags|=VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN;
         } 
         p_col=end_col;

         left();
         search('[~'p_word_chars']\c|^\c','-r@');
         lastid=_expand_tabsc(p_col,end_col-p_col);
         lastidstart_col=p_col;
         lastidstart_offset=(int)point('s');
      }
   }
   restore_pos(orig_pos);
   return(0);
}
//_command void test1() name_info(','VSARG2_CMDLINE|VSARG2_EDITORCTL)
void _do_list_members(boolean OperatorTyped,boolean DisplayImmediate)
{
   //say("do_list_members("OperatorTyped","DisplayImmediate);
   int cfg = 0;
   if (OperatorTyped) {
      left();
      cfg=_clex_find(0,'g');
      right();
   } else {
      cfg=_clex_find(0,'g');
   }
   if (_in_comment() || cfg==CFG_STRING) {
      if (!OperatorTyped) {
         message('List members not supported in string or comment');
      }
      return;
   }

   _str ext=p_extension;
   if (!find_index(ext'_proc_search',PROC_TYPE)) {
      return;
   }
   MaybeBuildTagFile(ext);

   get_idexp_index=find_index('_'ext'_get_idexp',PROC_TYPE);
   if (!get_idexp_index) {
      //_message_box('Auto function help not supported for this language');
      //status=call_index(false,prefixexp,lastid,lastidstart_col,info_flags,get_idexp_index);
      status=_do_default_get_idexp(errorArgs,
                        OperatorTyped,
                        prefixexp,
                        lastid,
                        lastidstart_col,
                        lastidstart_offset,
                        info_flags,
                        otherinfo
                        );
     
   } else {
      //status=call_index(false,prefixexp,lastid,lastidstart_col,info_flags,get_idexp_index);
      status=call_index(errorArgs,
                        OperatorTyped,
                        prefixexp,
                        lastid,
                        lastidstart_col,
                        lastidstart_offset,
                        info_flags,
                        otherinfo,
                        get_idexp_index);
   }
   if (status) {
      if (!OperatorTyped) {
         msg=_CodeHelpRC(status,errorArgs);
         if (msg!='') {
            _message_box(msg);
         }
      }
      return;
   }
   if (OperatorTyped) {
      info_flags |= VSAUTOCODEINFO_OPERATOR_TYPED;
   }
   if (_chdebug) {
      refresh();
      _message_box('prefixexp='prefixexp' lastid='lastid' lastidstart_col='lastidstart_col' info_flags='dec2hex(info_flags)' otherinfo='otherinfo);
   }
   if (OperatorTyped && _modename_eq(p_mode_name,"slick-c")) {
      // don't go into function help on leading underscore
      if (lastid=='_') {
         //say("leading underscore");
         return;
      }
      // slick-c, toss out '_' if already in list help
      if (last_char(lastid)=='_' && ginListHelp) {
         //say("already in list help, lastid="lastid);
         return;
      }
      // slick-c, only process '_', do nothing with '.'
      //if (last_char(last_id):!='_') {
      //   say("_ is not trailing, lastid="lastid" lc="last_char(lastid));
      //   return;
      //}
   }
   if (ginFunctionHelp && gFunctionHelp_pending 
       /*!OperatorTyped || DisplayImmediate || !def_codehelp_idle*/
       ) {
      TerminateFunctionHelp(false);
   }
   TerminateListHelp(false);

   gListHelp_prefixexp=prefixexp;
   gListHelp_lastid=lastid;
   gListHelp_lastidstart_col=lastidstart_col;
   gListHelp_lastidstart_offset=lastidstart_offset;
   gListHelp_info_flags=info_flags;
   gListHelp_expected_type='';
   gListHelp_otherinfo=otherinfo;
   gListHelp_OperatorTyped=OperatorTyped;

   gListHelp_insert_tags_index=find_index('_'ext'_insert_context_tags',PROC_TYPE);
   if ( !gListHelp_insert_tags_index) {
      gListHelp_insert_tags_index=find_index('default_insert_context_tags',PROC_TYPE);
      if ( !gListHelp_insert_tags_index) {
         return;
      }
   }
   gListHelp_form_wid=0;
   gMemberHelp_form_wid=0;
   StartListHelp(ext,gListHelp_lastid,gListHelp_lastidstart_col);
   if (!DisplayImmediate && def_codehelp_idle) {
      gListHelp_pending=true;
      gMemberHelp_pending=false;
   } else {
      gListHelp_pending=false;
      gMemberHelp_pending=false;
      _update_list_help();
   }
}
//_command void test1() name_info(','VSARG2_CMDLINE|VSARG2_EDITORCTL)
void _do_complete()
{    
   //say("_do_complete()");

   // check the current context, don't try it within string or comment
   int cfg=_clex_find(0,'g');
   if (_in_comment() || cfg==CFG_STRING) {
      if (expand_alias()) {
         message('Tag completion not supported in string or comment');
      }
      return;
   }

   // do we have a proc-search function?
   ext=p_extension;
   if (!find_index(ext'_proc_search',PROC_TYPE)) {
      expand_alias();
      return;
   }

   // do we have tag files set up for this extension?
   MaybeBuildTagFile(ext);

   // match the tag at the current position
   _str lastid = ''; 
   tag_clear_matches();
   int i, num_matches = context_match_tags(lastid,false,VSCODEHELP_MAXFINDCONTEXTTAGS,false,false);
   if (!num_matches) {
      errorArgs[1]=lastid;
      msg=_CodeHelpRC(VSCODEHELPRC_NO_SYMBOLS_FOUND,errorArgs);
      if (expand_alias() && msg!='') {
         message(msg);
      }
      return;
   }

   // force list symbols if it appears that the list was truncated
   if (num_matches >= VSCODEHELP_MAXFINDCONTEXTTAGS) {
      list_symbols();
      return;
   }

   // look for exact matches in the match set
   int lastid_len=length(lastid);
   _str longest_prefix = '';
   _str longest_caption = '';
   if (num_matches > 0) {
      tag_get_detail2(VS_TAGDETAIL_match_name, 1, longest_caption);
      longest_prefix = longest_caption;
   }
   for (i=2; i<=num_matches; i++) {
      tag_get_detail2(VS_TAGDETAIL_match_name, i, tag_name);
      while (longest_prefix != '' && !pos(longest_prefix, tag_name, 1, 'i')) {
         longest_prefix = substr(longest_prefix, 1, length(longest_prefix)-1);
      }
      if (length(tag_name) > length(longest_caption)) {
         longest_caption = tag_name;
      }
   }
   
   // replace the word with completed or partially completed word
   if (length(longest_prefix) >= length(lastid) && longest_prefix:!=lastid) {
      p_col=_text_colc(p_col-lastid_len,"i");
      word=cur_word(p_col);
      //say("word="word" p_col="p_col" lastid="lastid);
      _delete_text(length(word));
      _insert_text(longest_prefix);
   } else if (num_matches <= 1 || length(longest_caption) <= length(longest_prefix)) {
      if (p_extension=='e') {
         expand_alias();
      }
   }

   // force list symbols if the result is not an exact tag match
   if (num_matches > 1 && length(longest_caption)>length(longest_prefix)) {
      list_symbols();
   }
}
static void StartListHelp(_str ext,_str lastid,int lastidstart_col)
{
   ginListHelp=true;
   gListHelpStartCol=lastidstart_col;
   gListHelpNoflines=p_Noflines;
   gListHelpLineNum=p_line;
   gListHelpNewSearchString=gListHelpSearchString=lastid;
   gListHelpNewSearchPrefix=gListHelpSearchPrefix=substr(lastid,1,p_col-lastidstart_col);
   gListHelpStartText=_expand_tabsc(1,gListHelpStartCol-1);
   //_message_box(gListHelpStartCol' 'gListHelpStartText);
   gListHelpEndText=_expand_tabsc(gListHelpStartCol+length(gListHelpSearchString));

   geditorctl_wid=p_window_id;
   geditorctl_buf_id=p_buf_id;
   //ext=p_extension;
   gListHelpIgnoreCase=(p_LangCaseSensitive)?'':'I';
   /*gListHelpIgnoreCase=tag_case('',ext);
   if (upcase(gListHelpIgnoreCase)!='I') {
      gListHelpIgnoreCase='';
   } */
}
// Return the index of the current list help category
static int _curr_list_help_category()
{
   int index = _TreeCurIndex();
   if (index <= 0) {
      return TREE_ROOT_INDEX;
   }
   parent = _TreeGetParentIndex(index);
   while (parent != TREE_ROOT_INDEX) {
      index = parent;
      parent = _TreeGetParentIndex(index);
   }
   return index;
}
// Current object needs to be tree control for list members help
// Tries to find an exact match, case sensitivity defined by
// language mode.  If no match is found, tries to match case-
// insensitive using a prefix match.
static int _find_list_help_item(_str prefix, boolean &unique, boolean best_match=true)
{
   //say("_find_list_help_item: prefix="prefix"=");
   // no prefix to match?
   unique = false;
   if (prefix == '') {
      return -1;
   }

   // select a starting searh point
   typeless uinfo = _TreeGetUserInfo(TREE_ROOT_INDEX);
   boolean search_root = (uinfo._isempty() || uinfo!=1)? false : true;
   boolean ignore_case = (gListHelpIgnoreCase == '')? false : true;
   int root = (search_root)? TREE_ROOT_INDEX : _curr_list_help_category();
   //say("_find_list_help_item: root="root);
                     
   // check the currently selected item against prefix first
   static _str last_prefix;
   int curr_index = _TreeCurIndex();
   if (search_root || (curr_index > 0 && _TreeGetParentIndex(curr_index) > 0)) {
      caption = _TreeGetCaption(curr_index);
      if (pos(last_prefix, prefix)==1 && (pos(prefix, caption)==1 || (ignore_case && pos(prefix, caption, 1, 'i')==1))) {
         //say("_find_list_help_item: using current index");
         last_prefix = prefix;
         return curr_index;
      }
   }
   last_prefix = prefix;
 
   // first look for match in the 'current' subtree
   int index;
   int exact_match   = -1;
   int prefix_match  = -1;
   int case_match    = -1;
   int lowcase_match = -1;
   if (root > 0) {
      index = _TreeSearch(root, prefix, 'PIT');
      while (index > 0) {
         //say("_find_list_help_item: found in current tree="index);
         caption = _TreeGetCaption(index);
         parse caption with caption '(' .;
         if (caption :== prefix) {
            if (exact_match > 0) {
               return exact_match;
            }
            exact_match = index;
         }
         if (ignore_case && lowcase_match < 0 && !stricmp(caption,prefix)) {
            lowcase_match = index;
         }
         if (case_match < 0 && pos(prefix, caption)==1) {
            case_match = index;
         }
         if (prefix_match < 0) {
            prefix_match = index;
         }
         index = _TreeSearch(index, prefix, 'PITS');
      }
   }

   // If we found an exact match, then we are done
   if (exact_match > 0) {
      //say("UNIQUE");
      unique = true;
      return exact_match;
   }
   
   // next look for match somewhere in the entire tree
   if (prefix_match<0 || best_match) {
      index = _TreeSearch(TREE_ROOT_INDEX, prefix, 'PIT');
      while (index > 0) {
         //say("_find_list_help_item: found in entire tree, index="index);
         if (search_root || _TreeGetParentIndex(index) != TREE_ROOT_INDEX) {
            caption = _TreeGetCaption(index);
            parse caption with caption '(' .;
            if (caption :== prefix) {
               if (exact_match > 0) {
                  return exact_match;
               }
               exact_match = index;
            } else if (ignore_case && lowcase_match < 0 && !stricmp(caption,prefix)) {
               lowcase_match = index;
            } else if (case_match < 0 && pos(prefix, caption)==1) {
               case_match = index;
            } else if (prefix_match < 0) {
               prefix_match = index;
            }
         }
         index = _TreeSearch(index, prefix, 'PITS');
      }
   }
   
   // select result to return, best result is unique, exact, case-sensitive match
   if (exact_match > 0) {
      //say("UNIQUE");
      unique = true;
      return exact_match;
   }
   // next best is an exact, but case-insensitive match
   if (lowcase_match > 0) {
      return lowcase_match;
   }
   // next best is a case sensitive prefix match
   if (case_match > 0) {
      return case_match;
   }
   // next best is any prefix match, -1 if no matches at all
   return prefix_match;
}
// Current object needs to be tree control for list members help
// Tries to find an exact match, case sensitivity defined by
// language mode.  If no match is found, tries to match case-
// insensitive using a prefix match.
static _str _find_common_prefix_match(_str prefix, boolean &unique)
{
   //say("_find_common_prefix_match: prefix="prefix);
   // no prefix to match?
   if (prefix == '') {
      return prefix;
   }
   
   // select a starting searh point
   typeless uinfo = _TreeGetUserInfo(TREE_ROOT_INDEX);
   boolean search_root = (uinfo._isempty() || uinfo!=1)? false : true;
                     
   // find longest prefix match, case-sensitive
   _str longest_prefix = '';
   _str longest_caption = '';
   _str search_opts = gListHelpIgnoreCase'PST';
   int index = _TreeSearch(TREE_ROOT_INDEX, prefix, gListHelpIgnoreCase'PT');
   if (index <= 0 && gListHelpIgnoreCase=='') {
      index = _TreeSearch(TREE_ROOT_INDEX, prefix, 'PIT');
      search_opts = 'PIST';
   }
   if (index > 0) {
      unique=true;
      longest_prefix = longest_caption = _TreeGetCaption(index);
      index = _TreeSearch(index, prefix, search_opts);
      while (index > 0) {
         if (search_root || _TreeGetParentIndex(index)!=TREE_ROOT_INDEX) {
            _str caption = _TreeGetCaption(index);
            while (longest_prefix != '' && !pos(longest_prefix, caption, 1, 'i')) {
               longest_prefix = substr(longest_prefix, 1, length(longest_prefix)-1);
            }
            if (caption != longest_caption) {
               unique=false;
            }
         }
         index = _TreeSearch(index, prefix, search_opts);
      }
   }

   return longest_prefix;
}
// Returns true if the currently selected list help item
// is an actual tag, not a tag category
static boolean _list_help_item_is_tag()
{
   int index = _TreeCurIndex();
   if (index <= 0) {
      return false;
   }
   int parent = _TreeGetParentIndex(index);
   if (parent > 0) {
      return true;
   }
   if (parent < 0) {
      return false;
   }
   typeless uinfo = _TreeGetUserInfo(TREE_ROOT_INDEX);
   return (uinfo._isempty() || uinfo!=1)? false : true;
}
// Select (make current node) the given tree item
static boolean _select_list_help_item(int index)
{
   // valid index?
   if (index>0) {
      _TreeSetCurIndex(index);
      typeless uinfo = _TreeGetUserInfo(TREE_ROOT_INDEX);
      boolean search_root = (uinfo._isempty() || uinfo!=1)? false : true;
      p_AlwaysColorCurrent=search_root || (_TreeGetParentIndex(index) != TREE_ROOT_INDEX)
      gMemberHelp_pending=true;
      return true;
   }
   // not valid index, put cursor on first item and don't color it
   first_index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   if (first_index > 0) {
      _TreeSetCurIndex(first_index);
   }
   p_AlwaysColorCurrent=false;
   return false;
}
static _str table="\0\t\n\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~'";
// update the width of the code help tree control, assume that
// the current object is the tree control.
static void _update_list_width(int form_wid, int initial_width=0)
{
   // adjust width of form to accomodate longer captions
   _GetVisibleScreen(vx,vy,vwidth,vheight);
   //say("w="p_width" cw="_dx2lx(p_xyscale_mode, p_client_width)" ind="p_LevelIndent);
   int form_width   = _dx2lx(p_xyscale_mode, vwidth);
   int border_width = 300/*scrollbar*/ + 360/*bitmap*/ + p_LevelIndent;
   //p_width - _dx2lx(p_xyscale_mode,p_client_width) +
   int max_width = 0;
   if (initial_width > border_width) {
      max_width = initial_width - border_width;
   }
   int cat_index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   while (cat_index > 0) {
      int caption_width = _text_width(_TreeGetCaption(cat_index));
      if (caption_width > max_width) {
         max_width = caption_width;
      }
      int tag_index = _TreeGetFirstChildIndex(cat_index);
      while (tag_index > 0) {
         caption_width = _text_width(_TreeGetCaption(tag_index));
         if (caption_width > max_width) {
            max_width = caption_width;
         }
         tag_index = _TreeGetNextSiblingIndex(tag_index);
      }
      cat_index = _TreeGetNextSiblingIndex(cat_index);
   }
   if (max_width+border_width > form_width) {
      max_width = form_width - border_width;
   }
   p_width = max_width+border_width;
   form_wid.p_width=form_wid._left_width()*2+p_width;
}
static void _update_list_help()
{
   //say("_update_list_help: ");
   gListHelp_form_wid=form_wid=show('-hidden _list_members_form');
   _nocheck _control ctltree;
   int tree_wid=form_wid.ctltree;
   int orig_view_id;
   get_view_id(orig_view_id);
   p_window_id=tree_wid;
   _str lastid_prefix = substr(gListHelp_lastid,1,geditorctl_wid.p_col-gListHelp_lastidstart_col);
   lastid_prefix = strip(lastid_prefix);
   int status=call_index(errorArgs,geditorctl_wid,gListHelp_prefixexp,
                         gListHelp_lastid,lastid_prefix,
                         gListHelp_lastidstart_offset,gListHelp_expected_type,
                         gListHelp_info_flags,gListHelp_otherinfo,
                         gListHelp_insert_tags_index);
   // adjust width of form to accomodate longer captions
   //say("startcol="gListHelp_lastidstart_col" offset="gListHelp_lastidstart_offset);
   if (!status) {
      _update_list_width(form_wid);
   }
   activate_view(orig_view_id);
   // IF error or no items in the tree
   if (status) {
      if (status==VSCODEHELPRC_NO_SYMBOLS_FOUND && errorArgs[1]==lastid_prefix) {
         errorArgs[1]=gListHelp_lastid;
      }
      if (!gListHelp_OperatorTyped || status!=VSCODEHELPRC_NO_SYMBOLS_FOUND) {
         msg=_CodeHelpRC(status,errorArgs);
         if (msg!='') {
            message(msg);
            _beep();
         }
      }
      TerminateListHelp(0);
      return;
   }
   geditorctl_wid._AddEventtab(defeventtab codehelp_keys);
   if (tree_wid._TreeGetUserInfo(TREE_ROOT_INDEX) == 1) {
      tree_wid._TreeSortCaption(TREE_ROOT_INDEX, 'u');
      tree_wid._TreeSortCaption(TREE_ROOT_INDEX, 'i');
   }
   int index = tree_wid._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   while (index > 0) {
      tree_wid._TreeGetInfo(index, show_children);
      if (show_children >= 0) {
         tree_wid._TreeSortCaption(index, 'u');
         tree_wid._TreeSortCaption(index, 'i');
      }
      //caption = tree_wid._TreeGetCaption(index);
      //if (caption == '') {
      //   child = tree_wid._TreeGetFirstChildIndex(index);
      //   if (child > 0) {
      //      caption = tree_wid._TreeGetCaption(child);
      //      tree_wid._TreeGetInfo(child, ds, pic1, pic2);
      //      tree_wid._TreeSetCaption(index, caption);
      //      tree_wid._TreeSetInfo(index, show_children, pic1, pic2);
      //      tree_wid._TreeDelete(child);
      //   }
      //}
      index = tree_wid._TreeGetNextSiblingIndex(index);
   }
   index = tree_wid._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   if (index > 0) {
      tree_wid._TreeSetCurIndex(index);
   }
   // Resize form
   form_wid.p_width=form_wid._left_width()*2+tree_wid.p_width;
   tree_wid.p_x=0;
   tree_wid.p_y=0;
   h=_ly2dy(SM_TWIP,tree_wid.p_y)+_ly2dy(SM_TWIP,tree_wid.p_height);

   form_wid.p_height=_dy2ly(SM_TWIP,h)+form_wid._top_height()+form_wid._bottom_height();

   text_x=(gListHelp_lastidstart_col-p_col)*p_font_width+p_cursor_x;
   text_y=p_cursor_y;
   // Position the form
   _PositionNoFocusForm(p_window_id,form_wid,text_x,text_y,p_font_height,
                        (ginFunctionHelp)?gFunctionHelp_form_wid:0);

   gListHelp_ctltree_wid=gListHelp_form_wid.ctltree;
   gListHelp_ctltree_wid.p_MouseActivate=MA_NOACTIVATE;
   proc_index=find_index("codehelp_key",COMMAND_TYPE|PROC_TYPE);
   {
      ListHelpAltChars='';
      etab_index=defeventtab codehelp_keys;
      for (i=1;i<=length(ListHelpAltChars);++i) {
         selchar=substr(ListHelpAltChars,i,1);
         keyindex=ALT_KEYS_OFFSET+_asc(lowcase(selchar));
         set_eventtab_index(etab_index,keyindex,proc_index);
      }
   }

   gListHelp_ctltree_wid.p_AlwaysColorCurrent=false;
   if (gListHelpSearchString!='') {
      index = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchString, unique);
      if (index < 0) {
         index = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchPrefix, dummyunique);
      }
      if (index>=0 && unique && gListHelp_OperatorTyped) {
         TerminateListHelp(0);
         return;
      }
      gListHelp_ctltree_wid._select_list_help_item(index);
   }
   form_wid._ShowWindow(SW_SHOWNOACTIVATE);
}
static void _incremental_list_help()
{
   if (gListHelp_form_wid <= 0) {
      return;
   }
   int form_wid = gListHelp_form_wid;
   _nocheck _control ctltree;
   int tree_wid=form_wid.ctltree;
   int orig_view_id;
   get_view_id(orig_view_id);
   p_window_id=tree_wid;
   status=call_index(errorArgs,geditorctl_wid,gListHelp_prefixexp,
                     gListHelpSearchString,gListHelpSearchPrefix,
                     gListHelp_lastidstart_offset,gListHelp_expected_type,
                     gListHelp_info_flags,gListHelp_otherinfo,
                     gListHelp_insert_tags_index);
   // adjust width of form to accomodate longer captions
   if (!status) {
      _update_list_width(form_wid,p_width);
   }
   activate_view(orig_view_id);
   // IF error or no items in the tree
   if (status) {
      if (status==VSCODEHELPRC_NO_SYMBOLS_FOUND && errorArgs[1]==gListHelpSearchPrefix) {
         errorArgs[1]=gListHelpSearchString;
      }
      if (!gListHelp_OperatorTyped || status!=VSCODEHELPRC_NO_SYMBOLS_FOUND) {
         msg=_CodeHelpRC(status,errorArgs);
         if (msg!='') {
            message(msg);
         }
      }
      if (status != VSCODEHELPRC_NO_SYMBOLS_FOUND) {
         TerminateListHelp(0);
      }                                          
      return;
   }
   geditorctl_wid._AddEventtab(defeventtab codehelp_keys);
   if (tree_wid._TreeGetUserInfo(TREE_ROOT_INDEX) == 1) {
      tree_wid._TreeSortCaption(TREE_ROOT_INDEX, 'u');
      tree_wid._TreeSortCaption(TREE_ROOT_INDEX, 'i');
   }
   int index = tree_wid._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   while (index > 0) {
      tree_wid._TreeGetInfo(index, show_children);
      if (show_children >= 0) {
         tree_wid._TreeSortCaption(index, 'u');
         tree_wid._TreeSortCaption(index, 'i');
      }
      //caption = tree_wid._TreeGetCaption(index);
      //if (caption == '') {
      //   child = tree_wid._TreeGetFirstChildIndex(index);
      //   if (child > 0) {
      //      caption = tree_wid._TreeGetCaption(child);
      //      tree_wid._TreeGetInfo(child, ds, pic1, pic2);
      //      tree_wid._TreeSetCaption(index, caption);
      //      tree_wid._TreeSetInfo(index, show_children, pic1, pic2);
      //      tree_wid._TreeDelete(child);
      //   }
      //}
      index = tree_wid._TreeGetNextSiblingIndex(index);
   }
   //index = tree_wid._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   //if (index > 0) {
   //   tree_wid._TreeSetCurIndex(index);
   //}
}
/*
   PARAMETERS
      editorctl_wid     Coordinates text_x and text_y are relative to this window
      form_wid          The form to move.
      text_x,text_y     Prefered position of form in pixels relative to editorctl_wid
      text_height       Height of form in pixels
*/
static void _PositionNoFocusForm(int editorctl_wid,int form_wid,
                                 int text_x,int text_y,int text_height,
                                 int FunctionHelp_form_wid)
{
   x=text_x;
   y=text_y+text_height;
   _map_xy(editorctl_wid,0,x,y);
   if (x<0) x=0;  // Don't display text off the screen
   if (FunctionHelp_form_wid) {
      fx=0;fy=FunctionHelp_form_wid.p_y;
      fy=_ly2dy(SM_TWIP,fy);
      if (y<=fy) {
         y=fy+_ly2dy(SM_TWIP,FunctionHelp_form_wid.p_height);
      }
   }
   _GetVisibleScreen(vx,vy,vwidth,vheight);
   height=_ly2dy(form_wid.p_xyscale_mode,form_wid.p_height);
   if (y+height>=vy+vheight) {
      // Display this dialog above
      x=text_x;
      y=text_y-height;
      _map_xy(editorctl_wid,0,x,y);

      if (FunctionHelp_form_wid) {
         ty=y+_ly2dy(SM_TWIP,form_wid.p_height);
         fx=0;fy=FunctionHelp_form_wid.p_y;
         fy=_ly2dy(SM_TWIP,fy);
         if (ty>fy) {
            y-=ty-fy;
            //y=fy+_ly2dy(SM_TWIP,FunctionHelp_form_wid.p_height);
         }
      }
   }
   width=_lx2dx(form_wid.p_xyscale_mode,form_wid.p_width);
   if (x+width>=vx+vwidth) {
      x=vx+vwidth-width;
   }
   _dxy2lxy(form_wid.p_xyscale_mode,x,y);

   form_wid._get_window(junk,junk,width,height);
   form_wid._move_window(x,y,width,height);
}
void _CodeHelp()
{
   //say("_CodeHelp: ");
   if (!ginListHelp && !ginFunctionHelp) return;
   still_in_code_help();
}
void _switchbuf_code_help()
{
   if (def_switchbuf_cd) {
#if __UNIX__
       // If this buffer name has a valid path
       if (substr(p_buf_name,1,1)=='/') {
          path=strip_filename(p_buf_name,'N');
          // We don't want buffer order changed when if concurrent process
          // buffer is activate so here we change the load options before
          // calling cd().
          old_load_options=def_load_options;
          def_load_options=stranslate(lowcase(def_load_options),' ','+bp');
          cd('-a 'maybe_quote_filename(path),'q');
          def_load_options=old_load_options;
       }
#else
       // If this buffer name has a valid path
       if (substr(p_buf_name,2,1)==':' && substr(p_buf_name,3,1)=='\') {
          path=strip_filename(p_buf_name,'N');
          // We don't want buffer order changed when if concurrent process
          // buffer is activate so here we change the load options before
          // calling cd().
          old_load_options=def_load_options;
          def_load_options=stranslate(lowcase(def_load_options),' ','+bp');
          cd('-a 'maybe_quote_filename(path),'q');
          def_load_options=old_load_options;
       }
#endif

   }
   // on got focus
   if (arg(2)=='W') {
      if (geditorctl_wid==p_window_id) {
         return;
      }
   }
   TerminateCodeHelp(0,0);
}
static void still_in_code_help()
{
   //say("still_in_code_help: ");
   //if (!gListHelp_form_wid) return(false);
   orig_wid=p_window_id;
   focus_wid=_get_focus();
   if (!focus_wid) {
      TerminateCodeHelp(0,0);
      if (_iswindow_valid(orig_wid)) p_window_id=orig_wid;
      return;
   }
   if (gListHelp_form_wid && focus_wid==gListHelp_ctltree_wid) {
      focus_wid=focus_wid._form_parent();
   }
   p_window_id=focus_wid;
   // IF this dialog was closed (close_window maybe) OR
   //    focus is not on editor control object OR
   //    object changed
   //    buffer id changed
   if ((!_iswindow_valid(gListHelp_form_wid) && ginListHelp && !gListHelp_pending) ||
       p_view_id>=0 ||
       geditorctl_wid!=p_window_id ||
       geditorctl_wid.p_buf_id!=geditorctl_buf_id) {
      //say('h3 '(!_iswindow_valid(gListHelp_form_wid))' ':+(p_view_id>=0)' ':+(geditorctl_wid!=p_window_id)' ':+(geditorctl_wid.p_buf_id!=geditorctl_buf_id));
      TerminateCodeHelp(0,0);
      if (_iswindow_valid(orig_wid)) p_window_id=orig_wid;
      return;
   }
   idle=_idle_time_elapsed();
   if (ginFunctionHelp) {
      if (point('s')<gFunctionHelp_FunctionLineOffset+length(gFunctionHelp_starttext) ||
          get_text(length(gFunctionHelp_starttext),gFunctionHelp_FunctionLineOffset)!=gFunctionHelp_starttext
          ) {
         TerminateCodeHelp(0,0);
         if (_iswindow_valid(orig_wid)) p_window_id=orig_wid;
         return;
      }
      if (gFunctionHelp_pending) {
         if (idle>=def_codehelp_idle) {
            _update_function_help();
            gFunctionHelp_pending=false;
         }
      } else {
         if (idle>=100) {
            _update_function_help();
         } else {
            // Check if the cursor is under the the function help window
            text_x=0;
            text_y=p_cursor_y+p_font_height-1;
            _map_xy(p_window_id,0,text_x,text_y);
            _dxy2lxy(SM_TWIP,text_x,text_y);
            x=0;
            y=gFunctionHelp_form_wid.p_y;
            if (text_y>y && text_y<y+gFunctionHelp_form_wid.p_height) {
               gFunctionHelp_form_wid.p_visible=0;
            }

         }
      }
   }
   if (ginListHelp) {
      if (p_line!=gListHelpLineNum || gListHelpNoflines!=p_Noflines ||
          p_col<gListHelpStartCol) {
         TerminateListHelp(0);
         if (_iswindow_valid(orig_wid)) p_window_id=orig_wid;
         return;
      }
      //say(gListHelpStartCol' 'gListHelpStartText);
      if (_expand_tabsc(1,gListHelpStartCol-1)!=gListHelpStartText) {
         TerminateListHelp(0);
         if (_iswindow_valid(orig_wid)) p_window_id=orig_wid;
         return;
      }
      rest=_expand_tabsc(gListHelpStartCol);
      if (length(rest)<length(gListHelpEndText)) {
         TerminateListHelp(0);
         if (_iswindow_valid(orig_wid)) p_window_id=orig_wid;
         return;
      }
      gListHelpNewSearchString=substr(rest,1,length(rest)-length(gListHelpEndText));
      gListHelpNewSearchPrefix=substr(gListHelpNewSearchString,1,p_col-gListHelpStartCol);
      if (substr(rest,length(gListHelpNewSearchString)+1)!=gListHelpEndText ||
          p_col>gListHelpStartCol+length(gListHelpNewSearchString) ||
          pos('[~'p_word_chars']',gListHelpNewSearchString,1,'r')
          ) {
         TerminateListHelp(0);
         if (_iswindow_valid(orig_wid)) p_window_id=orig_wid;
         return;
      }
      if (gListHelpNewSearchPrefix!=gListHelpSearchPrefix && (idle>=def_codehelp_key_idle)) {
         //say('rest='rest'> 'gListHelpEndText);
         //say('New='gListHelpNewSearchString'> 'gListHelpSearchString);
         gListHelpSearchString=gListHelpNewSearchString;
         gListHelpSearchPrefix=gListHelpNewSearchPrefix;
         _incremental_list_help();
         if (!gListHelp_form_wid) {
            return;
         }
         if (!gListHelp_pending) {
            index = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchString,unique);
            if (index < 0) {
               index = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchPrefix, dummyunique);
            }
            gitem_selected=gListHelp_ctltree_wid._select_list_help_item(index);
         }
      }
      if (gListHelp_pending && idle>=def_codehelp_idle) {
         gListHelp_pending=false;
         _update_list_help();
      }
      if (_iswindow_valid(gListHelp_ctltree_wid) ) {
         if(gListHelp_ctltree_wid.p_AlwaysColorCurrent) {
            if (gMemberHelp_pending && idle>=def_memberhelp_idle) {
               gListHelp_ctltree_wid._display_list_member_help(gListHelp_ctltree_wid._TreeCurIndex());
               gMemberHelp_pending=false;
            }
         } else {
            TerminateMemberHelp(false);
         }
      } 
      return;
   }
   if (_iswindow_valid(orig_wid)) p_window_id=orig_wid;
}
int CodeHelpActive()
{
   if (!ginListHelp) return 0;
   if (!_iswindow_valid(gListHelp_form_wid)) return 0;
   return 1;
}
static void TerminateCodeHelp(boolean inFunctionHelpOnDestroy,
                              boolean inListHelpOnDestroy
                              )
{
   TerminateFunctionHelp(inFunctionHelpOnDestroy);
   TerminateListHelp(inListHelpOnDestroy);
}
static void TerminateMemberHelp(boolean inOnDestroy)
{
   if (_iswindow_valid(gMemberHelp_form_wid)) {
      if (!inOnDestroy) {
         gMemberHelp_form_wid._delete_window();
      }
   }
   gMemberHelp_form_wid=0;
   gMemberHelp_pending=false;
}
static void TerminateListHelp(boolean inOnDestroy)
{
   if (!ginListHelp) return;
   // IF this dialog was closed (close_window maybe)
   if (_iswindow_valid(gListHelp_form_wid)) {
      if (!inOnDestroy) {
         gListHelp_form_wid._delete_window();
      }
   }
   gListHelp_form_wid=0;
   TerminateMemberHelp(inOnDestroy);
   ginListHelp=0;
   if (_iswindow_valid(geditorctl_wid) &&
       geditorctl_wid._isEditorCtl() && !ginFunctionHelp) {
      geditorctl_wid._RemoveEventtab(defeventtab codehelp_keys);
      geditorctl_wid=0;
   }
   etab_index=defeventtab codehelp_keys;
   for (i=_asc('a');i<=_asc('z');++i) {
      keyindex=ALT_KEYS_OFFSET+i;
      set_eventtab_index(etab_index,keyindex,0);
   }
}
static DoDefaultKey(_str key,boolean doTerminate=true)
{
   last_index(prev_index('','C'),'C');
   //orig_eventtab=p_eventtab;
   //p_eventtab=0;
   _RemoveEventtab(defeventtab codehelp_keys);
   if (doTerminate) {
      if (ginListHelp) {
         wid=geditorctl_wid;
         TerminateListHelp(0);
         p_window_id=wid;
      }
      if (!_QReadOnly()) {
         last_event(key);
         call_key(key);
      }
   } else {
      if (!_QReadOnly()) {
         last_event(key);
         call_key(key);
      }
      if (_iswindow_valid(geditorctl_wid)) {
         //p_eventtab=orig_eventtab;
         _AddEventtab(defeventtab codehelp_keys);
      }
   }

}
void codehelp_key()
{
   //say("codehelp_key: last="event2name(last_event()));
   _macro_delete_line();
   _macro('m',_macro('s'));
   _nocheck _control ctltree;
   key=last_event();
   if (length(key)==1 && _asc(key)>=27 && 
       (key!=' ' || (def_codehelp_flags & VSCODEHELPFLAG_SPACE_INSERTS_SPACE))
      ) {
      still_in_code_help();
      doTerminate=0;
      if (ginListHelp && !gListHelp_pending) {
         // IF this is not a word character
         if (pos('[~'p_word_chars']',key,1,'r')) {
            if (gListHelpSearchPrefix!=gListHelpNewSearchPrefix) {
               gListHelpSearchString=gListHelpNewSearchString;
               gListHelpSearchPrefix=gListHelpNewSearchPrefix;
               _incremental_list_help();
               if (!gListHelp_pending) {
                  index = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchString,unique);
                  if (index < 0) {
                     index = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchPrefix, dummyunique);
                  }
                  gitem_selected=gListHelp_ctltree_wid._select_list_help_item(index);
               }
            }
            if (gListHelp_ctltree_wid.p_AlwaysColorCurrent) {
               doTerminate=1;
               ListHelpReplaceWord(key);
            }
         }
      }
      if (!doTerminate || key:!=' ' || !(def_codehelp_flags & VSCODEHELPFLAG_SPACE_INSERTS_SPACE)) {
         DoDefaultKey(key,doTerminate);
      }
      return;
   }
   switch (key) {
   case C_I:
   case UP:
      still_in_code_help()
      if (!ginListHelp || gListHelp_pending) {
         DoDefaultKey(key);
         return;
      }
      if (gListHelp_ctltree_wid._TreeGetUserInfo(TREE_ROOT_INDEX)!=1 || 
          gListHelp_ctltree_wid.p_AlwaysColorCurrent) {
         gListHelp_ctltree_wid._TreeUp();
      }
      index = gListHelp_ctltree_wid._TreeCurIndex(); 
      gListHelp_ctltree_wid._select_list_help_item(index);
      return;
   case C_K:
   case DOWN:
      still_in_code_help()
      if (!ginListHelp || gListHelp_pending) {
         DoDefaultKey(key);
         return;
      }
      if (gListHelp_ctltree_wid._TreeGetUserInfo(TREE_ROOT_INDEX)!=1 || 
          gListHelp_ctltree_wid.p_AlwaysColorCurrent) {
         gListHelp_ctltree_wid._TreeDown();
      }
      index = gListHelp_ctltree_wid._TreeCurIndex(); 
      gListHelp_ctltree_wid._select_list_help_item(index);
      return;
   case PGUP:
      still_in_code_help()
      if (!ginListHelp || gListHelp_pending) {
         DoDefaultKey(key);
         return;
      }
      gListHelp_ctltree_wid._TreePageUp();
      index = gListHelp_ctltree_wid._TreeCurIndex(); 
      gListHelp_ctltree_wid._select_list_help_item(index);
      return;
   case PGDN:
      still_in_code_help()
      if (!ginListHelp || gListHelp_pending) {
         DoDefaultKey(key);
         return;
      }
      gListHelp_ctltree_wid._TreePageDown();
      index = gListHelp_ctltree_wid._TreeCurIndex(); 
      gListHelp_ctltree_wid._select_list_help_item(index);
      return;
   case TAB:
   case ENTER:
      still_in_code_help();
      if (gListHelpNewSearchPrefix!=gListHelpSearchPrefix && 
          ginListHelp && !gListHelp_pending && gListHelp_ctltree_wid) {
         int new_index = gListHelp_ctltree_wid._find_list_help_item(gListHelpNewSearchPrefix,unique,false);
         if (new_index > 0) {
            gListHelp_ctltree_wid._TreeSetCurIndex(new_index);
         }
      }
      if (!ginListHelp  || gListHelp_pending || !gListHelp_ctltree_wid._list_help_item_is_tag()) {
         DoDefaultKey(key);
         return;
      }
      ListHelpReplaceWord();
      TerminateListHelp(0);
      return;
   case C_G:
      if (!iscancel(key)) {
         doDefaultKey(key,false /* don't terminate */);
         return;
      }
   case ESC:
      if (ginListHelp && !gListHelp_pending) {
         TerminateListHelp(0);
         return;
      }
      TerminateCodeHelp(0,0);
      return;
   case name2event('A-.'):
      still_in_code_help();
      //say("got here C-DOWN");
      if (!ginListHelp || gListHelp_pending) {
         DoDefaultKey(key);
         return;
      }
      index = gListHelp_ctltree_wid._curr_list_help_category();
      if (index > 0) {
         index = gListHelp_ctltree_wid._TreeGetNextSiblingIndex(index);
         if (index== -1) {
            index = gListHelp_ctltree_wid._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
         }
      }
      if (index > 0) {
         gListHelp_ctltree_wid._TreeSetCurIndex(index);
         cline=gListHelp_ctltree_wid._TreeCurLineNumber();
         gListHelp_ctltree_wid._TreeScroll(cline);
         gListHelp_ctltree_wid.p_AlwaysColorCurrent=false;
         match = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchString, unique, false);
         if (index < 0) {
            index = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchPrefix, dummyunique, false);
         }
         if (match > 0 && gListHelp_ctltree_wid._TreeGetParentIndex(match) == index) {
            gListHelp_ctltree_wid._select_list_help_item(match);
         }
      }
      return;
   case name2event('C-DOWN'):
      still_in_code_help();
      //say("got here C-DOWN");
      if (!ginListHelp || gListHelp_pending) {
         DoDefaultKey(key);
         return;
      }
      index = gListHelp_ctltree_wid._curr_list_help_category();
      if (index > 0) {
         index = gListHelp_ctltree_wid._TreeGetNextSiblingIndex(index);
      }
      if (index > 0) {
         gListHelp_ctltree_wid._TreeSetCurIndex(index);
         cline=gListHelp_ctltree_wid._TreeCurLineNumber();
         gListHelp_ctltree_wid._TreeScroll(cline);
         gListHelp_ctltree_wid.p_AlwaysColorCurrent=false;
         match = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchString, unique, false);
         if (index < 0) {
            index = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchPrefix, dummyunique, false);
         }
         if (match > 0 && gListHelp_ctltree_wid._TreeGetParentIndex(match) == index) {
            gListHelp_ctltree_wid._select_list_help_item(match);
         }
      }
      return;
   case name2event('C-UP'):
      still_in_code_help();
      //say("got here C-UP");
      if (!ginListHelp || gListHelp_pending) {
         DoDefaultKey(key);
         return;
      }
      index = gListHelp_ctltree_wid._curr_list_help_category();
      if (index > 0) {
         index = gListHelp_ctltree_wid._TreeGetPrevSiblingIndex(index);
      }
      if (index > 0) {
         gListHelp_ctltree_wid._TreeSetCurIndex(index);
         cline=gListHelp_ctltree_wid._TreeCurLineNumber();
         gListHelp_ctltree_wid._TreeScroll(cline);
         gListHelp_ctltree_wid.p_AlwaysColorCurrent=false;
         match = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchString, unique, false);
         if (index < 0) {
            index = gListHelp_ctltree_wid._find_list_help_item(gListHelpSearchPrefix, dummyunique, false);
         }
         if (match > 0 && gListHelp_ctltree_wid._TreeGetParentIndex(match) == index) {
            gListHelp_ctltree_wid._select_list_help_item(match);
         }
      }
      return;
   case name2event(' '):
      if (!(def_codehelp_flags & VSCODEHELPFLAG_SPACE_COMPLETION)) {
         still_in_code_help();
         if (!ginListHelp  || gListHelp_pending || !gListHelp_ctltree_wid._list_help_item_is_tag()) {
            DoDefaultKey(key);
            return;
         }
         ListHelpReplaceWord();
         TerminateListHelp(0);
         return;
      }
      // drop through as if they typed control-space
   case name2event('C- '):
      still_in_code_help();
      //say("got here C-SPACE or SPACE, "gListHelpSearchString);
      if (!ginListHelp || gListHelp_pending) {
         DoDefaultKey(key);
         return;
      }
      _str longest_prefix = gListHelp_ctltree_wid._find_common_prefix_match(gListHelpSearchString,unique);
      parse longest_prefix with longest_prefix '(';
      //say("L="longest_prefix" U="unique);
      int start_pos = length(gListHelpSearchString);
      if (length(longest_prefix) > start_pos) {
         p_col=_text_colc(gListHelp_lastidstart_col,"i");
         _delete_text(start_pos);
         _insert_text(longest_prefix);
      } else if (key==' ' && unique) {
         if (!ginListHelp  || gListHelp_pending || !gListHelp_ctltree_wid._list_help_item_is_tag()) {
            DoDefaultKey(key);
            return;
         }
         ListHelpReplaceWord();
         TerminateListHelp(0);
      } 
      return;
   default:
      //keyindex=event2index(key);
      //if (keyindex>=ALT_KEYS_OFFSET && keyindex<ALT_KEYS_OFFSET+128 &&
      //    ginListHelp && !gListHelp_pending) {
      //   ch=_chr(keyindex-ALT_KEYS_OFFSET);
      //   NofTabs=gListHelp_ctltab_wid.p_NofTabs;
      //   for (i=0;i<NofTabs;++i) {
      //      text = gListHelp_ctltab_wid._getTabInfo(i);
      //      j=pos('&',text);
      //      if (j) {
      //         selchar=substr(text,j+1,1);
      //         if (!stricmp(selchar,ch)) {
      //            gListHelp_ctltab_wid.p_ActiveTab=i;
      //            break;
      //         }
      //      }
      //   }
      //}
   }
}

void _do_default_replace_context_tag(int relcol,
                 _str last_id, _str caption, 
                 _str terminationKey, int info_flags)
{
   while (relcol-->0) left();
   _delete_text(length(last_id));

   // does this caption have a parenthesis? (is it a function?)
   boolean have_paren = false;
   if (pos('(', caption)) {
      caption = substr(caption, 1, pos('S')-1);
      have_paren = true;
   }
   if (terminationKey:==' ' && (def_codehelp_flags & VSCODEHELPFLAG_SPACE_INSERTS_SPACE)) {
      caption=caption' ';
   }
   _insert_text(caption);
   // if we have an open paren, then insert open paren and go directly
   // into function help, unless name is already followed by a paren.
   // kind of language specific...
   if (have_paren && terminationKey=="" && 
       !(info_flags&VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN) &&
       (def_codehelp_flags& VSCODEHELPFLAG_INSERT_OPEN_PAREN)
       ) {
      last_event('(');
      auto_functionhelp_key();
   }


   // actual results may vary slightly...
   _macro_append('word=cur_word(pstart_col);');
   _macro_append('if (word!="") {');
   _macro_append('   p_col=_text_colc(pstart_col,"i");');
   _macro_append('   _delete_text(length(word));');
   _macro_append('   _insert_text('_quote(caption)');');
   _macro_append('}');
}
// Replace the current word (if any) with the selected context tag
// Also does macro recording for code help and sets up for going
// directly into function argument help, if appropriate.
// Arguments:
//    terminationKey -- key pressed to terminate list help
// Returns:
//    void
//
static void ListHelpReplaceWord(_str terminationKey="")
{
   if (geditorctl_wid._QReadOnly()) {
      return;
   }
   orig_wid=p_window_id;
   p_window_id=geditorctl_wid;
   
   _nocheck _control ctltree;
   int index=gListHelp_ctltree_wid._TreeCurIndex();
   _str caption=gListHelp_ctltree_wid._TreeGetCaption(index);
   _str ext = geditorctl_wid.p_extension;
   int REPLindex = find_index('_'ext'_replace_context_tag',PROC_TYPE);
   if (index_callable(REPLindex)) {
      // Replace the current word (if any) with the selected context tag
      // This extension-specific callback is responsible for:
      //   - deleting the previous word (search_string)
      //   - inserting the new word according to language rules
      //   - arrange to start function help if appropriate
      // Arguments:
      //    start_col      -- start colume of identifier to replace
      //    search_string  -- identifier to replace
      //    caption        -- selected context tag (caption as shown in dialog)
      //    terminationKey -- key pressed to terminate list help
      //    info_flags     -- context tagging flags (check followed by paren)
      // Returns:
      //    void
      //
      call_index(p_col-gListHelpStartCol,
                 gListHelpNewSearchString, caption, 
                 terminationKey, gListHelp_info_flags, REPLindex);
      // Generate code for macro recording
      // actual results may vary slightly...
      if (gListHelpNewSearchString=="") {
         _macro_append('_'ext'_replace_context_tag(0,"",'_quote(caption)','_quote(terminationKey)','dec2hex(gListHelp_info_flags)');');
      } else {
         _macro_append('word=cur_word(pstart_col,"",1);');
         _macro_append('if (word!="") {');
         _macro_append('   p_col=_text_colc(pstart_col,"i");');
         _macro_append('   _'ext'_replace_context_tag(0,word,'_quote(caption)','_quote(terminationKey)','dec2hex(gListHelp_info_flags)');');
         _macro_append('}');
      }

   } else {
      _do_default_replace_context_tag(
                 p_col-gListHelpStartCol,
                 gListHelpNewSearchString, caption, 
                 terminationKey, gListHelp_info_flags
                 );
   }
   if (_isdiffed(p_buf_id)) {
      _DiffAddUndoOther(p_buf_id);
   }
   if (_iswindow_valid(orig_wid)) {
      p_window_id=orig_wid;
   }
}

defeventtab _list_members_form
void ctltree.lbutton_double_click()
{
   if (p_AlwaysColorCurrent) {
      ListHelpReplaceWord();
      TerminateListHelp(0);
   }
}
// Find the given tag to extract the comments surrounding.
// Attempts to use proc-search to locate the tag on the given
// line without regard to context.
//    ext          -- file extension to try
//    temp_view_id -- on success, contains temp_view_id containing file
//    orig_view_id -- on success, contains original view ID
//    tag_name     -- name of tag to search for
//    file_name    -- name of file that the tag is located in
//    line_no      -- the 'start' line for the tag
//    type_name    -- tag type (VS_TAGTYPE_*) to search for
//    class_name   -- class name to search for
// On success, 'temp_view_id' holds the view ID for the file
// the comment came from, and 'orig_view_id' is the original view ID.
//
static int _LocateTagForExtractingComment(_str &tag_type, int &temp_view_id, int &orig_view_id,
                                          _str tag_name, _str file_name, int line_no,
                                          _str type_name='', _str class_name='')
{
   // try finding the item in locals or context, for current buffer
   int tag_linenum = -1;
   int tag_seekpos = -1;
   if (_isEditorCtl() && p_buf_name :== file_name) {
      // update the current context and locals
      _UpdateContext();
      _UpdateLocals();
      // try to find the tag among the locals
      int i = tag_find_local(tag_name, true, p_LangCaseSensitive);
      while (i > 0) {
         //say("_LocateTagForExtractingComment: local="i);
         tag_get_detail2(VS_TAGDETAIL_local_start_linenum, i, tag_line_no);
         if (tag_line_no :== line_no) {
            tag_get_detail2(VS_TAGDETAIL_local_start_seekpos, i, tag_seekpos);
            tag_get_detail2(VS_TAGDETAIL_local_type, i, tag_type);
            break;
         }
         i = tag_next_local(tag_name, true, p_LangCaseSensitive);
      }
      // not found? try the current context
      if (tag_seekpos < 0) {
         i = tag_find_context(tag_name, true, p_LangCaseSensitive);
         while (i > 0) {
            //say("_LocateTagForExtractingComment: context="i);
            tag_get_detail2(VS_TAGDETAIL_context_start_linenum, i, tag_line_no);
            if (tag_line_no :== line_no) {
               tag_get_detail2(VS_TAGDETAIL_context_start_seekpos, i, tag_seekpos);
               tag_get_detail2(VS_TAGDETAIL_local_type, i, tag_type);
               break;
            }
            i = tag_next_context(tag_name, true, p_LangCaseSensitive);
         }
      }
      // found in locals or context
      if (tag_seekpos > 0) {
         int status=_open_temp_view(file_name,temp_view_id,orig_view_id);
         if (status) {
            return status;
         }
         p_line= tag_line_no;
         _nrseek(tag_seekpos);
         //say("_LocateTagForExtractingComment: p_line="p_line" seek="_nrseek());
         return 0;
      }
   }

   // we really need proc-search.
   //say("_LocateTagForExtractingComment: 1");
   /*if (!PSindex) {
      PSindex = find_index(ext'_proc_search',PROC_TYPE);
   }
   if (!index_callable(PSindex)) {
      return 1;
   }
   */
   _str fext=_bufname2ext(file_name);

   int index=find_index('vs'fext'-load-tags',PROC_TYPE);
   if (index_callable(index)) {
      //message nls('Can not locate source code for %s.',file_name);
      return(1);
   }

   // try to create a temp view for the file
   already_loaded=buf_match(file_name,1,"hx")!="";
   int status=_open_temp_view(file_name,temp_view_id,orig_view_id);
   if (status) {
      return status;
   }
   if (!already_loaded) {
      select_edit_mode();
   }
   PSindex=find_index(p_extension'-proc-search',PROC_TYPE)
   if (! index_callable(PSindex) ) {
      _delete_temp_view(temp_view_id);
      activate_view(orig_view_id);
      return(1);
   }
   // set up proc name to search for
   _str find_proc_name = tag_name;
   //if (type_name != '') {
   //   if (class_name != '') {
   //      find_proc_name = tag_name '(' type_name ')';
   //   } else {
   //      find_proc_name = tag_name '(' class_name ':' type_name ')';
   //   }
   //}
   // First try searching from designated line number
   p_line=line_no; begin_line();
   _str orig_proc_name = find_proc_name;
   top();
   ff=1;
   for (;;) {
      find_proc_name = orig_proc_name;
      status=call_index(find_proc_name,ff,ext,PSindex);
      //say("_ExtractTagComments: "find_proc_name" status="status" buf="p_buf_name);
      if (status) {
         break;
      }
      if (p_line==line_no) {
         tag_tree_decompose_tag(find_proc_name, tag_name, class_name, type_name, tag_flags);
         return 0;
      }
      ff=0;
   }

   // didn't find the tag
   _delete_temp_view(temp_view_id);
   activate_view(orig_view_id);
   return status;  // non-zero
}

// Extract source comments from the header file for the given tag,
// located in the given file and line number.
//    PSindex     -- index to extension specific proc_search function
//    ext         -- file extension to try
//    header_list -- (output) array of strings for each line of comment
//    tag_name    -- name of tag to search for
//    file_name   -- name of file that the tag is located in
//    line_no     -- the 'start' line for the tag
//    type_name   -- tag type (VS_TAGTYPE_*) to search for
//    class_name  -- class name to search for
//    indent_col  -- amount to indent each line of comment
// Results are returned in 'header_list', expect it to be empty.
//
int _ExtractTagComments(_str (&header_list)[], int line_limit,
                        _str tag_name, _str file_name, int line_no,
                        _str type_name='', _str class_name='', int indent_col=0)
{
   // we really need proc-search.
   //say("_ExtractTagComments: 1");
   header_list._makeempty();

   // try to find the tag
   _str tag_type='';
   int status = _LocateTagForExtractingComment(tag_type, temp_view_id, orig_view_id,
                                               tag_name, file_name, line_no,
                                               type_name, class_name);
   // didn't find the tag, out of here
   if (status) {
      return status;
   }

   // get the tag header comments
   int first_line, last_line;
   status=_do_default_get_tag_header_comments(first_line,last_line);
   if (status) {
      _delete_temp_view(temp_view_id);
      activate_view(orig_view_id);
      return status;
   }

   // maybe check line limit
   if (line_limit>0 && last_line-first_line>line_limit) {
      last_line = first_line+line_limit;
   }

   // collect the lines of the header comment, into header_list
   p_line=first_line;
   int first_non_blank_col=0;
   while (p_line<=last_line) {
      first_non_blank();
      if (!first_non_blank_col) {
         first_non_blank_col=p_col;
      } else {
         if (p_col<first_non_blank_col) {
            first_non_blank_col=p_col;
         }
      }
      line=_expand_tabsc(first_non_blank_col,-1,'S');
      line=indent_string(indent_col):+strip(line,'T');
      header_list[header_list._length()]=line;
      if (down()) {
         break;
      }
   }

   // success!!!
   _delete_temp_view(temp_view_id);
   activate_view(orig_view_id);
   return 0;
}
// Extract source comments from the header file for the given tag,
// located in the given file and line number.
//    PSindex     -- index to extension specific proc_search function
//    ext         -- file extension to try
//    member_msg  -- (output) array of strings for each line of comment
//    tag_name    -- name of tag to search for
//    file_name   -- name of file that the tag is located in
//    line_no     -- the 'start' line for the tag
// Results are returned in 'header_list', expect it to be empty.
//
int _ExtractTagComments2(_str &member_msg, int line_limit,
                         _str tag_name, _str file_name, int line_no)
{
   //say("_ExtractTagComments2: 1");
   // try to find the tag
   _str tag_type = '';
   int status = _LocateTagForExtractingComment(tag_type, temp_view_id, orig_view_id,
                                               tag_name, file_name, line_no);
   // didn't find the tag
   if (status) {
      return status;
   }

   // get the tag header comments
   _do_default_get_tag_comments(tag_type,member_msg,line_limit);
   _delete_temp_view(temp_view_id);
   activate_view(orig_view_id);
   return 0;
}
static _str ghtml_special_char:[]={
   'lt'=> '<',
   'gt'=> '>',
   'le'=> '<=',
   'ge'=> '>=',
   'times'=> 'x',
   'amp'=> '&',
   'nbsp'=>' ',  // non-breaking space not really supported.
   // Don't know that characters these are
   // &radic';    I think this is a square root symbol
   //&lceil; &rceil; &lfloor; &rfloor;

};
void translate_html(_str &member_msg)
{
   // translate SGML styles to function help style codes
   if (def_codehelp_html_comments) {
      member_msg=stranslate(member_msg, _chr(1):+'<','<');
      // translate HTML special character codes  &#ddd
      int i;
      i=1;
      while (pos('[&]\#{:i};',member_msg,i,'r')) {
         int s = pos('S');  // Start of match
         int n = pos('');  // length of match
         word=substr(member_msg,pos('S0'),pos('0'));
         if (word>=0 && word<=255) {
            temps = substr(member_msg, 1, s-1)   :+
                         _chr(word);
            i=length(temps)+1;
            member_msg=temps:+substr(member_msg, s+n);
         } else {
            i=s+n;
         }
      }
      //member_msg=stranslate(member_msg, "", '<(/|)(X(MP)|W(BR)|V(AR)|U(L|)|T(T|R|ITLE|HEAD|H|FOOT|EXTAREA|D|BODY|ABLE|AB)|S(UP|UB|TYLE|TRONG|TRIKE|PAN|PACER|MALL|ERVLET|ERVER|ELECT|CRIPT|AMP|)|Q()|P(RE|LAINTEXT|ERSON|ARAM|ARAM|)|O(VERLAY|PTION|L|BJECT)|N(OTE|OSCRIPT|OLAYER|OFRAMES|OEMBED|OBR|EXTID)|M(ULTICOL|ETA|ENU|ARQUEE|AP)|L(ISTING|INK|I|H|AYER|ANG)|K(EYGEN|BD)|J(AVA)|I(SINDEX|NS|NPUT|MG|)|H(TML|R|P([1-9]|)|EAD|[1-9])|F(RAMESET|RAME|ORM|ONT|N|IG)|E(MBED|M)|D(T|L|IV|IR|FN|EL|D)|C(REDIT|OLGROUP|OL|ODE|ITE|ENTER|APTION)|B(R|Q|ODY|LOCKQUOTE|LINK|IG|GSOUND|DO|ASEFONT|ASE|ANNER|)|A(U|REA|PPLET|PP|DDRESS|CRONYM|BBREV|))(>|[ \t]?*>)','ri');
      i=1;
      while (pos('[&]{[a-zA-Z]#}(;|[~a-zA-Z])',member_msg,i,'r')) {
         int s = pos('S');  // Start of match
         int n = pos('');  // length of match
         word=substr(member_msg,pos('S0'),pos('0'));
         _str *p;
         p=ghtml_special_char._indexin(word);
         if (p) {
            temps = substr(member_msg, 1, s-1):+ *p;
            i=length(temps)+1;
            if (substr(member_msg,s+n-1,1)==';') {
               member_msg=temps:+substr(member_msg, s+n);
            } else {
               member_msg=temps:+substr(member_msg, s+n-1);
               --i;
            }
         } else {
            i=s+n;
         }
      }
   }
#if 0
   member_msg=stranslate(member_msg, "\1b", '[<](CODE|B|H[0-9])[>]', 'ir');
   member_msg=stranslate(member_msg, "\1i", '<I>', 'i');
   member_msg=stranslate(member_msg, "\1u", '<U>', 'i');
   member_msg=stranslate(member_msg, "\1e", '[<][/](CODE|B|I|U)[>]', 'ir');
   member_msg=stranslate(member_msg, "", '[<]?*[>]','r');
   member_msg=stranslate(member_msg, " ", '&nbsp(;|)','r');
   member_msg=stranslate(member_msg,'&&','&');
#endif
}
// comment <B> bold comment</B> <I>italic</I> <U> underline</U>
// comment <B> bold comment <I>italic</I> <U> underline</U></B>
static void _display_list_member_help()
{
   // do nothing if the current index is not a selected tag
   //say("_display_list_member_help: 1");
   if (_idle_time_elapsed() < def_memberhelp_idle ||
       !p_AlwaysColorCurrent || !ginListHelp || 
       !_iswindow_valid(geditorctl_wid) ||
       !geditorctl_wid._isEditorCtl()) {
      // out of here
      TerminateMemberHelp(false);
      return;
   }

   // check current index
   int index = _TreeCurIndex();
   if (index <= TREE_ROOT_INDEX) {
      TerminateMemberHelp(false);
      return;
   }

   // get the tag name from the caption and adjust
   _str tag_name = _TreeGetCaption(index);
   int p = lastpos('(', tag_name);
   if (p) {
      tag_name = substr(tag_name, 1, p-1);
   }
   p = pos('operator ',tag_name);
   if (p) {
      tag_name = strip(substr(tag_name, 9));
   }

   // calculate the file ID and line number
   int line_no, file_id, tag_file_id;
   typeless value = _TreeGetUserInfo(index);
   int status = cb_get_db_file_line(value, tag_file_id, file_id, line_no);
   if (status) {
      // nothing found
      TerminateMemberHelp(false);
      return;
   }
   if (gMemberHelp_form_wid &&
       gMemberHelp_last_tag_name:==tag_name && 
       gMemberHelp_last_tag_file_id==tag_file_id &&
       gMemberHelp_last_file_id==file_id &&
       gMemberHelp_last_line_no==line_no
       ) {
      return;
   }
   gMemberHelp_last_tag_name=tag_name;
   gMemberHelp_last_tag_file_id=tag_file_id;
   gMemberHelp_last_file_id=file_id;
   gMemberHelp_last_line_no=line_no;

   // find the name of the filename containing this item
   //say("_display_list_member_help: 4");
   boolean case_sensitive = geditorctl_wid.p_LangCaseSensitive;
   _str return_type = '';
   _str file_name = geditorctl_wid.p_buf_name;
   if (file_id > 0) {
      // must be in a tag file
      typeless tag_files = tags_filenamea(geditorctl_wid.p_extension);
      for (i=0;;) {
         _str tag_filename = next_tag_filea(tag_files, i, false, true);
         //say("tag_filename="tag_filename);
         if (tag_filename=='') {
            status=BT_RECORD_NOT_FOUND_RC;
            break;
         }
         status = tag_get_file(file_id, file_name);
         if (status) {
            continue;
         }
         //say("file_name="file_name);
         status=tag_find_closest(tag_name, file_name, line_no, case_sensitive);
         if (!status) {
            tag_get_detail(VS_TAGDETAIL_file_line, line_no);
            tag_get_detail(VS_TAGDETAIL_return, return_type);
            //say("FOUND one");
            break;
         }
      }
   } else {
      // try to find the tag in locals or context to get return type
      status = tag_find_local(tag_name, true, case_sensitive);
      while (status > 0) {
         tag_get_detail2(VS_TAGDETAIL_local_line, status, tag_line_no);
         if (tag_line_no==line_no) {
            tag_get_detail2(VS_TAGDETAIL_local_return, status, return_type);
            break;
         }
         status = tag_next_local(tag_name, true, case_sensitive);
      }
      if (status<=0) {
         status = tag_find_context(tag_name, true, case_sensitive);
         while (status > 0) {
            tag_get_detail2(VS_TAGDETAIL_context_line, status, tag_line_no);
            if (tag_line_no==line_no) {
               tag_get_detail2(VS_TAGDETAIL_context_return, status, return_type);
               break;
            }
            status = tag_next_context(tag_name, true, case_sensitive);
         }
      }
      if (!status) {
         status=BT_RECORD_NOT_FOUND_RC;
      }
   }
   // didn't find any matches, give up on this
   //say("_display_list_member_help: 5");
   if (status<0) {
      TerminateMemberHelp(false);
      return;
   }

   // refresh output tab window
   // find the output tagwin and update it
   _nocheck _control ctltagname;
   f = _GetTagwinWID();
   if (f && tag_name != '') {    
      //_message_box(path'\t'LineNumber'\t'proc_name);
      f.ctltagname.p_user = file_name "\t" line_no// "\tJUST_GO_THERE";
      f.ctltagname.p_text = tag_name;
   }

   // list member help option is turned off?
   if (!(def_codehelp_flags & VSCODEHELPFLAG_DISPLAY_MEMBER_COMMENTS)) {
      // out of here
      TerminateMemberHelp(false);
      return;
   }

   // Now get the comment for this tag
   //say("_display_list_member_help: 6");
   _str member_msg='';
   _ExtractTagComments2(member_msg, def_codehelp_max_comments,
                        tag_name, file_name, line_no);

   if (member_msg=='' && return_type == '') {
      // all that work for nothing!
      TerminateMemberHelp(false);
      return;
   }
   if (return_type!='') {
      //strappend(member_msg,nls("Returns \1b%s1\1e",return_type));
      strappend(member_msg,nls("Returns \1<b>%s1\1</b>",return_type));
   }

#if 1
   /*
      This code DOES WORK.
      I decided not to used because the @ is sort of a substitute for
      bolding the text.
   */
   // translate Java doc '@' symbols
   i=1;
   while (pos('(^|\10){[@]:v}',member_msg,i,'r')) {
      int s = pos('S0');  // Start of @word match
      int n = pos('0');   // length of @word match

      temps = substr(member_msg, 1, s-1)   :+
              substr(member_msg, s+1, n-1) ;
      i=length(temps)+1;
      //member_msg=temps:+substr(member_msg, s+n);
      member_msg = substr(member_msg, 1, s-1)   :+ "\1<b>" :+
                   substr(member_msg, s+1, n-1) :+ "\1</b>" :+
                   substr(member_msg, s+n /*+1 */);
   }
#endif
   translate_html(member_msg);
   member_msg=stranslate(member_msg,'&&','&');
   
   // show the member (function) help dialog
   _nocheck _control picture1;
   if (!gMemberHelp_form_wid) {
      gMemberHelp_form_wid=geditorctl_wid.show('-hidden -nocenter -new _function_help_form');
      MemberHelp_list_changed=1;
   }

   int screen_w = _screen_width()*_twips_per_pixel_x();
   int list_h = gListHelp_form_wid.p_height;
   int list_w = gListHelp_form_wid.p_width;
   int char_h = gListHelp_ctltree_wid.p_char_height;
   int first_visible = gListHelp_ctltree_wid._TreeScroll();
   int current_line  = gListHelp_ctltree_wid._TreeCurLineNumber();
   int delta_h = _twips_per_pixel_y() * char_h * (current_line - first_visible);

   gMemberHelp_form_wid.picture1._DisplayFunctionHelp(
                        member_msg,'',
                        (_twips_per_pixel_x()*4),(_twips_per_pixel_y()*2),
                        (screen_w intdiv 3),
                        _default_font(CFG_FUNCTION_HELP),
                        0x80000020,0x80000021,
                        list_h,
                        0, // Wrap indent
                        -1 /*F_BOLD|F_ITALIC|F_UNDERLINE */);

   int x,y,width,height;
   gMemberHelp_form_wid._get_window(x,y,width,height);
   x = gListHelp_form_wid.p_x + list_w;
   y = gListHelp_form_wid.p_y + delta_h;
   if (delta_h+height > list_h) {
      y = y-delta_h+(list_h-height);
   }
   if (x+width > screen_w) {
      if(gListHelp_form_wid.p_x > width) {
         x = x-width-list_w;
      } else {
         /* 
            There is not enough space on either side
            Use the side with the most left and add
            a horizontal scroll bar.  
            
            When we have
            a miniHTML control, we will finished this.
            The miniHTML control will automatically
            add scroll bars if the text does not fit.  
            Add an on_resize event to the _function_help_form
         */ 

         //if (gListHelp_form_wid.p_x>screen_w-(x+width)) {
         //    x=0;
         //    width=gListHelp_form_wid.p_x;
         //} else {
         //    width=screen_w-(x+width);
         //}
      }
   }
   gMemberHelp_form_wid._move_window(x,y,width,height);
   gMemberHelp_form_wid._ShowWindow(SW_SHOWNOACTIVATE);
}
void ctltree.on_change(int reason, int index)
{
   if (reason==CHANGE_SELECTED) {
      _select_list_help_item(index);
      TerminateMemberHelp(false);
      gMemberHelp_pending=true;
   }
}
ctltree.lbutton_up()
{
   _select_list_help_item(_TreeCurIndex());
}

_list_members_form.esc()
{
   p_active_form._delete_window();
   TerminateListHelp(1);
}
_list_members_form.enter()
{
   ListHelpReplaceWord();
   TerminateListHelp(0);
}
/**********************END _list_members_form**************************************/

static void adjust_line_height2(int (&labels)[],int &largest_width,int &line_height)
{
   line_height=0;
   count=labels._length();
   for (i=0;i<count;++i) {
      wid=labels[i];
      if (wid.p_height>line_height) {
         line_height=wid.p_height;
      }
      if (wid.p_x+wid.p_width>largest_width) {
         largest_width=wid.p_x+wid.p_width;
      }
   }
   for (i=0;i<count;++i) {
      wid=labels[i];
      wid.p_height=line_height;
   }
}
static int _text_width3(_str text)
{
   return(_text_width(stranslate(text,'&','&&')));
}
static int _text_width3Max(_str text,int max_font_flags)
{
   old_font_flags=_font_props2flags();
   _font_flags2props(max_font_flags);
   width=_text_width(stranslate(text,'&','&&'));
   _font_flags2props(old_font_flags);
   return(width);
}
static int _text_width2(_str text)
{
   text=stranslate(text,'&','&&');
   for (i=length(text);;--i) {
      if (i<1) {
         return(0);
      }
      if (substr(text,i,1)!=' ') {
         return(_text_width(substr(text,1,i)));
      }
   }
}
static _str _last_char2(_str text)
{
   //text=stranslate(text,'&','&&');
   //return(last_char(text));
   for (i=length(text);;--i) {
      if (i<1) {
         return(' ');
      }
      ch=substr(text,i,1);
      if (ch!=' ') {
         return(ch);
      }
   }
}
static int _text_width2Max(_str text,int max_font_flags)
{
   old_font_flags=_font_props2flags();
   _font_flags2props(max_font_flags);
   text=stranslate(text,'&','&&');
   for (i=length(text);;--i) {
      if (i<1) {
         width=0;
      }
      if (substr(text,i,1)!=' ') {
         width=_text_width(substr(text,1,i));
         break;
      }
   }
   _font_flags2props(old_font_flags);
   return(width);
}
/*
   max_font_flags       Usually 0 is specified to indicate that
                        some font flags are used by that consistent
                        word wrap is not necessary.
                        
                        -1 indicates that no font flags are used.
   
                        One or more of the flags below indicate
                             F_BOLD
                             F_ITALIC
                             F_UNDERLINE
                             
                        the largest possible font case.  Then variations
                        in the font will give the same word wrap
                        results.
                             
*/
void _CreateBoldItalicLabels(int &width,int &height,int &Noflines,
                             int parent_wid,_str msg,_str sepchars,
                             int start_x,int start_y,
                             int max_width,_str font_string,
                             int fg,int bg,int wrap_indent,int max_font_flags
                            )
{
#define DEBUG_CAPTION "LPCTSTR lpszCaption = NULL,"
   if (max_font_flags== -1) {
      max_font_flags=0;
   }
   parse font_string with font_name','font_size',';
   _str prefix="";
   boolean word_wrap=false;
   if (pos(' ',sepchars)) {
      word_wrap=true;
      sepchars=stranslate(sepchars,'',' ');
   }
   sepchars=stranslate(sepchars,'',"\n");
   if (max_font_flags) {
      prefix=prefix:+_chr(1)'<_MAXFONTFLAGS flags='max_font_flags'>';
   }
   if (sepchars!="") {
      prefix=prefix:+_chr(1)'<_sepchars sepchars="'sepchars'">';
   }
   if (wrap_indent) {
      prefix=prefix:+_chr(1)'<_hangingindent width='wrap_indent't>';
   }
   if (prefix!="") {
      msg=prefix:+msg;
   }
   //say('start_y='start_y);
   label_wid=_create_window(OI_LABEL,parent_wid,"",start_x,start_y,0,0,CW_CHILD,BDS_NONE);
   label_wid.p_MouseActivate=MA_NOACTIVATE;
   if (font_name!="") {
      label_wid.p_font_name=font_name;
   }
   if (isinteger(font_size)) {
      label_wid.p_font_size=font_size;
   }
   //label_wid.p_width=max_width;
   //label_wid.p_height=400;
   if (word_wrap) {
      label_wid.p_width=max_width;
      label_wid.p_word_wrap=true;
   }
   if (max_font_flags) {
      label_wid.p_width=max_width;
      if (sepchars:!='') {
         label_wid.p_word_wrap=true;
      }
   }
   //label_wid._font_flags2props(font_flags);
   //fsay('msg=<'msg'>');
   label_wid.p_caption=msg;
   //messageNwait('label_wid.p_caption='label_wid.p_caption);
   label_wid.p_forecolor=fg;
   label_wid.p_backcolor=bg;
   label_wid.p_auto_size=true;

   if (max_font_flags) {
      width=start_x+label_wid.p_width;
      //say('width='_lx2dx(SM_TWIP,width));
      label_wid.p_auto_size=false;
      label_wid.p_width=max_width;
   } else {
      if (label_wid.p_width>max_width) {
         label_wid.p_auto_size=false;
         label_wid.p_width=max_width;
         if (sepchars:!='') {
            label_wid.p_word_wrap=true;
         }
         label_wid.p_auto_size=true;
      }
      width=start_x+label_wid.p_width;
   }

   height=start_y+label_wid.p_height;
   Noflines=label_wid.p_height intdiv label_wid._text_height();
}
//#if 0
defeventtab _function_help_form
void vscroll1.on_change()
{
   p_prev.p_y=- ((p_value-1)*(p_prev.p_height/p_max));
}
void vscroll1.on_scroll()
{
   p_prev.p_y=- ((p_value-1)*(p_prev.p_height/p_max));
}
#if 0
void picture1.on_create()
{
   //msg="int myclass::myproc(\1uint p1\1e,\1b\1iint \1\blong\1u long long p2\1e,\1iint p3\1e)\n";
   msg="int this is a test this is a sfsdfsfd thi sdfs";
   //msg=msg:+msg;
   //msg=msg:+msg;
  _DisplayFunctionHelp(msg," ",
                       //(_twips_per_pixel_x()*4),(_twips_per_pixel_y()*2),
                       0,0,
                       _dx2lx(SM_TWIP,200),p_font_name','p_font_size,
                     0x80000020,0x80000021,5000,0,F_BOLD);
}
#endif
/*
   This function operates on a picture1 of the _function_help_form

   PARAMETERS
      msg     message with optional line breaks and the following font
              style encodings
                 \1b      Bold
                 \1i      Italic
                 \1u      Underline
                 \1e      End all styles
      sepchars  One or more characters after which line breaks are allowed.
                Space may be specified in this list.

      pad_x,pad_y   Amount in twips to pad left/right and top/bottom.
      max_width     Maximimum width of label text in twips.
      font_name     Font to be used for label text
      fg,bg         RGB foreground and background colors
      scroll_bar_height  If the label is taller than this, a scroll bar is used.

*/
void _DisplayFunctionHelp(_str msg,_str sepchars,
                     int pad_x,int pad_y,
                     int max_width,_str font_string,
                     int fg,int bg,int scroll_bar_height,
                     int wrap_indent,
                          int max_font_flags)
{
   p_x=0;p_y=0;
   p_child.p_x=p_child.p_y=0;
   p_child.p_forecolor=p_forecolor=fg;
   p_child.p_backcolor=p_backcolor=bg;
   p_child.p_visible=0;
   while (p_child.p_child) {
      p_child.p_child._delete_window();
   }
   p_window_id._CreateBoldItalicLabels(max_x,max_y,Noflines,p_child,msg,sepchars,pad_x,pad_y,
                         max_width,font_string,
                          p_forecolor,p_backcolor,wrap_indent,max_font_flags);
   //messageNwait('max_x='max_x' max_width='max_width);
   p_child.p_visible=1;
   p_child.p_MouseActivate=p_MouseActivate=MA_NOACTIVATE;
   height=max_y+pad_y;
   p_child.p_height=height;
   width=max_x+pad_x;
   //messageNwait('height='height);
   if (height>scroll_bar_height) {
      p_height=scroll_bar_height+_top_height()+_bottom_height();
      p_child.p_width=width;
      p_width=width+vscroll1.p_width+_left_width()*2;;
      vscroll1.p_y=0;
      vscroll1.p_x=width;
      vscroll1.p_height=scroll_bar_height;
      vscroll1.p_min=1;
      vscroll1.p_max=Noflines;
      vscroll1.p_value=1;
      vscroll1.p_MouseActivate=MA_NOACTIVATE;
   } else {
      vscroll1.p_visible=0;
      p_height=height+_top_height()+_bottom_height();
      p_child.p_width=width;
      p_width=width+_left_width()*2;
   }
   p_active_form.p_height=p_height+p_active_form._top_height()+p_active_form._bottom_height();
   p_active_form.p_width=p_width+p_active_form._left_width()*2;
}

// List globals in the current buffer (context)
// Current object must be editor control
//
void _CodeHelpListContextGlobals(int treewid, int tree_index,
                                 boolean check_context,typeless tag_files,
                                 _str lastid, _str lastid_prefix,
                                 int pushtag_flags, int context_flags,
                                 int &num_matches, int max_matches)
{
   //say("_CodeHelpListContextGlobals("lastid","lastid_prefix")");
   if (p_LangCaseSensitive) {
      tag_list_context_globals(treewid,tree_index,lastid,
                               check_context,tag_files,
                               pushtag_flags,context_flags,
                               num_matches,max_matches,false,true);
      if (num_matches >= max_matches) return;
   }
   tag_list_context_globals(treewid,tree_index,lastid,
                            check_context,tag_files,
                            pushtag_flags,context_flags,
                            num_matches,max_matches,false,false);
   if (lastid==lastid_prefix) return;
   if (num_matches >= max_matches) return;
   if (p_LangCaseSensitive) {
      tag_list_context_globals(treewid,tree_index,lastid_prefix,
                               check_context,tag_files,
                               pushtag_flags,context_flags,
                               num_matches,max_matches,false,true);
      if (num_matches >= max_matches) return;
   }
   tag_list_context_globals(treewid,tree_index,lastid_prefix,
                            check_context,tag_files,
                            pushtag_flags,context_flags,
                            num_matches,max_matches,false,false);
}

// List locals in the current function context
// Current object must be editor control
//
void _CodeHelpListContextLocals(int treewid, int tree_index, typeless tag_files,
                                _str lastid, _str lastid_prefix, _str search_class,
                                int pushtag_flags, int context_flags,
                                int &num_matches, int max_matches)
{

   //say("_CodeHelpListContextLocals("lastid","lastid_prefix")");
   if (p_LangCaseSensitive) {
      tag_list_class_locals(treewid,tree_index,tag_files,lastid,
                            search_class,pushtag_flags,context_flags,
                            num_matches,max_matches,false,true);
      if (num_matches >= max_matches) return;
   }
   tag_list_class_locals(treewid,tree_index,tag_files,lastid,
                         search_class,pushtag_flags,context_flags,
                         num_matches,max_matches,false,false);
   if (num_matches >= max_matches) return;

   // don't do the same thing twice
   if (lastid!=lastid_prefix) {
      if (p_LangCaseSensitive) {
         tag_list_class_locals(treewid,tree_index,tag_files,lastid_prefix,
                               search_class,pushtag_flags,context_flags,
                               num_matches,max_matches,false,true);
         if (num_matches >= max_matches) return;
      }
      tag_list_class_locals(treewid,tree_index,tag_files,lastid_prefix,
                            search_class,pushtag_flags,context_flags,
                            num_matches,max_matches,false,false);
      if (num_matches >= max_matches) return;
   }

   // don't do the same thing three times
   if (lastid_prefix!='') {
      if (p_LangCaseSensitive) {
         tag_list_class_locals(treewid,tree_index,tag_files,'',
                               search_class,pushtag_flags,context_flags,
                               num_matches,max_matches,false,true);
         if (num_matches >= max_matches) return;
      }
      tag_list_class_locals(treewid,tree_index,tag_files,'',
                            search_class,pushtag_flags,context_flags,
                            num_matches,max_matches,false,false);
      if (num_matches >= max_matches) return;
   }

   // maybe delete 'locals' category
   if (treewid > 0 && num_matches == 0) {
      int context_id = tag_current_context();
      if (context_id > 0) {
         tag_get_detail2(VS_TAGDETAIL_context_type, context_id, cur_type_name);
         if (!tag_tree_type_is_func(cur_type_name) && cur_type_name :!= 'proto') {
            context_id = 0;
         }
      }
      if (context_id <= 0) {
         treewid._TreeDelete(tree_index);
         return;
      }
   }
}

// List labels in the current function context
// Current object must be editor control
//
void _CodeHelpListLabels(int treewid, int tree_index,
                         _str cur_tag_type,_str cur_class_name,
                         int &num_matches, int max_matches)
{
   //say("_CodeHelpListLabels()");
   _str no_tag_files[]; no_tag_files._makeempty();
   tag_list_class_locals(treewid,tree_index,no_tag_files,'',
                         '',VS_TAGFILTER_LABEL,VS_TAGCONTEXT_ANYTHING,
                         num_matches,max_matches,false,false);

   // special case for package / program / module initialization code
   if (tag_tree_type_is_package(cur_tag_type)) {
      tag_list_class_context(treewid,tree_index,no_tag_files,'',cur_class_name,
                             VS_TAGFILTER_LABEL,VS_TAGCONTEXT_ANYTHING,
                             num_matches,max_matches,false,false);
   }
}

// List any symbols in the matching the identifier or identifier prefix
// Current object must be editor control
//
void _CodeHelpListAnySymbols(int treewid, int tree_index, typeless tag_files,
                             _str lastid, _str lastid_prefix,
                             int pushtag_flags, int context_flags,
                             int &num_matches, int max_matches)
{
   //say("_CodeHelpListAnySymbols("lastid","lastid_prefix")");

   if (p_LangCaseSensitive) {
      tag_list_any_symbols(treewid,tree_index,lastid,
                           tag_files,pushtag_flags,context_flags,
                           num_matches,max_matches,false,true);
      if (num_matches >= max_matches) return;
   }
   tag_list_any_symbols(treewid,tree_index,lastid,
                        tag_files,pushtag_flags,context_flags,
                        num_matches,max_matches,false,false);
   if (num_matches >= max_matches) return;

   if (lastid!=lastid_prefix) {
      if (p_LangCaseSensitive) {
         tag_list_any_symbols(treewid,tree_index,lastid_prefix,
                              tag_files,pushtag_flags,context_flags,
                              num_matches,max_matches,false,true);
         if (num_matches >= max_matches) return;
      }
      tag_list_any_symbols(treewid,tree_index,lastid_prefix,
                           tag_files,pushtag_flags,context_flags,
                           num_matches,max_matches,false,false);
      if (num_matches >= max_matches) return;
   }
}


// Sellist callback function to 
// Load the matches into the _sellist_form
_str _load_matches_in_sellist(int sl_event, _str &result_str, _str info)
{
   //say("_load_matches_in_sellist: sl_event="sl_event);
   _nocheck _control _sellist;
   if (sl_event == SL_ONINITFIRST) {
      _str select_list = '';
      if (_sellist.p_Noflines > 0) {
         _sellist.p_line = 1;
         select_list = _sellist._lbget_text();
      }
      cb_prepare_expand(p_active_form,_sellist.p_window_id,0);
      int i, a=0, n=tag_get_num_of_matches();
      _sellist.p_picture = _pic_fldopen;
      _sellist._lbclear();
      for (i=1; i<=n; i++) {
         tag_get_match(i, tag_files, tag_name, type_name, file_name, line_no, class_name, tag_flags, signature, return_type);
         tag_list_insert_tag(_sellist.p_window_id, 0, 60, tag_name, type_name, file_name, line_no, class_name, tag_flags, return_type"\1"signature);
      }
      _sellist._lbdeselect_all();
      int first_index = 0;
      while (select_list != '') {
         parse select_list with select_index select_list;
         //say("selecting line: "select_index);
         _sellist.p_line=select_index;
         _sellist._lbselect_line();
         if (first_index==0) {
            first_index=select_index;
         }
      }
      if (first_index<=0) {
         _lbtop();
      } else {
         _sellist.p_line=first_index;
      }
   } else if (sl_event==SL_ONDEFAULT) {  // Enter key
      result_str=''
      int status=_sellist._lbfind_selected(1);
      while (!status) {
         strappend(result_str, _sellist.p_line-1);
         strappend(result_str, ' ');
         status=_sellist._lbfind_selected(0);
      }
      strappend(result_str, ' ');
      //say("_load_matches_in_sellist: returns"result_str);
      return(1);
   }
   return '';
}
// Display the set of tags found in the tag database match set
// (created using tag_clear_matches, tag_insert_matches, or using
// tag_list_* context related functions targetting a match set.
// Allow the user to select one or more of the matches
int _list_tag_matches(_str caption, boolean allow_multiselect=false, _str initial_selections='')
{
   //say("_list_tag_matches: select="initial_selections);

   // create list of captions and tag information
   VS_TAG_BROWSE_INFO cm;
   VS_TAG_BROWSE_INFO taginfo[]; taginfo._makeempty();
   int i,num_matches=tag_get_num_of_matches();
   for (i=1; i<=num_matches; i++) {
      tag_get_match(i, cm.tag_database, cm.member_name, cm.type_name, cm.file_name, cm.line_no, cm.class_name, cm.flags, cm.arguments, cm.return_type);
      taginfo[i-1]=cm;
   }

   // set up SL_* flags for the _sellist_form
   int sl_flags = SL_DEFAULTCALLBACK;
   if (allow_multiselect) {
      sl_flags |= SL_ALLOWMULTISELECT|SL_SELECTALL;
   }

   //say("selections="initial_selections);

   // display the list of tags for selection, autosize dialog and show classes
   _str choices='';
   if (num_matches > 0) {
      _str option='-reinit';
      if (_find_object('_sellist_form')) {
         option='-new';
      }
      choices=show('_sellist_form -mdi -modal 'option,
                   caption,
                   sl_flags,
                   initial_selections,
                   '',  // buttons
                   '',  // help item name
                   '',  // font
                   _load_matches_in_sellist   // Call back function
                  );
   }
   if (choices :== '') {
      return -1;
   }

   // add only the items that they selected to the match list
   tag_clear_matches();
   num_matches = 0;
   while (choices != '') {
      parse choices with cnum choices;
      cm=taginfo[cnum];
      tag_insert_match(cm.tag_database,cm.member_name,cm.type_name,
                       cm.file_name,cm.line_no,cm.class_name,cm.flags,
                       cm.return_type:+VS_TAGSEPARATOR_args:+cm.arguments);
      num_matches++;
   }

   // return the number of matches selected
   return num_matches;
}
int _do_default_get_virtuals(_str parent_classes,  
                             _str &selection_indexes, boolean only_abstract,
                             boolean allow_locals, boolean case_sensitive)
{
   //say("_do_default_get_virtuals("parent_classes")");
   // normalize the parent class names
   int num_matches = 0;
   typeless tag_files = tags_filenamea(p_extension);
   _str normalized_parents = '';
   _str normalized_types = '';
   _NormalizeClassTypeList(parent_classes, tag_files, allow_locals, case_sensitive,
                           normalized_parents, normalized_types);

   // get the virtual methods from each parent class
   tag_clear_matches();
   while (normalized_parents != '') {
      // add transitively inherited class members
      parse normalized_parents with p1 ';' normalized_parents;
      parse normalized_types   with n1 ';' normalized_types;
      //say("p1="p1" n1="n1);
      _ListVirtualMethods(p1, n1, selection_indexes, only_abstract, 0, 0,
                          num_matches, VSCODEHELP_MAXFINDCONTEXTTAGS,
                          allow_locals, case_sensitive);
   }

   // return the number of matches
   return num_matches;
}

int _do_default_get_protos(_str search_class, boolean allow_locals, boolean case_sensitive)
{
   // get the list of project tag files
   _str tag_files[]; tag_files._makeempty();
   _str project_tag_files = project_tags_filename();
   while (project_tag_files != '') {
      _str tag_filename = next_tag_file2(project_tag_files, true, false);
      if (tag_filename!='') {
         tag_files[tag_files._length()]=tag_filename;
      }
   }

   // get the virtual methods from each parent class
   int num_matches = 0;
   tag_clear_matches();
   _MatchSymbolInContext('',search_class,num_matches,VSCODEHELP_MAXFINDCONTEXTTAGS,
                         VS_TAGFILTER_PROTO, true, false, false, false,
                         false, case_sensitive);

   // return the number of matches
   return num_matches;
}

int _do_default_get_classes(_str search_class, boolean allow_locals, boolean case_sensitive)
{
   // get the list of project tag files
   _str tag_files[]; tag_files._makeempty();
   _str project_tag_files = project_tags_filename();
   while (project_tag_files != '') {
      _str tag_filename = next_tag_file2(project_tag_files, true, false);
      if (tag_filename!='') {
         tag_files[tag_files._length()]=tag_filename;
      }
   }

   // get the virtual methods from each parent class
   int num_matches = 0;
   tag_clear_matches();
   _MatchSymbolInContext('',search_class,num_matches,VSCODEHELP_MAXFINDCONTEXTTAGS,
                         VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE,
                         true, false, false, false, false, case_sensitive);

   // return the number of matches
   return num_matches;
}

int _do_default_get_implement_list(_str class_name, _str parent_classes, int class_flags)
{
   //say("_do_default_get_implement_list("class_name','parent_classes')');
   // list the virtual methods for the given class
   _str selection_indexes = '';
   int GVindex = find_index('_'p_extension'_get_virtuals', PROC_TYPE);
   int num_matches = 0;
   if (index_callable(GVindex)) {
      num_matches = call_index(parent_classes, selection_indexes,
                               false, true, p_LangCaseSensitive, GVindex);
   } else {
      num_matches = _do_default_get_virtuals(parent_classes, selection_indexes, 
                                             false, true, p_LangCaseSensitive);
   }
   if (num_matches <= 0) {
      //_message_box('no matches found');
      return num_matches;
   }

   // create list of captions and tag information
   return _list_tag_matches(nls('Select virtual functions to override'),
                            true, selection_indexes);
}

// implements all members found in the given match set
int _do_default_generate_matches(int indent_col, int brace_indent, 
                                 boolean make_proto,
                                 boolean in_class_scope=true,
                                 int c_access_flags=VS_TAGFLAG_private)
{
   // see if code generation is supported
   int gen_index = find_index('_'p_extension'_generate_match_signature',PROC_TYPE);
   if (!gen_index) {
      _message_box("Code generation not supported for this language.");
      return(0);
   }

   // generate code for each match
   boolean CursorDone=false;
   save_pos(AfterKeyinPos);
   int match_id=0;
   int count=tag_get_num_of_matches();
   for (match_id=1; match_id<=count; ++match_id) {
      // get detailed information about the tag match
      tag_get_match(match_id,tag_file,tag_name,type_name,
                    file_name,line_no,class_name,
                    tag_flags,signature,return_type);

      // Can't we get source comments?
      _str header_list[];header_list._makeempty();
      _ExtractTagComments(header_list,2000,tag_name,file_name,line_no,
                          type_name, class_name, indent_col);

      // generate the match signature for this function, not a prototype
      c_access_flags=(tag_flags&VS_TAGFLAG_access);
      int akpos=call_index(match_id,c_access_flags,header_list,
                           indent_col,brace_indent,make_proto,
                           in_class_scope,gen_index);
      if (!CursorDone) {
         CursorDone=true;
         AfterKeyinPos = akpos;
      }
   }
   // restore cursor position and we're done
   restore_pos(AfterKeyinPos);
   return (0);
}

_command override_virtual() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   _UpdateContext(true);
   int context_id = tag_current_context();
   _str cur_class_name = '';
   _str cur_type_name = '';
   _str cur_parents = '';
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_class, context_id, cur_class_name);
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, cur_type_name);
      tag_get_detail2(VS_TAGDETAIL_context_parents, context_id, cur_parents);
      tag_get_detail2(VS_TAGDETAIL_context_flags, context_id, cur_tag_flags);
   }
   if (!tag_tree_type_is_class(cur_type_name) && !tag_tree_type_is_package(cur_type_name)) {
      _message_box("not in class context");
      return(1);
   }
   int is_abstract = 0;
   if (cur_tag_flags & VS_TAGFLAG_abstract) {
      is_abstract = 1;
   }
   if (cur_type_name == 'interface') {
      is_abstract = 1;
   }

   // find the virtual functions
   num_matches=_do_default_get_implement_list(cur_class_name, cur_parents, is_abstract);
   if (num_matches < 0) {
      return num_matches;
   }

   // create list of captions and tag information
   int orig_line=p_line;
   call_key(ENTER);
   if (p_line > orig_line) up();
   return _do_default_generate_matches(p_col-1,0,false);
}

_command implement_protos(_str class_name='') name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   _str no_tag_files[]; no_tag_files._makeempty();
   _UpdateContext(true);
   int context_id = tag_current_context();
   _str cur_class_name = '';
   boolean in_class_scope=false;
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_name, context_id, cur_tag_name);
      tag_get_detail2(VS_TAGDETAIL_context_class, context_id, cur_class_name);
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, cur_type_name);
      tag_get_detail2(VS_TAGDETAIL_context_parents, context_id, cur_parents);
      tag_get_detail2(VS_TAGDETAIL_context_flags, context_id, cur_tag_flags);

      if (tag_tree_type_is_class(cur_type_name) || tag_tree_type_is_package(cur_type_name)) {
         cur_class_name = tag_join_class_name(cur_tag_name, cur_class_name,
                                              no_tag_files, p_LangCaseSensitive);
         in_class_scope=true;
      }
   }

   // list the classes in the current scope if not already in a class
   _str selection_indexes = '';
   int num_matches = 0;
   if (!tag_tree_type_is_class(cur_type_name)) {
      if (class_name!='') {
         cur_class_name=class_name;
      } else {
         int GCindex = find_index('_'p_extension'_get_classes', PROC_TYPE);
         if (index_callable(GCindex)) {
            num_matches = call_index(cur_class_name, true, p_LangCaseSensitive, GCindex);
         } else {
            num_matches = _do_default_get_classes(cur_class_name, true, p_LangCaseSensitive);
         }
         if (num_matches > 0) {
            num_matches = _list_tag_matches(nls('Select class to implement functions in'),
                                            false, selection_indexes);
            if (num_matches < 0) {
               return num_matches;
            } else if (num_matches==1) {
               typeless tag_files = tags_filenamea();
               tag_get_detail2(VS_TAGDETAIL_match_name, 1, cur_tag_name);
               tag_get_detail2(VS_TAGDETAIL_match_class, 1, cur_class_name);
               tag_get_detail2(VS_TAGDETAIL_match_type, 1, cur_type_name);
               tag_get_detail2(VS_TAGDETAIL_match_parents, 1, cur_parents);
               tag_get_detail2(VS_TAGDETAIL_match_flags, 1, cur_tag_flags);
               if (tag_tree_type_is_class(cur_type_name) || tag_tree_type_is_package(cur_type_name)) {
                  cur_class_name = tag_join_class_name(cur_tag_name, cur_class_name,
                                                       tag_files, p_LangCaseSensitive);
               }
            }
         }
      }
   }

   // list the virtual methods for the given class
   int GVindex = find_index('_'p_extension'_get_protos', PROC_TYPE);
   if (index_callable(GVindex)) {
      num_matches = call_index(cur_class_name, true, p_LangCaseSensitive, GVindex);
   } else {
      num_matches = _do_default_get_protos(cur_class_name, true, p_LangCaseSensitive);
   }
   if (num_matches <= 0) {
      _message_box('no matches found');
      return num_matches;
   }

   // create list of captions and tag information
   num_matches = _list_tag_matches(nls('Select functions to implement'),
                                   true, selection_indexes);
   if (num_matches < 0) {
      return num_matches;
   }
   int orig_line=p_line;
   call_key(ENTER);
   if (p_line > orig_line) up();
   return _do_default_generate_matches(p_col-1,0,false,in_class_scope);
}

void get_comment_delims(_str ext, _str &slcomment_start,
                        _str &mlcomment_start, _str &mlcomment_end)
{
   // get the multi-line comment start string
   switch (p_extension) {
   case 'pas':
   case 'mod':
      mlcomment_start = '(*';
      mlcomment_end   = '*)';
      slcomment_start = '';
      break;
   case 'ada':
      mlcomment_start = '';
      mlcomment_end   = '';
      slcomment_start = '--';
      break;
      break;
   case 'pl':
   case 'bourneshell':
   case 'csh':
   case 'tcl':
      mlcomment_start = '';
      mlcomment_end   = '';
      slcomment_start = '#';
      break;
   case 'bas':
      mlcomment_start = '';
      mlcomment_end   = '';
      slcomment_start = "'";
      break;
   case 'f':
      mlcomment_start = '';
      mlcomment_end   = '';
      slcomment_start = '!';
      break;
   case 'asm':
      mlcomment_start = '';
      mlcomment_end   = '';
      slcomment_start = ';';
      break;
   case 'cob':
      mlcomment_start = '';
      mlcomment_end   = '';
      slcomment_start = '      *';
      break;
   case 'awk':
      mlcomment_start = '/*';
      mlcomment_end   = '*/';
      slcomment_start = '#';
      break;
   default: // C, C++, Java, E, JavaScript
      mlcomment_start = '/*';
      mlcomment_end   = '*/';
      slcomment_start = '//';
      break;
   }
}

/**
 * Create a javadoc-style comment for the current function
 * @return typeless
 */
_command javadoc_comment() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   _UpdateContext(true);
   save_pos(p);

   // try to locate the current context, maybe skip over
   // comments to start of next tag
   int context_id = tag_current_context();
   if ((context_id<=0 || _in_comment()) && !_clex_skip_blanks()) {
      context_id = tag_current_context();
   }
   if (context_id <= 0) {
      restore_pos(p);
      _message_box('no current tag');
      return context_id;
   }

   // get the information about the current function
   tag_get_context(context_id, tag_name, type_name, file_name,
                   start_line_no, start_seekpos, scope_line_no,
                   scope_seekpos, end_line_no, end_seekpos,
                   class_name, tag_flags, signature, return_type);

   // get the start column of the tag, align new comment here
   p_line=start_line_no;
   _nrseek(start_seekpos);
   int start_col = p_col;
   if (tag_tree_type_is_func(type_name)) {
      _UpdateLocals(true);
   }

   // get the multi-line comment start string
   _str slcomment_start;
   _str mlcomment_start;
   _str mlcomment_end;
   get_comment_delims(p_extension,slcomment_start,mlcomment_start,mlcomment_end);

   // hash table of original comments for incremental updates
   _str orig_comment='';
   int first_line, last_line;
   if (!_do_default_get_tag_header_comments(first_line, last_line)) {
      p_line=start_line_no;
      _nrseek(start_seekpos);
      _do_default_get_tag_comments(type_name, orig_comment, 1000, false);
   } else {
      first_line = start_line_no;
      last_line  = first_line-1;
   }

   // delete the original comment lines
   int num_lines = last_line-first_line+1;
   if (num_lines > 0) {
      p_line=first_line;
      for (i=0; i<num_lines; i++) {
         delete_line();
      }
   } else {
      first_line=start_line_no;
   }

   // insert the comment start string and juggle slcomment if needed
   if (first_line>1) {
      p_line=first_line-1;
   } else {
      top();up();
   }
   if (mlcomment_start!='') {
      insert_line(indent_string(start_col-1):+mlcomment_start'*');
      slcomment_start='';
      if (pos('*',mlcomment_start)) {
         slcomment_start=' *';
      }
   }
   _str prefix=indent_string(start_col-1):+slcomment_start:+' ';

   // parse the parts out of the original comment
   _str orig_parts:[];
   orig_parts._makeempty();
   int first_param_pos=0;
   _str cmt = orig_comment;
   _str part_key = '';
   while (cmt!='') {
      parse cmt with one_line "\n" cmt;
      if (pos('@',one_line)==1) {
         parse one_line with "@" kw id .;
         if (lowcase(kw)=='param') {
            part_key='@param'id;
            orig_parts:[part_key] = one_line;
            if (!first_param_pos) {
               save_pos(first_param_pos);
            }
         } else if (lowcase(kw)=='return') {
            part_key='@return';
            orig_parts:[part_key] = one_line;
         } else {
            part_key='';
         }
      }
      // either append to the current key or re-insert line
      if (part_key!='') {
         if (pos('@',one_line)!=1) {
            orig_parts:[part_key] = orig_parts:[part_key]"\n"one_line;
         }
      } else {
         insert_line(prefix:+one_line);
      }
   }

   // insert the original parts of the comment (description)
   typeless cursor_pos=null;
   if (orig_comment=='') {
      insert_line(prefix);
      save_pos(cursor_pos);
   }
   if (!first_param_pos) {
      save_pos(first_param_pos);
   }
   if (mlcomment_start!='') {
      insert_line(indent_string(start_col):+mlcomment_end);
   }

   // insert the parameter descriptions, recycle old ones
   if (first_param_pos>1) {
      restore_pos(first_param_pos);
   }
   for (i=1; i<=tag_get_num_of_locals(); i++) {
      tag_get_detail2(VS_TAGDETAIL_local_type,i,param_type);
      if (param_type=='param') {
         tag_get_detail2(VS_TAGDETAIL_local_name,i,param_name);
         if (orig_parts._indexin('@param'param_name)) {
            cmt = orig_parts:['@param'param_name];
            orig_parts._deleteel('@param'param_name);
            while (cmt!='') {
               parse cmt with one_line "\n" cmt;
               insert_line(prefix:+one_line);
            }
         } else {
            insert_line(prefix'@param 'param_name);
         }
      }
   }
   boolean hit_param=false;
   for (i._makeempty();;) {
       orig_parts._nextel(i);
       if (i._isempty()) break;
       if (substr(i,1,6)=='@param') {
          if (!hit_param) {
             insert_line(prefix'---start old parameters---');
             hit_param=1;
          }
          cmt = orig_parts:[i];
          while (cmt!='') {
             parse cmt with one_line "\n" cmt;
             insert_line(prefix:+one_line);
          }
       }
   }
   if (hit_param) {
      insert_line(prefix'---end old parameters---');
   }

   // insert the return type description, recycle old one if present
   if (orig_parts._indexin('@return') && orig_parts:['@return']!='') {
      cmt = orig_parts:['@return'];
      while (cmt!='') {
         parse cmt with one_line "\n" cmt;
         insert_line(prefix:+one_line);
      }
   } else if (return_type != '') {
      insert_line(prefix'@return 'return_type);
   }
   if (cursor_pos!=null) {
      restore_pos(cursor_pos);
   }

   // restore the search and current position
   _macro_append('javadoc_comment();');
   return(0);
}

// create error code for code help functions
_str _CodeHelpRC(int status,_str (&errorArgs)[])
{
   switch (status) {
   case VSCODEHELPRC_CONTEXT_NOT_VALID:
      return nls('Context not valid',errorArgs);
   case VSCODEHELPRC_NOT_IN_ARGUMENT_LIST:
      return nls('The cursor is not in a function argument list',errorArgs);
   case VSCODEHELPRC_NO_HELP_FOR_FUNCTION:
      if (errorArgs._varformat()==VF_EMPTY) {
         return nls('No help found for this function',errorArgs);
      } else {
         return nls('No help found for this function: %s1',errorArgs);
      }
   case VSCODEHELPRC_NO_SYMBOLS_FOUND:
      return nls('No symbols found matching %s1',errorArgs);
   case VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX:
      return nls('The expression (%s1) is too complex',errorArgs);
   case VSCODEHELPRC_UNABLE_TO_EVALUATE_CONTEXT:
      return nls('Unable to evaluate type expression (%s1)',errorArgs);
   case VSCODEHELPRC_DOT_FOR_POINTER:
      return nls('Attempt to use operator "%s1", but variable %s2 is a pointer',errorArgs);
   case VSCODEHELPRC_DASHGREATER_FOR_NON_POINTER:
      return nls('Attempt to use operator "%s1", but variable %s2 is not a pointer',errorArgs);
   case VSCODEHELPRC_INVALID_NEW_EXPRESSION:
      return nls('Unable to evaluate "new" expression (%s1)',errorArgs);
   case VSCODEHELPRC_PARENTHESIS_MISMATCH:
      return nls('Unable to evaluate expression with mismatched parenthesis',errorArgs);
   case VSCODEHELPRC_BRACKETS_MISMATCH:
      return nls('Unable to evaluate expression with mismatched brackets',errorArgs);
   case VSCODEHELPRC_DASHGREATER_FOR_PTR_TO_POINTER:
      return nls('Attempt to use operator "%s1", but variable %s2 is a pointer to pointer',errorArgs);
   case VSCODEHELPRC_SUBSCRIPT_BUT_NOT_ARRAY_TYPE:
      return nls('Attempt to use subscript "[]", but variable %s1 is not an array type',errorArgs);
   case VSCODEHELPRC_OVERLOADED_RETURN_TYPE:
      return nls('Unable to determine type due to overloaded symbol %s1',errorArgs);
   case VSCODEHELPRC_NOT_A_TEMPLATE_CLASS:
      return nls('Template parameters found, but class %s1 is not a template',errorArgs);
   case VSCODEHELPRC_RETURN_TYPE_NOT_FOUND:
      return nls('Unable to locate definition of expression type: %s1',errorArgs);
   case VSCODEHELPRC_TEMPLATE_ARGS_MISMATCH:
      return nls('Unable to evaluate expression with mismatched template arguments',errorArgs);
   case VSCODEHELPRC_BUILTIN_TYPE:
      return nls('Symbol %s1 is declared as a simple type %s2',errorArgs);
   case VSCODEHELPRC_NO_LABELS_DEFINED:
      return nls('No labels defined in current function or procedure');
   case VSCODEHELPRC_DOT_FOR_ARRAY:
      return nls('Attempt to use operator "%s1", but variable %s2 is an array',errorArgs);
   }
   if (errorArgs[0]._varformat() == VF_LSTR) {
      return nls(errorArgs[0], errorArgs);
   }
   return '';
}
