// vsproxy

/* Used with _ftpQEHandler_RecvCmd() handler.
 * Pointer-to-function to call when tracking transfer progress.
 */
typedef void (*pfnProgressCallback_tp)(_str operation,int nofbytes,int total_nofbytes);
/* Used with _ftpQEHandler_RecvCmd() handler.
 * Struct that is passed with QE_RECV_CMD.
 */
typedef struct RecvCmd_s {
   boolean pasv;
   _str cmdargv[];
   _str dest;
   _str datahost;
   _str dataport;
   int  size;
   _str extra;   // Optional info specific to the caller
   pfnProgressCallback_tp ProgressCB;
} RecvCmd_t;
typedef struct SendCmd_s {
   boolean pasv;
   _str cmdargv[];
   _str src;
   _str datahost;
   _str dataport;
   int  size;
   pfnProgressCallback_tp ProgressCB;
} SendCmd_t;
typedef struct CustomCmd_s {
   _str pattern;
   _str cmdargv[];
} CustomCmd_t;
#if __UNIX__
   #define VSPROXY_COMMAND "vsproxy"
#else
   #define VSPROXY_COMMAND "vsproxy.exe"
#endif
#define QE_FIRST (1)
#define QE_START_CONN_PROFILE (QE_FIRST)
#define QE_PROXY_CONNECT      (QE_FIRST+1)
#define QE_RELAY_CONNECT      (QE_FIRST+2)
#define QE_PROXY_OPEN         (QE_FIRST+3)
#define QE_OPEN               (QE_FIRST+4)
#define QE_USER               (QE_FIRST+5)
#define QE_PASS               (QE_FIRST+6)
#define QE_CDUP               (QE_FIRST+7)
#define QE_CWD                (QE_FIRST+8)
#define QE_PWD                (QE_FIRST+9)
#define QE_MKD                (QE_FIRST+10)
#define QE_DELE               (QE_FIRST+11)
#define QE_RMD                (QE_FIRST+12)
#define QE_RENAME             (QE_FIRST+13)
#define QE_RECV_CMD           (QE_FIRST+14)
#define QE_SEND_CMD           (QE_FIRST+15)
#define QE_END_CONN_PROFILE   (QE_FIRST+16)
#define QE_PROXY_QUIT         (QE_FIRST+17)
#define QE_KEEP_ALIVE         (QE_FIRST+18)
#define QE_CUSTOM_CMD         (QE_FIRST+19)
#define QE_SYST               (QE_FIRST+20)
#define QE_ERROR              (QE_FIRST+21)
#define QE_LAST               QE_ERROR

#define QS_FIRST (1)
#define QS_BEGIN                              (QS_FIRST)
#define QS_WAITING_FOR_REPLY                  (QS_FIRST+1)
#define QS_LISTENING                          (QS_FIRST+2)
#define QS_PROMPT                             (QS_FIRST+3)
#define QS_PORT_BEGIN                         (QS_FIRST+4)
#define QS_PORT_WAITING_FOR_REPLY             (QS_FIRST+5)
#define QS_PASV_BEGIN                         (QS_FIRST+6)
#define QS_PASV_WAITING_FOR_REPLY             (QS_FIRST+7)
#define QS_PROXY_OPENDATA_BEGIN               (QS_FIRST+8)
#define QS_PROXY_OPENDATA_WAITING_FOR_REPLY   (QS_FIRST+9)
#define QS_PROXY_LISTENDATA_BEGIN             (QS_FIRST+10)
#define QS_PROXY_LISTENDATA_WAITING_FOR_REPLY (QS_FIRST+11)
#define QS_TYPE_BEGIN                         (QS_FIRST+12)
#define QS_TYPE_WAITING_FOR_REPLY             (QS_FIRST+13)
#define QS_CMD_BEGIN                          (QS_FIRST+14)
#define QS_CMD_WAITING_FOR_REPLY              (QS_FIRST+15)
#define QS_PROXY_RECVDATA_BEGIN               (QS_FIRST+16)
#define QS_PROXY_RECVDATA_WAITING_FOR_REPLY   (QS_FIRST+17)
#define QS_PROXY_SENDDATA_BEGIN               (QS_FIRST+18)
#define QS_PROXY_SENDDATA_WAITING_FOR_REPLY   (QS_FIRST+19)
#define QS_PROXY_DATASTAT_BEGIN               (QS_FIRST+20)
#define QS_PROXY_DATASTAT_WAITING_FOR_REPLY   (QS_FIRST+21)
#define QS_PROXY_CLOSEDATA_BEGIN              (QS_FIRST+22)
#define QS_PROXY_CLOSEDATA_WAITING_FOR_REPLY  (QS_FIRST+23)
#define QS_END_TRANSFER_WAITING_FOR_REPLY     (QS_FIRST+24)
#define QS_RNFR_WAITING_FOR_REPLY             (QS_FIRST+25)
#define QS_RNTO_WAITING_FOR_REPLY             (QS_FIRST+26)
#define QS_ERROR                              (QS_FIRST+27)
#define QS_ABORT                              (QS_FIRST+28)
#define QS_ABORT_WAITING_FOR_REPLY            (QS_FIRST+29)
#define QS_END                                (QS_FIRST+30)
#define QS_LAST                               (QS_END)

#define EOL "\n"
#define FTP_ALLFILES_RE "*"

#define INVALID_SOCKET (-1)

#define FTP_ERRORBOX_TITLE "FTP Error"

// Error return codes
#define FTP_USER_RC                      (5000)
#define FTP_INVALID_HOST_RC              (FTP_USER_RC)
#define FTP_GENERAL_ERROR_RC             (FTP_USER_RC+1)
#define FTP_BAD_RESPONSE_RC              (FTP_USER_RC+2)
#define FTP_BAD_SOCKET_RC                (FTP_USER_RC+3)
#define FTP_CONNECTION_DEAD_RC           (FTP_USER_RC+4)
#define FTP_ERROR_CREATING_TEMP_FILE_RC  (FTP_USER_RC+5)
#define FTP_ERROR_CREATING_LOCAL_FILE_RC (FTP_USER_RC+6)
#define FTP_CANNOT_FIND_PROXY_RC         (FTP_USER_RC+7)
#define FTP_ERROR_RUNNING_PROXY_RC       (FTP_USER_RC+8)
#define FTP_CUSTOM_ERROR_RC              (FTP_USER_RC+9)
#define FTP_WAITING_FOR_REPLY_RC         (FTP_USER_RC+10)

// Default values for a connection profile
#define FTPDEF_TIMEOUT (30)
#define FTPDEF_ANONYMOUS_USERID "anonymous"
#define FTPDEF_ANONYMOUS_PASS   "guest"
#define FTPDEF_PORT (21)

#define KEEP_ALIVE_IDLETIME (90)

// ON_CREATE flags for _ftpCreateProfile_form
#define FCPFLAG_LOGIN           (0x1)
#define FCPFLAG_NOSAVEPROFILE   (0x2)
#define FCPFLAG_HIDESAVEPROFILE (0x4)
#define FCPFLAG_SAVEPROFILEOFF  (0x8)
#define FCPFLAG_DISABLEPROFILE  (0x10)

typedef struct ftpOptions_s {
   _str    email;
   _str    deflocaldir;
   int     put;
   boolean resolvelinks;
   int     timeout;
   int     port;
   boolean keepalive;
#define FTPFILECASE_PRESERVE (0x1)
#define FTPFILECASE_LOWER    (0x2)
#define FTPFILECASE_UPPER    (0x3)
   int     uploadcase;
   _str    fwhost;
   int     fwport;
   _str    fwuserid;
   _str    fwpassword;
   int     fwtype;
   boolean fwpasv;
   boolean fwenable;
} ftpOptions_t;

typedef struct ftpFile_s {
   _str filename;
#define FTPFILETYPE_DIR  (0x1)
#define FTPFILETYPE_LINK (0x2)
   int  type;   // Is this file a directory/symlink?
   int  size;
   _str month;
   int  day;
   int  year;
   _str time;
   _str attribs;
   _str owner;
   _str group;
   int  refs;   // Number of file references
} ftpFile_t;

typedef struct ftpDirectory_s {
   ftpFile_t files[];
} ftpDirectory_t;

// Pointer-to-function to call when the queue processes the last event and goes idle
typedef void (*pfnPostCallback_tp)(.../*ftpQEvent_t *e_p*/);

typedef struct ftpConnProfile_s {
   _str    ProfileName;
   int     Instance;           /* Connection instance. This will normally be 0,
                                * but if the user starts the same connection
                                * profile more than once, then this number will
                                * be incremented to reflect the number of instances
                                * currently started.
                                */
   _str    Host;               // Name of the FTP server
   _str    UserID;             // User/Login ID
   _str    Password;           // This will be scrambled
   boolean Anonymous;          // true='anonymous' ftp login
   boolean SavePassword;       // true=save password
#define FTPXFER_ASCII  (1)
#define FTPXFER_BINARY (2)
   int     XferType;           // Transfer type (i.e. ascii/binary)
   _str    DefRemoteHostDir;   // Default remote host directory
   _str    DefLocalDir;        // Default local directory

   int     Port;               // remote FTP port to connect to (default=21)
   int     Timeout;            // (seconds) timeout to wait for a response from FTP server
   boolean UseFW;              // true=Use firewall/proxy to connect
   boolean KeepAlive;          // true=Keep connection alive
   int     UploadCase;         // File-case to use when STORing files (i.e. preserve, lower, upper)
   boolean ResolveLinks;       // Resolve file/directory links?

   ftpOptions_t Options;       // Global ftp options (e.g. firewall settings, etc.)

   _str LastStatusLine;        /* Last response line from ftp server that had
                                * a code. Example:
                                *
                                * 200 PORT command successful.
                                */

   int     sock;               // Currently connected FTP control socket
   int     vsproxy_sock;       // Currently connected control socket to the Visual SlickEdit proxy
   boolean VSProxy;            // true=Asynchronous operation so VSE is not tied up
   _str    LogBufName;         // buffer name of the log buffer
   ftpDirectory_t RemoteDir;   // Remote file/directory list struct
   _str    LocalCWD;           // Local Current Working Directory
   _str    RemoteCWD;          // Remote Current Working Directory
   _str    CwdHist[];          // History of all directories the user changed to
   _str    LocalFileFilter;    // Filespec to filter local directory listings
   _str    RemoteFileFilter;
   _str    RemoteRoot;         // Used to map remote paths onto local paths
   _str    LocalRoot;          // Used to map remote paths onto local paths

   _str    Reply;              /* Buffered reply from ftp server or VSE proxy.
                                * This is used in asynchronous operation to
                                * keep track of a server/VSE proxy response.
                                */
   int     Idle;               /* Used to keep track of how long a connection
                                * is idle by the ftp queue for the purpose of
                                * keeping the connection alive.
                                */
#define FTPOS_AUTO    (0)
#define FTPOS_UNIX    (1)
#define FTPOS_WINNT   (2)
#define FTPOS_VOS     (3)   /* e.g. a Stratus box running VOS */
#define FTPOS_MVS     (4)   /* e.g. an OS/390 box */
#define FTPOS_DEFAULT FTPOS_UNIX
   int     System;             // Host operating system name returned by SYST command
   // Pointer-to-function to call when the queue processes the last event and goes idle
   pfnPostCallback_tp PostedCB;
} ftpConnProfile_t;

typedef struct ftpQEvent_s {
   int event;              // Event to be processed (see QE_*)
   int state;              // State of the event (i.e. waiting for a reply, etc.)
   int start;              // Time (in milliseconds) that this event started
   ftpConnProfile_t fcp;   // Connection profile that this event affects
   typeless info[];        // Extra info depending on the event
} ftpQEvent_t;

typedef struct ftpFileHistFile_s {
   _str local_path;   /* Local filename (this would be mapped to an
                       * absolute remote path on an 8.3 file system).
                       */
} ftpFileHistFile_t;
typedef struct ftpFileHist_s {
   ftpFileHistFile_t files:[];   /* This hash table is indexed by the absolute
                                  * remote path and contains various information
                                  * about the remote file (e.g. local filename
                                  * mapping when on 8.3 file systems, trasfer
                                  * type, etc.).
                                  */
} ftpFileHist_t;

#define FTP_MICROEDGE_PROFILE_NAME "MicroEdge"
#define FTP_MICROEDGE_PROFILE_DATA "host=ftp.slickedit.com\n"\
                                   "userid=":+FTPDEF_ANONYMOUS_USERID:+"\n"\
                                   "password=":+FTPDEF_ANONYMOUS_PASS:+"\n"\
                                   "anonymous=1\n"\
                                   "savepassword=1\n"\
                                   "defremotehostdir=.\n"\
                                   "deflocaldir=.\n"\
                                   "xfertype=":+FTPXFER_BINARY:+"\n"\
                                   "port=21\n"\
                                   "timeout=30\n"\
                                   "keepalive=0\n"\
                                   "usefw=0\n"\
                                   "uploadcase=":+FTPFILECASE_PRESERVE:+"\n"\
                                   "resolvelinks=0\n"\
                                   "localroot=\n"\
                                   "remoteroot=\n"

// Common options
#define FTPOPT_EXPLICIT_PUT (0)
#define FTPOPT_PROMPTED_PUT (1)
#define FTPOPT_ALWAYS_PUT   (2)
#define FTPOPT_FWTYPE_USERAT (0)
#define FTPOPT_FWTYPE_OPEN   (1)
#define FTPOPT_FWTYPE_ROUTER (2)
#define FTP_DEFAULT_OPTIONS "email=guest\n"\
                            "deflocaldir=\n"\
                            "put=":+FTPOPT_PROMPTED_PUT:+"\n"\
                            "resolvelinks=0\n"\
                            "timeout=":+FTPDEF_TIMEOUT:+"\n"\
                            "port=":+FTPDEF_PORT:+"\n"\
                            "keepalive=0\n"\
                            "uploadcase=":+FTPFILECASE_PRESERVE:+"\n"\
                            "fwhost=\n"\
                            "fwport=":+FTPDEF_PORT:+"\n"\
                            "fwuserid=\n"\
                            "fwpassword=\n"\
                            "fwtype=":+FTPOPT_FWTYPE_USERAT:+"\n"\
                            "fwpasv=0\n"\
                            "fwenable=0\n"
#if __UNIX__
   #define FTP_USER_INI_FILENAME "uftp.ini"
#else
   #define FTP_USER_INI_FILENAME "ftp.ini"
#endif

/* _ftpQ cannot be static, otherwise it would get blown away when user
 * re-load()s.
 */
ftpQEvent_t _ftpQ[];

// Timer callback for the FTP queue
void _ftpQTimerCallback();

/* FTP files that have been opened within Visual SlickEdit for editing.
 * This hash table will be indexed by the host name of an ftp file.
 * Each entry contains another hash table of the remote files that have
 * been opened for the particular host along with various properties
 * (i.e. locally mapped filename, transfer type, etc.).
 */
ftpFileHist_t _ftpFileHist:[];

/* This MUST be global because a load() would wipe out the list and we
 * would be left with a bunch of "zombie" sockets left open without any
 * way of getting to them. _exit_ftp() takes care of emptying this array
 * when the editor exits.
 */
ftpConnProfile_t _ftpCurrentConnections:[];

int _pic_ftpcdup;
int _pic_ftpfile;
int _pic_ftpfold;
int _pic_ftplfol;
int _pic_ftplfil;

void _ftpopenProgressCB(_str operation,int nofbytes,int total_nofbytes);
void _ftpopenProgressDlgCB(_str operation,int nofbytes,int total_nofbytes);

#define FTPDEBUG_LOG_PROXY  (0x1)
#define FTPDEBUG_SAY_EVENTS (0x2)
#define FTPDEBUG_SAVE_LOG   (0x4)
#define FTPDEBUG_TIME_STAMP (0x8)
#define FTPDEBUG_SAVE_LIST  (0x10)
int _ftpdebug=0;

boolean gftpAbort;   // Used by _ftpProgress_form

