/*
$VerboseHistory: hex.e$
*/
#include "slick.sh"

#if __UNIX__
_str def_hex_display_xlat=_reinit
       //0123456789 0 123 45678901234567890
        ".........\t\n..\r.................. !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~................................................................................................................................";
#elif 1
_str def_hex_display_xlat=_reinit
       //0 123456789 0 123 45678901234567890
        "\0\t\n\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\x7f\x80\x81\x82\x83\x84\x85\0x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xab\xac\xad\xae\xaf\xb0\xb1\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xbb\xbc\xbd\xbe\xbf\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb\xdc\xdd\xde\xdf\xe0\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xeb\xec\xed\xee\xef\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff";
#endif
int _OnUpdate_hex(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED);
   }
   if (p_hex_mode) {
      return(MF_CHECKED|MF_ENABLED);
   }
   return(MF_UNCHECKED|MF_ENABLED);
}
_command void hex() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL)
{
   if (p_hex_mode) {
      p_on_event=0;
      p_hex_mode=0;
      if (p_display_xlat:==def_hex_display_xlat) {
         p_display_xlat="";
      }
   } else {
      if (p_display_xlat:=="") {
         p_display_xlat=def_hex_display_xlat;
      }
      p_on_event=find_index('_on_hex',PROC_TYPE)
      p_hex_mode=1;
      p_hex_nibble=0;
   }
}

void _on_hex()
{
   key=last_event()                 /* Key that was actually pressed. */
   keymsg=last_index('','p')     /* Prefix key(s) message */
   kt_index=last_index('','k')
   command_index=eventtab_index(kt_index,kt_index,event2index(key))
   flags=name_info_arg2(command_index)
   if (!isinteger(flags)) flags=0;
   if (p_scroll_left_edge>=0 && !(flags&VSARG2_NOEXIT_SCROLL) && (name_type(command_index) & COMMAND_TYPE)) {
      // Exit scroll mode.
      p_scroll_left_edge=(-1);
      //sticky_message("flags="flags" cmd="name_name(command_index));
      //_beep();
   }
   if (keymsg:!='' || event2index(key)>=ON_FIRST_I) {
      call_key key,keymsg,'e'
      return;
   }
   if (command_state()) {
      if ((flags & (VSARG2_CMDLINE|VSARG2_TEXT_BOX)) ||
          (length(key)==1 && !command_index)) {
         call_key key,keymsg,'e'
      }
      return;
   }
   switch (key) {
   case BACKSPACE:
      if (_QReadOnly() ||
         (_select_type()!='' && def_persistent_select=='D')) {
         call_key key,keymsg,'e'
         return;
      }
      _macro_call("hex_backspace");
      hex_backspace();
      return;
   case DEL:
      if (_QReadOnly()||
         (_select_type()!='' && def_persistent_select=='D')) {
         call_key key,keymsg,'e'
         return;
      }
      _macro_call("hex_del");
      hex_del();
      return;
   case TAB:
   case S_TAB:
      _macro_call("hex_tab");
      hex_tab();
      return;
   }
   if (_QReadOnly()||
        (_select_type()!='' && def_persistent_select=='D' &&
        !(def_keys=='vi-keys' && vi_get_vi_mode()=='C'))
      ) {
      call_key key,keymsg,'e'
      return;
   }
   keya=key;
   if (!command_index) {
      keya=key2ascii(key);
   }
   if (length(keya)==1 && _asc(keya)>=32) {
      hex_keyin();
      if (p_hex_field) {
         _undo('s');
      }
      return;
   }
   call_key key,keymsg,'e'
}
_command void hex_keyin() name_info(','VSARG2_MARK|VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   if (command_state()) {
      keyin(last_event());
      return;
   }
   maybe_delete_selection();
   _hex_keyin(last_event());
}
static _str hex2digit="0123456789ABCDEF";
void _hex_keyin(_str string)
{
   // IF we are on right in ASCII
   for (i=1;i<=length(string);++i) {
      ch=substr(string,i,1);
      if (_on_line0()) {
         _nrseek(0);
         offset=_nrseek();
         if (offset<0) {
            insert_line('');
            // Remove NLChars
            _delete_text(2);
         }
      }
      if (!p_hex_field) {
         if (_insert_state()) {
            _insert_text(ch,1);
         } else {
            _delete_text();
            _insert_text(ch,1);
         }
         p_hex_nibble=0;
         return;
      }
      j=pos(ch,hex2digit,1,'i');
      if (!j) {
         _beep();
         return;
      }
      --j;
      if (p_hex_nibble) {
         curch=get_text();
         _delete_text();
         _insert_text(_chr((_asc(curch)&0xf0)|j),1);
         p_hex_nibble=0;
      } else {
         if (_insert_state()) {
            _insert_text(_chr(j<<4),1);
         } else {
            curch=get_text();
            _delete_text();
            _insert_text(_chr((_asc(curch)&0x0f)|(j<<4)),1);
         }
         offset=_nrseek();
         _nrseek(offset-1);
         /*if (p_col==1) {
            offset=_nrseek();
            _nrseek(offset-1);
         } else {
            left();
         } */
         p_hex_nibble=1;
      }
   }
}

_command void hex_tab() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   if (command_state()) {
      call_root_key(last_event());
      return;
   }
   p_hex_field=!p_hex_field;
   if (p_hex_field) {
      set_scroll_pos(0,p_cursor_y);
   }
   p_hex_nibble=0;
}
_command void hex_del() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   offset=_nrseek();
   if (offset<0) {
      _nrseek(0);
      offset=_nrseek();
      if (offset<0) {
         return;
      }
   }
   _delete_text();
   p_hex_nibble=0;
}
_command void hex_backspace() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   offset=_nrseek();
   if (offset>=0) {
      _nrseek(offset-1);
   }
   if (offset<0) {
      _nrseek(0);
      offset=_nrseek();
      if (offset<0) {
         return;
      }
   }
   _delete_text();
   p_hex_nibble=0;
}
_command void hex_bottom() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   p_hex_nibble=0;
   _nrseek(p_buf_size);
}
int _hex_down()
{
   NofbytesPerLine=p_hex_Nofcols*HEX_CHARSPERCOL;
   offset=_nrseek();
   if (offset+NofbytesPerLine>=p_buf_size) {
      hex_bottom();
      if (offset intdiv NofbytesPerLine!=_nrseek() intdiv NofbytesPerLine) {
         return(0);
      }
      return(BOTTOM_OF_FILE_RC);
   }
   _nrseek(offset+NofbytesPerLine);
   return(0);
}
int _hex_up()
{
   NofbytesPerLine=p_hex_Nofcols*HEX_CHARSPERCOL;
   offset=_nrseek();
   if (offset<=0) {
      return(TOP_OF_FILE_RC);
   }
   if (offset-NofbytesPerLine<=0) {
      top_of_buffer();
      return(0);
   }
   _nrseek(offset-NofbytesPerLine);
   return(0);
}
void _hex_left()
{
   if (!p_hex_field) {
      p_hex_nibble=0;
      if (p_col==1) {
         offset=_nrseek();
         if (offset<=0) {
            return;
         }
         _nrseek(offset-1);
         return;
      }
      left();
      return;
   }
   if (p_hex_nibble) {
      p_hex_nibble=0;
      return;
   }
   offset=_nrseek();
   if (offset<=0) {
      return;
   }
   _nrseek(offset-1);
   p_hex_nibble=1;
}
void _hex_right()
{
   if (p_hex_field && !p_hex_nibble) {
      p_hex_nibble=1;
      return;
   }
   p_hex_nibble=0;
   if (!p_hex_field && p_col<_text_colc(0,"L")) {
      right();
      return;
   }
   offset=_nrseek();
   if (offset+1>=p_buf_size) {
      hex_bottom();
      return;
   }
   _nrseek(offset+1);
}
void _hex_pagedown()
{
   NofbytesPerLine=p_hex_Nofcols*HEX_CHARSPERCOL;
   NofbytesPerPage=NofbytesPerLine*p_char_height;
   offset=_nrseek();
   if (offset+NofbytesPerPage>p_buf_size) {
      LineOfs=offset%NofbytesPerLine;
      offset=(p_buf_size intdiv NofbytesPerLine)*NofbytesPerLine;
      if (offset+LineOfs>p_buf_size) {
         _beep();
         hex_bottom();
         return;
      }
      _nrseek(offset+LineOfs);
      return;
   }
   _nrseek(offset+NofbytesPerPage);
}
void _hex_pageup()
{
   NofbytesPerLine=p_hex_Nofcols*HEX_CHARSPERCOL;
   NofbytesPerPage=NofbytesPerLine*p_char_height;
   offset=_nrseek();
   if (offset-NofbytesPerPage<=0) {
      LineOfs=offset%NofbytesPerLine;
      if (LineOfs>p_buf_size) {
         top_of_buffer();
         return;
      }
      _nrseek(LineOfs);
      return;
   }
   _nrseek(offset-NofbytesPerPage);
}
void _hex_begin_line()
{
   offset=_nrseek();
   if (offset<0) return;
   NofbytesPerLine=p_hex_Nofcols*HEX_CHARSPERCOL;
   _nrseek(offset-(offset%NofbytesPerLine));
}
void _hex_end_line()
{
   offset=_nrseek();
   if (offset<0) return;
   NofbytesPerLine=p_hex_Nofcols*HEX_CHARSPERCOL;
   new_offset=(offset-(offset%NofbytesPerLine))+NofbytesPerLine-1;
   if (new_offset>p_buf_size) {
      new_offset=p_buf_size;
   }
   _nrseek(new_offset);
}
