#include "slick.sh"
defmain()
{
#if 0
   exe_dir='c:\vslick\'
   add_driver('system.ini',exe_dir'wemu387.386')
   stop
#endif
#if 0
   exe_dir='c:\slick26\rt\slick\'
   macros_dir='c:\slick26\rt\slick\'
   bitmaps_dir='c:\slick26\rt\slick\'
   filename=exe_dir:+"vslick.ini";
   status=load_files(filename);
   if (status) {
      if (status==NEW_FILE_RC) {
         _delete_line();
         insert_comments();
      } else {
         _message_box(nls("Installation failed.  Unable to open '%s'\n\n",filename)get_message(status),"Visual SlickEdit Installation");
         return(1);
      }
   }
   // Make sure VSLICKINCLUDE has
   update_pathvar('VSLICKINCLUDE',macros_dir)
   update_pathvar('VSLICKPATH',macros_dir)
   update_pathvar('VSLICKPATH',bitmaps_dir)
   stop
#endif
   parse arg(1) with exe_dir macros_dir bitmaps_dir update_dir .
   if (update_dir=='') {
      _message_box("Bad arguments given to instmac.e");
      exit(1);
   }
   use_courier=change_font();
   add_driver('system.ini',exe_dir'wemu387.386')
   if (!_win32s()) {
      def_wh='api32wh.hlp';
      //def_load_options=stranslate(upcase(def_load_options),'-L','+L');
      _config_modify|=CFGMODIFY_DEFVAR;
   }
   chdir(substr(exe_dir,1,length(exe_dir)-1),1);
   if (update_dir!='.\') {
      // Do this in instcopy.exe now
#if 0
      // Won't get a return code from this under windows.
      // Must check whether files exist.
      update_dir=substr(update_dir,2);
      command=update_dir"vs +new -p install-update "update_dir
      status=shell(command,'a')
      if (status<0) {
         _message_box(nls("Failed to transfer previous configuration changes\n\n")get_message(status))
      }
      if (status>=0) {
         semaphore_dir=update_dir:+'semaphor';
         if (file_match('-p 'semaphore_dir,1)!='') {
            rmdir(semaphore_dir);
         }
         done=0;
         _suspend();
         if (rc) {
            clear_message
            done=1;
         }
         if (!done) {
            sticky_message 'Press and hold Ctrl+Alt+Shift to abort wait.'
            for (;;) {
               cancel=0
               process_events(cancel);
               if (file_match('-p 'semaphore_dir,1)!='') {
                  rmdir(semaphore_dir);
                  break;
               }
            }
            clear_message
            rc=1;_resume();
         }
      }
#endif
   } else {
      update_dir='';
   }
   add_group('Visual SlickEdit',exe_dir'vs.exe','vslick.grp');
   status=edit("+t");
   insert_line '            Welcome to Visual SlickEdit'
   insert_line ''
   insert_line ''
   insert_line 'Exiting Visual SlickEdit'
   insert_line ''
   insert_line '   Windows emulation (default)        Alt+F4'
   insert_line '   SlickEdit emulation                Alt+X'
   insert_line '   BRIEF emulation                    Alt+X'
   insert_line '   EMACS emulation                    Ctrl+X Ctrl+C'
   insert_line '   VI emulation                       Alt+X'
   insert_line ''
   insert_line ''
   insert_line 'Last Minute Changes'
   insert_line ''
   insert_line '   We decided to default to storing macros in the c:\vslick\macros and'
   insert_line '   bitmaps in the c:\vslick\bitmaps directory to make it easier for new'
   insert_line '   users to browse the Visual SlickEdit files.'
   insert_line ''
   insert_line '   The dos command now defaults to running programs asynchronously.  The '
   insert_line '   manual has some incorrect examples of using the dos command.  To run   '
   insert_line '   the DOS DIR command from the Visual SlickEdit command line, type "dos  '
   insert_line '   -w dir".  The -w option is now required to indicate that you want to   '
   insert_line '   view the output and wait for the command to finish.  You won''t find    '
   insert_line '   much need to run the DOS DIR command unless you want to view your disk '
   insert_line '   space.  Our internal dir command starts the Visual SlickEdit file      '
   insert_line '   manager and provides many more features than the DOS DIR command.'
   top();
   p_window_state='M'

   p_modify=0;
   maybe_create_file(exe_dir,'alias.slk')
   maybe_create_file(exe_dir,'project.slk')
   if (last_char(exe_dir)!=FILESEP) {
      exe_dir=exe_dir:+ FILESEP
   }
   filename=exe_dir:+"vslick.ini";
   status=load_files(filename);
   if (status) {
      if (status==NEW_FILE_RC) {
         _delete_line();
         insert_comments();
      } else {
         _message_box(nls("Installation failed.  Unable to open '%s'\n\n",filename)get_message(status),"Visual SlickEdit Installation");
         return(1);
      }
   }
   update_pathvar('VSLICKINCLUDE',macros_dir)
   update_pathvar('VSLICKPATH',macros_dir)
   update_pathvar('VSLICKPATH',bitmaps_dir)
   // put macro compiler in path by placing exe_dir in VSLICKPATH
   set('VSLICKPATH='exe_dir';'get_env('VSLICKPATH'));
   status=save();
   _delete_buffer();
   if (status) {
      _message_box(nls("Unable to save vslick.ini\n\n")get_message(status),'Visual SlickEdit Installation');
      return(1);
   }
   //  Apply the configuration changes
   if (update_dir!='') {
      old_cwd=getcwd()
      chdir(substr(update_dir,1,length(update_dir)-1),1);
      // By convention, vusrmods is a batch program which loads all
      // user specific modules and restores the users previous setup.
      vusrmods_name=slick_path_search(USERMODS_FILE:+_macro_ext)
      if ( vusrmods_name!='' ) {
         message nls('Running %s',vusrmods_name)
         status=shell(vusrmods_name);
         if (status) {
            _message_box(nls("Unable to run '%s' to update previous configuration.\n\n",vusrmods_name)get_message(status),'Visual SlickEdit Installation');
         }
      }
      chdir(old_cwd,1);
      //delete_junk(update_dir);
   }
   delete_file exe_dir'instmac.ex'
   if (use_courier) {
      _mdi.p_child.p_font_name='Courier';
      _default_font(CFG_WINDOW_TEXT,'Courier,10');
      _config_modify|=CFGMODIFY_OPTION;
   }
   if (_config_modify) {
      _post_call(find_index('write_state',COMMAND_TYPE),_default_state_filename());
   }
   _post_call(find_index('config',COMMAND_TYPE));
}
static int change_font()
{
   if (_win32s()!=1) {
      return(0);
   }
   filename=_get_windows_directory():+'system.ini';
   status=edit(filename);
   if (status) {
      _message_box(nls("Unable to open %s",filename)"\n\n"get_message(status)"\n\n"nls("OEM font will be used."))
      return(0);
   }
   status=ini_find_section('keyboard');
   if (status) {
      return(0);
   }
   status=ini_get_value('keyboard.dll',value);
   if (status || value=='') {
      return(0);
   }
   return(1);
}
static ini_find_section(section)
{
   /* Search for the Environment section */
   top();
   status=search('^[ \t]*\[[ \t]*'section'[ \t]*\]','ri@');
   return(status);
}
static ini_get_value(name,var value)
{
   save_pos(p);
   down();
   name_re=_escape_re_chars(name)'='
   section_re='\[';
   status=search('^[ \t]*('name_re'|'section_re')','ri@')
   value='';
   if (!status) {
      get_line line
      if (substr(strip(line),1,1)=='[') {
         restore_pos(p);
         return(STRING_NOT_FOUND_RC);
      }
      parse line with '=' value
   }
   restore_pos(p);
   return(status);
}
static add_driver(ini_filename,driver)
{
   if (_win32s()!=1) {
      return(0);
   }
   /* 386end system.ini */
   filename=_get_windows_directory():+ini_filename;
   status=edit(filename);
   if (status) {
      _message_box(nls("Unable to open %s",filename)"\n\n"get_message(status)"\n\n"nls("Driver %s not installed",driver))
      return(status)
   }
   driver_added=add_driver2('DEVICE',driver)
   if (driver_added) {
      status=save()
      if (status) {
         driver_added=0;
         _message_box(nls("Unable to save changes to 'system.ini'.\n\n"nls("Driver %s not installed",driver)));
      }
   }
   p_modify=0;
   quit();
   if (driver_added) {
      _message_box(nls("A driver has been installed into 'system.ini'.  You need to restart windows before you can compile within the editor."));
   }
   return(0)
}
static add_driver2(name,value)
{
   /* Search for the Environment section */
   top();
   status=search('^[ \t]*\[[ \t]*386Enh[ \t]*\]','ri');
   if (status) {
      bottom
      insert_line '[386Enh]'
      insert_line name'='value
      return(1);
   }
   save_pos(p);
   down();
   name_re=name'=?*\\'substr(value,pathlen(value)+1)'$'
   section_re='\[';
   status=search('^[ \t]*('name_re'|'section_re')','ri')
   if (!status) {
      get_line line
      if (substr(strip(line),1,1)=='[') {
         restore_pos(p)
         insert_line name'='value
         return(1);
      }
   }
   if (status) {
      insert_line name'='value
      return(1);
   }
   return(0);
}
static void update_pathvar(name,value)
{
   update_pathvar2(name,value)
   get_line line
   parse line with name '=' new_value
   set(name'='new_value);
}
static void update_pathvar2(name,value)
{
   /* Search for the Environment section */
   top();
   status=search('^[ \t]*\[[ \t]*environment[ \t]*\]','ri');
   if (status) {
      bottom
      insert_line '[Environment]'
      insert_line name'='value
      return;
   }
   save_pos(p);
   down();
   name_re=name'=';
   section_re='\[';
   status=search('^[ \t]*('name_re'|'section_re')','ri')
   if (!status) {
      get_line line
      if (substr(strip(line),1,1)=='[') {
         restore_pos(p)
         insert_line name'='value
         return;
      }
   }
   if (status) {
      insert_line name'='value
      return;
   }
   get_line line
   parse line with '=' old_value
   paths=old_value
   value=absolute(value);
   for (;;) {
      parse paths with path ';' paths
      if (path=='') {
         break;
      }
      apath=absolute(path)
      if (file_eq(apath,value) || file_eq(apath:+FILESEP,value)) {
         return;
      }
   }
   replace_line name'='value';'old_value
}
static void insert_comments()
{
insert_line "; This INI file is intended to contain configuration options which"
insert_line '; you DO NOT want stored in "vslick.sta" or that can''t be stored in'
insert_line '; "vslick.sta".  This file typically contains environment variables'
insert_line "; which are required by the macro compiler or contain machine specific"
insert_line "; drive or path information.  Storing drive and path information"
insert_line '; separate from "vslick.sta" allows you to use one state file on machines'
insert_line "; with different directory configurations."
insert_line ";"
insert_line "; We recommend that you do not put the VSLICKCONFIG environment variable"
insert_line "; in this file.  If you have installed Visual SlickEdit on a network, each"
insert_line "; user should define the VSLICKCONFIG environment variable to a local directory and"
insert_line "; place a copy of this file there."
insert_line '; For Windows NT, use the "System" icon in the "Conrol Panel" group to define'
insert_line "; the VSLICKCONFIG environment variable."
insert_line ";"
}
#if 0
static void delete_junk(update_dir)
{
   if (update_dir=='') return;
   if (pos(FILESEP'$$$'FILESEP,update_dir)) {
      // Try to wait for editor to terminate.
      delete_file update_dir'listkeys.ex'
      delete_file update_dir'listcfg.ex'
      delete_file update_dir'listobjs.ex'
      delete_file update_dir'vusrmods.e'
      delete_file update_dir'vusrmods.ex'
      delete_file update_dir'vslick.ini'
      delete_file update_dir:+USERDEFS_FILE:+_macro_ext
      delete_file update_dir:+USERDEFS_FILE:+_macro_ext'x'
      delete_file update_dir:+USEROBJS_FILE:+_macro_ext
      delete_file update_dir:+USEROBJS_FILE:+_macro_ext'x'
      delete_file update_dir'vslick.mnu'
      // Wait up to 4 seconds for editor to terminate. */
      for (i=1;i<40;++i) {
         cancel=0;process_events(cancel);
         status=delete_file(update_dir'vs.exe');
         if (status==ACCESS_DENIED_RC) {
            delay(100);
         } else {
            break;
         }
      }
      delete_file update_dir'vslick.sta'
      filename=update_dir:+USERSYSO_FILE:+_macro_ext
      if (file_match('-p 'filename,1)=='') {
         rmdir(substr(update_dir,1,length(update_dir)-1))
      }
   } else {
      delete_file update_dir'vusrmods.e'
      delete_file update_dir'vusrmods.ex'
   }
}
#endif
static void maybe_create_file(path,name)
{
   filename=path:+name;
   if (file_match('-p 'filename,1)=='') {
      status=load_files('+t 'filename)
      if (status) {
         _message_box(nls("Unable to create '%s'\n\n",filename)get_message(filename));
         return;
      }
      _delete_line();
      status=save()
      _delete_buffer();
      if (status) {
         _message_box(nls("Unable to create '%s'\n\n",filename)get_message(filename));
         return;
      }
   }
}
static void add_group(title,cmdline,group_file)
{

   orig_wid=p_window_id;
   p_window_id=_mdi.p_child;
   load_files('+t');
   status=_dderequest('',"PROGMAN",'Groups','PROGMAN')
   p_window_id=_mdi.p_child;
   if (status) {
      _delete_buffer();
      p_window_id=orig_wid;
      return;
   }
   top();
   status=search('^'_escape_re_chars(title),'ri');
   _delete_buffer();
   p_window_id=orig_wid;
   if (!status) return;
   result=_message_box('Add Visual SlickEdit Group?','Visual SlickEdit Installation',MB_YESNO|MB_ICONQUESTION)
   if (result==IDNO) return;
   _ddecommand("PROGMAN",'[CreateGroup("'title'","vslick.grp")]','PROGMAN');
   status=_ddecommand("PROGMAN",'[AddItem("'cmdline'","'title'")]','PROGMAN')
}
