/*
$VerboseHistory: modula.e$
*/
/*
  To install this package, perform the following steps.

    -  Load this macro module with LOAD command.  The ST.EXE
       compiler will automatically get invoked if necessary.
    -  Save the configuration. {CONFIG,Save configuration...}

  Options for MODULA-2 syntax expansion/indenting may be accessed from SLICK's
  file extension setup menu (CONFIG, "File extension setup...").

  The extension specific options is a string of five numbers separated
  with spaces with the following meaning:

    Position       Option
       1             Minimum abbreviation.  Defaults to 1.  Specify large
                     value to avoid abbreviation expansion.
       2-5           reserved.
*/
#include 'slick.sh'
#define MODE_NAME 'Modula'
#define EXTENSION 'mod'

defload()
{
   setup_info='MN='MODE_NAME',TABS=+3,MA=1 74 1,':+
              'KEYTAB='MODE_NAME'-keys,WW=1,IWT=0,ST=0,'
   compile_info=''
   syntax_info='3 1 1 0 0 1 0'
   be_info='(WITH),(IF),(BEGIN),(WHILE),(CASE),(FOR),(LOOP)(RECORD)|(END) (REPEAT)|(UNTIL)'
   create_ext(kt_index,EXTENSION,'',MODE_NAME,setup_info,compile_info,
              syntax_info,be_info)

}
_command modula_mode()  name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode(EXTENSION)

}
_command modula_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand .
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) ||
         modula_expand_enter(p_SyntaxIndent,expand) ) {
      call_root_key(ENTER)
   } else if (_argument=='') {
      _undo 'S'
   }

}
_command modula_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   was_space=(last_event():==' ')
   parse name_info(_edit_window().p_index) with . expand .
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
      modula_expand_space(p_SyntaxIndent) ) {
      if ( was_space ) {
         if ( command_state() ) {
            call_root_key(' ')
         } else {
            keyin ' '
         }
      }
   } else if (_argument=='') {
      _undo 'S'
   }

}
#define ENTER_WORDS  (' begin case repeat var type const procedure implementation':+\
                ' label module if for while with elsif else definition module ')
#define DECL_WORDS ' type var label const else '
#define EXPAND_WORDS ' export end '

static _str space_words[]={'begin','case','const','definition','else','elsif',
                        'end','export','for','from','if','implementation',
                        'label','loop','module','procedure','repeat','type',
                        'var','while','with'};
/* Returns non-zero number if modulas through to enter key required */
static _str modula_expand_enter(syntax_indent,expand)
{
  status=0
  get_line line
  parse line with orig_first_word rest
  first_word=lowcase(orig_first_word)
  status=0;
  if ( pos(' 'first_word' ',ENTER_WORDS) ) {
     if ( first_word=='for' && name_on_key(ENTER)=='nosplit-insert-line' ) {
        /* tab to fields of modula for statement */
        line=expand_tabs(line)
        parse lowcase(line) with before ':='
        if ( length(before)+1>=p_col ) {
           p_col=length(before)+4
        } else {
           parse line with before 'TO'
           if ( length(before)>=p_col ) {
              p_col=length(before)+4
           } else {
              indent_on_enter(syntax_indent)
           }
        }
     } else if ( expand && (first_word=='implementation' || first_word=='procedure' ||
           first_word=='definition' || first_word=='module') ) {
        /* If next line is begin key word, comment begin/end with function name */
        down
        get_line next_line
        if ( lowcase(next_line)=='begin' && p_col>text_col(line) ) {
           up;
           if ( first_word=='module' || first_word=='procedure' ) {
              parse line with keyword function_name '([\:\(;])|$','r'
           } else {
              parse line with . . function_name '([\:\(;])|$','r'
           }
           down
           function_name=strip(function_name)
           replace_line next_line' (* 'function_name' *)'
           down
           get_line line
           parse line with 'END[.;]','r' +3 rest
           if ( line=='END;' || line=='END.' ) {
              replace_line substr(line,1,length(line)-1)' 'function_name:+rest
           }
           up 2
           indent_on_enter(syntax_indent)
        } else {
           up
           indent_on_enter(syntax_indent)
        }
     } else {
        i=pos(orig_first_word,line)
        replace_line substr(line,1,i-1):+upcase(orig_first_word):+
                     substr(line,i+length(orig_first_word))
        indent_on_enter(syntax_indent)
     }
  } else {
    status=1
  }
  return(status)

}
static _str modula_expand_space(syntax_indent)
{
   status=0
   get_line line
   line=strip(line,'T')
   orig_word=lowcase(strip(line));
   if ( p_col!=text_col(line)+1 ) {
      return(1)
   }
   aliasfilename='';
   word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename);
   if (word!=''&&aliasfilename!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   if ( word=='') return(1);
   line=substr(line,1,length(line)-length(orig_word)):+word
   width=text_col(line,length(line)-length(word)+1,'i')-1
   if ( word=='if' ) {
     replace_line upcase(line)'  THEN'
     /* insert_line indent_string(width)'end else begin' */
     insert_line indent_string(width)'END (* IF *);'
     up;p_col=width+4
     if ( ! _insert_state() ) { _insert_toggle }
   } else if ( word=='elsif' ) {
      replace_line upcase(line'  then')
      p_col=width+7
      if ( ! _insert_state() ) { _insert_toggle }
   } else if ( word=='implementation' || word=='procedure' ||  word=='definition' || word=='module' ) {
      if ( word=='implementation' ) {
         line=upcase(word)' MODULE'
      } else if ( word=='definition' ) {
         line=upcase(word)' MODULE'
      }
      replace_line upcase(line)
      insert_line indent_string(width):+'BEGIN'
      if ( word=='procedure' ) {
         insert_line indent_string(width):+'END;'
      } else {
         insert_line 'END.'
      }
      up 2;_end_line;right
   } else if ( word=='for' ) {
     replace_line upcase(line)' :=  TO  BY 1 DO'
     insert_line indent_string(width)'END (* FOR *);'
     up;p_col=width+5
     if ( ! _insert_state() ) { _insert_toggle }
   } else if ( word=='loop' ) {
     replace_line upcase(line)
     insert_line indent_string(width)'END (* LOOP *);'
     up;call nosplit_insert_line()
     p_col=p_col+syntax_indent
     if ( ! _insert_state() ) { _insert_toggle }
   } else if ( word=='begin' ) {
     replace_line upcase(line)
     insert_line indent_string(width)'END '  /* Hard to find ident */
/*
     up;call nosplit_insert_line()
     p_col=p_col+syntax_indent
     if not insert_state() then insert_toggle endif
*/
   } else if ( word=='while' ) {
     replace_line upcase(line)'  DO'
     insert_line indent_string(width)'END (* WHILE *);'
     up;p_col=width+7
     if ( ! _insert_state() ) { _insert_toggle }
   } else if ( word=='from' ) {
     replace_line upcase(line)'  IMPORT '
     p_col=width+6
     if ( ! _insert_state() ) { _insert_toggle }
   } else if ( word=='with' ) {
     replace_line upcase(line)'  DO'
     insert_line indent_string(width)'END (* WITH *);'
     up;p_col=width+6
     if ( ! _insert_state() ) { _insert_toggle }
   } else if ( word=='case' ) {
     replace_line upcase(line)'  OF'
     insert_line indent_string(width)'END (* CASE *);'
     up;p_col=width+6
     if ( ! _insert_state() ) { _insert_toggle }
   } else if ( word=='repeat' ) {
     replace_line upcase(line)
     insert_line indent_string(width)'UNTIL  ;'
     up;call nosplit_insert_line()
     p_col=p_col+syntax_indent
   } else if ( pos(' 'word' ',DECL_WORDS) ) {
      replace_line indent_string(width)upcase(word)
      indent_on_enter(syntax_indent)
   } else if ( pos(' 'word' ',EXPAND_WORDS) ) {
      replace_line indent_string(width)upcase(word)' '
      _end_line
   } else {
     status=1
   }
   return status
}
_str mod_proc_search(var proc_name,find_first,extension)
{
   _str _keywords='(PROCEDURE)';
   if ( find_first ) {
      if ( proc_name:=='' ) {
         status=search('^[ \t]*'_keywords':b:v[ \t]*[(;:]','re');
      } else {
         status=search(proc_name,'e>w=[A-Za-z0-9_$]');
      }
   } else {
      status=repeat_search();
   }
   for (;;) {
      if ( status ) {
         return(status)
      }
      if (_in_comment()) {
         status=repeat_search();
         continue;
      }
      get_line(line);
      line=expand_tabs(line);
      col=p_col;
      if ( pos(' '_keywords'[ \t]',' 'line,1,'r'):==0 ) {
         status=repeat_search();continue;
      }
      p=pos('[(;:]',line,1,'r');
      if ( p ) {
         if ( substr(line,p,1):=='(' ) {
            p_col=p;
            if ( _find_matching_paren(def_pmatch_max_diff) ) {
               status=repeat_search();
               continue;
            }
            _find_matching_paren(def_pmatch_max_diff);
         }
         get_line(temp);temp=expand_tabs(temp);
         if ( pos('forward;',temp) ) {
            status=repeat_search();
            continue;
         }
         line=strip(substr(line,1,p-1));
         i=lastpos(' ',translate(line,' ',\t));
         proc_name=substr(line,i+1);
         return(0)
      }
      status=repeat_search();
   }

}
_str mod_tag_case()
{
   return('e')
}
