/*
$VerboseHistory: msqbas.e$
 *
 * *****************  Version 2  *****************
 * User: Clark       Date: 01/22/1998  Time:10:41a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/22/1998 10:41a
 * Comment:
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:43a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:43a
 * Comment:
 * Change bas_proc_search function not to display search
 * error message
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:37p
 * Comment:
 * Adding new 3.0 stuff
*/
/*
  Options for Microsoft Quick Basic syntax expansion/indenting may be
  accessed from SLICK's file extension setup menu
  (CONFIG, "File extension setup...").

  The extension specific options is a string of five numbers separated
  with spaces with the following meaning:

    Position       Option
       1             Minimum abbreviation.  Defaults to 1.  Specify large
                     value to avoid abbreviation expansion.
       2             Keyword case.  Values may be 0,1, or 2 which correspond
                     to lower case, upper case, and capitalized.  Default
                     is 0.
       3             reserved
       4             Amount to indent for first level of code.  Default is 3.
                     Specify 0 if you want first level statements to
                     start in column 1.
       5             reserved.
*/
#include 'slick.sh'

#define MODE_NAME 'QBasic'
#define EXTENSION 'bas'
#define WORD_CHARS 'a-zA-Z0-9_$!%#&'

defload()
{
   setup_info='MN='MODE_NAME',TABS=+3,MA=1 74 1,':+
              'KEYTAB='MODE_NAME'-keys,WW=1,IWT=0,ST=0,'
   compile_info='0 bc *;'
   syntax_info='3 1 1 0 0 3 0'
   be_info='(FOR)|(NEXT) (WHILE)|(WEND) (DO)|(LOOP);i'
   create_ext(kt_index,EXTENSION,'',MODE_NAME,setup_info,compile_info,
              syntax_info,be_info,'',WORD_CHARS)

}
static _str word_case(s)
{
   parse name_info(p_index) with . . . scase .;
   if ( scase==0 ) {
      return(lowcase(s)); /* Lower case language key words. */
   } else if ( scase==1 ) {
      return(upcase(s));    /* Upper case language key words. */
   }
   i=pos('[~ \t]',s,1,'r');
   if (i) {
      return(substr('',1,i-1,' '):+upcase(substr(s,i,1)):+lowcase(substr(s,i+1)));  /* Capitalize */
   }
   return(s);
}

/* This command forces the current buffer to be in Quick Basic mode. */
/* Unfortunately, this command only changes the mode-name, tab options, */
/* word wrap options, and mode key table. */
/* Not necessary for syntax expansion and indenting. */
_command qbasic_mode()  name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   /* The SELECT_EDIT_MODE procedure can find the file extension setup */
   /* data by passing it the 'bas' extension. */
   select_edit_mode(EXTENSION)

/* This command is bound to the ENTER key.  It looks at the text around the */
/* cursor to decide whether to indent another level.  If it does not, the */
/* root key table definition for the ENTER key is called. */
}
_command qbasic_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand . . . first_indent .
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) ||
         qbasic_expand_enter(p_SyntaxIndent,expand,first_indent) ) {
       call_root_key(ENTER)
   } else {
      _undo 'S'
   }

/* This command is bound to the SPACE BAR key.  It looks at the text around */
/* the cursor to decide whether insert an expanded template.  If it does not, */
/* the root key table definition for the SPACE BAR key is called. */
}
_command qbasic_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand .
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
      qbasic_expand_space(p_SyntaxIndent) ) {
      if ( command_state() ) {
         call_root_key(' ')
      } else {
         keyin ' '
      }
   } else if (_argument=='') {
      _undo 'S'
   }

/* These constant strings have been defined to make the syntax
 expansion and indenting more data driven and to speed up
 determining whether special processing must be performed. There
 must be a space before and after each key word. */
}
#define ENTER_WORDS ' case do for if select type while '
#define FIRST_WORDS  ' function sub '
   /* Space words must be in sorted order */
#define SPACE_WORDS (' beep bload bsave call chain chdir circle clear close':+\
               ' cls color com const data date$ declare':+\
               ' def defdbl defint deflng defsng defstr dim do draw else':+\
               ' elseif end environ erase error exit field files for function ')

#define SPACE_WORDS2 (' get gosub goto if input input$ ioctl key kill':+\
               ' left line locate lock loop lprint lset mid$ on open out paint palette':+\
                ' pcopy pen play poke preset print pset put ')
#define SPACE_WORDS3 (' randomize read redim rem reset restore resume return':+\
               ' rmdir rset run screen seek select shared':+\
               ' shell sleep sound static stop strig sub swap system time$':+\
               ' timer troff tron type unlock view wait while width window':+\
                ' write ')
#define EXPAND_WORDS (' beep bload bsave call chain chdir circle clear close':+\
               ' cls color com const data date$ declare':+\
               ' def defdbl defint deflng defsng defstr dim do draw else':+\
               ' elseif end environ erase error exit field files for function ')

#define EXPAND_WORDS2 (' get gosub goto if input input$ ioctl key kill':+\
               ' left line locate lock loop lprint lset mid$ on open out paint palette':+\
                ' pcopy pen play poke preset print pset put ')
#define EXPAND_WORDS3 (' randomize read redim rem reset restore resume return':+\
               ' rmdir rset run screen seek select shared':+\
               ' shell sleep sound static stop strig sub swap system time$':+\
               ' timer troff tron type unlock view wait while width window':+\
                ' write ')
#define DECL_WORDS (' integer real string ')
/*
  no space after print read or write

   DECL_WORDS=' integer print real read string write '
*/


static _str space_words[]={
'beep','bload','bsave','call','chain','chdir','circle','clear','close',
'cls','color','com','const','data','date$','declare',
'def','defdbl','defint','deflng','defsng','defstr','dim','do','draw','else',
'elseif','end','environ','erase','error','exit','field','files','for','function',
'get','gosub','goto','if','input','input$','ioctl','key','kill',
'left','line','locate','lock','loop','lprint','lset','mid$','on','open','out',
'paint','palette','pcopy','pen','play','poke','preset','print','pset','put',
'randomize','read','redim','rem','reset','restore','resume','return','rmdir',
'rset','run','screen','seek','select','shared','shell','sleep','sound','static',
'stop','strig','sub','swap','system','time$','timer','troff','tron','type',
'unlock','view','wait','while','width','window','write'};

/* Returns non-zero number if fall through to enter key required */
static _str qbasic_expand_enter(syntax_indent,expand,first_indent)
{
  status=0
  /* Put last word of line into last_word variable. */
  get_line line
  parse lowcase(line) with 'begin' +0 last_word
  status=0;
  /* Is last word begin key word or first word one of indent on enter */
  /* key words?. */
  get_line line
  parse lowcase(line) with 'begin' +0 last_word
  parse line with '[~ \t]','r' +0 word '[ \t]','r' rest
  /* Put first word of line into first_word variable. */
  first_word=lowcase(word)
  if ( first_word=='for' && name_on_key(ENTER)=='nosplit-insert-line' ) {
     /* tab to fields of qbasic for statement */
     line=expand_tabs(line)
     parse lowcase(line) with before '='
     if ( length(before)+1>=p_col ) {
        p_col=length(before)+3
     } else {
        parse lowcase(line) with before 'to'
        if ( length(before)>=p_col ) {
           p_col=length(before)+4
        } else {
           indent_on_enter(syntax_indent)
        }
     }
  } else if ( first_word=='select' ) {
     indent_on_enter(0)
     replace_line indent_string(p_col-1)word_case('case ')
     _end_line
  } else if ( pos(' 'first_word' ',ENTER_WORDS,1,'i') ) {
     replace_line substr(line,1,pos(word,line)-1)word_case(first_word) " "rest
     indent_on_enter(syntax_indent)
  } else if ( pos(' 'first_word' ',FIRST_WORDS,1,'i') ) {
     indent_on_enter(first_indent)
  } else {
    status=1
  }
  return(status)

/* Returns non-zero number if fall through to space bar key required */
}
static _str qbasic_expand_space(syntax_indent)
{
   /* Put first word of line in lower case into word variable. */
   get_line(line);
   line=strip(line,'T');
   orig_word=lowcase(strip(line));
   if ( p_col!=text_col(line)+1 ) {
      return(1);
   }
   aliasfilename='';
   word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename);
   if (word!=''&&aliasfilename!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   /* Insert the appropriate template based on the key word. */
   line=substr(line,1,length(line)-length(orig_word)):+word;
   width=text_col(line,length(line)-length(word)+1,'i')-1;
   if ( word=='if' ) {
      replace_line word_case(line):+word_case('  then');
      /* insert_line indent_string(width)word_case('else') */
      insert_line(indent_string(width)word_case('end'):+word_case(' if'));
      up();p_col=width+4;
      if ( ! _insert_state() ) { _insert_toggle(); }
   } else if ( word=='for' ) {
      replace_line(word_case(line:+' =  to  step '));
      insert_line(indent_string(width)word_case('NEXT'));
      up();p_col=width+5;
      if ( ! _insert_state() ) { _insert_toggle(); }
   } else if ( word=='begin' ) {
     replace_line(word_case(line));
     insert_line('');
     insert_line(indent_string(width)word_case('endif')); /* Let user type . or ; */
     up();p_col=width+syntax_indent+1;
   } else if ( word=='while' ) {
      replace_line(word_case(line));
      insert_line(indent_string(width)word_case('wend'));
      up;p_col=width+7;
      if ( ! _insert_state() ) { _insert_toggle(); }
   } else if ( word=='select' ) {
      replace_line(word_case(line' case '));
      insert_line(indent_string(width)word_case('end select'));
      up();_end_line();
      if ( ! _insert_state() ) { _insert_toggle(); }
   } else if ( word=='type' ) {
      replace_line(word_case(line));
      insert_line(indent_string(width)word_case('end type'));
      up();p_col=width+6;
      if ( ! _insert_state() ) { _insert_toggle(); }
   } else if ( word=='function' || word=='sub' ) {
      replace_line(word_case(line));
      if ( word == 'sub' ) {
         insert_line(word_case('end sub'));
      } else {
         insert_line(indent_string(width):+word_case('end function'));
      }
      up(1);_end_line();right();
   } else if ( pos(' 'word' ',DECL_WORDS) ) {
      replace_line(indent_string(width)word_case(word));
      _end_line();
   } else if ( pos(' 'word' ',EXPAND_WORDS) || pos(' 'word' ',EXPAND_WORDS2) ||
          pos(' 'word' ',EXPAND_WORDS3) ) {
      replace_line(indent_string(width)word_case(word)' ');
      _end_line();
   }else{
      return(1);
   }
   return(0);
}
_str bas_proc_search(var proc_name,find_first)
{
   _str search_type = '';
   if ( find_first ) {
      _str keywords='sub|function|property|const|attribute';
      _str letget='[lg]et';
      if ( proc_name:=='' ) {
         variable_re='([A-Za-z]['WORD_CHARS']@)';
         search '^[ \t]@({#0:i}|{#0'variable_re'}\:|((public|private)[ \t]#|)('keywords')[ \t]#('letget'[ \t]#|){#0'variable_re'}([~'WORD_CHARS']|$))','r@i';
      } else {
         tag_tree_decompose_tag(proc_name, proc_name, dc, search_type, dt);
         proc_name_re=stranslate(proc_name,'\$','$');
         proc_name_re=stranslate(proc_name_re,'\#','#');
         if ( isinteger(proc_name) ) {
            search '^[ \t]@\c{#0'proc_name'}([~'WORD_CHARS']|$)','r@i';
         } else {
            search '^[ \t]@(\c{#0'proc_name_re'}\:|((public|private)[ \t]#|)('keywords')[ \t]*('letget'[ \t]#|)\c{#0'proc_name_re'}([~'WORD_CHARS']|$))','r@i';
         }
      }
   } else {
      repeat_search;
   }
   for (;;) {
      if ( rc ) {
         break;
      }
      int sm = match_length('S');
      int s0 = match_length('S0');
      int l0 = match_length('0');
      _str curline = get_text(s0-sm,sm);
      int  tag_flags = 0;
      if (pos("private",curline,1,'iw')) {
         tag_flags = VS_TAGFLAG_static;
      }
      _str type_name = '';
      if (pos("sub",curline,1,'iw')) {
         type_name = 'proc';
      } else if (pos('function', curline, 1, 'iw')) {
         type_name = 'func';
      } else if (pos('property', curline, 1, 'iw')) {
         if (pos('get',curline,1,'iw')) {
            type_name = 'func';
            tag_flags |= VS_TAGFLAG_const;
         } else if (pos('let',curline,1,'iw')) {
            type_name = 'proc';
         } else {
            type_name = 'prop';
         }
      } else if (pos('const', curline, 1, 'iw')) {
         type_name = 'const';
      } else if (pos('dim', curline, 1, 'iw')) {
         type_name = 'gvar';
      } else if (pos('attribute', curline, 1, 'iw')) {
         type_name = 'const';
      } else if (curline=='') {
         type_name = 'label';
      }
      name=get_text(l0,s0);
      if ( proc_name:=='' ) {
         proc_name=tag_tree_compose_tag(name, '', type_name, tag_flags);
         break;
      }
      if ( proc_name==name && (search_type=='' || search_type==type_name)) {
         break;
      }
      repeat_search;
   }
   return(rc);
}
