/*
$VerboseHistory: output.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:45a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:45a
 * Comment:
 * Added some commands for switch tool bars.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:26p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

static int outputLastOnOutputTabShell = 0;

defeventtab _tboutput_form

void _smart_toolbar_hotkey()
{
   if (p_object==OI_EDITOR) {
      key=last_event();                /* Key that was actually pressed. */
   
      kt_index=last_index('','k')
      command_index=eventtab_index(_default_keys,p_mode_eventtab,event2index(key))
      parse name_info(command_index) with ',' arg2 ','
      if ( arg2=='' ) {
         arg2=0;
      }
      iscommand=(name_type(command_index) & COMMAND_TYPE);
      if (iscommand && (!(arg2&VSARG2_EDITORCTL) ||   // not allowed in editor control
                          // Or command requires MDI window
                          ( (arg2&VSARG2_REQUIRES_MDI) && 
                            !(_default_option(VSOPTION_APIFLAGS) & 
                             VSAPIFLAG_MDI_WINDOW)
                          )
                         )) {

         if (p_isbutton_bar) {
            p_window_id=_mdi.p_child;
            call_key(last_event());
         }
         return;
      }
      active_form_wid=p_active_form;
      old_eventtab=active_form_wid.p_eventtab;
      //say('got here n='name_name(p_eventtab));
      active_form_wid.p_eventtab=0;
      call_key(key);
      if (_iswindow_valid(active_form_wid)) {
         active_form_wid.p_eventtab=old_eventtab;
      }
      return;
   } else if (p_object==OI_TEXT_BOX || p_object==OI_COMBO_BOX) {
      key=last_event();                /* Key that was actually pressed. */
   
      kt_index=last_index('','k')
      command_index=eventtab_index(_default_keys,_default_keys,event2index(key))
      parse name_info(command_index) with ',' arg2 ','
      if ( arg2=='' ) {
         arg2=0;
      }
      iscommand=(name_type(command_index) & COMMAND_TYPE);
      iscombo_key=key:==F4 && p_object==OI_COMBO_BOX;
      if (!iscombo_key &&  iscommand && (!(arg2&VSARG2_TEXT_BOX) // not allowed in text box
                         )) {  
         if (p_isbutton_bar) {
            p_window_id=_mdi.p_child;
            call_key(last_event());
         }
         return;
      }
      active_form_wid=p_active_form;
      old_eventtab=active_form_wid.p_eventtab;
      //say('got here n='name_name(p_eventtab));
      active_form_wid.p_eventtab=0;
      if (p_object==OI_COMBO_BOX && !iscombo_key) {
         p_cb_text_box.call_event(p_cb_text_box,key);
      } else {
         call_key(key);
      }
      active_form_wid.p_eventtab=old_eventtab;
      return;
   }
   if (p_isbutton_bar) {
      p_window_id=_mdi.p_child;
      call_key(last_event());
   }
}
void _tboutput_form.'C-A'-'C-Z',F2-F12,C_F12()
{
   _smart_toolbar_hotkey();
} 
void _tboutput_form.'C-W',A_UP,A_LEFT,A_RIGHT()
{
   if (!_no_child_windows()) {
      p_window_id=_mdi.p_child;
      _set_focus();
   }
}
void _tboutput_form.'c-tab','s-c-tab'()
{
   call_event(defeventtab _ainh_dlg_manager,last_event(),'e');
}
// Desc:  Need to handle this event here because anywhere else on the
//     tab control or form will kill existing handlers.
static void connectExistingProcessBuffer()
{
   // If the Shell output tab is the active tab, look for the 
   // concurrent process buffer and use it:
   if (p_buf_name == ".process") return;
   //parse buf_match('.process','vhx') with buf_id name;

   int oriBufId;
   oriBufId = p_buf_id;
   for (;;) {
      if (p_buf_name == ".process") {
         // Reuse existing .process buffer and delete the one that was create
         // with the editor control:
         //say( "Found and reuse existing .process" );
         int tempId;
         tempId = p_buf_id; 
         p_buf_id = oriBufId;
         //close_buffer();
         _delete_buffer();
         p_buf_id = tempId;

         bottom();
         break;
      }
      _next_buffer( "HR" );
      if (p_buf_id == oriBufId) {
         p_buf_name=".process";
         select_edit_mode();
         p_undo_steps=0;
         break;
      }
   }
}
void outputTabToolConnectProcess()
{
   int formwid;
   formwid = _find_object("_tboutput_form","N");
   if (!formwid) return;
   int tabeditor;
   tabeditor = formwid._find_control("_shellEditor");
   tabeditor.connectExistingProcessBuffer();
}
void _shellEditor.'ENTER'()
{
   if (_process_info('B')) {
      process_enter();
      return;
   }
   if (_shellEditor.p_line != _shellEditor.p_Noflines) {
      process_enter();
      //bottom();
      return;
   }
   _str line;
   _shellEditor.get_line(line);
   if (line == "") return;

   // Start the concur process buffer and queue the command:
   start_process_tab();
   if ( _process_info() ) {
      orig_wid=p_window_id;
      status=_open_temp_view('.process',temp_view_id,orig_view_id,'+b');
      if (!status) {
         command=line;
         bottom();
         get_line(line);
         if ( _process_info('c') ) {
            line=expand_tabs(line,1,_process_info('c')-1,'S');
         } else {
            line='';
         }
         replace_line(line:+command);
         insert_line("");
         refresh();
         _delete_temp_view(temp_view_id,0);
         p_window_id=orig_wid;
      }
   }
}
void _shellEditor.on_create()
{
   //say( "_shellEditor.on_create" );
   connectExistingProcessBuffer();
}
static int gignore_change=0;
void _output_sstab.on_change(reason)
{
   if (gignore_change) {
      return;
   }
   int createActivate;
   createActivate = 0;
   if (arg() > 2) createActivate = arg(3);
   if (createActivate) return;
   if (reason == CHANGE_TABACTIVATED) {
      // Force a resize:
      p_active_form.call_event(1,p_active_form,ON_RESIZE,'W');
   }
}
void list1.on_create()
{
   //say( "list1.on_create" );
   initMFOutputList(1); 
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
      orig_active_tab=_output_sstab.p_ActiveTab;
      gignore_change=1;
      _output_sstab.p_ActiveTab=OUTPUTTOOLTAB_SEARCH;
      _output_sstab.p_ActiveEnabled=0;
      if (orig_active_tab==OUTPUTTOOLTAB_SEARCH) {
         _output_sstab.p_ActiveTab=OUTPUTTOOLTAB_SYMBOL;
      } else {
         _output_sstab.p_ActiveTab=orig_active_tab;
      }
      gignore_change=0;
   }
}
void list1.'ENTER',lbutton_double_click()
{
   _set_focus();
   if (p_line==0) return;
   status=_mffindGetDest(filename,linenum,col);
   if (status) {
      // Line not recognized as grep line
      _beep();
      return;
   }
   _mffindGoTo(filename,linenum,col);
}
void _output_sstab.on_create()
{
   // Init vars private to tab control:
   typeless ht:[];
   ht:["_formW"] = p_active_form.p_width;
   ht:["_formH"] = p_active_form.p_height;
   ht:["_output_sstabW"] = p_width;
   ht:["_output_sstabH"] = p_height;

   // Find tab height and max tabs width:
   int i;
   int tallest, totalWidth;
   tallest = 0;
   totalWidth = 0;
   for (i=0; i<p_NofTabs; i++) {
      _str text;
      text = _getTabInfo(i);
      parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
      tabHeight = _dy2ly(SM_TWIP,y2 - y1);
      if (tabHeight > tallest) tallest = tabHeight;
      totalWidth += maxW;
   }
   ht:["tabHeight"] = tallest;
   ht:["pictureOnlyW"] = _dx2lx(SM_TWIP,totalWidth) + _dx2lx(SM_TWIP,4);
   p_user = ht;

   // If active tab is specified as arg(2).  Otherwise, use the saved value.
   if (arg() >= 2) {
      int active;
      active = arg(2);
      p_ActiveTab= active;
   } else {
      _retrieve_value();
   }
}
void _tboutput_form.on_destroy()
{
   value = _output_sstab.p_ActiveTab;
   _append_retrieve( _output_sstab, value );
   call_event(p_window_id,ON_DESTROY,'2');
}
#if 0
int _srg_outputtb()
{
   int formwid;
   formwid = _find_object("_tboutput_form","N");
   if (!formwid) return(0);
   if ( arg(1)=='R' || arg(1)=='N' ) {
      parse arg(2) with oldActive;
      formwid._output_sstab.p_ActiveTab= oldActive;
   } else {
      insert_line("OUTPUTTB: "formwid._output_sstab.p_ActiveTab);
   }
   return(0);
}
#endif
static void getNewSSTabWH(typeless & ht, int formWid, int sstWid, int & sstabW,
                          int & sstabH, int & tabHeight)
{
   _project_getNewSSTabWH(ht,formWid,sstWid,sstabW,sstabH,tabHeight);
   //sstabW = _dx2lx(SM_TWIP,formWid.p_client_width) - 2 * sstWid.p_x;
   //sstabH = _dy2ly(SM_TWIP,formWid.p_client_height) - 2 * sstWid.p_y;
}
static void resizeTabControl(typeless & ht)
{
   int sstabW,sstabH,tabHeight;
   getNewSSTabWH(ht, p_active_form, p_window_id, sstabW, sstabH, tabHeight);
   p_width = sstabW;
   p_height = sstabH;
   ht:["sstabW"] = sstabW;
   ht:["sstabH"] = sstabH;

   /*
   // Toggle tab control to display tab with text and images or just images:
   if (sstabW < ht:["pictureOnlyW"]) {
      if (p_PictureOnly != TRUE) {
         p_PictureOnly = TRUE;
      }
   } else {
      if (p_PictureOnly != FALSE) {
         p_PictureOnly = FALSE;
      }
   }
   */
}
static void resizeSearchTab(typeless & ht)
{
   int sstabW,sstabH,tabHeight;
   int nn;

   if (p_ActiveTab != OUTPUTTOOLTAB_SEARCH) return;
   getNewSSTabWH(ht, p_active_form, p_window_id, sstabW, sstabH, tabHeight);
   
   // Resize width:
   nn = sstabW - 2 * list1.p_x - _dx2lx(SM_TWIP,3);
   list1.p_width = nn;

   // Resize height:
   avail = sstabH - list1.p_y - tabHeight - list1.p_x - _dy2ly(SM_TWIP,4);
   list1.p_height = avail;
}
static void resizeShellTab(typeless & ht)
{
   int sstabW,sstabH,tabHeight;
   int nn;

   if (p_ActiveTab != OUTPUTTOOLTAB_SHELL) return;
   getNewSSTabWH(ht, p_active_form, p_window_id, sstabW, sstabH, tabHeight);
   
   // Resize width:
   nn = sstabW - 2 * _shellEditor.p_x - _dx2lx(SM_TWIP,3);
   _shellEditor.p_width = nn;

   // Resize height:
   avail = sstabH - _shellEditor.p_y - tabHeight - _shellEditor.p_x - _dy2ly(SM_TWIP,4);
   _shellEditor.p_height = avail;
}
static void resizeSymbolTab(typeless & ht)
{
   int sstabW,sstabH,tabHeight;
   int nn;

   if (p_ActiveTab != OUTPUTTOOLTAB_SYMBOL) return;
   getNewSSTabWH(ht, p_active_form, p_window_id, sstabW, sstabH, tabHeight);
   
   // Resize width:
   nn = sstabW - 2 * edit1.p_x - _dx2lx(SM_TWIP,2);
   edit1.p_width = nn;

   // Resize height:
   avail = sstabH - edit1.p_y - tabHeight - edit1.p_x - _dy2ly(SM_TWIP,4);
   edit1.p_height = avail;
   //if (avail<0) avail=0;

#if 0
   xbuffer=ctltagfiles.p_x;
   miny=max(ctltagfiles.p_y+ctltagfiles.p_height,ctltagname.p_y+ctltagname.p_height);
   edit1.p_y=miny+50;
   edit1.p_width=_dx2lx(SM_TWIP,edit1.p_parent.p_client_width)-(xbuffer*2);
   edit1.p_height=_dy2ly(SM_TWIP,edit1.p_parent.p_client_height)-edit1.p_y-50;
#endif
   ctlbufname.p_caption=ctlbufname._ShrinkFilename(ctlbufname.p_user,p_active_form.p_width-ctlbufname.p_x)
}
void _tboutput_form.on_resize()
{
   int forcedResize;
   forcedResize = 0;
   if (arg() > 0) forcedResize = arg(1);

   //say( "_tboutput_form.on_resize forcedResize="forcedResize );
   //say( "form p_width="p_width" p_height="p_height );
   //say( "obj="p_object" parent="p_parent );
   typeless lastW, lastH;
   typeless ht:[];
   ht = _output_sstab.p_user;
   if (ht._indexin("formWH")) {
      _str text;
      text = ht:["formWH"];
      parse text with lastW lastH;
      if (!forcedResize && lastW == p_width && lastH == p_height) return;
   } else {
      ht:["formWH"] = p_width:+" ":+p_height;
      _output_sstab.p_user = ht;
      return;
   }

   // Resize tab control:
   _output_sstab.resizeTabControl(ht);

   // Resize Search tab:
   _output_sstab.resizeSearchTab(ht);

   // Resize Shell tab:
   _output_sstab.resizeShellTab(ht);

   // Resize Search tab:
   _output_sstab.resizeSymbolTab(ht);

   // Save form's new XYWH:
   ht:["formWH"] = p_width:+" ":+p_height;
   _output_sstab.p_user = ht;
}
static int outputTabShow(int tabOrder, int hidden)
{
   // If form already exists, reuse it.  Otherwise, create it
   int formwid;
   formwid = _find_object("_tboutput_form","N");
   if (!formwid) {
      toggle_output();
      formwid = _find_object("_tboutput_form","N");
      int sstab;
      sstab = formwid._find_control("_output_sstab");
      sstab.p_ActiveTab= tabOrder;
      /*
         This code does not work with new toolbar docking
         smarts.
      if (hidden) {
         formwid = show('-hidden -xy -mdi _tboutput_form',0,tabOrder);
      } else {
         formwid = show('-xy -mdi _tboutput_form',0,tabOrder);
      } */
   } else {
      int sstab;
      sstab = formwid._find_control("_output_sstab");
      sstab.p_ActiveTab= tabOrder;
   }
   return(formwid);
}
int outputTabToolShowSearch()
{
   int hidden;
   hidden = 1;
   if (arg() > 0) hidden = arg(0);
   return(outputTabShow(OUTPUTTOOLTAB_SEARCH, hidden));
}
int outputTabToolShowShell()
{
   int formwid;
   formwid = outputTabShow(OUTPUTTOOLTAB_SHELL, 0);
   return(formwid._find_control("_shellEditor"));
}
int outputIsInTabShell()
{
   if (p_active_form.p_name != "_tboutput_form") return(0);
   int sstabId;
   sstabId = _find_control("_output_sstab");
   if (!sstabId) return(0);
   if (sstabId.p_ActiveTab != OUTPUTTOOLTAB_SHELL) return(0);
   return(1);
}
// Desc:  Return the window id of the editor control for the Shell output tab.
int outputGetShell()
{
   int formwid;
   formwid = _find_object("_tboutput_form","N");
   return(formwid._find_control("_shellEditor"));
}
void outputResetTabOutputShell()
{
   outputLastOnOutputTabShell = 0;
}
void outputSetLastOnTabShell(int on)
{
   outputLastOnOutputTabShell = on;
}
int outputIsLastOnTabShell()
{
   return(outputLastOnOutputTabShell);
}

_command void next_output_tab()
{
   wid=_find_object('_tboutput_form._output_sstab','n');
   if (wid) {
      wid.call_event(wid,name2event('c-tab'));
   }
}
_command void prev_output_tab()
{
   wid=_find_object('_tboutput_form._output_sstab','n');
   if (wid) {
      wid.call_event(wid,name2event('c-s-tab'));
   }
}
