/*
$VerboseHistory: pascal.e$
*/
/*
  Options for pascal syntax expansion/indenting may be accessed from SLICK's
  file extension setup menu (CONFIG, "File extension setup...").

  The extension specific options is a string of five numbers separated
  with spaces with the following meaning:

    Position       Option
       1             Minimum abbreviation.  Defaults to 1.  Specify large
                       value to avoid abbreviation expansion.
       2             Keyword case. Values may be 0,1, or 2 which correspond
                       to lower case, upper case, and capitalized.  Default
                       is 0.
       3             Begin/end style.  Begin/end style may be 0 or 1 (nonzero)
                       as show below. Default is 0.

                      Style 0
                          if expr then begin
                             statemens...
                          end;

                      Style 1
                          if expr then
                          begin
                             statements...
                          end;

                     Add 4 to the value if you want begin/end pairs inserted
                     during expansion.  (defaults to on).  Add 8 to the value
                     if you want Delphi syntax expansions.

       4             End commenting.  Defaults to 1.  0 is off, 1 is on.  Comments
                       ends with the keyword they are ending.  ex: end; { for }
       5             Indent constant from CASE.  Default is 1.  Specify
                       1 if you want constant statements indented from the
                       CASE statement.
*/
#include 'slick.sh'

#define STYLE1_FLAG 1
#define BE_INSERT_FLAG 4
#define DELPHI_EXPAND_FLAG 8

//Delphi Constants
#define D_ENTER_WORDS  (' begin case except exports else finally for initialization ':+\
                        'private public record repeat var then try type uses const while with on ')
/* Space words must be in sorted order */
#define D_EXPAND_WORDS ' begin else overlay property writeln label '
#define D_DECL_WORDS ' exports initialization type uses var const '

//Regular pascal constants
#define PAS_ENTER_WORDS (' begin case else for repeat var then type const while with ')
/* Space words must be in sorted order */
#define PAS_EXPAND_WORDS ' begin else overlay writeln label '
#define PAS_DECL_WORDS ' type var const '

#define PASCAL_COMMON_END_OF_STATEMENT_RE 'if|while|switch|for|case|default|public|private|protected|static|class|break|continue|do|else|goto|try|catch|return'
#define PASCAL_NOT_FUNCTION_WORDS ' catch do for if return synchronized switch throw while '

static _str d_space_words[]={
   'begin','case','const','constructor','destructor','else','exports','for','function','implementation',
   'initialization','interface','if','label','on','overlay','procedure','program'
   ,'property','repeat','record','try_except','try_finally','type','unit','uses'
   ,'var','while','with','writeln'
};
static _str pas_space_words[]={
   'begin','case','const','else','for','function','if','label','overlay',
   'procedure','program','repeat','type','var','while','with','writeln'
};

#define TK_ID 1
#define TK_NUMBER 1
#define TK_STRING 2
static _str gtkinfo;
static _str gtk;

static typeless word_case(s)
{
   parse name_info(p_index) with . . . scase .;
   if ( scase==0 ) {
      return(lowcase(s)); /* Lower case language key words. */
   } else if ( scase==1 ) {
      return(upcase(s));    /* Upper case language key words. */
   }
   where=1;
   inword=0;
   str='';
   do {
      ch=substr(s,where,1);
      where++;
      if (ch!=' '&& inword==0) {
         str=str:+upcase(ch);
         inword=1;
      } else str=str:+lowcase(ch);
      if (ch==' ') {
         inword=0;
      }
   } while (where <=length(s));

   return(str);
}

_command void pascal_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   /* The SELECT_EDIT_MODE procedure can find the file extension setup */
   /* data by passing it the 'pas' extension. */
   select_edit_mode('pas');
}

_command void pascal_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style end_comment indentcase .;
   if ( command_state() || p_window_state:=='I' ||
        p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
        _in_comment(1) || pascal_expand_enter(p_SyntaxIndent,expand,be_style,end_comment,indentcase) ) {
      call_root_key(ENTER);
   } else if (_argument=='') {
      _undo('S');
   }
}
_command void pascal_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   was_space=(last_event():==' ');
   parse name_info(_edit_window().p_index) with . expand . . be_style end_comment indentcase .;
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
        _in_comment() ||
        pas_expand_space(p_SyntaxIndent,be_style,end_comment,indentcase) ) {
      if ( was_space ) {
         if ( command_state() ) {
            call_root_key(' ');
         } else {
            keyin(' ');
         }
      }
   } else if (_argument=='') {
      _undo('S');
   }
}

pascal_get_info(var Noflines,var cur_line,var first_word,var last_word,
                var rest,var non_blank_col,var semi,var prev_semi)
{
   save_pos(old_pos);
   first_word='';last_word='';non_blank_col=p_col;
   orig_col=p_col;
   for (j=0; ; ++j) {
      get_line(cur_line);
      if (arg(9)!='') {
         _begin_line();
         i=verify(cur_line,' '\t);
         if ( i ) p_col=text_col(cur_line,i,'I');
         bool=cur_line!='' && _clex_find(0,'g')!=CFG_COMMENT;
      } else {
         bool=cur_line!='';
      }
      if (bool) {
         parse cur_line with line '(*'; /* Strip comment on current line. */
         parse line with line '{'; /* Strip comment on current line. */
         parse line with before_brace 'begin','i' +0 last_word;
         last_word=strip(last_word);

         //if lastword is '' then need to find the last word other than begin
         if (last_word=='') {
            parse line with stuff '( then| do| of| end| record)','ri' +0 last_word;  //the spaces make sure that it isn't part of another word
            if (lowcase(last_word)=='end;') {  //throw out the semi b/c we just want the end for the last word
               last_word=word_case('end');
            }
         }

         parse strip(line,'L') with first_word '[(:; \t]','r' +0 rest;
         parse name_info(_edit_window().p_index) with . expand . . be_style . indent_case .;
         if (lowcase(last_word)=='begin') {
            save_pos(p2);
            p_col=text_col(before_brace);
            _clex_skip_blanks('-');  //searches backwards, skipping blanks and comments till it finds another lexeme
            non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I');
            restore_pos(p2);
         } else {
            non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I');
         }
         Noflines=j;
         break;
      }
      if ( up() ) {
         restore_pos(old_pos);
         return(1);
      }
      if (j>=100) {
         restore_pos(old_pos);
         return(1);
      }
   }
   if (arg(9)!='') {
      if (!j) p_col=orig_col;
   }
   p='';
   if ( j ) {
      p=1;
   }
   semi=pas_stat_has_semi(p);
   prev_semi=pas_prev_stat_has_semi();
   restore_pos(old_pos);
   return(0);
}

/* Returns non-zero number if pass through to enter key required */
static typeless pascal_expand_enter(syntax_indent,expand,be_style,end_comment,indentcase)
{
   if (be_style & DELPHI_EXPAND_FLAG) {
      space_words=d_space_words;
      enter_words=D_ENTER_WORDS;
      expand_words=D_EXPAND_WORDS;
      decl_words=D_DECL_WORDS;
      delphi=1;
   } else {
      space_words=pas_space_words;
      enter_words=PAS_ENTER_WORDS;
      expand_words=PAS_EXPAND_WORDS;
      decl_words=PAS_DECL_WORDS;
      delphi=0;
   }

   status=pascal_get_info(Noflines,cur_line,first_word,last_word,rest,
                          non_blank_col,semi,prev_semi);
   // message("expent: #lines:"Noflines" cur_line:"cur_line" first_word:"first_word" last_word:"last_word" rest:"rest" nblc: "non_blank_col" semi:"semi" psemi:"prev_semi);
   lfirst_word=lowcase(first_word);
   llast_word=lowcase(last_word);  //so I don't need to test for different capitals
   line=cur_line;

   if (status) return(1);

   //Delphi class statement
   get_line(myline);
   if (pos('(:a)*( |\t)*=( |\t)*class\((:a)*\)',line,1,'ri')) {
      name=name_name(prev_index('','C'));
      if (pos('keyin-match-paren',name) && delphi) {

         parse line with before 'class','i' after;
         replace_line(before:+word_case('class'):+after);
         _save_pos2(p);
         first_non_blank();
         mycol=text_col(line,p_col,'p');
         insert_line(indent_string(mycol-1):+word_case('private'));
         insert_line('');
         insert_line(indent_string(mycol-1):+word_case('public'));
         insert_line('');
         if (end_comment) {
            insert_line(indent_string(mycol-1):+word_case('end; { class }'));
         } else {
            insert_line(indent_string(mycol-1):+word_case('end;'));
         }
         _restore_pos2(p);

      } else {
         /*col=p_col;
         save_pos(p);
         end_line();
         col2=p_col;
         restore_pos()
         if (col < col2) {
         } */
      }
      indent_on_enter(syntax_indent);
      return(0);
   }
   if (llast_word=='end' && myline!='') {     //line up next line with the block col
      _save_pos2(p);
      mycol=p_col;
      _end_line();
      if (mycol >= p_col) {  //make sure the cursor is at the end of the line, else fall through
         _restore_pos2(p);
         _save_pos2(p2);
         do {
            --p_col; //move left to get into the end
         } while (_clex_find(0,'g')!=CFG_KEYWORD  ); //this is so it will work with end comments
         do {
            //messageNwait('waiting');
            status=_find_matching_paren(def_pmatch_max_diff);
            myword=lowcase(cur_word(junk));
            if (myword=='begin') { //if it's not begin, it must be a case
               get_line thisline;
               if (lastpos('[~:]*\:[ \t]*(begin)' ,thisline,1,'ri')) {
                  mycol=verify(thisline,' '\t);
               } else mycol=pas_find_block_col();
               myword=lowcase(cur_word(junk));
            } else mycol=p_col;
         } while (myword=='end' && !status);  //in case they are indenting the elses in style 1

         _restore_pos2(p2);
         insert_line('');
         p_col=mycol;
         return(0);
      }
      _restore_pos2(p);

   }

   status=0;
   if ( expand && ! Noflines && 
        !(_dbcsSubstr(expand_tabs(line),p_col)!=""  && /*_expand_tabsc(p_col)!="" && */
          (name_on_key(ENTER):=='split-insert-line' ||
           (name_on_key(ENTER):=='maybe-split-insert-line' && _insert_state())
          )
         )
      ) {
      if (lfirst_word=='for' && name_on_key(ENTER):=='nosplit-insert-line' ) {
         if ( name_on_key(ENTER):!='nosplit-insert-line' ) {
            if ( (be_style & STYLE1_FLAG) || semi ) {
               return(1);
            }
            indent_on_enter(syntax_indent);
            return(0);
         }
         /* tab to fields of pascal for statement */
         line=expand_tabs(line);
         parse lowcase(line) with before ':=';
         if ( length(before)+1>=p_col ) {
            p_col=length(before)+4;
         } else {
            parse lowcase(line) with before 'to';
            if ( length(before)>=p_col ) {
               p_col=length(before)+4;
            } else {
               indent_on_enter(syntax_indent);
            }
         }
      } else if ( expand && 
                  (lfirst_word=='program' || lfirst_word=='procedure' || lfirst_word=='function'||
                   lfirst_word=='constructor' || lfirst_word=='destructor')
                ) {
         /* If next line is begin key word, comment begin/end with function name */
         save_pos(p);
         get_line(thisline);
         parse thisline with '(program|procedure|function|constructor|destructor)','ir' junk;
         if (junk!='') {
            num=1;
            if (lfirst_word=='program') {
               num++;    //the extra is so that there is a space between the begin of the program and any function headers.
            }
            down(num);
            get_line(next_line);
            if ( lowcase(next_line)=='begin' && p_col>text_col(line) ) {
               if (end_comment) {   //if end commenting is on, comment with the function name
                  up(num);
                  parse line with keyword function_name '([\:\(;])|$','r';
                  down(num);
                  function_name=strip(function_name);
                  replace_line(next_line' { 'function_name' }');
                  down();
                  get_line(line);
                  if ( lowcase(line)=='end;' || lowcase(line)=='end.' ) {
                     replace_line(line' { 'function_name' }');
                  }
               }
            }
            restore_pos(p);
            indent_on_enter(0);
         } else {
            replace_line(word_case(lfirst_word)); //move it over and capitalize
            indent_on_enter(syntax_indent);
         }
#if 0
      } else if (llast_word=='begin'&&lastpos('[~:]*\:[ \t]*(begin)' ,cur_line,1,'ri')) {   //check if it is a statement in a case
         parse cur_line with stuff 'begin','i' +0 junk;
         col=_pas_last_case_col();
         width=text_col(strip(stuff));

         if (name_name(prev_index('','C'))=='pascal-n') {   //was the last key hit an 'n'?

            //if indent constant from case is not on, subtract syntax_indent from col
            if (indentcase==1) {
               col=col+syntax_indent;
            }
            replace_line(indent_string(col-1):+strip(stuff):+' ':+word_case('begin'));
            insert_line('');
            stuff=strip(stuff);
            if (end_comment) {
               insert_line(indent_string(col+width)word_case('end;':+' { '):+substr(stuff,1,length(stuff)-1)' }');
            } else insert_line(indent_string(col+width)word_case('end;'));
            up();p_col=col + width + syntax_indent+1;
            return(0);
         } else {
            indent_on_enter(width+syntax_indent+1);
         }
#endif
      } else if (llast_word=='begin' && name_name(prev_index('','C'))=='pascal-n') {
         get_line(myline);
         parse line with stuff 'begin','i';
         replace_line(stuff:+word_case('begin'));
         pas_insert_end(be_style,end_comment,1);
         indent_on_enter(syntax_indent);

         /*} else if ( llast_word=='begin'||llast_word=='then' ) {
            messageNwait('inside test place');
            if ( lfirst_word!='while' || llast_word!=';' ) {
               if ( llast_word!='begin' && llast_word!='then' ) {
                  replace_line substr(line,1,pos(first_word,line)-1)word_case(lfirst_word) rest
                                      //note that pos uses the raw first word, not the lowercase one
            }
            messageNwait('status is 1');
            status=1;
         }*/
      } else if (lfirst_word=='case') {
         if (!indentcase) {
            indent_on_enter(0);
         } else {
            status=1;
         }
      } else if ( expand && (lfirst_word=='unit') ) {  //Delphi
         get_line(thisline);
         parse thisline with 'unit','i' junk;
         if (junk!='') {
            if ( p_col>text_col(line)) {
               save_pos(p);
               if (end_comment) {   //if end commenting is on, comment with the function name
                  parse line with keyword function_name '([\:\(;])|$','r';
                  down(10);
                  function_name=strip(function_name);
                  get_line(line);
                  if ( lowcase(line)=='end.' ) {
                     replace_line(line' { 'function_name' }');
                  }
                  restore_pos(p);
               }
               if (_find_keyword("interface")!="") {
                  down();
                  get_line(line);
                  if (line=="") {
                     down();
                     get_line(line);
                     if (line=="") {
                        down();
                        get_line(line);
                        up();
                        if (line=="") {
                           _begin_line();
                        } else {
                           up();
                           insert_line("");
                        }
                     } else {
                        up(2);
                        insert_line("");
                        status=1;
                     }
                  } else {
                     up();
                     insert_line("");
                     status=1;
                  }
               } else {
                  status=1;
               }
            } else {
               status=1;
#if 0               
               col=p_col;        //the col stuff is so that it won't indent if it's at the begining of the line
               end_line();
               col2=p_col;
               p_col=col;
               if (col2!=col) {
                  call_root_key(ENTER);
               } else indent_on_enter(syntax_indent);
#endif
            }
         } else {
            replace_line(word_case('unit')); //move it over and capitalize
            indent_on_enter(syntax_indent);
         }
#if 0  //won't work unless expansion is used, so take them out
      } else if (lfirst_word=='try_except' && delphi) {  //Delphi
         if (name_name(prev_index('','C'))=='pascal-y') {
            parse cur_line with stuff 'try','i' rest;  //find out how much to indent before the try
            width=text_col(stuff);

            line=stuff:+'try':+rest;
            replace_line word_case(line);
            _save_pos2(p);
            insert_line(indent_string(width):+word_case('except'));
            if (end_comment) {
               insert_line(indent_string(width)word_case('end; { try }'));
            } else {
               insert_line(indent_string(width)word_case('end;'));
            }
            _restore_pos2(p);
         }
         indent_on_enter(syntax_indent);

      } else if (lfirst_word=='try_finally' && delphi) {  //Delphi
         if (name_name(prev_index('','C'))=='pascal-y') {
            parse cur_line with stuff 'try','i';  //find out how much to indent before the try
            width=text_col(stuff);

            replace_line word_case(line);
            _save_pos2(p);
            insert_line(indent_string(width):+word_case('finally'));
            if (end_comment) {
               insert_line(indent_string(width)word_case('end; { try }'));
            } else {
               insert_line(indent_string(width)word_case('end;'));
            }
            _restore_pos2(p);
         }
         indent_on_enter(syntax_indent);
#endif
      } else if (llast_word=='record' && delphi) { //Delphi
         if (name_name(prev_index('','C'))=='pascal-d') {
            get_line(thisline);
            parse thisline with before 'record','i';
            replace_line(before:+word_case('record'));
            _save_pos2(p);
            first_non_blank();
            mycol=p_col-1;
            if (end_comment) {
               insert_line(indent_string(mycol):+word_case('end; { record }'));
            } else {
               insert_line(indent_string(mycol):+word_case('end;'));
            }
            _restore_pos2(p);
         }
         indent_on_enter(syntax_indent);


      } else if (pos(' 'lfirst_word' ',decl_words,1,'i')) {  //was llast word
         _save_pos2(p);
         get_line(thisline);
         col=p_col;        //the col stuff is so that it won't indent if it's at the begining of the line
         end_line();
         col2=p_col;
         p_col=col;
         if (col2 > col) {
            call_root_key(ENTER);
         } else {
            _restore_pos2(p);
            replace_line(word_case(lfirst_word));
            split_pos = pos(lfirst_word,thisline)+length(lfirst_word)+1;
            insert_line(indent_string(syntax_indent):+substr(thisline,split_pos));
            p_col=1+syntax_indent; //two indents
         }


      } else if (pos(' 'lfirst_word' ',enter_words,1,'i')) {
         mycol=p_col;
         _end_line();
         newcol=p_col;
         p_col=mycol; //move it back
         if (mycol < newcol) {
            indent_on_enter(0);
         } else indent_on_enter(syntax_indent);
      } else {
         status=1;
      }
   } else {
      status=1;
   }
   if ( status ) {  /* try some more? Indenting only. */
      status=0;
      col=pas_indent_col(cur_line,first_word,last_word,non_blank_col,semi,prev_semi,Noflines);
      indent_on_enter('',col);
   }
   return(status);

}

typeless pas_indent_col(cur_line,first_word,last_word,non_blank_col,semi,prev_semi,Noflines /*,pasting_open_brace2 */)
{
   lfirst_word=lowcase(first_word);
   llast_word=lowcase(last_word);
   pasting_open_brace2=arg(8);   // pasting open brace in style2
   parse name_info(p_index) with . expand . . be_style .;
   syntax_indent=p_SyntaxIndent;
   if ( syntax_indent<=0) {
      return(non_blank_col);
   }
   is_structure=pos(' 'lfirst_word' ',' if repeat while case for ');
   parse cur_line with cur_line '\(\*|\{|//','r';
   cur_line=strip(cur_line,'T');
   if (last_char(cur_line)==':' && substr(cur_line,1,1)=='') {
      is_structure=1;
   }
   past_non_blank=p_col>non_blank_col || name_on_key(ENTER)=='nosplit-insert-line';
   //messageNwait('is_struct='is_structure' semi='semi' psemi='prev_semi' firstw='first_word' lastw='last_word)

#if 1
   save_pos(p);
   up(Noflines);get_line(line);
   // Check for statement like this
   //
   //   if ( func(a,b,
   //          c,(d),(e) )) return;
   //
   //  look for last paren which matches to paren on different line.
   //
   if (Noflines) {
      i=length(line);
   } else {
      i=text_col(line,p_col,'p')-1;
   }
   //i=text_col(expand_tabs(line,1,p_col-1));
   //messageNwait('line='line' i='i);
   //old_col=p_col;
   pline=point();
   for (;;) {
      if (i<=0) break;
      j=lastpos(')',line,i);
      if (!j) break;
      p_col=text_col(line,j,'I');
      color=_clex_find(0,'g');
      //messageNwait('h1');
      if (color==CFG_COMMENT || color==CFG_STRING) {
         i=j-1;
         continue;
      }
      //messageNwait('try');
      status=_find_matching_paren(def_pmatch_max_diff);
      if (status) break;
      if (pline!=point()) {
         //messageNwait('special case');
         first_non_blank();
         non_blank_col=p_col;
         get_line(line);
         parse line with word .
         word=lowcase(word);  //for pascal keywords
         is_structure=pos(' 'word' ',' if repeat while case for ');
         //restore_pos(p);
         //return(col);
      }
      i=j-1;
   }
   if (llast_word=='end') {     //this will find the block col that the end belongs to
      _end_line();
      do {
         left();
      } while (_clex_find(0,'g')!=CFG_KEYWORD );  //this is safe since we know there is an end on the line

      do {
         //messageNwait('waiting');
         status=_find_matching_paren(def_pmatch_max_diff);
         myword=lowcase(cur_word(junk));
         if (myword=='begin') { //if it's not begin, it must be a case
            mycol=pas_find_block_col();
            myword=lowcase(cur_word(junk));
         } else mycol=p_col;
      } while (myword=='end' && !status);  //in case they are indenting the elses in style 1
      restore_pos(p);
      return(mycol);

   }
   restore_pos(p);
#endif
   if (
      ((llast_word=='begin'||  llast_word=='then') && past_non_blank) ||
      (is_structure && ! semi && past_non_blank && pasting_open_brace2!=1) ||
      pos('else$',strip(cur_line),1,'r') || (lfirst_word=='else' && !semi) ||
      (is_structure && llast_word=='begin' && past_non_blank) ) {
      //messageNwait('case1');
      return(non_blank_col+syntax_indent)
      /* Look for spaces, end brace, spaces, comment */
   } else if ( (semi && ! prev_semi)) {
      // OK we are a little lazy here. If the dangling statement is not indented
      // correctly, then neither will this statement.
      //
      //     if (
      //             )
      //             i=1;
      //         <end up here> and should be aligned with if
      //
      //messageNwait('case2');
      col=non_blank_col-syntax_indent;
      if ( col<=0 ) {
         col=1;
      }
      if ( col==1 ) {
         return(non_blank_col);
      }
      return(col);
   }
   return(non_blank_col);

}
static typeless pas_expand_space(syntax_indent,be_style,end_comment,indentcase)
{
   if (be_style & DELPHI_EXPAND_FLAG) {
      space_words=d_space_words;
      enter_words=D_ENTER_WORDS;
      expand_words=D_EXPAND_WORDS;
      decl_words=D_DECL_WORDS;
      delphi=1;
   } else {
      space_words=pas_space_words;
      enter_words=PAS_ENTER_WORDS;
      expand_words=PAS_EXPAND_WORDS;
      decl_words=PAS_DECL_WORDS;
      delphi=0;
   }

   /* Put first word of line in lower case into word variable. */
   get_line(orig_line);
   line=strip(orig_line,'T');
   orig_word=lowcase(strip(line));
   if ( p_col!=text_col(line)+1 ) {
      return(1);
   }
   status=pascal_get_info(Noflines,cur_line,first_word,last_word,rest,
                          non_blank_col,semi,prev_semi);

   lfirst_word=lowcase(first_word);
   llast_word=lowcase(last_word);  //so I don't need to test for different capitals

   aliasfilename='';

   word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename);

   if (aliasfilename!=''&&word!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      } else {
         //line_prefix=substr(line,1,col-1);
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   if_special_case=0;
   indent_value=0;
   if ( word=='') {
      name=name_name(prev_index('','C'));
      if (pos('(:a)*( |\t)*=( |\t)*class\((:a)*\)',line,1,'ri') && pos('keyin-match-paren',name) && delphi) {
         parse line with before 'class','i' after;
         replace_line(before:+word_case('class'):+after);
         _save_pos2(p);
         first_non_blank();
         mycol=text_col(line,p_col,'p');
         insert_line(indent_string(mycol-1):+word_case('private'));
         insert_line('');
         insert_line(indent_string(mycol-1):+word_case('public'));
         insert_line('');
         if (end_comment) {
            insert_line(indent_string(mycol-1):+word_case('end; { class }'));
         } else {
            insert_line(indent_string(mycol-1):+word_case('end;'));
         }
         _restore_pos2(p);

      } else {
         // Check for end else
         parse orig_line with first_word second_word rest;
         lfirst=lowcase(first_word);
         lsecond=lowcase(second_word);
         //messageNwait('first: 'lfirst' second: 'lsecond' rest: 'rest);
         if (lfirst=='end' && lsecond!='' && rest=='' && lsecond:==substr('els',1,length(lsecond))) {
            keyin(substr('else ',length(lsecond)+1));
            get_line(myline);
            replace_line(word_case(myline));  //the line only has an end and an if, so this is ok
            return(0);
         }
         // Check for else if or end else if
         if (lfirst=='else' && orig_word==substr('else if',1,length(orig_word))) {
            word='else if';
            if_special_case=1;
            if (second_word=='i') {
               indent_value=1;
            }
         } else if (lsecond=='else' && rest!='' && orig_word==substr('end else if',1,length(orig_word))) {
            word='end else if';
            if_special_case=1;
            if (rest=='i') {   //correct spacing if the 'if' is expanded
               indent_value=1;
            }
         }
      }
   }

#if 0
   if (llast_word=='begin'&&lastpos('[~:]*\:[ \t]*(begin)' ,orig_line,1,'ri')) {   //check if it is a statement in a case
      parse orig_line with stuff 'begin','i' +0 junk;
      col=_pas_last_case_col();
      width=text_col(strip(stuff));

      if (name_name(prev_index('','C'))=='pascal-n') {   //was the last key hit an 'n'?

         //if indent constant from case is not on, subtract syntax_indent from col
         if (indentcase==1) {
            col=col+syntax_indent;
         }

         replace_line(indent_string(col-1):+strip(stuff):+' ':+word_case('begin'));
         //insert_line '';
         stuff=strip(stuff);
         if (end_comment) {
            insert_line(indent_string(col+width)word_case('end;':+' { '):+substr(stuff,1,length(stuff)-1)' }');
         } else insert_line(indent_string(col+width)word_case('end;'));
         up();_end_line();p_col+=1;
         return(0);
      }  //else indent_on_enter(width+syntax_indent+1);
   }
#endif

   //line up the end depending on what style.
   if (llast_word=='begin' && name_name(prev_index('','C'))=='pascal-n') {
      get_line(myline);
      parse line with stuff 'begin','i';
      replace_line(stuff:+word_case('begin'));
      pas_insert_end(be_style,end_comment,1);
   }

   if (llast_word=='record' && name_name(prev_index('','C'))=='pascal-d' && delphi) {  //Delphi
      get_line(thisline);
      parse thisline with before 'record','i';
      replace_line(before:+word_case('record'));
      _save_pos2(p);
      first_non_blank();
      mycol=p_col-1;
      if (end_comment) {
         insert_line(indent_string(mycol):+word_case('end; { record }'));
      } else {
         insert_line(indent_string(mycol):+word_case('end;'));
      }
      _restore_pos2(p);
   }

#if 1
   /* Is the cursor not at the end of the line or the first word */
   /* not one of the SPACE BAR expansion key words. */
   if (word=='' && !if_special_case) {
      return(1);
   }
   //Dan changed for new alias expansion 11:16pm 4/18/1996
#else
   if ( (! pos(' 'word' ',space_words)) && !if_special_case) {
      return(1);    /* Fall through to space bar key. */
   }
#endif
   /* Insert the appropriate template based on the key word. */
   line=substr(line,1,length(line)-length(orig_word)):+word;
   width=text_col(line,length(line)-length(word)+1,'i')-1;

   //messageNwait('if special='if_special_case);
   if ( word=='if' || if_special_case==1 ) {
      replace_line(word_case(line):+word_case('  then'));
      _save_pos2(p);
      if (be_style & STYLE1_FLAG) {
         if (be_style & BE_INSERT_FLAG) {
            insert_line indent_string(width+syntax_indent)word_case('begin');
            pas_insert_end(be_style,end_comment, 0);
            _restore_pos2(p);
         }
         //p_col=width+4;
         p_col+=1;
         if (if_special_case/*and first word isn't end*/) {
            p_col+=indent_value;
         }
         //messageNwait('if, style 1');
         if ( ! _insert_state() ) {
            _insert_toggle();
         }
      } else {
         if (be_style & BE_INSERT_FLAG) {
            replace_line(word_case(line):+word_case('  then begin'));
            _end_line(); //cursor needs to be at the end of line for insert_end to work
            pas_insert_end(be_style,end_comment, 0);
            _restore_pos2(p);
         }
         p_col+=1;
         if (if_special_case) {
            p_col+=indent_value;
         }
         //messageNwait('if, style 0');
         if ( ! _insert_state() ) {
            _insert_toggle();
         }

      }
   } else if ( word=='for' ) {
      replace_line(word_case(word_case(line):+' :=  'word_case('to')'  'word_case('do')));
      _save_pos2(p);
      if (be_style & STYLE1_FLAG) {
         if (be_style & BE_INSERT_FLAG) {
            insert_line indent_string(width+syntax_indent)word_case('begin');
            pas_insert_end(be_style,end_comment,1);
            _restore_pos2(p);
         }
         p_col=width+5;
         if ( ! _insert_state() ) {
            _insert_toggle();
         }
      } else {
         if (be_style & BE_INSERT_FLAG) {
            replace_line(word_case(line):+' :=  ':+word_case('to'):+'  ':+word_case('do'):+' ':+word_case('begin'));
            _end_line(); //cursor needs to be at the end of line for insert_end to work
            pas_insert_end(be_style,end_comment,1);
            _restore_pos2(p);
            p_col+=1;
         } else {
            p_col+=length(word' ')-length(orig_word);
         }
         if ( ! _insert_state() ) {
            _insert_toggle();
         }

      }
   } else if ( word=='with' ) {
      //There are two 'with' cases in this if..else section.  Second one
      //has to be dead right?
      replace_line(word_case(word_case(line):+'  'word_case('do')));
      _save_pos2(p);
      if (be_style & STYLE1_FLAG) {
         if (be_style & BE_INSERT_FLAG) {
            insert_line indent_string(width+syntax_indent)word_case('begin');
            pas_insert_end(be_style,end_comment,1);
            _restore_pos2(p);
         }
         p_col=width+6;
         if ( ! _insert_state() ) {
            _insert_toggle();
         }
      } else {
         if (be_style & BE_INSERT_FLAG) {
            replace_line(word_case(line):+'  ':+word_case('do'):+' ':+word_case('begin'));
            _end_line(); //cursor needs to be at the end of line for insert_end to work
            pas_insert_end(be_style,end_comment,1);
            _restore_pos2(p);
            p_col+=1;
         } else {
            p_col+=length(word' ')-length(orig_word);
         }
         if ( ! _insert_state() ) {
            _insert_toggle();
         }

      }
   } else if (word=='while') {

      replace_line(word_case(line'  do'));
      _save_pos2(p);
      if (be_style & STYLE1_FLAG) {
         if (be_style & BE_INSERT_FLAG) {
            insert_line(indent_string(width+syntax_indent)word_case('begin'));
            pas_insert_end(be_style,end_comment,1);
            _restore_pos2(p);
         }
         p_col=width+7;
         if ( ! _insert_state() ) {
            _insert_toggle();
         }
      } else {
         if (be_style & BE_INSERT_FLAG) {
            replace_line(word_case(line'  do begin'));
            _end_line(); //cursor needs to be at the end of line for insert_end to work
            pas_insert_end(be_style,end_comment,1);
            _restore_pos2(p);
            p_col=width+7;
         } else p_col=width+7;
         if ( ! _insert_state() ) {
            _insert_toggle();
         }

      }
   } else if ( word=='case' ) {
      replace_line(word_case(line'  of'));
      if (end_comment) {
         insert_line(indent_string(width)word_case('end; { case }'));
      } else {
         insert_line(indent_string(width)word_case('end;'));
      }
      up();p_col=width+6;
      if ( ! _insert_state() ) {
         _insert_toggle();
      }
   } else if ( word=='repeat' ) {
      replace_line(word_case(line));
      insert_line(indent_string(width)word_case('until  ;'));
      up();call(nosplit_insert_line());
      p_col=p_col+syntax_indent;
   } else if ( word=='program' || 
               word=='procedure' ||  word=='function' ||
               word=='constructor' ||  word=='destructor'
             ) {
      save_pos(p);
      first_non_blank();
      mycol=p_col;
      restore_pos(p);

      // Just incase we are in a class definition, require
      // user to type entire word.
      if (orig_word=='procedure' || orig_word=='function' ||
          orig_word=='constructor' || orig_word=='destructor' ||
          mycol!=1) {
         get_line(thisline);
         parse thisline with before '(procedure|function)','ri';
         replace_line(indent_string(mycol-1):+word_case(word));
         end_line();
         p_col++;
      } else {
         temp_col=p_col;
         code=down();
         get_line(myline);
         if (1 /*!pos('begin',myline,1,'I')*/) {
            if (!code) { //down was successfull
               up();
            }
            p_col=temp_col;
            num=2;
            if (word=='program') {
               insert_line(' '); //this is so the keys function and procedure will expand (begin not on next line)
               num++;
            }
            insert_line(indent_string(width):+word_case('begin'));   //don't care if its in the wrong place, will fix below
            col=_pas_last_prog_col()-1;  //begin has to be there so it will match up
            up(num-1);                    //need to use strange order so that the begin is there for last_prog_col
            if (col==0) {
               replace_line(word_case(word));
            } else {
               replace_line(indent_string(col)word_case(word));
            }
            down(num-1);
            //_end_line;
            replace_line(indent_string(col)word_case('begin'));   //fix where the begin is
            if ( word == 'program' ) {
               insert_line(word_case('end.'));
            } else {
               insert_line(indent_string(col):+word_case('end;'));
            }
            up(num);_end_line();right();
         } else {
            if (!code) up();
            keyin(' ');
         }
      }

   } else if ( word=='writeln' ) {
      replace_line(indent_string(width)"writeln('");
      _end_line();
   } else if (word=='on') {   //Delphi
      replace_line(word_case(line'  do'));
      p_col=width+4;
   } else if (word=='try_except') {  //Delphi
      parse line with before 'try_except','i' rest;
      line=before:+'try':+rest;
      replace_line word_case(line);
      _save_pos2(p);
      insert_line(indent_string(width):+word_case('except'));
      if (end_comment) {
         insert_line(indent_string(width)word_case('end; { try }'));
      } else {
         insert_line(indent_string(width)word_case('end;'));
      }
      _restore_pos2(p);
      p_col=width+5;
   } else if (word=='try_finally') {  //Delphi
      parse line with before 'try_finally','i' rest;
      line=before:+'try':+rest;
      replace_line word_case(line);
      _save_pos2(p);
      insert_line(indent_string(width):+word_case('finally'));
      if (end_comment) {
         insert_line(indent_string(width)word_case('end; { try }'));
      } else {
         insert_line(indent_string(width)word_case('end;'));
      }
      _restore_pos2(p);
      p_col=width+5;
   } else if ( word=='unit' ) {  //Delphi
      replace_line(word_case(word));  //this always starts it in col 1
      _end_line();
      _save_pos2(p);
      insert_line('');
      insert_line(word_case('interface'));
      insert_line('');
      insert_line('');
      insert_line('');
      insert_line(word_case('implementation'));
      insert_line('');
      insert_line('');
      insert_line('');
      insert_line(word_case('end.'));
      _restore_pos2(p);
      p_col+=1;

   } else if ( pos(' 'word' ',decl_words) ) {
      replace_line(word_case(word));
      insert_line('');
      p_col=1+syntax_indent; //two indents
   } else if ( pos(' 'word' ',expand_words) ) {
      replace_line(indent_string(width)word_case(word)' ');
      _end_line();
   }

   return(0);

}

static typeless pas_prev_stat_has_semi()
{
   status=1;
   up();
   if ( ! rc ) {
      col=p_col;_end_line();get_line(line);
      parse line with line '\(\*|\{','r';
      line=strip(line,'T');
      //want this to be last word of line == do, then
      save_pos(p);
      _clex_skip_blanks('-');
      if (_clex_find(0,'g')==CFG_KEYWORD) {
         myword=lowcase(cur_word(junk));
      } else myword=''; //just to make sure

      restore_pos(p);
      if (myword=='then' || myword=='do') {
         status=0;  //if it was a do or a then, the first word must be a while, if or for
      } else {
         status=last_char(line)!=')' && ! pos('((end)|)else$',line,1,'r');
      }
      down();
      p_col=col;
   }
   return(status);
}
static typeless pas_stat_has_semi()
{
   get_line(line);
   parse line with line '(*';
   parse line with line '\(\*|\{','r';
   line=strip(line,'T');
   name=name_on_key(ENTER);
   return(last_char(line):==';' &&
          (
          ! (( name=='split-insert-line' ||
               (name=='maybe-split-insert-line' && _insert_state())
             ) && (p_col<=text_col(line) && arg(1)=='')
            )
          )
         );

}


int _pas_last_case_col()
{
   if (p_lexer_name=='') {
      return(0);
   }
   save_pos(p);
   // Find case at same brace level
   // search for begin brace,end brace, and case not in comment or string
   status=search('begin|end|case','@ri-');
   level= 0;
   for (;;) {
      if (status) {
         restore_pos(p);
         return(1);
      }
      word=get_text(match_length(),match_length('S'));
      color=_clex_find(0,'g');
      if (color!=CFG_STRING && color!=CFG_COMMENT) {
         switch (lowcase(word)) {
         case 'end':
            --level;
            break;
         case 'begin':
            ++level;
            break;
         default:
            //messageNwait("_pas_last_case_col: word="word" level="level);
            if (color==CFG_KEYWORD && level== 0) {
               result=p_col;
               restore_pos(p);
               return(result);
            } else ++level;     //must be a case
         }
      }
      status=repeat_search();
   }
}

int _pas_last_prog_col()
{
   if (p_lexer_name=='') {
      return(0);
   }
   save_pos(p);
   status=search('program|unit','@ri-');
   for (;;) {
      if (status) {
         restore_pos(p);
         return(1);
      }
      word=get_text(match_length(),match_length('S'));
      color=_clex_find(0,'g');
      if (color==CFG_KEYWORD) {
         first_non_blank();
         result=p_col;
         restore_pos(p);
         return(result)
      } else status=repeat_search();
   }


}
int _pas_last_func_col()
{
   if (p_lexer_name=='') {
      return(0);
   }
   save_pos(p);
   // Find function header at same brace level
   // search for begin, end and function/program headers
   status=search('program|function|procedure|begin|end|unit','@ri-');   //unit is for delphi.

   level= 1;    //because there are no begins before the var etc. headings
   for (;;) {
      if (status) {
         restore_pos(p);
         return(1);
      }
      word=get_text(match_length(),match_length('S'));
      color=_clex_find(0,'g');
      if (color!=CFG_STRING && color!=CFG_COMMENT) {
         switch (lowcase(word)) {
         case 'end':
            --level;
            break;
         case 'begin':
            ++level;
            break;
         default:
            if (color==CFG_KEYWORD && level== 1) {
               result=p_col;
               restore_pos(p);
               return(result);
            }
         }
      }
      //messageNwait('word:'word' level:'level);
      status=repeat_search();
   }
}

_command pascal_n() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_LASTKEY)
{
   //this function traps the n key so pascal_enter and space can be
   //smarter.
   keyin event2name(last_event());
   if (command_state()) {
   } else {
      word=cur_word(junk);
      if (upcase(word)=='BEGIN') {
         left(); //so c_lex_find will work
         if (_clex_find(0,'g')==CFG_KEYWORD) {  //probably redundant
            right();
            return('');
         }
         right();
      }
      last_index(0,'C');
   }
}

_command pascal_d() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_LASTKEY)
{
   //this function traps the d key so pascal_enter and space can be
   //smarter.
   keyin(event2name(last_event()));
   if (command_state()) {
   } else {
      word=cur_word(junk);
      if (upcase(word)=='RECORD') {
         left(); //so c_lex_find will work
         if (_clex_find(0,'g')==CFG_KEYWORD) {  //probably redundant
            right();
            return('');
         }
         right();
      }
      last_index(0,'C');
   }
}

_command pascal_y() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_LASTKEY)
{
   //this function traps the y key so pascal_enter and space can be
   //smarter.
   keyin(event2name(last_event()));
   if (command_state()) {
   } else {
      word=cur_word(junk);
      if (upcase(word)=='TRY') {
         left(); //so c_lex_find will work
         if (_clex_find(0,'g')==CFG_KEYWORD) {  //probably redundant
            right();
            return('');
         }
         right();
      }
      last_index(0,'C');
   }
}

int pas_endbrace_col(be_style)
{
   if (p_lexer_name=='') {
      return(0);
   }
   save_pos(p);
   --p_col;
   // Find matching begin brace
   status=_find_matching_paren(def_pmatch_max_diff);
   if (status) {
      restore_pos(p);
      return(0);
   }
   // Assume end brace is at level 0
   if (p_col==1) {
      restore_pos(p);
      return(1);
   }
   begin_brace_col=p_col;
   // Check if the first char before open brace is close paren
   col= pas_find_block_col();
   if (!col) {
      restore_pos(p);
      return(0);
   }
   if (be_style & STYLE1_FLAG) {
      restore_pos(p);
      return(begin_brace_col);
   }
   restore_pos(p);
   return(col);
}

int pas_find_try_col()
{
   if (p_lexer_name=='') {
      return(0);
   }
   save_pos(p);
   // Find case at same brace level
   // search for begin brace,end brace, and case not in comment or string
   status=search('begin|end|case|try','@ri-');

   level= 1;
   for (;;) {
      if (status) {
         restore_pos(p);
         return(1);
      }
      word=get_text(match_length(),match_length('S'));
      color=_clex_find(0,'g');
      if (color!=CFG_STRING && color!=CFG_COMMENT) {
         switch (lowcase(word)) {
         case 'end':
            --level;
            break;
         case 'begin':
         case 'case':
            ++level;
            break;
         default:
            if (color==CFG_KEYWORD && level== 1) {
               result=p_col;
               restore_pos(p);
               return(result);
            } else ++level;     //must be a try
         }
      }
      status=repeat_search();
   }
}
static int pas_find_block_col()
{
   temp_col=p_col;
   --p_col;
   if (_clex_skip_blanks('-')) return(0);
   //messageNwait('waiting');
   if (_clex_find(0,'g')!=CFG_KEYWORD) {
      //_message_box("pas_find_block_col: temp_col="temp_col);
      //messageNwait('returning 0 b/c its not a keyword');
      return(temp_col);
   }
   word=lowcase(cur_word(col));

   //messageNwait('lets see what the word is: 'word);
   if (word=='do' || word=='else' || word=='then' || word=='of') {
      first_non_blank();
      return(p_col);
      //return(p_col-length(word)+1);
   }
   return(p_col);
}

static int pas_insert_end(be_style,end_comment,semi)
{
   _save_pos2(p);
   p_col=p_col-5;
   //messageNwait('waiting1');
   style1col=p_col;
   col=pas_find_block_col()-1;
   //messageNwait('col:'col);
   myword=cur_word(junk);
   if (be_style & STYLE1_FLAG) {
      _restore_pos2(p);
      _save_pos2(p2);
      if (lowcase(myword)=='if' || lowcase(myword)=='else' || lowcase(myword)=='end') {
         insert_line(indent_string(style1col-1):+word_case('end'));
      } else insert_line(indent_string(style1col-1):+word_case('end;'));
      if (end_comment && lowcase(myword)!='if' && lowcase(myword)!='end' && lowcase(myword)!='else') {
         get_line(line);
         if (lowcase(myword)=='begin') {
            replace_line(line);
         } else {
            replace_line(line:+' { 'word_case(myword)' }');
         }
      }
      _restore_pos2(p2);
      p_col+=1;
      return(0);
   }
   _restore_pos2(p);
   _save_pos2(p2);
   if (lowcase(myword)=='if' || lowcase(myword)=='else' || lowcase(myword)=='end') {
      insert_line(indent_string(col):+word_case('end'));
   } else {
      insert_line(indent_string(col):+word_case('end;'));
   }
   if (end_comment && lowcase(myword)!='if' && lowcase(myword)!='end' && lowcase(myword)!='else') {
      get_line(line);
      if (lowcase(myword)=='begin') {
         replace_line(line);
      } else {
         replace_line(line:+' { 'word_case(myword)' }');
      }
   }
   _restore_pos2(p2);
   p_col+=1;
   return(0);
}
/*
   Returns string keyword found
*/
static _str _find_keyword(re_words)
{
   save_pos(p);
   status=search("{"re_words"}","r");
   for (;;) {
      if (status) {
         restore_pos(p);
         return("");
      }
      cfg=_clex_find(0,'g');
      if (cfg==CFG_KEYWORD) {
         word=get_text(match_length('0'),match_length('S0'));
         return(word);
      }
      status=repeat_search();
   }
}

#define PASCAL_CONTEXT_TAGGING 0
#if PASCAL_CONTEXT_TAGGING
/////////////////////////////////////////////////////////////////////////////////////
// Context tagging related function for Pascal, Modula, Ada, etc.
//
static int _pas_parse_return_type(_str (&errorArgs)[], typeless tag_files,
                                  _str symbol, _str search_class_name,
                                  _str file_name, _str return_type,
                                  _str &match_type, int &pointer_count,
                                  int &pas_return_flags, _str &match_tag)
{
   //say("_pas_parse_return_type("symbol","search_class_name","return_type","file_name")");
   boolean found_seperator = false;
   boolean allow_local_class= true;
   _str orig_return_type = return_type;
   _str found_type = '';
   _str package_name = '';
   match_type = '';

   while (return_type != '') {
      p = pos('^ @{\:\:|\:\[|\[|\]|[.<>*&()]|:v|\@:i:v|\@:i}', return_type, 1, 'r');
      if (p <= 0) {
         break;
      }
      p = pos('S0');
      n = pos('0');
      ch = substr(return_type, p, n);
      return_type = substr(return_type, p+n);
      //say("return ch="ch" return_type="return_type);
      //say("package_name="package_name" ch="ch);
      switch (ch) {
      case 'extern':
      case 'struct':
      case 'class':
      case 'interface':
      case 'union':
         break;
      case 'volatile':
         pas_return_flags |= VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY;
         break;
      case 'const':
         pas_return_flags |= VSCODEHELP_RETURN_TYPE_CONST_ONLY;
         break;
      case '::':
         found_seperator = true;
         if (found_type == '') {
            pas_return_flags |= VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
            allow_local_class=false;
         } else {
            allow_local_class=true;
         }
         break;
      case '.':
            if (pos('/',package_name)) {
               new_package_name = stranslate(package_name,'.','/');
               if (tag_check_for_package(new_package_name, tag_files, true, true)) {
                  package_name = new_package_name :+ '/';
               }
            } else if (package_name != '' && tag_check_for_package(package_name, tag_files, true, true)) {
               package_name = package_name :+ '/';
            } else {
               package_name = package_name :+ '.';
            }
         break;
      case '*':
         if (found_type != '') {
            pointer_count++;
         }
         //say("PARSE *, pointer_count="pointer_count);
         break;
      case '&':
         break;
      case ':[':
         if (!match_brackets(return_type, num_args)) {
            errorArgs[1] = orig_return_type;
            return VSCODEHELPRC_BRACKETS_MISMATCH;
         }
         pas_return_flags |= VSCODEHELP_RETURN_TYPE_HASHTABLE;
         pointer_count++;
         //say("PARSE:[], pointer_count="pointer_count);
         break;
      case '[':
         if (!match_brackets(return_type, num_args)) {
            errorArgs[1] = orig_return_type;
            return VSCODEHELPRC_BRACKETS_MISMATCH;
         }
         pas_return_flags |= VSCODEHELP_RETURN_TYPE_ARRAY;
         pointer_count++;
         //say("PARSE[], pointer_count="pointer_count);
         break;
      case ']':
         break;
      case '(':
         if (!match_parens(return_type, parenexp, num_args)) {
            // this is not good
            errorArgs[1] = orig_return_type;
            return VSCODEHELPRC_PARENTHESIS_MISMATCH;
         }
         while (pos('[', parenexp)) {
            parenexp = substr(parenexp, pos('S')+1);
            if (!match_brackets(parenexp, num_args)) {
               errorArgs[1] = orig_return_type;
               return VSCODEHELPRC_BRACKETS_MISMATCH;
            }
            pointer_count++;
         }
         break;
      case ')':
         break;
      default:
         // this must be an identifier
         // try simple macro substitution
         //say("XXXXXXXXXXXXXXXXXXX, return_type="return_type);
         //if (_MatchSymbolAsDefine(ch, ch)) {
         _UpdateContext(true);
         if (tag_check_for_define(ch, 0, tag_files, ch)) {
            switch (ch) {
            case '':
            case 'extern':
            case 'struct':
            case 'class':
            case 'interface':
            case 'union':
               continue;
            case 'volatile':
               pas_return_flags |= VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY;
               continue;
            case 'const':
               pas_return_flags |= VSCODEHELP_RETURN_TYPE_CONST_ONLY;
               continue;
            }
         }
         if (pos('::*',return_type)==1) {
            return_type='';
            break;
         }
         package_name = package_name :+ ch;
         if (found_type != '' && allow_local_class && found_seperator) {
            found_type = found_type :+ VS_TAGSEPARATOR_class :+ ch;
            found_seperator = false;
         } else {
            found_type = ch;
         }
      }
   }
   //say("maybe searching for local class");
   //say("search_class="search_class_name" found_type="found_type);
   _str qualified_name = found_type;
   if (pos('/', package_name)) {
      found_type = package_name;
   }
   if (allow_local_class) {// && (search_class_name == '' || search_class_name == cur_class_name)) {
      //say("JJJJJJ found_type="found_type" return_type="return_type" search_class="search_class_name);
      _str inner_name, outer_name;
      tag_split_class_name(found_type, inner_name, outer_name);
      //say("found_type="found_type" inner_name="inner_name" outer_name="outer_name);
      qualified_name='';
      if (length(outer_name) < length(search_class_name)) {
         //say("inner_name="inner_name" search_class="search_class_name);
         outer_name = tag_join_class_name(inner_name, search_class_name, tag_files, true);
         //say("outer_name="outer_name);
         qualified_name = outer_name;
         if (outer_name :== '' && search_class_name :!= '' && found_type :!= inner_name) {
            outer_name = found_type;
         }
      }
      if (qualified_name=='') {
         //say("JJJJJJJ inner_name="inner_name" outer_name="outer_name);
         qualified_name = _QualifySymbolName(inner_name, outer_name, file_name, true);
         //say("JJJJJJJ qualify="qualified_name" symbol="symbol" class="search_class_name);
      }
      if (qualified_name=='') {
         qualified_name = found_type;
      }
   }
      // try to handle typedefs
      //say("check for typedef, qualified_name="qualified_name" found_type="found_type);
      tag_split_class_name(qualified_name, qualified_inner, qualified_outer);
      if (tag_check_for_typedef(found_type, tag_files, true)) {
         //say(qualified_name" is a typedef");
         int orig_const_only    = (pas_return_flags | VSCODEHELP_RETURN_TYPE_CONST_ONLY);
         int orig_volatile_only = (pas_return_flags | VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY);
         status = _pas_get_return_type_of(errorArgs, tag_files, found_type, qualified_outer,
                                        0, VS_TAGFILTER_TYPEDEF, false,
                                        qualified_name, pointer_count,
                                        pas_return_flags, match_tag);
         if (!(pas_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY)) {
            pas_return_flags |= orig_const_only;
         }
         if (!(pas_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY)) {
            pas_return_flags |= orig_volatile_only;
         }
         if (status) {
            return status;
         }
         //say("qualify = "qualified_name" found_type="found_type);
      }
   if (qualified_name == '' && 
       (pas_return_flags & (VSCODEHELP_RETURN_TYPE_ARRAY|VSCODEHELP_RETURN_TYPE_HASHTABLE)) &&
       (_modename_eq(p_mode_name,"javascript") || 
        _modename_eq(p_mode_name,"slick-c"))) {
      qualified_name = found_type;
   }
   if (qualified_name == '') {
      if (pos(' 'found_type' ', ' boolean char short int long float double signed unsigned void ')) {
         errorArgs[1] = symbol;
         errorArgs[2] = orig_return_type;
         match_type   = found_type;
         return VSCODEHELPRC_BUILTIN_TYPE;
      }
   }

   match_type = qualified_name;
   //say("_pas_parse_return_type returns "match_type);
   if (match_type == '') {
      errorArgs[1] = found_type;
      return VSCODEHELPRC_RETURN_TYPE_NOT_FOUND;
   }
   return 0;
}
static int _pas_get_return_type_of(_str (&errorArgs)[], typeless tag_files,
                                 _str symbol, _str search_class_name,
                                 int min_args, int pushtag_mask, boolean maybe_class_name,
                                 _str &match_type, int &pointer_count,
                                 int &pas_return_flags, _str &match_tag)
{
   //say("_pas_get_return_type_of("symbol","search_class_name")");

   // initialize pas_return_flags
   pas_return_flags &= ~(VSCODEHELP_RETURN_TYPE_CONST_ONLY|
                       VSCODEHELP_RETURN_TYPE_STATIC_ONLY|
                       VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY|
                       VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS|
                       VSCODEHELP_RETURN_TYPE_ARRAY|
                       VSCODEHELP_RETURN_TYPE_HASHTABLE
                      );
   if (search_class_name == '::') {
      pas_return_flags |= VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
      search_class_name = '';
   }

   // get the current class from the context
   _str cur_class_name='';
   int cur_tag_flags=0;
   int context_id = tag_current_context();
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_class, context_id, cur_class_name);
      tag_get_detail2(VS_TAGDETAIL_context_flags, context_id, cur_tag_flags);
      tag_get_detail2(VS_TAGDETAIL_context_type,  context_id, cur_tag_type);
      tag_get_detail2(VS_TAGDETAIL_context_name, context_id, cur_tag_name);
      if (tag_tree_type_is_class(cur_tag_type) || tag_tree_type_is_package(cur_tag_type)) {
         _str no_tag_files[]; no_tag_files._makeempty();
         cur_class_name = tag_join_class_name(cur_tag_name, cur_class_name, no_tag_files, true);
      }
   }

   // special case keyword 'this'
   if (symbol :== 'this') {
      if (search_class_name :== '' && context_id > 0 && 
          !(cur_tag_flags & VS_TAGFLAG_static)) {
         pas_return_flags |= VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS;
         if (cur_tag_flags & VS_TAGFLAG_const) {
            pas_return_flags |= VSCODEHELP_RETURN_TYPE_CONST_ONLY;
         } else {
            pas_return_flags &= ~VSCODEHELP_RETURN_TYPE_CONST_ONLY;
         }
         if (cur_tag_flags & VS_TAGFLAG_volatile) {
            pas_return_flags |= VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY;
         } else {
            pas_return_flags &= ~VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY;
         }
         pas_return_flags &= ~VSCODEHELP_RETURN_TYPE_STATIC_ONLY;
         match_type = cur_class_name;
         pointer_count = 0;
         return 0;
      } else if (search_class_name != '') {
         pas_return_flags &= ~(VSCODEHELP_RETURN_TYPE_CONST_ONLY|
                             VSCODEHELP_RETURN_TYPE_STATIC_ONLY|
                             VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY|
                             VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS|
                             VSCODEHELP_RETURN_TYPE_ARRAY|
                             VSCODEHELP_RETURN_TYPE_HASHTABLE
                            );
         match_type = search_class_name;
         pointer_count = 0;
         return 0;
      }
   }

   int num_matches = _pas_match_return_type_of(errorArgs,tag_files,
                                             symbol,search_class_name,
                                             pushtag_mask, 
                                             pas_return_flags);
   // check for error condition
   if (num_matches < 0) {
      return num_matches;
   }

   // resolve the type of the matches
   match_tag = '';
   int orig_return_flags = pas_return_flags;
   int status = _pas_get_type_of_matches(errorArgs, tag_files, symbol,
                                       search_class_name, cur_class_name,
                                       min_args, maybe_class_name,
                                       match_type, pointer_count,
                                       pas_return_flags, match_tag);
   if (!status && (orig_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY)) {
      pas_return_flags |= VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
   }
   return status;
}
static int _pas_match_return_type_of(_str (&errorArgs)[], typeless tag_files,
                                   _str symbol, _str search_class_name,
                                   int pushtag_mask,int pas_return_flags)
{
   //say("_pas_match_return_type_of("symbol","search_class_name")");

   // Attempt to qualify symbols to their appropriate package for Java
   if (search_class_name=='') {
      search_class_name = _QualifySymbolName(symbol, search_class_name, p_buf_name, true);
      tag_split_class_name(search_class_name, junk, search_class_name);
   }
   //say("2 before previous_id="symbol" match_class="search_class_name);

   // try to find match for 'symbol' within context, watch for
   // C++ global designator (leading ::)
   int i, num_matches = 0;
   tag_clear_matches();
   if (pas_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY) {
      //say("matching globals");
      tag_list_context_globals(0, 0, symbol, true, tag_files, VS_TAGFILTER_ANYTHING,
                               VS_TAGCONTEXT_ONLY_non_static,
                               num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS, true, true);
   } else {
      //say("matching class symbols, search_class="search_class_name" symbol="symbol" pushtag_mask="pushtag_mask);
      _MatchSymbolInContext(symbol, search_class_name,
                            num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                            pushtag_mask, true, true,
                            false, true, true, true);
   }

   // return the number of matches
   //say("num_matches="num_matches);
   return num_matches;
}
static int _pas_get_type_of_matches(_str (&errorArgs)[], typeless tag_files,
                                  _str symbol, _str search_class_name,
                                  _str cur_class_name, int min_args,
                                  boolean maybe_class_name,
                                  _str &match_type, int &pointer_count,
                                  int &pas_return_flags, _str &match_tag)
{
   //say("_pas_get_type_of_matches("symbol","search_class_name")");

   // filter out matches based on number of arguments
   _str matchlist[];
   matchlist._makeempty();
   //say("_pas_get_type_of_matches num="num_matches);
   int num_matches = tag_get_num_of_matches();
   for (i=1; i<=num_matches; i++) {
      tag_get_match(i,tag_file,proc_name,type_name,file_name,line_no,class_name,tag_flags,signature,return_type);
      //say("XXX proc_name="proc_name" min_args="min_args" return_type="return_type" type_name="type_name" class_name="class_name);
      // check that number of argument matches.
      if (min_args > 0 && tag_tree_type_is_func(type_name)) {
         int num_args = 0;
         int def_args = 0;
         int ff=1;
         for (;;) {
            _str parm = cb_next_arg(signature, arg_pos, ff);
            if (parm == '') {
               break;
            }
            if (pos('=', parm)) {
               def_args++;
            }
            if (parm :== '...') {
               num_args = min_args;
               break;
            }
            num_args++;
            ff=0;
         }
         // this prototype doesn't take enough arguments?
         if (num_args < min_args) {
            continue;
         }
         // this prototype requires too many arguments?
         if (num_args - def_args > min_args) {
            continue;
         }
      }
      if ((tag_flags & VS_TAGFLAG_operator) && class_name :!= search_class_name) {
         continue;
      }
      //say("WHERE proc_name="proc_name" class="class_name" return_type="return_type);
      if (match_tag == '') {
         match_tag = tag_tree_compose_tag(proc_name, class_name, type_name, tag_flags, signature, return_type);
         //say("MATCH TAG="match_tag);
      }
      if (tag_tree_type_is_class(type_name)) {
         return_type = proc_name;
      }
      if (return_type != '') {
         matchlist[matchlist._length()] = proc_name "\t" class_name "\t" file_name "\t" return_type;
      } else {
         num_matches--;
      }
   }

   // for each match in list, (have to do it this way because
   // _pas_parse_return_type()) uses the context match set.
   match_type = '';
   int match_pointer_count = 0;
   for (i=0; i<matchlist._length(); i++) {

      parse matchlist[i] with proc_name "\t" class_name "\t" file_name "\t" return_type;
      //say("HERE proc_name="proc_name" class="class_name" return_type="return_type);

      int found_return_flags      = 0;
      int found_pointer_count = 0;
      _str found_type = '';
      status = _pas_parse_return_type(errorArgs, tag_files, proc_name, class_name,
                                    file_name, return_type,
                                    found_type, found_pointer_count,
                                    found_return_flags, match_tag);
      if (status) {
         return status;
      }
      //say("**found_type="found_type" match_type="match_type" flags="found_return_flags);
      if (found_type != '') {

         if (match_type == '') {
            match_type = found_type;
            //_message_box("new match type="match_type);
            pas_return_flags = found_return_flags;
            pointer_count += found_pointer_count;
            //say("RETURN, pointer_count="pointer_count" found_pointer_count="found_pointer_count" found_type="found_type);
            match_pointer_count = found_pointer_count;
         } else {
            // different opinions on static_only or const_only, chose more general
            if (!(pas_return_flags & found_return_flags & VSCODEHELP_RETURN_TYPE_STATIC_ONLY)) {
               pas_return_flags &= ~VSCODEHELP_RETURN_TYPE_STATIC_ONLY;
            }
            if (!(pas_return_flags & found_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY)) {
               pas_return_flags &= ~VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY;
            }
            if (!(pas_return_flags & found_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY)) {
               pas_return_flags &= ~VSCODEHELP_RETURN_TYPE_CONST_ONLY;
            }
            if (!(pas_return_flags & found_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY)) {
               pas_return_flags &= ~VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
            }
            pas_return_flags |= (found_return_flags | VSCODEHELP_RETURN_TYPE_ARRAY);
            pas_return_flags |= (found_return_flags | VSCODEHELP_RETURN_TYPE_HASHTABLE);
            if (match_type :!= found_type || match_pointer_count != found_pointer_count) {
               // different return type, this sucks.
               //say("MATCH_TYPE="match_type" FOUND_TYPE="found_type);
               errorArgs[1] = symbol;
               return VSCODEHELPRC_OVERLOADED_RETURN_TYPE;
            }
         }
      }
   }

   //_message_box("OUT OF LOOP");
   //say("maybe class name, num_matches="num_matches);
   // Java syntax like Class.blah... or C++ style iostream::blah
   if (maybe_class_name && num_matches==0) {
      //say("111 searching for class name, symbol="symbol" class="search_class_name);
      _MatchSymbolInContext(symbol, search_class_name,
                            num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                            VS_TAGFILTER_PACKAGE|VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE|VS_TAGFILTER_UNION|VS_TAGFILTER_PACKAGE,
                            true, !(pas_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY), 
                            false, false, true, true);
      //say("found "num_matches" matches");
      if (num_matches > 0) {
         tag_get_match(1, x_tag_file, x_tag_name, x_type_name, x_file_name, x_line_no, x_class_name, x_tag_flags, x_signature, x_return_type);
         //say("X tag="x_tag_name" class="x_class_name" type="x_type_name);
         match_type = symbol;
         if (search_class_name == '' || search_class_name == cur_class_name) {
            _str outer_class_name = cur_class_name;
            int local_matches=0;
            while (outer_class_name != '') {
               _MatchSymbolInContext(match_type, cur_class_name,
                                     local_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                     VS_TAGFILTER_PACKAGE|VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE|VS_TAGFILTER_UNION,
                                     true, !(pas_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY), 
                                     false, false, true, true);
               //say("222 match_type="match_type" cur_class_name="cur_class_name" num_matches="local_matches);
               if (local_matches > 0) {
                  tag_get_match(1, rel_tag_file, rel_tag_name, rel_type_name, rel_file_name, rel_line_no, rel_class_name, rel_tag_flags, rel_signature, rel_return_type);
                  match_type = tag_join_class_name(match_type, rel_class_name, tag_files, true);
                  //say("type_name="rel_type_name" MATCH_TYPE="match_type);
                  pas_return_flags |= VSCODEHELP_RETURN_TYPE_STATIC_ONLY;
                  break;
               }
               tag_split_class_name(outer_class_name, junk, outer_class_name);
            }
         } else if (search_class_name != '') {
            match_type = tag_join_class_name(match_type, search_class_name, tag_files, true);
            pas_return_flags |= VSCODEHELP_RETURN_TYPE_STATIC_ONLY;
         }
      }
   }

   // no matches?
   if (num_matches == 0) {
      //say("_pas_get_type_of_matches: no symbols found");
      errorArgs[1] = symbol;
      return VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }

   // current method is from same class, then we have private access
   if (match_type :== cur_class_name) {
      pas_return_flags |= VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS;
   }
   //say("_pas_get_type_of_matches() returns "match_type" pointers="pointer_count);
   return 0;
}
// pull prefix off of prefixexp until matching bracket, paren, or lt/gt
// returns true if match was found, false otherwise
static _str _pas_get_expr_token(_str &prefixexp)
{
   // get next token from expression
   int p = pos('^ @{->(\*|)|\.\*|\:\:|<<|>>|\&\&|\|\||[<>=\|\&\*\+-/~\^\%](=|)|:v|[()\.]|\[|\]}', prefixexp, 1, 'r');
   if (!p) {
      return '';
   }
   p = pos('S0');
   int n = pos('0');
   _str ch = substr(prefixexp, p, n);
   prefixexp = substr(prefixexp, p+n);
   return ch;
}
static int _pas_get_type_of_part(_str (&errorArgs)[], typeless tag_files,
                               _str &previous_id, _str ch,
                               _str &prefixexp, _str &full_prefixexp,
                               _str &match_class, int &pointer_count, int &reference_count,
                               int &pas_return_flags, _str &match_tag, int depth=0)
{
   //say("_pas_get_type_of_part("previous_id","ch","prefixexp","full_prefixexp")");
   // was the previous identifier a builtin type?
   _str current_id = previous_id;
   boolean previous_builtin = false;
   switch (previous_id) {
   case 'char':
   case 'short':
   case 'int':
   case 'long':
   case 'signed':
   case 'unsigned':
   case 'float':
   case 'double':
   case 'void':
      previous_builtin = true;
      break;
   }

   // number of arguments in paren or brackets group
   int num_args = 0;

   // process token
   switch (ch) {
   case '->':     // pointer to member
      if (previous_id != '') {
         status = _pas_get_return_type_of(errorArgs, tag_files,
                                        previous_id, match_class, 0,
                                        VS_TAGFILTER_ANYDATA, true,
                                        match_class, pointer_count,
                                        pas_return_flags, match_tag);
         //say("match_class="match_class" pointer_count="pointer_count" status="status);
         if (status) {
            return status;
         }
         previous_id = '';
      }
      //say("pointer_count="pointer_count);
      if (pointer_count < 1) {
         errorArgs[1] = current_id;
         return (VSCODEHELPRC_DASHGREATER_FOR_NON_POINTER);
      } else if (pointer_count > 1) {
         errorArgs[1] = current_id;
         return (VSCODEHELPRC_DASHGREATER_FOR_PTR_TO_POINTER);
      }
      pointer_count = 0;
      break;

   case '.':     // member access operator
      if (previous_id != '') {
         //say("before previous_id="previous_id" match_class="match_class);
         status = _pas_get_return_type_of(errorArgs, tag_files,
                                        previous_id, match_class, 0,
                                        VS_TAGFILTER_ANYSTRUCT|VS_TAGFILTER_ANYDATA, true,
                                        match_class, pointer_count,
                                        pas_return_flags, match_tag);
         // special case for array, hash tables in slick-C, javascript
         //say("status="status" p_mode_name="p_mode_name" pas_return_flags="pas_return_flags);
         // unknown variable used in slick-c 'DOT' expression, then just skip it
         if (_modename_eq(p_mode_name,"slick-c") && 
             depth < VSCODEHELP_MAXRECURSIVETYPESEARCH &&
             (status == VSCODEHELPRC_BUILTIN_TYPE ||
              status == VSCODEHELPRC_NO_SYMBOLS_FOUND)) {
            return _pas_get_type_of_prefix(errorArgs, prefixexp, match_class, false,
                                         pointer_count, pas_return_flags,
                                         match_tag, depth+1);
         }
         if (status) {
            return status;
         }
         previous_id = '';
         //say("after previous_id="previous_id" match_class="match_class" pointer_count="pointer_count);
      }
      if (pointer_count > 0) {
         //say("checking pointer count > 0");
         if (_modename_eq(p_mode_name,"javascript")) {
            match_class = "Array";
            pointer_count = 0;
         } else if (_modename_eq(p_mode_name,"slick-c")) {
            if (pas_return_flags & VSCODEHELP_RETURN_TYPE_ARRAY) {
               match_class = '_array';
               pointer_count = 0;
            } else if (pas_return_flags & VSCODEHELP_RETURN_TYPE_HASHTABLE) {
               match_class = '_hashtable';
               pointer_count = 0;
            } else {
               errorArgs[1] = current_id;
               return(VSCODEHELPRC_DOT_FOR_POINTER);
            }
         } else {
            errorArgs[1] = current_id;
            return(VSCODEHELPRC_DOT_FOR_POINTER);
         }
      } else if (pointer_count < 0) {
         errorArgs[1] = full_prefixexp;
         return(VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX);
      }
      break;

   case '::':    // static member or global scope indicator
      //say(":: previous_id="previous_id" match_class="match_class);
      if (previous_id == '' && match_class=='') {
         pas_return_flags |= VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY;
         match_class = '::';
         //say("XX match_class=::");
      } else if (previous_id != '') {
         status = _pas_get_return_type_of(errorArgs, tag_files,
                                        previous_id, match_class, 0,
                                        VS_TAGFILTER_ANYDATA, true,
                                        match_class, pointer_count,
                                        pas_return_flags, match_tag);
         //say(":: match_class="match_class" status="status);
         if (status) {
            return status;
         }
         // THIS could be just a class qualification for making an
         // assignment to a pointer to member or pointer to member func.
         // SO, we have to list everything, not just statics.
         // ALSO, the class could be a base class qualification for a
         // function call BASE::myvirtualfunc();
         previous_id = '';
      } else {
         //say(":: already processed previous ID");
      }
      break;

   case 'new':   // new keyword
      // Just ignore 'new' if we don't know what to do with it
      if (!pos('(',prefixexp)) {
         break;
      }
      p = pos('^:b{:v}:b', prefixexp, 1, 'r');
      if (!p) {
         // this is not good news...
         //say("return from new");
         errorArgs[1] = 'new ' prefixexp;
         return VSCODEHELPRC_INVALID_NEW_EXPRESSION;
      }
      ch = substr(prefixexp, pos('S0'), pos('0'));
      prefixexp = substr(prefixexp, p+pos(''));
      match_class = ch;
      if (substr(prefixexp, 1, 1):=='(') {
         prefixexp = substr(prefixexp, 2);
         if (!match_parens(prefixexp, parenexp, num_args)) {
            // this is not good
            //say("return from new 2");
            errorArgs[1] = 'new 'ch' 'prefixexp;
            return VSCODEHELPRC_PARENTHESIS_MISMATCH;
         }
      }
      previous_id = '';
      pointer_count=1;
      break;

   case '[':     // array subscript introduction
      if (!match_brackets(prefixexp, num_args)) {
         // this is not good
         //say("return from [");
         errorArgs[1] = full_prefixexp;
         return VSCODEHELPRC_BRACKETS_MISMATCH;
      }
      if (previous_id != '') {
         current_id = previous_id;
         status = _pas_get_return_type_of(errorArgs, tag_files,
                                        previous_id, match_class, 0,
                                        VS_TAGFILTER_ANYDATA, false,
                                        match_class, pointer_count,
                                        pas_return_flags, match_tag);
         if (status) {
            return status;
         }
         previous_id = '';
      }
      if (pointer_count <= 0) {
            //say("TRYING TO FIND OPERATOR []");
            status = _pas_get_return_type_of(errorArgs,tag_files,
                                           '[]', match_class, 0,
                                           VS_TAGFILTER_ANYPROC,
                                           false, match_class, pointer_count,
                                           pas_return_flags, match_tag);
            if (status) {
               return status;
            }
            previous_id = '';
         if (match_class == '') {
            errorArgs[1] = current_id;
            return (VSCODEHELPRC_SUBSCRIPT_BUT_NOT_ARRAY_TYPE);
         }
         break;
      }
      pointer_count--;
      //say("PREFIX[], pointer_count="pointer_count);
      break;

   case ']':     // array subscript close
      // what do I do here?
      break;

   case '(':     // function call, cast, or expression grouping
      if (!match_parens(prefixexp, cast_type, num_args)) {
         // this is not good
         //say("return from (");
         errorArgs[1] = full_prefixexp;
         return VSCODEHELPRC_PARENTHESIS_MISMATCH;
      }
      if (previous_id != '') {
         //say("GOT HERE 1");
         if (previous_builtin) {
            //say("GOT HERE 2");
            match_class = previous_id;
            pointer_count = 0;
         } else {
            //say("GOT HERE 3, previous_id="previous_id" match_class="match_class" num_args="num_args);
            // this was a function call or new style function pointer
            status = _pas_get_return_type_of(errorArgs,tag_files,previous_id, 
                                           match_class, num_args,
                                           VS_TAGFILTER_ANYPROC|VS_TAGFILTER_ANYDATA, false,
                                           new_match_class, pointer_count,
                                           pas_return_flags, match_tag);
            //say("status="status" pointer_count="pointer_count" match_tag="match_tag);
            if (status && status!=VSCODEHELPRC_NO_SYMBOLS_FOUND) {
               return status;
            }
            // did we find a variable of a function or function pointer?
            boolean is_function=false;
            if (match_tag != '') {
               _str ts='',tr='';
               tag_tree_decompose_tag(match_tag, tn,cn,tt,tf,ts,tr);
               if (tag_tree_type_is_func(tt) || pos('(',tr)) {
                  is_function=true;
               }
            }
            //say("3 new_match_class="new_match_class);
            // could not find match class, maybe this is a function-style cast?
            if (new_match_class == '') {
               //say("GOT HERE 4");
               int num_matches = 0;
               _MatchSymbolInContext(previous_id, match_class, 
                                     num_matches, VSCODEHELP_MAXFINDCONTEXTTAGS, 
                                     VS_TAGFILTER_ANYSTRUCT|VS_TAGFILTER_TYPEDEF, true,
                                     true, false, true, true, true);
               if (num_matches > 0) {
                  //say("_pas_get_type_of_prefix: "previous_id" is a struct or typedef");
                  _str dummy_tag = '';
                  status = _pas_parse_return_type(errorArgs, tag_files, '', '', p_buf_name,
                                                previous_id,
                                                match_class, pointer_count,
                                                pas_return_flags, dummy_tag);
               }
               //say("4 match_class="match_class" status="status" pointer_count="pointer_count);
               if (match_class != '') {
                  pointer_count = 0;
               }
            } else {
               //say("GOT HERE 5");
               match_class = new_match_class;
               previous_id='';
            }
            // maybe they have function call operator
            //say("GOT HERE 6, match_class="match_class)
            if (match_class != '' && !status && !is_function) {
               status = _pas_get_return_type_of(errorArgs,tag_files,'()', 
                                              match_class, num_args,
                                              VS_TAGFILTER_ANYPROC, false,
                                              match_class, pointer_count,
                                              pas_return_flags, match_tag);
               if (status && status != VSCODEHELPRC_BUILTIN_TYPE && 
                   status != VSCODEHELPRC_NO_SYMBOLS_FOUND) {
                  return status;
               }
               //say("8 match_class="match_class" status="status" pointer="pointer_count);
            }
            //say("GOT HERE 10");
            previous_id = '';
         }
      } else {
         //say("cast_type="cast_type" prefixexp="prefixexp);
         // perhaps a function pointer call
         if (pos('^\*{:v|[(]}',cast_type,1,'r') && pos('(',prefixexp)==1) {
            //say("think it's a function pointer");
            cast_type = substr(cast_type, 2);
            status = _pas_get_type_of_prefix(errorArgs, cast_type, match_class,
                                           pointer_count, 
                                           pas_return_flags, match_tag, depth+1);
            if (status) {
               return status;
            }
            //say("PFN: match_class="match_class"prefixexp="prefixexp" cast_type="cast_type);
            prefixexp = substr(prefixexp, 2);
            //say("33333prefixexp="prefixexp);
            if (!match_parens(prefixexp, cast_type, num_args)) {
               // this is not good
               //say("return from (");
               errorArgs[1] = full_prefixexp;
               return VSCODEHELPRC_PARENTHESIS_MISMATCH;
            }
         } else if (pos("([-][>]|[.])[*]", cast_type, 1, 'r') && pos('(',prefixexp)==1) {
            // this is a pointer to member function invocation
            //say("think it's a pointer to member function");
            status = _pas_get_type_of_prefix(errorArgs, cast_type, match_class,
                                           pointer_count,
                                           pas_return_flags, match_tag, depth+1);
            if (status) {
               return status;
            }
            //say("PFMF: match_class="match_class"prefixexp="prefixexp" cast_type="cast_type);
            prefixexp = substr(prefixexp, 2);
            //say("33333prefixexp="prefixexp);
            if (!match_parens(prefixexp, cast_type, num_args)) {
               // this is not good
               //say("return from (");
               errorArgs[1] = full_prefixexp;
               return VSCODEHELPRC_PARENTHESIS_MISMATCH;
            }
         } else if (pos("^[*&(]@:v",prefixexp,1,'r')) {
            // a cast will be followed by an identifier, (, *, or &
            //say("think it's a cast, depth="depth);
            if (depth > 0) {
               _str dummy_tag;
               status = _pas_parse_return_type(errorArgs, tag_files, '', '', p_buf_name,
                                             cast_type,
                                             match_class, pointer_count,
                                             pas_return_flags, dummy_tag);
               //say("CAST: match_class="match_class"prefixexp="prefixexp" cast_type="cast_type);
               return status;
            }
            // otherwise, just ignore the cast
         } else if (!pos('(',cast_type) && pos(',',cast_type)) {
            // this looks like an argument list, check for operator
            // function call.
            status = _pas_get_return_type_of(errorArgs,tag_files,'()', 
                                           match_class, num_args,
                                           VS_TAGFILTER_ANYPROC, false,
                                           match_class, pointer_count,
                                           pas_return_flags, match_tag);
            if (status) {
               return status;
            }
         } else {
            // not a cast, must be an expression, go recursive
            //say("think it's an expression, cast_type="cast_type);
            status = _pas_get_type_of_prefix(errorArgs, cast_type, match_class,
                                           pointer_count,
                                           pas_return_flags, match_tag, depth+1);
            if (status) {
               return status;
            }
            //say("EXPR: match_class="match_class"prefixexp="prefixexp" cast_type="cast_type);
         }
      }
      break;

   case ')':
      // what do I do here?
      errorArgs[1] = full_prefixexp;
      return VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX;

   case 'char':
   case 'short':
   case 'int':
   case 'long':
   case 'signed':
   case 'unsigned':
   case 'float':
   case 'double':
   case 'void':
      previous_id = ch;
      previous_builtin = true;
      break;

   case 'this':
      status = _pas_get_return_type_of(errorArgs, tag_files, ch, '', 0,
                                     VS_TAGFILTER_ANYDATA,
                                     false, match_class, pointer_count,
                                     pas_return_flags, match_tag);
      if (status) {
         return status;
      }
      previous_id = '';
      pointer_count = 1;
      break;

   case '->*':   // pointer to member function
   case '.*':    // binds left-to-right, type of rhs is result
      previous_id = '';
      match_class='';
      break;

   case '*':     // dereference pointer
   case '&':     // get reference to object
         if (ch:=='*') {
            reference_count--;
            break;
         } else if (ch:=='&') {
            reference_count++;
            break;
         }
      // drop through to operator overloading case

   case '=':     // binary operators within expression
   case '-':
   case '+':
   case '/':
   case '%':
   case '^':
   case '<<':
   case '>>':
   case '&&':
   case '|':
   case '||':
   case '<=':
   case '>=':
   case '==':
   case '<':
   case '>':
      if (depth <= 0) {
         errorArgs[1] = full_prefixexp;
         return VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX;
      }
         if (previous_id != '') {
            match_tag = '';
            status = _pas_get_return_type_of(errorArgs, tag_files, 
                                           previous_id, match_class, 0,
                                           VS_TAGFILTER_ANYDATA, true,
                                           match_class, pointer_count,
                                           pas_return_flags, match_tag);
            if (status) {
               return status;
            }
            previous_id = '';
         }
         // check for operator overloading
         if (match_class != '') {
            status = _pas_get_return_type_of(errorArgs, tag_files, ch, match_class, 0,
                                           VS_TAGFILTER_ANYPROC, true,
                                           new_match_class, pointer_count,
                                           pas_return_flags, match_tag);
            if (status && status!=VSCODEHELPRC_NO_SYMBOLS_FOUND) {
               return status;
            }
            if (!status) {
               match_class = new_match_class;
            }
         }
         if (match_class == '') {
            errorArgs[1] = full_prefixexp;
            return VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX;
         }
         prefixexp = '';  // breaks us out of loop
      break;
      // drop through, treat it as a an identifier

   case 'super':
      if (ch:=='super') {
         status = _pas_get_return_type_of(errorArgs, tag_files, 'this', '', 0, 
                                        VS_TAGFILTER_ANYDATA, false, 
                                        match_class, pointer_count,
                                        pas_return_flags, match_tag);
         if (status) {
            return status;
         }
         parents = cb_get_normalized_inheritance(match_class, tag_dbs, tag_files);
         parse parents with match_class ';' parents;
         // add each of them to the list also
         orig_db = tag_current_db();
         while (parents != '') {
            parse parents with p1 ';' parents;
            parse tag_dbs with t1 ';' tag_dbs
            status = tag_read_db(t1);
            if (status) {
               continue;
            }
            // add transitively inherited class members
            tag_split_class_name(p1, match_class, outer_class);
            status = tag_find_tag(match_class, 'class', outer_class);
            if (!status) {
               match_class = p1;
               break;
            }
         }
         previous_id = '';
         break;
      }
      // drop through, treat as a plain identifier

   case 'outer':
      if (ch:=='outer') {
         status = _pas_get_return_type_of(errorArgs, tag_files, 'this', '', 0, 
                                        VS_TAGFILTER_ANYDATA, false,
                                        match_class, pointer_count,
                                        pas_return_flags, match_tag);
         if (status) {
            return status;
         }
         tag_split_class_name(match_class, junk, match_class);
         previous_id = '';
         break;
      }
      // drop through and treat as a plain identifier

   case 'operator':
      if (ch :== 'operator') {
         prefixexp = strip(prefixexp,'L');
         int pp = pos('(',prefixexp,2);
         if (pp > 0) {
            ch = strip(substr(prefixexp,1,pp-1));
            prefixexp = substr(prefixexp,pp+1);
            //say("***prefixexp="prefixexp" ch="ch);
            if (!match_parens(prefixexp, dummy_args, num_args)) {
               // this is not good
               //say("return from (");
               errorArgs[1] = full_prefixexp;
               return VSCODEHELPRC_PARENTHESIS_MISMATCH;
            }
            status = _pas_get_return_type_of(errorArgs, tag_files, ch, 
                                           match_class, num_args,
                                           VS_TAGFILTER_ANYPROC, false,
                                           match_class, pointer_count,
                                           pas_return_flags, match_tag);
            if (status) {
               return status;
            }
            previous_id='';
         } else {
            ch = strip(prefixexp);
            prefixexp='';
         }
         break;
      }
      // drop through, treat it as an identifier

   default:
      // this must be an identifier (or drop-through case)
      match_tag = '';
      previous_id = ch;
      var_filters = VS_TAGFILTER_VAR|VS_TAGFILTER_PROPERTY;
      if (match_class == '') {
         var_filters |= VS_TAGFILTER_LVAR|VS_TAGFILTER_GVAR;
      }
         // search ahead and try to match up package name
         _str package_name = previous_id;
         _str orig_prefix  = prefixexp;
         while (orig_prefix != '') {
            //say("package_name="package_name);
            if (tag_check_for_package(package_name, tag_files, true, true)) {
               match_class = package_name;
               previous_id = '';
               //say("found package "package_name);
               prefixexp = orig_prefix;
            }
            ch = _pas_get_expr_token(orig_prefix);
            //say("prefixexp = "orig_prefix" ch="ch);
            if (ch == '' || ch != '.') {
               break;
            }
            ch = _pas_get_expr_token(orig_prefix);
            //say("prefixexp = "orig_prefix" ch="ch);
            if (ch == '' || !isid_valid(ch)) {
               break;
            }
            package_name = package_name '.' ch;
         }
      break;
   }

   // successful so far, cool.
   //say("_pas_get_type_of_part: success");
   return 0;
}
int _pas_get_type_of_prefix(_str (&errorArgs)[], _str prefixexp,
                            _str &match_class, int &pointer_count, int &pas_return_flags,
                          _str &match_tag, int depth=0)
{
   //say("_pas_get_type_of_prefix("prefixexp")");

   // initiialize return values
   match_class    = '';
   pointer_count  = 0;
   pas_return_flags = 0;

   // loop variables
   typeless tag_files       = tags_filenamea(p_extension);
   _str     full_prefixexp  = prefixexp;
   _str     previous_id     = '';
   int      reference_count = 0;
   boolean  found_define    = false;

   // save the arguments, for retries later
   _str     orig_prefixexp       = prefixexp;
   _str     orig_match_class     = match_class;
   int      orig_pointer_count   = pointer_count;
   int      orig_reference_count = reference_count;
   int      orig_pas_return_flags  = pas_return_flags;
   _str     orig_match_tag       = match_tag;
   _str     orig_previous_id     = previous_id;

   // process the prefix expression, token by token, delegate
   // most of processing to recursive func _pas_get_type_of_part
   while (prefixexp != '') {

      // get next token from expression
      _str ch = _pas_get_expr_token(prefixexp);
      //say("get prefixexp = "prefixexp" ch="ch);
      if (ch == '') {
         // don't recognize something we saw
         errorArgs[1] = full_prefixexp;
         return(VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX);
      }

      // process this part of the prefix expression
      status = _pas_get_type_of_part(errorArgs, tag_files,
                                   previous_id, ch, prefixexp, full_prefixexp,
                                   match_class, pointer_count, reference_count, 
                                   pas_return_flags, match_tag);

      if (status && found_define) {
         //say("FAIL and retry with "orig_previous_id" instead of "previous_id);
         // try the original ID, not what the define said it was
         prefixexp       = orig_prefixexp;
         previous_id     = orig_previous_id;
         match_class     = orig_match_class;
         pointer_count   = orig_pointer_count;
         reference_count = orig_reference_count;
         match_tag       = orig_match_tag;
         status = _pas_get_type_of_part(errorArgs, tag_files,
                                      previous_id, ch, prefixexp, full_prefixexp,
                                      match_class, pointer_count, reference_count, 
                                      pas_return_flags, match_tag);
      }
      if (status) {
         return status;
      }

      // check if 'previous' ID was a define
      found_define = false;
      orig_previous_id = previous_id;
      if (isid_valid(previous_id)) {
         tag_check_for_define(previous_id, p_line, tag_files, previous_id);
         if (previous_id != orig_previous_id) {
            found_define=true;
         }
      }

      // save the arguments, for retries later
      orig_prefixexp       = prefixexp;
      orig_match_class     = match_class;
      orig_pointer_count   = pointer_count;
      orig_reference_count = reference_count;
      orig_pas_return_flags  = pas_return_flags;
      orig_match_tag       = match_tag;
   }

   if (previous_id != '') {
      //say("before previous_id="previous_id" match_class="match_class);
      int var_filters = VS_TAGFILTER_ANYDATA;
         var_filters |= VS_TAGFILTER_ANYPROC;

      status = _pas_get_return_type_of(errorArgs, tag_files, previous_id, match_class, 0,
                                     var_filters, true,
                                     match_class, pointer_count,
                                     pas_return_flags, match_tag);
      if (status && found_define) {
         // try the original ID, not what the define said it was
         prefixexp       = orig_prefixexp;
         match_class     = orig_match_class;
         pointer_count   = orig_pointer_count;
         reference_count = orig_reference_count;
         match_tag       = orig_match_tag;
         previous_id     = orig_previous_id;

         status = _pas_get_return_type_of(errorArgs, tag_files, previous_id, match_class, 0,
                                        var_filters, true,
                                        match_class, pointer_count,
                                        pas_return_flags, match_tag);
      }
      if (status) {
         return status;
      }
      previous_id = '';
      //say("after previous_id="previous_id" match_class="match_class" match_tag="match_tag);
   }
   pointer_count += reference_count;

   //say("_pas_get_type_of_prefix: returns "match_class);
   return 0;
}

/*
   REMARKS:
      caller must check whether text is in a comment
      or string.
      for now, set info_flags to 0.  In the future we could
      have a LASTID_FOLLOWED_BY_PAREN flag and optionally do an
      exact match instead of a prefix match.

   POSSIBLE FUTURE ENHANCEMENTS
      Smart assignments where we check required result type
      Smart function argument where we check required result type
      Smart java throws where we know we need something that derives from exception.

   This function is called when:

     possibly operator typed like -> or ( or .
        return 1 if not valid operator
        return 1 if expression too complex or invalid context

     Identifier just typed (curr char not id) or on identifier

   Example
     PossibleOperator==true
        a[1].b.c.<Here>

           prefixexp="a[].b.c."
           lastid=""
           lastidstart_col=column after last dot
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

        x=A::B::MYCLASS(Noflines);   // C++ ambiguity only. Most common case
           prefixexp="A::B::"
           lastid="MYCLASS"
           lastidstart_col=column is M of MYCLASS
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN

           This could be a function or a converter

        x=A::B::
           prefixexp="A::B::"
           lastid=""
           lastidstart_col=column after last :
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

           This could be a function or a converter

        f(x,y).a[1].b.c.method(<Here>
           return 1 --> expression too complex

           prefixexp="f(x,y).a[1].b.c."
           lastid="method"
           lastidstart_col=column after last dot
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN


        MYCLASS *p=new MYCLASS(<Here>
           prefixexp="new"
           lastid="MYCLASS"
           lastidstart_col=column is M of MYCLASS
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN

(java)   innerclass ic=j.new innerclass().<Here>
           prefixexp="j.new innerclass()."
           lastid=""
           lastidstart_col=column after last dot
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

(java)   innerclass ic=j.new innerclass(<Here>
           prefixexp="j.new"
           lastid="innerclass"
           lastidstart_col=column is 'i' of innerclass
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN

        MYCLASS::MYCLASS(int x,int y):a(x),b(<Here>
           prefixexp=""
           lastid="b"
           lastidstart_col=column is at b
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_IN_INITIALIZER_LIST|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN
           otherinfo="MYCLASS"

           Only list members of MYCLASS and base classes

        MYCLASS():a(<Here>
           prefixexp=""
           lastid="a"
           lastidstart_col=column is at a
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_MAYBE_IN_INITIALIZER_LIST|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN
           otherinfo="MYCLASS"

           We are in an initializer list only if the class
           name in otherinfo matches the context class.

           Only list members of MYCLASS and base classes if
           we are in an initializer list, otherwise treat
           this case like the typical VSAUTOCODEINFO_DO_FUNCTION_HELP
           case.

        MYCLASS method(<Here>

           prefixexp=""
           lastid="method"
           lastidstart_col=column of 'm' character of method
           infoflags=VSAUTOCODEINFO_DO_FUNCTION_HELP|VSAUTOCODEINFO_VAR_OR_PROTOTYPE_DECL|VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN
           otherinfo="MYCLASS"

           This is either a variable definition or a prototype

           Hopefully, it is sufficient to display function help
           for the MYCLASS constructors. It not, the caller could do
           nothing unless  we are in the context of function code.


     PossibleOperator==false

        a[1].b.c.id<Here>

           prefixexp="a[].b.c."
           lastid="id"
           lastidstart_col=column after last dot
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

        a[1].b.c.<here>id

           prefixexp="a[].b.c."
           lastid="id"
           lastidstart_col=column after last dot
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

        <here>

           prefixexp=""
           lastid=""
           lastidstart_col=column same as cursor
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

        a[1].b.c<here>.id

           prefixexp="a[].b."
           lastid="c"
           lastidstart_col=column at c
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS

        f(<here>+id

           prefixexp=""
           lastid=""
           lastidstart_col=column after (
           infoflags=VSAUTOCODEINFO_DO_LIST_MEMBERS


   RETURN
     return 0 if successful
     return 1 if expression too complex
     return 2 if not valid operator


*/
int _pas_get_idexp(_str (&errorArgs)[],
                 boolean PossibleOperator,
                 _str &prefixexp,
                 _str &lastid,int &lastidstart_col,
                 int &lastidstart_offset,
                 int &info_flags,
                 typeless &otherinfo
                )
{
   errorArgs._makeempty();
   otherinfo="";
   info_flags=VSAUTOCODEINFO_DO_LIST_MEMBERS;
   save_pos(orig_pos);
   if (PossibleOperator) {
      left();
      ch=get_text();
      switch (ch) {
      case '.':
         orig_col=p_col;
         if (ch=='.') {
            // Screen out floating point.  1.0 
            if (isdigit(get_text(1,(int)point('s')-1))) {
               // Check if identifier before . is a number
               typeless p2;
               save_pos(p2);
               left();
               search('[~'p_word_chars']\c|^\c','-r@');
               if (isdigit(get_text())) {
                  restore_pos(orig_pos);
                  return(1);
               }
               restore_pos(p2);

            }
            get_line(line);
            if (pos('^[ \t]*\#include',line,1,'r')) {
               // Screen out -->  #include <iostream.h>
               restore_pos(orig_pos);
               return(1);
            }
            right();
         } else if (ch==':') {
            right();
         } else {
            restore_pos(orig_pos);
            return(1);
         }
         // get the id after the dot
         // IF we are on a id character
         if (pos('['p_word_chars']',get_text(),1,'r')) {
            start_col=p_col;start_offset=point('s');
            search('[~'p_word_chars']|$','r@');
            lastid=_expand_tabsc(start_col,p_col-start_col);
            lastidstart_col=start_col;
            lastidstart_offset=start_offset;
         } else {
            lastid="";
            lastidstart_col=p_col;
            lastidstart_offset=(int)point('s');
         }
         p_col=orig_col;
         break;
      case '(':
         info_flags=VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN|VSAUTOCODEINFO_DO_FUNCTION_HELP;
         lastidstart_col=p_col;  // need this for function pointer case
         left();
         _clex_skip_blanks('-');
         if (pos('[~'p_word_chars']',get_text(),1,'r')) {
            restore_pos(orig_pos);
            //say("ID returns 5");
            return(1);
         }
         end_col=p_col+1;
         search('[~'p_word_chars']\c|^\c','-r@');
         lastid=_expand_tabsc(p_col,end_col-p_col);
         lastidstart_col=p_col;
         lastidstart_offset=(int)point('s');
         if (pos(' 'lastid' ',PASCAL_NOT_FUNCTION_WORDS)) {
            restore_pos(orig_pos);
            return(1);
         }
         if(p_col==1) {
            up();_end_line();
         } else {
            left();
         }
         break;
      default:
         restore_pos(orig_pos);
         return(1);
      }
   } else {
      // IF we are not on an id character.
      ch=get_text();
      done=0;
      if (pos('[~'p_word_chars']',ch,1,'r')) {
         left();
         ch=get_text();
         if (ch=='.') {
            lastid='';
            lastidstart_col=p_col+1;
            lastidstart_offset=(int)point('s')+1;
            done=1;
         }
      }
      if (!done) {
         // IF we are not on an id character.
         if (pos('[~'p_word_chars']',get_text(),1,'r')) {
            restore_pos(orig_pos);
            prefixexp='';
            lastid="";
            lastidstart_col=p_col;
            lastidstart_offset=(int)point('s');
            return(0);
         }
         search('[~'p_word_chars']|$','r@');
         end_col=p_col;
         // Check if this is a function call
         search('[~ \t]|$','r@');
         if (get_text()=='(') {
            info_flags|=VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN;
         }
         p_col=end_col;

         left();
         search('[~'p_word_chars']\c|^\c','-r@');
         lastid=_expand_tabsc(p_col,end_col-p_col);
         lastidstart_col=p_col;
         lastidstart_offset=(int)point('s');
         if(p_col==1) {
            up();_end_line();
         } else {
            left();
         }
      }
   }
   prefixexp='';
   gtk=c_prev_sym();
   hit_colon_colon=0;
   if (gtk==TK_ID && gtkinfo=='new') {
      // We have seen  new [a::b::c::]lastid
      gtk=pas_prev_sym();
      if (gtk!='.') {
         prefixexp='new ':+prefixexp;
         restore_pos(orig_pos);
         return(0);
      }
      prefixexp='new ':+prefixexp;
   }
   status=pas_before_id(prefixexp,lastid,lastidstart_col);
   restore_pos(orig_pos);
   return(status);
}

static _str pas_next_sym()
{
   if (p_col>_text_colc()) {
      if(down()) return('');
      _begin_line();
   }
   ch=get_text();
   if (ch=='' || (ch=='/' && _clex_find(0,'g')==CFG_COMMENT)) {
      status=_clex_skip_blanks();
      if (status) {
         gtk=gtkinfo='';
         return(gtk);
      }
      return(pas_next_sym());
   }
   if ((ch=='"' || ch=="'" ) && _clex_find(0,'g')==CFG_STRING) {
      start_col=p_col;
      start_line=p_line;
      status=_clex_find(STRING_CLEXFLAG,'n');
      if (status) {
         _end_line();
      } else if (p_col==1) {
         up();_end_line();
      }
      gtk=TK_STRING;
      gtkinfo=_expand_tabsc(start_col,p_col-start_col+1);
      return(gtk);
   }
   if (pos('['p_word_chars']',ch,1,'r')) {
      start_col=p_col;
      if(_clex_find(0,'g')==CFG_NUMBER) {
         for (;;) {
            if (p_col>_text_colc()) break;
            right();
            if(_clex_find(0,'g')!=CFG_NUMBER) {
               break;
            }
         }
         gtk=TK_NUMBER;
         gtkinfo=_expand_tabsc(start_col,p_col-start_col+1);
         return(gtk);
      }
      search('[~'p_word_chars']|$','@r');
      gtk=TK_ID;
      gtkinfo=_expand_tabsc(start_col,p_col-start_col);
      return(gtk);
   }
   right();
   if (ch=='-' && get_text()=='>') {
      right();
      gtk=gtkinfo='->';
      return(gtk);

   }
   if (ch==':' && get_text()==':') {
      right();
      gtk=gtkinfo='::';
      return(gtk);
   }
   gtk=gtkinfo=ch;
   return(gtk);

}
static _str pas_prev_sym_same_line()
{
   //messageNwait('h0 gtk='gtk);
   if (gtk!='(' && gtk!='::') {
      return(pas_prev_sym());
   }
   // Only force same line for Slick-C and C++
   if (p_extension!="c" && p_extension!='e') {
      return(pas_prev_sym());
   }
   orig_linenum=p_line;
   result=pas_prev_sym();
   //messageNwait('h1 gtkinfo='gtkinfo);
   if (p_line!=orig_linenum && (p_col<=_text_colc() || p_line!=orig_linenum-1) ) {
      //messageNwait('h2');
      gtk=gtkinfo="";
      return(gtk);
   }
   return(result);
}
static _str pas_prev_sym()
{
   ch=get_text();
   if (ch=="\n" || ch=="\r" || ch=='' || (ch=='/' && _clex_find(0,'g')==CFG_COMMENT)) {
      status=_clex_skip_blanks('-');
      if (status) {
         gtk=gtkinfo='';
         return(gtk);
      }
      return(pas_prev_sym());
   }
   if (pos('['p_word_chars']',ch,1,'r')) {
      end_col=p_col+1;
      if(_clex_find(0,'g')==CFG_NUMBER) {
         for (;;) {
            if (p_col==1) break;
            left();
            if(_clex_find(0,'g')!=CFG_NUMBER) {
               right();
               break;
            }
         }
         gtk=TK_NUMBER;
         gtkinfo=_expand_tabsc(p_col,end_col-p_col);
      } else {
         search('[~'p_word_chars']\c|^\c','@r-');
         gtk=TK_ID;
         gtkinfo=_expand_tabsc(p_col,end_col-p_col);
      }
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      return(gtk);
   }
   if (p_col==1) {
      up();_end_line();
      if (_on_line0()) {
         gtk=gtkinfo="";
         return(gtk);
      }
      gtk=gtkinfo=ch;
      if (p_extension=="pl" && ch=="'") {
         gtk=gtkinfo='::';
      }
      return(gtk);
   }
   left();
   if (ch=='>' && get_text()=='-') {
      left();
      gtk=gtkinfo='->';
      return(gtk);

   }
   if (p_extension=="pl" && ch=="'") {
      gtk=gtkinfo='::';
      return(gtk);
   }
   if (ch==':' && get_text()==':') {
      left();
      gtk=gtkinfo='::';
      return(gtk);
   }
   gtk=gtkinfo=ch;
   return(gtk);

}

// context tagging function for pascal, modula, ada, modula-3, oberon
// Still needs some work.
int _pas_insert_context_tags(_str (&errorArgs)[],int editorctl_wid,_str prefixexp,_str lastid,_str lastid_prefix,int lastidstart_offset,_str expected_type,int info_flags,typeless otherinfo)
{
   //say("_pas_insert_context_tags("prefixexp","lastid","lastid_prefix")");
   // id followed by paren, then limit search to functions
   errorArgs._makeempty();
   boolean funcs_only = false;
   if (info_flags & VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN) {
      funcs_only = true;
   }

   // watch out for unwelcome 'new' as prefix expression
   if (strip(prefixexp)=='new') {
      prefixexp='';
   }

   // set up for (possibly) incremental update
   cb_prepare_expand(0, p_window_id, TREE_ROOT_INDEX);
   int status, first_index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);

   // get the current class and current package from the context
   typeless tag_files = tags_filenamea(editorctl_wid.p_extension);
   editorctl_wid._UpdateContext(true);
   editorctl_wid._UpdateLocals(true);
   _str cur_class_name = '';
   _str cur_package_name = '';
   int context_id = editorctl_wid.tag_current_context();
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, cur_type_name);
      tag_get_detail2(VS_TAGDETAIL_context_class, context_id, cur_class_name);
      if (tag_tree_type_is_class(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, class_name);
         //cur_class_name = editorctl_wid._JoinClassWithOuter(class_name, cur_class_name, true, true);
         cur_class_name = tag_join_class_name(class_name, cur_class_name, tag_files, true);
      }
      if (tag_tree_type_is_package(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, cur_package_name);
      } else if (pos(VS_TAGSEPARATOR_package, cur_class_name)) {
         cur_package_name = substr(cur_class_name, 1, pos('S')-1);
      }
   }

   // how many of each category did we find?
   int locals_count  = 0;
   int members_count = 0;
   int classes_count = 0;
   int package_count = 0;
   static _str    package_lastid;
   static _str    classes_lastid;
   static _str    members_lastid;
   static boolean package_truncated;
   static boolean classes_truncated;
   static boolean members_truncated;
   if (first_index <= 0) {
      members_truncated = true;
      classes_truncated = true;
      package_truncated = true;
   }

   // no prefix expression, update globals and members from current context
   if (prefixexp == '') {
      int locals_root  = 0;
      int members_root = 0;
      int classes_root = 0;
      int package_root = 0;

      // first time here, set up categories, otherwise, find them...
      if (first_index <= 0) {
         // FIRST TIME INSERTING ITEMS
         _TreeSetUserInfo(TREE_ROOT_INDEX, 0); // do not search/sort root level
         locals_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals,   TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         members_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         classes_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_classes,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         package_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_packages, TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         int abstract_count = 0;

         // insert locals and 'this' if there is class context
         if (!funcs_only) {
            _str this_class_name = editorctl_wid._MatchThisOrSelf();
            if (this_class_name != '') {
               this_class_name = stranslate(this_class_name, '.', '/');
               this_class_name = stranslate(this_class_name, '.', ':');
               tag_tree_insert_tag(p_window_id,locals_root,0,1,0,'self','var','',0,'',0,this_class_name);
               locals_count++;
            }
         }
         editorctl_wid._CodeHelpListContextLocals(p_window_id,locals_root,tag_files,
                                                  lastid,lastid_prefix,'',
                                                  VS_TAGFILTER_ANYTHING,VS_TAGCONTEXT_ANYTHING,
                                                  locals_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
      } else {
         // INCREMENTAL UPDATE
         locals_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals);
         members_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members);
         classes_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_classes);
         package_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_packages);
         // for non-incremental items, count the actual number of items
         if (locals_root > 0) {
            locals_count = _TreeGetNumChildren(locals_root);
         }
      }

      // update the members in the current context
      if (members_truncated || pos(members_lastid, lastid_prefix)!=1) {
         if (members_root > 0) {
            _TreeBeginUpdate(members_root);
            editorctl_wid._ListMembersInContext(p_window_id, members_root, false, 
                                                funcs_only, false, false, false, false, 
                                                members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            if (_TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members) > 0) {
               if (members_count < VSCODEHELP_MAXLISTMEMBERSSYMBOLS) {
                  editorctl_wid._ListMembersInContext(p_window_id, members_root, false, 
                                                      funcs_only, false, false, false, true, 
                                                      members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
               }
            }
            if (_TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members) > 0) {
               _TreeEndUpdate(members_root);
            }
         }
         members_lastid = lastid_prefix;
         members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;
      }

      // update the classes, make sure that case-sensitive matches get preference
      if (classes_truncated || pos(classes_lastid, lastid_prefix)!=1) {
         if (classes_root > 0) {
            _TreeBeginUpdate(classes_root);
            // java.lang is always imported
            editorctl_wid._ListSymbolsInClass('','java.lang',p_window_id,classes_root,0,classes_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS, VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE,VS_TAGCONTEXT_ACCESS_public, false, true);
            // look for other imports and global classes in this file
            int num_matches = tag_get_num_of_context();
            for (i=1; i<=num_matches; i++) {
               tag_get_detail2(VS_TAGDETAIL_context_class, i, class_name);
               if (class_name == '' || class_name :== cur_package_name) {
                  tag_get_detail2(VS_TAGDETAIL_context_type, i, type_name);
                  if (type_name :== 'class' || type_name :== 'interface') {
                     tag_tree_insert_fast(p_window_id, classes_root, VS_TAGMATCH_context, i, 0, 1, 0, 0, 0);
                  } else if (type_name :== 'import') {
                     tag_get_detail2(VS_TAGDETAIL_context_name, i, proc_name);
                     if (pos('.*', proc_name)) {
                        proc_name = substr(proc_name, 1, pos('S')-1);
                        editorctl_wid._ListSymbolsInClass('',proc_name,p_window_id,classes_root,0,classes_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS, VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE,VS_TAGCONTEXT_ACCESS_public, false, true);
                     } else {
                        proc_name = substr(proc_name, 1+lastpos('.',proc_name));
                        tag_tree_insert_tag(p_window_id, classes_root, 0, 1, 0, proc_name, 'class', '', 0, '', 0, '');
                     }
                  }
               }
            }
            _TreeEndUpdate(classes_root);
         }
         classes_lastid = lastid_prefix;
         classes_truncated = (classes_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      }

      // update the members from current buffer, 
      // give case-sensitive matches preference
      if (package_truncated || pos(package_lastid, lastid_prefix)!=1) {
         if (package_root > 0) {
            _TreeBeginUpdate(package_root);
            // java.lang is always imported
            tag_tree_insert_tag(p_window_id, package_root, 0, 1, 0, 'java.lang', 'package', '', 0, '', 0, '');
            package_count++;
            // list other available classes matching prefix
            if (lastid_prefix == '') {
               editorctl_wid.tag_list_globals_of_type(p_window_id, package_root, tag_files, VS_TAGTYPE_package, 0, 0, package_count, VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            } else {
               editorctl_wid.tag_list_context_packages(p_window_id, package_root, lastid_prefix, tag_files, package_count, VSCODEHELP_MAXLISTGLOBALSYMBOLS, false, true);
            }
            // list explicitely imported packages and current package
            int num_matches = tag_get_num_of_context();
            for (i=1; i<=num_matches; i++) {
               tag_get_detail2(VS_TAGDETAIL_context_type, i, type_name);
               if (tag_tree_type_is_package(type_name)) {
                  tag_tree_insert_fast(p_window_id, package_root, VS_TAGMATCH_context, i, 0, 1, 0, 0, 0);
               } else if (type_name :== 'import') {
                  tag_get_detail2(VS_TAGDETAIL_context_name, i, proc_name);
                  tag_tree_insert_tag(p_window_id, package_root, 0, 1, 0, proc_name, 'import', '', 0, '', 0, '');
               }
            }
            _TreeEndUpdate(package_root);
         }
         package_lastid = lastid_prefix;
         package_truncated = (package_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      }

      // all done
      errorArgs[1] = lastid;
      int total_count = locals_count+members_count+classes_count+package_count;
      return (total_count>0)? 0 : VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }

   // prefix expression is not null, so no categories, just list memebers
   if (!members_truncated && pos(members_lastid, lastid_prefix)==1) {
      return 0;
   }
   _TreeSetUserInfo(TREE_ROOT_INDEX, 1);
   _TreeBeginUpdate(TREE_ROOT_INDEX);

   // maybe prefix expression is a package name or prefix of package name
   if (pos("^[$_a-zA-Z0-9.]@$", prefixexp, 1, 'r') &&
      tag_check_for_package(prefixexp:+lastid, tag_files, false, true)) {
      //say("got here");
      editorctl_wid.tag_list_context_packages(p_window_id,TREE_ROOT_INDEX,prefixexp,tag_files,members_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS,false,true);
      _TreeSortCaption(TREE_ROOT_INDEX, 'u');
      members_count = 0;
      int index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
      int start = length(prefixexp)+1;
      while (index > 0) {
         _str caption = _TreeGetCaption(index);
         //say("raw caption="caption);
         if (pos(prefixexp, caption)!=1) {
            next_index = _TreeGetNextSiblingIndex(index);
            _TreeDelete(index);
            index = next_index;
            continue;
         }
         caption = substr(caption, start);
         _TreeSetCaption(index, caption);
         //say("trimmed caption="caption);
         index = _TreeGetNextSiblingIndex(index);
         members_count++;
      }
   }

   if (prefixexp != '') {
      _str dummy_tag = '';
      status = editorctl_wid._pas_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                                     pointer_count,
                                                     pas_return_flags, dummy_tag);
      if (status && members_count==0) {
         return status;
      }
   } else {
      status = 0;
   }
   if (!status) {
      int context_flags = VS_TAGCONTEXT_ONLY_inclass;
      if (pos(cur_package_name'/',match_class)) {
         context_flags |= VS_TAGCONTEXT_ALLOW_package;
      }
      //if (pas_return_flags & VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS) {
      //   context_flags |= VS_TAGCONTEXT_ACCESS_private;
      //}
      //if (pas_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY) {
      //   context_flags |= VS_TAGCONTEXT_ONLY_const;
      //}
      //if (pas_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY) {
      //   context_flags |= VS_TAGCONTEXT_ONLY_volatile;
      //}
      //if (pas_return_flags & VSCODEHELP_RETURN_TYPE_STATIC_ONLY) {
      //   context_flags |= VS_TAGCONTEXT_ONLY_static;
      //}
      editorctl_wid._ListSymbolsInClass('' /*lastid*/, match_class,
                                        p_window_id, TREE_ROOT_INDEX, 0,
                                        members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                        VS_TAGFILTER_ANYTHING, context_flags,
                                        false, false);
   }
   _TreeEndUpdate(TREE_ROOT_INDEX);
   members_lastid = lastid_prefix;
   members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;

   // Return 0 indicating success if anything was found
   errorArgs[1] = (lastid!='')? lastid : prefixexp;
   return (members_count == 0)? VSCODEHELPRC_NO_SYMBOLS_FOUND:0;
}

int _pas_find_context_tags(_str (&errorArgs)[],_str prefixexp,_str lastid,int lastidstart_offset,int info_flags,typeless otherinfo,boolean find_parents,boolean case_sensitive)
{
   //say("_pas_find_context_tags("prefixexp","lastid")");
   errorArgs._makeempty();

   //say "_pas_find_context_tags"
   int num_matches=0;
   _str match_class='';
   _str dummy_tag='';
   int pas_return_flags = 0;
   int pointer_count = 0;
   if (prefixexp!='') {
      int status = _pas_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                           pointer_count, pas_return_flags, dummy_tag);
      //say("match_class="match_class" status="status);
      if (status) {
         return status;
      }
   }

   // try to match the symbol in the current context
   tag_clear_matches();
   _MatchSymbolInContext(lastid, match_class,
                         num_matches, VSCODEHELP_MAXFINDCONTEXTTAGS,
                         VS_TAGFILTER_ANYTHING, true,
                         !(pas_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY), 
                         find_parents, false, true, true);
   // try case insensitive match
   if (num_matches == 0 && !case_sensitive) {
      _MatchSymbolInContext(lastid, match_class,
                            num_matches, VSCODEHELP_MAXFINDCONTEXTTAGS,
                            VS_TAGFILTER_ANYTHING, true,
                            !(pas_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY), 
                            find_parents, false, true, false);
   }

   // Return 0 indicating success if anything was found
   errorArgs[1] = lastid;
   return (num_matches == 0)? VSCODEHELPRC_NO_SYMBOLS_FOUND:0;
}

/*
   PARAMETERS
      OperatorTyped     When true, user has just typed last character of operator.
                        Example
                             p-><Cursor Here>
                        This should be false if cursorInsideArgumentList
                        is true.
      cursorInsideArgumentList
                        When true, user requested function help when
                        the cursor was inside an argument list.

                        Example
                          MessageBox(...,<Cursor Here>...)

                        Here we give help on MessageBox
      FunctionNameOffset  OUTPUT. Offset to start of function name.

      ArgumentStartOffset OUTPUT. Offset to start of first argument

  RETURN CODES
      0    Successful
      VSCODEHELPRC_CONTEXT_NOT_VALID
      VSCODEHELPRC_NOT_IN_ARGUMENT_LIST
      VSCODEHELPRC_NO_HELP_FOR_FUNCTION
*/
int _pas_fcthelp_get_start(_str (&errorArgs)[],
                            boolean OperatorTyped,
                            boolean cursorInsideArgumentList,
                            int &FunctionNameOffset,
                            int &ArgumentStartOffset,
                            int &flags
                           )
{
   errorArgs._makeempty();
   //say("_c_fcthelp_get_start");
   flags=0;
   //if (cursorInsideArgumentList || OperatorTyped)
   save_pos(orig_pos);
   orig_seek=point('s');
   int first_less_than_seek=0;
   {
         if (!ginFunctionHelp && cursorInsideArgumentList) {
            status=search('[;}{()<]','-r@xcs');
            if (!status) {
               ch=get_text();
               if (ch=='<') {
                  first_less_than_seek=(int)point('s');
                  left();
                  if (get_text()!='<') { // Have << or < at beginning of line
                     _clex_skip_blanks('-');
                     status=_pas_get_idexp(junk,false,junk_prefixexp,junk_lastid,junk_lastidstart_col,junk_lastidstart_offset,junk_info_flags,junk_otherinfo);
                  }
               }
            }
            restore_pos(orig_pos);
         }
#if 0
      ch=get_text();
      if (ch==')' ||
          (OperatorTyped && (ch=='(' || ch==';' || ch=='{'))) {
         if(p_col==1){up();_end_line();} else {left();}
      }
#endif
      orig_col=p_col;orig_line=p_line;
      status=search('[;}{()]','-r@xcs');
      if (!status && p_line==orig_line && p_col==orig_col) {
         status=repeat_search();
      }
      ArgumentStartOffset= -1;
      for (;;) {
         if (status) {
            //say('break '_nrseek());
            break;
         }
         ch=get_text();
         //say("CCH="ch);
         if (ch=='(') {
            save_pos(p);
            if(p_col==1){up();_end_line();} else {left();}
            save_search(p1,p2,p3,p4);
            _clex_skip_blanks('-');
            restore_search(p1,p2,p3,p4);
            ch=get_text();
            word=cur_word(junk);
            restore_pos(p);
            if (pos('['p_word_chars']',ch,1,'r')) {
                  if (pos(' 'word' ',PASCAL_NOT_FUNCTION_WORDS)) {
                     if (OperatorTyped && ArgumentStartOffset== -1) {
                        return(VSCODEHELPRC_CONTEXT_NOT_VALID);
                     }
                     break;
                  }

               ArgumentStartOffset=(int)point('s')+1;
            } else {
               /*
                  OperatorTyped==TRUE
                      Avoid give help when have
                      myproc(....4+( <CursorHere>

               */
               if (OperatorTyped && ArgumentStartOffset== -1 &&
                   ch!=')' &&   // (*pfn)(a,b,c)  OR  f(x)(a,b,c)
                   ch!=']'      // calltab[a](a,b,c)
                  ){
                  return(VSCODEHELPRC_CONTEXT_NOT_VALID);
               }
               if (ch==')' || ch==']') {
                  ArgumentStartOffset=(int)point('s')+1;
               }
            }
         } else if (ch==')') {
            status=find_matching_paren();
            if (status) {
               restore_pos(orig_pos);
               return(1);
            }
            save_pos(p);
            if(p_col==1){up();_end_line();} else {left();}
            save_search(p1,p2,p3,p4);
            _clex_skip_blanks('-');
            restore_search(p1,p2,p3,p4);
            word=cur_word(junk);
            if (pos(' 'word' ',' if while catch switch ')) {
               break;
            }
            restore_pos(p);
         } else  {
            break;
         }
         status=repeat_search();
      }
      if (ArgumentStartOffset<0) {
      } else {
         goto_point(ArgumentStartOffset);
      }
      right();
   }
   ArgumentStartOffset=(int)point('s');
   left();
   return(0);
   return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
}

/*
   PARAMETERS
      FunctionHelp_list    (Input/Ouput)
                           Structure is initially empty.
                              FunctionHelp_list._isempty()==true
                           You may set argument lengths to 0.
                           See VSAUTOCODE_ARG_INFO structure in slick.sh.
      FunctionHelp_list_changed   (Output) Indicates whether the data in
                                  FunctionHelp_list has been changed.
                                  Also indicates whether current
                                  parameter being edited has changed.
      FunctionHelp_cursor_x  (Output) Indicates the cursor x
                             position in pixels relative to the
                             edit window where to display the
                             argument help.

      FunctionNameStartOffset,ArgumentEndOffset
                              (INPUT) The text between these two
                              end points needs to be parsed
                              to determine the new argument
                              help.
   RETURN
     Returns 0 if we want to continue with function argument
     help.  Otherwise a non-zero value is returned and a
     message is usually displayed.

   REMARKS
     If there is no help for the first function, a non-zero value
     is returned and message is usually displayed.

     If the end of the statement is found, a non-zero value is
     returned.  This happens when a user to the closing brace
     to the outer most function caller or does some weird
     paste of statements.

     If there is no help for a function and it is not the first
     function, FunctionHelp_list is filled in with a message
         FunctionHelp_list._makeempty();
         FunctionHelp_list[0].proctype=message;
         FunctionHelp_list[0].argstart[0]=1;
         FunctionHelp_list[0].arglength[0]=0;

  RETURN CODES
     1   Not a valid context
     (not implemented yet)
     10   Context expression too complex
     11   No help found for current function
     12   Unable to evaluate context expression
*/
static _str gLastContext_FunctionName;
static int gLastContext_FunctionOffset;
int _pas_fcthelp_get(_str (&errorArgs)[],
                   VSAUTOCODE_ARG_INFO (&FunctionHelp_list)[],
                   boolean &FunctionHelp_list_changed,
                   int &FunctionHelp_cursor_x,
                   _str &FunctionHelp_HelpWord,
                   int FunctionNameStartOffset,
                   int flags
                   )
{
   errorArgs._makeempty();
   //say("_pas_fcthelp_get");
   // avoid recalculating the expression when we don't have to
   static _str prev_prefixexp;
   static _str prev_otherinfo;
   static int  prev_info_flags;
   static int  prev_ParamNum;

   FunctionHelp_list_changed=0;
   if(FunctionHelp_list._isempty()) {
      FunctionHelp_list_changed=1;
      gLastContext_FunctionName="";
      gLastContext_FunctionOffset=-1;
   }
   common='[,{};()]|'PASCAL_COMMON_END_OF_STATEMENT_RE;
   cursor_offset=point('s');
   save_pos(p);
   orig_left_edge=p_left_edge;
   goto_point(FunctionNameStartOffset);
   // enum, struct class
   status=search(common,'r@xcs');
   //boolean found_function_pointer=false;
   int preprocessing_top=0;
   int preprocessing_ParamNum_stack[];
   int preprocessing_offset_stack[];
   int ParamNum_stack[];
   int offset_stack[];  // offset of this function open parenthesis
   int stack_top=0;
   ParamNum_stack[stack_top]=0;
   nesting=0;
   for (;;) {
      if (status) {
         break;
      }
      ch=get_text();
      //say('ch='ch);
      //say('cursor_offset='cursor_offset' p='point('s'));
      if (cursor_offset<=point('s')) {
         break;
      }
      if (ch==',') {
         ++ParamNum_stack[stack_top];
         status=repeat_search();
         continue;
      }
      if (ch==')') {
         --stack_top;
         if (stack_top<=0 /*&& (!found_function_pointer && stack_top<0)*/) {
            // The close paren has been entered for the outer most function
            // We are done.
            restore_pos(p);
            return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
         }
         //found_function_pointer = false;
         status=repeat_search();
         continue;
      }
      if (ch=='>') {
         --stack_top;
         if (stack_top<=0) {
            // The close paren has been entered for the outer most function
            // We are done.
            restore_pos(p);
            return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
         }
         status=repeat_search();
         continue;
      }
      if (ch=='(') {
         // Determine if this is a new function
         ++stack_top;
         ParamNum_stack[stack_top]=1;
         offset_stack[stack_top]=(int)point('s');
         /*if (get_text(2)=='(*') {
            found_function_pointer = true;
         } */
         status=repeat_search();
         continue;
      }
      if (ch=='<') {
         // Determine if this is a new function
         ++stack_top;
         ParamNum_stack[stack_top]=1;
         offset_stack[stack_top]=(int)point('s');
         status=repeat_search();
         continue;
      }
      if (ch=='}' || ch==';') {
         restore_pos(p);
         return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
      }
      if (ch=='#' || ch=='{' || (pos('[~'p_word_chars']',get_text(1,match_length('s')-1),1,'r') &&
                                 pos('[~'p_word_chars']',get_text(1,match_length('s')+match_length()),1,'r'))
          ) {
         // IF this could be enum, struct, or class
         if (stack_top>1 && (ch=='e' || ch=='s' || ch=='c')) {
            word=cur_word(junk);
            if (word=='enum' || word=='struct' || word=='class') {
               status=repeat_search();
               continue;
            }
         }
         restore_pos(p);
         return(VSCODEHELPRC_NOT_IN_ARGUMENT_LIST);
      }
      status=repeat_search();
   }
   typeless tag_files = tags_filenamea(p_extension);
   lastid="";
   for (;;--stack_top) {
      if (stack_top<=0) {
         restore_pos(p);
         return(VSCODEHELPRC_NO_HELP_FOR_FUNCTION);
      }
      goto_point(offset_stack[stack_top]+1);
      status=_pas_get_idexp(junk,true,prefixexp,lastid,lastidstart_col,lastidstart_offset,info_flags,otherinfo);
      errorArgs[1] = lastid;

      if (_chdebug) {
         say('prefixexp='prefixexp' lastid='lastid' lastidstart_col='lastidstart_col' info_flags='dec2hex(info_flags)' otherinfo='otherinfo' status='status);
      }
      if (!status) {
         // get parameter number and cursor position
         ParamNum=ParamNum_stack[stack_top];
         set_scroll_pos(orig_left_edge,p_col);

         // check if anything has changed
         if (prev_prefixexp :== prefixexp &&
            gLastContext_FunctionName :== lastid &&
            gLastContext_FunctionOffset :== lastidstart_col &&
            prev_otherinfo :== otherinfo &&
            prev_info_flags == info_flags &&
            prev_ParamNum   == ParamNum) {
            FunctionHelp_cursor_x=(lastidstart_col-p_col)*p_font_width+p_cursor_x;
            break;
         }

         // find matching symbols
         //say('lastid='lastid' prefixexp='prefixexp' ParamNum='ParamNum' otherinfo='otherinfo);
         int tag_flags=0;
         boolean globals_only=false;
         _str signature='';
         _str return_type='';
         _str match_list[];
         _str match_symbol = lastid;
         _str match_class="";
         _str match_tag = "";
         int  match_flags = VS_TAGFILTER_ANYPROC;

         // find symbols matching the given class
         int num_matches = 0;
         tag_clear_matches();
         // this may be a variable MYCLASS a(
         if (info_flags & VSAUTOCODEINFO_VAR_OR_PROTOTYPE_DECL) {
            otherinfo    = stranslate(otherinfo,':','::');
            tag_split_class_name(otherinfo, match_symbol, match_class);
            cmatch_class = tag_join_class_name(match_symbol, match_class, tag_files, true);
            //say("111 match_symbol="match_symbol" match_class="cmatch_class);
            tag_clear_matches();
            _ListSymbolsInClass(match_symbol, cmatch_class, 0, 0, 0,
                                num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                VS_TAGFILTER_ANYPROC,
                                VS_TAGCONTEXT_ANYTHING|VS_TAGCONTEXT_ALLOW_locals|VS_TAGCONTEXT_ONLY_inclass,
                                true, true);
            if (num_matches <= 0) {
               match_symbol = lastid;
            }
         }

         // initializer list of constructor MYCLASS::MYCLASS() : BASECLASS(<here>
         if (info_flags & (VSAUTOCODEINFO_IN_INITIALIZER_LIST|VSAUTOCODEINFO_MAYBE_IN_INITIALIZER_LIST)) {
            otherinfo    = stranslate(otherinfo,':','::');
            tag_split_class_name(otherinfo,junk,match_class);
            if (match_class == '') {
               match_class = otherinfo;
            }
            match_symbol = lastid;
            //say("match_symbol="match_symbol" match_class="match_class);
            tag_clear_matches();
            _ListSymbolsInClass(match_symbol, match_class, 0, 0, 0,
                                num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                VS_TAGFILTER_ANYPROC/*|VS_TAGFILTER_ANYSTRUCT*/,
                                VS_TAGCONTEXT_ANYTHING|VS_TAGCONTEXT_ALLOW_locals|VS_TAGCONTEXT_ONLY_inclass,
                                true, true);
            //say("num_matches="num_matches" here 2");
         }

         // analyse prefix epxression to determine effective class
         if (num_matches == 0) {
            //say("xxx prefixexp="prefixexp" match_symbol="match_symbol);
            if (pos('new ',prefixexp) == 1) {
               // handle 'new' expressions as a special case
               _str outer_class = substr(prefixexp, 5);
               if (last_char(outer_class)==':') {
                  outer_class = substr(outer_class, 1, length(outer_class)-2);
               }
               outer_class = stranslate(outer_class, ':', '::');
               //say("match_symbol="match_symbol" outer_class="outer_class);
               match_class = tag_join_class_name(match_symbol, outer_class, tag_files, true);
               //say("match_class = "match_class);
               pointer_count = 1;
               status = 0;
            } else if (prefixexp != '') {
               int pointer_count=0;
               int pas_return_flags=0;
               status = _pas_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                              pointer_count,pas_return_flags, match_tag);
               //say("_pas_get_type_of_prefix returns "match_class" status="status" match_tag="match_tag);
               if (status && (status!=VSCODEHELPRC_BUILTIN_TYPE || lastid!='')) {
                  restore_pos(p);
                  return status;
               }
               if (pas_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY) {
                  globals_only = true;
               }
            }
            tag_clear_matches();
            // try to find 'lastid' as a member of the 'match_class'
            // within the current context
            //say("_pas_fcthelp_get: 0, match_flags="match_flags);
            if (lastid != '') {
               _MatchSymbolInContext(match_symbol, match_class,
                                     num_matches, VSCODEHELP_MAXFUNCTIONHELPPROTOS,
                                     match_flags, true, !globals_only, 
                                     false, false, true, true);
            }
            //say("aa num_matches="num_matches);
            if (lastid == '' && match_tag != '') {
               _str tr='', ts='';
               tag_tree_decompose_tag(match_tag, tn,tc,tt,tf,ts,tr);
               tag_clear_matches();
               tag_insert_match('',tn,tt,'',0,tc,tf,tr:+VS_TAGSEPARATOR_args:+ts);
               num_matches = 1;
               //say("tn="tn" tc="tc" tt="tt" tf="tf" ts="ts);
               if (match_class!='' && !pos('(',tr)) {
                  int pointer_count=0;
                  int pas_return_flags=0;
                  status = _pas_get_return_type_of(errorArgs,tag_files,'()',match_class,
                                                 0,VS_TAGFILTER_ANYPROC,
                                                 false,match_class,pointer_count,
                                                 pas_return_flags, match_tag);
                  if (!status) {
                     tag_tree_decompose_tag(match_tag, tn,tc,tt,tf,ts,tr);
                     tag_clear_matches();
                     tag_insert_match('',tn,tt,'',0,tc,tf,tr:+VS_TAGSEPARATOR_args:+ts);
                  }
               }
            }
         } else {
            lastid = match_symbol;
         }

         //say("_pas_fcthelp_get: num_matches="tag_get_num_of_matches());
         

         // simplify the list, we don't care where the symbols came from
         int i,j,k;
         boolean last_is_duplicate = false;
         for (i=1,j=0; i<=num_matches; i++) {
            tag_get_match(i,tag_file,proc_name,type_name,file_name,line_no,class_name,tag_flags,signature,return_type);
            //say("HERE proc_name="proc_name" class_name="class_name" type_name="type_name);
            match_tag_name = (lastid!='')? lastid:proc_name;
            if (tag_flags & VS_TAGFLAG_operator) {
               match_tag_name = "operator "proc_name;
            }
            // don't permit match on current line
            if (file_eq(file_name,p_buf_name) && line_no :== p_line && num_matches>1) {
               continue;
            }
            if (type_name :== 'define') {
               if (signature == '') {
                  continue;
               }
               return_type = '';
            } else if (tag_tree_type_is_class(type_name)) {
               continue;
            } else if (tag_tree_type_is_func(type_name)) {
               if (type_name=='proc' || type_name=='procproto') {
                  signature = '';
               }
               if (class_name != '') {
                  match_tag_name = class_name '.' match_tag_name;
               }
               int found_duplicate = 0;
               _str dup_type_name   = '';
               for (k=i+1; k<=num_matches; k++) {
                  tag_get_detail2(VS_TAGDETAIL_match_type,k,k_type_name);
                  tag_get_detail2(VS_TAGDETAIL_match_args,k,k_signature);
                  if (tag_tree_type_is_func(k_type_name)) {
                     if (!tag_tree_compare_args(signature, k_signature, false)) {
                        //say("found duplicate="k);
                        found_duplicate = k;
                        if (dup_type_name == '' || dup_type_name :!= 'proto') {
                           //say("found duplicate type="k_type_name);
                           dup_type_name   = k_type_name;
                        }
                     }
                  }
               }
               if (i==num_matches && last_is_duplicate && j>0) {
                  found_duplicate = 1;
               }
               //say("dup_type_name="dup_type_name" type_name="type_name" found_dup="found_duplicate" last_dup="last_is_duplicate);
               if (found_duplicate == num_matches) {
                  last_is_duplicate = true;
               }
               if (found_duplicate && (dup_type_name:=='proto' || type_name:!='proto' || dup_type_name :== type_name)) {
                  //say("skipping duplicate");
                  continue;
               }
            } else if ((!pos('(',return_type)) || 
                       (!pos('var',type_name) && type_name!='typedef')) {
               continue;
            }
            match_list[j] = match_tag_name "\t" signature "\t" return_type;
            j++;
         }

         // get rid of any duplicate entries
         match_list._sort();
         _aremove_duplicates(match_list, false);

         // translate functions into struct needed by function help
         boolean have_matching_params = false;
         if (match_list._length()>0) {
            FunctionHelp_list._makeempty();
            FunctionHelp_HelpWord = match_symbol;

            //say("FunctionHelp_cursor_x="FunctionHelp_cursor_x" lastid="lastid);
            for (i=0; i<match_list._length(); i++) {
               k = FunctionHelp_list._length();
               if (k >= VSCODEHELP_MAXFUNCTIONHELPPROTOS) break;
               parse match_list[i] with match_tag_name "\t" signature "\t" return_type;
               //say("tag="match_tag_name" sig="signature" ret="return_type);
               FunctionHelp_list[k].prototype = return_type' 'match_tag_name'('signature')';
               int base_length = length(return_type) + length(match_tag_name) + 2;
               FunctionHelp_list[k].argstart[0]=length(return_type)+1;
               FunctionHelp_list[k].arglength[0]=length(match_tag_name);
               FunctionHelp_list[k].ParamNum=ParamNum;
               FunctionHelp_list[k].ParamType='';
               //++base_length;

               // parse signature and map out argument ranges
               int  arg_pos  = 0;
               _str argument = cb_next_arg(signature, arg_pos, 1);
               while (argument != '') {
                  //say("argument="argument);
                  j = FunctionHelp_list[k].argstart._length();
                  FunctionHelp_list[k].argstart[j]=base_length+arg_pos;
                  FunctionHelp_list[k].arglength[j]=length(argument);
                  if (j == ParamNum) {
                     // parse out the return type of the current parameter
                     _str psextn = p_extension;
                     int psindex = find_index(psextn'_proc_search',PROC_TYPE);
                     int orig_view_id=_create_temp_view(temp_view_id);
                     _insert_text(argument';');
                     top();
                     if (index_callable(psindex)) {
                        pvarname='';
                        status=call_index(pvarname,1,psextn,psindex);
                        if (!status) {
                           ds=param_type='';
                           tag_tree_decompose_tag(pvarname,dt,dc,dy,tf,ds,param_type);
                           FunctionHelp_list[k].ParamType=param_type;
                        }
                     }
                     _delete_temp_view(temp_view_id);
                     p_view_id = orig_view_id;
                  }
                  argument = cb_next_arg(signature, arg_pos, 0);
               }
               if (ParamNum != 1 && j < ParamNum) {
                  if (have_matching_params) {
                     FunctionHelp_list._deleteel(k);
                  }
               } else {
                  if (!have_matching_params) {
                     VSAUTOCODE_ARG_INFO func_arg_info = FunctionHelp_list[k];
                     FunctionHelp_list._makeempty();
                     FunctionHelp_list[0] = func_arg_info;
                  }
                  have_matching_params = true;
               }
            }
            // Found some matches?
            if (FunctionHelp_list._length() > 0) {
               if (prev_ParamNum!=ParamNum) {
                  FunctionHelp_list_changed=1;
               }
               prev_prefixexp  = prefixexp;
               prev_otherinfo  = otherinfo;
               prev_info_flags = info_flags;
               prev_ParamNum   = ParamNum;
               FunctionHelp_cursor_x=(lastidstart_col-p_col)*p_font_width+p_cursor_x;
               break;
            }
         }
      }
   }
   if (lastid!=gLastContext_FunctionName || gLastContext_FunctionOffset!=lastidstart_offset) {
      FunctionHelp_list_changed=1;
      gLastContext_FunctionName=lastid;
      gLastContext_FunctionOffset=lastidstart_offset;
   }
   restore_pos(p);
   return(0);
}

#endif

// context tagging function for pascal, modula, ada, modula-3, oberon
// Still needs some work.
int _pas_insert_context_tags(_str (&errorArgs)[],int editorctl_wid,_str prefixexp,_str lastid,_str lastid_prefix,int lastidstart_offset,_str expected_type,int info_flags,typeless otherinfo)
{
   //say("_pas_insert_context_tags("prefixexp","lastid","lastid_prefix")");
   // id followed by paren, then limit search to functions
   errorArgs._makeempty();
   boolean funcs_only = false;
   if (info_flags & VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN) {
      funcs_only = true;
   }

   // watch out for unwelcome 'new' as prefix expression
   if (strip(prefixexp)=='new') {
      prefixexp='';
   }

   // set up for (possibly) incremental update
   cb_prepare_expand(0, p_window_id, TREE_ROOT_INDEX);
   int status, first_index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);

   // get the current class and current package from the context
   typeless tag_files = tags_filenamea(editorctl_wid.p_extension);
   editorctl_wid._UpdateContext(true);
   editorctl_wid._UpdateLocals(true);
   _str cur_class_name = '';
   _str cur_package_name = '';
   int context_id = editorctl_wid.tag_current_context();
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, cur_type_name);
      tag_get_detail2(VS_TAGDETAIL_context_class, context_id, cur_class_name);
      if (tag_tree_type_is_class(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, class_name);
         //cur_class_name = editorctl_wid._JoinClassWithOuter(class_name, cur_class_name, true, true);
         cur_class_name = tag_join_class_name(class_name, cur_class_name, tag_files, true);
      }
      if (tag_tree_type_is_package(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, cur_package_name);
      } else if (pos(VS_TAGSEPARATOR_package, cur_class_name)) {
         cur_package_name = substr(cur_class_name, 1, pos('S')-1);
      }
   }

   // how many of each category did we find?
   int locals_count  = 0;
   int members_count = 0;
   int classes_count = 0;
   int package_count = 0;
   static _str    package_lastid;
   static _str    classes_lastid;
   static _str    members_lastid;
   static boolean package_truncated;
   static boolean classes_truncated;
   static boolean members_truncated;
   if (first_index <= 0) {
      members_truncated = true;
      classes_truncated = true;
      package_truncated = true;
   }

   // no prefix expression, update globals and members from current context
   if (prefixexp == '') {
      int locals_root  = 0;
      int members_root = 0;
      int classes_root = 0;
      int package_root = 0;

      // first time here, set up categories, otherwise, find them...
      if (first_index <= 0) {
         // FIRST TIME INSERTING ITEMS
         _TreeSetUserInfo(TREE_ROOT_INDEX, 0); // do not search/sort root level
         locals_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals,   TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         members_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         classes_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_classes,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         package_root = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_packages, TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         int abstract_count = 0;

         // insert locals and 'this' if there is class context
         if (!funcs_only) {
            _str this_class_name = editorctl_wid._MatchThisOrSelf();
            if (this_class_name != '') {
               this_class_name = stranslate(this_class_name, '.', '/');
               this_class_name = stranslate(this_class_name, '.', ':');
               tag_tree_insert_tag(p_window_id,locals_root,0,1,0,'self','var','',0,'',0,this_class_name);
               locals_count++;
            }
         }
         editorctl_wid._CodeHelpListContextLocals(p_window_id,locals_root,tag_files,
                                                  lastid,lastid_prefix,'',
                                                  VS_TAGFILTER_ANYTHING,VS_TAGCONTEXT_ANYTHING,
                                                  locals_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
      } else {
         // INCREMENTAL UPDATE
         locals_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals);
         members_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members);
         classes_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_classes);
         package_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_packages);
         // for non-incremental items, count the actual number of items
         if (locals_root > 0) {
            locals_count = _TreeGetNumChildren(locals_root);
         }
      }

      // update the members in the current context
      if (members_truncated || pos(members_lastid, lastid_prefix)!=1) {
         if (members_root > 0) {
            _TreeBeginUpdate(members_root);
            editorctl_wid._ListMembersInContext(p_window_id, members_root, false, 
                                                funcs_only, false, false, false, false, 
                                                members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            if (_TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members) > 0) {
               if (members_count < VSCODEHELP_MAXLISTMEMBERSSYMBOLS) {
                  editorctl_wid._ListMembersInContext(p_window_id, members_root, false, 
                                                      funcs_only, false, false, false, true, 
                                                      members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
               }
            }
            if (_TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members) > 0) {
               _TreeEndUpdate(members_root);
            }
         }
         members_lastid = lastid_prefix;
         members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;
      }

      // update the classes, make sure that case-sensitive matches get preference
      if (classes_truncated || pos(classes_lastid, lastid_prefix)!=1) {
         if (classes_root > 0) {
            _TreeBeginUpdate(classes_root);
            // java.lang is always imported
            editorctl_wid._ListSymbolsInClass('','java.lang',p_window_id,classes_root,0,classes_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS, VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE,VS_TAGCONTEXT_ACCESS_public, false, true);
            // look for other imports and global classes in this file
            int num_matches = tag_get_num_of_context();
            for (i=1; i<=num_matches; i++) {
               tag_get_detail2(VS_TAGDETAIL_context_class, i, class_name);
               if (class_name == '' || class_name :== cur_package_name) {
                  tag_get_detail2(VS_TAGDETAIL_context_type, i, type_name);
                  if (type_name :== 'class' || type_name :== 'interface') {
                     tag_tree_insert_fast(p_window_id, classes_root, VS_TAGMATCH_context, i, 0, 1, 0, 0, 0);
                  } else if (type_name :== 'import') {
                     tag_get_detail2(VS_TAGDETAIL_context_name, i, proc_name);
                     if (pos('.*', proc_name)) {
                        proc_name = substr(proc_name, 1, pos('S')-1);
                        editorctl_wid._ListSymbolsInClass('',proc_name,p_window_id,classes_root,0,classes_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS, VS_TAGFILTER_STRUCT|VS_TAGFILTER_INTERFACE,VS_TAGCONTEXT_ACCESS_public, false, true);
                     } else {
                        proc_name = substr(proc_name, 1+lastpos('.',proc_name));
                        tag_tree_insert_tag(p_window_id, classes_root, 0, 1, 0, proc_name, 'class', '', 0, '', 0, '');
                     }
                  }
               }
            }
            _TreeEndUpdate(classes_root);
         }
         classes_lastid = lastid_prefix;
         classes_truncated = (classes_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      }

      // update the members from current buffer, 
      // give case-sensitive matches preference
      if (package_truncated || pos(package_lastid, lastid_prefix)!=1) {
         if (package_root > 0) {
            _TreeBeginUpdate(package_root);
            // java.lang is always imported
            tag_tree_insert_tag(p_window_id, package_root, 0, 1, 0, 'java.lang', 'package', '', 0, '', 0, '');
            package_count++;
            // list other available classes matching prefix
            if (lastid_prefix == '') {
               editorctl_wid.tag_list_globals_of_type(p_window_id, package_root, tag_files, VS_TAGTYPE_package, 0, 0, package_count, VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            } else {
               editorctl_wid.tag_list_context_packages(p_window_id, package_root, lastid_prefix, tag_files, package_count, VSCODEHELP_MAXLISTGLOBALSYMBOLS, false, true);
            }
            // list explicitely imported packages and current package
            int num_matches = tag_get_num_of_context();
            for (i=1; i<=num_matches; i++) {
               tag_get_detail2(VS_TAGDETAIL_context_type, i, type_name);
               if (tag_tree_type_is_package(type_name)) {
                  tag_tree_insert_fast(p_window_id, package_root, VS_TAGMATCH_context, i, 0, 1, 0, 0, 0);
               } else if (type_name :== 'import') {
                  tag_get_detail2(VS_TAGDETAIL_context_name, i, proc_name);
                  tag_tree_insert_tag(p_window_id, package_root, 0, 1, 0, proc_name, 'import', '', 0, '', 0, '');
               }
            }
            _TreeEndUpdate(package_root);
         }
         package_lastid = lastid_prefix;
         package_truncated = (package_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      }

      // all done
      errorArgs[1] = lastid;
      int total_count = locals_count+members_count+classes_count+package_count;
      return (total_count>0)? 0 : VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }

   // prefix expression is not null, so no categories, just list memebers
   if (!members_truncated && pos(members_lastid, lastid_prefix)==1) {
      return 0;
   }
   _TreeSetUserInfo(TREE_ROOT_INDEX, 1);
   _TreeBeginUpdate(TREE_ROOT_INDEX);

   // maybe prefix expression is a package name or prefix of package name
   if (pos("^[$_a-zA-Z0-9.]@$", prefixexp, 1, 'r') &&
      tag_check_for_package(prefixexp:+lastid, tag_files, false, true)) {
      //say("got here");
      editorctl_wid.tag_list_context_packages(p_window_id,TREE_ROOT_INDEX,prefixexp,tag_files,members_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS,false,true);
      _TreeSortCaption(TREE_ROOT_INDEX, 'u');
      members_count = 0;
      int index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);
      int start = length(prefixexp)+1;
      while (index > 0) {
         _str caption = _TreeGetCaption(index);
         //say("raw caption="caption);
         if (pos(prefixexp, caption)!=1) {
            next_index = _TreeGetNextSiblingIndex(index);
            _TreeDelete(index);
            index = next_index;
            continue;
         }
         caption = substr(caption, start);
         _TreeSetCaption(index, caption);
         //say("trimmed caption="caption);
         index = _TreeGetNextSiblingIndex(index);
         members_count++;
      }
   }

   if (prefixexp != '') {
      _str dummy_tag = '';
#if 0
      status = editorctl_wid._pas_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                                     pointer_count,
                                                     pas_return_flags, dummy_tag);
#else
      status=0;
      match_class = '';
      pointer_count = 0;
      pas_return_flags = 0;
#endif
      if (status && members_count==0) {
         return status;
      }
   } else {
      status = 0;
   }
   if (!status) {
      int context_flags = VS_TAGCONTEXT_ONLY_inclass;
      if (pos(cur_package_name'/',match_class)) {
         context_flags |= VS_TAGCONTEXT_ALLOW_package;
      }
      //if (pas_return_flags & VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS) {
      //   context_flags |= VS_TAGCONTEXT_ACCESS_private;
      //}
      //if (pas_return_flags & VSCODEHELP_RETURN_TYPE_CONST_ONLY) {
      //   context_flags |= VS_TAGCONTEXT_ONLY_const;
      //}
      //if (pas_return_flags & VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY) {
      //   context_flags |= VS_TAGCONTEXT_ONLY_volatile;
      //}
      //if (pas_return_flags & VSCODEHELP_RETURN_TYPE_STATIC_ONLY) {
      //   context_flags |= VS_TAGCONTEXT_ONLY_static;
      //}
      editorctl_wid._ListSymbolsInClass('' /*lastid*/, match_class,
                                        p_window_id, TREE_ROOT_INDEX, 0,
                                        members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                        VS_TAGFILTER_ANYTHING, context_flags,
                                        false, false);
   }
   _TreeEndUpdate(TREE_ROOT_INDEX);
   members_lastid = lastid_prefix;
   members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;

   // Return 0 indicating success if anything was found
   errorArgs[1] = (lastid!='')? lastid : prefixexp;
   return (members_count == 0)? VSCODEHELPRC_NO_SYMBOLS_FOUND:0;
}

