/*
$VerboseHistory: print.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:48a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:47a
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'
_str
   def_print_header="%f"
   ,def_print_footer="%p of %n"
   ,def_print_font="Courier,10,0"
   // The left,right, and center flags are for 1.0 and 1.5 support
   ,def_print_options="720,720,720,720,720,"(PRINT_CENTER_HEADER|PRINT_CENTER_FOOTER)",0"
   ,def_print_cheader,def_print_cfooter
   ,def_print_rheader,def_print_rfooter

static _str gprinter_setup,oprinter_setup;

/* sys_message,reserved,callback_index,font,header,footer,options */
defeventtab _print_form
void ctlhex.lbutton_up()
{
   enabled=!(ctlhex.p_value && ctlhex.p_enabled);
   if (enabled) {
      wid=_form_parent();
      if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
         ctlvisibleonly.p_enabled=wid.p_Nofhidden!=0;
      } else {
         ctlvisibleonly.p_enabled=0;
      }
   } else {
      ctlvisibleonly.p_enabled=enabled;
   }
   ctlColorCoding.p_enabled=enabled;
   _print_color.p_enabled=enabled;
   _linenums_every.p_enabled=enabled;
   ctllinenums_everylab.p_enabled=enabled;
}
_mfhook.lbutton_up(reason,info)
{
   if (reason==CHANGE_SELECTED) {
      _mfnofselected.p_caption=_mfbuflist.p_Nofselected' of '_mfbuflist.p_Noflines' selected';
      if (info) {
         // Some files or buffers have been selected
         if (_selection_only.p_enabled) _selection_only.p_enabled=0;
         if (ctlvisibleonly.p_enabled) ctlvisibleonly.p_enabled=0;
         if (ctlhex.p_enabled) {
            ctlhex.p_enabled=0;
            ctlhex.call_event(ctlhex,LBUTTON_UP);
         }
         wid=_form_parent();
         if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
            ctlBufName.p_enabled=0;
         }
      } else {
         wid=_form_parent();
         if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
            ctlBufName.p_enabled=1;
         }
         // No files or buffers are selected
         if (!_selection_only.p_enabled) {
            wid=_form_parent();
            if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)
                && wid.select_active()) {
               _selection_only.p_enabled=1;
            }
         }

         if (!ctlvisibleonly.p_enabled) {
            wid=_form_parent();
            if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
               ctlvisibleonly.p_enabled= wid.p_Nofhidden!=0;
            }
         }
         if (!ctlhex.p_enabled) {
            wid=_form_parent();
            if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
               ctlhex.p_enabled= 1;
               ctlhex.call_event(ctlhex,LBUTTON_UP);
            }
         }
      }
   }
}
_ok.on_create()
{
#if !__UNIX__
   if (substr(machine(),1,2)=="NT") {
      parse gprinter_setup with "," +0 rest
      _printer_setup(rest,'R',gprinter_setup)
      parse gprinter_setup with printer",";
      _printer_setup('','P',port);
      ctlprinter.p_caption=printer" on "port;
#if 0
      if (gprinter_setup!="") {
         parse gprinter_setup with printer "," //"," "," port
         ctlprinter.p_caption=printer;
      } else {
         parse _ntgetdefaultprintinfo() with printer"," "," port
         ctlprinter.p_caption=printer" on "port;
      }
#endif
   } else {
      ctlprinter.p_visible=ctlprinter.p_prev.p_visible=0;
      ctlorientation.p_visible=0;
   }
#endif
   wid=_form_parent()
   nowins=wid.p_view_id>=0 || (wid.p_window_flags & HIDE_WINDOW_OVERLAP);
   Nofhidden=0;
   hex_mode=0;
   if (!nowins) {
      caption=ctlBufName._ShrinkFilename(wid.p_buf_name,ctlBufName.p_width);
      ctlBufName.p_caption=caption;
      Nofhidden= wid.p_Nofhidden;
      hex_mode=wid.p_hex_mode;
   }
   // If parent window is not an MDI child window
   if (!wid.p_mdi_child) {
      _mfmore.p_enabled=0;
   }
   if (nowins) {
      _mfmore.call_event(_mfmore,LBUTTON_UP);
   } else {
      _mfhook.call_event(CHANGE_SELECTED,0,_mfhook,LBUTTON_UP,'w')
   }
   if (nowins || !wid.select_active()) {
      _selection_only.p_enabled=0;
   } else {
      _selection_only.p_value=1;
   }
   _fonttext.p_text=def_print_font;
   parse def_print_options with left_ma','AfterHeader_ma','right_ma','BeforeFooter_ma','space_between_ma','print_flags','linenums_every','top_ma','bottom_ma
   if (!isinteger(print_flags)) print_flags=PRINT_CENTER_HEADER|PRINT_CENTER_FOOTER;
   switch (print_flags & 3) {
   case PRINT_CENTER_HEADER:
      _cheader.p_text=def_print_header;
      break;
   case PRINT_RIGHT_HEADER:
      _rheader.p_text=def_print_header;
      break;
   default:
      _lheader.p_text=def_print_header
      _cheader.p_text=def_print_cheader
      _rheader.p_text=def_print_rheader
   }
   switch ((print_flags>>2) & 3) {
   case PRINT_CENTER_HEADER:
      _cfooter.p_text=def_print_footer
      break;
   case PRINT_RIGHT_HEADER:
      _rfooter.p_text=def_print_footer
      break;
   default:
      _lfooter.p_text=def_print_footer
      _cfooter.p_text=def_print_cfooter
      _rfooter.p_text=def_print_rfooter
      break;
   }
   if (!isinteger(top_ma)) top_ma=0;
   if (!isinteger(bottom_ma)) bottom_ma=0;
   _two_up.p_value=print_flags&PRINT_TWO_UP
   _linenums_every.p_text=linenums_every
   ctlAfterHeader.p_text=AfterHeader_ma/1440;
   ctlBeforeFooter.p_text=BeforeFooter_ma/1440
   _left_ma.p_text=left_ma/1440;_top_ma.p_text=top_ma/1440;
   _right_ma.p_text=right_ma/1440;_bottom_ma.p_text=bottom_ma/1440
   _space_between_ma.p_text=space_between_ma/1440;
   _retrieve_prev_form();
   if (!_selection_only.p_enabled) {
      _selection_only.p_value=0;
   }
   if (!Nofhidden) {
      ctlvisibleonly.p_enabled=0;
      ctlvisibleonly.p_value=0;
   } else {
      ctlvisibleonly.p_value=1;
   }
   if (!hex_mode) {
      //ctlhex.p_enabled=0;
      ctlhex.p_value=0;
   } else {
      ctlhex.p_value=1;
      ctlhex.call_event(ctlhex,LBUTTON_UP);
   }
   if (!_two_up.p_value) {
      _space_between_ma.p_enabled=0;
      _space_between_label.p_enabled=0
   }
   if (machine()=='OS2386') {
      ctlBottomLabel.p_enabled=ctlTopLabel.p_enabled=_top_ma.p_enabled=_bottom_ma.p_enabled=0;
   }
   if (isnumber(ctlAfterHeader.p_text)) ctlAfterHeader.p_text=ctlAfterHeader.p_text:+'"';
   if (isnumber(ctlBeforeFooter.p_text)) ctlBeforeFooter.p_text=ctlBeforeFooter.p_text:+'"';
   if (isnumber(_top_ma.p_text)) _top_ma.p_text=_top_ma.p_text:+'"';
   if (isnumber(_left_ma.p_text)) _left_ma.p_text=_left_ma.p_text:+'"';
   if (isnumber(_bottom_ma.p_text)) _bottom_ma.p_text=_bottom_ma.p_text:+'"';
   if (isnumber(_right_ma.p_text)) _right_ma.p_text=_right_ma.p_text:+'"';
   if (isnumber(_space_between_ma.p_text)) _space_between_ma.p_text=_space_between_ma.p_text:+'"';
}

static _str get_pfile_list(files, atbuflist)
/* returns view id of buffer/file list */
{
   orig_view_id=_create_temp_view(temp_view_id);
   p_view_id=temp_view_id;
   for (;;) {
      word=parse_file(files);
      if (word=="") break;
      insert_file_list(word' +p -v');
   }
   for (;;) {
      cur_buf=parse_file(atbuflist);
      if (cur_buf=='') {
         break;
      }
      if (substr(cur_buf,1,1)=='@') {
         _open_temp_view(substr(cur_buf,2),temp_buflist_view_id, temp_view_id);
         p_view_id=temp_buflist_view_id;
         mark_id=_alloc_selection();
         top();_select_line(mark_id);
         bottom();
         //messageNwait('p_Noflines='p_Noflines);
         _select_line(mark_id);
         p_view_id=temp_view_id;
         _copy_to_cursor(mark_id);
         _delete_temp_view(temp_buflist_view_id);
      }else{
         insert_line(strip(cur_buf,'B','"'));
         //insert_file_list(cur_buf' +p -v');
      }
   }
   if (p_Noflines) {
      sort_buffer('-f');
      _remove_duplicates();
   }else{
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
      return('');
   }
   p_view_id=orig_view_id;
   return(temp_view_id);
}

_ok.lbutton_up()
{
   orig_view_id=p_view_id;
   print_flags=0;
   wid=_form_parent();
   include_pfiles=(_mfproject_files.p_value)&&(pos('<<',_mfmore.p_caption));
   if(!isinteger(_linenums_every.p_text)){
      _message_box('Invalid integer')
      _linenums_every._set_sel(1,length(_linenums_every.p_text)+1)
      p_window_id=_linenums_every;_set_focus();
      return('')
   }
   if (substr(machine(),1,2)!='NT') {
      ctlorientation.p_visible=0;
   }
   files='';atbuflist='';
   list_view_id='';
   _param9='';
   fid=p_active_form;
   if (pos('<<',_mfmore.p_caption)) {
      status=_mfget_result(files, atbuflist, include_pfiles);
      //Third parameter is to include project files
      if (status) {
         return(status);
      }
      if (wid.p_view_id>=0 || (wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
         if (files=='' && atbuflist=='') {
            //If there really are no files selected, mffind can
            //return 0 and we wind up here.  I didn't want to mess with
            //mffind to much, so we just wind up here.
            _message_box(nls("No files selected"));
            p_window_id=_control _mffiles;_set_focus
            _set_sel(1,length(p_text)+1)
            return('');
         }
      }
      _param9=get_pfile_list(files, atbuflist);
      if (_param9==''&&include_pfiles) {
         _message_box(nls("There are no files in the current project."));
         p_view_id=orig_view_id;
         return('');
      }
   } else if (wid.p_view_id>=0 || (wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
      _message_box(nls("No files selected"));
      _mfmore.call_event(_mfmore,LBUTTON_UP);
      return('');
   }
   p_window_id=fid;
   if(_check_inch(_control ctlAfterHeader,AfterHeader_ma)) return('');
   if(_check_inch(_control ctlBeforeFooter,BeforeFooter_ma)) return('');
   if(_check_inch(_control _top_ma,top_ma)) return('');
   if(_check_inch(_control _left_ma,left_ma)) return('');
   if(_check_inch(_control _bottom_ma,bottom_ma)) return('');
   if(_check_inch(_control _right_ma,right_ma)) return('');
   if(_check_inch(_control _space_between_ma,space_between_ma)) return('');

   if (ctlColorCoding.p_value && ctlColorCoding.p_enabled) print_flags|=PRINT_FONTATTRS;
   if (_print_color.p_value && _print_color.p_enabled) print_flags|=PRINT_COLOR;
   if (_two_up.p_value) print_flags|=PRINT_TWO_UP;
   if (ctlvisibleonly.p_value && ctlvisibleonly.p_enabled) print_flags|=PRINT_VISIBLEONLY;
   if (ctlhex.p_value && ctlhex.p_enabled) {
      print_flags|=PRINT_HEX;
   }

   _param1= _fonttext.p_text
   _param2= _lheader.p_text;
   _param3= _lfooter.p_text;
   parse def_print_options with ','.','.','.','.','.','.','.','.','rest
   _param4=left_ma','AfterHeader_ma','right_ma','BeforeFooter_ma','space_between_ma','print_flags','_linenums_every.p_text','top_ma','bottom_ma','rest
   _param5= _cheader.p_text;
   _param6= _cfooter.p_text;
   _param7= _rheader.p_text;
   _param8= _rfooter.p_text;

#if 0
   {
      def_print_font=_param1;
      def_print_header=_param2;
      def_print_footer=_param3;
      def_print_options=_param4;
      def_print_cheader=_param5;
      def_print_cfooter=_param6;
      def_print_rheader=_param7;
      def_print_rfooter=_param8;
      _config_modify|=CFGMODIFY_DEFVAR;
   }
#endif

   _ok.p_user='';
   _save_form_response();
   if (substr(machine(),1,2)=='NT') { //we're on a windows machine
      //parse gprinter_setup with devname","
      if (ctllandscape.p_value) {
         _printer_setup(',2,,','r'); //turn on landscape
      } else {
         _printer_setup(',1,,','r'); //turn off landscape
      }
   }
   p_active_form._delete_window((_selection_only.p_value && _selection_only.p_enabled)?2:1)
}
_ok.on_destroy()
{
   // IF save settings button pressed and user did not press OK button
   if (_ok.p_user!='') {
      _save_form_response()
   }
}
_font.lbutton_up()
{
   if (machine()=='OS2386') {
      // Don't want to use _choose_font under OS/2 because we
      // don't support kerned fonts yet.
      result=show('-modal _font_form','p',_fonttext.p_text)
      if (result!='') {
         _fonttext.p_text=result;
      }
   } else {
      result=_choose_font(CF_PRINTERFONTS,_fonttext.p_text);
      if (result!='') {
         _fonttext.p_text=result;
      }
   }
}

_finddir.lbutton_up()
{
   result=show('-modal '_stdform('_cd_form'),'Choose Directory',1,1,1);
   if( result=='' ) {
      return('');
   }
   _mfcurdir.p_caption='CurDir is 'getcwd();
   result=strip_options(result,dummy);
   line=_mffiles.p_text;
   if( line!='' ) {
      line=strip(line,'T');
      lastch=last_char(line);
      if( lastch==FILESEP ) {
         #if __UNIX__
         line=strip(line,'T'):+'* ':+result;
         #else
         line=strip(line,'T'):+'*.* ':+result;
         #endif
      } else {
         line=strip(line,'T'):+' ':+result;
      }
   } else {
      line=result;
   }
   _mffiles.p_text=line;
   _mffiles._end_line();
   _mffiles._set_focus();
}

definit()
{
   gprinter_setup='';oprinter_setup='';
}
_sr_printer()
{
   if (arg(1)=='N' || arg(1)=='R') {
      // IF we are not restoring from an editor invocation.
      // Only restore project if user has selected to restore current directory
      parse arg(2) with Noflines
      if (!arg(3)) {
         down(Noflines);
         return(0);
      }
      down
      get_line gprinter_setup
      down
      get_line oprinter_setup
      if (machine()=='OS2386') {
         _printer_setup(oprinter_setup,'r');
      } else {
         gprinter_setup="";
         // We are commenting this out line because if we reset the printer to a
         // non-existant printer, the user will not be able to print until
         // a valid printer is selected through printer setup.
         //_printer_setup(gprinter_setup,'r');
         //_printer_setup('','s',temp);
         //messageNwait("_sr_printer: temp="temp" gsetup="gprinter_setup);
         //gprinter_setup="";
      }
   } else {
      insert_line('PRINTER: 2');
      insert_line(gprinter_setup);
      insert_line(oprinter_setup);
   }
   return(0);
}
void _setup.lbutton_up()
{
   if (substr(machine(),1,2)=='NT') { //we're on a windows machine
      //parse gprinter_setup with devname","
      if (ctllandscape.p_value) {
         _printer_setup(',2,,','r'); //turn on landscape
      } else {
         _printer_setup(',1,,','r'); //turn off landscape
      }
      status=_printer_setup('','s',gprinter_setup)
      if (status) {
         _message_box(nls('Failed to setup printer.')'  'get_message(status));
         return;
      }
      //_printer_setup('','R',setup);
      //parse setup with ','landscape',';
      parse gprinter_setup with ','landscape',';
      if (landscape==2) {
         ctllandscape.p_value=1;
      } else {
         ctlportrait.p_value=1;
      }
      parse gprinter_setup with "," +0 rest
      _printer_setup(rest,'R',gprinter_setup)
      parse gprinter_setup with printer",";
      _printer_setup('','P',port);
      ctlprinter.p_caption=printer" on "port;
      return;
   }
   if (machine()=='OS2386') {
      status=_printer_setup('','s',oprinter_setup)
   } else {
      status=_printer_setup('','s',gprinter_setup)
   }
   if (status) {
      _message_box(nls('Failed to setup printer.')'  'get_message(status))
   }
}
_two_up.lbutton_up()
{
   _space_between_ma.p_enabled=
   _space_between_label.p_enabled=_two_up.p_value!=0;

   //turn on landscape mode
   //if (def_auto_landscape) {
   if (_two_up.p_value) {
      ctllandscape.p_value=1;
   } else {
      ctlportrait.p_value=1;
   }
   //}

}
static _check_inch(wid,var twips)
{
   text=wid.p_text;
   parse text with number '"','i' rest
   parse number with x '.' y
   if (isnumber(number)) {
      number=number*1440
      // Strip off decimal pointer if there is no exponent
      parse number with x '.' y
      if (isinteger(y)) number=x;
   }
   if (rest!='' || !isnumber(number) || pos('e',number,1,'i')) {
      _message_box('Invalid margin setting');
      p_window_id=wid;
      wid._set_sel(1,length(text)+1);_set_focus();
      return(1)
   }
   twips=number
   return(0)
}
_command void printer_setup() name_info(','VSARG2_EDITORCTL)
{
   if (machine()=='OS2386') {
      status=_printer_setup('','s',oprinter_setup)
   } else {
      status=_printer_setup('','s',gprinter_setup)
   }
   if (status) {
      _message_box(nls('Failed to setup printer.')'  'get_message(status))
   }
}
static _str cancel_wid
static void _print_callback(reason)
{
   _nocheck _control filelabel
   switch(reason) {
   case PRINT_ONINIT:
      cancel_wid=show('_cancelprint_form')
      cancel_wid.filelabel.p_caption=arg(2)
      break;
   case PRINT_ONEXIT:
      cancel_wid._delete_window()
      break;
   case PRINT_ONPAGE:
      PageNumber=arg(2);
      NofPages=arg(3);
      //say("PageNumber="PageNumber" NofPages="NofPages);
      _nocheck _control ctlinfo;
      if (NofPages) {
         cancel_wid.ctlinfo.p_caption="Page "PageNumber" of "NofPages;
      } else {
         cancel_wid.ctlinfo.p_caption="Page "PageNumber;
      }
      cancel_wid.refresh('w');
      break;
   }
}
defeventtab _cancelprint_form
cancel.lbutton_up()
{
   _print_cancel
}
_command gui_print() name_info(','VSARG2_EDITORCTL)
{
   _macro_delete_line();
   result=show('-modal _print_form');
   if (result=='') {
      return(COMMAND_CANCELLED_RC)
   }
   if (result==1) {
      if (_param9!='') {
         orig_view_id=p_view_id;
         filelist_view_id=_param9;
         p_view_id=filelist_view_id;
         if (!p_Noflines) {
            _message_box(nls("No matching files."));
            p_view_id=orig_view_id;
            _delete_temp_view(filelist_view_id);
            return('');
         }
         p_line=0;
         while (!down()) {
            get_line(filename);
            filename=strip(filename);
            p_view_id=HIDDEN_VIEW_ID;
            status=load_files('+c +q +b 'filename)
            if (!status) {
               fileinmem=1;
            }else{
               load_files('+c +q 'filename);
               fileinmem=0;
               select_edit_mode();
            }
            //I decided to use load_files instead of edit to get around cases
            //where there were no child windows and edit brought them up.
            //This just feels cleaner to me.
            status=_print(filename,
                   '',//We don't know why this is here
                   //find_index('_print_callback',PROC_TYPE),    //callback_index
                   _print_callback,  //callback
                   _param1,         // Font
                   _insert_print_options(_param2,filename),         // header
                   _insert_print_options(_param3,filename),         // footer
                   _param4,         // margins, print flags, linenums_every
                   _insert_print_options(_param5,filename),
                   _insert_print_options(_param6,filename),
                   _insert_print_options(_param7,filename),
                   _insert_print_options(_param8,filename)
                   );
            if (substr(machine(),1,2)=='NT' && _win32s()!=1) {
               // Force the HDC to be recreated.
               // The HP Laserjet 2 si  seems to trash the HDC
               // when we finish printing.
               // Pretend like we are modifying some options so
               // the hdc will be created.
               _printer_setup(',','R',setup);
            }
            if (!fileinmem) _delete_buffer();//Delete buffer if not already up
            _quit_view();
            p_view_id=orig_view_id;
            p_view_id=filelist_view_id;
            _macro('m',_macro('s'))
            _macro_call('print',_param1,_param2,_param3,_param4,_param5,_param6,_param7,_param8)
         }
         p_view_id=orig_view_id;
         _delete_temp_view(filelist_view_id);
      }else{
         status=_print(p_buf_name,'',
                //find_index('_print_callback',PROC_TYPE),    //callback_index
                _print_callback,  //callback
                _param1,         // Font
                _insert_print_options(_param2,p_buf_name),         // header
                _insert_print_options(_param3,p_buf_name),         // footer
                _param4,         // margins, print flags, linenums_every
                _insert_print_options(_param5,p_buf_name),         // cheader
                _insert_print_options(_param6,p_buf_name),         // cfooter
                _insert_print_options(_param7,p_buf_name),         // rheader
                _insert_print_options(_param8,p_buf_name)          // rfooter
                );
         _macro('m',_macro('s'));
         _macro_call('print',_param1,_param2,_param3,_param4,_param5,_param6,_param7,_param8);
      }
   } else {
      status=print_selection(
             _param1,         // Font
             _param2,         // header
             _param3,         // footer
             _param4,         // margins, print flags, linenums_every
             _param5,         // cheader
             _param6,         // cfooter
             _param7,         // rheader
             _param8          // rfooter
             )
      _macro('m',_macro('s'))
      _macro_call('print_selection',_param1,_param2,_param3,_param4,_param5,_param6,_param7,_param8)
   }
   if (status) {
      _message_box("Error printing.  "get_message(status))
   }
   return(status)
}
static _str _insert_print_options(_str string,_str buf_name)
{
   result="";
   for(i=1;;) {
      j=pos("%",string,i);
      if (!j) {
         result=result:+substr(string,i);
         return(result);
      }
      result=result:+substr(string,i,j-i);
      switch (upcase(substr(string,j+1,2))) {
      case "FD":
         result=result:+file_date(buf_name);
         i=j+3;
         break;
      case "FT":
         result=result:+file_time(buf_name);
         i=j+3;
         break;
      default:
         result=result:+substr(string,j,2);
         i=j+2;
      }
   }
}
_command print() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   if (arg()>1) {
      status=_print(p_buf_name,'',
             //find_index('_print_callback',PROC_TYPE),    //callback_index
             _print_callback,  //callback
             arg(1),           //font
             _insert_print_options(arg(2),p_buf_name),
             _insert_print_options(arg(3),p_buf_name),
             arg(4),
             _insert_print_options(arg(5),p_buf_name),
             _insert_print_options(arg(6),p_buf_name),
             _insert_print_options(arg(7),p_buf_name),
             _insert_print_options(arg(8),p_buf_name)
             )
   } else {
      status=_print(p_buf_name,'',
             //find_index('_print_callback',PROC_TYPE),    //callback_index
             _print_callback,  //callback
             def_print_font,   // font
             _insert_print_options(def_print_header,p_buf_name),         // header
             _insert_print_options(def_print_footer,p_buf_name),         // footer
             def_print_options,
             _insert_print_options(def_print_cheader,p_buf_name),
             _insert_print_options(def_print_cfooter,p_buf_name),
             _insert_print_options(def_print_rheader,p_buf_name),
             _insert_print_options(def_print_rfooter,p_buf_name)
             )
   }
   if (status<0) {
      _message_box(nls('Printing Failed')'.  'get_message(status))
   }
   return(status);
}

_command print_selection() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_MARK)
{
   if (arg(1)>1) {
      print_font=arg(1)
      print_header=arg(2)
      print_footer=arg(3)
      print_options=arg(4)
      print_cheader=arg(5)
      print_cfooter=arg(6)
      print_rheader=arg(7)
      print_rfooter=arg(8)
   } else {
      print_font=def_print_font
      print_header=def_print_header;
      print_footer=def_print_footer;
      print_options=def_print_options
      print_cheader=def_print_cheader
      print_cfooter=def_print_cfooter
      print_rheader=def_print_rheader
      print_rfooter=def_print_rfooter
   }
   parse print_options with left_ma','AfterHeader_ma','right_ma','BeforeFooter_ma','space_between_ma','print_flags','linenums_every','top_ma','bottom_ma
   if ( !select_active2() ) {
      _message_box(get_message(TEXT_NOT_SELECTED_RC))
      return(TEXT_NOT_SELECTED_RC)
   }
   mark= _duplicate_selection()    /* Save the users mark. */
   if ( mark<0  ) return(mark);
   status=_get_selinfo(junk,junk,buf_id);
   if ( status ) {
      _free_selection(mark);
      return(status)
   }
   // Save old buffer cursor position so mark does not move.
   _next_buffer('h');_prev_buffer('h');

   orig_view_id=_create_temp_view(temp_view_id);
   if (orig_view_id=="") {
      _free_selection(mark);
      return(status)
   }
   old_buf_id=p_buf_id;
   p_buf_id=buf_id;
   extension=_bufnameNmode2ext(p_buf_name,p_mode_name);
   save_pos(p);_begin_select();
   if (print_flags & PRINT_HEX) {
      if (_select_type()=='LINE') {
         _begin_line();
      }
      RealLineNumber=_QROffset();
      //messageNwait('RealLineNumber='RealLineNumber);
   } else {
      RealLineNumber=p_RLine;
   }
   restore_pos(p);
   tabs=p_tabs;buf_width=p_buf_width;buf_name=p_buf_name;
   p_buf_id=old_buf_id;
   p_buf_name=buf_name;
   p_tabs=tabs;
   if (_select_type()!='LINE') {
      insert_line("");
   }
   _copy_to_cursor(mark,VSMARKFLAG_COPYNOSAVELF);
   _free_selection(mark);
   select_edit_mode(extension);
   parse print_options with left_ma','AfterHeader_ma','right_ma','BeforeFooter_ma','space_between_ma','print_flags','linenums_every','top_ma','bottom_ma','pageleft_ma','pageright_ma',';
   print_options=left_ma','AfterHeader_ma','right_ma','BeforeFooter_ma','space_between_ma','print_flags','linenums_every','top_ma','bottom_ma','pageleft_ma','pageright_ma','RealLineNumber;
   p_show_tabs=0;
   status=_print(buf_name,'',
          //find_index('_print_callback',PROC_TYPE),    //callback_index
          _print_callback,  //callback
          print_font,
          _insert_print_options(print_header,buf_name),
          _insert_print_options(print_footer,buf_name),
          print_options,
          _insert_print_options(print_cheader,buf_name),
          _insert_print_options(print_cfooter,buf_name),
          _insert_print_options(print_rheader,buf_name),
          _insert_print_options(print_rfooter,buf_name)
          );
   _delete_temp_view(temp_view_id);
   if ( status<0 ) {
      _message_box(nls('Printing Failed')'.  'get_message(status))
   } else {
      if (def_keys=='brief-keys') deselect();
   }
   return(status)
}
struct VSPRINTCONFIG {
   _str szFontName;
   int FontSizeX10;
   int FontFlags;
   int FontCharSet;
   _str szLeftHeader;
   _str szLeftFooter;
   _str szCenterHeader;
   _str szCenterFooter;
   _str szRightHeader;
   _str szRightFooter;
   int twLeftMargin;
   int twRightMargin;
   int twTopMargin;
   int twBottomMargin;
   int twAfterHeader;
   int twBeforeFooter;
   int twSpaceBetween;
   int PrintFlags;
   int LinenumsEvery;
};
void _PrintSetConfig(VSPRINTCONFIG &result)
{
   //say('result.szCenterHeader='result.szCenterHeader);
   def_print_font=result.szFontName','(result.FontSizeX10 intdiv 10)','result.FontFlags','result.FontCharSet;

   switch (result.PrintFlags & 3) {
   case PRINT_CENTER_HEADER:
      def_print_header=result.szCenterHeader;
      break;
   case PRINT_RIGHT_HEADER:
      def_print_header=result.szRightHeader;
      break;
   default:
      def_print_header=result.szLeftHeader;
      def_print_cheader=result.szCenterHeader;
      def_print_rheader=result.szRightHeader;
   }
   switch ((result.PrintFlags>>2) & 3) {
   case PRINT_CENTER_HEADER:
      def_print_footer=result.szCenterFooter;
      break;
   case PRINT_RIGHT_HEADER:
      def_print_footer=result.szRightFooter;
      break;
   default:
      def_print_footer=result.szLeftFooter;
      def_print_cfooter=result.szCenterFooter;
      def_print_rfooter=result.szRightFooter;
      break;
   }

   def_print_options=
      result.twLeftMargin',':+
      result.twAfterHeader',':+
      result.twRightMargin',':+
      result.twBeforeFooter',':+
      result.twSpaceBetween',':+
      result.PrintFlags',':+
      result.LinenumsEvery',':+
      result.twTopMargin',':+
      result.twBottomMargin;

   _DialogClearRetrieval('_print_form');
}
void _PrintGetConfig(VSPRINTCONFIG &result)
{
   parse def_print_font with FontName','FontSize','FontFlags','CharSet;
   result.szFontName=FontName;
   result.FontSizeX10=FontSize*10;
   result.FontFlags=FontFlags;
   if (!isinteger(CharSet)) {
      CharSet=1;  // default_charset
   }
   result.FontCharSet=CharSet;

   parse def_print_options with left_ma','AfterHeader_ma','right_ma','BeforeFooter_ma','space_between_ma','print_flags','linenums_every','top_ma','bottom_ma;

   result.szLeftHeader='';
   result.szLeftFooter='';
   result.szCenterHeader='';
   result.szCenterFooter='';
   result.szRightHeader='';
   result.szRightFooter='';

   switch (print_flags & 3) {
   case PRINT_CENTER_HEADER:
      result.szCenterHeader=def_print_header;
      break;
   case PRINT_RIGHT_HEADER:
      result.szRightHeader=def_print_header;
      break;
   default:
      result.szLeftHeader=def_print_header;
      result.szCenterHeader=def_print_cheader;
      result.szRightHeader=def_print_rheader;
   }
   switch ((print_flags>>2) & 3) {
   case PRINT_CENTER_HEADER:
      result.szCenterFooter=def_print_footer
      break;
   case PRINT_RIGHT_HEADER:
      result.szRightFooter=def_print_footer
      break;
   default:
      result.szLeftFooter=def_print_footer
      result.szCenterFooter=def_print_cfooter
      result.szRightFooter=def_print_rfooter
      break;
   }
   if (!isinteger(top_ma)) top_ma=0;
   if (!isinteger(bottom_ma)) bottom_ma=0;
   result.twLeftMargin=left_ma;
   result.twRightMargin=right_ma;
   result.twTopMargin=top_ma;
   result.twBottomMargin=bottom_ma;
   result.twAfterHeader=AfterHeader_ma;
   result.twBeforeFooter=BeforeFooter_ma;
   result.twSpaceBetween=space_between_ma;
   result.PrintFlags=print_flags;
   result.LinenumsEvery=linenums_every;
   //say('result.szCenterHeader='result.szCenterHeader);
}
