/*
$VerboseHistory: put.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:54a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:54a
 * Comment:
 * Added support for Explorer style open dialog.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:37p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'
_str   // Options for tprint command. (Must set variables manually.)
          // Old text mode macro variables.
   def_leading_codes
   ,def_trailing_codes
   ,def_tprint_device

_str
   def_preplace


_command get(...) name_info(FILE_ARG','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   arg1=prompt(arg(1),nls('Insert file'))
   mark=_alloc_selection()
   if ( mark<0 ) {
     return(mark)
   }
   get_view_id view_id
   /* Check if this buffer already exists. */
   buf_id=p_buf_id
   new_buffer_status=load_files('+q +b 'absolute(strip_options(arg1,junk)))
   load_files '+bi 'buf_id
   if (p_mdi_child) {
      status=edit_file('-w -i -u +c 'arg1)
   } else {
      // Don't want to set focus.
      status=load_files('-u +c 'arg1)
   }
   if ( status==NEW_FILE_RC ) {
      message get_message(FILE_NOT_FOUND_RC)
      quit_file();_quit_view
   }
   if ( status ) {
     _free_selection mark
     return(status)
   }
   if ( buf_id==p_buf_id ) {  /* No file loaded.  Arg1 could be '' */
      _free_selection mark
      return(COMMAND_CANCELLED_RC)
   }
   if ( new_buffer_status ) {   /* is this a file that was loaded from disk? */
                               /* then want to throw away this buffer. */
      p_buf_flags=p_buf_flags|THROW_AWAY_CHANGES
   }
   LastLineHasNLChars=1;
   RemoveEOF=0;
   top();
   if (!_on_line0()) {
      _select_line(mark);bottom();
      _select_line(mark);
      // IF this is an ASCII buffer in DOS format AND last line
      //    contains just an EOF character
      if (!p_buf_width && p_newline=="\r\n" &&
          get_text()==_chr(26)) {
         RemoveEOF=1;
      } else {
         LastLineHasNLChars=_line_length()!=_line_length(1);
      }
   }
   get_view_id mark_view_id
   old_buf_flags=p_buf_flags
   activate_view view_id
   old_line_insert=def_line_insert
   if ( arg(3)!='' ) {
      def_line_insert=upcase(arg(3))
   }
   status=rc;
   if (_select_type(mark)!='') {
      RemoveNLChars=0;
      if (!p_buf_width && !LastLineHasNLChars && def_line_insert=='A') {
         typeless p;
         save_pos(p);
         if(down() ){
            RemoveNLChars=1;
         }
         restore_pos(p);
      }
      //Noflines=count_lines_in_selection();
      if ( old_buf_flags&THROW_AWAY_CHANGES ) {
         status=move_to_cursor(mark);
      } else {
         status=copy_to_cursor(mark);
      }
      if (RemoveEOF || !LastLineHasNLChars) {
         typeless p;
         save_pos(p);
         _end_select(mark);
         _end_line();
         if (RemoveEOF) {
            left();_delete_text();
         }
         // IF are on the last line of the file
         if (down()) {
            // Remove NLChars
            _delete_text(2);
         }
         if (!_line_length(1)) {
            _delete_line();
         }
         restore_pos(p);
      }
   }
   def_line_insert=old_line_insert
   _free_selection mark
   activate_view mark_view_id
   if ( p_buf_flags&THROW_AWAY_CHANGES ) {
      quit_file();
   }
   _quit_view
   activate_view view_id
   if ( status ) {  /* make sure move mark error message is displayed. */
     message get_message(status)
   }
   return(status)

}
_command put(...)
{
   if (is_printer_device(arg(1)) || lowcase(arg(1))=='-p') {
      return(print_selection());
   }
   return(put2(arg(1),arg(2),nls('Write mark'),'+t'))


}
_command append(...) name_info(FILE_ARG",")    /* Reasonable to allow completion for append. */
{
   return(put2(arg(1),SV_OVERWRITE,nls('Append mark'),''))

}
// Old function used for text mode (not-laser printer) printing.
static _str is_printer_device(dev_name)
{
    return (
#if __PCDOS__
      file_eq(dev_name,'prn') ||
      /* Check for LPT follow by a digit. */
       (file_eq(substr(dev_name,1,3),'lpt') && isinteger(substr(dev_name,4))) ||
       file_eq(dev_name,def_tprint_device)
#else
      file_eq(dev_name,'/dev/lp') || file_eq(dev_name,'/dev/lp1') ||
      file_eq(dev_name,'/dev/lp2') || file_eq(dev_name,'/dev/lp3') ||
      file_eq(dev_name,'/dev/lp4') || file_eq(dev_name,def_tprint_device)
#endif
    )

}
static _str put2(arg1,arg2,msg,options)
{
   dev_name=prompt(arg1,msg)
   if ( dev_name=='' ) {
      return(COMMAND_CANCELLED_RC)
   }
   /* IF allow popup prompt AND called from key OR command line/arg(2) */
   /* AND file exists */

   flags=arg(2);
   if (flags=='') flags=0;
   preplace=!(flags&SV_OVERWRITE) && def_preplace;

   if ( preplace && file_match('-p 'dev_name,1)!='') {
      status=overwrite_existing(dev_name,"Write Mark")
      if ( status ) {
         return(status)
      }
   }
   if ( _select_type()=='' ) {
      message get_message(TEXT_NOT_SELECTED_RC)
      return(TEXT_NOT_SELECTED_RC)
   }
   // Make a copy of the current selection so we dont loose it.
   mark= _duplicate_selection();
   if ( mark<0 ) return(mark);
   _get_selinfo junk,junk,buf_id
   old_buf_id=p_buf_id;
   status=load_files('+bi 'buf_id);
   if ( status ) {
      _free_selection(mark);
      return(status)
   }
   selected_buf_name=p_buf_name;
   tabs=p_tabs;buf_width=p_buf_width
   load_files('+bi 'old_buf_id);
#if __UNIX__
   if ( ! pathlen(def_tprint_device) ) {
      def_tprint_device='/dev/'def_tprint_device
   }
#endif
   if ( lowcase(dev_name)=='-p' ) {
      dev_name=def_tprint_device;
   }
   file_already_loaded=0;
   if (options=='') {
      file_already_loaded=buf_match(absolute(strip(dev_name)),1,'xh')!='';
   }
   if ( buf_width ) {
      status=edit_file('-w -i +'buf_width' 'build_load_options(dev_name)' +c -u 'options" "dev_name);
   } else {
      // Appending to file
      status=edit_file('-w -i 'build_load_options(dev_name)' +c -u 'options" "dev_name);
   }
   if ( status ) {
      if ( status:==NEW_FILE_RC ) {
         status=FILE_NOT_FOUND_RC;
         message get_message(status);
         quit_file();
         if (!buf_width) {
            _quit_view();
         }
      }
      _free_selection(mark);
      return(status)
   }

   // Appending to file?
   if ( options=='' ) {
      // Trying to append to self?
      if (buf_id==p_buf_id) {
         _free_selection(mark);
         _quit_view();
         status=ACCESS_DENIED_RC;
         message(nls("Can't append to self"));
         return(status);
      }
      bottom();
      // IF this is an ASCII buffer in DOS format AND last character
      //    of buffer is an EOF character
      if (!p_buf_width && p_newline=="\r\n" &&
          get_text()==_chr(26)) {
         // Delete the EOF character
         if (_line_length(1)==1) {
            // Delete whole line.  It just contains an EOF character.
            _delete_line();
         } else {
            // Delete the EOF character
            left();_delete_text();
         }
      }
   }

   p_tabs=tabs;
   status=_copy_to_cursor(mark)
   _free_selection mark
   if ( status ) {
      if (!file_already_loaded) quit_file();
      _quit_view();
      message get_message(status)
      return(status)
   }
   if ( _select_type()=='LINE' && options!='' ) {
      top;_delete_line();
   }
   old_AllowSave=p_AllowSave;
   p_AllowSave=true;
   status=save('',SV_OVERWRITE);
   p_AllowSave=old_AllowSave;
   p_modify=0;
   if (!file_already_loaded) quit_file();
   _quit_view();
   if ( status<0 ) {
      message(get_message(status));
   }
   return(status)

}
_str _temp_path()
{
#if __UNIX__
   path='/tmp/'
#else
   path=_spill_file_path()
   if (path=='') {
      path=get_env('TEMP');
      if (path=='') {
         path=get_env('TMP');
      }
   }
#endif
   if( last_char(path)!=FILESEP ) {
      path=path:+FILESEP
   }
   return(path);
}
_str mktemp()
{
   path=_temp_path();
   pid=getpid()
   start=arg(1)
   if ( start=='' ) {
      start=1
   }
   for (i=start; i<=99 ; ++i) {
      buf_id=0;
      if (p_view_id<0) {
         buf_id=p_buf_id;
      }
      name=path:+substr(pid,1,6,'0'):+i'.'buf_id
      if ( file_match('-p 'name,1)=='' ) {
         return(name)
      }
   }
   return('')
}


_command gui_insert_file() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   _macro_delete_line();
   result=_OpenDialog(_stdform('_open_form')' -modal',
     'Insert File',
      ALLFILES_RE,
     def_file_types,
     OFN_FILEMUSTEXIST,
     '',
     '',
     '',
     'gui_insert_file',   // Retrieve name
     'Insert File dialog box'
     )
   if(result == ''){
      return(COMMAND_CANCELLED_RC);
   }
   status = get(result);
   if (status) {
      clear_message();
      _message_box(nls('Unable to open %s',result)'. 'get_message(status));
      return(status)
   }
   _macro('m',_macro('s'))
   _macro_append('get('_quote(result)');');
   return(0);
}

_command gui_write_selection() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION|VSARG2_MARK)
{
   _macro_delete_line();
   if ( _select_type()=='' ) {
      message get_message(TEXT_NOT_SELECTED_RC)
      return(TEXT_NOT_SELECTED_RC)
   }
   result=_OpenDialog(_stdform('_open_form')' -modal',
     'Write Selection',
     ALLFILES_RE,
     def_file_types,
     OFN_SAVEAS|OFN_APPEND|OFN_PREFIXFLAGS,
     '',
     '',
     '',
     'gui_insert_file',   // Retrieve name
     'write selection dialog box'
     );
   if(result == ''){
      return(COMMAND_CANCELLED_RC);
   }
   parse result with option rest
   if (lowcase(option)=='-a') {
      status = append(result);
      if (status) {
         clear_message();
         _message_box(nls('Unable to write selection to %s',result)'. 'get_message(status));
         return(status)
      }
      _macro('m',_macro('s'))
      _macro_append('append('_quote(result)');');
      return(0);
   }
   status = put(result,SV_OVERWRITE);
   if (status) {
      clear_message();
      _message_box(nls('Unable to write selection to %s',result)'. 'get_message(status));
      return(status)
   }
   _macro('m',_macro('s'))
   _macro_append('put('_quote(result)',SV_OVERWRITE);');
   return(0);
}

_command gui_append_selection() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   _macro_delete_line();
   if ( _select_type()=='' ) {
      message get_message(TEXT_NOT_SELECTED_RC)
      return(TEXT_NOT_SELECTED_RC)
   }
   result=_OpenDialog(_stdform('_open_form')' -modal',
     'Append Selection',
     ALLFILES_RE,
     def_file_types,
     OFN_FILEMUSTEXIST,
     '',
     '',
     '',
     'gui_insert_file',  //Retrieve name
     'append selection dialog box'
     );
   if(result == ''){
      return(COMMAND_CANCELLED_RC);
   }
   status = append(result);
   if (status) {
      clear_message();
      _message_box(nls('Unable to write selection to %s',result)'. 'get_message(status));
      return(status)
   }
   _macro('m',_macro('s'))
   _macro_append('append('_quote(result)');');
   return(0);
}
