/*
$VerboseHistory: slick.sh$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:11a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:11a
 * Comment:
 * 
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:44p
 * Comment:
 * Adding new 3.0 stuff
*/
// Macro Version 2.0a
// Note: Slick-C uses const to get the effect of #define.  When
//       #define is added to the language, these declarations will be
//       changed.

// IF we are running old macro compiler to convert SlickEdit
//    macro to Slick-C.
#if __VERSION__<1.8
   #include "slick24.sh"
#else

#define KEEP 0
#define KEEP2 0

#define MAXINT       (0x7fffffff)

   /* some machine dependant constants. */
#if __PCDOS__
   #define FILESEP "\\"              /* Primary filename,directory separator */
   #define FILESEP2  "/"              /* Secondary filename,directory separator */
   #define PATHSEP ";"
   #define PRJ_DEFAULT_FILE 'project.slk'
   #define PRJ_PACKS_FILE 'prjpacks.slk'
#else
   #define PRJ_DEFAULT_FILE 'uproject.slk'
   #define PRJ_PACKS_FILE 'uprjpack.slk'
   #define FILESEP "/"              /* Primary filename,directory separator */
   #define FILESEP2 "\\"              /* Secondary filename,directory separator */
   #define PATHSEP ":"
#endif
   #define ARGSEP "-"

#if __PCDOS__
   #define ALLFILES_RE  '*.*'
   #define _NAME_HAS_DRIVE 1
   #define DLLEXT '.dll'
#else
    #define ALLFILES_RE  '*'
    #define _NAME_HAS_DRIVE 0
    #define DLLEXT '.dll'
#endif

#define _MAX_HSCROLL_POS 32000
#define _SLICKBIN "VSLICKBIN"
#define _SLICKMISC "VSLICKMISC"
#define _SLICKMACROS "VSLICKMACROS"
#define _SLICKPATH "VSLICKPATH"
#define _SLICKRESTORE "VSLICKRESTORE"
#define _SLICKCONFIG "VSLICKCONFIG"
#define _SLICKLOAD "VSLICKLOAD"
#define _SLICKSAVE "VSLICKSAVE"
#define _SLICKTAGS "VSLICKTAGS"
#define _SLICKREFS "VSLICKREFS"
#define _SLICKALIAS "VSLICKALIAS"
#define _MDIMENU "_mdi_menu"
#define USERMACS_FILE 'vusrmacs'       /* File to contain all user recorded macros. */
#define USERMODS_FILE 'vusrmods'       /* File which loads user macro modules. */
#define KEYTAB_MAXASCII  129
#define KEYTAB_MAXEXT    446
/* number of definable keys in a key table. */
#define NUMKEYS KEYTAB_MAXASCII+KEYTAB_MAXEXT
#define _WINDOW_CONFIG_FILE "vrestore.slk"
#define _ALIAS_FILE "alias.slk"
#define _VLX_FILE "vslick.vlx"
#define _GREP1_BUFFER 'grep1'
#define _INI_FILE "vslick.ini"
#define BSC_FILE_EXT '.bsc'
#define REF_FILE_EXT '.vtr'
#define TAG_FILE_EXT '.vtg'
#define PRJ_TAG_FILE_EXT '.vtg'
#define PRJ_FILE_EXT '.vpj'
#define OS2SLICK_HELP_FILE   "ovslick.hlp"  // Default OS/2 help file

#if __PCDOS__
   // non-UNIX platforms
   #define SLICK_TAGS_FILE   "tags.slk"
   #define SLICK_TAGS_DB     "tags.vtg"
   #define SLICK_HELP_FILE   "vslick.hlp"  // Default Windows help file
   #define SLICK_HELPLIST_FILE   "vslick.lst"  // Help list file
   #define _MDI_INTERFACE 1
   #define USERDEFS_FILE "vusrdefs"
   #define USEROBJS_FILE "vusrobjs"
   #define USERSYSO_FILE 'vusrs40b'
   #define SYSOBJS_FILE "sysobjs"
   #define STATE_FILENAME "vslick.sta"
   #define SYSCPP_FILE    "syscpp.h"
   #define USERCPP_FILE   "usercpp.h"
   #define _MULTI_USER 1
#else
   // UNIX options
   #define SLICK_TAGS_FILE   "utags.slk"
   #define SLICK_TAGS_DB     "utags.vtg"
   #define SLICK_HELP_FILE   "uvslick.hlp"  // Default help file
   #define SLICK_HELPLIST_FILE   "uvslick.lst"  // Help list file
   #define _MDI_INTERFACE 1
   #define USERDEFS_FILE "vunxdefs"
   #define USEROBJS_FILE "vunxobjs"
   #define USERSYSO_FILE "vunxs40b"
   #define SYSOBJS_FILE "usysobjs"
   #define STATE_FILENAME "vslick.stu"
   #define SYSCPP_FILE    "usyscpp.h"
   #define USERCPP_FILE   "unxcpp.h"
   #define _MULTI_USER 1
#endif

#define MAX_LINE 0x7fffffff
#define HEX_CHARSPERCOL 4

#define SYSTEM_LEXER_FILENAME  'vslick.vlx'
#define USER_LEXER_FILENAME 'user.vlx'
#define LEXER_FILE_LIST SYSTEM_LEXER_FILENAME:+PATHSEP:+USER_LEXER_FILENAME
/* Meaning of rc flags passed to internal commands (DEFC)*/
#define PAUSE_COMMAND  4               /* Command should wait for key press */

/* buffer flags for p_buf_flags property. */
#define HIDE_BUFFER        0x1  /* NEXT_BUFFER won't switch to this buffer */
#define THROW_AWAY_CHANGES 0x2  /* Allow quit without prompting on modified buffer */
#define KEEP_ON_QUIT       0x4  /* Don't delete buffer on QUIT.  */
/* HYPERTEXT_BFLAG  =0x8 */
#define REVERT_ON_THROW_AWAY   0x10
#define PROMPT_REPLACE_BFLAG       0x20
#define DELETE_BUFFER_ON_CLOSE     0x40   /* Indicates whether a list box/ */
                                      /* edit window buffer show be deleted */
                                      /* when the dialog is closed. */
#define FTP_UPLOAD_IN_PROGRESS     0x80   /* Specifies that buffer is currently being uploaded */

/* p_color_flags property. */
/* These color flags indicate what coloring should be applied. */
#define LANGUAGE_COLOR_FLAG    0x1
#define MODIFY_COLOR_FLAG      0x2
#define CLINE_COLOR_FLAG       0x4

// _clex_find flags
#define OTHER_CLEXFLAG        0x1
//ERROR_CLEXFLAG     =  0x2
#define KEYWORD_CLEXFLAG      0x4
#define NUMBER_CLEXFLAG       0x8
#define STRING_CLEXFLAG       0x10
#define COMMENT_CLEXFLAG      0x20
#define PPKEYWORD_CLEXFLAG    0x40
#define LINENUM_CLEXFLAG      0x80
#define SYMBOL1_CLEXFLAG      0x100
#define SYMBOL2_CLEXFLAG      0x200
#define SYMBOL3_CLEXFLAG      0x400
#define SYMBOL4_CLEXFLAG      0x800
#define FUNCTION_CLEXFLAG     0x1000
#define NOSAVE_CLEXFLAG      0x2000
#define PARAMETER_CLEXFLAG    0x4000
// NOSAVE lines are treated like comments to
// simplify macro programming.
//#define NOSAVE_CLEXFLAG       0x2000



#define DIR_SIZE_COL      4
#define DIR_SIZE_WIDTH    8
#define DIR_DATE_COL      14
#define DIR_DATE_WIDTH    10
#define DIR_TIME_COL      26
#define DIR_TIME_WIDTH    (6+2*_dbcs())
#define DIR_ATTR_COL      (33+2*_dbcs())
#if __PCDOS__
   #define DIR_ATTR_WIDTH    5
   #define DIR_FILE_COL      (40+2*_dbcs())
#elif __UNIX__
   #define DIR_ATTR_WIDTH    10
   #define DIR_FILE_COL      (45+2*_dbcs())
#endif


/* Each entry in the names symbol table has a type. */
/* The type flags values are below. */
#define PROC_TYPE      0x1
#define VAR_TYPE       0x4
#define EVENTTAB_TYPE    0x8
#define COMMAND_TYPE   0x10
#define GVAR_TYPE      0x20
#define GPROC_TYPE     0x40
#define MODULE_TYPE    0x80
#define PICTURE_TYPE   0x100
#define BUFFER_TYPE    0x200
#define OBJECT_TYPE    0x400
#define OBJECT_MASK    0xf800
#define OBJECT_SHIFT   11
#define INFO_TYPE      0x10000
#define DLLCALL_TYPE   0x40000   /* Entries with this flag MUST also have the
                                    COMMAND_TYPE or PROC_TYPE flag. */
#define DLLMODULE_TYPE 0x80000
#define MISC_TYPE      0x20000000
#define IGNORECASE_TYPE  0x80000000


#define HELP_TYPES   ("proc="PROC_TYPE         " ""picture="PICTURE_TYPE       :+" ":+\
          "bufvar="BUFFER_TYPE     :+" ":+\
          "command="COMMAND_TYPE   " ""misc="MISC_TYPE         :+" ":+\
          "any=-1")

#define HELP_CLASSES  ("window=1 search=2 cursor=4 mark=8 misc=16 name=32":+" ":+\
           "string=64 display=128 keyboard=256 buffer=512"    :+" ":+\
           "file=1024 menu=2048 help=4096 cmdline=8192" :+" ":+\
           "language=16384 mouse=32768 any=-1")

#define PCB_TYPES ("command="COMMAND_TYPE:+" ":+"proc="PROC_TYPE)

/* view id of the internal command retrieve file ".command" */
#define RETRIEVE_VIEW_ID    -8
/* buf  id of the internal command retrieve file ".command" */
#define RETRIEVE_BUF_ID     0
/* View id activated before loading a system file */
/* into the hidden window for system files like .command, .kill, etc. */
#define HIDDEN_VIEW_ID      -9
// Constant window handles
#define _desktop            1
#define _app                2
#define _mdi                3
#define _cmdline            4
#define HIDDEN_WINDOW_ID    5
#define VSWID_STATUS        6

#define TERMINATE_MATCH    1  /* Old convention _file_ */
#define FILE_CASE_MATCH    2  /* _complete=_fposcase */
#define NO_SORT_MATCH      4  /* ns_ */
#define REMOVE_DUPS_MATCH  8  /* __ */
#define AUTO_DIR_MATCH     16
#define ONE_ARG_MATCH      32  // Command or completion supports one argument
                       // with spaces.
#define EXACT_CASE_MATCH   64
#define SMALLSORT_MATCH    128

#define MORE_ARG       "*"      /* Indicate more arguments. */
                        /* '!' indicates last argument. */
#define WORD_ARG       "w"      /* Match what was typed. */
                        /* Look for any file. */
#define NONE_ARG       ""
#define FILE_ARG       ("f:"(FILE_CASE_MATCH|AUTO_DIR_MATCH))
#define MULTI_FILE_ARG (FILE_ARG'*')
#define BUFFER_ARG     ("b:"FILE_CASE_MATCH)
#define COMMAND_ARG    ("c:"EXACT_CASE_MATCH)
#define PICTURE_ARG    "_pic"
#define FORM_ARG       ("_form:"EXACT_CASE_MATCH)
#define OBJECT_ARG     ("_object:"EXACT_CASE_MATCH)
#define MODULE_ARG     "m"
#define DLLMODULE_ARG  '_dll'
              // look for procedure or command.
#define PC_ARG         ("pc:"EXACT_CASE_MATCH)
                   /* look Slick-C tag cmd,proc,form */
#define MACROTAG_ARG   ("mt:"(REMOVE_DUPS_MATCH|TERMINATE_MATCH))
#define MACRO_ARG      ('k:'EXACT_CASE_MATCH)   // User recorded macro
#define PCB_TYPE       (COMMAND_TYPE|PROC_TYPE)
#define PCB_TYPE_ARG   "pcbt"   /* list proc,command, and built-in types. */
#define VAR_ARG        ("v:"EXACT_CASE_MATCH) /* look for variable. Global vars not included.*/
#define ENV_ARG        "e"      /* look for environment variables. */
#define MENU_ARG       ("_menu:"EXACT_CASE_MATCH)
#define HELP_ARG       ("h:"(TERMINATE_MATCH|ONE_ARG_MATCH|NO_SORT_MATCH))
                        /* command,macro,built-in,language */
                        /* the '-' means that duplicates are removed. */
#define HELP_TYPE       (COMMAND_TYPE|PROC_TYPE|MISC_TYPE)
#define HELP_TYPE_ARG  "ht"
#define HELP_CLASS_ARG "hc"
#define COLOR_FIELD_ARG "cf"
/* Match tagged procedure. */
#define TAG_ARG ("tag:"(REMOVE_DUPS_MATCH|SMALLSORT_MATCH|TERMINATE_MATCH))

/******************************OLD ARG2 FLAGS******************************/
#define NCW_ARG2      0    // Ignored. Here for backward compatibility.
                           // Previously: Command allowed when there are no MDI child windows.
#define ICON_ARG2     0x2  // Command allowed when editor control window is iconized
                           // Not necessary if command does not require 
                           // an editor control
#define CMDLINE_ARG2  0x4  // Command supports the command line.

#define MARK_ARG2     0x8  // ON_SELECT psuedo event should pass control on
                           // to this command and not deselect text first.
#define READ_ONLY_ARG2   0x10 // Command is allowed in read-only mode
                              // Not necessary if command does not require 
                              // an editor control
#define QUOTE_ARG2    0x40   // Indicates that this command must be quoted when
                             // called during macro recording.  Needed only if
                             // command name is an invalid identifier or
                             // keyword.
#define LASTKEY_ARG2  0x80   // Command requires last_event value to be set
                             // when called during macro recording.
#define MACRO_ARG2  0x100    // This is a recorded macro command. Used for completion.
#define HELP_ARG2      0     // Ignored. Here for backward compatibility.
#define HELPSALL_ARG2  0     // Ignored. Here for backward compatibility.
#define TEXT_BOX_ARG2  0x800 // Command supports any text box control.
#define NOEXIT_SCROLL_ARG2 0x1000 // Do not exit scroll caused by using scroll bars.
#define EDITORCTL_ARG2 0x2000     // Command supports non-mdi editor control
#define NOUNDOS_ARG2   0x4000   // Do not automatically call _undo('s').
                                // Require macro to call _undo('s') to
                                // start a new level of undo.
#define REQUIRESMDI_ARG2 0x8000  // Command requires mdi interface may be because
                                 // it opens a new file or uses _mdi object.
/********************************************************************/


/******************************NEW ARG2 FLAGS******************************/

/*
   NOTE:
    
   VSARG2_MARK,VSARG2_NOEXIT_SCROLL, 
   VSARG2_READ_ONLY, VSARG2_ICON are now
   ignored if the command does not require an 
   editor control. 
   
       VSARG2_REQUIRES_EDITORCTL 
                or 
       VSARG2_REQUIRES_MDI_EDITORCTL
   
   This is different than versions <= 3.0
*/
#define VSARG2_NCW      0      // Ignored. Here for backward compatibility.
                               // Previously: Command allowed when there are no MDI child windows.
#define VSARG2_CMDLINE  0x4    // Command supports the command line.
                               // VSARG2_CMDLINE allows a fundamental mode 
                               // key binding to be inherited by the command line
#define VSARG2_MARK     0x8    // ON_SELECT event should pass control on
                               // to this command and not deselect text first.
                               // Ignored if command does not require an editor control
#define VSARG2_QUOTE     0x40  // Indicates that this command must be quoted when
                               // called during macro recording.  Needed only if
                               // command name is an invalid identifier or
                               // keyword.
#define VSARG2_LASTKEY  0x80   // Command requires last_event value to be set
                               // when called during macro recording.
#define VSARG2_MACRO     0x100      // This is a recorded macro command. Used for completion.
#define VSARG2_HELP      0          // Ignored. Here for backward compatibility.
#define VSARG2_HELPSALL  0          // Ignored. Here for backward compatibility.
#define VSARG2_TEXT_BOX  0x800      // Command supports any text box control.
                                    // VSARG2_TEXT_BOX allows a fundamental mode 
                                    // key binding to be inherited by a text box
#define VSARG2_NOEXIT_SCROLL 0x1000 // Do not exit scroll caused by using scroll bars.
                                    // Ignored if command does not require an editor control
#define VSARG2_EDITORCTL   0x2000   // Command allowed in editor control.
                                    // VSARG2_EDITORCTL allows a fundamental mode 
                                    // key binding to be inherited by a non-MDI editor control
#define VSARG2_NOUNDOS     0x4000   // Do not automatically call _undo('s').
                                    // Require macro to call _undo('s') to
                                    // start a new level of undo.
// Command allowed when editor control is in strict read only mode
// Ignored if command does not require an editor control
#define VSARG2_READ_ONLY   0x10
// Command allowed when editor control window is iconized
// Ignored if command does not require an editor control
#define VSARG2_ICON        0x2


// Command requires any editor control
#define VSARG2_REQUIRES_EDITORCTL       (VSARG2_REQUIRES_MDI_EDITORCTL|EDITORCTL_ARG2)
#define VSARG2_REQUIRES_MDI_EDITORCTL   0x00010000 // Command requires mdi editor control


#define VSARG2_REQUIRES_AB_SELECTION    0x00020000 // Command requires selection in active buffer
#define VSARG2_REQUIRES_BLOCK_SELECTION 0x00040000 // Command requires block/column selection in any buffer
#define VSARG2_REQUIRES_CLIPBOARD       0x00080000 // Command requires editorctl clipboard
#define VSARG2_REQUIRES_FILEMAN_MODE    0x00100000 // Command requires active buffer to be in fileman mode
#define VSARG2_REQUIRES_TAGGING         0x00200000 // Command requires <ext>_proc_search/find-tag support
//#define VSARG2_REQUIRES_                0x00400000 

#define VSARG2_REQUIRES_SELECTION       0x00800000 // Command requires a selection in any buffer
#define VSARG2_REQUIRES_MDI             0x00008000 // Command requires mdi interface may be because
                                                   // it opens a new file or uses _mdi object.

#define VSARG2_REQUIRES  (VSARG2_REQUIRES_TAGGING|VSARG2_REQUIRES_MDI_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION|VSARG2_REQUIRES_BLOCK_SELECTION|VSARG2_REQUIRES_CLIPBOARD|VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_SELECTION|VSARG2_REQUIRES_MDI)



 //Restore flags
#define RF_CLIPBOARDS 0x1
#define RF_CWD 0x2
#define RF_PROCESS 0x4
#define RF_PROJECTFILES 0x8
#define RF_LINEMODIFY   0x10
#define RF_NOSELDISP    0x20
#define RF_CBROWSER_TREE 0x40

// Horizontal scrolling gets faster over time
#define DEF_CHG_COUNT 10
#define DEF_DEC_DELAY_BY 0
/* DEF_MIN_DELAY=0 */
#define DEF_INC_MAX_SKIP_BY  2
#define DEF_MAX_SKIP  5

/* Fast line scrolling gets faster over time*/
#define DEF_FS_MAX_SKIP 4
#define DEF_FS_INC_MAX_SKIP_BY  2
#define DEF_FS_CHG_COUNT 5

#define INITIAL_LANGUAGE_MARGINS "1 254"   /* initial language margins before */
                                       /* default is set. */
// p_window_flags constants
#define HIDE_WINDOW_OVERLAP 0x1 // Indicates window is hidden window used
                   // for storing system views and buffers.
#define OVERRIDE_CURLINE_RECT_WFLAG 0x4
#define CURLINE_RECT_WFLAG 0x8
#define OVERRIDE_CURLINE_COLOR_WFLAG 0x10
#define CURLINE_COLOR_WFLAG 0x20

/* flags for p_word_wrap_style property */
#define STRIP_SPACES_WWS  1
#define WORD_WRAP_WWS     2
#define JUSTIFY_WWS       4
#define ONE_SPACE_WWS     8

/* Search flags */
#define IGNORECASE_SEARCH           0x1
#define MARK_SEARCH                 0x2
#define POSITIONONLASTCHAR_SEARCH   0x4
#define REVERSE_SEARCH              0x8
#define RE_SEARCH                  0x10
#define WORD_SEARCH                0x20
#define UNIXRE_SEARCH              0x40
#define NO_MESSAGE_SEARCH          0x80
#define GO_SEARCH                 0x100
#define INCREMENTAL_SEARCH        0x200
#define WRAP_SEARCH               0x400
#define HIDDEN_TEXT_SEARCH        0x800
#define SCROLL_STYLE_SEARCH       0x1000
#define BINARYDBCS_SEARCH         0x2000
#define BRIEFRE_SEARCH            0x4000

#define NSPECIAL_KEYS   19 /* Number of special keys. */
#define BACKSPACE_SK  3
#define S_SPACE_K       (256-127)
#define C_CTRL_K        (S_SPACE_K+1)
#define A_ALT_K         (S_SPACE_K+2)
#define C_DOT_K         (S_SPACE_K+3)
#define C_COMMA_K       (S_SPACE_K+4)

#define ALT_KEYS_OFFSET  (S_SPACE_K+17)
#define SPECIAL_KEYS_OFFSET    (ALT_KEYS_OFFSET+128)
#define A_SPECIAL_KEYS_OFFSET  (SPECIAL_KEYS_OFFSET+NSPECIAL_KEYS)
#define C_SPECIAL_KEYS_OFFSET  (A_SPECIAL_KEYS_OFFSET+NSPECIAL_KEYS)
#define S_SPECIAL_KEYS_OFFSET  (C_SPECIAL_KEYS_OFFSET+NSPECIAL_KEYS)
#define A_C_SPECIAL_KEYS_OFFSET  (S_SPECIAL_KEYS_OFFSET+NSPECIAL_KEYS)
#define NFKEYS  12
#define FKEYS_OFFSET     (A_C_SPECIAL_KEYS_OFFSET+BACKSPACE_SK+1)
#define S_FKEYS_OFFSET   (FKEYS_OFFSET+NFKEYS)
#define A_FKEYS_OFFSET   (S_FKEYS_OFFSET+NFKEYS)
#define C_FKEYS_OFFSET   (A_FKEYS_OFFSET+NFKEYS)
#define S_C_FKEYS_OFFSET   (C_FKEYS_OFFSET+NFKEYS)
#define S_C_AZ_OFFSET      (S_C_FKEYS_OFFSET+NFKEYS)
#define S_C_09_OFFSET       (S_C_AZ_OFFSET+26)
#define C_09_OFFSET          (S_C_09_OFFSET+10)
#define S_C_SPECIAL_KEYS_OFFSET  (C_09_OFFSET+10)
#define NMEVENTS2 13
#define NMEVENTS 9
#define MEVENTS_OFFSET (S_C_SPECIAL_KEYS_OFFSET+NSPECIAL_KEYS)
#define S_MEVENTS_OFFSET (MEVENTS_OFFSET+NMEVENTS2)
#define A_MEVENTS_OFFSET (S_MEVENTS_OFFSET+NMEVENTS)
#define C_MEVENTS_OFFSET (A_MEVENTS_OFFSET+NMEVENTS)
#define S_C_MEVENTS_OFFSET (C_MEVENTS_OFFSET+NMEVENTS)
#define ON_FIRST_I   (S_C_MEVENTS_OFFSET+NMEVENTS)

/* Flags for _set_menu_state function. */
#define MF_CHECKED         1
#define MF_UNCHECKED       2
#define MF_GRAYED          4
#define MF_ENABLED         8
#define MF_SUBMENU         16

/* Draw modes.  Windows Rastore Ops.  SetROP2 */
#define DM_NOT             6    /* Invert what is drawn over. */


//#define CFG_PAST_END_OF_LINE   -1
#define CFG_SELECTION          1
#define CFG_WINDOW_TEXT        2
#define CFG_CLINE              3
#define CFG_SELECTED_CLINE     4
#define CFG_MESSAGE            5
#define CFG_STATUS             6
#define CFG_CMDLINE            7
#define CFG_CURSOR             8
//CFG_CMDLINE_SELECT   = 9
//CFG_LIST_BOX_SELECT  = 10
//CFG_LIST_BOX         = 11
//CFG_ERROR
#define CFG_MODIFIED_LINE       13
#define CFG_INSERTED_LINE       14
#define CFG_FUNCTION_HELP       15
//G_INSERTED_LINE      =16
#define CFG_KEYWORD             17
#define CFG_LINENUM             18
#define CFG_NUMBER              19
#define CFG_STRING              20
#define CFG_COMMENT             21
#define CFG_PPKEYWORD           22
#define CFG_SYMBOL1             23
#define CFG_SYMBOL2             24
#define CFG_SYMBOL3             25
#define CFG_SYMBOL4             26
#define CFG_IMAGINARY_LINE      27
#define CFG_NOSAVE_LINE         27
#define CFG_FUNCTION            28
#define CFG_FILENAME            30
#define CFG_HILIGHT             31
#define CFG_ATTRIBUTE           32

// Some configurable fonts that dont have color
#define CFG_MENU                (-1)
#define CFG_DIALOG              (-2)
#define CFG_MDICHILDICON        (-3)
#define CFG_MDICHILDTITLE       (-4)



#define OI_MDI_FORM          1
#define OI_FORM              2
#define OI_TEXT_BOX          3
#define OI_CHECK_BOX         4
#define OI_COMMAND_BUTTON    5
#define OI_RADIO_BUTTON      6
#define OI_FRAME             7
#define OI_LABEL             8
#define OI_LIST_BOX          9
#define OI_HSCROLL_BAR       10
#define OI_VSCROLL_BAR       11
#define OI_COMBO_BOX         12
#define OI_HTHELP            13
#define OI_PICTURE_BOX       14
#define OI_IMAGE             15
#define OI_GAUGE             16
#define OI_SPIN              17
#define OI_MENU              18
#define OI_MENU_ITEM         19
#define OI_TREE_VIEW         20
#define OI_SSTAB             21
#define OI_DESKTOP           22
#define OI_SSTAB_CONTAINER   23
#define OI_EDITOR            24

#define CW_MAX_BUTTON      0x1  // Not yet supported
#define CW_MIN_BUTTON      0x2  // Not yet supported
#define CW_NO_CONTROL_BOX  0x4  // Not yet supported
#define CW_HIDDEN          0x8
#define CW_MINIMIZED       0x10 // Not yet supported.
#define CW_MAXIMIZED       0x20 // Not yet supported.
#define CW_CHILD           0x40
#define CW_PARENT          0x80
/*                   =0x100 */
#define CW_RIGHT_JUSTIFY   0x200
#define CW_LEFT_JUSTIFY    0x400
#define CW_CENTER_JUSTIFY  0x800  // Not yet suported
#define CW_BSDEFAULT       0x1000
#define CW_EDIT            0x2000
#define CW_COMBO_LIST_ALWAYS  0x4000
#define CW_COMBO_NOEDIT    0x8000
#define CW_CLIP_CONTROLS   0x40000

/* Property border styles. p_border_style */
#define BDS_NONE           0
#define BDS_FIXED_SINGLE   1
#define BDS_SIZABLE        2
#define BDS_DIALOG_BOX     3   /* FIXED_DOUBLE */
#define BDS_FIXED_DOUBLE   3   /* Same as DIALOG BOX */
#define BDS_SUNKEN         4
// Picture box only

/* Gauge styles. p_style */
#define PSGA_HORZ_WITH_PERCENT  0
#define PSGA_VERT_WITH_PERCENT  1
#define PSGA_HORIZONTAL         2
#define PSGA_VERTICAL           3

/* Picture styles. p_style. */
#define PSPIC_DEFAULT           0
#define PSPIC_PARTIAL_BUTTON    1
#define PSPIC_AUTO_BUTTON       2
#define PSPIC_AUTO_CHECK        3
/*
    PSPIC_BUTTON is used to create an efficient button (no system window) with
    a caption.
    It is also used to create an image control with a picture that
    does not have a border. This is a way to have toolbar bitmap that has
    two states but only requires a bitmap containing one state.
*/
#define PSPIC_BUTTON            4
// Some addition image control style
#define PSPIC_SIZEVERT          7
#define PSPIC_SIZEHORZ          8
#define PSPIC_GRABBARVERT       9
#define PSPIC_GRABBARHORZ       10
#define PSPIC_TOOLBAR_DIVIDER_VERT 11
#define PSPIC_TOOLBAR_DIVIDER_HORZ 12
#define PSPIC_FLAT_BUTTON          13

/* Scroll bar style. p_scroll_bars */
#define SB_NONE         0
#define SB_HORIZONTAL   1
#define SB_VERTICAL     2
#define SB_BOTH         3

/* Validate styles. p_validate_style. Effects text box and combo box. */
#define VS_NONE     0
#define VS_INTEGER  1

/* Init styles. p_init_style. Effects form. */
#define IS_NONE        0x0
#define IS_SAVE_XY     0x1
#define IS_REINIT      0x2
#define IS_HIDEONDEL   0x4

/* p_indent_style. p_init_style.. */
#define INDENT_NONE        0
#define INDENT_AUTO        1
#define INDENT_SMART       2

/* max click style. p_max_click */
#define MC_SINGLE   0
#define MC_DOUBLE   1
#define MC_TRIPLE   2

/* Multi select style. p_multi_select */
#define MS_NONE          0
#define MS_SIMPLE_LIST   1
#define MS_EXTENDED      2
#define MS_EDIT_WINDOW   3

/* Mouse pointer styles. p_mouse_pointer */
#define MP_DEFAULT   0
#define MP_ARROW     1
#define MP_CROSS     2
#define MP_IBEAM     3
#define MP_ICON      4
#define MP_SIZE      5
#define MP_SIZENESW  6
#define MP_SIZENS    7
#define MP_SIZENWSE  8
#define MP_SIZEWE    9
#define MP_UP_ARROW  10   // Translated to MP_ARROW by OS/2 version
#define MP_HOUR_GLASS 11
#define MP_LISTBOXBUTTONSIZE 243
#define MP_NODROP     244
#define MP_ALLOWCOPY  245
#define MP_ALLOWDROP  246
#define MP_SIZEHORZ   247
#define MP_SIZEVERT   248
#define MP_LEFTARROW_DROP_TOP 249
#define MP_LEFTARROW_DROP_BOTTOM 250
#define MP_LEFTARROW_DROP_RIGHT 251
#define MP_LEFTARROW_DROP_LEFT 252
#define MP_LEFTARROW 253
#define MP_RIGHTARROW 254
#define MP_MOVETEXT 255
/* MP_NODROP   =12  not available yet. */

/* Alignment styles. */
#define AL_MASK         3     // left,right,center mask
#define AL_LEFT         0
#define AL_RIGHT        1
#define AL_CENTER       2
#define AL_VCENTER      4
#define AL_VCENTERRIGHT 5
#define AL_CENTERBOTH   6

/* Check box style. p_style. */
#define PSCH_AUTO2STATE   0
#define PSCH_AUTO3STATEA  1    /* Gray, check, uncheck. */
#define PSCH_AUTO3STATEB  2    /* Gray, uncheck, check */
/* Combo box style. p_style. */
#define PSCBO_EDIT         0    /* Standard.  List drops down. */
#define PSCBO_LIST_ALWAYS  1    /* List is always present. Can edit. */
#define PSCBO_NOEDIT       2    /* Must select list item to modify text box. */

/* Scale modes.  Setting the scale mode not support. */
//SM_USER    = 0
#define SM_TWIP      1
#define SM_PIXEL     3

#define VSM_CYCAPTION   4
#define VSM_CXDLGFRAME  7     // non-sizable dialog box border
#define VSM_CYDLGFRAME  8
#define VSM_CYMENU      15    // Height of menu if using system default font.
                     // OS/2 and X Windows menu font may be different.
#define VSM_CXFRAME     32    // Sizable border. */
#define VSM_CYFRAME     33
#define VSM_CXSIZE      30    // Min/max button */
#define VSM_CYSIZE      31
#define VSM_CXVSCROLL   20    // Default Vertical scroll bar width
#define VSM_CYHSCROLL   21    // Default horizontal scroll bar height
#define VSM_CYSMCAPTION 51    // Small caption height



/* message box support. If you use other built-in windows*/
/* flags, they will not be supported on other platforms. */
#define MB_ICONMASK         0x000000F0
#define MB_MODEMASK         0x00003000

#define MB_OK               0x00000000
#define MB_OKCANCEL         0x00000001
#define MB_ABORTRETRYIGNORE 0x00000002   /* Not supported on UNIX */
#define MB_YESNOCANCEL      0x00000003
#define MB_YESNO            0x00000004
#define MB_RETRYCANCEL      0x00000005   /* Not supported on UNIX*/
#define MB_ICONHAND         0x00000010
#define MB_ICONQUESTION     0x00000020
#define MB_ICONEXCLAMATION  0x00000030
#define MB_ICONINFORMATION  0x00000040
#define MB_ICONSTOP         MB_ICONHAND
#define MB_ICONNONE         MB_ICONMASK
#define MB_DEFBUTTON1       0x00000000
#define MB_DEFBUTTON2       0x00000100
#define MB_DEFBUTTON3       0x00000200

#define MB_SYSTEMMODAL      0x00001000   /* Not supported on UNIX or OS/2*/
//MB_MODAL           =0x00002000  // MB_TASKMODAL
//MB_MODELESS        =MB_MODEMASK

#define IDOK     1
#define IDCANCEL 2
#define IDABORT  3
#define IDRETRY  4
#define IDIGNORE 5
#define IDYES    6
#define IDNO     7

/* p_draw_style */
#define PSDS_SOLID            0
#define PSDS_DASH             1
#define PSDS_DOT              2
#define PSDS_DASHDOT          3  // May only be supported on MS Windows
#define PSDS_DASHDOTDOT       4  // May only be supported on MS Windows
#define PSDS_NULL             5  // May only be supported on MS Windows
#define PSDS_INSIDE_SOLID     6

/* p_draw_mode */
#define PSDM_BLACK            1
#define PSDM_NOTMERGEPEN      2
#define PSDM_MASKNOTPEN       3
#define PSDM_NOTCOPYPEN       4
#define PSDM_MASKPENNOT       5
#define PSDM_NOT              6
#define PSDM_XORPEN           7
#define PSDM_NOTMASKPEN       8
#define PSDM_MASKPEN          9
#define PSDM_NOTXORPEN        10
#define PSDM_NOP              11
#define PSDM_MERGENOTPEN      12
#define PSDM_COPYPEN          13
#define PSDM_MERGEPENNOT      14
#define PSDM_MERGEPEN         15
#define PSDM_WHITE            16

/* p_fill_style */
#define PSFS_TRANSPARENT      1
#define _HANDLE_WIDTH  75    /* twips width of dialog editor handle. */
#define _HANDLE_HEIGHT 75    /* twips height of dialog editor handle. */

/* Names dialog editor tool bar bitmap files with .bmp extension. */
#define DE_ARROW '_arrow'
#define DE_LABEL '_labelb'
#define DE_TEXT_BOX '_textbox'
#define DE_EDIT_WINDOW '_editwin'
#define DE_FRAME '_frameb'
#define DE_COMMAND_BUTTON '_cmdbtn'
#define DE_RADIO_BUTTON '_radbtn'
#define DE_CHECK_BOX '_checkbx'
#define DE_COMBO_BOX '_combobx'
#define DE_LIST_BOX '_listbox'
#define DE_VSCROLL_BAR '_vscroll'
#define DE_HSCROLL_BAR '_hscroll'
#define DE_DRIVE_LIST '_drvlist'
#define DE_FILE_LIST '_fillist'
#define DE_DIRECTORY_LIST '_dirlist'
#define DE_PICTURE_BOX '_picture'
#define DE_NONE '.'
#define DE_IMAGE '_imageb'
#define DE_GAUGE '_gaugeb'
#define DE_SPIN '_spinb'
#define DE_TREE_VIEW '_tree'
#define DE_SSTAB '_sstabb'
#define DE_SSTAB_CONTAINER '_sstabb_container'
#define DEBITMAP_LIST (\
    DE_ARROW'='0' ':+\
    DE_NONE'='0' ':+\
    DE_LABEL'='OI_LABEL' ':+\
    DE_SPIN'='OI_SPIN' ':+\
    DE_TEXT_BOX'='OI_TEXT_BOX' ':+\
    DE_EDIT_WINDOW'='OI_EDITOR' ':+\
    DE_FRAME'='OI_FRAME' ':+\
    DE_COMMAND_BUTTON'='OI_COMMAND_BUTTON' ':+\
    DE_RADIO_BUTTON'='OI_RADIO_BUTTON' ':+\
    DE_CHECK_BOX'='OI_CHECK_BOX' ':+\
    DE_COMBO_BOX'='OI_COMBO_BOX' ':+\
    DE_LIST_BOX'='OI_LIST_BOX' ':+\
    DE_VSCROLL_BAR'='OI_VSCROLL_BAR' ':+\
    DE_HSCROLL_BAR'='OI_HSCROLL_BAR' ':+\
    DE_DRIVE_LIST'='OI_COMBO_BOX' ':+\
    DE_FILE_LIST'='OI_LIST_BOX' ':+\
    DE_DIRECTORY_LIST'='OI_LIST_BOX' ':+\
    DE_PICTURE_BOX'='OI_PICTURE_BOX' ':+\
    DE_GAUGE'='OI_GAUGE' ':+\
    DE_IMAGE'='OI_IMAGE' ':+\
    DE_SSTAB'='OI_SSTAB' ':+\
    DE_TREE_VIEW'='OI_TREE_VIEW)

#define LB_PICTURE_RE '(^?+\: *)'
//#define LB_RE '(^? *)'
#define LB_RE '^?'

#define CBF_TEXT 1
#define CBF_VSTEXT "VSTEXT"
#define CBF_VSCONTROLS "VSCONTROLS"


#define DRIVE_NOROOTDIR  1
#define DRIVE_REMOVABLE  2
#define DRIVE_FIXED      3
#define DRIVE_REMOTE     4
#define DRIVE_CDROM      5
#define DRIVE_RAMDISK    6

//  Arguments to Combo Box ON_CHANGE event.
// These events are generated by macros and are
// not hard wired into the editor
#define CHANGE_OTHER 0         // Text box value changed.
#define CHANGE_CLINE 1         // Text box value changed by
                    // changing selected line in list.
#define CHANGE_CLINE_NOTVIS 2  // Text box value changed by
                    // changing selected line while
                    // list is invisible
#define CHANGE_CLINE_NOTVIS2 3 // Text box value changed by
                    // changing selected line while
                    // list is invisible. Sent to user level 2
                    // inheritance only.

#define CHANGE_BUTTON_PRESS  4 //List box with buttons on it



//  Arguments to List Box ON_CHANGE event.
#define CHANGE_SELECTED 10     // User's selection has changed
#define CHANGE_PATH 11         // Path was changed in a directory
                    // list box
#define CHANGE_FILENAME 12      // filename was changed in file
                    // list box
#define CHANGE_DRIVE 13         // Drive changed in drive combo box

#define CHANGE_EXPANDED 14      // A tree node was expanded
#define CHANGE_COLLAPSED 15     // A tree node was collapsed
#define CHANGE_LEAF_ENTER 16    // User pressed enter on leafs tree node
                                // If you want ENTER for nodes and leaves,
                                // define your own ENTER key.
#define CHANGE_SCROLL 17

// Arguments to Spin ON_CHANGE event
#define CHANGE_NEW_FOCUS 20     // Called before ON_SPIN_UP and ON_SPIN_DOWN
                     // event.  Return '' or window id
                     // of control to get focus.

// Arguments to SSTAB ON_CHANGE event
#define CHANGE_TABDEACTIVATED 30  // New tab was selected in the tab control
#define CHANGE_TABACTIVATED 31  // New tab was selected in the tab control


// Arguments to Combo Box ON_DROP_DOWN event.
// These events are generated by macros and are
// not hard wired into the editor
#define DROP_UP    0     // After combo list box is made invisible
#define DROP_DOWN  1     // Before combo list box is made visible
#define DROP_INIT  2     // Before retrieve next/previous.  Used to initialize
              // the list box before is used.
#define DROP_UP_SELECTED 3     // Mouse release while on valid
                    // selection in list box
                    // and list is visible
// boolean values
#define TRUE 1
#define FALSE 0


// Open file dialog flags
#define OFN_ALLOWMULTISELECT  0x1  // Allow multiple file selection
                        // When set, user must process
#define OFN_FILEMUSTEXIST     0x2  // File(s) selected must exist
#define OFN_CHANGEDIR         0x4  // Ignored for backward compatibility

#define OFN_NOOVERWRITEPROMPT 0x8  // Don't prompt user with overwrite exisiting dialog. */
#define OFN_SAVEAS            0x10 // File list box does not select files and
                        // user is prompted whether to overwrite an
                        // existing file.
#define OFN_DELAYFILELIST     0x20 // Display dialog box before displaying
                        // list.
#define OFN_NODELWINDOW       0x40 // Open file dialog is not deleted
                        // when user selects cancel. Instead
                        // window is made invisible.
#define OFN_READONLY          0x80  // Show read only button. Can't be used
                         // with OFN_READONLY
                         // See OFN_PREFIXFLAGS flag
#define OFN_KEEPOLDFILE       0x100 // Show keep old name button
                         // See OFN_PREFIXFLAGS flag
#define OFN_PREFIXFLAGS       0x200 // Prefix result with -r if
                         // OFN_READONLY flag given and -n if
                         // OFN_KEEPOLDFILE flag given and -a if
                         // OFN_APPEND given.
#define OFN_SAVEAS_FORMAT     0x400
#define OFN_SET_LAST_WILDCARDS 0x800
#if 0
      #define OFN_KEEPDIR           0x400 // Show keep dir check box
#endif
#define OFN_NOCHANGEDIR        0x1000  // Dont' show Change dir check box

#define OFN_APPEND            0x2000 // Show append button.

#define EDC_OUTPUTINI       0x1
#define EDC_OUTPUTSTRING    0x2
//EDC_OUTPUTBUFFER =0x4
//EDC_OUTPUTFILE   =0x8
#define EDC_INPUTINI        0x10
#define EDC_INPUTSTRING     0x20
//EDC_INPUTBUFFER  =0x40
//EDC_INPUTFILE    =0x80

// Selection list dialog flags
#define SL_ALLOWMULTISELECT  0x1
#define SL_NOTOP             0x2
#define SL_VIEWID            0x4   // View always deleted.
#define SL_FILENAME          0x8
#define SL_NOISEARCH         0x10
#define SL_NODELETELIST      0x20  // Can preserve buffer this way
#define SL_SELECTCLINE       0x40  // Select current line.
#define SL_MATCHCASE         0x80  // Case sensitive i-search
#define SL_INVERT            0x8000// Invert button for muli-select
#define SL_SELECTALL         0x100 // Select all button for multi-select
#define SL_HELPCALLBACK      0x200
#define SL_DEFAULTCALLBACK   0x400 // Call the callback routine when enter
                           // pressed
#define SL_COMBO             0x800 // Display combo box above list box
#define SL_MUSTEXIST         0x1000
#define SL_BUFID             0x2000
#define SL_DESELECTALL       0x4000  // Deselect all before selecting anything
#define SL_NORETRIEVEPREV    0x10000 // Don't retrieve last combo box value
                             // By default, last combo box value
                             // is restored when initial_value not given.
                             // Has no effect if SL_COMBO not given
#define SL_COLWIDTH          0x20000 // Computer largest first column text string
                                     // and set up two columns
#define SL_SELECTPREFIXMATCH 0x40000 // Effects SL_COMBO only.
                                     // When typing in the combo box
                                     // and text is a prefix match
                                     // of the text in the list box,
                                     // list box line is selected.
#define SL_CLOSEBUTTON       0x80000  // Use Close instead of Cancel button

// Selection list call back events
#define SL_ONINIT       1   // Dialog being initialized
#define SL_ONDEFAULT    2   // Enter pressed and SL_DEFAULTCALLBACK specified
#define SL_ONLISTKEY    3   // List box fall through key
#define SL_ONUSERBUTTON 4   // User button pressed
#define SL_ONSELECT     5   // Select item(s) changed
#define SL_ONINITFIRST  6   // First Dialog initialized callback, before autosizing

// save() and file() argument 2 flags
#define SV_RETURNSTATUS      0x1
#define SV_OVERWRITE         0x2
#define SV_POSTMSGBOX        0x4 /* Required when unsafe to display message box. */
#define SV_RETRYSAVE         0x8

// _tprint flags
#define TPRINT_FORM_FEED_AFTER_LAST_PAGE  0x1

// _print() print_flags
#define PRINT_LEFT_HEADER     0
#define PRINT_RIGHT_HEADER    1
#define PRINT_CENTER_HEADER   2
#define PRINT_LEFT_FOOTER     (0<<2)
#define PRINT_RIGHT_FOOTER    (1<<2)
#define PRINT_CENTER_FOOTER   (2<<2)
#define PRINT_TWO_UP          0x10
#define PRINT_COLOR           0x20
#define PRINT_FONTATTRS       0x40
#define PRINT_VISIBLEONLY     0x80
#define PRINT_HEX             0x100

// _print() call back events
#define PRINT_ONINIT    0
#define PRINT_ONEXIT    1
#define PRINT_ONPAGE    2
// _font_type() flags.

#define RASTER_FONTTYPE      0x001
#define DEVICE_FONTTYPE      0x002
#define TRUETYPE_FONTTYPE    0x004
#define FIXED_FONTTYPE       0x008
#define OUTLINE_FONTTYPE     0x100
#define KERNING_FONTTYPE     0x200

// Font flags
#define F_BOLD   0x1
#define F_ITALIC 0x2
#define F_STRIKE_THRU  0x4
#define F_UNDERLINE    0x8
#define F_PRINTER      0x200
// _choose_font() flags
#define CF_SCREENFONTS   0x00000001
#define CF_PRINTERFONTS  0x00000002
#define CF_EFFECTS       0x00000100
#define CF_FIXEDPITCHONLY   0x00004000

#define TB_RETRIEVE       0x1
#define TB_RETRIEVE_INIT  (0x2|TB_RETRIEVE)
#define TB_VIEWID_INPUT   0x4
#define TB_VIEWID_OUTPUT  0x8
#define TB_QUERY_COMPAT   0x10

// Name info flags for form objects
#define FF_MODIFIED        0x1
#define FF_SYSTEM          0x2

// _sys_help options
#define HELP_CONTEXT       0x0001    /* Display topic in ulTopic */
//HELP_QUIT      = 0x0002  /* Terminate help */
#define HELP_CONTENTS      0x0003
#define HELP_HELPONHELP    0x0004  /* Display help on using help */
//HELP_SETINDEX  =   0x0005  /* Set current Index for multi index help */
//HELP_SETCONTENTS = 0x0005
//HELP_CONTEXTPOPUP= 0x0008
#define HELP_FORCEFILE     0x0009    /* Load a help file */
#define HELP_KEY           0x0101    /* Display topic for keyword in offabData */
//HELP_COMMAND    =  0x0102
#define HELP_PARTIALKEY    0x0105
//HELP_MULTIKEY   =  0x0201
//HELP_SETWINPOS  =  0x0203
#define HELP_INDEX         0xf001
#define HELP_VALIDATE       0xf002
#define HELP_TITLE          0xf003  //Used vshlp.dll to get windows help file title

// Undo flags
#define LINE_DELETES_UNDONE      1
#define CURSOR_MOVEMENT_UNDONE   2
#define MARK_CHANGE_UNDONE       4
#define TEXT_CHANGE_UNDONE       8
#define LINE_INSERTS_UNDONE      16
#define MODIFY_FLAG_UNDONE       32
#define LINE_FLAGS_UNDONE        64
#define FILE_FORMAT_CHANGE_UNDONE   128
#define COLOR_CHANGE_UNDONE          256

typeless _argument;      // '' or integer count used by some commands.
                         // Set by argument command.
typeless _arg_complete   /* Completion functions may set this var to non-zero */
                         /* value to indicate that more typing is necessary */
                         /* Ex. '\macros\' is not a complete file spec. */

int _cua_select;     // Indicates that selection was done with mouse or
                         // shift-arrow keys or search
//
// Initial values for variables below are defined in "main.e"
//
 _str
   _help_file_spec             /* Path to 'slick.doc' */
   ,def_load_options           /* Default load options. Don't load entire file.*/
   ,def_save_options           /* Default save options. Backup overwritten files*/
   ,def_tab_ext                /* Defaults file extensions to be saved */
                               /* with tabs. */
   ,def_preload_ext            /* Default file extensions to be pre-loaded */
                               /* to allow eof character in middle of file. */
   ,def_select_style           /* Default select style. */
   ,def_persistent_select
   ,def_advanced_select
   ,def_word_chars       /* Specifies word characters used by */
                         /* next word, prev word and searching. */
   ,def_line_insert      /* 'B' or 'A'. Default line insert style [Before,After] */
   ,def_user_args        /* User defined completion equates. */
   ,_error_file          /* Absolute name of error file. */
   ,_grep_buffer         /* Absolute name of multi-file find output buffer. */
   ,def_keys             /* Name of active emulation keys help item. */
#if __PCDOS__
   ,_fpos_case           /* 'i' if file system is case insensitive. */
                         /* Otherwise ''. */
#else
   ,_fpos_case            /* UNIX file system is case sensitive. */
#endif
   ,_macro_ext           /* Macro source code extension with . */
                         /* SLICKEXT envvar may set this. */
   ,_tag_pass            // Number of passes.  May be used by "ext"_proc_search(). */
                         // Initialized to one before first call.
                         // perl.e places several 3 values in this string.

   ,def_file_types
   ,def_one_file        //  One file per window.
    // Edit window/list box vertical scroll speed.
    // Scrolling gets faster as move mouse further past edge
    // Timer delay, Number of lines to skip.
   ,def_scroll_speeds
   ,def_next_word_style  //Determines whether prev-word and
                         //next-word (C-right & C-left) move to the
                         //beginning or end of the word.
   ,def_pmatch_style2    // 0-MoveCursor,1-Highlight,None-'' What to do when type
                         // close paren
                         // If !=0, alt+letter invokes menu bar drop-down
   ,def_wh               // Help files used by wh,wh2,wh3 commands
   ,def_who              // OS/2 help files used by wh,wh2,wh3 commands
   ,def_mdi_menu         // Name of default MDI menu bar
   ,_cur_mdi_menu        // Current name of MDI menu.
   ,def_keydisp          // Menu/Bind key display.  L- Long C- Condensed
   ,_project_name        // Name of open project.  '' if not project open
         // Timer amounts separated by spaces
         // inactive_amount absolute_amount config_amount
   ,def_as_timer_amounts //
   ,def_as_directory     // AutoSave directory
   ,def_mffind_style
   ,COMPILE_ERROR_FILE
   ,def_mdibb   // Name of default button bar
   ,def_max_loadall   // "<on/off> <ksize>". Load files larger than ksize
   // Under OS/2 Menu font can be changed by droping configured ICON onto
   // editor.  Record original font and check if it changes.
   ,_origMdiMenuFont
   ,def_macfiles  // Space delimited list of macro files that were loaded
                  // and did not exist in the original state file
                  // DO NOT SPECIFY A PATH for any file added.
                  // Slick-C macros must have ".ex" extension.
                  // DLL files must have extension specified if there
                  // is one.
                  // Filenames with spaces are in double quotes.
   ,def_deselect_copy
   ,def_sellist_font   // non-japanese default selection list font
   ,def_jsellist_font  // Japanese default selection list font
   ,def_color_scheme
   ,def_embedded_color_scheme;

_str  // The configuration variables below should have been boolean but
      // are not for backward compatibility with VS user configuration files.
      // For these strings "0" is false and all other string values are true.
   def_scursor_style     // boolean string. Shift+<cursor key> style.  0 specifies character selection.
   ,def_exit_process     // boolean string. Try to exit process buffer option.
   ,def_prompt           // boolean string. Prompt commands with GET_STRING switch.
   ,def_qmark_complete   // boolean string. Indicates whether '?' is used for completion
   ,def_top_bottom_style // boolean string. Preserve Column when going to top | bottom
   ,def_leave_selected   // boolean string.  Leave search string selected
   ,def_gui              // boolean string. Modified by guisetup macro
   ,def_alt_menu         // boolean string. Determines how to bind alt-keys
   ,def_modal_tab        // boolean string. If non-zero and text is selected, text is indented
   ,def_cua_textbox      // boolean string. Determines whether text box is CUA.

_str _proc_found;         // Name of procedure found by next_proc or prev_proc commands
// Some UNIX text mode printing strings.
_str def_tprint_cheader
   ,def_tprint_cfooter
   /*
   options -->   print_flags,blank_lines_after_header,
                 blank_lines_before_footer,lines_per_page,
                 columns_per_line,linenums_every,
   */
   ,def_tprint_options
   ,def_tprint_lheader,def_tprint_lfooter
   ,def_tprint_rheader,def_tprint_rfooter
   ,def_tprint_command
   ,def_tprint_filter
   ,def_tprint_device
   ,def_leading_codes
   ,def_trailing_codes

boolean def_enter_indent;
int def_change_dir;      // Change directory in open and save as dialog boxes
boolean def_cursorwrap;  //Cursor left/right wrap
boolean def_hack_tabs;   //Back space deletes tab characters 1 column at
                         //at a time (No jump).
boolean def_restore_cursor;   //Cursor Position is restored after a replace
int def_updown_col;       //Cursor stays in straight line when moving up
boolean def_reflow_next;  //After reflow-paragraph command place cursor on
                          //Next paragraph
boolean def_pmatch_style;     //Set to 0 for fast brace matching
boolean def_stay_on_cmdline;
boolean def_delay_filelist;   //Delay inserting of filelist in openfile
                             //dialog until user is done typing filename.
boolean def_start_on_cmdline;
boolean def_start_on_first;   //When editing 'A B C' start on A
boolean def_exit_file_list;   //No file list when exiting w/modified buffers
boolean def_deselect_paste;
int def_auto_restore;           /* Default resume last edit session. */
boolean def_pull;             //backspace pulls characters event when in replace mode
boolean def_jmp_on_tab;       //Cursor Jumps over Tab characters
boolean def_linewrap;    //Determines whether cursor-left command wraps
                         // to column 1 when left margin greater than 1
boolean def_ignore_tcase;     //Ignore case on tags for all languages
boolean def_keep_dir;         //Open file dialog keep dir check box value.
boolean def_from_cursor;     // Set to true in EMACS emul. Effects some word functions.
boolean def_unix_expansion;  // Expand ~ and $ like UNIX shells.
boolean def_process_tab_output;  // Default concurrent process buffer output to tab in output toolbar
int def_help_flags;
int def_mouse_menu_style;
int def_cd;
int def_max_filehist;     // Maximium files listed under File menu
int def_ctags_flags;          /* BITWISE flags that are checked in vsc_proc_search()
                                   1 = Do NOT skip over function definitions/prototypes
                                       that do not have a semicolon or open brace
                                       following the parameter list.  C++ source code
                                       that uses Microsoft MFC macro definitions are
                                       one of the reasons a user may want to skip over
                                       these types of definitions.  Set this option
                                       when you do not want old C-style function definitions
                                       skipped.

                                   2 = Tag C/C++ prototypes.
                                   
                                   4 = Do not skip over old style C/C++ prototypes
                                       that do not have an explicit return type.
                                       This should be off in order for local-variable
                                       search to work properly, otherwise it is very
                                       difficult to distinguish a function call from
                                       a prototype.
                               */
boolean def_brief_word;     // If true, Brief style select word and delete word,

int def_actapp;           // Activate application options
#if __UNIX__
   #define TAG_DEFAULT_BUFFER_RETAG_INTERVAL 6000
#else 
   #define TAG_DEFAULT_BUFFER_RETAG_INTERVAL 3000
#endif 
int def_buffer_retag;
_str def_bgtag_options;   //Options for background FILE tagging
#define ACTAPP_AUTORELOADON 0x1
#define ACTAPP_SAVEALLONLOSTFOCUS 0x2
#define ACTAPP_NORELOADPROMPT 0x4
#define ACTAPP_WARNONLYIFBUFFERMODIFIED 0x8
#define ACTAPP_AUTOREADONLY 0x10

int def_as_flags;  // AutoSave flags.
int def_restore_flags;
int def_init_delay;
int _display_wid;    //  Window id of properties being displayed.
int def_clipboards;       // Default maximum number of clipboards.
int def_read_ahead_lines; // Default lines to read from disk when scrolling.
int def_vcpp_version;     // Version of Visual C++ being used by user
// BITMAP handles
int _pic_drremov;        /* Floppy drive bitmap for drive list. */
int _pic_drfixed;        /* Fixed drive bitmap for drive list. */
int _pic_drcdrom;        /* CD rom drive bitmap for drive list. */
int _pic_cbarrow;        /* Combo box arrow bitmap */
int _pic_cbdots;         /* Combo box dot dot dot bitmap. */
int _pic_cbdis;          /* Combo box disabled arrow. */
int _pic_fldclos;        /* Closed file folder bitmap. */
int _pic_fldaop;         // Active openned file folder bitmap
int _pic_fldopen;        // Openned file folder bitmap
int _pic_tt;             // True Type font bitmap
int _pic_printer;        // Printer font bitmap
int _pic_lbplus;         // List box Plus bitmap
int _pic_lbminus;        // List box Minus bitmap
int _pic_lbvs;           // List Box Visual SlickEdit
int _pic_file;           // _file bitmap used by tree view control
int _pic_file_d;         // _file bitmap used by tree view control, looks disabled
int _pic_project;        // _project bitmap used by project toolbar
int _pic_func;           // Fx bitmap for the tree control
int _pic_sm_func;        // smaller version of Fx bitmap for the tree control
int _pic_sm_file;        // smaller version of _file bitmap used by tree view control
int _pic_sm_file_d;      // looks disabled
//Bitmaps for multi-file diff
int _pic_file_match;     // Just a file bitmap, files match, copied so we can have a message
int _pic_filed;          // Red, for different files
int _pic_filed2;         // Blue, different files the user has viewed
int _pic_filem;          // Has a minus sign, file does not exist
int _pic_filep;          // File with a plus.  File only exists in this path
int _pic_fldopenp;       // Folder with a plus.  Direcetory only exists in this path
int _pic_fldopenm;       // Folder with a minus.  Direcetory does not exist
int _pic_diffzs2;        // Diffzill bitmap


//New Project toobar bitmaps for files under SCC
int _pic_vc_co_user_w;           // File under version control checked out by user, writable
int _pic_vc_co_user_r;           // File under version control checked out by user, read-only
int _pic_vc_co_other_m_w;        // File under version control checked out by other user multiple, writable
int _pic_vc_co_other_m_r;        // File under version control checked out by other user multiple, read-only
int _pic_vc_co_other_x_w;        // File under version control checked out by other user exclusive, writable
int _pic_vc_co_other_x_r;        // File under version control checked out by other user exclusive, read-only
int _pic_vc_available_w;         // File under version control not checked writable
int _pic_vc_available_r;         // File under version control not checked read-only
int _pic_doc_w;                  // File NOT under version control writable
int _pic_doc_r;                  // File NOT under version control read-only
int _pic_tfldclos;               // "Tall" closed folder to match the new file bitmaps
int _pic_tfldopen;               // "Tall" open folder to match the new file bitmaps
int _pic_tproject;               // "Tall" _project bitmap used by project toolbar

int def_max_filepos;
int _default_keys;               /* Index of default-keys key table. */
int def_compile_flags;
    #define COMPILEFLAG_CLEARPROCESSBUFFER 1
    #define COMPILEFLAG_CDB4COMPILE 0x2
_str def_save_on_compile;
int def_max_fhlen;        // Maximum length of filenames under menus
boolean _no_mdi_bind_all;  // When non-zero, menu_mdi_bind_all call is
                           // ignored.
int def_err;    // Boolean which indicates whether error
                // processing commands should try to look
                // for bufname.err files.
int def_mfsearch_init_flags; // Search init flags.

int def_exit_flags;
int def_re_search;   // Set to RE_SEARCH or UNIXRE_SEARCH
boolean def_autoclipboard  // When on, text selected with the mouse are copied to the
                           // clipboard.
boolean def_flush_repeats;
boolean _in_quit;   // In quit command
boolean _in_project_close;   // In project-close command
boolean _in_exit_list;
boolean _in_help;            // prompt not reentrant.
int def_max_autosave;  //Largest file in K to autosave
boolean def_dragdrop;
int def_pmatch_max_diff;

   #define EXIT_CONFIG_ALWAYS 0x1
   #define EXIT_CONFIG_PROMPT 0x2
   //EXIT_CONFIG_NEVER =0x4,
   //EXIT_FILES_ALWAYS =0x8,
   //EXIT_FILES_PROMPT =0x10,
   //EXIT_FILES_NEVER  =0x20,
   #define EXIT_CONFIRM       0x40


typeless
   _param1          //Modal Dialog Box Result Parameter 1
   ,_param2         //Modal Dialog Box Result Parameter 2
   ,_param3         //Modal Dialog Box Result Parameter 3
   ,_param4         //Modal Dialog Box Result Parameter 4
   ,_param5         //Modal Dialog Box Result Parameter 5
   ,_param6         //Modal Dialog Box Result Parameter 6
   ,_param7         //Modal Dialog Box Result Parameter 7
   ,_param8         //Modal Dialog Box Result Parameter 8
   ,_param9         //Modal Dialog Box Result Parameter 9
   ,_param10        //Modal Dialog Box Result Parameter 10
   ,_param11        //Modal Dialog Box Result Parameter 11
   ;

#define HF_CLOSE 0x1
#define HF_EXACTMATCH 0x2
#define HF_USEDEFAULT 0x4

#define EDIT_DEFAULT_FLAGS  (VCF_AUTO_CHECKOUT|EDIT_RESTOREPOS)
#define VCF_AUTO_CHECKOUT   0x1  // This flag must not overlap with EDIT_??? flag
#define VCF_EXIT_CHECKIN    0x2
#define VCF_SET_READ_ONLY   0x4
#define EDIT_RESTOREPOS     0x4
#define EDIT_NOADDHIST      0x8
#define EDIT_NOSETFOCUS     0x10
#define EDIT_NOUNICONIZE    0x20


#define AS_ON               0x2   // AutoSave is on
#define AS_ASDIR            0x4   // AutoSave to different directory
#define AS_SAMEFN           0x8   // AutoSave to same file
#define AS_DIFFERENT_EXT    0x10  // AutoSave to Generated extension
#define AS_SAVE_WINDOWS     0x20  // AutoSave window configuration

#define VPM_LEFTBUTTON   0x0000
#define VPM_RIGHTBUTTON  0x0002
#define VPM_LEFTALIGN    0x0000
#define VPM_CENTERALIGN  0x0004
#define VPM_RIGHTALIGN   0x0008

#define SC_SIZE         0xF000
#define SC_MOVE         0xF010
#define SC_MINIMIZE     0xF020
#define SC_MAXIMIZE     0xF030
#define SC_NEXTWINDOW   0xF040
#define SC_PREVWINDOW   0xF050
#define SC_CLOSE        0xF060
#define SC_RESTORE      0xF120

// Flags for _lineflags() function
#define EMBEDDEDLANGAUGEMASK_LF 0xE0

// Mask multi-line comments, strings, and embedded languages
#define MULTILINEINFOMASK_LF  0xff

// Mask multi-line comments, strings
#define COMMENTINFOMASK_LF  0x1f

#define MLCOMMENTINDEX_LF   0x18   //Indicates which multi-line comment.
                          //Only four are allowed. Must know which
                          //multi-line comment we are in so we know
                          //what will terminate it.
#define MLCOMMENTLEVEL_LF   0x07   //Indicates multi-line comment nest level

#define CURLINEBITMAP_LF  0x00000200   //Line has been modified
#define MODIFY_LF         0x00000400   //Line has been modified
#define INSERTED_LINE_LF  0x00000800   //Line was inserted
#define HIDDEN_LF         0x00001000
#define MINUSBITMAP_LF    0x00002000
#define PLUSBITMAP_LF     0x00004000
#define NEXTLEVEL_LF      0x00008000
#define LEVEL_LF          0x001F8000
#define NOSAVE_LF         0x00200000   //Display this line in no save color
#define VIMARK_LF         0x00400000   //Used by VImacro to mark lines

#define LINEFLAGSMASK_LF     0x007fffff
#define vsLevelIndex(bl_flags)  (((bl_flags) & LEVEL_LF)>>15)
#define vsIndex2Level(level)   ((level)<<15)

// p_MouseActivate property values
// Determines what happens when user clicks on edit window
#define MA_DEFAULT          0
#define MA_ACTIVATE         1
#define MA_ACTIVATEANDEAT   2
#define MA_NOACTIVATE       3
#define MA_NOACTIVATEANDEAT 4

#define VF_FREE     0   // Variable is on free list
               // If you get this, you screwed up with pointers.
#define VF_LSTR     2
#define VF_INT      3
#define VF_ARRAY    4
#define VF_HASHTAB  5
#define VF_PTR      7
#define VF_EMPTY    8
#define VF_FUNPTR   9

   boolean def_cfgfiles;  // Typically non-zero, advanced users may
                          // never want source files for configuration.
   boolean def_localsta;  // Default is 1.  If you don't have
                          // disk space, set this to zero.

#define MFSEARCH_INIT_HISTORY   0x1
#define MFSEARCH_INIT_CURWORD   0x2
#define MFSEARCH_INIT_SELECTION 0x4

   int _config_modify;   /* Initialized by stdcmds.e. */
                         /* Non-zero if user configuration has been modified.*/
// _config_modify flags
#define CFGMODIFY_ALLCFGFILES  0x001 // For backward compatibility.
                              // New macros should use the constants below.
#define CFGMODIFY_DEFVAR    0x002  // Set macro variable with prefix "def_"
#define CFGMODIFY_DEFDATA   0x004  // Set symbol with prefix "def_"
#define CFGMODIFY_OPTION    0x008  // color, scroll style, insert state or
                           // any option which the list_config
                           // command generates source for.
#define CFGMODIFY_RESOURCE     0x010  // FORM, BITMAP, MENU, BUTTON BAR, TOOL BAR
#define CFGMODIFY_SYSRESOURCE  0x020  // FORM, BITMAP, MENU, BUTTON BAR, TOOL BAR
#define CFGMODIFY_LOADMACRO  0x040  // vusermacs is screened out of this.
                            // Must write state file if user load
#define CFGMODIFY_LOADDLL    0x080  // Must write state file if user loads
                            // a DLL.
#define CFGMODIFY_KEYS       0x100  // Modify keys
#define CFGMODIFY_USERMACS   0x200  // vusrmacs was loaded.
#define CFGMODIFY_MUSTSAVESTATE  (CFGMODIFY_LOADMACRO|CFGMODIFY_LOADDLL)
#define CFGMODIFY_DELRESOURCE  0x400 // Sometimes must write state file
                             // when resource is deleted.
                             // This should be used with
                             // CFGMODIFY_RESOURCE or
                             // CFGMODIFY_SYSRESOURCE

// Some _default_option() constants
// VSOPTION_APIFLAGS
   #define VSAPIFLAG_SAVERESTORE_EDIT_WINDOWS  0x1
   #define VSAPIFLAG_TOOLBAR_DOCKING           0x2
   #define VSAPIFLAG_MDI_MENUS                 0x4
   #define VSAPIFLAG_MDI_WINDOW                0x8
   #define VSAPIFLAG_CONFIGURABLE_CMDLINE_COLOR     0x10
   #define VSAPIFLAG_CONFIGURABLE_CMDLINE_FONT      0x20
   #define VSAPIFLAG_CONFIGURABLE_STATUS_COLOR      0x40
   #define VSAPIFLAG_CONFIGURABLE_STATUS_FONT       0x80
   #define VSAPIFLAG_CONFIGURABLE_ALT_MENU_HOTKEYS  0x100
   #define VSAPIFLAG_CONFIGURABLE_ONE_FILE_PER_WINDOW 0x200
   #define VSAPIFLAG_CONFIGURABLE_VCPP_SETUP          0x400
   #define VSAPIFLAG_ALLOW_DIALOG_EDITING           0x1000
   #define VSAPIFLAG_ALLOW_DIALOG_ACCESS_TO_PROJECTS  0x2000
   #define VSAPIFLAG_SAVERESTORE_CWD                0x4000
   #define VSAPIFLAG_GOTO_BOOKMARK_RESTORES_BY_FILENAME        0x8000
   #define VSAPIFLAG_GOTO_BOOKMARK_RESTORES_BY_DOCUMENTNAME     0x10000
#define VSOPTION_WARNING_ARRAY_SIZE    1
#define VSOPTION_WARNING_STRING_LENGTH 2
#define VSOPTION_VERTICAL_LINE_COL     3
#define VSOPTION_WEAK_ERRORS           4
#define VSOPTION_MAXIMIZE_FIRST_MDICHILD  5
#define VSOPTION_MAXTABCOL             6
#define VSOPTION_CURSOR_BLINK          7
#define VSOPTION_DISPLAY_TEMP_CURSOR   8
#define VSOPTION_LEFT_MARGIN           9
#define VSOPTION_DISPLAY_TOP_OF_FILE   10
#define VSOPTION_HORIZONTAL_SCROLL_BAR 11
#define VSOPTION_VERTICAL_SCROLL_BAR   12
#define VSOPTION_HIDE_MOUSE            13
#define VSOPTION_ALT_ACTIVATES_MENU    14
#define VSOPTION_DRAW_BOX_AROUND_CURRENT_LINE 15
#define VSOPTION_MAX_MENU_FILENAME_LEN 16
#define VSOPTION_PROTECT_READONLY_MODE 17
#define VSOPTION_PROCESS_BUFFER_CR_ERASE_LINE 18
#define VSOPTION_ENABLE_FONT_FLAGS     19
#define VSOPTION_APIFLAGS              20
#define VSOPTION_HAVECMDLINE           21
#define VSOPTION_QUIET                 22
#define VSOPTION_SHOWTOOLTIPS          23
#define VSOPTION_TOOLTIPDELAY          24
#define VSOPTION_HAVEMESSAGELINE       25
#define VSOPTION_HAVEGETMESSAGELINE    26
#define VSOPTION_MACRO_SOURCE_LEVEL    27
#define VSOPTION_VSAPI_SOURCE_LEVEL    28
#define VSOPTION_APPLY_LOCAL_STATE_FILE_CHANGES 29
#define VSOPTION_EMBEDDED              30
#define VSOPTION_DISPLAYVERSIONMESSAGE 31
#define VSOPTION_CXDRAGMIN             32
#define VSOPTION_CYDRAGMIN             33
#define VSOPTION_DRAGDELAY             34
#define VSOPTION_MDI_SHOW_WINDOW_FLAGS 35//4:26pm 4/20/1998
                                         //Dan added for to support hiding mdi
                                         //on startup
#define VSOPTION_SEARCHDEFAULTFLAGS    36
#define VSOPTION_MAX_STACK_DUMP_LINE_LENGTH 37
#define VSOPTION_MAX_STACK_DUMP_ARGUMENT_NOFLINES 38
#define VSOPTION_NEXTWINDOWSTYLE                  39

#define VSOPTIONZ_PAST_EOF               1000

#define VSOPTIONZ_SPECIAL_CHAR_XLAT_TAB  1001
   #define VSSPECIALCHAR_EOLCH1  0
   #define VSSPECIALCHAR_EOLCH2  1
   #define VSSPECIALCHAR_TAB     2
   #define VSSPECIALCHAR_SPACE   3
   #define VSSPECIALCHAR_VIRTUALSPACE 4
   #define VSSPECIALCHAR_EOF     5

   #define VSSPECIALCHAR_MAX     20

#define VSOPTIONZ_APPLICATION_NAME       1002

// Structure for new tool bar list def_toolbartab.
// Users should only need to use the define constants
struct _TOOLBAR{
   _str  FormName;     //Name of form for toolbox/button bar
#define TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED 0x0001
#define TBFLAG_SIZEBARS       0x0002
#define TBFLAG_ALWAYS_ON_TOP  0x0004
#define TBFLAG_ALLOW_DOCKING  0x0008
//#define TBFLAG_HIDE_WHEN_APP_INACTIVE   0x0010

// Initial flags for a new tool bar
#define TBFLAG_NEW_TOOLBAR  (TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED|TBFLAG_ALLOW_DOCKING|TBFLAG_ALWAYS_ON_TOP)
   int tbflags;

   boolean restore_docked;  // Indicates whether to restore this toolbar docked
   // Below is last show info.
   int show_x;
   int show_y;
   int show_width;
   int show_height;

   // Below are last docked information.
   int docked_bbside; //0 indicates last docked position info is unknown.
   int docked_row;    // 1 is first row.  Reinsert at this row.  
   int docked_x;     // Reinsert at this x,y.  If toolbar fits
   int docked_y;
   int docked_width;
   int docked_height;
};
boolean def_hidetoolbars;


int def_diff_options;
#define DIFF_EXPAND_TABS            0x01
#define DIFF_IGNORE_LSPACES         0x02
#define DIFF_IGNORE_TSPACES         0x04
#define DIFF_IGNORE_SPACES          0x08
#define DIFF_IGNORE_CASE            0x10
#define DIFF_OUTPUT_INTERLEAVED     0x20
#define DIFF_DONT_COMPARE_EOL_CHARS 0x40

int def_diff_edit_options;
#define   DIFF_START_AT_TOP          0x04
#define   DIFF_START_AT_FIRST_DIFF   0x08
#define   DIFF_CURFILE_INIT          0x10
#define   DIFF_AUTO_JUMP             0x20
#define   DIFF_SHOW_GAUGE            0x40
//Other flags reserved...
#define   DIFF_OUTPUT_BOOLEAN        0x400
#define   DIFF_LEADING_SKIP_COMMENTS 0x800
#define   DIFF_NO_AUTO_MAPPING       0x1000

boolean def_smart_diff=true;
int def_diff_view_options;
#define DIFF_VIEW_MATCHING_FILES  0x1
#define DIFF_VIEW_VIEWED_FILES    0x2
#define DIFF_VIEW_DIFFERENT_FILES 0x4
#define DIFF_VIEW_MISSING_FILES1  0x8
#define DIFF_VIEW_MISSING_FILES2  0x10

#define LINE_NUMBERS_LEN  6

boolean def_seldisp_single;
boolean def_auto_landscape;
#define SELDISP_COLLAPSEPROCCOMMENTS 0x1
#define SELDISP_SHOWPROCCOMMENTS 0x2
#define SELDISP_EXPANDSUBLEVELS  0x4
#define SELDISP_COLLAPSESUBLEVELS 0x8
int def_seldisp_flags;
int def_seldisp_maxlevel;

#define VCPP_CLOSE_ON_EXIT   0x01
#define VCPP_OPEN_ON_START   0x02
#define VCPP_ADD_VSE_MENU    0x04
int def_vcpp_flags;
int _Nofchanges;
boolean def_copy_noselection;  // Copy current line when there is no selection
#define BBSIDE_LEFT    1
#define BBSIDE_TOP     2
#define BBSIDE_RIGHT   3
#define BBSIDE_BOTTOM  4
#define SHOWSPECIALCHARS_NLCHARS  0x01
#define SHOWSPECIALCHARS_TABS     0x02
#define SHOWSPECIALCHARS_SPACES   0x04
#define SHOWSPECIALCHARS_EOF      0x08
#define SHOWSPECIALCHARS_ALL      0xff

#define MFFIND_CURBUFFERONLY 0x01
#define MFFIND_FILESONLY     0x02
#define MFFIND_APPEND        0x04
#define MFFIND_MDICHILD      0x08
#define MFFIND_SINGLE        0x10
#define MFFIND_GLOBAL        0x20

#define SW_HIDE             0  // Make window invisible
#define SW_NORMAL           1
#define SW_SHOWMINIMIZED    2  // Show window iconized
#define SW_SHOWMAXIMIZED    3  // Show window maximized
#define SW_SHOWNOACTIVATE   4  // Make window visible without changing Z order
#define SW_SHOW             5  // Make window visible and change Z order
#define SW_RESTORE          9  // Restore window

#define SSTAB_OTOP          0  // tab-on-top orientation
#define SSTAB_OBOTTOM       1  // tab-on-bottom orientation
#define SSTAB_OLEFT         2  // tab-on-left orientation
#define SSTAB_ORIGHT        3  // tab-on-right orientation
#define SSTAB_TAB_CLICKED   10 // base of index of tab clicked
#define SSTAB_TAB_LPARTIAL  0x8000
#define SSTAB_TAB_RPARTIAL  0x4000
#define SSTAB_LSCROLLBUTTON_CLICKED 1
#define SSTAB_RSCROLLBUTTON_CLICKED 2
#define SSTAB_TABABOVE      0
#define SSTAB_TABBELOW      1
#define SSTAB_TABLEFT       2
#define SSTAB_TABRIGHT      3

_str gerror_info:[];   // Hash table containing filenames which have
                       // old line numbers set.

/*
    1-Multi-file find uses find_next/find_prev
    2-Multi-file find uses next_error/prev_error
    Both bits can be on.
 */
int def_mfflags;
//3:35pm 3/24/1997:Dan added for tree control
#define TREE_NO_LINES     0
#define TREE_DOTTED_LINES 1
#define TREE_SOLID_LINES  2

#define TREENODE_HIDDEN   0x1
#define TREENODE_SELECTED 0x2

//7:15pm 4/29/1997:These are for the push buttton list box stuff
#define LB_BUTTON_NOPUSH      0
#define LB_BUTTON_PUSH_BUTTON 1
#define LB_BUTTON_STICKY      2

#define TREE_ADD_BEFORE     0x1 /* Add a node before sibling in order */
#define TREE_ADD_AS_CHILD   0x2
//These sort flags cannot be used in combination with each other
#define TREE_ADD_SORTED_CS       0x4
#define TREE_ADD_SORTED_CI       0x8
#define TREE_ADD_SORTED_FILENAME 0x10

#define TREE_ROOT_INDEX     0

/* Constants for 'tree_to_node' */
#define TO_PREVSIB 0x1   /* To previous(left) sibling */
#define TO_NEXTSIB 0x2   /* To next(right) sibling    */
#define TO_PARENT  0x4   /* To parent                 */
#define TO_LCHILD  0x8   /* To left-most child        */

/* Constants for 'tree_traverse' */
#define TRAVERSE_PREORDER  0x1
#define TRAVERSE_INORDER   0x2
#define TRAVERSE_POSTORDER 0x4

#define TREE_NODE_CHILD  1
#define TREE_NODE_PARENT 2

#define VCPP_STARTUP_TIMEOUT 30
#define VCPP_EXE_FILENAME 'msdev.exe'
#define VCPP_CLASSNAME_PREFIX 'Afx'
#define VCPP_WINDOWTITLE_PREFIX 'Microsoft Developer Studio'

// Label Style argument constants
#define MULTI_LABEL_DEFAULT 0x1
#define MULTI_LABEL_SUNKEN 0x2

// Label AutoSizeStyle argument constants
#define MULTI_LABEL_AUTOSIZE_DEFAULT 0
#define MULTI_LABEL_AUTOSIZE_INDIV 1
#define MULTI_LABEL_AUTOSIZE_REST 2

// _SetListColInfo method Style argument constants
#define LBCOLSTYLE_LABEL      0
#define LBCOLSTYLE_BUTTON     1
#define LBCOLSTYLE_2STATE     2

#define VSMARKFLAG_BINARY            1
//#define VSMARKFLAG_DELETE_LAST_LINE  2
//#define VSMARKFLAG_ALREADYADJUSTED   4
#define VSMARKFLAG_COPYNOSAVELF      8

//      p_ModifyFlags
#define MODIFYFLAG_AUTOSAVE_DONE       0x0002
#define MODIFYFLAG_DELPHI              0x0004
#define MODIFYFLAG_TAGGED              0x0008
#define MODIFYFLAG_PROCTREE_UPDATED    0x0010
#define MODIFYFLAG_CONTEXT_UPDATED     0x0020
#define MODIFYFLAG_LOCALS_UPDATED      0x0040
#define MODIFYFLAG_FCTHELP_UPDATED     0x0080
#define MODIFYFLAG_TAGWIN_UPDATED      0x0100
#define MODIFYFLAG_CONTEXTWIN_UPDATED  0x0200
#define MODIFYFLAG_FTP_NEED_TO_SAVE    0x0400

//////////////////////////////////////////////////////////////////////
// Database file types that can be opened using this library
//
#define VS_DBTYPE_tags        0
#define VS_DBTYPE_references  1
#define VS_DBTYPE_msbrowse    2

//////////////////////////////////////////////////////////////////////
// Database version, corresponding to Visual Slickedit, release 3.0
//
#define VS_TAG_USER_VERSION             3000
#define VS_TAG_USER_VERSION_WIDE_FLAGS  3100
#define VS_TAG_USER_VERSION_FILE_TYPES  4000
#define VS_TAG_USER_VERSION_CASE_FIXED  4100
#define VS_TAG_LATEST_VERSION           4100
#define VS_REF_USER_VERSION             4000
#define VS_REF_LATEST_VERSION           4000

//////////////////////////////////////////////////////////////////////
// Standard tag types, by default, always present in database
// standard type name is always "xxx" for VS_TAGTYPE_xxx,
// for example, the type name for VS_TAGTYPE_proc is "proc".
// ID's 37-127 are reserved for future use by Microedge.
//
#define VS_TAGTYPE_proc         1  // procedure or command
#define VS_TAGTYPE_proto        2  // function prototype
#define VS_TAGTYPE_define       3  // preprocessor macro definition
#define VS_TAGTYPE_typedef      4  // type definition
#define VS_TAGTYPE_gvar         5  // global variable declaration
#define VS_TAGTYPE_struct       6  // structure definition
#define VS_TAGTYPE_enumc        7  // enumeration value
#define VS_TAGTYPE_enum         8  // enumerated type
#define VS_TAGTYPE_class        9  // class definition
#define VS_TAGTYPE_union       10  // structure / union definition
#define VS_TAGTYPE_label       11  // label
#define VS_TAGTYPE_interface   12  // interface, eg, for Java
#define VS_TAGTYPE_constructor 13  // class constructor
#define VS_TAGTYPE_destructor  14  // class destructor
#define VS_TAGTYPE_package     15  // package / module / namespace
#define VS_TAGTYPE_var         16  // member of a class / struct / package
#define VS_TAGTYPE_lvar        17  // local variable declaration
#define VS_TAGTYPE_constant    18  // pascal constant
#define VS_TAGTYPE_function    19  // function
#define VS_TAGTYPE_property    20  // property
#define VS_TAGTYPE_program     21  // pascal program
#define VS_TAGTYPE_library     22  // pascal library
#define VS_TAGTYPE_parameter   23  // overloaded operator
#define VS_TAGTYPE_import      24  // package import or using
#define VS_TAGTYPE_friend      25  // C++ friend relationship
#define VS_TAGTYPE_database    26  // SQL/OO Database
#define VS_TAGTYPE_table       27  // Database Table
#define VS_TAGTYPE_column      28  // Database Column
#define VS_TAGTYPE_index       29  // Database index
#define VS_TAGTYPE_view        30  // Database view
#define VS_TAGTYPE_trigger     31  // Database trigger
#define VS_TAGTYPE_form        32  // GUI Form or window
#define VS_TAGTYPE_menu        33  // GUI Menu
#define VS_TAGTYPE_control     34  // GUI Control or Widget
#define VS_TAGTYPE_eventtab    35  // GUI Event table
#define VS_TAGTYPE_procproto   36  // Prototype for procedure
#define VS_TAGTYPE_task        37  // Ada task
#define VS_TAGTYPE_include     38  // C++ include or Ada with (dependency)
#define VS_TAGTYPE_LASTID      38  // last tag type ID
#define VS_TAGTYPE_FIRSTUSER  128  // first user-defined tag type ID

//////////////////////////////////////////////////////////////////////
// Tag type filtering flags, formerly PUSHTAG_* flags in slick.sh
//
#define VS_TAGFILTER_CASESENSITIVE 0x01
#define VS_TAGFILTER_PROC          0x02
#define VS_TAGFILTER_PROTO         0x04
#define VS_TAGFILTER_DEFINE        0x08
#define VS_TAGFILTER_ENUM          0x10
#define VS_TAGFILTER_GVAR          0x20
#define VS_TAGFILTER_TYPEDEF       0x40
#define VS_TAGFILTER_STRUCT        0x80
#define VS_TAGFILTER_UNION         0x100
#define VS_TAGFILTER_LABEL         0x200
#define VS_TAGFILTER_INTERFACE     0x400
#define VS_TAGFILTER_PACKAGE       0x800
#define VS_TAGFILTER_VAR           0x1000
#define VS_TAGFILTER_CONSTANT      0x2000
#define VS_TAGFILTER_PROPERTY      0x4000
#define VS_TAGFILTER_LVAR          0x8000
#define VS_TAGFILTER_MISCELLANEOUS 0x10000
#define VS_TAGFILTER_DATABASE      0x20000
#define VS_TAGFILTER_GUI           0x40000
#define VS_TAGFILTER_INCLUDE       0x80000
#define VS_TAGFILTER_ANYTHING      0xffffe
#define VS_TAGFILTER_ANYPROC       (VS_TAGFILTER_PROTO|VS_TAGFILTER_PROC)
#define VS_TAGFILTER_ANYDATA       (VS_TAGFILTER_GVAR|VS_TAGFILTER_VAR|VS_TAGFILTER_LVAR|VS_TAGFILTER_PROPERTY)
#define VS_TAGFILTER_ANYSTRUCT     (VS_TAGFILTER_STRUCT|VS_TAGFILTER_UNION|VS_TAGFILTER_INTERFACE)
#define VS_TAGFILTER_NOBINARY      0x80000000

//////////////////////////////////////////////////////////////////////
// Flags associated with tags, denoting access restrictions and
// and other attributes of class members (proc's, proto's, and var's)
//    NOT virtual and NOT static implies normal class method
//    NOT protected and NOT private implies public
//    NOT const implies normal read/write access
//
#define VS_TAGFLAG_virtual      0x0001  // virtual function (instance)
#define VS_TAGFLAG_static       0x0002  // static method / member (class)
#define VS_TAGFLAG_access       0x000C  // access flags (public/protected/private/package)
#define VS_TAGFLAG_public       0x0000  // public access (test equality with flags&access)
#define VS_TAGFLAG_protected    0x0004  // protected access
#define VS_TAGFLAG_private      0x0008  // private access
#define VS_TAGFLAG_package      0x000C  // package access (for Java)
#define VS_TAGFLAG_const        0x0010  // const
#define VS_TAGFLAG_final        0x0020  // final
#define VS_TAGFLAG_abstract     0x0040  // abstract/deferred method
#define VS_TAGFLAG_inline       0x0080  // inline / out-of-line method
#define VS_TAGFLAG_operator     0x0100  // overloaded operator
#define VS_TAGFLAG_constructor  0x0200  // class constructor
#define VS_TAGFLAG_volatile     0x0400  // volatile method
#define VS_TAGFLAG_template     0x0800  // template class
#define VS_TAGFLAG_inclass      0x1000  // proc is in class definition?
#define VS_TAGFLAG_destructor   0x2000  // class destructor
#define VS_TAGFLAG_const_destr  0x2200  // class destructor or constructor
#define VS_TAGFLAG_synchronized 0x4000  // synchronized (thread safe)
#define VS_TAGFLAG_transient    0x8000  // transient / persistent data

#define VS_TAGFLAG_native       0x00010000  // Java native method?
#define VS_TAGFLAG_macro        0x00020000  // Tag was part of macro expansion?
#define VS_TAGFLAG_extern       0x00040000  // "extern" C prototype (not local)
#define VS_TAGFLAG_maybe_var    0x00080000  // Prototype which could be a variable.
#define VS_TAGFLAG_anonymous    0x00100000  // Anonymous structure or class
#define VS_TAGFLAG_mutable      0x00200000  // mutable C++ class member

//////////////////////////////////////////////////////////////////////
// Flags passed to tag to extract specific information about the
// current tag, using tag_get_detail(), below
//
#define VS_TAGDETAIL_max 256

#define VS_TAGDETAIL_current (VS_TAGDETAIL_max*0)
#define VS_TAGDETAIL_context (VS_TAGDETAIL_max*1)
#define VS_TAGDETAIL_local   (VS_TAGDETAIL_max*2)
#define VS_TAGDETAIL_match   (VS_TAGDETAIL_max*3)

#define VS_TAGDETAIL_name           0  // (string) tag name
#define VS_TAGDETAIL_type           1  // (string) tag type
#define VS_TAGDETAIL_type_id        2  // (int) unique id for tag type (VS_TAGTYPE_*)
#define VS_TAGDETAIL_file_name      3  // (string) full path of file the tag is located in
#define VS_TAGDETAIL_file_date      4  // (string) modification data of file when tagged
#define VS_TAGDETAIL_file_line      5  // (int) line number of tag within file
#define VS_TAGDETAIL_file_id        6  // (int) unique id for file the tag is located in
#define VS_TAGDETAIL_class_simple   7  // (string) name of class the tag is present in
#define VS_TAGDETAIL_class_name     8  // (string) name of class with outer classes
#define VS_TAGDETAIL_package        9  // (string) package/module/namespace tag belongs to
#define VS_TAGDETAIL_class_id      10  // (int) unique id for class tag belongs to
#define VS_TAGDETAIL_flags         11  // (int) tag flags (see VS_TAGFLAG_* above)
#define VS_TAGDETAIL_return        12  // (string) return type for functions, type of variables
#define VS_TAGDETAIL_arguments     13  // (string) function arguments
#define VS_TAGDETAIL_num_tags      17  // (int) number of tags in database
#define VS_TAGDETAIL_num_classes   18  // (int) number of classes in database
#define VS_TAGDETAIL_num_files     19  // (int) number of files in database
#define VS_TAGDETAIL_num_types     20  // (int) number of types in database
#define VS_TAGDETAIL_num_refs      21  // (int) number of references in database

#define VS_TAGDETAIL_context_tag_file      (VS_TAGDETAIL_context+0)
#define VS_TAGDETAIL_context_name          (VS_TAGDETAIL_context+1)
#define VS_TAGDETAIL_context_type          (VS_TAGDETAIL_context+2)
#define VS_TAGDETAIL_context_file          (VS_TAGDETAIL_context+3)
#define VS_TAGDETAIL_context_line          (VS_TAGDETAIL_context+4)
#define VS_TAGDETAIL_context_start_linenum (VS_TAGDETAIL_context+4)
#define VS_TAGDETAIL_context_start_seekpos (VS_TAGDETAIL_context+5)
#define VS_TAGDETAIL_context_scope_linenum (VS_TAGDETAIL_context+6)
#define VS_TAGDETAIL_context_scope_seekpos (VS_TAGDETAIL_context+7)
#define VS_TAGDETAIL_context_end_linenum   (VS_TAGDETAIL_context+8)
#define VS_TAGDETAIL_context_end_seekpos   (VS_TAGDETAIL_context+9)
#define VS_TAGDETAIL_context_class         (VS_TAGDETAIL_context+10)
#define VS_TAGDETAIL_context_flags         (VS_TAGDETAIL_context+11)
#define VS_TAGDETAIL_context_args          (VS_TAGDETAIL_context+12)
#define VS_TAGDETAIL_context_return        (VS_TAGDETAIL_context+13)
#define VS_TAGDETAIL_context_outer         (VS_TAGDETAIL_context+14)
#define VS_TAGDETAIL_context_parents       (VS_TAGDETAIL_context+15)

#define VS_TAGDETAIL_local_tag_file        (VS_TAGDETAIL_local+0)
#define VS_TAGDETAIL_local_name            (VS_TAGDETAIL_local+1)
#define VS_TAGDETAIL_local_type            (VS_TAGDETAIL_local+2)
#define VS_TAGDETAIL_local_file            (VS_TAGDETAIL_local+3)
#define VS_TAGDETAIL_local_line            (VS_TAGDETAIL_local+4)
#define VS_TAGDETAIL_local_start_linenum   (VS_TAGDETAIL_local+4)
#define VS_TAGDETAIL_local_start_seekpos   (VS_TAGDETAIL_local+5)
#define VS_TAGDETAIL_local_scope_linenum   (VS_TAGDETAIL_local+6)
#define VS_TAGDETAIL_local_scope_seekpos   (VS_TAGDETAIL_local+7)
#define VS_TAGDETAIL_local_end_linenum     (VS_TAGDETAIL_local+8)
#define VS_TAGDETAIL_local_end_seekpos     (VS_TAGDETAIL_local+9)
#define VS_TAGDETAIL_local_class           (VS_TAGDETAIL_local+10)
#define VS_TAGDETAIL_local_flags           (VS_TAGDETAIL_local+11)
#define VS_TAGDETAIL_local_args            (VS_TAGDETAIL_local+12)
#define VS_TAGDETAIL_local_return          (VS_TAGDETAIL_local+13)
#define VS_TAGDETAIL_local_outer           (VS_TAGDETAIL_local+14)
#define VS_TAGDETAIL_local_parents         (VS_TAGDETAIL_local+15)

#define VS_TAGDETAIL_match_tag_file        (VS_TAGDETAIL_match+0)
#define VS_TAGDETAIL_match_name            (VS_TAGDETAIL_match+1)
#define VS_TAGDETAIL_match_type            (VS_TAGDETAIL_match+2)
#define VS_TAGDETAIL_match_file            (VS_TAGDETAIL_match+3)
#define VS_TAGDETAIL_match_line            (VS_TAGDETAIL_match+4)
#define VS_TAGDETAIL_match_start_linenum   (VS_TAGDETAIL_match+4)
#define VS_TAGDETAIL_match_start_seekpos   (VS_TAGDETAIL_match+5)
#define VS_TAGDETAIL_match_scope_linenum   (VS_TAGDETAIL_match+6)
#define VS_TAGDETAIL_match_scope_seekpos   (VS_TAGDETAIL_match+7)
#define VS_TAGDETAIL_match_end_linenum     (VS_TAGDETAIL_match+8)
#define VS_TAGDETAIL_match_end_seekpos     (VS_TAGDETAIL_match+9)
#define VS_TAGDETAIL_match_class           (VS_TAGDETAIL_match+10)
#define VS_TAGDETAIL_match_flags           (VS_TAGDETAIL_match+11)
#define VS_TAGDETAIL_match_args            (VS_TAGDETAIL_match+12)
#define VS_TAGDETAIL_match_return          (VS_TAGDETAIL_match+13)
#define VS_TAGDETAIL_match_outer           (VS_TAGDETAIL_match+14)
#define VS_TAGDETAIL_match_parents         (VS_TAGDETAIL_match+15)

//////////////////////////////////////////////////////////////////////
// Standard file types, used to distinguish between source files
// pulled in naturally by tagging, object files, class files,
// executables, browser databaser, debug databases, and source files
// referenced by various other items.
//
#define VS_FILETYPE_source      0
#define VS_FILETYPE_refsource   1
#define VS_FILETYPE_browserdb   2
#define VS_FILETYPE_tagfile     3
#define VS_FILETYPE_LASTID      3

//////////////////////////////////////////////////////////////////////
// Flags associated with tags, denoting access restrictions and
// and other attributes of class members (proc's, proto's, and var's)
//    NOT virtual and NOT static implies normal class method
//    NOT const implies normal read/write access
//    NOT volatile implies normal optimizations are safe
//
#define VS_INSTFLAG_static       0x01
#define VS_INSTFLAG_virtual      0x02
#define VS_INSTFLAG_volatile     0x04
#define VS_INSTFLAG_const        0x08

//////////////////////////////////////////////////////////////////////
// Standard reference types, by default, always present in database
// standard type name is always "xxx" for VS_REFTYPE_xxx,
// for example, the type name for VS_REFTYPE_proc is "proc".
//
#define VS_REFTYPE_unknown    0     // unspecified
#define VS_REFTYPE_macro      1     // use of #define'd macro
#define VS_REFTYPE_call       2     // function or procedure call
#define VS_REFTYPE_var        3     // use of a variable
#define VS_REFTYPE_import     4     // use of a package
#define VS_REFTYPE_derive     5     // class derivation
#define VS_REFTYPE_type       6     // use of abstract type
#define VS_REFTYPE_class      7     // instantiantion of class
#define VS_REFTYPE_constant   8     // use of constant value or enum value
#define VS_REFTYPE_label      9     // use of label for goto

//////////////////////////////////////////////////////////////////////
// Characters used as separators when storing compound strings
// in the database.
//
#define VS_TAGSEPARATOR_class     ":"  // seperates nested class names
#define VS_TAGSEPARATOR_package   "/"  // seperates class from package name
#define VS_TAGSEPARATOR_args      "\1" // seperates arguments from return type
#define VS_TAGSEPARATOR_parents   ";"  // seperates list of class parents
#define VS_TAGSEPARATOR_equals    "="  // seperates type of constant from value

/////////////////////////////////////////////////////////////////////
// Tag match types for speed insert of tag matches
#define VS_TAGMATCH_tag      0
#define VS_TAGMATCH_context  1
#define VS_TAGMATCH_local    2
#define VS_TAGMATCH_match    3

/////////////////////////////////////////////////////////////////////
// Options flags used by various functions in context.e
// for example _MatchSymbolInContext()
#define VS_TAGCONTEXT_ALLOW_locals         0x00000001
#define VS_TAGCONTEXT_ALLOW_private        0x00000002
#define VS_TAGCONTEXT_ALLOW_protected      0x00000004
#define VS_TAGCONTEXT_ALLOW_package        0x00000008
#define VS_TAGCONTEXT_ONLY_volatile        0x00000010
#define VS_TAGCONTEXT_ONLY_const           0x00000020
#define VS_TAGCONTEXT_ONLY_static          0x00000040
#define VS_TAGCONTEXT_ONLY_non_static      0x00000080
#define VS_TAGCONTEXT_ONLY_data            0x00000100
#define VS_TAGCONTEXT_ONLY_funcs           0x00000200
#define VS_TAGCONTEXT_ONLY_classes         0x00000400
#define VS_TAGCONTEXT_ONLY_packages        0x00000800
#define VS_TAGCONTEXT_ONLY_inclass         0x00001000
#define VS_TAGCONTEXT_ONLY_constructors    0x00002000
#define VS_TAGCONTEXT_ONLY_this_class      0x00004000
#define VS_TAGCONTEXT_ONLY_parents         0x00008000
#define VS_TAGCONTEXT_FIND_derived         0x00010000
#define VS_TAGCONTEXT_ALLOW_anonymous      0x00020000
#define VS_TAGCONTEXT_ACCESS_private       0x0000000E
#define VS_TAGCONTEXT_ACCESS_protected     0x0000000C
#define VS_TAGCONTEXT_ACCESS_package       0x00000008
#define VS_TAGCONTEXT_ACCESS_public        0x00000000
#define VS_TAGCONTEXT_ANYTHING             VS_TAGCONTEXT_ACCESS_public

/////////////////////////////////////////////////////////////////////
// Context information retrieved by get_user_tag_info() and
// get_inheritance_tag_info(), see below.  This is used to determine
// what action to take when an item in the class browser or inheritance
// browser is selected.
//
struct VS_TAG_BROWSE_INFO {
   _str tag_database;      // filename of tag file (database)
   _str category;          // caption of tag category (see CB_*, above)
   _str class_name;        // class name for this tag
   _str member_name;       // the tag name
   _str qualified_name;    // qualified class name (if the tag is a class)
   _str type_name;         // tag type
   _str file_name;         // absolute path of file the tag is located in
   int  line_no;           // line number tag should be found on
   int  seekpos;           // seek position of tag
   int  scope_line_no;     // line number of tag's scope start
   int  scope_seekpos;     // seek position of tag's scope start
   int  end_line_no;       // line number of tag's end
   int  end_seekpos;       // seek position of tag's end
   int  flags;             // bit flags for tag attributes (see slick.sh)
   _str return_type;       // tag return type (unused)
   _str arguments;         // tag signature (function arguments)
};

/*
    Prototypes for the tagging function.
*/
_str tag_current_db();
int tag_set_cache_size(int cache_size);
void tagsdb_version();
int tag_current_version();
int tag_create_db(_str file_name, ...);
int tag_open_db(_str file_name);
int tag_read_db(_str file_name);
int tag_flush_db();
int tag_close_db2(...);   // Higher level than tag_close_db
int tag_close_db(... /*_str file_name,boolean leave_open*/);
int tag_close_all_db();
_str tag_get_db_comment();
int tag_set_db_comment(_str comment);
int tag_insert_tag   (_str tag_name, _str tag_type, _str file_name, int line_no, _str class_name, int tag_flags, _str signature);
int tag_insert_simple(_str tag_name, int  type_id,  _str file_name, int line_no, _str class_name, int tag_flags, _str signature);
int tag_remove_tag();
int tag_remove_from_file(_str file_name, int RemoveFileRecord=0);
int tag_remove_from_class(_str class_name, ...);
int tag_set_date(_str file_name, ...);
int tag_get_date(_str file_name, var date_tagged);
int tag_set_inheritance(_str class_name, _str parents);
int tag_get_inheritance(_str class_name, var parents);
int tag_find_tag(_str tag_name, _str tag_type, _str class_name, ... /*VSPSZ signature*/);
int tag_next_tag(_str tag_name, _str tag_type, _str class_name, ... /*VSPSZ signature*/);
int tag_find_equal(_str tag_name, ...);
int tag_find_prefix(_str tag_prefix, ...);
int tag_next_equal(...);
int tag_next_prefix(_str tag_prefix, ...);
int tag_get_file(int file_id, var file_name);
int tag_find_file(var file_name, ...);
int tag_next_file(var file_name, ...);
int tag_get_type(int type_id, var type_name);
int tag_find_type(var type_name, .../*, _str search_for*/);
int tag_next_type(var type_name);
int tag_find_in_file(_str file_name);
int tag_next_in_file();
int tag_get_class(int class_id, var class_name);
int tag_find_class(var class_name, .../*VSPSZ search_class, normalize, case_sensitive*/);
int tag_next_class(var class_name, .../*VSPSZ search_class, normalize, case_sensitive*/);
int tag_find_in_class(_str class_name);
int tag_next_in_class();
int tag_find_global(int type_id, int mask, int nzero);
int tag_next_global(int type_id, int mask, int nzero);
void tag_get_info(var tag_name, var type_name, var file_name, var line_no, var class_name, var tag_flags);
void tag_get_detail(int detail, var result);
int tag_find_closest(_str tag_name, _str file_name, int line_no, ...);

// functions associated with fast class browser implementation
_str tag_tree_make_caption(_str member_name, _str type_name, _str class_name, int flags, _str arguments, boolean include_tab);
int tag_tree_type_is_func(_str type_name);
int tag_tree_type_is_class(_str type_name);
int tag_tree_type_is_package(_str type_name);
int tag_tree_filter_member(int filter_flags, _str type_name, int in_class, int tag_flags, var i_access, var i_type);
int tag_tree_filter_member2(int filter_flags_1, int filter_flags_2, _str type_name, int in_class, int tag_flags, var i_access, var i_type);
int tag_tree_prepare_expand(int f, int i, int t, int in_refresh, _str class_filter, _str member_filter, _str exception_name, int filter_flags, var icons, ...);
int tag_tree_add_members_in_category(int t1, int mask, int nzero, _str category_name, var in_count);
int tag_tree_add_members_in_section(_str prefix, int t1, int mask, int nzero, _str category_name, var in_count);
int tag_tree_add_members_of(_str class_name, _str in_file_name, int tag_file_id, var in_count);
_str tag_tree_compose_tag(_str tag_name, _str class_name, _str type_name, int tag_flags=0,_str signature="",_str return_type="");
void tag_tree_decompose_tag(_str proc_name, var tag_name, var class_name, var type_name, var tag_flags, ...);
int tag_tree_insert_fast(int tree_wid, int tree_index, int match_type, int match_id, int include_tab, int force_leaf, int tree_flags, int include_sig, int include_class);
int tag_tree_insert_tag(int tree_wid, int tree_index, int include_tab, int force_leaf, int tree_flags, _str tag_name, _str type_name, _str file_name, int line_no, _str class_name, int tag_flags, _str signature);
int tag_list_insert_tag(int list_wid, int include_tab, int indent_x, _str tag_name, _str type_name, _str file_name, int line_no, _str class_name, int tag_flags, _str signature);
int tag_tree_compare_args(_str args1, _str args2, boolean unqualify);
void tag_tree_select_bitmap(int i_access, int i_type, var leaf_flag, var pic_member);
void tag_tree_set_user_info(int tree_wid, int tree_index, int tag_file_id, int file_id, int line_no);

// functions associated with references database
int tag_insert_instance(_str inst_name, _str inst_type, int inst_flags, _str inst_class, _str inst_args, _str file_name, int line_no);
void tag_get_instance_info(int inst_id, var inst_name, var inst_type,  var inst_flags, var inst_class, var inst_args, var file_name,  var line_no);
int tag_match_instance(_str inst_name, _str inst_type, int inst_flags, _str inst_class, _str inst_args, _str file_name, int line_no, int case_sensitive);
int tag_insert_reference(int refto_id, int refby_id, _str ref_file, int ref_type, _str file_name, int line_no);
int tag_find_refer_to(int inst_id, var ref_type, var file_name, var line_no);
int tag_next_refer_to(int inst_id, var ref_type, var file_name, var line_no);
int tag_find_refer_by(int inst_id, var ref_type, var file_name, var line_no);
int tag_next_refer_by(int inst_id, var ref_type, var file_name, var line_no);
            
// current tag context functions
int tag_get_num_of_context();
int tag_insert_context(int outer_context, _str tag_name, _str tag_type, _str file_name, int start_line_no, int start_seekpos, int scope_line_no, int scope_seekpos, int end_line_no, int end_seekpos, _str class_name, int tag_flags, _str signature);
int tag_end_context(int context_id,int end_line_no, int end_seekpos);
int tag_clear_context();
int tag_check_context();
int tag_get_context(int context_id, var tag_name, var type_name, var file_name, var start_line_no, var start_seekpos, var scope_line_no, var scope_seekpos, var end_line_no, var end_seekpos, var class_name, var tag_flags, var signature, var return_type);
int tag_set_current_word(_str tag_name, _str tag_type, _str file_name, int line_no, _str class_name, int tag_flags, _str signature);
int tag_current_context();
int tag_nearest_context(int linenum);
int tag_tree_insert_context(int treeWID, int treeIndex, int pushtag_flags, int include_tab, int force_leaf, int tree_flags);
_str tag_get_context_type(int context_id);
int tag_find_context(_str tag_prefix, boolean exact, boolean case_sensitive, .../*boolean pass_through_anonymous=false, VSPSZ search_class_name=0*/);
int tag_next_context(_str tag_prefix, boolean exact, boolean case_sensitive, .../*boolean pass_through_anonymous=false, VSPSZ search_class_name=0*/);
int tag_set_context_parents(int context_id, _str parents);
_str tag_get_context_parents(int context_id);

int tag_get_num_of_locals();
int tag_insert_local(_str tag_name,_str tag_type,_str file_name,int line_no,_str class_name,int tag_flags,_str signature);
int tag_insert_local2(_str tag_name,_str tag_type,_str file_name,int line_no,int seekpos,int scope_line_no,int scope_seekpos,int end_line_no,int end_seekpos,_str class_name,int tag_flags,_str signature);
int tag_clear_locals(int local_id);
int tag_current_local();
int tag_get_local(int local_id,var tag_name,var type_name,var file_name,var line_no,var class_name,var tag_flags,var signature,var return_type);
int tag_get_local2(int context_id, var tag_name, var type_name, var file_name, var start_line_no, var start_seekpos, var scope_line_no, var scope_seekpos, var end_line_no, var end_seekpos, var class_name, var tag_flags, var signature, var return_type);
int tag_find_local(_str tag_prefix, boolean exact, boolean case_sensitive, .../*boolean pass_through_anonymous=false, VSPSZ search_class_name=0*/);
int tag_next_local(_str tag_prefix, boolean exact, boolean case_sensitive, .../*boolean pass_through_anonymous=false, VSPSZ search_class_name=0*/);
int tag_set_local_parents(int local_id, _str parents);
_str tag_get_local_parents(int local_id);

int tag_get_num_of_matches();
int tag_insert_match(_str tag_file, _str tag_name, _str tag_type, 
                     _str file_name, int line_no, _str class_name,
                     int tag_flags, _str signature);
int tag_insert_match_fast(int match_type, int local_or_context_id);
int tag_clear_matches();
int tag_get_match(int match_id, var tag_file, var tag_name, var type_name,
                  var file_name, var line_no, var class_name, var tag_flags,
                  var signature, var return_type);

int tag_filter_type(int type_id, int filter_flags, .../*, VSPSZ type_name, int tag_flags*/);
void tag_get_detail2(int detail_id, int item_id, var result);

// context tagging utility functions
int  tag_check_access_level(int context_flags, int tag_flags);
int  tag_check_context_flags(int context_flags, int tag_flags, _str type_name);
void tag_split_class_name(_str class_name, var inner_name, var outer_name);
_str tag_join_class_name(_str class_name, _str outer_class, var tag_files, boolean case_sensitive);
int  tag_check_for_typedef(_str symbol, var tag_files, boolean case_sensitive);
int  tag_check_for_define(_str symbol, int line_no, var tag_files, var alt_symbol);
int  tag_check_for_template(_str symbol, _str outer_class, boolean case_sensitive, var tag_files, var template_sig);
int  tag_check_for_package(_str symbol, var tag_files, boolean exact_match, boolean case_sensitive);
int tag_is_same_package(_str class1, _str class2, boolean case_sensitive);
void tag_list_context_packages(int treewid, int tree_index,
                               _str prefix, var tag_files,
                               var vnum_matches, int max_matches,
                               boolean exact_match, boolean case_sensitive);
void tag_list_globals_of_type(int treewid, int tree_index, var tag_files,
                              int type_id, int mask, int nonzero,
                              var vnum_matches, int max_matches);
void tag_list_in_file(int treewid,int tree_index,_str prefix,var tag_files,
                      _str search_file_name,int pushtag_flags,int context_flags,
                      var vnum_matches,int max_matches,
                      boolean exact_match,boolean case_sensitive);
void tag_list_context_globals(int treewid, int tree_index, _str prefix,
                              boolean check_context, var tag_files,
                              int pushtag_flags, int context_flags,
                              var vnum_matches, int max_matches,
                              boolean exact_match, boolean case_sensitive);
int tag_is_parent_class(_str parent_class, _str child_class,
                        var tag_files, boolean case_sensitive, boolean normalize);
int tag_list_class_locals(int treewid, int tree_index, var tag_files,
                          _str prefix, _str search_class,
                          int pushtag_flags, int context_flags,
                          var vnum_matches, int max_matches,
                          boolean exact_match, boolean case_sensitive);
int tag_list_class_context(int treewid, int tree_index, var tag_files,
                           _str prefix, _str search_class,
                           int pushtag_flags, int context_flags,
                           var vnum_matches, int max_matches,
                           boolean exact_match, boolean case_sensitive);
int tag_list_class_tags(int treewid, int tree_index, var tag_files,
                        _str prefix, _str search_class,
                        int pushtag_flags, int context_flags,
                        var vnum_matches, int max_matches,
                        boolean exact_match, boolean case_sensitive);
void tag_list_any_symbols(int treewid,int tree_index, _str prefix,
                          var tag_files, int pushtag_flags,int context_flags,
                          var vnum_matches,int max_matches,
                          boolean exact_match,boolean case_sensitive);

//12:20pm 7/3/1997
//Dan added for background/on save tagging
#define AUTOTAG_ON_SAVE            0x01   // tag file on save
#define AUTOTAG_BUFFERS            0x02   // background tag buffers
//#define AUTOTAG_PROJECT_ONLY     0x04   // background tag project buffers only (obsolete?)
#define AUTOTAG_FILES              0x08   // background tag all files
#define AUTOTAG_SYMBOLS            0x10   // refresh tag window (symbols tab)
#define AUTOTAG_FILES_PROJECT_ONLY 0x20   // background tag project files only
#define AUTOTAG_CURRENT_CONTEXT    0x40   // background update current context
int def_autotag_flags2;

#include "rc.sh"
#define VSWID_TOP      -1
#define VSWID_BOTTOM   -2

//These are options for *_list_tags and *_list_locals
#define VSLTF_OUTPUT_LINE_NUMBERS   0x0001   // output only line numbers
#define VSLTF_PROCS                 0x0002   // List proctree (def_proctree_flags) only
#define VSLTF_TREE_OUTPUT           0x0004   // Output to a tree control
#define VSLTF_TREE_OUTPUT_HIDDEN    0x0008   // Output to tree control hidden
#define VSLTF_LIST_OUTPUT           0x0010   // Output to list control
#define VSLTF_SKIP_OUT_OF_SCOPE     0x0020   // Skip locals that are out of scope
#define VSLTF_SET_TAG_CONTEXT       0x0040   // Set tagging context at cursor position

#define USE_T_FOR_TOOLS  0

int def_tagwin_flags;
int def_proctree_flags;

/*
    _TagFileRefresh_*     Callbacks are called when a tag file
                          is added or removed.  It is also
                          called when a tag file is modified.
    _TagFileAddRemove_*   Callbacks are called when a tag file
                          is added or removed.

    _TagFileModified_*    Callbacks are called when a tag file
                          is modified.


    If you use the _TagFileRefresh_ callback, do not implement
    a _TagFileModified_ or a _TagFileAddRemove_ function.

    If you implement _TagFileAddRemove_ and _TagFileModified_,
    do not implement a _TagFileRefresh_ callback.
*/
#define TAGFILE_MODIFIED_CALLBACK_PREFIX   "_TagFileModified_"
#define TAGFILE_ADD_REMOVE_CALLBACK_PREFIX "_TagFileAddRemove_"
#define TAGFILE_REFRESH_CALLBACK_PREFIX    "_TagFileRefresh_"

#define SYMBOL_TAB_CAPTION_STRING 'Symbol'

int def_tag_cache_size;
_str _last_wildcards;
#define PROJTOOLTAB_FILES      0
#define PROJTOOLTAB_PROCS      1
#define PROJTOOLTAB_CLASSES    2
#define PROJTOOLTAB_OPEN       3

#define OUTPUTTOOLTAB_SEARCH 0
#define OUTPUTTOOLTAB_SYMBOL 1
#define OUTPUTTOOLTAB_SHELL  2
#define OUTPUTTOOLTAB_DEBUG  3 /* future */
#endif
boolean def_fast_open;
#define VSEMBEDDED_IGNORE    1
#define VSEMBEDDED_ONLY      2

#define VSAUTOCODEINFO_DO_FUNCTION_HELP  0x1
#define VSAUTOCODEINFO_DO_LIST_MEMBERS   0x2
#define VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN 0x4
/* 
   Indicate function argument help has been requested for
   template class type declaration.
*/
#define VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST      0x8    // stack<... 
#define VSAUTOCODEINFO_IN_INITIALIZER_LIST 0x10        // MYCLASS::MYCLASS(..): a(
#define VSAUTOCODEINFO_IN_FUNCTION_POINTER_ARGLIST 0x10   // (*pfn)(a,b...
#define VSAUTOCODEINFO_MAYBE_IN_INITIALIZER_LIST 0x20  // MYCLASS(..): a(
#define VSAUTOCODEINFO_VAR_OR_PROTOTYPE_DECL 0x40      // MYCLASS a(
//  Option to _c_fcthelp_get to just check in
//  cursor is inside template declaration.
#define VSAUTOCODEINFO_IN_TEMPLATE_ARGLIST_TEST  0x80
// True if an operator was typed rather than an explicit
// list-members or function argument help command.
#define VSAUTOCODEINFO_OPERATOR_TYPED 0x100
// True if context is directly following certain statements
#define VSAUTOCODEINFO_IN_GOTO_STATEMENT  0x200        // goto label;
#define VSAUTOCODEINFO_IN_THROW_STATEMENT 0x400        // throw excepshun;

/*
    MicroEdge reserves the first 16 bits.  You may
    use the other 16 bits for anything you want.
    
    VSAUTOCODEINFO_USER1               0x10000
    VSAUTOCODEINFO_USER2               0x20000
    ...
*/


struct VSAUTOCODE_ARG_INFO {
   _str prototype;
   int argstart[];    // 0..# of arguments in prototype.  Start pos of this arg
                      // argstart[0] is start of function name.
   int arglength[];   // 0..# of arguments in prototype.  Start pos of this arg
                      // arglength[0] is length of function name.
                      // arglength[i]==0 indicates nothing to do.

   int ParamNum;      // 0..# of arguments -1.  Argument to highlight
                      // -1 indicates highlight nothing.

   _str ParamType;    // declared type of current argument (ParamNum)
};

#define VSCODEHELPRC_CONTEXT_NOT_VALID                1
#define VSCODEHELPRC_NOT_IN_ARGUMENT_LIST             2
#define VSCODEHELPRC_NO_HELP_FOR_FUNCTION             3
#define VSCODEHELPRC_NO_SYMBOLS_FOUND                 4
#define VSCODEHELPRC_CONTEXT_EXPRESSION_TOO_COMPLEX   5
#define VSCODEHELPRC_UNABLE_TO_EVALUATE_CONTEXT       6
#define VSCODEHELPRC_DOT_FOR_POINTER                  7
#define VSCODEHELPRC_DASHGREATER_FOR_NON_POINTER      8
#define VSCODEHELPRC_INVALID_NEW_EXPRESSION           9
#define VSCODEHELPRC_PARENTHESIS_MISMATCH            10
#define VSCODEHELPRC_BRACKETS_MISMATCH               11
#define VSCODEHELPRC_DASHGREATER_FOR_PTR_TO_POINTER  12
#define VSCODEHELPRC_SUBSCRIPT_BUT_NOT_ARRAY_TYPE    13
#define VSCODEHELPRC_OVERLOADED_RETURN_TYPE          14
#define VSCODEHELPRC_NOT_A_TEMPLATE_CLASS            15
#define VSCODEHELPRC_RETURN_TYPE_NOT_FOUND           16
#define VSCODEHELPRC_TEMPLATE_ARGS_MISMATCH          17
#define VSCODEHELPRC_BUILTIN_TYPE                    18
#define VSCODEHELPRC_NO_LABELS_DEFINED               19
#define VSCODEHELPRC_DOT_FOR_ARRAY                   20

#define VSCODEHELP_TITLE_locals   "Locals"
#define VSCODEHELP_TITLE_members  "Members"
#define VSCODEHELP_TITLE_imports  "Imports"
#define VSCODEHELP_TITLE_buffer   "Current Buffer"
#define VSCODEHELP_TITLE_globals  "Globals"
#define VSCODEHELP_TITLE_packages "Packages"
#define VSCODEHELP_TITLE_classes  "Classes"
#define VSCODEHELP_TITLE_props    "Properties"
#define VSCODEHELP_TITLE_builtins "Builtins"
#define VSCODEHELP_TITLE_params   "Parameters"
#define VSCODEHELP_TITLE_controls "Controls"

#define VSCODEHELP_MAXFUNCTIONHELPPROTOS   100
#define VSCODEHELP_MAXLISTGLOBALSYMBOLS    100
#define VSCODEHELP_MAXLISTMEMBERSSYMBOLS   200
#define VSCODEHELP_MAXFINDCONTEXTTAGS     1000
#define VSCODEHELP_MAXSKIPPREPROCESSING    100
#define VSCODEHELP_MAXRECURSIVETYPESEARCH   32


// BIT FLAGS for _ext_get_return_type_of_prefix related functions
#define VSCODEHELP_RETURN_TYPE_PRIVATE_ACCESS  0x0002
#define VSCODEHELP_RETURN_TYPE_CONST_ONLY      0x0004
#define VSCODEHELP_RETURN_TYPE_VOLATILE_ONLY   0x0008
#define VSCODEHELP_RETURN_TYPE_STATIC_ONLY     0x0010
#define VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY    0x0020
#define VSCODEHELP_RETURN_TYPE_ARRAY           0x0040
#define VSCODEHELP_RETURN_TYPE_HASHTABLE       0x0080

/* 
   Specify the VSBMFLAG_SHOWNAME if you want the bookmark
   name displayed at the left edge of the edit window.  Note
   that the user can select not to show any bookmark names
   on the left edge.
*/       
#define VSBMFLAG_SHOWNAME     0x1
/*       
   VSBMFLAG_STANDARD has the following effects:
     * bookmark is diplayed in bookmark list
     * next_bookmark and prev_bookmark will traverse this bookmark.
*/   
#define VSBMFLAG_STANDARD     0x2

/*
   This flag is used by the push_bookmark command.  PUSHED bookmarks
   are mainly useful for tagging where the bookmarks are very temporary.
   By convention, PUSHED bookmarks do not appear on the left edge
   or in the bookmarks dialog and are ignored by all commands excepted
   the pop_bookmark command.  Don't specify the VSBMFLAG_SHOWNAME or
   VSBMFLAG_STANDARD flags when using this flag.
   
   In case you were wondering, tag boookmarks are named to simplify
   save and restoring bookmarks.
*/
#define VSBMFLAG_PUSHED       0x4
   
#define VSTBBORDER_BORDER    0x1
#define VSTBBORDER_GRABBARS  0x2

struct CMDUI {
   int menu_handle;   // 0 if not called from menu
   int menu_pos;      // undefined if menu_handle==0
   boolean inMenuBar; // undefined if menu_handle==0
   _str reserved;     // undefined
   int button_wid;    // 0 if not called from toolbar button
};
                                  
#define VSTBREFRESHBY_READ_ONLY                  1
#define VSTBREFRESHBY_UNDO                       2
#define VSTBREFRESHBY_REDO                       3
#define VSTBREFRESHBY_SELECTION                  4
#define VSTBREFRESHBY_CREATEDESTROY_MDICHILD     5
#define VSTBREFRESHBY_MDICHILD_WINDOW_STATE      6
#define VSTBREFRESHBY_ADDREMOVE_BOOKMARK         7 
#define VSTBREFRESHBY_STARTSTOP_MACRO_RECORDING  8 

#define VSTBREFRESHBY_PROJECT                    9 
#define VSTBREFRESHBY_INTERNAL_CLIPBOARDS        10
#define VSTBREFRESHBY_SWITCHBUF                  11
#define VSTBREFRESHBY_APPLICATION_GOT_FOCUS      12

// Start your own values here or just use this one
#define VSTBREFRESHBY_USER                       1000

// ALL TAG FILES in absolute format, duplicates removed
//    Project tags, all extension tag files, all global tag files
_str gtag_filelist[];
_str gtag_filelist_project[];
_str gtag_filelist_ext[];
boolean gtag_filelist_cache_updated;

 int gNoTagCallList;  // Delay tag file refresh calls to weed out duplicates
                      // initialized in stdcmds.e
#define VSSCC_OK                                  0

#define VSSCC_E_INITIALIZEFAILED                  -1
#define VSSCC_E_UNKNOWNPROJECT                    -2
#define VSSCC_E_COULDNOTCREATEPROJECT             -3
#define VSSCC_E_NOTCHECKEDOUT                     -4
#define VSSCC_E_ALREADYCHECKEDOUT                 -5
#define VSSCC_E_FILEISLOCKED                      -6
#define VSSCC_E_FILEOUTEXCLUSIVE                  -7
#define VSSCC_E_ACCESSFAILURE                     -8
#define VSSCC_E_CHECKINCONFLICT                   -9
#define VSSCC_E_FILEALREADYEXISTS                 -10
#define VSSCC_E_FILENOTCONTROLLED                 -11
#define VSSCC_E_FILEISCHECKEDOUT                  -12
#define VSSCC_E_NOSPECIFIEDVERSION                -13
#define VSSCC_E_OPNOTSUPPORTED                    -14
#define VSSCC_E_NONSPECIFICERROR                  -15
#define VSSCC_E_OPNOTPERFORMED                    -16
#define VSSCC_E_TYPENOTSUPPORTED                  -17
#define VSSCC_E_VERIFYMERGE                       -18
#define VSSCC_E_FIXMERGE                          -19
#define VSSCC_E_SHELLFAILURE                      -20
#define VSSCC_E_INVALIDUSER                       -21
#define VSSCC_E_PROJECTALREADYOPEN                -22
#define VSSCC_E_PROJSYNTAXERR                     -23
#define VSSCC_E_INVALIDFILEPATH                   -24
#define VSSCC_E_PROJNOTOPEN                       -25
#define VSSCC_E_NOTAUTHORIZED                     -26
#define VSSCC_E_FILESYNTAXERR                     -27
#define VSSCC_E_FILENOTEXIST                      -28

#define VSSCC_COMMAND_GET         0
#define VSSCC_COMMAND_CHECKOUT    1
#define VSSCC_COMMAND_CHECKIN     2
#define VSSCC_COMMAND_UNCHECKOUT  3
#define VSSCC_COMMAND_ADD         4
#define VSSCC_COMMAND_REMOVE      5
#define VSSCC_COMMAND_DIFF        6
#define VSSCC_COMMAND_HISTORY     7
#define VSSCC_COMMAND_RENAME      8
#define VSSCC_COMMAND_PROPERTIES  9
#define VSSCC_COMMAND_OPTION      10

#define VSSCC_STATUS_INVALID          -1     // Status could not be obtained, don't rely on it
#define VSSCC_STATUS_NOTCONTROLLED    0x0000 // File is not under source control
#define VSSCC_STATUS_CONTROLLED       0x0001 // File is under source code control
#define VSSCC_STATUS_CHECKEDOUT       0x0002 // Checked out to current user at local path
#define VSSCC_STATUS_OUTOTHER         0x0004 // File is checked out to another user
#define VSSCC_STATUS_OUTEXCLUSIVE     0x0008 // File is exclusively check out
#define VSSCC_STATUS_OUTMULTIPLE      0x0010 // File is checked out to multiple people
#define VSSCC_STATUS_OUTOFDATE        0x0020 // The file is not the most recent
#define VSSCC_STATUS_DELETED          0x0040 // File has been deleted from the project
#define VSSCC_STATUS_LOCKED           0x0080 // No more versions allowed
#define VSSCC_STATUS_MERGED           0x0100 // File has been merged but not yet fixed/verified
#define VSSCC_STATUS_SHARED           0x0200 // File is shared between projects
#define VSSCC_STATUS_PINNED           0x0400 // File is shared to an explicit version
#define VSSCC_STATUS_MODIFIED         0x0800 // File has been modified/broken/violated
#define VSSCC_STATUS_OUTBYUSER        0x1000 // File is checked out by current user someplace

#define VSSCC_PROJECT_NAME      1
#define VSSCC_LOCAL_PATH        2
#define VSSCC_AUX_PATH_INFO     3
#define VSSCC_PROVIDER_DLL_PATH 4
#define VSSCC_PROVIDER_NAME     5

#define SCC_PREFIX        'SCC:'
#define SCC_PREFIX_LENGTH 4

_str def_vc_system;     //The current vcs

#define VCS_CHECKOUT           'checkout'
#define VCS_CHECKIN_NEW        'checkin_new'
#define VCS_CHECKIN            'checkin'
#define VCS_CHECKOUT_READ_ONLY 'checkout_read_only'
#define VCS_CHECKIN_DISCARD    'checkin_discard'
#define VCS_PROPERTIES         'properties'
#define VCS_DIFFERENCE         'difference'
#define VCS_HISTORY            'history'
#define VCS_REMOVE             'remove'
#define VCS_LOCK               'lock'
#define VCS_MANAGER            'manager'
#define NULL_COMMENT _chr(0)

#define READ_ONLY_ERROR_MESSAGE 'This command is not allowed in read only mode'

  int _in_firstinit;

int _chdebug;
boolean ginFunctionHelp;
boolean gFunctionHelp_pending;

#define RBFORM_CHECKBOXES 0x1

#define DIFF_REPORT_CREATED              0x1
#define DIFF_REPORT_LOADED               0x2
#define DIFF_REPORT_DIFF                 0x4
#define DIFF_REPORT_FILE_CHANGE          0x8
#define DIFF_REPORT_COPY_FILE           0x10
#define DIFF_REPORT_COPY_TREE           0x20
#define DIFF_REPORT_COPY_TREE_FILE      0x40
#define DIFF_REPORT_DELETE_FILE         0x80
#define DIFF_REPORT_DELETE_TREE        0x100
#define DIFF_REPORT_DELETE_TREE_FILE   0x200
#define DIFF_REPORT_SAVED_DIFF_STATE   0x400
#define DIFF_REPORT_SAVED_PATH1_LIST   0x800
#define DIFF_REPORT_SAVED_PATH2_LIST  0x1000
#define DIFF_REPORT_REFRESH_CHANGED   0x2000
#define DIFF_REPORT_REFRESH_ALL       0x4000

boolean def_switchbuf_cd;
boolean _hit_defmain;


#define HKEY_CLASSES_ROOT           ( 0x80000000 )
#define HKEY_CURRENT_USER           ( 0x80000001 )
#define HKEY_LOCAL_MACHINE          ( 0x80000002 )
#define HKEY_USERS                  ( 0x80000003 )
#define HKEY_PERFORMANCE_DATA       ( 0x80000004 )
#define HKEY_CURRENT_CONFIG         ( 0x80000005 )
#define HKEY_DYN_DATA               ( 0x80000006 )

#define DIFF_LIST_FILE_EXT 'dls'

#define VSIMPLEMENT_ABSTRACT  0x1

#define VSCODEHELPFLAG_AUTO_FUNCTION_HELP   0x1
#define VSCODEHELPFLAG_AUTO_LIST_MEMBERS    0x2
// When on, pressing space bar during list members always
// inserts a space. 
#define VSCODEHELPFLAG_SPACE_INSERTS_SPACE  0x4
// When on, selecting an item in during list members which 
// requires an open paren,'<', or additional characters, 
// automatically inserts the additinal characters.
#define VSCODEHELPFLAG_INSERT_OPEN_PAREN  0x8
// When on, pressing space during list members completes
// the word.
#define VSCODEHELPFLAG_SPACE_COMPLETION   0x10
// Get comments while doing list help
#define VSCODEHELPFLAG_DISPLAY_MEMBER_COMMENTS 0x20
// Get comments with doing function help (not implemented)
#define VSCODEHELPFLAG_DISPLAY_FUNCTION_COMMENTS 0x40
// Reserved for future use
#define VSCODEHELPFLAG_RESERVED_ON    0xFF80


int def_codehelp_flags;
int def_codehelp_idle;  // Delay in milliseconds before 
                        // members are listed.


#define SSTAB_MULTIROW_NONE       0
#define SSTAB_MULTIROW_MULTIROW   1
#define SSTAB_MULTIROW_BESTFIT    2

// p_ProtectReadOnlyMode values
#define VSPROTECTREADONLYMODE_OPTIONAL 0
#define VSPROTECTREADONLYMODE_ALWAYS   1
#define VSPROTECTREADONLYMODE_NEVER    2

boolean def_word_continue;

#define VSCURWORD_WHOLE_WORD       0
#define VSCURWORD_FROM_CURSOR      1
#define VSCURWORD_AT_END_USE_PREV  2

_str _ntRegQueryValue(int ConstantHkey,_str pszPath,_str pszDefault,...);

#define VSCHARSET_ANSI            0
#define VSCHARSET_DEFAULT         1
#define VSCHARSET_SYMBOL          2
#define VSCHARSET_SHIFTJIS        128
#define VSCHARSET_HANGEUL         129
#define VSCHARSET_GB2312          134
#define VSCHARSET_CHINESEBIG5     136
#define VSCHARSET_OEM             255
#define VSCHARSET_JOHAB           130
#define VSCHARSET_HEBREW          177
#define VSCHARSET_ARABIC          178
#define VSCHARSET_GREEK           161
#define VSCHARSET_TURKISH         162
#define VSCHARSET_THAI            222
#define VSCHARSET_EASTEUROPE      238
#define VSCHARSET_RUSSIAN         204
#define VSCHARSET_MAC             77
#define VSCHARSET_BALTIC          186

