/*
$VerboseHistory: tagwin.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:18a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:18a
 * Comment:
 * 
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:27p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

#define TAG_WINDOW_BUFFER  ".Tag Window Buffer"
#define TAG_NAME_BUFFER_LIST '.Tag Name Buffer List'
#define TAG_FORM_NAME  _tboutput_form 
#define TAG_FORM_NAME_STRING  "_tboutput_form" 
#define PROJ_FORM_NAME_STRING  "_tbproject_form" 
#define CBPROPS_FORM_NAME_STRING   "_tbprops_form"
#define CBPARENTS_FORM_NAME_STRING   "_cbparents_form"
#define PREFIXMATCHEDMAXLISTCOUNT 200
#define SYMBOLS_FOR_CURWORD_TIMEOUT 250

static int glast_seekpos= -1;
//5:07pm 7/3/1997
//This is window that displays the location of a tag.
//This may be part of a tabbed dialog eventually, try to keep that in mind

defeventtab _tboutput_form
_editor edit1; 
#if 0
TAG_FORM_NAME.on_resize()
{
   xbuffer=ctltagfiles.p_x;
   miny=max(ctltagfiles.p_y+ctltagfiles.p_height,ctltagname.p_y+ctltagname.p_height);
   edit1.p_y=miny+50;
   edit1.p_width=_dx2lx(SM_TWIP,edit1.p_parent.p_client_width)-(xbuffer*2);
   edit1.p_height=_dy2ly(SM_TWIP,edit1.p_parent.p_client_height)-edit1.p_y-50;
}
#endif   

static boolean _in_keyword(...)
{
   if (p_lexer_name=='') {
      return(0);
   }
   in_ml_comment=arg(1);
   if (in_ml_comment==1) {
      color=_clex_find(0,'g');
      if (color==CFG_COMMENT) {
         // This code does not work when cursor is inbetween start chars
         // chars of mlcomment. i.e. "/<cursor>*" cursor is inbetween / and *.
         orig_modify=p_modify;
         get_line(line);
         orig_col=p_col;
         replace_line(expand_tabs(line,1,orig_col-1,'s'));
         insert_line(' 'expand_tabs(line,orig_col,-1,'s'));
         p_col=1;
         color=_clex_find(0,'g');
         if (!_delete_line()) {
            up();
         }
         replace_line(line);
         p_col=orig_col;
         p_modify=orig_modify;
      }
   } else {
      color=_clex_find(0,'g');
   }
#if 0
   if (color=='' && p_col>1) {
      left();
      color=_clex_find(0,'g');
      right();
   }
#endif
   return(color==CFG_KEYWORD);
}

//We did this because it doesn't take any of the options that cur_word did
static _str mycur_word()
{
   // find and call routine to get prefix expression
   _str ext=p_extension;
   int get_idexp_index=find_index('_'ext'_get_idexp',PROC_TYPE);
   if (get_idexp_index && !call_index(junk,false, prefixexp, lastid,
                                      lastidstart_col, lastidstart_offset,
                                      info_flags, otherinfo, get_idexp_index)) {
      return lastid;
   }

   //if (_clex_find(KEYWORD_CLEXFLAG|NUMBER_CLEXFLAG|STRING_CLEXFLAG|COMMENT_CLEXFLAG|PPKEYWORD_CLEXFLAG|LINENUM_CLEXFLAG,'T')) {
   //   return('');
   //}
   save_search(sv_search_string,sv_flags,sv_word_re,sv_more);
   col=_text_colc(p_col,'p')
   save_pos(p);
   common_re='([~\od'p_word_chars']|^)\c[\od'p_word_chars']';
   common_re='('common_re')|^';
   status=search(common_re,'r-@');
   if ( status || !match_length()) {
      restore_pos(p);
      restore_search(sv_search_string,sv_flags,sv_word_re,sv_more);
      return('')
   }
   start_col=p_col;
   status=search('[~\od'p_word_chars']|$','r@');
   if ( status) {
      _end_line();
   }
   word=_expand_tabsc(start_col,p_col-start_col);
   restore_pos(p);
   //start_col=_text_colc(start_col,'P');
   restore_search(sv_search_string,sv_flags,sv_word_re,sv_more);
   return(word);
}

#define OUTPUT_TB_FORM_NAME_STRING "_tboutput_form"

//Need to be able to call this from proctree.e
/*static */
int _GetTagwinWID()
{
   static int LastFormWID;

   if (_iswindow_valid(LastFormWID) && 
       LastFormWID.p_object==OI_FORM &&
       LastFormWID.p_name==TAG_FORM_NAME_STRING &&
       !LastFormWID.p_edit){
      wid=LastFormWID;
   }else{
      wid=_find_formobj(TAG_FORM_NAME_STRING,'N');
      LastFormWID=wid;
   }
   return(wid);
}
static boolean TagWinFocus()
{
   FocusWID=_get_focus();
   _control ctltagname;
   _control ctltagfiles;
   FormWID=_GetTagwinWID();
   if (FocusWID==FormWID||
       FocusWID==FormWID.edit1 ||
       FocusWID==FormWID.ctltagname ||
       FocusWID==FormWID.ctltagname.p_cb_text_box ||
       FocusWID==FormWID.ctltagname.p_cb_list_box ||
       FocusWID==FormWID.ctltagfiles) {
      return(1);
   }
   return(0);
}
/*static */int _GetCBrowserWID()
{
   static int cbLastFormWID;

   if (_iswindow_valid(cbLastFormWID) && 
       cbLastFormWID.p_object==OI_FORM &&
       cbLastFormWID.p_name==PROJ_FORM_NAME_STRING &&
       !cbLastFormWID.p_edit){
      wid=cbLastFormWID;
   }else{
      wid=_find_formobj(PROJ_FORM_NAME_STRING,'N');
      cbLastFormWID=wid;
   }
   return(wid);
}
/*static */int _GetCBrowserParentsWID()
{
   static int cbpLastFormWID;

   if (_iswindow_valid(cbpLastFormWID) &&
       cbpLastFormWID.p_object==OI_FORM &&
       cbpLastFormWID.p_name==CBPARENTS_FORM_NAME_STRING &&
       !cbpLastFormWID.p_edit){
      wid=cbpLastFormWID;
   }else{
      wid=_find_formobj(CBPARENTS_FORM_NAME_STRING,'N');
      cbpLastFormWID=wid;
   }
   return(wid);
}
/*static */int _GetCBrowserPropsWID()
{
   static int cbtLastFormWID;

   if (_iswindow_valid(cbtLastFormWID) &&
       cbtLastFormWID.p_object==OI_FORM &&
       cbtLastFormWID.p_name==CBPROPS_FORM_NAME_STRING &&
       !cbtLastFormWID.p_edit){
      wid=cbtLastFormWID;
   }else{
      wid=_find_formobj(CBPROPS_FORM_NAME_STRING,'N');
      cbtLastFormWID=wid;
   }
   return(wid);
}
static boolean CBrowseFocus()
{
   FocusWID=_get_focus();
   _nocheck _control ctl_class_tree_view;
   _nocheck _control _proc_tree;
   FormWID=_GetCBrowserWID();
   if (FormWID && (FocusWID==FormWID||FocusWID==FormWID.ctl_class_tree_view||FocusWID==FormWID._proc_tree)) {
      FormWID=_GetTagwinWID();
      return(1);
   }
   _nocheck _control ctl_member_tree_view;
   _nocheck _control ctl_inheritance_tree_view;
   FormWID=_GetCBrowserParentsWID();
   if (FormWID && (FocusWID==FormWID||FocusWID==FormWID.ctl_member_tree_view||FocusWID==FormWID.ctl_inheritance_tree_view)) {
      FormWID=_GetTagwinWID()
      return(1);
   }
   _nocheck _control ctl_call_tree_view;
   _nocheck _control ctl_ref_tree_view;
   FormWID=_GetCBrowserPropsWID();
   if (FormWID && (FocusWID==FormWID||FocusWID==FormWID.ctl_ref_tree_view||FocusWID==FormWID.ctl_call_tree_view)) {
      FormWID=_GetTagwinWID()
      return(1);
   }
   return(0);
}

// Update the tag/symbol output window.  Grabs the current word from
// the editor control currently having focus and stuff's it into the
// 'ctltagname' combo box.  The _DisplayTagList method is activated
// by the on_change() event for the combo box and causes the tag
// in the 'ctltagname' to be looked up in the current context and
// displayed if unique, or creates a list of matches.
//
void _UpdateTagWindow(boolean AlwaysUpdate=false)
{
   //say("_UpdateTagWindow: alwaysupdate="AlwaysUpdate);
   // tag window disabled?
   if (!(def_autotag_flags2 & AUTOTAG_SYMBOLS)) {
      return;
   }

   // check current focus and if it is an editor control
   if (_no_child_windows()) {
      return;
   }
   int editorctl_wid = _mdi.p_child;
   //int editorctl_wid=_get_focus();
   //if (!editorctl_wid || !editorctl_wid._isEditorCtl()) {
   //   return;
   //}

   // idle timer elapsed?
   if (_idle_time_elapsed()>SYMBOLS_FOR_CURWORD_TIMEOUT || AlwaysUpdate) {

      // if no seekpos change or buffer modification, do not update
      int curr_seekpos = editorctl_wid._nrseek();
      if (curr_seekpos != glast_seekpos || 
          !(editorctl_wid.p_ModifyFlags&MODIFYFLAG_TAGWIN_UPDATED)) {
         glast_seekpos = curr_seekpos;

         // check if tagwin is active
         int wid=_GetTagwinWID();
         if (!wid) return;
         int tabwid=wid._find_control('_output_sstab');
         if (tabwid.p_ActiveTab!=OUTPUTTOOLTAB_SYMBOL || tabwid.p_ActiveEnabled==FALSE) {
            return;
         }

         // clear the filename/line number
         _nocheck _control ctltagname;
         wid.SetInfoCaption(0);
         editorctl_wid.p_ModifyFlags |= MODIFYFLAG_TAGWIN_UPDATED;

         // blow out of here if the tagwin or class browser or proctree has focus
         if (CodeHelpActive() || TagWinFocus() || CBrowseFocus()) return;

         // check if this extension supports tagging
         static _str last_ext;
         _str ext=editorctl_wid.p_extension;
         if (ext=='' || (last_ext!=ext && !find_index(ext'-proc-search',PROC_TYPE))) {
            return;
         }
         last_ext=ext;

         // if the current symbol hasn't changed, don't update tag
         static int last_linenum;
         int curr_linenum = editorctl_wid.p_RLine;
         _str tagname=editorctl_wid.mycur_word();
         if (tagname:==wid.ctltagname.p_text && curr_linenum == last_linenum) {
            return;
         }
         last_linenum = editorctl_wid.p_RLine;

         //10:35am 7/10/1997
         //I only want to add the tags that match something to the combo listbox
         //There can be a blank line in the box(because of the way we scroll down)
         //So, I check _GoToROffset(4).  This will fail if the line is blank
         //and I think it should be faster than a get_line
         if (wid.ctltagname.p_text!='' && !wid.edit1._GoToROffset(4)) {
            if (!wid.ctltagname.p_cb_list_box.p_visible) {
               _str ssmessage=get_message();
               int sticky=rc;
               wid.ctltagname.p_cb_list_box.add_combo_list_item(wid.ctltagname.p_text);
               if (ssmessage!='') {
                  if (sticky) {
                     sticky_message(ssmessage);
                  } else {
                     message(ssmessage);
                  }
               }
            }
         }
         wid.ctltagname.p_text=tagname;
         wid.ctltagname.p_user='';
      }
   }
}

//#define DontDeleteBuffer   edit1.p_user
#define EditWindowBufferID edit1.p_user
#define FilenameTagIsIn    ctlbufname.p_user

static mdisetfocus()
{
   if (!_no_child_windows()) {
      _mdi.p_child._set_focus();
   }
}

edit1.on_create()
{
   gtagwin_in_quit_file=false;
   glast_seekpos= -1;
   p_window_flags|=(OVERRIDE_CURLINE_RECT_WFLAG|CURLINE_RECT_WFLAG|OVERRIDE_CURLINE_COLOR_WFLAG);
   p_window_flags&=~(CURLINE_COLOR_WFLAG);
   p_buf_name=TAG_WINDOW_BUFFER;
   p_MouseActivate=MA_NOACTIVATE;
   _shellEditor.p_MouseActivate=MA_NOACTIVATE;
   //If I set tabs during the on_create it seemed to get hosed...
   //p_tabs='1 7 15 52';
   p_tabs='1 9 41';
   EditWindowBufferID=p_buf_id;
   ctltagname.p_cb_list_box.p_buf_name=TAG_NAME_BUFFER_LIST;
   _UpdateTagWindow();
   if (!p_Noflines) {
      insert_line('');
   }
   p_line=1;
   line_to_top();
   p_scroll_left_edge=-1;
   _post_call(mdisetfocus);
   ctlbufname.p_caption='';
   SetInfoCaption(0);
}

// Set the filename and line number caption for the symbol window.
// The the current object must be the tag window.
static void SetInfoCaption(int line_no)
{
   if (edit1.p_buf_id != EditWindowBufferID) {
      _str filename=edit1.p_buf_name;
      _str caption=ctlbufname._ShrinkFilename(filename,p_active_form.p_width-ctlbufname.p_x);
      if (line_no > 0) {
         caption = caption:+': 'line_no;
      } else if (edit1.p_RLine > 1) {
         caption = caption:+': 'edit1.p_RLine;
      }
      if (caption!=ctlbufname.p_caption) {
         ctlbufname.p_caption=caption;
      }
      FilenameTagIsIn=filename;
   }
   ctlbufname.p_width=ctlbufname._text_width(ctlbufname.p_caption);
}

static void DisplayFile(_str filename,int line_no)
{
   status=edit1.load_files('+q +m +b 'filename);
   if (status) {
      //old=def_load_options;
      //def_load_options=stranslate(' 'def_load_options' ','',' +bp ','i');

      status=edit1._BufEdit(filename,"",0,"",1);
      if (status<0) {
         load_files('+bi 'EditWindowBufferID);
         return;
      }
      edit1.p_buf_id=status;
#if 0
      status=edit1.load_files(build_load_options(filename)' +q +m 'maybe_quote_filename(filename));
      //def_load_options=old;
      if (status) {
         if (status==NEW_FILE_RC) {
            _delete_buffer();
         }
         load_files('+bi 'EditWindowBufferID);
         return;
      }
#endif
      p_buf_flags|=(HIDE_BUFFER|DELETE_BUFFER_ON_CLOSE);
      select_edit_mode();
   }
   SetInfoCaption(line_no);
   p_RLine=line_no;
   //line_to_top();
   center_line();  
}

static boolean gtagwin_in_quit_file;
static void tagwin_quit_file()
{
   gtagwin_in_quit_file=true;
   quit_file();
   gtagwin_in_quit_file=false;
}
edit1.on_destroy()
{
   if (EditWindowBufferID!=p_buf_id) {
      if (p_buf_flags&HIDE_BUFFER) {
         if (!_DialogViewingBuffer(p_buf_id,p_window_id) && !(p_buf_flags&KEEP_ON_QUIT)) {
            tagwin_quit_file();
         }
      }
      load_files('+q +m +bi 'EditWindowBufferID);
   }
}

//Just throwing in the keys that I really feel like I need
ctltagname.ESC,'C-A'()
{
   tagwin_next_window();
}
static void tagwin_goto_tag(_str filename, int line_no=0)
{
   if (!_no_child_windows()) _mdi.p_child.push_bookmark();
   int lp=lastpos(':',filename);
   if (lp && !line_no) {
      line_no=(int)substr(filename,lp+1);
      filename=substr(filename,1,lp-1);
   }
   _str ext=_bufname2ext(filename);
   int index=find_index('vs'ext'-load-tags',PROC_TYPE);
   if (index_callable(index)) {
      message nls('Can not locate source code for %s.',filename);
      return;
   }
   int status=_mdi.p_child.edit(maybe_quote_filename(filename));
   if (!status) {
      _mdi.p_child.p_RLine=line_no;
      _mdi.p_child.center_line();
   }
}
void ctltagname.ENTER()
{
   if (p_cb_list_box.p_visible) {
      FallThroughCBEvent();
      return;
   }
   ctltagname.p_cb_list_box.add_combo_list_item(ctltagname.p_text);
   if (edit1.p_buf_id!=EditWindowBufferID) {
      ctltagname.call_event(ctltagname,ON_CHANGE);
      return;
   }
   edit1.get_line(line);
   if (substr(line,1,11)=='Maximum of ') return;
   if (line!='') {
      parse line with type_name"\t"tag_name"\t"filename;
   }else {
      return;
   }
   if (tag_name!=ctltagname.p_text) {
      ctltagname.p_text=tag_name;
      edit1.tagwin_mode_enter();
   }else{
      //_beep();
      //edit1.DisplayFile(filename,line_no);
      tagwin_goto_tag(filename);
      //if (!_no_child_windows()) _mdi.p_child.push_bookmark();
      //lp=lastpos(':',filename);
      //if (lp) {
      //   line_no=substr(filename,lp+1);
      //   filename=substr(filename,1,lp-1);
      //   status=_mdi.p_child.edit(maybe_quote_filename(filename));
      //   if (!status) {
      //      _mdi.p_child.p_RLine=line_no;
      //      _mdi.p_child.center_line();
      //   }
      //}
   }
   //tagwin_next_window();
}

static FallThroughCBEvent()
{
   index=find_index('_ul2_combobx',EVENTTAB_TYPE);
   if (index) {
      ctltagname.call_event(index,last_event(),'E');
   }
}

ctltagname.down,'C-K'()
{
   if (!ctltagname.p_cb_list_box.p_visible) {
      edit1.down();
   }else{
      FallThroughCBEvent();
   }
}

ctltagname.up,'C-I'()
{
   if (!ctltagname.p_cb_list_box.p_visible) {
      edit1.up();
   }else{
      FallThroughCBEvent();
   }
}

ctltagname.on_got_focus()
{
   _set_sel(1,length(p_text)+1);
}

_str GetClassSep(_str filename)
{
   _str extn = _bufname2ext(filename);
   switch (extn) {
   case 'java':
   case 'ada':
   case 'pl':
   case 'pas':
      return '.'
   case 'c':
   default:
      break; // drop through
   }
   return('::');
}

static void add_combo_list_item(_str text)
{
   if (text=='') {
      return;
   }
   _lbtop();
   old_text=_lbget_text();
   if (old_text!=text) {
      _lbup();
      _lbadd_item(text);
   }
   if (p_Noflines>30) {
      _lbbottom();
      while (p_Noflines>30) {
         _lbdelete_item();
      }
      _lbtop();
   }
}


static void tagwin_remove_duplicates()
{
   sort_buffer();
   sort_buffer('I');
   top();
   get_line(previous_line);
   for (;;) {
      down();
      if ( rc ) {
         break;
      }
      get_line(line);
      if ( line:==previous_line ) {
         up();_delete_line();
      } else {
         parse line with t1 "\t" n1 "\t" file1;
         parse previous_line with t2 "\t" n2 "\t" file2;
         if (t1 :== t2 && n1 :== n2 && file_eq(file1, file2)) {
            up(); delete_line();
         }
      }
      previous_line=line;
   }
}
static void DisplayTagList()
{
   //say("DisplayTagList()");
   //wid=_find_formobj(TAG_FORM_NAME_STRING,'N');
   int wid=_GetTagwinWID();
   if (!wid) return;
   int orig_wid=p_window_id;
   p_window_id=wid;
   p_window_id=edit1;
   boolean tagwin_has_focus = false;
   if (_get_focus()!=wid.ctltagname.p_cb_text_box) {
      wid.ctltagname.p_cb_list_box.add_combo_list_item(wid.ctltagname.p_text);
   } else {
      tagwin_has_focus = true;
   }

   //10:27am 7/10/1997
   if (p_Noflines) {
      orig_buf_id=p_buf_id;
      if (p_buf_id!=EditWindowBufferID) {
         if (p_buf_flags&HIDE_BUFFER) {
            if (!_DialogViewingBuffer(p_buf_id,p_window_id) && !(p_buf_flags&KEEP_ON_QUIT)) {
               tagwin_quit_file();
            }
         }
         load_files('+q +m +bi 'EditWindowBufferID);
      }
      markid=_alloc_selection();
      top();_select_line(markid);
      bottom();_select_line(markid);
      if (!rc) _delete_selection(markid);
      _free_selection(markid);
   }

   // get the ID of the first MDI child, otherwise 0
   _str match_tag_database='';
   _str match_tag_name='';
   int editorctl_wid = 0;
   _str search_tag_name='';
   _str search_class_name='';
   _str search_type_name='';
   int search_tag_flags=0;
   _str search_string = wid.ctltagname.p_text;
   boolean force_prefix_match = false;
   if (!pos('(',search_string) && tagwin_has_focus) {
      // check for trailing '*' indicating to force prefix match
      if (pos('[*]$',search_string,1,'r')) {
         search_string = substr(search_string, 1, pos('S')-1);
         force_prefix_match = true;
      }
      // compute search tag name and search class name
      search_tag_name = search_string;
      if (lastpos('::',search_string)) {
         search_class_name = substr(search_string, 1, pos('S')-1);
         search_tag_name   = substr(search_string, pos('S')+pos(''));
      } else if (lastpos('.',search_string)) {
         search_class_name = substr(search_string, 1, pos('S')-1);
         search_tag_name   = substr(search_string, pos('S')+pos(''));
      }
   } else {
      tag_tree_decompose_tag(wid.ctltagname.p_text, search_tag_name, search_class_name, search_type_name, search_tag_flags);
   }
   //say("search_tag_name="search_tag_name" search_class_name="search_class_name);
   int num_matches = 0;
   _str find_in_file = ctltagname.p_user;
   if (!_no_child_windows() && find_in_file=='') {
      editorctl_wid = _mdi.p_child;
   }
   parse find_in_file with find_in_file "\t" find_on_line "\t" just_go_there;
   if (find_in_file!='' && (just_go_there != '' || !editorctl_wid)) {
      //insert_line("\t"search_tag_name"\t"find_in_file':'find_on_line);
      insert_line(search_type_name"\t"search_tag_name"\t"find_in_file":"find_on_line);
      num_matches = 1;
   } else if (search_tag_name!='') { //if (editorctl_wid) {
      tag_clear_matches();
      int pushtag_flags = def_tagwin_flags;
      if (search_type_name != '' && !tag_filter_type(0, pushtag_flags, search_type_name)) {
         pushtag_flags = ~pushtag_flags;
      }
      if (editorctl_wid) {
         if (search_type_name == '' && search_class_name == '' && 
             find_in_file == '' && !tagwin_has_focus) {
            num_matches = editorctl_wid.context_match_tags(search_tag_name,false,PREFIXMATCHEDMAXLISTCOUNT,
                                                           (def_tagwin_flags&VS_TAGFILTER_CASESENSITIVE));
         }
         if (num_matches <= 0) {
            tag_clear_matches();
            if (!force_prefix_match) {
               editorctl_wid._MatchSymbolInContext(search_tag_name, search_class_name, 
                                                   num_matches, PREFIXMATCHEDMAXLISTCOUNT,
                                                   pushtag_flags, true, true, 
                                                   false, tagwin_has_focus, true,
                                                   (def_tagwin_flags&VS_TAGFILTER_CASESENSITIVE));
            }
            if (num_matches<=0 && tagwin_has_focus) {
               editorctl_wid._MatchSymbolInContext(search_tag_name, search_class_name, 
                                                   num_matches, PREFIXMATCHEDMAXLISTCOUNT,
                                                   pushtag_flags, true, true, 
                                                   false, tagwin_has_focus, false,
                                                   (def_tagwin_flags&VS_TAGFILTER_CASESENSITIVE));
            }
         }
      } else {
         // no MDI child, so not context or locals
         tag_clear_context();
         tag_clear_locals(0);
      }
      if (num_matches <= 0 && tagwin_has_focus) {
         typeless tag_files = tags_filenamea();
         if (search_class_name != '') {
            int i=0;
            _str tag_filename = next_tag_filea(tag_files, i, false, true);
            while (tag_filename != '') {
               if (!force_prefix_match) {
                  tag_list_class_tags(0,0,tag_files,search_tag_name,search_class_name,
                                      pushtag_flags,VS_TAGCONTEXT_ANYTHING,
                                      num_matches,PREFIXMATCHEDMAXLISTCOUNT,
                                      true, (def_tagwin_flags&VS_TAGFILTER_CASESENSITIVE)? true:false);
               }
               if (num_matches <= 0 && tagwin_has_focus) {
                  tag_list_class_tags(0,0,tag_files,search_tag_name,search_class_name,
                                      pushtag_flags,VS_TAGCONTEXT_ANYTHING,
                                      num_matches,PREFIXMATCHEDMAXLISTCOUNT, 
                                      false, (def_tagwin_flags&VS_TAGFILTER_CASESENSITIVE)? true:false);
               }
               tag_filename = next_tag_filea(tag_files, i, false, true);
            }
         }
         if (num_matches <= 0 && !force_prefix_match) {
            tag_list_any_symbols(0,0,search_tag_name,tag_files,
                                 pushtag_flags,VS_TAGCONTEXT_ANYTHING,
                                 num_matches,PREFIXMATCHEDMAXLISTCOUNT,
                                 true, (def_tagwin_flags&VS_TAGFILTER_CASESENSITIVE)? true:false);
         }
         if (num_matches <= 0 && tagwin_has_focus) {
            tag_list_any_symbols(0,0,search_tag_name,tag_files,
                                 pushtag_flags,VS_TAGCONTEXT_ANYTHING,
                                 num_matches,PREFIXMATCHEDMAXLISTCOUNT,
                                 false, (def_tagwin_flags&VS_TAGFILTER_CASESENSITIVE)? true:false);
         }
      }
      //say("num_matches="num_matches);
      while (!wid.edit1.p_Noflines) {
         for (i=1; i<=num_matches; i++) {
            tag_get_match(i,match_tag_database,match_tag_name,type_name,file_name,line_no,class_name,tag_flags,signature,return_type);
            //say("1db="match_tag_database" tag="match_tag_name" file="file_name);
            if (find_in_file!='') {
               if (!file_eq(file_name,find_in_file)) {
                  continue;
               }
               if (find_on_line!='' && find_on_line:!=line_no) {
                  continue;
               }
            }
            if (!tag_filter_type(0,pushtag_flags,type_name)) {
               continue;
            }
            _str caption = type_name"\t"match_tag_name"\t"file_name':'line_no;
            wid.edit1.insert_line(caption);
         }
         // defeat the pushtag flags for second time through
         if (pushtag_flags == VS_TAGFILTER_ANYTHING) {
            break;
         }
         pushtag_flags = VS_TAGFILTER_ANYTHING;
      }
   }

   ctltagname.p_user='';
   //_remove_duplicates();
   if (num_matches > 1) {
      tagwin_remove_duplicates();
   }
   if (p_Noflines==1) {
      //There is only one match
      get_line(line);
      //parse line with line_no"\t"type_name"\t"tag_name"\t"filename;
      //say("LLL="line);
      parse line with type_name"\t"tag_name"\t"filename;
      lp=lastpos(':',filename);
      if (lp) {
         line_no=substr(filename,lp+1);
         filename=substr(filename,1,lp-1);
         // blow out of here if there is no proc-search for this filename
         ext=_bufname2ext(filename);
         PSindex=find_index(ext'_proc_search',PROC_TYPE);
         if (index_callable(PSindex)) {
            DisplayFile(filename,line_no);
         }
      }
      if (!CBrowseFocus() && _GetCBrowserPropsWID()>0) {
         struct VS_TAG_BROWSE_INFO cm;
         if (_GetContextTagInfo(cm, match_tag_database, tag_name, filename, line_no)) {
            cb_refresh_property_view(cm);
         }
      }
   } else {
      if (ctlbufname.p_caption!='') {
         ctlbufname.p_caption='';
      }
      FilenameTagIsIn='';
      SetInfoCaption(0);
      if (!p_Noflines) {
         insert_line('');
      }
      p_line=1;
      line_to_top();
      p_scroll_left_edge=-1;
   }
   refresh();
   p_window_id=orig_wid;
}

static int tagWinTimerID=-1;

static int tagWinTimerCB()
{
   //say("tagWinTimerCB()");
   _kill_timer(tagWinTimerID);
   tagWinTimerID = -1;
   DisplayTagList();
   return(0);
}

#define KEYPRESSTOTAGMATCHINGDELAY 150
void ctltagname.on_change()
{
   //say("ctltagname.on_change()");
   if (TagWinFocus()) {
      if (tagWinTimerID >= 0) {
         _kill_timer(tagWinTimerID);
         tagWinTimerID= -1;
      }
      // If prefix is too short, don't match tags:
      _str prefix = ctltagname.p_cb_text_box.p_text;
      if (length(prefix) <= 0) {
         orig_wid=p_window_id;
         p_window_id=edit1;
   
         if (p_buf_id!=EditWindowBufferID) {
            if (p_buf_flags&HIDE_BUFFER) {
               if (!_DialogViewingBuffer(p_buf_id,p_window_id) && !(p_buf_flags&KEEP_ON_QUIT)) {
                  tagwin_quit_file();
               }
            }
            load_files('+q +m +bi 'EditWindowBufferID);
         }
   
         _lbclear();
         insert_line('');p_line=1;
         line_to_top();
         p_scroll_left_edge=-1;
         p_window_id=orig_wid;
         return;
      }
      tagWinTimerID = _set_timer( KEYPRESSTOTAGMATCHINGDELAY, tagWinTimerCB, 0 );
   }else{
      //If it was just a timer event that changed us, no sense waiting
      DisplayTagList();
   }
}

static void tagwin_mode_enter()
{
   if (edit1.p_buf_name==TAG_WINDOW_BUFFER) {
      get_line(line);
      if (substr(line,1,11)=='Maximum of ') return;
      if (line!='') {
         parse line with type_name"\t"tag_name"\t"filename;
         //DisplayFile(filename,line_no);
         tagwin_goto_tag(filename);
         //if (!_no_child_windows()) _mdi.p_child.push_bookmark();
         //lp=lastpos(':',filename);
         //if (lp) {
         //   line_no=substr(filename,lp+1);
         //   filename=substr(filename,1,lp-1);
         //   status=_mdi.p_child.edit(maybe_quote_filename(filename));
         //   if (!status) {
         //      _mdi.p_child.p_RLine=line_no;
         //      _mdi.p_child.center_line();
         //   }
         //}
      }
   }else{
      tagwin_goto_tag(p_buf_name, p_RLine);
      //filename=p_buf_name;
      //linenumber=p_RLine;
      //if (!_no_child_windows()) _mdi.p_child.push_bookmark();
      //status=_mdi.p_child.edit(maybe_quote_filename(filename));
      //if (!status) {
      //   _mdi.p_child.p_RLine=linenumber;
      //   _mdi.p_child.center_line();
      //}
   }
}

static void tagwin_next_window()
{
   if (!_no_child_windows()) {
      p_window_id=_mdi.p_child;
      _mdi.p_child._set_focus();
   }else{
      _cmdline._set_focus();
   }
}

static typeless TagWinCommands:[]={
   "split-insert-line"         =>tagwin_mode_enter,
   "c-enter"                   =>tagwin_mode_enter,
   "slick-enter"               =>tagwin_mode_enter,
   "cmd-enter"                 =>tagwin_mode_enter,
   "for-enter"                 =>tagwin_mode_enter,
   "pascal-enter"              =>tagwin_mode_enter,
   "prg-enter"                 =>tagwin_mode_enter,
   "select-line"               =>'',
   "brief-select-line"         =>'',
   "select-char"               =>'',
   "brief-select-char"         =>'',
   "cua-select"                =>'',
   "deselect"                  =>'',
   "copy-to-clipboard"         =>'',
   "next-window"               =>tagwin_next_window,
   "prev-window"               =>tagwin_next_window,
   "bottom-of-buffer"          =>'',
   "top-of-buffer"             =>'',
   "page-up"                   =>'',
   "vi-page-up"                =>'',
   "page-down"                 =>'',
   "vi-page-down"              =>'',
   "cursor-left"               =>'',
   "cursor-right"              =>'',
   "cursor-up"                 =>'',
   "cursor-down"               =>'',
   "begin-line"                =>'',
   "begin-line-text-toggle"    =>'',
   "brief-home"                =>'',
   "vi-begin-line"             =>'',
   "vi-begin-line-insert-mode" =>'',
   "brief-end"                 =>'',
   "end-line"                  =>'',
   "vi-end-line"               =>'',
   "brief-end"                 =>'',
   "vi-end-line-append-mode"   =>'',
   "mou-click"                 =>'',
   "mou-select-word"           =>'',
   "mou-select-line"           =>'',
   "next-word"                 =>'',
   "prev-word"                 =>'',
   "cmdline-toggle"            =>tagwin_next_window
};

void edit1.\0-ON_SELECT()
{
   lastevent=last_event();
   eventname=event2name(lastevent);
   if (eventname=='ESC') {
      tagwin_next_window();
      return;
   }
   if (eventname=='A-F4') {
      if (!p_active_form.p_isbutton_bar) {
         p_active_form._delete_window();
         return;
      }else{
         safe_exit();
         return;
      }
   }
   if (upcase(eventname)=='LBUTTON-DOUBLE-CLICK') {
      tagwin_mode_enter();
      return;
   }
   key_index=event2index(lastevent);
   root_keys_index=find_index('default-keys',EVENTTAB_TYPE);
   name_index=eventtab_index(root_keys_index,edit1.p_mode_eventtab,key_index);
   command_name=name_name(name_index);
   if (command_name=='safe-exit') {
      safe_exit();
      return;
   }
   switch (TagWinCommands:[command_name]._varformat()) {
   case VF_FUNPTR:
      junk=(*TagWinCommands:[command_name])();
      break;
   case VF_LSTR:
      //junk=(*TagWinCommands:[command_name][0])(TagWinCommands:[command_name][1]);
      call_index(name_index);
      break;
   }
   if (select_active()) deselect();
}

_command activate_tagwin()
{
   //wid=_find_formobj(TAG_FORM_NAME_STRING,'N');
   wid=_GetTagwinWID();
   if (wid) {
      if (wid.p_child.p_object==OI_SSTAB) {
         tabid=wid.p_child;
         for (i=0;i<tabid.p_NofTabs;++i) {
            text=tabid._getTabInfo(i);
            parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
            caption = stranslate(extractCaption(theRest),'','&');
            if (caption==SYMBOL_TAB_CAPTION_STRING) {
               tabid.p_ActiveTab=i;
            }
         }
      }
      wid.ctltagname._set_focus();
   }
}
#if 0
_command alt_goto_tagwin()
{
   keyname=event2name(last_event());
   parse keyname with prefix'-'key;
   if (isinteger(key)) {
      linenum=key;
   }else{
      linenum=1;
   }
   //wid=_find_formobj(TAG_FORM_NAME_STRING,'N');
   wid=_GetTagwinWID();
   if (wid) {
      p_window_id=wid;
      if (edit1.p_buf_id!=EditWindowBufferID||linenum>edit1.p_Noflines) {
         return(0);
      }
      edit1.p_RLine=linenum;
      edit1.get_line(line);
      if (line!='') {
         parse line with type_name"\t"tag_name"\t"filename;
      }
      edit1.DisplayFile(filename,line_no);
   }else{
      message("This command requires the Symbols toolbar");
   }
}
#endif


void edit1.rbutton_up()
{
   // Get handle to menu:
   index=find_index("_tagbookmark_menu",oi2type(OI_MENU));
   menu_handle=p_active_form._menu_load(index,'P');

   flags=def_tagwin_flags;
   pushTgConfigureMenu(menu_handle, flags, 0);

   // Show menu:
   mou_get_xy(x,y);
   _KillToolTipMessages();
   status=_menu_show(menu_handle,VPM_RIGHTBUTTON,x-1,y-1);
   _menu_destroy(menu_handle);
}

#if 0
//11:39am 8/12/1997
//This could be used to automatically activate this tab if the toolbar is
//up or something like that
_switchbuf_show_tagwin()
{
   ext=_mdi.p_child.p_extension;
   if (file_eq(ext,substr(_macro_ext,2))) {
      index=0;
   }else{
      index=find_index(ext'_proc_search',PROC_TYPE);
      if (index) {
         show(TAG_FORM_NAME_STRING);
      }
   }
}
#endif

ctltagfiles.lbutton_up()
{
   if (p_isbutton_bar) {
      _mdi.show('_tag_form');
   } else {
      show('_tag_form');
   }
}
void _TagFileRefresh_symbols()
{
   if (gtagwin_in_quit_file) {
      return;
   }
   wid=_find_formobj('_tboutput_form','N');
   if (wid) {
      _control ctltagname;
      wid.ctltagname.call_event(wid.ctltagname,ON_CHANGE);
   }
}
