/*
$VerboseHistory: vc.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:24a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:24a
 * Comment:
 * Removed keep dir support.
 * Change message box to display question mark icon.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/08/1997 03:10p
 * Comment:
 * Adding new 3.0 stuff
*/
/*
   8/5/1996:  Extension changed on temp files.  Needed for demo.
*/
#include 'slick.sh'


int def_cd;
_str _vcdebug=0;
static _str creating;  // Just a flag for to avoid a couple of on_change events
static _str _last_inwildcards;
static _str _last_outwildcards;


#if __UNIX__
   #define VCSYSTEM_FILE       'uvcsys.slk'
   #define VCUSER_SYSTEM_FILE  'uservc.slk'
   #define VC_ERROR_FILENAME   'vcs.slk'
   #define VC_ERROR_FILENAME2  'vcs2.slk'
   #define VC_COMMENT_FILENAME 'cmt.slk'
#else
   #define VCSYSTEM_FILE       'vcsystem.slk'
   #define VCUSER_SYSTEM_FILE  'uservc.slk'
   #define VC_ERROR_FILENAME   '$vcs.slk'
   #define VC_ERROR_FILENAME2  '$vcs2.slk'
   #define VC_COMMENT_FILENAME '$cmt.slk'
#endif


int def_vcflags;
//Keep the command lists loaded here...
static int gvcEnableList[];

/*
    WARNING: These constants are duplicated in C code.  If you change
    them you must update the C code.
*/
#define VCGET        0
#define VCCHECKOUT   1
#define VCCHECKIN    2
#define VCUNLOCK     3
#define VCADD        4
#define VCLOCK       5
#define VCREMOVE     6
#define VCHISTORY    7
#define VCDIFF       8
#define VCPROPERTIES 9
#define VCMANAGER    10


static void _vcquit_error_file()
{
   quit_error_file(_vcerror_file());
}
static _vcerror_file()
{
   //2:59pm 9/4/1997
   //Don't want to use Config dir on Source Safe
   tmp=get_env('TMP');
   if (tmp=='') {
      tmp=get_env('TEMP');
   }
   if (tmp=='') tmp=_config_path();
   if (last_char(tmp)!=FILESEP) {
      tmp=tmp:+FILESEP;
   }
   return(tmp:+VC_ERROR_FILENAME);
}
static _vcerror_file2()
{
   //2:59pm 9/4/1997
   //Don't want to use Config dir on Source Safe
   tmp=get_env('TMP');
   if (tmp=='') {
      tmp=get_env('TEMP');
   }
   if (tmp=='') tmp=_config_path();
   if (last_char(tmp)!=FILESEP) {
      tmp=tmp:+FILESEP;
   }
   return(tmp:+VC_ERROR_FILENAME2);
}

int _prjclose_vc()
{
   if (machine()=='NT386' && _isscc()) {
      vsSccCloseProject();
   }
   return(0);
}

int _prjopen_vc()
{
   vcs=def_vc_system;
   if (vcs=='') {
      // This case naturally happens when a new project is created.
      //_message_box(nls("You must have a version control system set for the current project to use Check-In/Check-Out from the command line."));
      return(1);
   }
   _ini_get_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',vcsproject,'')

   vcsproject=substr(vcsproject,SCC_PREFIX_LENGTH+1);
   vcsproject=MaybeStripLeadingVCSName(vcsproject,prjvcs);

   if (machine()=='NT386' && _isscc(def_vc_system) && 
       vcsproject!=vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME)) {
      //If _srg_project opened this already, skip it
      vcs=substr(def_vc_system,5);
      if (vcs!=vsSccGetCurProjectInfo(VSSCC_PROVIDER_NAME)) {
         status=vsSccInit(vcs);
         if (status) {
            _message_box(nls("Could not initialize %s",def_vc_system));
            return(status);
         }
      }
      _ini_get_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcslocalpath',vcslocalpath,'')

      //Order is important here...
      //vcsproject=substr(vcsproject,SCC_PREFIX_LENGTH+1);
      vcslocalpath=substr(vcslocalpath,SCC_PREFIX_LENGTH+1);

      //vcsproject=MaybeStripLeadingVCSName(vcsproject,prjvcs);
      vcslocalpath=MaybeStripLeadingVCSName(vcslocalpath,localpathvcs);

      if (prjvcs==vcs && localpathvcs==vcs) {
         //use project and local_path because they are the stripped versions(no SCC:)
         status=vsSccOpenProject(0,'',vcsproject,vcslocalpath);
         if (status) {
            _message_box(nls("Could not open %s project %s",vcs,vcsproject));
            vsSccCloseProject();
            //return(status);
            return(0);//Don't want to stop restore...
         }
      }
   }else{
      parse vcsproject with project_option ',' info
      if (lowcase(project_option)=='command') {
         _ini_get_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',vcsproject,'')
         if (vcsproject=='') {
            // This case naturally happens when a new project is created.
            return(1);
         }
         styles='';
         comment='';
         command=_vcparse_command(vcs, info, '', _project_name, vcsproject, comment,'',styles);
         status=shell(command,'p');
         if (status) {
            _message_box(nls("Failed to set VCS Project by executing the command:\n\n%s",command));
            return(status);
         }
      }
   }
   vcGetList(gvcEnableList);
   return(0);
}
static _vccomment_file()
{
   //2:59pm 9/4/1997
   //Don't want to use Config dir on Source Safe
   tmp=get_env('TMP');
   if (tmp=='') {
      tmp=get_env('TEMP');
   }
   if (tmp=='') tmp=_config_path();
   if (last_char(tmp)!=FILESEP) {
      tmp=tmp:+FILESEP;
   }
   return(tmp:+VC_COMMENT_FILENAME);
}

/*
    p_user variables used

    _project_files.p_user       Used to make sure that file list is not filled
                                in more than once.
    _openfn.p_user           Last filespec wildcard(s) used to fill in file
                             list box.

    _ok.p_user               Current directory when dialog box was displayed.

*/
defeventtab _vc_form

_openfile_types.on_destroy()
{
   // This can happen if destroy the window becuase user wants to edit
   // the dialog
   checking_in = lowcase(p_active_form.p_caption) == 'check in';
   parse _openfile_types.p_text with '('wildcards')'
   if (checking_in) {
      _last_inwildcards=wildcards;
   } else {
      _last_outwildcards=wildcards;
   }
}
_openfile_types.on_drop_down(reason)
{
   switch (reason) {
   case DROP_UP:
      parse p_cb_list_box._lbget_seltext() with '('files')'
      if (files!='') {
         _vcopen_set_wildcards(files);
         fill_in_sf_listbox();
         _openfn.p_text=files;
         _openfn._set_sel(1);
      }
   }
}
void _vc_form.'F1'()
{
   checking_in = lowcase(p_active_form.p_caption) == 'check in';
   if (checking_in) {
      name='Check In dialog box';
   } else {
      name='Check Out dialog box';
   }
   help(name);
}
_invert.lbutton_up()
{
   _openfile_list._lbinvert();
   _openfile_list.call_event(CHANGE_SELECTED,_openfile_list,ON_CHANGE,'');
}
_prompt_for_each.lbutton_up()
{
   _discard_changes.p_value=0;
}
_discard_changes.lbutton_up()
{
   _new_archive.p_value=0;
   _prompt_for_each.p_value=0;
}
_new_archive.lbutton_up()
{
   _discard_changes.p_value=0;
}
_save_settings.lbutton_up()
{
#if 0
   _ini_set_value(_project_get_filename(), _vcs_project_get_section("COMPILER"), 'vcs', _vc_system.p_text);
   _ini_set_value(_project_get_filename(), _vcs_project_get_section("COMPILER"), 'vcsproject', _vcs_project.p_text);
   if (_vcs_project.p_text!=_vcs_project.p_user) {
      _prjopen_vc();
   }
   _vcs_project.p_user=_vcs_project.p_text;
#endif
}

static put_files_in_box(var filelist_id)
{
   orig_view = p_view_id;
   p_view_id = filelist_id;
   top();up();
   for (;;) {
      down()
      if (rc) {
         break;
      }
      get_line(line);
      parse line with 'srcfiles' '=' src_filespec;
      if (src_filespec != '' && iswildcard(src_filespec)) {
         orig_view._openfile_list.insert_file_list('-v +p ':+src_filespec);
      }else if(src_filespec != ''){
         orig_view._openfile_list._lbadd_item(src_filespec);
      }
   }
   _delete_temp_view(filelist_id);
   p_view_id = orig_view;
   _openfile_list._lbsort(_fpos_case' -f');
   _openfile_list._remove_duplicates();
   _openfile_list.top();
}
void _checkinout.lbutton_up()
{
   _ok.call_event(1,_ok,LBUTTON_UP,'');
}
void _ok.lbutton_up()
{

   checking_in = lowcase(p_active_form.p_caption) == 'check in';
   open_wildcards=arg(1);
   result=_vcopen_get_result(open_wildcards);
   if (result=='') return;
   options='';
   if (_edit.p_value) {
      options=options:+' +e';
   } else if(!checking_in){
      options=options:+' -e';
   }
   if (_read_only.p_value) {
      options=options:+' +r';
   }
   if (_prompt_for_each.p_value) {
      options=options:+' +p';
   }
   if (_discard_changes.p_value) {
      options=options:+' +d';
   }
   if (_new_archive.p_value) {
      options=options:+' +new';
   }
#if 0
   _ini_set_value(_project_get_filename(), _vcs_project_get_section("COMPILER"), 'vcs', _vc_system.p_text);
   _ini_set_value(_project_get_filename(), _vcs_project_get_section("COMPILER"), 'vcsproject', _vcs_project.p_text);
   if (_vcs_project.p_text!=_vcs_project.p_user) {
      _prjopen_vc();
   }
#endif

   p_active_form._delete_window(options' 'result);
}
static void _vcopen_set_wildcards(wildcards)
{
   if (_project_files.p_value) return;
   _openfn.p_user=wildcards;
}
static _str _vcopen_get_wildcards()
{
   if (_project_files.p_value) return('');
   wildcards=_openfn.p_user;
   if (wildcards=='') {
      wildcards=ALLFILES_RE;
   }
   return(wildcards);
}

static _str _vcopen_get_result()
{
   open_wildcards=arg(1)!=''
   //parse _openfn.p_user with flags default_ext name_part .
   name_part='';

   checking_in = lowcase(p_active_form.p_caption) == 'check in';
   flags=OFN_ALLOWMULTISELECT;
   if (checking_in) {
      flags|=OFN_FILEMUSTEXIST;
   }
   default_ext='.'
   hit_dir=0;
   hit_wildcard=0;
   hit_normal=0;
   rest=_openfn.p_text;
   hit_semi= -1;
   wildcards='';
   path='';
   result='';
   bresult='';  // result not in abolute form for retrieval
   cwd=_opendir_list._dlpath();
   vcs=def_vc_system;
   vcsproject=_ini_get_value(_project_get_filename(), _vcs_project_get_section("COMPILER"),'vcsproject','');
   vcsproject=MaybeStripLeadingVCSName(vcsproject);
   if (vcs=='') {
      return(1);
   }
   //_ini_get_value(_vcssystem_file(),vcs, "styles", styles);
   _vc_get_value(vcs, "styles", styles);
   for (;;) {
      parse rest with filenames ';' rest;
      if (filenames=='') break;
      ++hit_semi;
      for (;;){
         if ((flags & OFN_SAVEAS) || !(flags & OFN_ALLOWMULTISELECT)) {
            bfilename=maybe_quote_filename(filenames);
            filenames='';
         } else {
            bfilename=parse_file(filenames);
         }
         if (bfilename=='') break;
         filename=_absolute2(bfilename,cwd);
         // Check if this is a directory specification.
         if (isdirectory(filename)) {
            hit_dir=1;
            path=filename;
            name_part='';
         } else {
            if (default_ext!='.' && filename==strip_filename(filename,'e')) {
               filename=maybe_quote_filename(strip(filename,'B','"')'.'default_ext);
            }
            result=result' 'filename;
            if (bresult=='') {
               bresult=bfilename;
            } else {
               bresult=bresult' 'bfilename;
            }
            filename=strip(filename,'B','"');

            if (pos('sstree',styles,1,'i') && _ssxlat_dir(filename,vcs,styles)=='') {
               status=1;
               _message_box(nls('The file %s is not in or below the current project',filename),
                            p_active_form.p_caption
                         );
               text=_openfn.p_text;_openfn.set_command text,1,length(text)+1;_set_focus();
               return('');
            }

            new_path=strip_filename(filename,'N');
            name_part=strip_filename(filename,'P');
            // Check if path exists
            if (new_path!=''){
               path=new_path;
               if(!isdirectory(new_path)) {
                  _message_box(new_path"\n"nls("Path does not exist.")"\n":+
                               nls("Please verify that the correct path was given."),
                               p_active_form.p_caption
                            );
                  text=_openfn.p_text;_openfn.set_command text,1,length(text)+1;_set_focus();
                  return('')
               }
            }
         }
         if (!open_wildcards && iswildcard(name_part)) {
            wildcards=wildcards' 'name_part;
            hit_wildcard=1;
         } else if(name_part!=''){
            ++hit_normal;
         }
         if ((hit_normal && (hit_wildcard || hit_dir || hit_semi)) ||
             (hit_normal>1 && !(flags & OFN_ALLOWMULTISELECT))) {
            _message_box(result"\n"nls("The above file name is invalid."),
                         p_active_form.p_caption
                         );

            text=_openfn.p_text;_openfn.set_command text,1,length(text)+1;_set_focus();
            return('')
         }
      }
   }
   if (hit_normal) {
      if ((flags & OFN_FILEMUSTEXIST)||
           ((flags & OFN_SAVEAS) && !(flags & OFN_NOOVERWRITEPROMPT)) ) {
         rest=result;
         for (;;) {
            filename=parse_file(rest);
            if (filename=='') break;
            file_exists=file_match('-p 'filename,1)!='';
            if (flags & OFN_FILEMUSTEXIST) {
               if(!file_exists) {
                  _message_box(filename"\n"nls("File not found.")"\n":+
                            nls("Please verify that the correct file name was given."),
                               p_active_form.p_caption
                              );
                  p_window_id=_openfn;
                  text=_openfn.p_text;_openfn.set_command text,1,length(text)+1;_set_focus();
                  return('');
               }
            }
            if (flags & OFN_SAVEAS) {
               if (file_exists) {
                  status=_message_box(nls("%s already exists.",filename)"\n\n":+
                            nls("Replace existing file?"),
                            p_active_form.p_caption,
                            MB_YESNO|MB_DEFBUTTON2|MB_ICONQUESTION
                            )
                  if (status==IDNO) {
                     p_window_id=_openfn;
                     text=_openfn.p_text;_openfn.set_command text,1,length(text)+1;_set_focus();
                     return('');
                  }
               }
            }
         }
      }
      result=strip(result);
      if (result=='') {
         return('');
      }
      if (pos("vcp_required",styles,1,'i') && vcsproject=='' && !pos("sslocate",styles,1,'i')) {
          _message_box("The VCS Project must be set.  Use Version Control Setup Dialog.");
          return('');
      }
      //if (!(flags & OFN_SAVEAS)) {
      //   _append_retrieve(_openfn,bresult,_openfn.p_cb_picture.p_user)
      //}
      return(result);
   }
   wildcards=strip(wildcards);
   if (!hit_wildcard && !hit_dir && (flags & OFN_ALLOWMULTISELECT)){
       if (pos("vcp_required",styles,1,'i') && vcsproject=='' && !pos("sslocate",styles,1,'i')) {
          _message_box("The VCS Project must be set.  Use Version Control Setup Dialog.");
           return('');
       }
       /* Nothing selected? */
       result=_openfile_list._lbmulti_select_result(1)
       if (result=='') {
          return('');
       }
       return(strip(result));
   }
   if (!hit_normal && !hit_wildcard && !hit_dir) return('');
   if (wildcards=='') {
      wildcards=_vcopen_get_wildcards();
   }
   // Convert *.c *.h to *.c;*.h
   rest=wildcards;
   wildcards='';
   for (;;) {
      wildcard=parse_file(rest);
      if (wildcard=='') break;
      if (wildcards!='') {
         wildcards=wildcards';'wildcard;
      } else {
         wildcards=wildcard;
      }
   }
   if (path!='') {
      _vcopen_set_wildcards(wildcards);
      p_window_id=_openfn;
#if __PCDOS__
      fill_in_sf_listbox();
      //_openfile_list._flfilename(wildcards,path,1)
      if (substr(path,1,2)=='\\') {
         _opendir_list._dlpath(path);
         parse path with '\\'  server '\' sharep'\' rest;
         unc_name='\\'server'\'sharep;
         _opendrives._dvldrive(unc_name);
      } else {
         _opendir_list._dlpath(path);
         _opendrives._dvldrive('');
      }
#else
      //chdir path,1
      fill_in_sf_listbox();
      _opendir_list._dlpath('');
      //_opendrives._dvldrive('')
#endif
      _set_sel(1,length(p_text)+1);
   } else {
      _vcopen_set_wildcards(wildcards);
      fill_in_sf_listbox();
      //_openfile_list._flfilename(wildcards)
   }
   return('');
}
static init_vc_form_project(use_ini_vcs)
{
   if (_project_name=='') {
      _project_files.p_enabled=0;
      //_vcs_project.p_text='';
      //_vcs_project.p_enabled=_vcs_projectlab.p_enabled=0;
      if (_project_files.p_value) {
         ++creating;
         _use_filespec.p_value=1;
         --creating;
      }
   } else {
      _project_files.p_enabled=1;
      //_vcs_project.p_enabled=_vcs_projectlab.p_enabled=1;
   }
   _ini_get_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',vcsproject,'');
   vcsproject=MaybeStripLeadingVCSName(vcsproject);
#if 0
   _vcs_project.p_text=vcsproject;
   if (use_ini_vcs) {
      vcs=def_vc_system;
      if (vcs=='') {
         last_data='';
         if (machine()=='OS2386') {
            _vc_system.p_cb_list_box._lbi_search(last_data,'PVCS for OS/2');
         } else {
            _vc_system.p_cb_list_box._lbi_search(last_data,'PVCS');
         }
      } else {
         _vc_system.p_cb_list_box._lbsearch(vcs);
      }
      ++creating;
      _vc_system.p_text = _vc_system.p_cb_list_box._lbget_text();
      --creating;
      _vcs_project.p_user=_vcs_project.p_text;
   }

   vcs=_vc_system.p_text;
#endif
   vcs=def_vc_system;
   if (vcs=='') {
      return(1);
   }
   //status=_ini_get_value(_vcssystem_file(), vcs, 'archive_filespec', archive_filespec,'');
   status=_vc_get_value(vcs, 'archive_filespec', archive_filespec,'');
   //_ini_get_value(_vcssystem_file(),vcs, "styles", styles);
   _vc_get_value(vcs, "styles", styles);
   filetypes=_openfile_types.p_user;
   wildcards=_openfn.p_user;

   old_line=_openfile_types.p_cb_list_box._lbget_text();
   if (old_line!='') {
      parse old_line with '(' wildcards ')';
   }

   _openfile_types.p_cb_list_box._lbclear();
   // add to _openfile_types
   orig_wid=p_window_id;
   p_window_id=_openfile_types.p_cb_list_box;
   if (wildcards=='') {
      parse filetypes with '('wildcards')';
      if (wildcards=='') {
         wildcards=ALLFILES_RE;
      }
   }
   for (;;) {
      line=_parse_line(filetypes,',');
      if (line=='') break;
      if (pos('(*.e;',line)) {
         line=stranslate(line,'(*'_macro_ext';','(*.e;')
      }
      _lbadd_item(line);
   }
   if (archive_filespec!='' && pos('pvcs_wildcards',styles,1,'i')) {
      _lbadd_item('Archive Files ('archive_filespec')');
   }
   top();
   status=search(LB_RE:+'?*\(':+_escape_re_chars(wildcards)'\)','ri@');
   if (status) {
       parse _lbget_text() with '(' wildcards ')';
   }
   _openfile_types.p_text=_lbget_text();

}

_ok.on_destroy()
{

   cwd=_ok.p_user;
   if (!_openchange_dir.p_value && cwd!=getcwd()) {
      /* Restore original directory. */
      chdir(cwd,1);
      call_list('_cd_');
   }
}

_ok.on_create()
{
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_ALLOW_DIALOG_ACCESS_TO_PROJECTS)) {
      _open_project.p_visible=0;
      _edit_project.p_visible=0;
   }
   caption=arg(1);
   init_filename=arg(2);
   wildcards=arg(3);
   filetypes=arg(4);
   if (filetypes=='') filetypes=def_file_types;
   _openfile_types.p_user=filetypes;
   _openfn.p_user=wildcards;

   creating=1;
   _ok.p_user=getcwd();
   if (def_change_dir) _openchange_dir.p_value=1;


   init_vc_form_project(1);


   _opendir_list.p_user = _opendir_list._dlpath(_dvldrive() );
   _opendir_list._dlpath(_dvldrive());

   checking_in=lowcase(caption) == 'check in';
   if (checking_in) {
      _checkinout.p_caption='C&heck In'
      _discard_changes.p_visible = 1;
      _edit.p_visible = 0;
      _edit.p_value=0;
      _new_archive.p_visible = 1;
      _prompt_for_each.p_visible = 1;
      _read_only.p_visible = 0;
   }else{
      _discard_changes.p_visible = 0;
      _edit.p_visible = 1;
      _new_archive.p_visible = 0;
      _prompt_for_each.p_visible = 0;
      _read_only.p_visible = 1;
   }
   p_active_form.p_caption = caption;
   //vcs=_vc_system.p_text;
   _openfn.p_text=(init_filename=='')?wildcards: init_filename;
   _use_filespec.p_value=1;
   creating=0;
   p_active_form.fill_in_sf_listbox();
}

#if 0
void _vc_system.on_change()
{
   if (creating) return;
   init_vc_form_project(0);
}

#endif
void _use_filespec.lbutton_up()
{
   if (creating) return;
   _openfn.p_text=_vcopen_get_wildcards();
   allow_chdir(1);
   fill_in_sf_listbox();
}

_project_files.lbutton_up()
{
   fill_in_sf_listbox();
   allow_chdir(0);
}

static allow_chdir(value)
{
   _openfile_typeslab.p_enabled=_openfile_types.p_enabled=
#if _NAME_HAS_DRIVE
          _opendriveslab.p_enabled=_opendrives.p_enabled=
#endif
           _sddir_listlab.p_enabled=_opendir_list.p_enabled=
            _openfn.p_enabled=_fslabel.p_enabled=value;
}

_openfn.on_change()
{
   if (creating) {
      return('');
   }
   list=_control _openfile_list;
   if (list.p_Nofselected) {
      list._lbdeselect_all();
      _opennofselected.p_caption=list.p_Nofselected' of 'list.p_Noflines' selected'
   }
}

static void fill_in_sf_listbox()
{
   if (creating) return;
   if (_project_files.p_value) {
      option='p';
   } else {
      option='f';
   }
   path=_opendir_list._dlpath();
   wildcards=_vcopen_get_wildcards();
   new_list=option:+path:+wildcards;
   if (new_list:==_project_files.p_user) return;
   _project_files.p_user=new_list;
   wid=p_window_id;
   _openfile_list._lbclear();
   if (!_project_files.p_value) {
      for (;;) {
         parse wildcards with filename ' |;','r' wildcards;
         if (filename=='') break;
         _openfile_list.insert_file_list('-v -p 'maybe_quote_filename(path:+filename));
      }
   }else{
      get_view_id(view_id);
      //11:45am 8/18/1997
      //Dan changed for makefile support
      //status=_ini_get_section(_project_get_filename(), "FILES", temp_view_id);
      status=GetProjectFiles(_project_get_filename(), temp_view_id);
      if (status) {
         return;
      }
      activate_view(temp_view_id);
#if 0
/* I think this should work, and be a little faster, but deletes the top line. */
      mark_id=_alloc_selection();
      top();_select_line(mark_id);
      bottom();_select_line(mark_id);
      _shift_selection_right(mark_id);
      activate_view(view_id);
#else
/* Using this instead */
      top();up();
      for (;;) {
         if (down()) {
            break;
         }
         get_line(line);
         wid._openfile_list._lbadd_item(line);
      }
      _delete_temp_view(temp_view_id);
#endif
   }
   p_window_id=wid;
   _openfile_list._lbsort('-f');
   _openfile_list._lbtop();
   _opennofselected.p_caption = '0 of '_openfile_list.p_Noflines' selected';
}

_open_project.lbutton_up()
{
   wid=p_window_id;
   old_project_name=_project_name;
   project_open();
   // IF project changed AND project form not editted by dialog editor.
   if (old_project_name!=_project_name && _iswindow_valid(wid)) {
      p_window_id=wid;
      init_vc_form_project(1);
      fill_in_sf_listbox();
   }
}

_edit_project.lbutton_up()
{
   project_edit();
}

void _openfile_list.lbutton_double_click()
{
   _ok.call_event(_ok, LBUTTON_UP);
}

void _openfile_list.on_change(reason)
{
   if (reason!=CHANGE_SELECTED) return;
   creating=1;
   Nofselected=_openfile_list.p_Nofselected;
   _opennofselected.p_caption = Nofselected' of '_openfile_list.p_Noflines' selected';
   if (Nofselected==1 && _lbisline_selected()) {
      _openfn.p_text=maybe_quote_filename(_lbget_text());
   }
   if (Nofselected>1){
      _openfn.p_text='';
   }
   creating=0;
}

_str get_src_file(project_name)
{
   status=_project_get_all(project_name, temp_view_id);
   orig_view = p_view_id;
   p_view_id = temp_view_id;
   top();up();
   for (;;) {
      down();
      if (rc) {
         break;
      }
      get_line(line);
      parse line with 'srcfiles' '=' srcfile_spec;
      if (srcfile_spec == '') {
         _delete_line();
      }
   }
   p_view_id = orig_view;
   return(temp_view_id);
}

static get_vc_system(project_name)
{
   _project_get_info(project_name, 'vcs', info);
   return(info);
}

static checkout_error(filename)
{
   junk=0;process_events(junk);//process_events has a call by reference parameter
   _message_box(nls("An error occured while checking out the file %s.\nThe file may be checked out already, or there may be no archive file for %s",filename, filename));
   return(1);
}

/*
   Get current buffer name.  May be for check in current buffer.
*/
static _str vcinit_filename()
{
   if (_isEditorCtl()) {
      return(maybe_quote_filename(p_buf_name));
   }
   return('');
}

_command int maybe_set_readonly() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   if (_isdiffed(p_buf_id)) {
      return(0);
   }
#if __UNIX__
#if 0
   attrs=file_list_field(p_buf_name,DIR_ATTR_COL,DIR_ATTR_WIDTH);
   if (attrs=='') return(0);
   w=pos('w',attrs,'','i');
   if (!p_readonly_set_by_user) {
      if (ro) {
         read_only_mode();
      }else if (!ro) {
         if (p_readonly_mode) {
            read_only_mode_toggle();
         }
      }
      p_readonly_set_by_user=0;
   }
#endif
   return(0);
#else
   attrs=file_list_field(p_buf_name,DIR_ATTR_COL,DIR_ATTR_WIDTH);
   if (attrs=='') return(0);
   ro=pos('r',attrs,1,'i');
   if (!p_readonly_set_by_user) {
      if (ro) {
         read_only_mode();
      }else if (!ro) {
         if (p_readonly_mode) {
            read_only_mode_toggle();
         }
      }
      p_readonly_set_by_user=0;
   }
   return(0);
#endif
}

_command old_checkin()  name_info(FILE_ARG'*,'VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_NOEXIT_SCROLL|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   /* Command line operation:

      +c [comment]         Comment for all files
      +p                   Promt for each comment
      +d                   Discard changes
      +new                 Create a new archive file for all files
      .                    Check-in current buffer
   */
   result=arg(1);
   if (result == '') {
      get_view_id(orig_view_id);
      _str filename;
      filename = "";
      if (arg() > 1) filename = arg(2);
      if (filename == "") {
         filename = vcinit_filename();
      }
      was_recording=_macro();
      _macro_delete_line();
      result=show('-mdi -modal -reinit _vc_form',
                  'Check In',filename,_last_inwildcards,def_file_types);
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      result=strip(result);
      _macro('m',was_recording);
      _macro_call('old_checkin',result);
      activate_view(orig_view_id);
   }
   get_view_id(orig_view_id);
   status=checkin_cl(result);
   activate_view(orig_view_id);
   if (!status) {
      maybe_set_readonly2();
   }
   return(status);
}

static _vcssystem_file()
{
   file_part=arg(1);
   if (file_part=='') {
      file_part=VCSYSTEM_FILE;
   }
   filename=slick_path_search(file_part);
   if (filename=='') {
      return(_config_path():+file_part);
   }
   return(filename);
}

static _vcsuser_file()
{
   _str file_part=arg(1);
   if (file_part=='') {
      file_part=VCUSER_SYSTEM_FILE;
   }
#if 0
   filename=slick_path_search(file_part);
   if (filename=='') {
      return(_config_path():+file_part);
   }
   return(filename);
#else
   return(_config_path():+file_part);
#endif
}

static checkin_cl(arglist)
{
   vcs=def_vc_system;
   if (vcs=='') {
      _message_box(nls("You must have a version control system set for the current project to use Check-In/Check-Out from the command line."));
      return(1);
   }
   _vcquit_error_file();
   status=delete_file(_vcerror_file());
   file_added=0;
   current_filename="";
   if (_isEditorCtl()) {
      current_filename=absolute(p_buf_name);
   }
   prompt_for_each_comment=0;discard_changes=0;new_archive_files=0;current_buffer=0;
   grabbed_comment=0;
   comment=NULL_COMMENT;
   filenames='';
   for (;;) {
      if (grabbed_comment) {
         break;
      }
      s=parse_file(arglist);
      if (s=='') {
         break;
      }
      pm=substr(s,1,1);
      if (pm=='+'||pm=='-') {
         switch (lowcase(substr(s,2))) {
         case 'c':
            prompt_for_each_comment=0;
            comment=arglist;// Everything remaining in line should be a comment
            grabbed_comment=1;
            break;
         case 'p':
            prompt_for_each_comment=1;
            break;
         case 'd':
            discard_changes=pm=='+';
            break;
         case 'new':
            new_archive_files=pm=='+';
            break;
         }
      } else {
         /* It's a filename */
         file_added=1;
         if (s=='.') {
            s=current_filename;
         }
         filenames=filenames' 'maybe_quote_filename(s);
      }
   }
   if (!file_added) {
      _message_box(nls("No files were specified."));
      return('');
   }
   orig_view_id=_create_temp_view(errors_view_id);
   if (orig_view_id=='') return(1);
   activate_view(orig_view_id);
   status=_checkin(linenum,errors_view_id,filenames, vcs, new_archive_files, discard_changes,prompt_for_each_comment, comment)
   show('-modal _vc_error_form',errors_view_id,linenum);
   delete_file(_vccomment_file());
   return(status);
}

static void maybe_set_readonly2()
{
   if((def_vcflags&VCF_SET_READ_ONLY)) {
      if (_isEditorCtl() && (p_buf_flags & HIDE_BUFFER)) {
         maybe_set_readonly();
      }
      if(!_no_child_windows()) {
         _mdi.p_child.for_each_buffer('maybe_set_readonly');
      }
   }
}

/* Command Line operation:

   checkout <options> filespec [filespec[..filespec]]

   Valid options are:

   +r Check out read only

   +e Edit newly checked out files

   .  Check out current buffer
*/
_command old_checkout(...) name_info(FILE_ARG'*,'VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_NOEXIT_SCROLL|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   old_def_actapp=def_actapp;
   def_actapp=0;
   result=arg(1);
   if (result == '') {
      get_view_id(orig_view_id);
      _str filename;
      filename = "";
      if (arg() > 1) filename = arg(2);
      if (filename == "") {
         filename = vcinit_filename();
      }
      was_recording=_macro();
      _macro_delete_line();
      result=show('-mdi -modal -reinit _vc_form',
               'Check Out',filename,_last_outwildcards,def_file_types);

      if (result=='') {
         def_actapp=old_def_actapp;
         return(COMMAND_CANCELLED_RC);
      }
      _macro('m',was_recording);
      _macro_call('old_checkout');
      activate_view(orig_view_id);
   }
   get_view_id(orig_view_id);
   status=checkout_cl(result);
   activate_view(orig_view_id);
   def_actapp=old_def_actapp;
   if (!status) {
      maybe_set_readonly2();
   }
   return(status);
}

static checkout_cl(arglist)
{
   _param1="";
   vcs=def_vc_system;
   if (vcs=='') {
      _message_box(nls("You must have a version control system set for the current project to use Check-In/Check-Out from the command line."));
      return(1);
   }
   _vcquit_error_file();
   status=delete_file(_vcerror_file());
   current_filename="";
   if (_isEditorCtl()) {
      // SourceSafe needs the path or sstree does not work.
      current_filename=p_buf_name;
   }
   read_only=0;edit_files=1;files_added=0;
   filenames='';
   _str list[];
   for (;;) {
      filename=parse_file(arglist);
      if (filename=='') {
         break;
      }
      pm=substr(filename,1,1);
      if (pm=='+'||pm=='-') {
         switch (lowcase(substr(filename,2))) {
         case 'r':
            read_only=pm=='+';
            break;
         case 'e':
            edit_files=pm=='+';
            break;
         }
      } else {
         files_added=1;
         /* Its a file */
         if (filename=='.') {
            filename=current_filename;
         }
         if (substr(filename,1,1)=='@') {
            status=_open_temp_view(substr(filename,2),temp_view_id,orig_view_id,"+b");
            if (!status) {
               top();up();
               for (;;) {
                  if (down()) break;
                  line=_lbget_text();
                  list[list._length()]=line;
               }
               _delete_temp_view(temp_view_id);
               activate_view(orig_view_id);
            }
            filenames=filenames' 'filename;
         } else {
            filenames=filenames' 'maybe_quote_filename(absolute(filename));
         }
      }
   }
   if (!files_added) {
      _message_box(nls("No files were specified."));
      return('');
   }
   orig_view_id=_create_temp_view(errors_view_id);
   if (orig_view_id=='') return(1);
   activate_view(orig_view_id);
   status=_checkout(linenum,errors_view_id,filenames, vcs, edit_files, read_only);
   show('-modal _vc_error_form',errors_view_id,linenum);
   if (edit_files) {
      if (list._length()) {
         _param1="";
         for (i=0;i<list._length();++i) {
            if (_param1=="") {
               _param1=maybe_quote_filename(list[i]);
            } else {
               _param1=_param1:+" ":+maybe_quote_filename(list[i]);
            }
         }
      } else {
         _param1=strip(filenames);
      }
   } else {
      _param1="";
   }
   return(status);
}



_opendir_list.on_change()
{
   fill_in_sf_listbox();
#if 0
   _openfile_list._lbclear();
   _openfile_list.insert_file_list('-v +p '_openfn.p_text);
   _openfile_list._lbsort(_fpos_case' -f');
   _openfile_list.top();
#endif
}

#if _NAME_HAS_DRIVE
_opendrives.on_change(reason)
{
   switch (reason) {
   case CHANGE_DRIVE:
      _opendir_list._dlpath(_dvldrive());
   }
}
#endif

#if 0
_setup.lbutton_up()
{
   result = show('-modal _vc_setup_form',
                 _vc_system.p_text);
   if (result == '') {
      return(COMMAND_CANCELLED_RC);
   }
}
#endif

defeventtab _vc_comment_form

static void save_restore_comment(_str Option)
{
   static _str LastComment;
   if (Option=='S') {
      LastComment='';
      top();up();
      while (!down()) {
          get_line(line);
          LastComment=LastComment"\n"line;
      }
      LastComment=substr(LastComment,2);//Get rid of leading \n
   }else if (Option=='R') {
      _lbclear();
      for (;;) {
         parse LastComment with CurLine "\n" LastComment;
         if (CurLine=='') break;
         insert_line(CurLine);
      }
      if (!p_Noflines) {
         insert_line('');
      }
   }
}

void _ok.on_create()
{
   filename=arg(1);
   prompt_for_each_comment=arg(2)!='';
   show_use_for_all_cb=arg(3)!='';
   if (prompt_for_each_comment) {
      p_active_form.p_caption=p_active_form.p_caption' for 'filename;
   }
   ctlapply_to_all.p_visible=0;
   if (show_use_for_all_cb) {
      ctlapply_to_all.p_visible=1;
      _ok.p_y+=ctlapply_to_all.p_height;
      _ok.p_next.p_y=_ok.p_y;
      p_active_form.p_height+=ctlapply_to_all.p_height;
   }
   list1.save_restore_comment('R');
}
void _ok.lbutton_up()
{
   _param2=0;
   //_ini_get_value(_project_get_filename(), _vcs_project_get_section("COMPILER"), "vcs", vcs,'');
   vcs=def_vc_system;
   if (vcs=='') {
      p_active_form._delete_window();
      return;
   }
   //_ini_get_value(_vcssystem_file(),vcs, "styles", styles);
   int multiline=0;
   if (_isscc(vcs) && machine()=="NT386") {
      comment_file=0;
      multiline=1;
   }else{
      _vc_get_value(vcs, "styles", styles);
      comment_file=pos('comment_file',styles,1,'i');
   }
   if (comment_file) {
      list1.save_restore_comment('S');
      list1.p_buf_name=absolute(_vccomment_file());
      list1.p_AllowSave=1;
      status=list1.save();
      if (status) {
         return;
      }
      _param1=list1.p_buf_name;
      _param2=ctlapply_to_all.p_value;
      p_active_form._delete_window(0);
      return;
   }
   _param1='';
   if (list1.p_Noflines>1 && !multiline) {
      _message_box(nls("The %s Version Control System is not configured to allow multi-line comments",vcs));
      return;
   }
   if (list1.p_Noflines==1) {
      list1.bottom();
      list1.get_line(_param1);
   }else if (multiline) {
      wid=p_window_id;
      p_window_id=list1;
      top();up();
      while (!down()) {
         get_line(line);
         if (_param1=='') {
            _param1=line;
         }else{
            _param1=_param1:+p_newline:+line;
         }
      }
      p_window_id=wid;
   }
   if (ctlapply_to_all.p_visible) {
      _param2=ctlapply_to_all.p_value;
   }
   p_active_form._delete_window(0);
}


defeventtab _vc_setup_form;

static _ssxlat_dir(filename,vcsproject,styles)
{
   filename=_ssxlat_dir2(strip(filename,'B','"'),vcsproject,styles);
   return(maybe_quote_filename(filename));
}
// Input filename must be absolute
static _ssxlat_dir2(filename,vcsproject,styles)
{
   if (vcsproject=='') {
      return(strip_filename(filename,'P'));
   }
   parse vcsproject with '[' ssdir ']' dir;
   //messagenwait('ssdir='ssdir' dir='dir);

   //3:00pm 9/4/1997
   //Witout this first a trailing space gets turned into a directory
   ssdir=strip(ssdir);
   if (last_char(ssdir)!='/') {
      ssdir=ssdir:+'/';
   }
   if (pos('ssonedir|sslocate',styles,1,'ir')) {
      return(ssdir:+strip_filename(filename,'P'));
   }
   dir=absolute(strip(dir));
   if (last_char(dir)!=FILESEP) {
      dir=dir:+FILESEP;
   }
   prefix=substr(filename,1,length(dir));
   if (!file_eq(prefix,dir)) {
      // filename being checked in is not below this directory.
      // Return invalid filename
      return('');
   }
   filename=translate(ssdir:+substr(filename,length(dir)+1),'/',FILESEP);
   //messageNwait('filename='filename);
   return(filename);
}

#define PARSE_CHAR '%'

static _vcparse_command(vcs,command,buf_name,project_name,vcsproject,var comment,prompt_for_each_comment,styles)
{
   parse command with dosrc rest;
   if (file_eq(dosrc,'dosrc')) {
      // IF the "dosrc" program is not in the path
      if (path_search('dosrc','','P')=='') {
         // Find dosrc in the VSLICKPATH
         dosrc=slick_path_search('dosrc','P');
         command=strip_filename(dosrc,'E')' 'rest;
      }
   }
   j=1
   for (;;) {
     j=pos(PARSE_CHAR,command,j)
     if ( ! j ) { break }
     ch=upcase(substr(command,j+1,1));
     len=2;
     if ( ch=='P' ) {
       s=strip_filename(buf_name,'N');
     } else if ( ch=='F' ) {
       if (pos('sstree|ssonedir|sslocate',styles,1,'ir')) {
          s=_ssxlat_dir(buf_name,vcsproject,styles);
       } else {
          s=relative(buf_name);
       }
     } else if ( ch=='N' ) {
       s=strip(strip_filename(buf_name,'P'),'B','"');
       s=strip(strip_filename(s,'E'),'B','"');
     } else if ( ch=='C' ) {
       if (comment==NULL_COMMENT) {
          result=show('-modal _vc_comment_form',buf_name,prompt_for_each_comment);
          if (result=='') {
             return(COMMAND_CANCELLED_RC);
          }
          // comment will be the filename if COMMENT_FILE style exists
          comment=_param1;
       }
       s=comment;
     } else if ( ch=='E' ) {
       s=strip(get_extension(buf_name,'.'),'B','"');
     } else if (ch=='R'){
       ch2=upcase(substr(command,j+2,1));
       if (ch2=='N') {
          temp=strip_filename(project_name,'P');
          temp=strip_filename(temp,'E');
          s=temp;
       }else if (ch2=='P') {
          s=strip_filename(project_name,'N');
       }else{
          s=project_name;
       }
     } else if (ch=='S'){
       if (pos('sstree|ssonedir|sslocate',styles,1,'ir')) {
          parse vcsproject with '[' s ']';
          s=strip(s);
       } else {
          s=vcsproject;
       }
     } else if (ch=='T'){  // Error file
       s=_vcerror_file();
     } else if ( ch=='V' ) {
       s=buf_name;
       if ( substr(s,2,1)==':' ) {
         s=substr(s,1,2);
       } else {
         s='';
       }
     } else if (ch=='L') {
        if (_isrcs(vcs)) {
           s='';
           // Has the user specified a directory?
           if (vcsproject!='') {
              s=vcsproject;
              if (last_char(s)!=FILESEP) s=s:+FILESEP;
              s=s:+strip_filename(strip(buf_name,'B','"'),'P');
#if __UNIX__
              s=s:+',v';
#endif
           }
        }
     } else if ( ch=='(' ) {
        k=pos(')',command,j+1);
        s='';
        if (k) {
           len=k-j+1;
           envvar_name=substr(command,j+2,len-3);
           s=get_env(envvar_name);
        }
     } else if ( ch==PARSE_CHAR ) {
       s=PARSE_CHAR;
     } else {
       len=1;
       /* insert pc filename */
       s='';
     }
     command=substr(command,1,j-1):+s:+substr(command,j+len);
     j=j+length(s);
   }
   return(command);
}

defeventtab _vc_error_form

void list1.on_create()
{
   errors_view_id=arg(1);
   linenum=arg(2);
   _str caption=arg(3);
   if (caption!='') {
      p_active_form.p_caption=caption;
   }

   if (errors_view_id=='') return;

   list_buf_flags=p_buf_flags;
   get_view_id(list_view_id);
   activate_view(errors_view_id);
   if (!p_Noflines) {
      _delete_temp_view(errors_view_id);
      activate_view(list_view_id);
      p_active_form._delete_window();
      return;
   }
   errors_buf_id=p_buf_id;
   _quit_view();
   activate_view(list_view_id);
   _delete_buffer();
   p_buf_id=errors_buf_id;
   p_buf_flags=list_buf_flags;
   read_only_mode();
   top();
   if (linenum!='') {
      p_line=linenum;
   }
}

void _vc_error_form.on_resize()
{
   if (!_find_formobj('_vc_error_form','N')) {
      //9:01am 6/22/1998
      //This is a workaround for a bug if a form is deleted in on_create.
      //Clark has fixed this, I just don't have the fix yet.
      return;
   }
   list1.p_width=_dx2lx(SM_TWIP,p_active_form.p_client_width)-(list1.p_x*2);
   _yes.p_y=_dx2lx(SM_TWIP,p_active_form.p_client_height)-_yes.p_height-100;
   list1.p_height=_yes.p_y-100-list1.p_y;
}

static dosrc_shell(command,styles,_str ShellOptions='')
{
   temp=command;
   pgmname=parse_file(temp);
   temp_view_id='';
   read_return_code=0;
   if (pos('dosrc',styles,1,'i') && _win32s()==0 && machine()=='NT386') {
      if (machine()=='NT386') {
         command='dosrc 'command;
      } else {
         read_return_code=1;
         command='dosrc -f '_vcerror_file2()' 'command;
      }
   }
   alternate_shell='';
#if __UNIX__
   alternate_shell='/bin/sh';
   if (file_match('-p 'alternate_shell,1)=='') {
      alternate_shell=path_search('sh');
      if (alternate_shell=='') {
         _message_box(nls("Could not find sh shell"));
      }
   }
#endif
   if (_vcdebug) {
      _message_box('cwd='getcwd()' command='command);
   }
   found_internal_command=false;
   if (pos('internal_cmd_lookup',styles)) {
      parse command with pgmname .;
      index=find_index(pgmname,COMMAND_TYPE);
      if (index) {
         found_internal_command=true;
         status=execute(command,'');
      } else {
         status=shell(command,'p'ShellOptions,alternate_shell);
      }
   } else {
      status=shell(command,'p'ShellOptions,alternate_shell);
   }
   //_message_box('pgmname='pgmname' status='status);
   // We get UNKNOWN_COMMAND_RC and not FILE_NOT_FOUND_RC
   // when a program is not found.
   if (!found_internal_command && 
       (status==FILE_NOT_FOUND_RC || 
        status==UNKNOWN_COMMAND_RC ||
        status==PATH_NOT_FOUND_RC) && 
       path_search(pgmname,'PATH','P')=="" ) {
      // IF the program name has no path specified.
      if (strip_filename(pgmname,'N')=="") {
         _message_box(nls('Program %s not found.  Make sure this program can be found on your PATH',pgmname));
      } else {
         _message_box(nls('Program %s not found.',pgmname));
      }
   } else {
      /* Dan added for new sswcl support */
      if (pos('sserror_file_rc',styles)) {
         tstatus=_open_temp_view(_vcerror_file(), temp_view_id, orig_view_id);
         if (tstatus) {
            if (ShellOptions=='') {
               /* Error file not found, or something */
               _message_box(nls("Could not open error file."));
               status=1;
            }
            /* Force error, since we don't know what happened */
         }else{
            p_view_id=temp_view_id;
            top();
            tstatus=search('^exit code\:','@ri');
            /* Look for error code part */
            if (tstatus) {
               // User may have an incorrect version of the sswcl.exe program.
               _message_box(nls("Could not find error code"));
               /* If the error code is not found, they may have an incorrect version of sswcl */
               /* So, we warn them of this possibility */
               status=1;
               /* Force error, since we don't know what happened */
            }else{
               get_line(line);
               parse line with ':' trc;
               status=strip(trc);
               /* get error code and set status to it */
            }
            _delete_temp_view(temp_view_id);
            p_view_id=orig_view_id;
         }
      }


      if (read_return_code) {
         get_view_id(orig_view_id);
         activate_view(HIDDEN_VIEW_ID)
         _safe_hidden_window();
         status=load_files('+q +d +l '_vcerror_file2());
         if (status) {
            if (status==NEW_FILE_RC) {
               _delete_buffer();
            }
         } else {
            get_line(status);
            if (!isinteger(status)) {
               status=0;
            }
            _delete_buffer();
         }
         delete_file(_vcerror_file2());
         activate_view(orig_view_id);
      }
   }

   if (_vcdebug) {
      if (!_win32s()) {
         // Strange bug in Windows NT.  Must flush keyboard before waiting for key
         _mdi.refresh();
         flush_keyboard();
      }
      _message_box('shell status='status);
   }
   return(status);
}
static _vcshell(_str vcs,_str command,_str styles,
                _str buf_name,_str &lastss_cd,_str vcsproject,
                _str ssnew_archives='',int ForceError=0,
                _str ShellOptions='')
{
   status=_vcshell2(vcs,command,styles,buf_name,lastss_cd,vcsproject,ssnew_archives,ShellOptions)
   if (!status && !ForceError && pos('delta_error',styles,1,'i')) {
      if (pos('error_file|error_redir|error_stdout',styles,1,'ir')) {
         orig_view_id=_create_temp_view(temp_view_id);
         if (orig_view_id!='') {
            status=get(_vcerror_file(),'','A');
            noerror=search('^(Error|Warning)\:','ri@');
            //messageNwait('msg noerror='get_message(noerror));
            status=(noerror)?0:1;
            activate_view(orig_view_id);
            _delete_temp_view(temp_view_id);
         }
      }
   }
   return(status);
}
static _vcshell2(vcs,command,styles,buf_name,var lastss_cd,vcsproject,_str ssnew_archives='',
                 _str ShellOptions='')
{
   if (pos('error_redir',styles,1,'i')) {
      parse command with program arg_list;
      command=program' >'_vcerror_file()' 2>&1 'arg_list;
   } else if (pos('error_stdout',styles,1,'i')) {
      parse command with program arg_list;
      command=program' >'_vcerror_file()' 'arg_list;
   }
   if (ssnew_archives!='') {
      old_cwd=getcwd();
      path=strip_filename(buf_name,'N');
      if (lastss_cd!=path) {
         //messageNwait('vcsproject='vcsproject)
         vcs=def_vc_system;

         //_ini_get_value(_vcssystem_file(),vcs, 'vcsproject',tvcsproject,'')
         _vc_get_value(vcs, 'vcsproject',tvcsproject,'')
         parse tvcsproject with . ',' info;

         buf_name=strip(buf_name,'B','"');
         ssdir=_ssxlat_dir(buf_name,vcsproject,styles);
         i=lastpos('/',ssdir);
         if (i) {
            ssdir=substr(ssdir,1,i);
         }
         vcsproject='['maybe_quote_filename(ssdir)']';
         comment='';
         newcommand=_vcparse_command(vcs, info, buf_name, _project_name, vcsproject, comment,'',styles);

         status=dosrc_shell(newcommand,styles,ShellOptions);
         if (status) {
            //Was using wrong quote type to use \n 10:25am 4/29/1996
            _message_box(nls("Failed to set Source Current Directory by executing the command:\n\n%s",newcommand));
            return(status);
         }
         lastss_cd=path;
      }
      status=chdir(strip(path,'B','"'),1);
      status=dosrc_shell(command,styles,ShellOptions);
      chdir(old_cwd,1);

   } else if (pos('sstree|ssonedir|sslocate',styles,1,'ir')) {
      old_cwd=getcwd();
      path=strip_filename(buf_name,'N');
      // When performat ss locate, buf_name is ''
      if (path=='') {
         status=dosrc_shell(command,styles,ShellOptions);
      } else {
         status=chdir(strip(path,'B','"'),1);
         status=dosrc_shell(command,styles,ShellOptions);
         chdir(old_cwd,1);
      }
   } else {
      status=dosrc_shell(command,styles,ShellOptions);
   }
   // Check for warning from RCS and make sure the message gets displayed.
   if (_isrcs(vcs) && pos('error_redir',styles,1,'i') && status==0 && file_list_field(_vcerror_file(),DIR_SIZE_COL,DIR_SIZE_WIDTH)>0) {
      status=1;
   }
   return(status);
}

static int sslocate_project(command,buf_name,styles,var vcsproject,ssnew_archives)
{
   if (!pos('sslocate',styles,1,'i')) return(0);
   if (ssnew_archives!='') {
      //messageNwait('vcsproject='vcsproject)
      result = show('-modal _textbox_form',
                    'Checkin New file 'buf_name, // Form caption
                    0,  //flags
                    '', //use default textbox width
                    '', //Help item.
                    '', //Font (not yet supported)
                    'sslocate', //Retrieve Name
                    'Source Safe Project:'
                    );

      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      vcsproject='['_param1 ']';
      //messageNwait('vcsproject='vcsproject);
      return(0);
   }
   // Locate which Source Safe project this file is in
   parse command with ssexe .;
   locatecmd=ssexe' locate 'strip_filename(buf_name,'P');
   locatecmd=locatecmd" -o@"_vcerror_file()" -exitcode";
   status=_vcshell2('',locatecmd,styles,'',junk,vcsproject);
   if (status) {
      _message_box(nls("Failed to locate Source Safe project for %s.  Shell error",buf_name));
      return(status);
   }
   orig_view_id=_create_temp_view(temp_view_id);
   if (orig_view_id!='') {
      status=get(_vcerror_file(),'','A');
      top();
      status=1;
      for (;;) {
         if(_on_line0()) break;
         get_line(line);
         _delete_line();
         if (pos("Searching",line)) {
            status=0;
            break;
         }
      }
      if (status) {
         _delete_temp_view(temp_view_id);
         _message_box(nls("Failed to locate Source Safe project for %s.  Keyword 'Searching' not found.",buf_name));
         return(NOT_ENOUGH_MEMORY_RC);
      }
      parse lowcase(vcsproject) with '[' base_project ']';
      found_file_in_base= 0;
      top();up();
      for (;;) {
         if(down()) break;
         get_line(line);
         i=lastpos('/',line);
         if (pos('(Removed)',line)) {
            if(_delete_line()) break;
            up();
            continue;
         }
         if (i) {
            line=substr(line,1,i-1);
         }
         if (line=='$') line='$/';
         if (line=='') {
            _delete_line();
            break;
         }
         if (base_project==lowcase(substr(line,1,length(base_project)))) {
            found_file_in_base=1;
         }
         _lbset_item(line);
      }
      top();get_line(line);
      if (_on_line0() || line=="No matches found.") {
         _delete_temp_view(temp_view_id);
         _message_box(nls("Failed to locate Source Safe project for %s.  Use the New Archive File(s) option to check in a new file.",buf_name));
         return(NOT_ENOUGH_MEMORY_RC);
      }
      if (base_project!='') {
         if (found_file_in_base) {
            top();up();
            for (;;) {
               if(down()) break;
               line=_lbget_text();
               if (base_project!=lowcase(substr(line,1,length(base_project)))) {
                  if(_lbdelete_item()) break;
                  up();
               }
            }
         }
      }
      result=_lbget_text();
      if (p_Noflines>1) {
         activate_view(orig_view_id);
         result=show('-modal _sellist_form',
              nls('Select Project for %s',buf_name),
              SL_VIEWID|SL_SELECTPREFIXMATCH|SL_COMBO|SL_MUSTEXIST, // flags
              temp_view_id,     // input_data
              "",       // buttons
              nls('?Choose the Source Safe project for which the file %s belongs',buf_name),    // help item
              '',   // font

              '',   // Call back function
              '',   // Item separator for list_data
              '',   // Retrieve form name
              '',   // Combo box. Completion property value.
              7000,   // minimum list width
              result    // Combo Box initial value
             );
      }
      activate_view(orig_view_id);
      result=strip(result);
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      vcsproject='['result']';
   }
   return(0);
}


static _str MaybeStripLeadingVCSName(_str VCSName,_str &VCS='')
{
   _str vcs=def_vc_system;
   if (!_isscc(VCSName) && _isscc(vcs) && machine()=="NT386") {
      vcs=substr(vcs,SCC_PREFIX_LENGTH+1);
   }
   if (substr(VCSName,1,length(vcs':'))==vcs:+':') {
      VCS=substr(VCSName,1,length(vcs));
      return(substr(VCSName,length(vcs':')+1));
   }
   return(VCSName);
}

/*
   CommandName is the name of the command to be executed as it appears in the
   vc file(vcsystem.slk or uservc.slk).
   
   If ForceOutput is non-zero we make sure that we get output even if there is
   no error condition.
*/
static int _misc_cl_vc_command(_str CommandName,
                               int ErrorsViewId,
                               _str Filename,
                               _str vcs,
                               int ForceOutput,
                               _str ShellOptions='')
{
   status=_vc_get_value(vcs, CommandName, info, '');
   //if (Filename=='') return(1);
   //2:43pm 7/2/1998
   //For manager we don't need a filename
   _vc_get_value(vcs, "styles", styles);
   //_vc_get_value(vcs, 'vcsproject',vcsproject,'')
   _ini_get_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',vcsproject,'');
   vcsproject=MaybeStripLeadingVCSName(vcsproject);
   command=_vcparse_command(vcs, info, Filename, 
                            _project_name, vcsproject, comment,
                            0,//prompt for each comment
                            styles);
   if (command=='') {
      return(1);
   }
   if (command==COMMAND_CANCELLED_RC) {
      return(COMMAND_CANCELLED_RC);
   }
   if (file_match(_vcerror_file()' -p',1)!='') {
      delete_file(_vcerror_file());
   }
   status=_vcshell(vcs,command,styles,Filename,lastss_cd,vcsproject,'',ForceOutput,ShellOptions);
   if (status || pos('show_error',styles,1,'i') || ForceOutput) {
      _vcappend_errors(linenum,ErrorsViewId,styles);
      //handle_error(vcs, status, Filename, 1/* checking in */, new_archives);
   }
   if (status==FILE_NOT_FOUND_RC) {
      parse command with Filename rest;
      clear_message();
      _message_box(nls("Program '%s' not found",Filename));
      return(status);
   }
   return(status);
}


/*
   filespec is a filespec to check in, or a view_id of a list of filespecs to check
      in.

   vcs is the name of the current version control system

   new_archives is one if the user wants new archive files to be made for all files
      to be checked in.

   discard_changes is 1 if the user wants a "Unlock and Discard" action for each of
      the files to be checked in

   prompt_for_each_comment  is non-zero if the user wants to specify a comment for each file.

   comment is a comment (just for better command line support)
*/
static _checkin(var linenum,errors_view_id,filespec, vcs, new_archives, discard_changes,prompt_for_each_comment, comment)
{
   if (machine()=='NT386' && _isscc(vcs)) {
      vcs=substr(vcs,5);
      if (vsSccGetCurProjectInfo(VSSCC_PROVIDER_NAME)!=vcs) {
         status=vsSccInit(vcs);
         if (status) {
            _message_box(nls("Could not initialize support for '%s'",vcs));
            return(status);
         }
      }
      if (vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME)=='') {
         _message_box(nls("You must first open a project(Project...Version Control...Setup)"));
         return(1);
      }
      _str Files[];
      Files._makeempty();
      ExpandFilespecForSCC(filespec,Files);
      if (!Files._length()) {
         return(1);
      }
      int status=0;
      if (new_archives) {
         int FileStatus[];
         status=vsSccQueryInfo(Files,FileStatus);
         if (status) {
            _message_box(nls(vcget_message(status)));
            return(status);
         }
         if ( (FileStatus[0]&(VSSCC_STATUS_CONTROLLED|VSSCC_STATUS_DELETED))==(VSSCC_STATUS_CONTROLLED|VSSCC_STATUS_DELETED) ) {
            _message_box(nls("This file is already in version control, but is deleted.  You must either undelete or purge this file first."));
            return(1);
         }else if (FileStatus[0]&VSSCC_STATUS_CONTROLLED) {
            _message_box(nls("This file is already in version control."));
            return(1);
         }
         status=vsSccAdd(Files,comment);
         //Check it in, but we gotta prompt for a comment.
         if (status) {
            //_message_box(nls("An error occured while checking in files"));
            _message_box(nls("%s",vcget_message(status)));
         }
      }else{
         _str OrigFiles:[];
         CopyArrayToHashTab(OrigFiles,Files);
         int Command;
         if (discard_changes) {
            Command=VSSCC_COMMAND_UNCHECKOUT;
         }else{
            Command=VSSCC_COMMAND_CHECKIN;
         }
         status=vsSccPopulateList(Command,Files,1);
         if (Files._length()) {
            int FileStatus[];
            status=vsSccQueryInfo(Files,FileStatus);
            if (status) {
               _message_box(nls(vcget_message(status)));
               return(status);
            }
            for (i=0;i<FileStatus._length();++i) {
               if (FileStatus[i]==VSSCC_STATUS_NOTCONTROLLED) {
                  //This returns flags,but is 0, so we have to check for exact
                  FileStatus._deleteel(i);
                  Files._deleteel(i);
                  --i;
               }
            }
         }

         _str ExistingFiles:[];
         CopyArrayToHashTab(ExistingFiles,Files);

         _str RemovedFileList='';
         _str ActionName;
         if (discard_changes) {
            ActionName='unlock';
         }else{
            ActionName='checkin';
         }
         GetRemovedFileList(OrigFiles,ExistingFiles,RemovedFileList);
         if (!Files._length()) {
            //All files were removed
            _message_box(nls("Cannot %s the following files:\n%s\n\nThese files may not be checked out, or archives may not exist for these files",ActionName,RemovedFileList));
            return(1);
            //Display message 'The following files could not be checked out'
            //No continue message, return immediatley
         }
         if (RemovedFileList!='') {
            result=_message_box(nls("Cannot %s the following files:\n%s\nContinue?",ActionName,RemovedFileList));
            if (result!=IDYES) {
               return(COMMAND_CANCELLED_RC);
            }
         }

         if (discard_changes) {
            status=vsSccUncheckout(Files);
            if (status) {
               _message_box(nls("An error occured while unlocking files"));
            }
         }else{
            status=vsSccCheckin(Files,comment);
            //Check it in, but we gotta prompt for a comment.
            if (status) {
               _message_box(nls("An error occured while checkin in files"));
            }
         }
      }
      return(status);
   }
   linenum='';
   if (new_archives) {
      //status=_ini_get_value(_vcssystem_file(), vcs, VCS_CHECKIN_NEW, info, '');
      status=_vc_get_value(vcs, VCS_CHECKIN_NEW, info, '');
   } else if (!discard_changes) {
      status=_vc_get_value(vcs, VCS_CHECKIN, info, '');
   } else {// Discard Changes
      status=_vc_get_value(vcs, VCS_CHECKIN_DISCARD, info, '');
   }
   if (status||info=='') {
      return(status);
   }

   _vc_get_value(vcs, "styles", styles);
   _vc_get_value(vcs, 'vcsproject',vcsproject,'');//Have to do this part for the project_option
   parse lowcase(vcsproject) with project_option ',';
   _ini_get_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',vcsproject,'');
   vcsproject=MaybeStripLeadingVCSName(vcsproject);
   ssnew_archives='';
   lastss_cd='';
   if (new_archives && pos('sstree|ssonedir|sslocate',styles,1,'ir')) {
      ssnew_archives=1;
      // Don't want _ssxlat_dir to be called
   }
   orig_cd='';
   if (project_option=='dir') {
      orig_cd=getcwd();
      if (vcsproject!='') {
         status=chdir(vcsproject,1);
         if (status) {
            _message_box(nls("VCS Project is invalid directory"));
            return(1);
         }
      }
   }
   if (pos("vcp_required",styles,1,'i') && vcsproject=='' && !pos("sslocate",styles,1,'i')) {
      _message_box("The VCS Project must be set.  Use Check In dialog box to set VCS Project.");
      return(1);
   }
   filespec=strip(filespec);
   if (substr(filespec,1,1)!='@') {
      for (;;) {
         filename=parse_file(filespec);
         if (filename=='') break;
         status=sslocate_project(info,filename,styles,vcsproject,ssnew_archives);
         if (status) break;
         command=_vcparse_command(vcs, info, filename, _project_name, vcsproject, comment,prompt_for_each_comment,styles);
         if (prompt_for_each_comment) {
            comment=NULL_COMMENT;
         }
         if (command==COMMAND_CANCELLED_RC) {
            status=command;
            break;
         }
         if (pos('sstree',styles,1,'i') && _ssxlat_dir(filename,vcsproject,styles)=='') {
            status=1;
            line=nls('The file %s is not in or below the current project',filename);
            _vcappend_error_message(linenum,errors_view_id,styles,line);
         } else {
            status=_vcshell(vcs,command,styles,filename,lastss_cd,vcsproject,ssnew_archives);
            if (iswildcard(filename) || status || pos('show_error',styles,1,'i')) {
               _vcappend_errors(linenum,errors_view_id,styles);
               //handle_error(vcs, status, filename, 1/* checking in */, new_archives);
            }
            if (status==FILE_NOT_FOUND_RC) {
               parse command with filename rest;
               clear_message();
               _message_box(nls("Program '%s' not found",filename));
               break;
            }
         }
      }
   }else{
      get_view_id(orig_view_id);
      activate_view(HIDDEN_VIEW_ID);
      _safe_hidden_window();
      status=load_files('+c 'substr(filespec,2));
      if (status) {
         if (!load_files('+q +b 'substr(filespec,2))) {
            _delete_buffer();
         }
         if (orig_cd!='') chdir(orig_cd,1);
         return(status);
      }
      get_view_id(temp_view_id)
      activate_view(temp_view_id);
      top();up();
      for (;;) {
         /* In this section, I shell out for each file individually.  Therefore,
            If the user has specified one commment to be used for all files, I
            just put it into each command line, depending on the VCS's syntax*/
         activate_view(temp_view_id);
         if (down()) {
            break;
         }
         filename=maybe_quote_filename(_lbget_text());
         status=sslocate_project(info,filename,styles,vcsproject,ssnew_archives)
         if (status) break;
         command=_vcparse_command(vcs, info, filename, _project_name, vcsproject, comment,prompt_for_each_comment,styles);
         if (prompt_for_each_comment) {
            comment=NULL_COMMENT;
         }
         if (command==COMMAND_CANCELLED_RC) {
            status=command;
            break;
         }
         if (pos('sstree',styles,1,'i') && _ssxlat_dir(filename,vcsproject,styles)=='') {
            status=1;
            line=nls('The file %s is not in or below the current project',filename);
            _vcappend_error_message(linenum,errors_view_id,styles,line);
         } else {
            status=_vcshell(vcs,command,styles,filename,lastss_cd,vcsproject,ssnew_archives);
            if (status || pos('show_error',styles,1,'i')) {
               _vcappend_errors(linenum,errors_view_id,styles);
               //handle_error(vcs, status, filename, 1/* checking in */, new_archives);
            }
            if (status==FILE_NOT_FOUND_RC) {
               parse command with filename rest;
               clear_message();
               _message_box(nls("Program '%s' not found",filename));
               break;
            }
         }
      }
      activate_view(orig_view_id);
      _delete_temp_view(temp_view_id);
   }
   if (orig_cd!='') chdir(orig_cd,1);
   return(status);
}

static void _vcpvcs_append_checkout(errors_view_id,styles,filelist_view_id)
{
   if (!pos('pvcs_wildcards',styles,1,'i')) return;
   if (!pos('error_file|error_redir|error_stdout',styles,1,'ir')) return;

   get_view_id(orig_view_id);
   activate_view(HIDDEN_VIEW_ID);
   _safe_hidden_window();
   status=load_files(_vcerror_file());
   if (!status) {
      top();
      status=search('^{:p}( <- ){:p}','r@');
      for (;;) {
         if (status) break;
         word=get_text(match_length('0'),match_length('S0'));
         activate_view(filelist_view_id);
         _lbadd_item(absolute(word));
         activate_view(HIDDEN_VIEW_ID);
         status=repeat_search();
      }
      _delete_buffer();
   }
   activate_view(orig_view_id);
}
static _vcappend_errors(var linenum,errors_view_id,styles)
{
   if (pos('error_file|error_redir|error_stdout',styles,1,'ir')) {
      get_view_id(orig_view_id);
      activate_view(errors_view_id);
      status=get(_vcerror_file(),'','A');
      if (!status) {
         if (linenum=='') {
            linenum=p_line+1;
         }
         bottom();
      }
      activate_view(orig_view_id);
   }
}
static _vcappend_error_message(var linenum,errors_view_id,styles,msg)
{
   if (pos('error_file|error_redir|error_stdout',styles,1,'ir')) {
      get_view_id(orig_view_id);
      activate_view(errors_view_id);
      insert_line(msg);
      if (linenum=='') {
         linenum=p_line+1;
      }
      bottom();
      activate_view(orig_view_id);
   }
}

static void ExpandFilespecForSCC(_str filespec,_str (&Files)[])
{
   if (!iswildcard(filespec)) {
      for (i=0;;++i) {
         cur=strip(parse_file(filespec),'B','"');
         if (cur=='') break;
         Files[i]=cur;
      }
      return;
   }
   ff=1;
   for (;;) {
      filename=file_match(maybe_quote_filename(filespec)' -p',ff);ff=0;
      if (filename=='') break;
      Files[Files._length()]=strip(filename);
   }
}

static void CopyArrayToHashTab(_str (&FilesTab):[],_str FilesArray[])
{
   int len=FilesArray._length();
   for (i=0;i<len;++i) {
      FilesTab:[FilesArray[i]]=FilesArray[i];
   }
}

static void GetRemovedFileList(_str OrigFiles:[],
                               _str ExistingFiles:[],
                               _str &RemovedFileList)
{
   for (i._makeempty();;) {
      OrigFiles._nextel(i);
      if (i._varformat()==VF_EMPTY) break;
      if (!ExistingFiles._indexin(i)) {
         if (RemovedFileList=='') {
            RemovedFileList=i;
         }else{
            RemovedFileList=RemovedFileList"\n"i;
         }
      }
   }
}

/*
   vcs is the name of the current version control system

   read_only is 1 if the user wishes to check out all files specified in "browse"
      mode.
*/
static _checkout(var linenum,errors_view_id,filespec, vcs, edit_files, read_only)
{
   if (machine()=='NT386' && _isscc(vcs)) {
      vcs=substr(vcs,5);
      if (vsSccGetCurProjectInfo(VSSCC_PROVIDER_NAME)!=vcs) {
         status=vsSccInit(vcs);
         if (status) {
            _message_box(nls("Could not initialize support for '%s'",vcs));
            return(status);
         }
      }
      _str Files[];
      Files._makeempty();
      filespec=strip(filespec);
      ExpandFilespecForSCC(filespec,Files);
      if (!Files._length()) {
         return(1);
      }

      _str OrigFiles:[];
      CopyArrayToHashTab(OrigFiles,Files);
      //status=vsSccPopulateList(VSSCC_COMMAND_CHECKOUT,Files,1);

      int FileStatus[];
      status=vsSccQueryInfo(Files,FileStatus);
      if (status) {
         _message_box(nls(vcget_message(status)));
         return(status);
      }
      for (i=0;i<Files._length();++i) {
         if (!FileStatus[i] || FileStatus[i]==VSSCC_STATUS_INVALID) {
            FileStatus._deleteel(i);
            Files._deleteel(i);
            --i;
         }
      }

      _str ExistingFiles:[];
      CopyArrayToHashTab(ExistingFiles,Files);

      _str RemovedFileList='';
      _str ActionName;
      if (read_only) {
         ActionName='get';
      }else{
         ActionName='checkout';
      }
      GetRemovedFileList(OrigFiles,ExistingFiles,RemovedFileList);
      if (!Files._length()) {
         //All files were removed
         _message_box(nls("Cannot %s the following files:\n%s\n\nThese files may be checked out, or archives may not exist for these files",ActionName,RemovedFileList));
         return(1);
         //Display message 'The following files could not be checked out'
         //No continue message, return immediatley
      }
      if (RemovedFileList!='') {
         result=_message_box(nls("Cannot %s the following files:\n%s\nContinue?",ActionName,RemovedFileList),'',MB_YESNOCANCEL);
         if (result!=IDYES) {
            return(COMMAND_CANCELLED_RC);
         }
      }
      if (read_only) {
         status=vsSccGet(Files);
         if (status) {
            _message_box(nls("Could not get files status=%s",status));
         }
      }else{
         status=vsSccCheckout(Files,'');
         if (status) {
            _message_box(nls("Could not checkout files\n%s",vcget_message(status)));
         }
      }
      if (!status) {
         //Need to call edit_and_close_files
         int orig_view_id=_create_temp_view(temp_view_id);
         for (i=0;i<Files._length();++i) {
            insert_line(' 'Files[i]);
         }
         p_view_id=orig_view_id;
         edit_and_close_files(temp_view_id);
      }
      return(status);
   }
   linenum='';
   if (!read_only) {
      //status=_ini_get_value(_vcssystem_file(), vcs, VCS_CHECKOUT, info, '');
      status=_vc_get_value(vcs, VCS_CHECKOUT, info, '');
   }else{
      //status=_ini_get_value(_vcssystem_file(), vcs, VCS_CHECKOUT_READ_ONLY, info, '');
      status=_vc_get_value(vcs, VCS_CHECKOUT_READ_ONLY, info, '');
   }
   if (status||info=='') {
      return(status);
   }
   //_ini_get_value(_vcssystem_file(),vcs, "styles", styles);
   _vc_get_value(vcs, "styles", styles);

   //_ini_get_value(_vcssystem_file(),vcs, 'vcsproject',vcsproject,'')
   _vc_get_value(vcs, 'vcsproject',vcsproject,'');
   parse lowcase(vcsproject) with project_option ',';
   _ini_get_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',vcsproject,'');
   vcsproject=MaybeStripLeadingVCSName(vcsproject);
   orig_cd='';
   if (project_option=='dir') {
      orig_cd=getcwd();
      if (vcsproject!='') {
         status=chdir(vcsproject,1);
         if (status) {
            _message_box(nls("VCS Project is invalid directory"));
            return(1);
         }
      }
   }
   if (pos("vcp_required",styles,1,'i') && vcsproject=='' && !pos("sslocate",styles,1,'i')) {
      _message_box("The VCS Project must be set.  Use Check Out dialog box to set VCS Project.");
      return(1);
   }
   filespec=strip(filespec);
   orig_view_id = _create_temp_view(filelist_view_id);
   if (orig_view_id=='') return(1);
   if (substr(filespec,1,1)!='@') {
      for (;;) {
         filename=parse_file(filespec);
         if (filename=='') break;
         status=sslocate_project(info,filename,styles,vcsproject,'')
         if (status) break;
         comment=_chr(0);
         command=_vcparse_command(vcs, info, filename, _project_name, vcsproject, comment,'',styles);
         if (pos('sstree',styles,1,'i') && _ssxlat_dir(filename,vcsproject,styles)=='') {
            status=1;
            line=nls('The file %s is not in or below the current project',filename);
            _vcappend_error_message(linenum,errors_view_id,styles,line);
         } else {
            status=_vcshell(vcs,command,styles,filename,junk,vcsproject);
            if (iswildcard(filename) || status || pos('show_error',styles,1,'i')) {
               _vcappend_errors(linenum,errors_view_id,styles);
               //handle_error(vcs, status, filename, 0/* checking in */, 0 /* create_new_archives */);
            }
            if (status!=FILE_NOT_FOUND_RC) {
               _vcpvcs_append_checkout(errors_view_id,styles,filelist_view_id);
            }
            if (!pos('pvcs_wildcards',styles,1,'i') &&
                (iswildcard(filename) || !status)) {
               activate_view(filelist_view_id);
               _lbadd_item(absolute(filename));
            }
            if (status==FILE_NOT_FOUND_RC) {
               parse command with filename rest;
               clear_message();
               _message_box(nls("Program '%s' not found",filename));
               break;
            }
         }
      }
   }else{
      activate_view HIDDEN_VIEW_ID;
      _safe_hidden_window();
      status=load_files('+c 'substr(filespec,2));
      if (status) {
         if (!load_files('+q +b 'substr(filespec,2))) {
            _delete_buffer();
         }
         if (orig_cd!='') chdir(orig_cd,1);
         _delete_temp_view(filelist_view_id);
         return(status);
      }
      get_view_id temp_view_id;
      top();up();
      for (;;) {
         if (down()) break;
         filename=maybe_quote_filename(absolute(_lbget_text()));
         //if (!read_only) add_to_list(filename);
         status=sslocate_project(info,filename,styles,vcsproject,'');
         if (status) break;
         comment='';
         command=_vcparse_command(vcs, info, filename, _project_name, vcsproject, comment,'',styles);
         if (pos('sstree',styles,1,'i') && _ssxlat_dir(filename,vcsproject,styles)=='') {
            status=1;
            line=nls('The file %s is not in or below the current project',filename);
            _vcappend_error_message(linenum,errors_view_id,styles,line);
         } else {
            status=_vcshell(vcs,command,styles,filename,junk,vcsproject);
            if (status || pos('',styles,1,'i')) {
               _vcappend_errors(linenum,errors_view_id,styles)
               //handle_error(vcs, status, filename, 0/* checking out */,0/* create_new_archives */);
            }
            if (status!=FILE_NOT_FOUND_RC) {
               _vcpvcs_append_checkout(errors_view_id,styles,filelist_view_id);
            }
            if (status==FILE_NOT_FOUND_RC) {
               parse command with filename rest;
               clear_message();
               _message_box(nls("Program '%s' not found",filename));
               break;
            }
         }
         if (!status && !pos('pvcs_wildcards',styles,1,'i')) {
            activate_view(filelist_view_id);
            _lbadd_item(absolute(filename));
            activate_view(temp_view_id);
         }
      }
      _delete_temp_view(temp_view_id);
   }
   if (orig_cd!='') chdir(orig_cd,1);
   activate_view(orig_view_id);
   if (edit_files && status!=FILE_NOT_FOUND_RC) {
      edit_and_close_files(filelist_view_id);
      _delete_temp_view(filelist_view_id);
   }else{
      _delete_temp_view(filelist_view_id);
   }
   return(status);
}

static edit_and_close_files(filelist_view_id)
{
   orig_view_id=p_view_id;
   p_view_id=filelist_view_id;
   top();up();
   for (;;) {
      if (down()) {
         break;
      }
      filename=_lbget_text();
      p_view_id=orig_view_id;
      filename=strip(filename);
      qfilename=maybe_quote_filename(filename);
      if (file_match('-p 'qfilename,1)!='') {
         file_already_loaded=buf_match(filename,1,'E')!='';
         if (file_already_loaded) {
            parse buf_match(filename,1,'VE') with buf_id .;
            old_reload_info=def_actapp;
            def_actapp=0;
            //result=_message_box(nls("Do you wish to replace '%s' with the new '%s'?",filename,filename),'',MB_YESNOCANCEL|MB_ICONQUESTION);
            //Don't really need this message.  For the new stuff, the buffer is 
            //usually already.
            result=IDYES;
            def_actapp=old_reload_info;
            if (result==IDYES) {
               temp_view_id=_list_bwindow_pos(buf_id);
               p_view_id=HIDDEN_VIEW_ID;
               _safe_hidden_window();
               status=load_files(def_load_options' +q +l +b 'filename);
               if (!status) {
                  status=load_files(def_load_options' +q +l +r +d 'qfilename);
               }
               if (!p_readonly_set_by_user) {
                  //will set buffer to what it is on disk, should be r/w
                  maybe_set_readonly();
               }
               _set_bwindow_pos(temp_view_id)
               _delete_temp_view(temp_view_id);

               p_view_id=orig_view_id;
            }
         }else{
            if (_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW) {
               edit(qfilename);
            }
         }
      }
      p_view_id=filelist_view_id;
   }
}

static handle_error(vcs, error_code, filename, checking_in, create_new_archives)
{
   filename=strip(filename,'B','"');
   switch (lowcase(vcs)) {
   case 'tlib for dos':
   case 'tlib for os/2':
      if (checking_in) {
         switch (error_code) {
         case 1:
            if (!create_new_archives) {
               _message_box(nls("%s could not be checked in.\n\nYou may need to create an archive file for it first.",filename));
            }else{
               _message_box(nls("%s could not be created.\n\nAn archive file may already exist for this file."),filename);
            }
            break;
         }
      }else{
         switch (error_code) {
         case 1:
            _message_box(nls("%s could not be checked out.\n\nYou may wish to be sure that an archive exists for %s.",filename, filename));
            break;
         }
      }
      break;
   case 'source safe for dos':
   case 'source safe for os/2':
      if (checking_in) {
         switch (error_code) {
         case 1:
         case 100:
            if (!create_new_archives) {
               _message_box(nls("%s could not be checked in.\n\nYou may need to create an archive file for it first.",filename));
            }else{
               /* Actually Source safe returns 0 if you try to create a checked
                  in module, but I put this in for completeness in case they change
                  it. */
               _message_box(nls("%s could not be created.\n\nAn archive file may already exist for this file.",filename));
            }
            break;
         }
      }else{
         switch (error_code) {
         case 1:
         case 100:
            _message_box(nls("%s could not be checked out.\n\nYou may wish to be sure that an archive exists for %s.",filename, filename));
            break;
         }
      }
      break;
   }
}

static build_view_of_selected(var temp_view_id)
{
   if (p_Nofselected<1) {
      return(1);
   }
   orig_view_id=_create_temp_view(temp_view_id);
   activate_view(orig_view_id);
   ff=1;
   for (;;) {
      status=_lbfind_selected(ff);
      if (status) {
         break;
      }
      text=_lbget_text();
      activate_view(temp_view_id);
      insert_line(text);
      activate_view orig_view_id;
      ff=0;
   }
}

defeventtab _vc_auto_inout_form

_yes.on_create()
{
   msg=arg(1);
   read_only_caption=arg(2);
   oldheight=_message.p_height;
   _message.p_caption=msg;
   diff=_message.p_height-oldheight;
   _read_only.p_y+=diff;
   _yes.p_y+=diff;
   _no.p_y+=diff;
   _no.p_next.p_y+=diff;
   _read_only.p_caption=read_only_caption;
   p_active_form.p_height+=diff;
   // _read_only.p_caption="Discard Changes";
   // msg=nls("Do you wish to save and check in the file %s?",str, arg(1));
}

_yes.lbutton_up()
{
   _param1=_read_only.p_value;
   _param2=1;   // Save the file
   p_active_form._delete_window(IDYES);
}

_no.lbutton_up()
{
   p_active_form._delete_window(IDNO);
}

defload()
{
#if 0
   menu_handle=_mdi.p_menu_handle;
   if (menu_handle) {
      // Add checkout and checkin menu items if they are not already
      // there.
      // Look for checkout command
      mi=find_index(_cur_mdi_menu,oi2type(OI_MENU));
      if (mi) {
         if(!_menu_find(menu_handle,'checkin',junk,junk,'m')) return;
         // Scan for "&Project" menu
         for(project_mi=mi.p_child;;){
            if (project_mi.p_caption=="&Project") break;
            project_mi=project_mi.p_next;
            if (project_mi==mi.p_child) {
               project_mi=0;
               break;
            }
         }
         if (project_mi) {
            // Look for compile_mi or execute_mi
            for (menu_pos=0,mi=project_mi.p_child,i=0;;++i) {
               if (mi.p_command=="project-compile") {
                  menu_pos=i;
               }
               if (mi.p_command=="project-execute") {
                  menu_pos=i+1;
                  break;
               }
               mi=mi.p_next;
               if (mi==project_mi.p_child) {
                  break;
               }
            }
#if 0
            _menu_insert(project_mi,menu_pos,MF_ENABLED,
                         "Chec&k Out...","checkout","ncw",
                         "popup-imessage Checks out files you specify from version control system.",
                         "Checks out files from version control system");
            _menu_insert(project_mi,menu_pos,MF_ENABLED,
                         "Check &In...","checkin","ncw",
                         "popup-imessage Checks in files you specify into version control system.",
                         "Checks in files into version control system");
#endif
            _menu_mdi_update();
         }
      }
   }
   rc=0;
#endif
}

#define CHECKOUT      1
#define GET           2
#define SET_WRITEABLE 3

/*
    Dont' use edit or window_edit to create a hidden buffer or
    it might get added to the project tab buffer list.
*/
_str window_edit(filename)
{
   a2_flags=arg(2);
   do_auto_check=(def_vcflags&VCF_AUTO_CHECKOUT) && (isinteger(a2_flags) && (a2_flags & 1));
  /* tiled edit is the default of load_files so nothing need be done. */
   if (do_auto_check) {
      //file_already_loaded=buf_match(absolute(just_name(filename)),1,'E')!='';
      block_was_read(0);
      jname=just_name(filename);
      if (jname=='') {
         attrs='x';
      } else {
         attrs=file_list_field(jname,DIR_ATTR_COL,DIR_ATTR_WIDTH);
      }
#if __UNIX__
      // Could limit check to user write access.
      // A better check would check write access by attempting to open the file read/write
      // and in case we are root, check for no write access.
      isreadonly=!pos('w',attrs);
#else
      isreadonly=pos('R',attrs);
#endif
      LoadingBuffer=pos('\+b( |i)',filename,1,'ir');
      //Don't want to get the +bp option by accident!!!!
      if((_ispvcs_library(filename) || attrs==''/* || isreadonly*/) &&
         !LoadingBuffer) {
         int status=0;
         _str b1='',b2='',b3='';//Captions for radio buttons
         if (_ispvcs_library(filename)) {
            msg=nls("'%s' is a PVCS archive file.",jname);
         } else if(attrs=='') {
            msg=nls("'%s' does not exist.",jname);
            b3='&Create the file';
         } else {
            msg=nls("'%s' is read only.",jname);
         }
         result=show('-modal _vc_checkout_form',msg,b1,b2,b3);
         if (result=='') {
            return(COMMAND_CANCELLED_RC);
         }else if (result==CHECKOUT) {
            vccheckout(jname);
         }else if (result==GET) {
            vcget(jname);
         }else if (result==SET_WRITEABLE) {
            if (b3=='&Create the file') {
               status=edit_file(filename);
               if (! status) p_buf_flags=p_buf_flags&~(HIDE_BUFFER|DELETE_BUFFER_ON_CLOSE);
            }else{
               chmod('-r 'jname);
            }
         }
         return(status);
      }
   }
   status=edit_file(filename);
   if (! status) p_buf_flags=p_buf_flags&~(HIDE_BUFFER|DELETE_BUFFER_ON_CLOSE);
   return(status)
}
boolean _ispvcs_library(filename)
{
   filename=strip(filename,'B','"');
   ext=get_extension(filename);
   if (file_eq(substr(ext,3,1),'v')) {
      // Check for PVCS file
      vcs=def_vc_system;
      //_ini_get_value(_vcssystem_file(),vcs, "styles", styles);
      _vc_get_value(vcs, "styles", styles);
      if (pos('pvcs_wildcards',styles,1,'i')) {
         return(1);
      }
   }
   return(0);
}

static just_name(filename)
{
   for (;;) {
      name=parse_file(filename);

      if (filename=='') {
         return('');
      }
      first_ch=substr(filename,1,1);
      //This is Shawn's fix for a version control problem if you have
      //def_winpos_override set.
      if (first_ch!='-' && first_ch!='+') return(filename);
      if (lowcase(substr(filename,2,2)=='i:')) {
         for (i=0;i<6;++i) parse_file(filename);
      }
   }
}
_vcs_project_get_section(...)
{
   if (_project_name=='') {
      return("VCS");
   }
   return(arg(1));
}
static int _isrcs(SectionName)
{
   return (pos(' RCS ',' 'SectionName' '));
}
#if 0
static filename2pvcs(filename)
{
   wheres_dot = lastpos('.', filename);
   if (!wheres_dot) {
      return(filename'.__v')
   }
   ext = substr(filename, wheres_dot+1);
   len = length(ext);
   if (len == 1) {
      return(filename'_v');
   }
   if (len == 2) {
      return(filename'v');
   }
   before = substr(filename, 1, wheres_dot);
   return(before'v'substr(filename, wheres_dot +4));
}
#endif


defeventtab _vc_select_form

#define LIST_BOX_DEFAULT_COLOR  0x80000008
#define LIST_BOX_DISABLED_COLOR 0x00808080

static void SetAllEnabledProps(boolean val)
{
   wid=p_window_id;
   while (p_child) {
      p_window_id=p_child;
      firstwid=p_window_id;
      for (;;) {
         p_window_id=p_next;
         if (!pos('enabled',p_name)) {
            p_enabled=val;
            if (p_object==OI_LIST_BOX) {
               if (val) {
                  p_forecolor=LIST_BOX_DEFAULT_COLOR;
               }else{
                  p_forecolor=LIST_BOX_DISABLED_COLOR;
               }
            }
         }
         if (p_window_id==firstwid) break;
      }
   }
   p_window_id=wid;
}

void ctlcl_enabled.lbutton_up()
{
   ctlscc_enabled.p_value=(int)!p_value;
   frame1.SetAllEnabledProps(p_value!=0);
   frame2.SetAllEnabledProps(!p_value);
   if (!ctlcl_systems.p_Nofselected) {
      ctlcl_systems._lbselect_line();
   }
   if (machine()=='NT386') {
      ctlscc_systems.call_event(CHANGE_SELECTED,ctlscc_systems,ON_CHANGE,'W') ;
   }
}

void ctlscc_enabled.lbutton_up()
{
   ctlcl_enabled.p_value=(int)!p_value;
   frame1.SetAllEnabledProps(!p_value);
   frame2.SetAllEnabledProps(p_value!=0);
   if (!ctlscc_systems.p_Nofselected) {
      ctlscc_systems._lbselect_line();
   }
   if (machine()=='NT386') {
      ctlscc_systems.call_event(CHANGE_SELECTED,ctlscc_systems,ON_CHANGE,'W') ;
   }
}

static _str MaybeNone(_str Caption)
{
   return( (Caption==''?'NONE':Caption) );
}

static void InsertCLSystemList()
{
   _ini_list_sections(_vcssystem_file());
   _ini_list_sections(_vcsuser_file());
   ctlcl_systems._lbsort();
   ctlcl_systems._remove_duplicates();
   ctlcl_systems.top();
}

static int GetNumLinesInLabel(_str string)
{
   int count=1;
   int p=0;
   for (;;) {
      p=pos("\n",string,p+1);
      if (!p) return(count);
      ++count;
   }
}

#define SIMULATE_NON_NT 0

#if 0
static void SetLabel()
{
   if (substr(machine(),1,2)=='NT' && ctlscc_enabled.p_enabled && !SIMULATE_NON_NT) {
      ctlinfo_label.p_caption="If SCC support is available for your version control system, we recommend you try it.  This should provide the best integration between Visual SlickEdit and your version control system.\n\n";
      ctlinfo_label.p_caption=ctlinfo_label.p_caption:+"If you are using a command line version control system, be sure that version control system executable(s) are in your path.\n\nFor command line vcs users who need to specify a configuration file, we recommend you use an environment variable that is set in the project's Open Command.  For example:\n\nin the project's Open Command(on the project dialog) is:\n\nset VCSCONFIG=-CC:\\proj\\proj.prj\n\nIn the command string you would put:\n\n%(VCSCONFIG)";
   }else{
      ctlinfo_label.p_caption="Be sure that your version control system executable(s) are in your path.\n\nFor command line vcs users who need to specify a configuration file, we recommend you use an environment variable that is set in the project's Open Command.  For example:\n\nin the project's Open Command(on the project dialog) is:\n\nset VCSCONFIG=-C C:\\proj\\proj.cfg\n\nIn the command string you would put:\n\n%(VCSCONFIG)";
   }
   int NumLines=GetNumLinesInLabel(ctlinfo_label.p_caption);
   int LabelHeight=ctlinfo_label._text_height()*NumLines;
   int Diff=frame1.p_y-(ctlinfo_label.p_y+ctlinfo_label.p_height);
   //Size the form.  We don't have to check if Diff is positive or negative
   Diff-=200;
   frame1.p_y-=Diff;
   frame2.p_y-=Diff;
   _auto_checkout.p_y-=Diff;
   _set_read_only.p_y-=Diff;
   ctlok.p_y-=Diff;
   ctlcancel.p_y-=Diff;
   ctlhelp.p_y-=Diff;
   p_active_form.p_height-=Diff;
}
#endif

void _vc_select_form.on_load()
{
   if (ctlcl_enabled.p_value) {
      ctlcl_enabled._set_focus();
   }else if (ctlscc_enabled.p_value) {
      ctlscc_enabled._set_focus();
   }
}

void ctlok.on_create()
{
   ctlcl_systems.InsertCLSystemList();
   if (machine()=='OS2386' ) {
      wid=ctlcl_systems;
      wid.top();
      wid.up();
      for (;;) {
         if (wid._lbdown()) {
            break;
         }
         wid.get_line(line);
         if (pos('windows',line,1,'i')) {
            if (wid._lbdelete_item()) break;
            wid._lbup();
         }
      }
   }else{
      wid=ctlcl_systems;
      wid.top();
      wid.up();
      for (;;) {
         if (wid._lbdown()) {
            break;
         }
         wid.get_line(line);
         if (pos('os/2',line,1,'i')) {
            if (wid._lbdelete_item()) break;
            wid._lbup();
         }
      }
   }
   wid.top();
   if (machine()=='NT386') {
      ctlscc_systems.vsSccListProviders();
      ctlscc_systems._lbsort();
      ctlscc_systems._lbtop();
   }

   _ini_get_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',vcsproject,'');
   if (machine()=='NT386' && def_vc_system=='') {
      if (ctlscc_systems.p_Noflines) {
         ctlscc_enabled.p_value=1;
         ctlscc_enabled.call_event(ctlscc_enabled,LBUTTON_UP);
         ctlscc_systems._lbtop();
         ctlscc_systems._lbselect_line();
         ctlscc_projname.p_caption=MaybeNone(vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME));
      }else if (!ctlscc_systems.p_Noflines) {
         ctlcl_enabled.p_value=1;
         ctlcl_enabled.call_event(ctlcl_enabled,LBUTTON_UP);
         ctlcl_systems._lbtop();
         ctlcl_systems._lbselect_line();
         ctlscc_enabled.p_enabled=0;
      }
   }else if (machine()=='NT386' && _isscc(def_vc_system)) {
      vcs=substr(def_vc_system,5);
      ctlscc_enabled.p_value=1;
      ctlscc_enabled.call_event(ctlscc_enabled,LBUTTON_UP);
      ctlscc_systems._lbsearch(vcs);
      ctlscc_systems._lbselect_line();
      _str projname=vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME);
      ctlscc_projname.p_caption=MaybeNone(projname);
      if (projname!='') {
         ctlscc_open_project.p_caption='Close Project';
      }
   }else{
      ctlcl_enabled.p_value=1;
      ctlcl_enabled.call_event(ctlcl_enabled,LBUTTON_UP);
      vcs=def_vc_system;
      ctlcl_systems._lbsearch(vcs);
      ctlcl_systems._lbselect_line();
      //parse vcsproject with prj_vcs ':' project;
      vcsproject=MaybeStripLeadingVCSName(vcsproject,prj_vcs);
      if (prj_vcs==vcs) {
         //Don't want to set vcs project unle   ss it is the same system
         _vcs_project.p_text=vcsproject;
      }
   }
   _auto_checkout.p_value=def_vcflags&VCF_AUTO_CHECKOUT;
   _auto_checkin.p_value=def_vcflags&VCF_EXIT_CHECKIN;
   _set_read_only.p_value=def_vcflags&VCF_SET_READ_ONLY;
   if (machine()=='NT386') {
      ctlscc_systems.call_event(CHANGE_SELECTED,ctlscc_systems,ON_CHANGE,'W') ;
   }
   //SetLabel();
   if (machine()!='NT386'||!ctlscc_enabled.p_enabled||SIMULATE_NON_NT) {
      //If we can't use the scc stuff, hide it
      frame2.p_visible=0;
      _auto_checkout.p_y=_set_read_only.p_y=frame2.p_y;
      diff=_auto_checkout.p_y-frame1.p_y;
      ctlok.p_y-=diff;
      ctlcancel.p_y-=diff;
      ctlhelp.p_y-=diff;
      p_active_form.p_height-=diff;
      ctlcl_enabled.p_value=1;
      ctlcl_enabled.p_visible=0;
      ctlcl_enabled.call_event(ctlcl_enabled,LBUTTON_UP);
      ctlcl_enabled.p_y=-500;
      frame1.p_caption=ctlcl_enabled.p_caption;
   }
   if (machine()=='NT386') {
      ctlok.p_user=vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME);
   }
}

void ctlok.lbutton_up()
{
   //say('ctlok.p_user='ctlok.p_user);
   olddef_vc_system=def_vc_system;
   if (ctlcl_enabled.p_value) {
      if (_vcs_project.p_text!=_vcs_project.p_user) {
         _prjopen_vc();
      }
      def_vc_system=ctlcl_systems._lbget_text();
      _config_modify|=CFGMODIFY_DEFVAR;
      _ini_set_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',def_vc_system':'_vcs_project.p_text);
      if (machine()=='NT386' && 
          _isscc(def_vc_system) &&
          vsSccGetCurProjectInfo(VSSCC_PROVIDER_NAME)!='') {
         vsSccUninit();
      }
   }else if (ctlscc_enabled.p_value){
      def_vc_system=SCC_PREFIX:+ctlscc_systems._lbget_text();
      _config_modify|=CFGMODIFY_DEFVAR;
   }
   if (def_vc_system!=olddef_vc_system) {
      gvcEnableList._makeempty();
      vcGetList(gvcEnableList);
   }
   if (machine()=='NT386' && 
       _isscc(def_vc_system) &&
       vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME)!=ctlok.p_user) {
      toolbarUpdateFilterList(_project_name);
   }
   if (!_isscc(def_vc_system) || machine()!='NT386') {
      VerifyVCSExecutables();
   }
   if (_auto_checkout.p_value) {
      def_vcflags|=VCF_AUTO_CHECKOUT;
   }else{
      def_vcflags&=~VCF_AUTO_CHECKOUT;
   }
   if (_auto_checkin.p_value) {
      def_vcflags|=VCF_EXIT_CHECKIN;
   }else{
      def_vcflags&=~VCF_EXIT_CHECKIN;
   }
   if (_set_read_only.p_value) {
      def_vcflags|=VCF_SET_READ_ONLY;
   }else{
      def_vcflags&=~VCF_SET_READ_ONLY;
   }
   p_active_form._delete_window();
}

void ctlsetup.lbutton_up()
{
   result = show('-modal _vc_setup2_form',
                 ctlcl_systems._lbget_text());
}

static boolean nonblank(_str str)
{
   if (str!='') {
      return(0);
   }
   return(1);
}

static boolean nonblankpath(_str str)
{
   if (str=='') {
      return(1);
   }
   return(! (isdirectory(str)));//Has to return 0...
}

void ctlscc_open_project.lbutton_up()
{
   if (machine()=='NT386') {
      //This is strictly a precaution.  We should never get here unless we
      //are running Intel Windows
      if (p_caption=='&Open Project') {
         curvcs=ctlscc_systems._lbget_text();
         if (curvcs=='Perforce SCM') {
            status=show('-modal _textbox_form',
                        'Open Perforce Project',
                        TB_RETRIEVE_INIT,
                        '',//tb width
                        '',//help item
                        '',//reserved(buttons)
                        'perforceproject',//retrieve name
                        '-e 'nonblank' Project Name',
                        '-e 'nonblankpath' Local Path');
            if (status=='') return;
            status=vsSccOpenProject(0,"",_param1,_param2);
         }else{
            status=vsSccOpenProject(0,"");
         }
         if (!status) {
            _ini_set_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',def_vc_system':'vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME));
            _ini_set_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcslocalpath',def_vc_system':'vsSccGetCurProjectInfo(VSSCC_LOCAL_PATH));
         }
         if (vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME)!='') {
            p_caption='Close Project';
         }
      }else if (p_caption=='Close Project') {
         status=vsSccCloseProject();
         if (!status) {
            _ini_set_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',def_vc_system':'vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME));
            _ini_set_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcslocalpath',def_vc_system':'vsSccGetCurProjectInfo(VSSCC_LOCAL_PATH));
         }
         if (vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME)=='') {
            p_caption='&Open Project';
         }
      }
      ctlscc_projname.p_caption=MaybeNone(vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME));
      toolbarUpdateFilterList(_project_name);
      ctlok.p_user=vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME);
   }
}

#define VSSCC_MAJOR_VERSION 1
#define VSSCC_MINOR_VERSION 1

void ctlscc_init.lbutton_up()
{
   if (machine()=='NT386') {
      //This is strictly a precaution.  We should never get here unless we
      //are running Intel Windows
      if (vsSccGetCurProjectInfo(VSSCC_PROVIDER_NAME)!=ctlscc_systems._lbget_text()) {
         status=vsSccInit(ctlscc_systems._lbget_text());
      }
      if (status) {
         _message_box(nls("Could not initialize provider %s",ctlscc_systems._lbget_text()));
      }
      vsSccGetVersion(Major,Minor);
      if (Major<VSSCC_MAJOR_VERSION ||
          Minor<VSSCC_MINOR_VERSION) {
         _message_box(nls("Visual SlickEdit cannot use the provider support dll %s because it is too old.",vsSccGetCurProjectInfo(VSSCC_PROVIDER_NAME)));
         status=vsSccInit(ctlscc_systems._lbget_text());
         return;
      }
      ctlscc_open_project.p_caption='&Open Project';
      ctlscc_projname.p_caption=MaybeNone(vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME));
      ctlscc_systems.call_event(CHANGE_SELECTED,ctlscc_systems,ON_CHANGE,'W') ;
   }
}

void ctlscc_systems.on_change(reason)
{
   //say('vsSccGetCurProjectInfo(SCC_PROVIDER_NAME)='vsSccGetCurProjectInfo(SCC_PROVIDER_NAME));
   //say('vsSccGetCurProjectInfo(SCC_PROJECT_NAME)='vsSccGetCurProjectInfo(SCC_PROJECT_NAME));
   if (machine()=='NT386') {
      //This is strictly a precaution.  We should never get here unless we
      //are running Intel Windows
      if (_lbget_text()!=vsSccGetCurProjectInfo(VSSCC_PROVIDER_NAME)) {
         ctlscc_init.p_enabled=ctlscc_systems.p_enabled;
         ctlscc_open_project.p_enabled=0;
         ctlscc_advanced.p_enabled=0;
         ctlscc_projname.p_caption='NONE';
      }else{
         ctlscc_init.p_enabled=0;
         ctlscc_open_project.p_enabled=ctlscc_systems.p_enabled;
         ctlscc_advanced.p_enabled=ctlscc_systems.p_enabled;
         ctlscc_projname.p_caption=MaybeNone(vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME));
      }
   }
}

void ctlscc_advanced.lbutton_up()
{
   if (machine()=='NT386') {
      //This is strictly a precaution.  We should never get here unless we
      //are running Intel Windows
      vsSccGetCommandOptions(VSSCC_COMMAND_OPTION);
   }
}

static int IsUniqueSystemName(_str SystemName)
{
   if (pos(':',SystemName)) {
      _message_box(nls("'%s' is not a valid system name.  Please limit name to alphnumeric characters."));
      return(1);
   }
   status=_open_temp_view(_config_path():+VCUSER_SYSTEM_FILE,temp_view_id,orig_view_id);
   if (status==FILE_NOT_FOUND_RC) {
      //If the file is not found, we assume it does not exist
      //If it does not exist, the new name has to be unique.
      return(0);
   }
   status=_ini_find_section(SystemName);
   if (!status) {
      //New system name is not unique
      _message_box(nls("A system named '%s' already exists"));
      return(1);
   }
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   return(0);
}

void ctladd.lbutton_up()
{
   result=show('-modal _textbox_form',
               'New System Name',
               0,//Flags
               '',//Use default width
               '',//Help Item
               '',//Reserved
               '',//Retrieve Name
               '-e 'IsUniqueSystemName':New System Name');
   if (result=='') {
      return;
   }
   newvcs=_param1;
   orig_view_id=_create_temp_view(temp_view_id);
   insert_line('checkin_new=[CHECK IN NEW COMMAND HERE]');
   insert_line('checkout=[CHECK OUT COMMAND HERE]');
   insert_line('checkin=[CHECK IN COMMAND HERE]');
   insert_line('checkin_discard=[UNLOCK COMMAND HERE]');
   insert_line('checkout_read_only=[GET COMMAND HERE]');
   insert_line('archive_filespec=*.??v');
   insert_line('styles=comment_file,error_redir,dosrc');
   p_view_id=orig_view_id;
   status=_ini_put_section(_config_path():+VCUSER_SYSTEM_FILE,newvcs,temp_view_id);
   wid=p_window_id;
   p_window_id=ctlcl_systems;
   _lbclear();
   InsertCLSystemList();
   _lbtop();
   _lbsearch(newvcs);
   _lbselect_line();
   ctlsetup.call_event(ctlsetup,LBUTTON_UP);
   p_window_id=wid;
}

void ctldelete.lbutton_up()
{
   vcs=ctlcl_systems._lbget_text();
   status=_ini_delete_section(_config_path():+VCUSER_SYSTEM_FILE,vcs);
   if (status) {
      _message_box(nls("Could not delete system '%s'.  This may be because it is in the system vcs file.",vcs));
      return;
   }
   wid=p_window_id;
   p_window_id=ctlcl_systems;
   _lbclear();
   InsertCLSystemList();
   _lbtop();
   _lbselect_line();
   p_window_id=wid;
}

void ctlrename.lbutton_up()
{
   result=show('-modal _textbox_form',
               'New System Name',
               0,//Flags
               '',//Use default width
               '',//Help Item
               '',//Reserved
               '',//Retrieve Name
               '-e 'IsUniqueSystemName':New System Name');
   if (result=='') {
      return;
   }
   newvcs=_param1;
   vcs=ctlcl_systems._lbget_text();
   status=_open_temp_view(_config_path():+VCUSER_SYSTEM_FILE,temp_view_id,orig_view_id);
   if (status) {
      _message_box(nls("Could not rename system '%s'.  This may be because it is in the system vcs file.",vcs));
      return;
   }
   status=_ini_find_section(vcs);
   if (status) {
      _message_box(nls("Could not find system '%s'.  This may be because it is in the system vcs file.",vcs));
      return;
   }
   get_line(line);
   replace_line('['_param1']');
   _save_file('+o');
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   wid=p_window_id;
   p_window_id=ctlcl_systems;
   _lbclear();
   InsertCLSystemList();
   _lbtop();
   _lbsearch(newvcs);
   _lbselect_line();
   p_window_id=wid;
}

static int _vc_get_value(_str section_name,_str field_name,_str &result,typeless default_value='')
{
   if (_isscc(section_name) && machine()=='NT386') {
      //section_name=substr(section_name,5);
      result=default_value;
      return(0);
   }
   status=_ini_get_value(_vcsuser_file(),section_name,field_name,result,arg(4));
   if (status) {
      status=_ini_get_value(_vcssystem_file(),section_name,field_name,result,arg(4));
   }
   return(status);
}

defeventtab _vc_styles_form

void ctlok.on_create()
{
   p_active_form.p_caption=arg(1);
   _str styles=arg(2);
   _str vcsproject=arg(3);
   if (pos(',error_redir,',','styles',')) {
      ctlstderr.p_value=1;
   }else if (pos(',error_stdout,',','styles',')) {
      ctlstdout.p_value=1;
   }else if (pos(',error_file,',','styles',')) {
      ctlsserror.p_value=1;
   }
   ctldeltaerr.p_value=pos(',delta_error,',','styles',');
   ctlcomment_file.p_value=pos(',comment_file,',','styles',');
   ctldosrc.p_value=pos(',dosrc,',','styles',');
   ctlarchive_filespec.p_value=pos(',pvcs_wildcards,',','styles',');
   ctlvcp_required.p_value=pos(',vcp_required,',','styles',');
   if (pos(',sstree,',','styles',')) {
      ctlvcp_sstree.p_value=1;
   }else if (pos(',ssonedir,',','styles',')) {
      ctlvcp_ssonedir.p_value=1;
   }else if (pos(',sslocate,',','styles',')) {
      ctlvcp_sslocate.p_value=1;
   }else if (strip(vcsproject)=='dir') {
      ctlvcp_dir.p_value=1;
   }else if (_isrcs(p_active_form.p_caption)) {
      //Look to see if this is RCS, because it is hardwired in the code
      ctlvcp_archivedir.p_value=1;

      ctlvcp_sstree.p_enabled=0;
      ctlvcp_dir.p_enabled=0;
      ctlvcp_ssonedir.p_enabled=0;
      ctlvcp_sslocate.p_enabled=0;
   }
}

_str ctlok.lbutton_up()
{
   _str styles='',vcsproject='';
   if (ctlstderr.p_value) {
      styles='error_redir';
   }else if (ctlstdout.p_value) {
      styles='error_stdout';
   }else if (ctlsserror.p_value) {
      styles='error_file,sserror_file_rc';
   }
   if (ctldeltaerr.p_value) {
      styles=styles',delta_error';
   }
   if (ctlcomment_file.p_value) {
      styles=styles',comment_file';
   }
   if (ctldosrc.p_value) {
      styles=styles',dosrc';
   }
   if (ctlarchive_filespec.p_value) {
      styles=styles',pvcs_wildcards';
   }
   if (ctlvcp_required.p_value) {
      styles=styles',vcp_required';
   }
   if (ctlvcp_sstree.p_value) {
      styles=styles',sstree';
      vcsproject='ssproject,sswcl cd %s -o%t -exitcode';
   }else if (ctlvcp_ssonedir.p_value) {
      styles=styles',ssonedir';
      vcsproject='ssproject,ss cd %s -o%t -exitcode';
   }else if (ctlvcp_sslocate.p_value) {
      styles=styles',sslocate';
   }else if (ctlvcp_dir.p_value) {
      vcsproject='dir';
   }else if (ctlvcp_archivedir.p_value) {
      //For RCS, use this for the archive directory.
      //No actual values are set
   }
   p_active_form._delete_window(styles"\t"vcsproject);
   return(styles"\t"vcsproject);
}


static _str vcget_message(int status)
{
   if (!_isscc() || machine()!='NT386') {
      return(get_message(status));
   }
   switch (status) {
   case VSSCC_E_INITIALIZEFAILED:
      return("Initialize failed");
   case VSSCC_E_UNKNOWNPROJECT:
      return("Unknown project");
   case VSSCC_E_COULDNOTCREATEPROJECT:
      return("Could not create project");
   case VSSCC_E_NOTCHECKEDOUT:
      return("Not checked out");
   case VSSCC_E_ALREADYCHECKEDOUT:
      return("Already checked out");
   case VSSCC_E_FILEISLOCKED:
      return("File is locked");
   case VSSCC_E_FILEOUTEXCLUSIVE:
      return("File checked out exclusive");
   case VSSCC_E_ACCESSFAILURE:
      return("Access failure");
   case VSSCC_E_CHECKINCONFLICT:
      return("Checkin conflict");
   case VSSCC_E_FILEALREADYEXISTS:
      return("File already exists");
   case VSSCC_E_FILENOTCONTROLLED:
      return("File not controlled");
   case VSSCC_E_FILEISCHECKEDOUT:
      return("File is checked out");
   case VSSCC_E_NOSPECIFIEDVERSION:
      return("No specified version");
   case VSSCC_E_OPNOTSUPPORTED:
      return("Opereation not supported");
   case VSSCC_E_NONSPECIFICERROR:
      return("The version control system returned a non specific error code");
   case VSSCC_E_OPNOTPERFORMED:
      return("Operation not performed");
   case VSSCC_E_TYPENOTSUPPORTED:
      return("Type not supported");
   case VSSCC_E_VERIFYMERGE:
      return("Verify Merge");
   case VSSCC_E_FIXMERGE:
      return("Fix Merge");
   case VSSCC_E_SHELLFAILURE:
      return("Shell failure");
   case VSSCC_E_INVALIDUSER:
      return("Invalid user");
   case VSSCC_E_PROJECTALREADYOPEN:
      return("Project already open");
   case VSSCC_E_PROJSYNTAXERR:
      return("Project syntax error");
   case VSSCC_E_INVALIDFILEPATH:
      return("Invalid file path");
   case VSSCC_E_PROJNOTOPEN:
      return("Project not open");
   case VSSCC_E_NOTAUTHORIZED:
      return("Not authorized");
   case VSSCC_E_FILESYNTAXERR:
      return("File syntax error");
   case VSSCC_E_FILENOTEXIST:
      return("File does not exist");
   }
   return(get_message(status));
}

int _isscc(_str vcs=def_vc_system)
{
   return((int)(substr(vcs,1,SCC_PREFIX_LENGTH)==SCC_PREFIX));
}

boolean _SCCProjectIsOpen()
{

   if (machine()=='NT386') {
      //This is strictly a precaution.  We should never get here unless we
      //are running Intel Windows
      return(vsSccGetCurProjectInfo(VSSCC_PROJECT_NAME)!='');
   }
   return(false);
}

boolean _VCSCommandIsValid(_str FieldName)
{
   if (def_vc_system=='') {
      return(0);
   }
   vcsfile=_vcsuser_file();
   _str info='';
   if (_ini_get_value(vcsfile, def_vc_system, FieldName, info,'')) {
      vcsfile=_vcssystem_file();
      _ini_get_value(vcsfile, def_vc_system, FieldName, info,'');
   }
   return(info!='');
}

#define PROJECT_TREE_NAME '_proj_tooltab_tree'

_command refresh_project_toolbar() name_info(','READ_ONLY_ARG2|EDITORCTL_ARG2)
{
   toolbarUpdateFilterList(_project_name);
}

static void UpdateProjectTree(int treewid,_str filename)
{
   if (!treewid) {
      treewid=_find_formobj('_tbproject_form','N');
      if (treewid) {
         _nocheck _control _proj_tooltab_tree;
        treewid=treewid._proj_tooltab_tree;
      }
   }
   if (treewid) {
      treewid.UpdateProjectBitmap(filename);
   }
}

static void UpdateBufferReadOnlyStatus(_str filename)
{
   //Now reload the file to get the read-only stuff right
   orig_view_id=p_view_id;
   p_view_id=HIDDEN_VIEW_ID;
   _safe_hidden_window();
   status=load_files('+b 'strip(filename,'b','"'));
   if (!status) {
      maybe_set_readonly();
   }
   p_view_id=orig_view_id;
}

int _OnUpdate_vcget(CMDUI &cmdui,int target_wid,_str command)
{
   if (def_vc_system==''||command=='') {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCGET));
}
/*
   Get the current file
*/
_command int vcget(_str filename='') name_info(','READ_ONLY_ARG2|EDITORCTL_ARG2)
{
   boolean PassedFilename=filename!='';
   if (def_vc_system=='') {
      _message_box(nls("No vcs configured"));
      return(1);
   }
   if (p_name==PROJECT_TREE_NAME) {
      index=_TreeCurIndex();
      Caption=_TreeGetCaption(index);
      parse Caption with name "\t" path;
      filename=path;
      if (filename=='') {
         return(1);
      }
   }else if (filename=='') {
      filename=p_buf_name;
   }
   filename=maybe_quote_filename(filename);
   int status=0;
   if (_isscc(def_vc_system) && machine()=='NT386') {
      status=_checkout(junk,junk,filename,def_vc_system,
                       1,1);//edit_files,read_only
   }else{
      if (file_match(_vcerror_file()' -p',1)!='') {
         delete_file(_vcerror_file());
      }
      orig_view_id=_create_temp_view(errors_view_id);
      if (orig_view_id=='') return(1);
      activate_view(orig_view_id);
      status=_checkout(linenum,errors_view_id,filename,def_vc_system,
                       1,1);//edit_files,read_only
      //show('-modal _vc_error_form',errors_view_id,linenum);
   }
   UpdateBufferReadOnlyStatus(filename);
   return(0);
}
static int IsValidLevel()
{
   index=_TreeCurIndex();
   if (_TreeGetDepth(index)<2) {
      //This cannot be a file
      return(0);
   }
   return(1);
}
int _OnUpdate_vccheckout(CMDUI &cmdui,int target_wid,_str command)
{
   if (def_vc_system==''||command=='') {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCCHECKOUT));
}
/*
   Checkout the current file
*/
_command int vccheckout(_str filename='') name_info(','READ_ONLY_ARG2|EDITORCTL_ARG2)
{
   boolean PassedFilename=filename!='';
   if (def_vc_system=='') {
      _message_box(nls("No vcs configured"));
      return(1);
   }
   int status=0;
   int treewid=0;
   if (p_name==PROJECT_TREE_NAME) {
      //If someone has used the 'rclickmenu' on the project tree
      treewid=p_window_id;
      index=_TreeCurIndex();
      Caption=_TreeGetCaption(index);
      parse Caption with name "\t" path;
      filename=path;
      if (filename=='') {
         return(1);
      }
   }else if (filename=='') {
      if (!_isEditorCtl()) {
         return(FILE_NOT_FOUND_RC);
      }
      filename=p_buf_name;
   }
   filename=maybe_quote_filename(filename);
   if (_isscc(def_vc_system) && machine()=='NT386') {
      status=_checkout(junk,junk,filename,def_vc_system,1,0);
   }else{
      if (file_match(_vcerror_file()' -p',1)!='') {
         delete_file(_vcerror_file());
      }
      orig_view_id=_create_temp_view(errors_view_id);
      if (orig_view_id=='') return(1);
      activate_view(orig_view_id);
      status=_checkout(linenum,errors_view_id,filename,def_vc_system,
                       1,0);//edit_files,read_only
      //_checkout will not edit the files if there is no _mdi
      show('-modal _vc_error_form',errors_view_id,linenum);
   }
   UpdateProjectTree(treewid,filename);
   UpdateBufferReadOnlyStatus(filename);
   return(status);
}


// Need this so version 3.0 tool bars sort of work.
// Old message in toolbar will be wrong.
_command int checkin(...) name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   filename=strip_options(arg(1),options,1);
   return(vccheckin(filename));
}
// Need this so version 3.0 tool bars sort of work.
// Old message in toolbar will be wrong.
_command int checkout(...) name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   filename=strip_options(arg(1),options,1);
   return(vccheckout(filename));
}

int _OnUpdate_vccheckin(CMDUI &cmdui,int target_wid,_str command)
{
   if (def_vc_system==''||command=='') {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCCHECKIN));
}
/*
   Checkin the current file
*/
_command int vccheckin(_str filename='',_str comment='') name_info(','EDITORCTL_ARG2)
{
   boolean PassedFilename=filename!='';
   if (def_vc_system=='') {
      _message_box(nls("No vcs configured"));
      return(1);
   }
   int treewid=0;
   if (p_name==PROJECT_TREE_NAME) {
      treewid=p_window_id;
      index=_TreeCurIndex();
      Caption=_TreeGetCaption(index);
      parse Caption with name "\t" path;
      filename=path;
      if (filename=='') {
         return(1);
      }
   }else if (filename=='') {
      if (!_isEditorCtl()) {
         return(FILE_NOT_FOUND_RC);
      }
      filename=p_buf_name;
   }
   int status=list_modified();
   if (status) {
      return(status);
   }
   _vc_get_value(def_vc_system, "styles", styles);
   if (comment=='') {
      comment_file=pos('comment_file',styles,1,'i');
      result=show('-modal _vc_comment_form',filename,0);
      if (comment_file) {
         comment=absolute(_vccomment_file());
      }else{
         comment=_param1;
      }
   }
   filename=maybe_quote_filename(filename);
   if (result=='') {
      return(COMMAND_CANCELLED_RC);
   }
   if (_isscc(def_vc_system) && machine()=='NT386') {
      _checkin(junk,junk,filename,def_vc_system,0,0,0,comment);
   }else{
      if (file_match(_vcerror_file()' -p',1)!='') {
         delete_file(_vcerror_file());
      }
      orig_view_id=_create_temp_view(errors_view_id);
      if (orig_view_id=='') return(1);
      activate_view(orig_view_id);
      _checkin(linenum,errors_view_id,filename,def_vc_system,0,0,0,comment);
   }

   //Now update the bitmap in the project toolbar 
   UpdateProjectTree(treewid,filename);
   UpdateBufferReadOnlyStatus(filename);
   return(0);
}

int _OnUpdate_vcunlock(CMDUI &cmdui,int target_wid,_str command)
{
   if (def_vc_system==''||command=='') {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCUNLOCK));
}
/*
   Unlock the current file
*/
_command int vcunlock(_str filename='') name_info(','EDITORCTL_ARG2)
{
   boolean PassedFilename=filename!='';
   if (def_vc_system=='') {
      _message_box(nls("No vcs configured"));
      return(1);
   }
   int treewid=0;
   if (p_name==PROJECT_TREE_NAME) {
      treewid=p_window_id;
      index=_TreeCurIndex();
      Caption=_TreeGetCaption(index);
      parse Caption with name "\t" path;
      filename=path;
      if (filename=='') {
         return(1);
      }
   }else if (filename=='') {
      if (!_isEditorCtl()) {
         return(FILE_NOT_FOUND_RC);
      }
      filename=p_buf_name;
   }
   filename=maybe_quote_filename(filename);
   _str comment='';
   if (_isscc(def_vc_system) && machine()=='NT386') {
      _checkin(junk,junk,filename,def_vc_system,0,1,0,'');
   }else{
      if (file_match(_vcerror_file()' -p',1)!='') {
         delete_file(_vcerror_file());
      }
      orig_view_id=_create_temp_view(errors_view_id);
      if (orig_view_id=='') return(1);
      activate_view(orig_view_id);
      _checkin(linenum,errors_view_id,filename,def_vc_system,0,1,0,'');
   }
   //Now reload the file to get the read-only stuff right
   UpdateProjectTree(treewid,filename);
   UpdateBufferReadOnlyStatus(filename);
   return(0);
}

int _OnUpdate_vcadd(CMDUI &cmdui,int target_wid,_str command)
{
   if (def_vc_system==''||command=='') {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCADD));
}
/*
   Checkin the current file for the first time
*/
_command int vcadd(_str filename='',_str comment='') name_info(','EDITORCTL_ARG2|READ_ONLY_ARG2)
{
   boolean PassedFilename=filename!='';
   if (def_vc_system=='') {
      _message_box(nls("No vcs configured"));
      return(1);
   }
   int treewid=0;
   if (p_name==PROJECT_TREE_NAME) {
      treewid=p_window_id;
      index=_TreeCurIndex();
      Caption=_TreeGetCaption(index);
      parse Caption with name "\t" path;
      filename=path;
      if (filename=='') {
         return(1);
      }
   }else if (filename=='') {
      if (!_isEditorCtl()) {
         return(FILE_NOT_FOUND_RC);
      }
      filename=p_buf_name;
   }
   filename=maybe_quote_filename(filename);
   styles='';
   _vc_get_value(def_vc_system, "styles", styles);
   comment_file=pos('comment_file',styles,1,'i');
   if (comment=='') {
      result=show('-modal _vc_comment_form',filename,0);
      if (comment_file) {
         comment=absolute(_vccomment_file());
      }else{
         comment=_param1;
      }
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
   }
   if (_isscc(def_vc_system) && machine()=='NT386') {
      _checkin(junk,junk,filename,def_vc_system,1,0,0,comment);
   }else{
      if (file_match(_vcerror_file()' -p',1)!='') {
         delete_file(_vcerror_file());
      }
      orig_view_id=_create_temp_view(errors_view_id);
      if (orig_view_id=='') return(1);
      activate_view(orig_view_id);
      _checkin(linenum,errors_view_id,filename,def_vc_system,1,0,0,comment);
      show('-modal _vc_error_form',errors_view_id,linenum);
   }
   UpdateProjectTree(treewid,filename);
   UpdateBufferReadOnlyStatus(filename);
   return(0);
}

int _OnUpdate_vcmanager(CMDUI &cmdui,int target_wid,_str command)
{
   if (def_vc_system==''||command=='') {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCMANAGER));
}
_command int vcmanager() name_info(','NCW_ARG2|ICON_ARG2|READ_ONLY_ARG2|CMDLINE_ARG2|EDITORCTL_ARG2)
{
   int status=0;
   if (machine()!='NT386' || !_isscc()) {
      int orig_view_id=_create_temp_view(temp_view_id);
      p_view_id=orig_view_id;
      status=_misc_cl_vc_command(VCS_MANAGER,temp_view_id,'',def_vc_system,0,'A');
      if (status) {
         show('-modal _vc_error_form',temp_view_id);
      }else{
         _delete_temp_view(temp_view_id);
      }
   }else{
      _str junk[];
      //This is supposed to take an array of files to highlight when the VCS
      //comes up, but the SCC call doesn't seem to work right.
      status=vsSccRunScc(junk);
      if (status) {
         _message_box(nls(vcget_message(status)));
      }
   }
   return(status);
}

int _OnUpdate_vcproperties(CMDUI &cmdui,int target_wid,_str command)
{
   if (def_vc_system==''||command=='') {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCPROPERTIES));
}
_command int vcproperties(_str filename='') name_info(','READ_ONLY_ARG2|EDITORCTL_ARG2)
{
   int status=0;
   if (p_name==PROJECT_TREE_NAME) {
      index=_TreeCurIndex();
      Caption=_TreeGetCaption(index);
      parse Caption with name "\t" path;
      filename=path;
      if (filename=='') {
         return(1);
      }
   }else if (filename=='') {
      if (!_isEditorCtl()) {
         return(FILE_NOT_FOUND_RC);
      }
      filename=p_buf_name;
   }
   if (machine()=='NT386' && _isscc(def_vc_system)) {
      _str Files[];
      Files[0]=filename;
      status=vsSccProperties(filename);
      if (status) {
         _message_box(nls(vcget_message(status)));
      }
   }else{
      int orig_view_id=_create_temp_view(temp_view_id);
      p_view_id=orig_view_id;
      int status=_misc_cl_vc_command(VCS_PROPERTIES,temp_view_id,maybe_quote_filename(filename),def_vc_system,1);
      show('-modal _vc_error_form',temp_view_id,'','Properties for 'filename);
   }
   return(status);
}

int _OnUpdate_vcdiff(CMDUI &cmdui,int target_wid,_str command)
{
   if (def_vc_system==''||command=='') {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCDIFF));
}
_command int vcdiff(_str filename='') name_info(','READ_ONLY_ARG2|EDITORCTL_ARG2)
{
   int status=0;
   if (p_name==PROJECT_TREE_NAME) {
      index=_TreeCurIndex();
      Caption=_TreeGetCaption(index);
      parse Caption with name "\t" path;
      filename=path;
      if (filename=='') {
         return(1);
      }
   }else if (filename=='') {
      filename=p_buf_name;
   }
   if (machine()=='NT386' && _isscc(def_vc_system)) {
      status=vsSccDiff(filename);
      if (status) {
         _message_box(nls(vcget_message(status)));
      }
   }else{
      int orig_view_id=_create_temp_view(temp_view_id);
      p_view_id=orig_view_id;
      int status=_misc_cl_vc_command(VCS_DIFFERENCE,temp_view_id,maybe_quote_filename(filename),def_vc_system,1);
      show('-modal _vc_error_form',temp_view_id,'','Differences for 'filename);
   }
   return(status);
}

_command void vcsetup() name_info(','NCW_ARG2|ICON_ARG2|READ_ONLY_ARG2|CMDLINE_ARG2|EDITORCTL_ARG2)
{
   show('-modal _vc_select_form');
}

int _OnUpdate_vcremove(CMDUI &cmdui,int target_wid,_str command)
{
   if (def_vc_system==''||command=='') {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCREMOVE));
}
_command int vcremove(_str filename='') name_info(','READ_ONLY_ARG2|EDITORCTL_ARG2)
{
   boolean PassedFilename=filename!='';
   int RemoveFromProject=0;
   result=_message_box(nls("Remove %s from the project %s also?",filename,_project_name),'',MB_YESNOCANCEL);
   if (result==IDYES) {
      RemoveFromProject=1;
   }else if (result==IDCANCEL) {
      return(COMMAND_CANCELLED_RC);
   }
   int treewid=0
   if (p_name==PROJECT_TREE_NAME) {
      treewid=p_window_id;
      index=_TreeCurIndex();
      Caption=_TreeGetCaption(index);
      parse Caption with name "\t" path;
      filename=path;
      if (filename=='') {
         return(1);
      }
   }else if (filename=='') {
      if (!_isEditorCtl()) {
         return(FILE_NOT_FOUND_RC);
      }
      filename=p_buf_name;
   }
   if (machine()=='NT386' && _isscc(def_vc_system)) {
      _str Files[];
      Files[0]=filename;
      status=vsSccRemove(Files,'');
      if (status) {
         _message_box(nls(vcget_message(status)));
      }
   }else{
      int orig_view_id=_create_temp_view(temp_view_id);
      p_view_id=orig_view_id;
      int status=_misc_cl_vc_command(VCS_REMOVE,temp_view_id,maybe_quote_filename(filename),def_vc_system,0);
      if (status) {
         show('-modal _vc_error_form',temp_view_id);
      }
   }
   _str UpdateOptions='';
   if (_project_name!='') {
      if (RemoveFromProject) {
         orig_view_id=p_view_id;
         _ini_get_section(_project_name,"Files",temp_view_id);
         p_view_id=temp_view_id;
         top();up();
         status=search('^'_escape_re_chars(strip(filename,'b','"'))'$',_fpos_case'@r');
         if (!status) {
            UpdateOptions='R';
            _delete_line();
            p_view_id=orig_view_id;
            _ini_put_section(_project_name,"Files",temp_view_id);
         }else{
            //Couldn't find it, lets be quiet about it
            p_view_id=orig_view_id;
            _delete_temp_view(temp_view_id);
         }
      }
   }
   UpdateProjectTree(treewid,filename);
   UpdateBufferReadOnlyStatus(filename);
   return(status);
}

int _OnUpdate_vchistory(CMDUI &cmdui,int target_wid,_str command)
{
   if (def_vc_system==''||command=='') {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCHISTORY));
}
_command int vchistory(_str filename='') name_info(','READ_ONLY_ARG2|EDITORCTL_ARG2)
{
   int status=0;
   if (p_name==PROJECT_TREE_NAME) {
      index=_TreeCurIndex();
      Caption=_TreeGetCaption(index);
      parse Caption with name "\t" path;
      filename=path;
      if (filename=='') {
         return(1);
      }
   }else if (filename=='') {
      if (!_isEditorCtl()) {
         return(FILE_NOT_FOUND_RC);
      }
      filename=p_buf_name;
   }
   if (machine()=='NT386' && _isscc(def_vc_system)) {
      _str Files[];
      Files[0]=filename;
      status=vsSccHistory(filename);
      if (status) {
         _message_box(nls(vcget_message(status)));
      }
   }else{
      int orig_view_id=_create_temp_view(temp_view_id);
      p_view_id=orig_view_id;
      int status=_misc_cl_vc_command(VCS_HISTORY,temp_view_id,maybe_quote_filename(filename),def_vc_system,1);
      show('-modal _vc_error_form',temp_view_id,'','History for 'filename);
   }
   return(status);
}

int _OnUpdate_vclock(CMDUI &cmdui,int target_wid,_str command)
{
   //There is no SccLock command, so if we are using an SCC system
   if (def_vc_system==''||command==''|| 
       (_isscc(def_vc_system) && machine()=='NT386') ) {
      return(MF_GRAYED);
   }
   return(_OnUpdateVCCommand(cmdui,target_wid,command,VCLOCK));
}
_command int vclock(_str filename='')
{
   int treewid=0;
   if (p_name==PROJECT_TREE_NAME) {
      treewid=p_window_id;
      index=_TreeCurIndex();
      Caption=_TreeGetCaption(index);
      parse Caption with name "\t" path;
      filename=path;
      if (filename=='') {
         return(1);
      }
   }else if (filename=='') {
      if (!_isEditorCtl()) {
         return(FILE_NOT_FOUND_RC);
      }
      filename=p_buf_name;
   }
   if (_isscc(def_vc_system) && machine()=='NT386') {
      //Should not get here
      //There is no SccLock for me to call, and I gray the menu item
      _message_box(nls("This option is not supported for %s",substr(def_vc_system,SCC_PREFIX_LENGTH+1)));
      return(0);
   }else{
      int orig_view_id=_create_temp_view(temp_view_id);
      p_view_id=orig_view_id;
      int status=_misc_cl_vc_command(VCS_LOCK,temp_view_id,filename,def_vc_system,0);
      if (status) {
         show('-modal _vc_error_form',temp_view_id);
      }else{
         _delete_temp_view(temp_view_id);
      }
      return(status);
   }
   UpdateProjectTree(treewid,filename);
   UpdateBufferReadOnlyStatus(filename);
}

/*
returns 1 if the current file is controlled by version control for the 
current vc project

Filname MUST BE FULLY QUALIFIED

Only works properly for SCC, for all others, returns 1
*/
int _FileUnderVC(_str Filename)
{
   if (def_vc_system=='') {
      return(0);
   }
   if (!_isscc(def_vc_system) || machine()!='NT386') {
      return(1);
   }
   if (!machine()=='NT386') {
      return(0);
   }
   _str Files[];
   Files[0]=p_buf_name;
   int Checkin=0;
   int Checkout=0;
   int Get=0;
   status=vsSccPopulateList(VSSCC_COMMAND_GET,Files,1);
   if (Files._length()) {
      //We are only depopulating the list, so if there is anything left, it
      //has to be under version control
      return(1);
   }
   return(0);
}
 
defeventtab _vc_setup2_form;

#define COMMAND_MODIFIED ctlcommand_line.p_user
#define CURRENT_STYLES   ctladvanced.p_user

static _str CommandIndexes[]={
                              "Get",
                              "Checkout",
                              "Update",
                              "Unlock",
                              "Add",
                              "Lock",
                              "Remove",
                              "History",
                              "Difference",
                              "Properties",
                              "Manager"
                             };
static _str CommandIniNames:[]={
                                "Get"        => "checkout_read_only",
                                "Checkout"   => "checkout",
                                "Update"     => "checkin",
                                "Unlock"     => "checkin_discard",
                                "Add"        => "checkin_new",
                                "Lock"       => "lock",
                                "Remove"     => "remove",
                                "History"    => "history",
                                "Difference" => "difference",
                                "Properties" => "properties",
                                "Manager"    => "manager"
                               };

void vcGetList(int (&vcEnableList)[])
{
   int len=CommandIndexes._length();
   if (_isscc(def_vc_system) && machine()=='NT386') {
      for (i=0;i<len;++i) {
         vcEnableList[i]=MF_ENABLED;
      }
      vcEnableList[VCLOCK]=MF_GRAYED;
   }else{
      ini_filename=_config_path():+VCUSER_SYSTEM_FILE;
      status=_ini_get_section(ini_filename,def_vc_system,temp_view_id);
      if (status) {
         ini_filename=get_env('VSROOT'):+VCSYSTEM_FILE;
         status=_ini_get_section(ini_filename,def_vc_system,temp_view_id);
         if (status) return;
      }
      orig_view_id=p_view_id;
      for (i=0;i<len;++i) {
         commandname=CommandIniNames:[CommandIndexes[i]];
         p_view_id=temp_view_id;
         top();up();
         status=search('^'_escape_re_chars(commandname)'=','@ri');
         vcEnableList[i]=MF_GRAYED;
         if (!status) {
            get_line(line);
            parse line with '=' commandstr;
            if (strip(commandstr)!='') {
               vcEnableList[i]=MF_ENABLED;
            }else{
               vcEnableList[i]=MF_GRAYED;
            }
         }
      }
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
   }
}

definit()
{
   gvcEnableList._makeempty();
   vcGetList(gvcEnableList);
   rc=0;
}

/*
    WARNING: This function is called from code which assumes that the
    cmdui and command arguments are not used.
*/
int _OnUpdateVCCommand(CMDUI &cmdui,int target_wid,_str command,int index)
{
   if (!target_wid) {
      return(MF_GRAYED);
   }
   if (target_wid.p_name=='_proj_tooltab_tree') {
      if (!target_wid.IsValidLevel()) {
         return(MF_GRAYED);
      }
      return(gvcEnableList[index]);
   }
   if (!target_wid._isEditorCtl()) {
      return(MF_GRAYED);
   }
   if (p_buf_name=='' && command!='vcmanager') {
      return(MF_GRAYED);
   }
   return(gvcEnableList[index]);
}

static int GetCommandTable(_str vcsfile,_str vcs,_str (&CommandTable):[])
{
   for (i=0;i<CommandIndexes._length();++i) {
      _str result='';
      status=_vc_get_value(vcs,CommandIniNames:[CommandIndexes[i]],result,'');
      CommandTable:[CommandIndexes[i]]=result;
   }
   return(0);
}

void ctlok.on_create()
{
   p_active_form.p_caption = arg(1)' Setup';
   vcs = arg(1);
   ctlok.p_user = vcs;
   for (i=0;i<CommandIndexes._length();++i) {
      list1._lbadd_item(CommandIndexes[i]);
   }
   vcsfile=_vcsuser_file();
   status=_ini_get_value(vcsfile, vcs, VCS_CHECKIN, info)
   if (status) {
      vcsfile=_vcssystem_file();
   }
   _vc_get_value(vcs, "styles", styles,'');
   _vc_get_value(vcs, "vcsproject", vcsproject,'');
   CURRENT_STYLES=styles"\t"vcsproject;
   wid=p_window_id;
   p_window_id=list1;
   _lbsort();
   _lbtop();
   _lbselect_line();
   p_window_id=wid;
   _str CommandTable:[];
   GetCommandTable(vcsfile,vcs,CommandTable);
   p_active_form.p_user=CommandTable;
   list1.call_event(CHANGE_SELECTED,list1,ON_CHANGE,'w');
}

void ctlok.lbutton_up()
{
   if (COMMAND_MODIFIED==1) {
      list1.call_event(CHANGE_SELECTED,list1,ON_CHANGE,'w');
      _str CommandTable:[];
      CommandTable=p_active_form.p_user;
      _str vcs=ctlok.p_user;
      for (i=0;i<CommandIndexes._length();++i) {
         status=_ini_set_value(_vcsuser_file(),vcs,CommandIniNames:[CommandIndexes[i]],CommandTable:[CommandIndexes[i]]);
         if (status) {
            _message_box(nls("Could not write to file %s",_vcsuser_file()));
            return;
         }
      }
      if (CURRENT_STYLES!='') {
         //if CURRENT_STYLES is still '', these did not change and will be fine
         parse CURRENT_STYLES with styles vcsproject;
         _ini_set_value(_vcsuser_file(),vcs,'styles',styles);
         _ini_set_value(_vcsuser_file(),vcs,'vcsproject',vcsproject);
      }
   }
   p_active_form._delete_window();
}

void list1.on_change()
{
   _str CommandTable:[];
   CommandTable=p_active_form.p_user;
   if (list1.p_user!='') {
      CommandTable:[list1.p_user]=ctlcommand_line.p_text;
   }
   list1.p_user=_lbget_text();
   ctlcommand_line.p_text=CommandTable:[list1._lbget_text()];
   p_active_form.p_user=CommandTable;
}

void ctlcommand_line.on_change()
{
   if (p_active_form.p_visible) {
      COMMAND_MODIFIED=1;
   }
}

void ctladvanced.lbutton_up()
{
   parse p_active_form.p_caption with vcs 'Setup';
   vcs=strip(vcs);
   _str styles=CURRENT_STYLES;
   parse CURRENT_STYLES with styles vcsproject;
   CURRENT_STYLES=show('-modal _vc_styles_form',p_active_form.p_caption,styles,vcsproject);
   if (styles=='') return;
   if (styles!=CURRENT_STYLES) {
      COMMAND_MODIFIED=1;
   }
}

void _on_readonly_error(int KeyPressed)
{
   index=find_index('_on_readonly_error2',PROC_TYPE);
   if (index_callable(index)) {
      status=call_index(KeyPressed,index);
      if (!status) {
         return;
      }
   }
   if (def_vc_system=='' || !_HaveValidOuputFileName(p_buf_name)) {
      _message_box(READ_ONLY_ERROR_MESSAGE);
      return;
   }
   int doauto=0;
   if (def_vcflags&VCF_AUTO_CHECKOUT) {
      if (machine()=='NT386' && _isscc(def_vc_system)) {
         //If the current VCS is an SCC system, we can check to see if the 
         //file is in version control
         _str Files[];
         Files._makeempty();
         Files[0]=p_buf_name;
         status=vsSccPopulateList(VSSCC_COMMAND_CHECKOUT,Files,1);
         if (Files._length()) {
            //There was only one file in the list, and "depopulate only" 
            //was on, so if there are any left, we definitely have a file
            //in version control
            doauto=1;
         }
      }else{
         //If the current VCS is not an SCC system, we're flying blind.
         //Have to show them the VCS prompt box and hope for the best
         doauto=1;
      }
   }
   if (doauto) {
      result=show('-modal _vc_checkout_form',p_buf_name' is read only');
      if (result=='') {
         return;
      }
      if (result==CHECKOUT) {
         vccheckout();
      }else if (result==GET) {
         vcget();
      }else if (SET_WRITEABLE) {
         chmod('-r 'p_buf_name);
         p_readonly_mode=0;
      }
   }else{
      _message_box(READ_ONLY_ERROR_MESSAGE);
   }
}

defeventtab _vc_checkout_form

void ctlok.on_create()
{
   label1.p_caption=arg(1)"\nDo you wish to:";
   p_active_form.p_caption='Visual SlickEdit';
   if (arg(2)!='') {
      ctlcheckout.p_caption=arg(2);
   }
   if (arg(3)!='') {
      ctlget.p_caption=arg(3);
   }
   if (arg(4)!='') {
      ctlset_writable.p_caption=arg(4);
   }
}

void ctlok.lbutton_up()
{
   if (ctlcheckout.p_value) {
      p_active_form._delete_window(CHECKOUT);
   }else if (ctlget.p_value) {
      p_active_form._delete_window(GET);
   }else if (ctlset_writable.p_value) {
      p_active_form._delete_window(SET_WRITEABLE);
   }
}
static int VerifyCommand(_str (&InvalidExeNames):[],_str CommandString)
{
   str=CommandString;
   exename=parse_file(str);
   filename=path_search(exename,'','P');
   if (filename=='') {
      InvalidExeNames:[exename]=exename;
      return(1);
   }
   return(0);
}

static void VerifyVCSExecutables()
{
   _str InvlalidExeNames:[];

   _str checkinstr;
   _vc_get_value(def_vc_system,'checkin',checkinstr,'');
   status1=VerifyCommand(InvlalidExeNames,checkinstr);

   _str checkoutstr;
   _vc_get_value(def_vc_system,'checkout',checkoutstr,'');
   status2=VerifyCommand(InvlalidExeNames,checkoutstr);

   _str unlockstr;
   _vc_get_value(def_vc_system,'checkin_discard',unlockstr,'');
   status3=VerifyCommand(InvlalidExeNames,unlockstr);

   _str getstr;
   _vc_get_value(def_vc_system,'checkout_read_only',getstr,'');
   status4=VerifyCommand(InvlalidExeNames,getstr);

   _str addstr;
   _vc_get_value(def_vc_system,'checkin_new',addstr,'');
   status5=VerifyCommand(InvlalidExeNames,addstr);

   if (status1||status2||status3||status4||status5) {
      _str msg=nls("The following executables were not found:\n");
      for (i._makeempty();;) {
         InvlalidExeNames._nextel(i);
         if (i._isempty()) break;
         msg=msg:+i"\n";
      }
      msg=msg:+nls("Version control may not work properly because these executables could not be found.  You may need to add them to your PATH.");
      _message_box(nls(msg));
   }
}
/*
#define VSSCC_STATUS_INVALID          -1L,    // Status could not be obtained, don't rely on it
#define VSSCC_STATUS_NOTCONTROLLED    0x0000L,// File is not under source control
#define VSSCC_STATUS_CONTROLLED       0x0001L,// File is under source code control
#define VSSCC_STATUS_CHECKEDOUT       0x0002L,// Checked out to current user at local path
#define VSSCC_STATUS_OUTOTHER         0x0004L,// File is checked out to another user
#define VSSCC_STATUS_OUTEXCLUSIVE     0x0008L,// File is exclusively check out
#define VSSCC_STATUS_OUTMULTIPLE      0x0010L,// File is checked out to multiple people
#define VSSCC_STATUS_OUTOFDATE        0x0020L,// The file is not the most recent
#define VSSCC_STATUS_DELETED          0x0040L,// File has been deleted from the project
#define VSSCC_STATUS_LOCKED           0x0080L,// No more versions allowed
#define VSSCC_STATUS_MERGED           0x0100L,// File has been merged but not yet fixed/verified
#define VSSCC_STATUS_SHARED           0x0200L,// File is shared between projects
#define VSSCC_STATUS_PINNED           0x0400L,// File is shared to an explicit version
#define VSSCC_STATUS_MODIFIED         0x0800L,// File has been modified/broken/violated
#define VSSCC_STATUS_OUTBYUSER        0x1000L // File is checked out by current user someplace
*/
static int GetBitmapIndex(_str filename,int FileStatus)
{
   //boolean ro=IsReadOnly(filename);
   ro=0;
   if (!FileStatus || (FileStatus&VSSCC_STATUS_DELETED)) {
      if (ro) {
         return(_pic_doc_r);
      }else{
         return(_pic_doc_w);
      }
   }
   if (FileStatus & VSSCC_STATUS_CHECKEDOUT) {
      if (ro) {
         return(_pic_vc_co_user_r);
      }else{
         return(_pic_vc_co_user_w);
      }
   }
   if (FileStatus&VSSCC_STATUS_OUTOTHER) {
      if (FileStatus&VSSCC_STATUS_OUTEXCLUSIVE) {
         if (ro) {
            return(_pic_vc_co_other_x_r);
         }else{
            return(_pic_vc_co_other_x_w);
         }
      }else/* if (FileStatus&VSSCC_STATUS_OUTMULTIPLE) */{
         if (ro) {
            return(_pic_vc_co_other_m_r);
         }else{
            return(_pic_vc_co_other_m_w);
         }
      }
   }
   if (FileStatus&VSSCC_STATUS_CONTROLLED && 
       !(FileStatus&VSSCC_STATUS_LOCKED)) {
      if (ro) {
         return(_pic_vc_available_r);
      }else{
         return(_pic_vc_available_w);
      }
   }
   return(-1);
}

//This function sets a file's bitmap in the project window to the appropriate
//picture according to whether the file is checked out etc.
//The project tree conrol must be active
static void UpdateProjectBitmap(_str filename,_str options='')
{
   if (!machine()=='NT386' || !_isscc()) {
      return;
   }
   ParentIndex=_TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   filename=strip(filename,'B','"');
   for (;;) {
      if (ParentIndex<0) break;
      fileIndex=_TreeSearch(ParentIndex,strip_filename(filename,'P')"\t"filename,_fpos_case);
      if (fileIndex>0) {
         //Found one
         if (options=='R') {
            _TreeDelete(fileIndex);
         }else{
            int FileStatus[];
            status=vsSccQueryInfo(filename,FileStatus);
            if (!status) {
               bmindex=GetBitmapIndex(filename,FileStatus[0]);
               _TreeGetInfo(fileIndex,state);
               _TreeSetInfo(fileIndex,state,bmindex,bmindex);
            }
         }
         break;
      }
      ParentIndex=_TreeGetNextSiblingIndex(ParentIndex);
   }
}

#if 0
void vsSccDisplayOutput(_str str)
{
   formwid=_find_formobj('_tboutput_form','N');
   _nocheck _control ctlvc_output;
   _nocheck _control _output_sstab;
   if (!formwid) {
      tbShow('_tboutput_form');
      formwid=_find_formobj('_tboutput_form','N');
      if (!formwid) return;
      formwid._output_sstab.ctlvc_output.delete_line();
   }
   if (!formwid) return;
   _nocheck _control _output_sstab;
   formwid._output_sstab.p_ActiveTab=OUTPUTTOOLTAB_VCOUTPUT;
   wid=p_window_id;
   p_window_id=formwid._output_sstab.ctlvc_output;
   bottom();
   insert_line(str);
   bottom();
   p_window_id=wid;
}
#endif 
