//+------------------------------------------------------------------------------+
//|  What's it called: ESMP1.C
//|
//|  What does it do : Creates a simple E-MultiLine Edit Control Window.
//|                    The edit window uses SIMPLE.EX as its E-MLE profile
//|                    (See ESMP1.E
//|
//|  Who and When    : Gennaro (Jerry) Cuomo
//|                    John Ponzo (updated for version 5.60 + 6.00 of E toolkit)
//|                    Larry Margolis (Added sample error handling if EFrame returned is NULL)
//+------------------------------------------------------------------------------+

/*ͻ
 Included Header Files:                                             GC 9-88 
*/
#define INCL_WIN         // WIN function and WM_ msgs
#define INCL_DOS         // DOS functions
#define INCL_GPI         // graphic functions
#include <os2.h>

#include <stdio.h>       // C library functions...
#include <stdlib.h>      // C library functions...
#include <string.h>      // C library functions...
#include <malloc.h>      // C library functions...
#include <edll.h>        // includes bindings to ETKExxx.DLL
#include <eframe.h>      // EFrame header file
#include <eres.h>        // define MAXLEN

#if OS2VERSION < 20
  #define MSG USHORT
#else
  #define MSG ULONG
#endif

EFRAMEEDITWNDCTRLDATA EFrameEditWndCtrlData; //EFrame control info

MRESULT EXPENTRY SubclassedEditWndProc(HWND HwndEdit, MSG Msg, MPARAM Mp1, MPARAM Mp2);

PFNWP   EditWndDefWndProc;   // pointer to E-MLE default window procedure
HWND    hwndAppClient;       // handle to application client window
HWND    hwndEdit;            // handle to E-MLE  window
HWND    EFrame;              // handle to EFrame window

#define NEWEMLECLASS "NEWEMLECLASS"
BOOL    EMLESubclassed = 0;

/*Ŀ
                                                                            
 What's it called: TestWndProc()                                            
                                                                            
 What does it do : Handles messages sent to test application window.        
                   If a EPM_EDIT_CURSORMOVE message is received, display    
                   The current Line and column of the cursor.               
                                                                            
 Who and when    : Gennaro (Jerry) Cuomo   9-88                             
                                                                            
*/
MRESULT EXPENTRY TestWndProc( HWND hwnd, MSG msg, MPARAM mp1, MPARAM mp2)
{
   switch (msg)   {
        /*Ŀ
          This message is received when CLOSE is selected on the system       
          menu of the Test Edit Application window.                           
        */
   case WM_CLOSE:
        WinSendMsg(hwndEdit, EPM_EDIT_CLOSE, (MPARAM)0, (MPARAM)0);
        WinPostMsg(hwnd,WM_QUIT,0L,0L);
        break;
           /*Ŀ
            This message notifies your app that an edit window has   
            been closed.                                             
           */
      case EPM_EDIT_DESTROYNOTIFY:
           WinAlarm( HWND_DESKTOP, WA_NOTE);
           return((MRESULT)0);

        /*Ŀ
          Application window has become invalid...                            
          or window has changed size...                                       
        */
    case WM_PAINT:
    case WM_SIZE:
         {
           HPS    hPS;      /* local handle to a cashed micro PS */
           hPS = WinBeginPaint( hwnd, (HPS)0, (PRECTL)0);
           GpiErase( hPS );
           WinEndPaint( hPS );
         }
         break;
    default:
         return( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );
         break;
    }
    return((MRESULT)0);
}

/*Ŀ
                                                                            
 What's it called: main()                                                   
                                                                            
 What does it do : creates a application window and creates a child edit    
                   window that contains file(s) specified on the system     
                   command line.                                            
                                                                            
 Who and when    : Gennaro (Jerry) Cuomo   9-88                             
                                                                            
*/
void main(int argc, char **argv)
{
    QMSG    qmsg;                           // queue message structure
    ULONG   pmstyle;                        // application window style
    HMQ     hmq;                            // Queue Handle
    HAB     hab;                            // Anchor Block
    RECTL   rect;                           // rectangle structure for pos.
    CHAR    Fname[128];                     // Input file came
    HWND    hwndAppFrame;
    PSZ     class;                          // edit window class name
    PSZ     MY_EMLE = "MY E";
    EFRAMEEDITWNDCTRLDATA EFrameEditWndCtrlData; //EFrame control info
    ULONG format;
    PSZ     EFrameClass;
    PSZ     EMLEClass;
    EFRAMECTRLDATA  EFrameCtrlData;
    EDITWNDCTRLDATA EditWndCtrlData;


    hab = WinInitialize(0);              // Initialize app as a PM app

    hmq = WinCreateMsgQueue(hab, 0x100);    // Create Queue


    WinRegisterClass( hab,                  // Register Application window
                      (PSZ)"TEST",          //...class name
                      (PFNWP)TestWndProc,   //...application window proc
                      CS_SIZEREDRAW,        //...window class style
                      4                     //...make room for instance data
                    );

    // window style of application
    //size border
    //title bar, minimize-
    //maximize, system menu.

    pmstyle = FCF_SIZEBORDER | FCF_TITLEBAR | FCF_MINMAX | FCF_SYSMENU;

    hwndAppFrame =WinCreateStdWindow(       // Create application window
                     HWND_DESKTOP,          //...parent is the desk top wnd
                     WS_VISIBLE,            //...
                     &pmstyle,              //...window style flags
                     (PSZ)"TEST",           //...window class name
                     (PSZ)"Simple E-MLE Example",   //...title bar text.
                     0L,                    //...
                     (HMODULE)0,            //...
                     1001,                  //...
                     (PHWND)&hwndAppClient  //...(return) client wnd handle
                     );


    // Position Application Window
    rect.xLeft   =  75;
    rect.yBottom =  100;
    rect.xRight  =  500;
    rect.yTop    =  300;

    // Set position of app window
    WinSetWindowPos ((HWND)hwndAppFrame,
                     (HWND)HWND_TOP,
                     (SHORT)rect.xLeft,
                     (SHORT)rect.yBottom,
                     (SHORT)rect.xRight,
                     (SHORT)rect.yTop,
                     SWP_MOVE | SWP_SIZE );


   //----------  Register Edit Window -------------
   EFrameClass = EtkRegisterEFrameClass(hab);

   //--- Statically subclass the EMLE control --------
   if(!EMLESubclassed) {
     ULONG     flStyle;
     USHORT    cbData;
     CLASSINFO OriginalClass;

     EMLEClass   = EtkRegisterEMLEClass(hab);

     WinQueryClassInfo(hab, EMLEClass,  &OriginalClass);

     EditWndDefWndProc = OriginalClass.pfnWindowProc;

     flStyle  = OriginalClass.flClassStyle & ~CS_PUBLIC;
     cbData   = OriginalClass.cbWindowData ;

     WinRegisterClass(hab, NEWEMLECLASS, SubclassedEditWndProc, flStyle, cbData);

     EMLESubclassed = 1;
   }

   // are you loading a file from the command line
   if (argc > 1) {
      strcpy (Fname,argv[1]);
   } else {
      strcpy (Fname,"sample.doc");
   }

   memset(&EFrameEditWndCtrlData, 0, sizeof(EFRAMEEDITWNDCTRLDATA));
   memset(&EFrameCtrlData, 0, sizeof(EFRAMECTRLDATA));
   memset(&EditWndCtrlData, 0, sizeof(EDITWNDCTRLDATA));

   EFrameEditWndCtrlData.EFrameCtrlData  = &EFrameCtrlData;
   EFrameEditWndCtrlData.EditWndCtrlData = &EditWndCtrlData;

   EFrameEditWndCtrlData.EFrameCtrlData->PMFlags =   FCF_TITLEBAR   | FCF_SIZEBORDER | FCF_VERTSCROLL |
                                                    FCF_HORZSCROLL | FCF_NOMOVEWITHOWNER |
                                                    FCF_SYSMENU    | FCF_MINMAX;

   EFrameEditWndCtrlData.EFrameCtrlData->Flags   =   EFRAMEF_EDITWND;


   EFrameEditWndCtrlData.EditWndCtrlData->FileName = Fname;
   EFrameEditWndCtrlData.EditWndCtrlData->ExFile   = (PSZ)"ESMP1.EX";
   EFrameEditWndCtrlData.EditWndCtrlData->TopMkr   = (PSZ)"------Top of File Marker----------------";
   EFrameEditWndCtrlData.EditWndCtrlData->BotMkr   = (PSZ)"------Bottom of File Marker-------------";
   EFrameEditWndCtrlData.EditWndCtrlData->ExePath  = ".";
   EFrameEditWndCtrlData.EditWndCtrlData->EditorStyle = EDIT_STYLE_CURSORON;
   EFrameEditWndCtrlData.EditWndCtrlData->Size = sizeof(EDITWNDCTRLDATA);
   EFrameEditWndCtrlData.EFrameCtrlData->Size  = sizeof(EFRAMECTRLDATA);
   EFrameEditWndCtrlData.Size = sizeof(EFRAMEEDITWNDCTRLDATA);
   EFrameEditWndCtrlData.EditWndClassName = NEWEMLECLASS;


   EFrame = WinCreateWindow(  hwndAppClient,
                              EFrameClass,
                              0,
                              0L,
                              10, 40, 200, 200,
                              hwndAppClient,
                              HWND_TOP,
                              1001,
                              &EFrameEditWndCtrlData,
                              (PVOID)0);

   if (!EFrame) {
      UCHAR ErrorString[MAXLEN*3];
      ULONG ErrorID;
      switch(EFrameEditWndCtrlData.EditWndCtrlData->ErrCode)
      {
         case EWCEC_LIF_EXNOTFOUND:
              strcpy(ErrorString, "EX profile not found");
              break;
         case EWCEC_LIF_OUTOFRESOURCES:
              strcpy(ErrorString, "Cannot open edit window! \n\n\nThis is most likely caused by a depletion \nof some PM resource.");
              break;
         case EWCEC_LIF_EXBADVERSION:
              strcpy(ErrorString, "Invalid EX file or incorrect version.");
              break;
         default:
              strcpy(ErrorString, "Cannot open edit window! \n\n\nThis is most likely caused by a depletion \nof some PM resource.");
              break;
      }
      if (EFrameEditWndCtrlData.EditWndCtrlData->ErrCode==EWCEC_LIF_EXBADVERSION ||
          EFrameEditWndCtrlData.EditWndCtrlData->ErrCode==EWCEC_LIF_EXNOTFOUND) {
         strncat( ErrorString, "\n", sizeof(ErrorString));
         strncat( ErrorString, EFrameEditWndCtrlData.EditWndCtrlData->ExFile, sizeof(ErrorString));
      } /* endif */
      WinMessageBox ((HWND)HWND_DESKTOP,   /* Display editor return code   */
                     (HWND)hwndAppClient,
                     (PSZ)ErrorString,
                     (PSZ)"Error creating frame",
                     0,
                     MB_CUACRITICAL
                    );
   } else {

      hwndEdit = WinWindowFromID(EFrame, FID_CLIENT);


      // dispatch messages to Test Application
      while( WinGetMsg( hab, (PQMSG)&qmsg, (HWND)0, 0, 0 ) ) {
          WinDispatchMsg( hab, (PQMSG)&qmsg );
      }
   } /* endif */

   // Close up shop
   WinDestroyWindow( hwndAppFrame );
   WinDestroyMsgQueue( hmq );
   WinTerminate( hab );
}


MRESULT EXPENTRY SubclassedEditWndProc(HWND HwndEdit, MSG Msg, MPARAM Mp1, MPARAM Mp2)
{


   switch(Msg) {
      case EPM_QUERYHINI:
           return(MRESULT)HINI_USERPROFILE;
      case EPM_EDIT_ASKTOQUIT:
      case EPM_EDIT_ASKTOCLOSE:
           WinPostMsg((HWND)Mp2, EPM_EDIT_ASKTODONE, MPFROMSHORT(ERES_DISCARD), Mp1);
           return((MRESULT)0);

          /*Ŀ
           The edit window has send a return code.                    
           This message is in response to the last EPM_EDIT_COMMAND   
           message issued by the active edit window.                  
               mp1 = message string   (PSZ)                           
               mp2 = message number   (USHORT)                        
          */
     case EPM_EDIT_RETCODE:
          WinMessageBox ((HWND)HWND_DESKTOP,   /* Display editor return code   */
                         (HWND)hwndAppClient,
                         (PSZ)Mp1,
                         (PSZ)"E-MLE: Command Return Code",
                         0,
                         MB_ICONEXCLAMATION
                        );
          return((MRESULT)0);

       /*Ŀ
        This message is sent by the edit window to the owner.                  
        We process this message by displaying the current editor cursor pos.   
            mp1 = line number      (ULONG)                                     
            mp2 = column  number   (ULONG)                                     
       */
       case EPM_EDIT_CURSORMOVE:
            {
              POINTL pt;
              HPS    hps;
              CHAR   text[80];
              USHORT l;
              RECTL  rc;

              hps = WinGetPS(hwndAppClient);

              WinQueryWindowRect (hwndAppClient, (PRECTL)&rc );
              rc.yTop =  rc.yBottom + 20;
              WinFillRect(hps, &rc, CLR_RED );

              pt.x = 5L; pt.y = 3L;             /* Set the text coordinates,    */
              GpiSetColor( hps, CLR_WHITE );    /* Set color of the text        */

              l = sprintf(text,"Line = %lu ",(ULONG)Mp1);
              GpiCharStringAt( hps, &pt, (ULONG)l, (PSZ)text); /* Draw Text       */

              pt.x = 82L;
              l = sprintf(text,"Column = %lu ",(ULONG)Mp2);
              GpiCharStringAt( hps, &pt, (ULONG)l, (PSZ)text );

              WinReleasePS(hps);
            }
            return((MRESULT)0);

       case WM_DESTROY:
            return(EditWndDefWndProc(HwndEdit, Msg, Mp1, Mp2));

       default:
            return(EditWndDefWndProc(HwndEdit, Msg, Mp1, Mp2));
   }
}
