//+------------------------------------------------------------------------------+
//|  What's it called: ESAMPLE4.C
//|
//|  What does it do : Creates an EFrame Window and uses the E Toolkit
//|                    resource DLL and base E macros.
//|                    The edit window uses ESAMPLE4.EX as its E-MLE profile
//|
//|  Who and When    : John Ponzo 3/93
//|
//+------------------------------------------------------------------------------+

/*ͻ
 Included Header Files:                                             GC 9-88 
*/
#define INCL_WIN         // WIN function and WM_ msgs
#define INCL_DOS         // DOS functions
#define INCL_GPI         // GPI functions
#include <os2.h>

#include <stdio.h>       // C library functions...
#include <stdlib.h>      // C library functions...
#include <string.h>      // C library functions...
#include <malloc.h>      // C library functions...

#include <edll.h>        // includes bindings to ETKExxx.DLL
#include <eframe.h>      // EFrame header file
#include <eresdlg.h>     // E Toolkit Resource DLL Header Info
#include <eres.h>        // E Toolkit Resource DLL Header Info

#include "esmp4.h"

#if OS2VERSION < 20
  #define MSG USHORT
#else
  #define MSG ULONG
#endif


MRESULT EXPENTRY SubclassedEMLEWndProc(HWND HwndEdit, MSG Msg, MPARAM Mp1, MPARAM Mp2);
ULONG   CreateEFrame(HAB hab, PSZ FileName);

PFNWP    EditWndDefWndProc;   // pointer to E-MLE default window procedure
HWND     HwndAppClient;       // handle to application client window
HWND     HwndActiveEdit;      // handle to E-MLE  window
HWND     EFrame;              // handle to EFrame window
HMODULE  HModuleERES;         // handle to ETKRxxx.DLL
//HMODULE  HModuleECfg;         // handle to ETKCxxx.DLL
HINI     Hini;                // handle to ini file
LISTDLG  MsgDlgList;          // Retrieve List for Message Dialog
HWND     HwndHelpInstance;    // Handle to the help instance
HELPINIT HelpData;            // Help Instance creation structure

PEWINDOWLLNODE EWindowLL = 0; // Edit window linked list

#define NEWEMLECLASS "NEWEMLECLASS"
BOOL    EMLESubclassed = 0;

/*Ŀ
                                                                            
 What's it called: ApplicationWndProc()                                     
                                                                            
 What does it do : Handles messages sent to sample application window.      
                                                                            
 Who and when    : John Ponzo 3/93                                          
                                                                            
*/
MRESULT EXPENTRY ApplicationWndProc( HWND hwnd, MSG msg, MPARAM mp1, MPARAM mp2)
{
   switch (msg)   {

        /*Ŀ
          This message is received when CLOSE is selected on the system       
          menu of the Application window.                                     
        */
   case WM_CLOSE:
        WinSendMsg(HwndActiveEdit, EPM_EDIT_CLOSE, (MPARAM)0, (MPARAM)0);
        WinPostMsg(hwnd,WM_QUIT,0L,0L);
        break;

   case WM_COMMAND:
        switch((ULONG)mp1) {
                // Create a new EFrame window when this menu item is selected.
           case ID_CREATEEFRAME:
                CreateEFrame(WinQueryAnchorBlock(hwnd), (PSZ)0);
                break;

                // Pop up a dialog with a list of all EFrames
           case ID_LISTEFRAMES:
                ERESShowWndList(hwnd, EWindowLL);
                break;
           case ID_INSERTFONTSTRING:
                {
                   USHORT FontId;
                   PSZ           String="Line of text with Attributes"; //String to be inserted.
                   ATTRIBRECTYPE   Attr[3];          //Attributes for the string
                   PATTRSTRING     AttrString;       //Attributed string variable
                   USHORT          AttrLevel=15;
                   LSTRING         FontName;

                   EtkSetFileField(HwndActiveEdit, ATTRIBUTE_SUPPORT_LEVEL, 0, (PVOID)AttrLevel);

                   strcpy(FontName.Data, "Helvetica");
                   FontName.lsLength = strlen("Helvetica");

                   FontId =
                      EtkRegisterFont2(HwndActiveEdit, &FontName, 36, 0, 0, 0);


                   AttrString = (PATTRSTRING) malloc(sizeof(ATTRSTRING)+strlen(String)+1);

                   Attr[0].Col    = 1;
                   Attr[0].Class  = FONTCLASS;
                   Attr[0].IsPush = 1;
                   Attr[0].Value  = FontId;
                   Attr[1].Col    = 8;
                   Attr[1].Class  = FONTCLASS;
                   Attr[1].IsPush = 0;

                   AttrString->ALAttr  = &Attr[2];
                   AttrString->Attrs   = &Attr[0];
                   AttrString->SelfPtr = (PCHAR)AttrString;
                   AttrString->TextLen = strlen(String)+1;

                   strcpy(AttrString->Text, String);

                   EtkInsertText(HwndActiveEdit, 0, 1, &AttrString, CRLF_TERMINATED);

                   EtkInvalidateText(HwndActiveEdit, 1, 1);

                   free(AttrString);
                }
                break;
           case ID_INSERTCOLORSTRING:
                {
                   PSZ             String="Line of text with Attributes"; //String to be inserted.
                   ATTRIBRECTYPE   Attr[3];          //Attributes for the string
                   PATTRSTRING     AttrString;       //Attributed string variable
                   USHORT          AttrLevel=15;


                   EtkSetFileField(HwndActiveEdit, ATTRIBUTE_SUPPORT_LEVEL, 0, (PVOID)AttrLevel);

                   AttrString = (PATTRSTRING) malloc(sizeof(ATTRSTRING)+strlen(String)+1);

                   Attr[0].Col    = 1;
                   Attr[0].Class  = COLORCLASS;
                   Attr[0].IsPush = 1;
                   Attr[0].Value  = 9;
                   Attr[1].Col    = 5;
                   Attr[1].Class  = COLORCLASS;
                   Attr[1].IsPush = 0;

                   AttrString->ALAttr  = &Attr[2];
                   AttrString->Attrs   = &Attr[0];
                   AttrString->SelfPtr = (PCHAR)AttrString;
                   AttrString->TextLen = strlen(String)+1;

                   strcpy(AttrString->Text, String);

                   EtkInsertText(HwndActiveEdit, 0, 1, &AttrString, CRLF_TERMINATED);

                   EtkInvalidateText(HwndActiveEdit, 1, 1);

                   free(AttrString);
                }
                break;
        }

        /*Ŀ
          Application window has become invalid...                            
          or window has changed size...                                       
        */
    case WM_PAINT:
    case WM_SIZE:
         {
           HPS    hPS;      /* local handle to a cashed micro PS */
           hPS = WinBeginPaint( hwnd, (HPS)0, (PRECTL)0);
           GpiErase( hPS );
           WinEndPaint( hPS );
         }
         break;

      /*Ŀ
       An existing edit window is requesting to open up a new   
       edit window.  Since the requesting edit window can't do  
       this on its own, this message is sent to the application.
           mp1 = File name            (PSZ)                     
           mp2 = Option flag    bit=0  TRUE = FREE mp1 when done
                                bit=1  RESERVED                 
                                bit=2  GET-ABLE segment         
      */
      case EPM_EDIT_NEWFILE:
           if ((LONGFROMMP(mp2) & COMMAND_GETABLE)==COMMAND_GETABLE) {
              USHORT rc;
              #if OS2VERSION < 20
                OFFSETOF(mp1) = 0;
                rc=DosGetSeg( SELECTOROF(mp1) );
              #else
                rc=DosGetSharedMem(mp1, PAG_WRITE | PAG_READ);
              #endif
              if (rc) return(MPFROMSHORT(rc));     /* access denied */
           }

           CreateEFrame(WinQueryAnchorBlock(hwnd), (PSZ)mp1);

           if ((LONGFROMMP(mp2) & COMMAND_FREESEL)==COMMAND_FREESEL) {
               ERESFreeMem(mp1);
           }
           break;

        //Open the Proof Dialog. This message EPM_POPPROOFDLG is
        //sent from the base macros with the proof command.
   case EPM_POPPROOFDLG:
        {
           PROOFBOXINFO ProofBoxInfo;
           extern HMODULE ecfgModule;
           ProofBoxInfo.size       = sizeof(PROOFBOXINFO);
           ProofBoxInfo.Hini       = Hini;
           ProofBoxInfo.HwndApp    = HwndAppClient;
           ProofBoxInfo.HwndEdit   = HwndActiveEdit;
           ProofBoxInfo.AppName    = "EMLE_SAMP";

           if(!GetProcs()) return;  // Make sure that dynamically=loaded routines have been loaded!

           WinDlgBox(HWND_DESKTOP,
                        HwndAppClient,
                        (PFNWP)ERESProofDlgProc,
                        ecfgModule,
                        DLG_PROOF,
                        (PVOID)&ProofBoxInfo);
        }
        break;

        //Pop up the Open File Dialog. This Message was sent from the macros.
   case EPM_POPOPENDLG:
        {
           OPENBOXINFO OpenBoxInfo;
           extern HMODULE ecfgModule;
           memset(&OpenBoxInfo, 0, sizeof(OPENBOXINFO));
           OpenBoxInfo.Size     = sizeof(OPENBOXINFO);
           OpenBoxInfo.Mode     = SHORT2FROMMP(mp2);
           OpenBoxInfo.List     = 0;
           OpenBoxInfo.Hini     = Hini;
           OpenBoxInfo.HwndApp  = HwndAppClient;
           OpenBoxInfo.Style    = OPENF_ISSUE_OPEN;
           OpenBoxInfo.HwndEdit = HwndActiveEdit;
           OpenBoxInfo.AppName  = "EMLE_SAMP";
           OpenBoxInfo.KeyName  = "Open1Box";

           if(!GetProcs()) return;  // Make sure that dynamically=loaded routines have been loaded!

           WinDlgBox(HWND_DESKTOP,
                     HwndAppClient,
                     (PFNWP)ERESOpenDlgProc,
                     ecfgModule,
                     DLG_OPEN,
                     (PVOID)&OpenBoxInfo);
        }
        break;

        //Pop up the Command Line dialog. This message was sent from the macros.
   case EPM_POPCMDLINE:
        {
           COMMANDBOXINFO CommandBoxInfo;
           extern HMODULE ecfgModule;
           CommandBoxInfo.Size    = sizeof(COMMANDBOXINFO);
           CommandBoxInfo.Hini    = Hini;
           CommandBoxInfo.CmdText = mp2;
           CommandBoxInfo.HwndApp = hwnd;
           CommandBoxInfo.HwndEdit= HwndActiveEdit;
           CommandBoxInfo.List    = 0;
           CommandBoxInfo.Style   = CB_ISSUE_COMMAND;
           CommandBoxInfo.AppName = "EMLE_SAMP";
           CommandBoxInfo.KeyName = "CommandBox";

           if(!GetProcs()) return;  // Make sure that dynamically=loaded routines have been loaded!

           WinDlgBox(HWND_DESKTOP,
                     hwnd,
                     (PFNWP)ERESCommandDlgProc,
                     ecfgModule,
                     DLG_COMMAND,
                     (PVOID)&CommandBoxInfo);
            ERESFreeMem(mp2);
        }
        break;

        //Pop up the search dialog.
   case EPM_POPCHANGEDLG:
        {
           FINDBOXINFO FindBoxInfo;
           extern HMODULE ecfgModule;
           FindBoxInfo.Size     = sizeof(FINDBOXINFO);
           FindBoxInfo.Hini     = Hini;
           FindBoxInfo.FindText = mp2;
           FindBoxInfo.HwndApp  = hwnd;
           FindBoxInfo.HwndEdit = HwndActiveEdit;

           if(!GetProcs()) return;  // Make sure that dynamically=loaded routines have been loaded!

           WinDlgBox(HWND_DESKTOP, hwnd, ERESFindChangeDlgProc,
                     ecfgModule, DLG_CHANGE, &FindBoxInfo);
           ERESFreeMem(mp2);
        }
        break;

        //Pop up the Undo dialog.
   case EPM_POPUNDODLG:
        {
           UNDOBOXINFO UndoBoxInfo;
           extern HMODULE ecfgModule;
           UndoBoxInfo.Size     = sizeof(UNDOBOXINFO);
           UndoBoxInfo.Hini     = Hini;
           UndoBoxInfo.HwndApp  = hwnd;
           UndoBoxInfo.HwndEdit = HwndActiveEdit;

           if(!GetProcs()) return;  // Make sure that dynamically=loaded routines have been loaded!

           WinDlgBox(HWND_DESKTOP,
                     HwndActiveEdit,
                     (PFNWP)ERESUndoDlgProc,
                     ecfgModule,
                     DLG_UNDO,
                     (PVOID)&UndoBoxInfo);
            break;
        }

        //Pop up the List Ring Dialog.
   case EPM_POPRINGDLG:
        {
           RINGBOXINFO    RingBoxInfo;
           extern HMODULE ecfgModule;
           USHORT         rc;

           RingBoxInfo.Size    = sizeof(RINGBOXINFO);
           RingBoxInfo.Hini    = Hini;
           RingBoxInfo.HwndApp = HwndAppClient;
           RingBoxInfo.HwndEdit= HwndActiveEdit;

           if(!GetProcs()) return;  // Make sure that dynamically=loaded routines have been loaded!

           rc = WinDlgBox(HWND_DESKTOP,
                          HwndActiveEdit,
                          (PFNWP)ERESRingDlgProc,
                          ecfgModule,
                          DLG_RING,
                          (PVOID)&RingBoxInfo);
        }
        break;


        //Pop up the Print dialog.
   case EPM_POPPRINTDLG:
        {
           extern HMODULE ecfgModule;
           PRINTBOXINFO PrintBoxInfo;
           PrintBoxInfo.Size     = sizeof(PRINTBOXINFO);
           PrintBoxInfo.Hini     = Hini;
           PrintBoxInfo.HwndApp  = hwnd;
           PrintBoxInfo.HwndEdit = HwndActiveEdit;

           if(!GetProcs()) return;  // Make sure that dynamically=loaded routines have been loaded!

           WinDlgBox(HWND_DESKTOP,
                     HwndActiveEdit,
                     (PFNWP)ERESPrintDlgProc,
                     ecfgModule,
                     DLG_PRINT,
                     (PVOID)&PrintBoxInfo);
           break;
        }

        //Pop up the Configuration dialog.
   case EPM_POPCONFIGDLG:
        {
           SETBOXINFO SetBoxInfo;
           extern HMODULE ecfgModule;

           SetBoxInfo.Size     =  sizeof(SETBOXINFO);
           SetBoxInfo.Hini     =  Hini;
           SetBoxInfo.HwndApp  =  hwnd;
           SetBoxInfo.HwndEdit =  HwndActiveEdit;
           SetBoxInfo.Pages    =  (ULONG)mp1;
           SetBoxInfo.Options  =  (PUSHORT)&mp2;
           SetBoxInfo.Mode     =  SETBOX_SET;

           if(!GetProcs()) return;  // Make sure that dynamically=loaded routines have been loaded!

           WinDlgBox(HWND_DESKTOP,
                     HwndActiveEdit,
                     (PFNWP)ERESSettingsDlgProc,
                     ecfgModule,
                     DLG_SETTINGS,
                     (PVOID)&SetBoxInfo);
        }
        break;

        //Pop up the Style dialog.
   case EPM_POPFONTDLG:
        {
           extern HMODULE ecfgModule;
           STYLEBOXINFO StyleBoxInfo;
           memset(&StyleBoxInfo, 0, sizeof(STYLEBOXINFO));
           StyleBoxInfo.Size             = sizeof(STYLEBOXINFO);
           StyleBoxInfo.Hini             = Hini;
           StyleBoxInfo.HwndApp          = hwnd;
           StyleBoxInfo.HwndEdit         = HwndActiveEdit;
           StyleBoxInfo.Type             = STYLEDLG_DIALOG;

           if(!GetProcs()) return;  // Make sure that dynamically=loaded routines have been loaded!

           WinDlgBox(HWND_DESKTOP,
                     HwndActiveEdit,
                     (PFNWP)ERESStyleDlgProc,
                     ecfgModule,
                     DLG_STYLE,
                     (PVOID)&StyleBoxInfo);
           break;
        }

         //Pop up the message box.
    case EPM_POPMSGBOX:
         {
           extern HMODULE ecfgModule;
            MSGBOXINFO MsgBoxInfo;
            MsgBoxInfo.Size    = sizeof(MSGBOXINFO);
            MsgBoxInfo.HwndApp = HwndAppClient;
            MsgBoxInfo.MsgText = mp2;
            MsgBoxInfo.List    = &MsgDlgList;
            MsgBoxInfo.Hini    = Hini;

           if(!GetProcs()) return;  // Make sure that dynamically=loaded routines have been loaded!

            WinDlgBox(HWND_DESKTOP,
                      HwndActiveEdit,
                      (PFNWP)ERESMsgBoxDlgProc,
                      ecfgModule,
                      DLG_MSGBOX,
                      (PVOID)&MsgBoxInfo);
         }
         break;

         //Pop up the help panel specified in mp1.
    case EPM_POPHELPMGRPANEL:
         {
            if(!HwndHelpInstance) {
               HwndHelpInstance = WinCreateHelpInstance(WinQueryAnchorBlock(hwnd),&HelpData);
            }

            if(HwndHelpInstance) {
               WinSendMsg(HwndHelpInstance, HM_DISPLAY_HELP, mp1, HM_RESOURCEID);
            }
         }
         break;

    default:
         return( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );
         break;
    }
    return((MRESULT)0);
}



/*Ŀ
                                                                            
 What's it called: main()                                                   
                                                                            
 What does it do : Creates a application window and creates a child EFrame  
                   window.                                                  
                                                                            
 Who and when    : John Ponzo   3-93                                        
                                                                            
*/
void main(int argc, char **argv)
{
    QMSG    qmsg;                           // queue message structure
    ULONG   pmstyle;                        // application window style
    HMQ     hmq;                            // Queue Handle
    HAB     hab;                            // Anchor Block
    RECTL   rect;                           // rectangle structure for pos.
    HWND    HwndAppFrame;
    extern UCHAR ERES_LIBRARY_NAME[];

     // Initialize app as a PM app
    hab = WinInitialize(0);

    // Create Queue. Make sure your queue size is at least 0x100.
    hmq = WinCreateMsgQueue(hab, 0x100);

    // Get the handle to the ETK Resource DLL.
    #if OS2VERSION < 20
       DosGetModHandle("ETKR560", &HModuleERES);
    #else
       DosQueryModuleHandle(ERES_LIBRARY_NAME, &HModuleERES);
    #endif

    //Open the applications profile
    Hini = PrfOpenProfile(hab, "ESMP4.INI");

    //Get The message dialogs retrieve list.
    ERESRetrieveDlgList(Hini, &MsgDlgList,"EMLE_SAMP", "MsgList");

    //Initialize the help structure. Help is not created until
    //a help panel is requested. This decreases startup time since the
    //help file is large.

    HelpData.cb                      = sizeof(HELPINIT);
    HelpData.phtHelpTable            = (PVOID)(0xFFFF0000|ID_EPMWND);
    HelpData.pszHelpWindowTitle      = "EMLE Help";
    HelpData.pszHelpLibraryName      = "ETK.HLP";


    WinRegisterClass( hab,                  // Register Application window
                      (PSZ)"TEST",          //...class name
                      (PFNWP)ApplicationWndProc,   //...application window proc
                      CS_SIZEREDRAW,        //...window class style
                      4                     //...make room for instance data
                    );


    // window style of application
    //size border
    //title bar, minimize-
    //maximize, system menu.

    pmstyle = FCF_SIZEBORDER | FCF_TITLEBAR | FCF_MINMAX | FCF_SYSMENU |
              FCF_MENU;

    HwndAppFrame =
      WinCreateStdWindow(                       // Create application window
                         HWND_DESKTOP,          //...parent is the desk top wnd
                         WS_VISIBLE,            //...
                         &pmstyle,              //...window style flags
                         (PSZ)"TEST",           //...window class name
                         (PSZ)"ESample4",       //...title bar text.
                         0L,                    //...
                         (HMODULE)0,            //...
                         ID_WINDOW,             //...
                         (PHWND)&HwndAppClient  //...(return) client wnd handle
                         );


    // Position Application Window
    rect.xLeft   =  75;
    rect.yBottom =  100;
    rect.xRight  =  800;
    rect.yTop    =  500;

    // Set position of app window
    WinSetWindowPos ((HWND)HwndAppFrame,
                     (HWND)HWND_TOP,
                     (SHORT)rect.xLeft,
                     (SHORT)rect.yBottom,
                     (SHORT)rect.xRight,
                     (SHORT)rect.yTop,
                     SWP_MOVE | SWP_SIZE );

   //Create an EFrame
   CreateEFrame(hab, (PSZ)0);

   // dispatch messages  Application window
   while( WinGetMsg( hab, (PQMSG)&qmsg, (HWND)0, 0, 0 ) ) {
       WinDispatchMsg( hab, (PQMSG)&qmsg );
   }

   // Save the retrieve list of the message box.
   ERESSaveDlgList(Hini, &MsgDlgList, "EMLE_SAMP", "MsgList");

   //Close the ini file
   if(Hini) {
      PrfCloseProfile(Hini);
   }

   //if help was created destroy it now.
   if(HwndHelpInstance) {
      WinDestroyHelpInstance(HwndHelpInstance);
   }

   // Close up shop
   WinDestroyWindow(HwndAppFrame);
   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
}

/*Ŀ
                                                                            
 What's it called: CreateEFrame                                             
                                                                            
 What does it do : Creates an EFrame window with the given file name.       
                                                                            
 Who and when    : John Ponzo 3/93                                          
                   Larry Margolis (updated for version 6.03 of E Toolkit).  
*/
ULONG CreateEFrame(HAB hab, PSZ FileName)
{
   CHAR                  Fname[128];
   HWND                  hwndAppFrame;
   PSZ                   EFrameClass;
   HWND                  HwndEdit;
   EFRAMEEDITWNDCTRLDATA EFrameEditWndCtrlData; //EFrame control info
   EFRAMECTRLDATA        EFrameCtrlData;
   EDITWNDCTRLDATA       EditWndCtrlData;


   //----------  Register Edit Window -------------
   EFrameClass = EtkRegisterEFrameClass(hab);

   if(!EMLESubclassed) {
     ULONG     flStyle;
     USHORT    cbData;
     CLASSINFO OriginalClass;
     PSZ       EMLEClass;

     EMLEClass   = EtkRegisterEMLEClass(hab);

     WinQueryClassInfo(hab, EMLEClass,  &OriginalClass);

     EditWndDefWndProc = OriginalClass.pfnWindowProc;

     flStyle  = OriginalClass.flClassStyle & ~CS_PUBLIC;
     cbData   = OriginalClass.cbWindowData ;

     WinRegisterClass(hab, NEWEMLECLASS, SubclassedEMLEWndProc, flStyle, cbData);

     EMLESubclassed = 1;
   }

   if(!FileName) {
      strcpy(Fname,"sample.doc");
   }else{
      strcpy(Fname, FileName);
   }

   memset(&EFrameEditWndCtrlData, 0, sizeof(EFRAMEEDITWNDCTRLDATA));
   memset(&EFrameCtrlData, 0, sizeof(EFRAMECTRLDATA));
   memset(&EditWndCtrlData, 0, sizeof(EDITWNDCTRLDATA));

   EFrameEditWndCtrlData.EFrameCtrlData  = &EFrameCtrlData;
   EFrameEditWndCtrlData.EditWndCtrlData = &EditWndCtrlData;

   EFrameEditWndCtrlData.EFrameCtrlData->PMFlags =   FCF_TITLEBAR   | FCF_SIZEBORDER | FCF_VERTSCROLL |
                                                     FCF_HORZSCROLL | FCF_NOMOVEWITHOWNER |
                                                     FCF_SYSMENU    | FCF_MINMAX;

   EFrameEditWndCtrlData.EFrameCtrlData->Flags   =   EFRAMEF_STATUSWND      |
                                                     EFRAMEF_MESSAGEWND     |
                                                     EFRAMEF_FILEWND        |
                                                     EFRAMEF_RINGBUTTONS    |
                                                     EFRAMEF_DMTBWND        |
                                                     EFRAMEF_TASKLISTENTRY  |
                                                     EFRAMEF_EDITWND        ;

   EFrameEditWndCtrlData.EditWndCtrlData->FileName = Fname;
   EFrameEditWndCtrlData.EditWndCtrlData->ExFile   = (PSZ)"ESMP4.EX";
   EFrameEditWndCtrlData.EditWndCtrlData->TopMkr   = (PSZ)"------Top of File Marker----------------";
   EFrameEditWndCtrlData.EditWndCtrlData->BotMkr   = (PSZ)"------Bottom of File Marker-------------";
   EFrameEditWndCtrlData.EditWndCtrlData->ExePath  = ".";
   EFrameEditWndCtrlData.EditWndCtrlData->EditorStyle = EDIT_STYLE_CURSORON |
                                                        EDIT_STYLE_COMMANDMSGTOMACROS  |
                                                        EDIT_STYLE_DISPLAYERRORRETRY;
   EFrameEditWndCtrlData.EditWndCtrlData->Size = sizeof(EDITWNDCTRLDATA);
   EFrameEditWndCtrlData.EFrameCtrlData->Size  = sizeof(EFRAMECTRLDATA);
   EFrameEditWndCtrlData.Size = sizeof(EFRAMEEDITWNDCTRLDATA);
   EFrameEditWndCtrlData.EditWndClassName = NEWEMLECLASS;


   EFrame = WinCreateWindow(  HwndAppClient,
                              EFrameClass,
                              0,
                              0L,
                              10, 40, 600, 400,
                              HwndAppClient,
                              HWND_TOP,
                              1001,
                              &EFrameEditWndCtrlData,
                              (PVOID)0);
   // See error handling in ESMP1.C if EFrame is NULL.

   //Get the handle to the E-MLE(The Client window of the EFrame)
   HwndEdit = WinWindowFromID(EFrame, FID_CLIENT);

   //Add the EMLE to the Edit window list.
   ERESAddToWndList(&EWindowLL, HwndEdit, 0L);
}


/*Ŀ
                                                                            
 What's it called: SubclassedEMLEWndProc                                    
                                                                            
 What does it do : Creates an EFrame window with the given file name.       
                                                                            
 Who and when    : John Ponzo 3/93                                          
                                                                            
*/
MRESULT EXPENTRY SubclassedEMLEWndProc(HWND HwndEdit, MSG Msg, MPARAM Mp1, MPARAM Mp2)
{
   switch(Msg) {
      case EPM_EDIT_ACTIVEHWND:
           HwndActiveEdit = (HWND)Mp1;
           return((MRESULT)0);
           /*Ŀ
            This message notifies your app that an edit window has   
            been closed. Delete it from the EMLE List.               
           */
      case EPM_EDIT_DESTROYNOTIFY:
           ERESDeleteFromWndList(&EWindowLL, (HWND)Mp1);
           return((MRESULT)0);

           //A Return code Message was sent to your application. Store it in
           //the Message Dialog retrieve list.
      case EPM_EDIT_RETCODE:
           ERESRetrieveListInsert(&MsgDlgList, (PSZ)Mp1, 1);
           return((MRESULT)0);

           //A Request was made from the E Macros for the handle to your INI file
      case EPM_QUERYHINI:
           return((MRESULT)Hini);


           //See the E Toolkit Documentation a description of these messages.
      case EPM_EDIT_ASKTOQUIT:
      case EPM_EDIT_ASKTOCLOSE:
      case EPM_EDIT_ASKTOFAILED:
           {
             HAB  hab=WinQueryAnchorBlock(HwndEdit);
             char tempstr[450];
             char DialogTitle[400];
             char DialogMessage[450];
             QUITBOXINFO QuitBoxInfo;
             USHORT titlemsg;
             ULONG  rc;

             QuitBoxInfo.Size       = sizeof(QUITBOXINFO);
             QuitBoxInfo.FileName   = Mp1;
             QuitBoxInfo.DlgTitle   = DialogTitle;
             QuitBoxInfo.DlgMessage = DialogMessage;
             QuitBoxInfo.HwndApp    = HwndAppClient;

             WinLoadString(hab, 0, IDS_SAVEWARNING1, 150, tempstr);
             sprintf( QuitBoxInfo.DlgMessage, tempstr, QuitBoxInfo.FileName);

             if (Msg == EPM_EDIT_ASKTOQUIT) {
                titlemsg=IDS_QUITTINGFILE;
             } else if (Msg == EPM_EDIT_ASKTOCLOSE)  {
                titlemsg=IDS_CLOSINGWINDOW;
             } else if (Msg == EPM_EDIT_ASKTOFAILED) {
                titlemsg=IDS_SAVEERROR;
                WinLoadString(hab, 0, IDS_SAVEWARNING2, 150, tempstr);
                sprintf(QuitBoxInfo.DlgMessage,tempstr,QuitBoxInfo.FileName);
             }
             WinLoadString(hab, 0, titlemsg, 128, QuitBoxInfo.DlgTitle);

             // Call quit dlgbox. mp1 contains name of file to quit.
             // mp2 contains the window handle of the edit window.
             rc = WinDlgBox(HWND_DESKTOP, (HWND)Mp2, (PFNWP)ERESQuitDlgProc,
                     HModuleERES, DLG_QUITBOX, (PVOID) &QuitBoxInfo);
             if (rc == ERES_SAVE) {
                // execute the "SAVE" function.
                strcpy(tempstr,"Save ");
                strcat(tempstr, (PSZ) QuitBoxInfo.FileName);
                strcpy(Mp1, tempstr);
                WinPostMsg((HWND)Mp2, EPM_EDIT_ASKTODONE, MPFROMSHORT(rc), Mp1);
             } else {
                WinPostMsg((HWND)Mp2, EPM_EDIT_ASKTODONE, MPFROMSHORT(rc), 0L);
             } /* endif */
             break;
           }

       case WM_DESTROY:
            return(EditWndDefWndProc(HwndEdit, Msg, Mp1, Mp2));

       default:
            return(EditWndDefWndProc(HwndEdit, Msg, Mp1, Mp2));
   }
}

