//Constants
#include <edll.h>
#define MAXSTRLEN 255


//Private data used by the frame window
typedef struct {
   HWND  HwndCmdLine;         //handle of the command line window
   HWND  HwndMsg;             //handle of the message window
   HWND  HwndStatus;          //handle of the status window
   HWND  HwndFile;            //handle of the file window
   HWND  HwndPrevButton;      //handle of the Previous rotate button
   HWND  HwndNextButton;      //handle of the Next rotate button
   HWND  HwndUCMenu;          //handle of the user configurable menu(BUTTON BAR)
   ULONG Flags;               //EtkFrame Flags
   ULONG PMFlags;             //PM flags of the frame
   UCHAR TaskListEntryPrefix[52]; //Prefix used for the Task List Entry
                              //This is usually the application name
                              //as opposed to the file name
   SWCNTRL TaskInfo;          //Task list entry structure
   HSWITCH TaskHandle;        //Handle to the task-list entry
   HPOINTER HIcon;            //Window Icon
   PHELPTABLE    HelpTable;
   PHELPSUBTABLE HelpSubTable;
   ULONG CurUCMItem;
   BOOL  bTBModified;
   BOOL  bTBCreating;
   CHAR msglinezstate;
   CHAR reserved1[3];  // for packing insensitivity
} EFRAMEDATA, *PEFRAMEDATA;


/*Public data used by the frame sent in with the create message*/
typedef struct {
   ULONG   Size;
   ULONG   PMFlags;
   ULONG   Flags;
   PVOID   HIcon;
} EFRAMECTRLDATA, *PEFRAMECTRLDATA;

/*
typedef struct {
   ULONG           Size;
   EFRAMECTRLDATA  EFrameCtrlData;
   EDITWNDCTRLDATA EditWndCtrlData;
   PSZ             EditWndClassName;
} EFRAMEEDITWNDCTRLDATA, *PEFRAMEEDITWNDCTRLDATA;
*/

typedef struct {
   ULONG            Size;
   PEFRAMECTRLDATA  EFrameCtrlData;
   PEDITWNDCTRLDATA EditWndCtrlData;
   PSZ              EditWndClassName;
} EFRAMEEDITWNDCTRLDATA, *PEFRAMEEDITWNDCTRLDATA;

//EFRAME Style Flags
#define EFRAMEF_STATUSWND      1
#define EFRAMEF_MESSAGEWND     2
#define EFRAMEF_RINGBUTTONS    4
#define EFRAMEF_VSCROLLBAR     8
#define EFRAMEF_HSCROLLBAR     16
#define EFRAMEF_INFOONTOP      32
#define EFRAMEF_FILEWND        64
#define EFRAMEF_DMTBWND        128
#define EFRAMEF_TASKLISTENTRY  256
#define EFRAMEF_EDITWND        512
#define EFRAMEF_COMMANDLINE    1024
#define EFRAMEF_TOOLBAR        2048
#define EFRAMEF_TOOLBARPROMPT  4096
#define EFRAMEF_DROPIMPORTS    8192

#define EXTRAWND_STYLE_CHANGE      WM_USER + 1

//TIMER Messages
#define TIMER_MESSAGELINE_REFRESH 1


//EFRAME Messages

#define EFRAMEM_MSGID                 WM_USER       +  0x700 //5888
#define EFRAMEM_SETMSGLINE            EFRAMEM_MSGID + 1
#define EFRAMEM_DELETE_MSGLINE        EFRAMEM_MSGID + 2
#define EFRAMEM_SETSTATUSTEMPLATE     EFRAMEM_MSGID + 3
#define EFRAMEM_SETSTATUSCOLOR        EFRAMEM_MSGID + 4
#define EFRAMEM_SETMSGCOLOR           EFRAMEM_MSGID + 5
#define EFRAMEM_SETSTATUSTEXT         EFRAMEM_MSGID + 6
#define EFRAMEM_REFRESHMSGWND         EFRAMEM_MSGID + 7
#define EFRAMEM_SETMSGPOS             EFRAMEM_MSGID + 8
#define EFRAMEM_QUERYSTATUSINFO       EFRAMEM_MSGID + 9
#define EFRAMEM_UPDATESTATUSWND       EFRAMEM_MSGID + 10
#define EFRAMEM_QUERYFILEINFO         EFRAMEM_MSGID + 11
#define EFRAMEM_EIQMSG                EFRAMEM_MSGID + 12
#define EFRAMEM_EDITCOMMAND           EFRAMEM_MSGID + 13
#define EFRAMEM_EDITCOMMAND2          EFRAMEM_MSGID + 14
#define EFRAMEM_ENABLERINGBUTTONS     EFRAMEM_MSGID + 15
#define EFRAMEM_DESTROY               EFRAMEM_MSGID + 16
#define EFRAMEM_TASKLISTENTRY         EFRAMEM_MSGID + 17
#define EFRAMEM_TITLETEXTCHANGE       EFRAMEM_MSGID + 18
#define EFRAMEM_TOGGLECONTROL         EFRAMEM_MSGID + 19
#define EFRAMEM_SHOWACTIONBAR         EFRAMEM_MSGID + 20
#define EFRAMEM_SHOWPOPUP             EFRAMEM_MSGID + 21
#define EFRAMEM_IDENTITY              EFRAMEM_MSGID + 22
#define EFRAMEM_SHOWSYSMENU           EFRAMEM_MSGID + 23
#define EFRAMEM_SHOWUCMENU            EFRAMEM_MSGID + 24
#define EFRAMEM_ACTIONSLIST           EFRAMEM_MSGID + 25
#define EFRAMEM_MAKEUCMTEMPLATE       EFRAMEM_MSGID + 26
#define EFRAMEM_SAVEUCMTEMPLATE       EFRAMEM_MSGID + 27
#define EFRAMEM_LOADUCMTEMPLATE       EFRAMEM_MSGID + 28
#define EFRAMEM_SHOWUCMENUPOPUP       EFRAMEM_MSGID + 29
#define EFRAMEM_UCMITEMCHANGED        EFRAMEM_MSGID + 30
#define EFRAMEM_DELETETEMPLATE        EFRAMEM_MSGID + 31
#define EFRAMEM_SHOWRESOURCEMENU      EFRAMEM_MSGID + 32
#define EFRAMEM_SETTOOLBARSTYLE       EFRAMEM_MSGID + 33
#define EFRAMEM_SHOWRESOURCEUCMENU    EFRAMEM_MSGID + 34
#define EFRAMEM_RESETTBFLAG           EFRAMEM_MSGID + 35



//Function Prototypes
PSZ     ETKENTRY EtkRegisterEFrameClass(HAB hab);
MRESULT EXPENTRY EFrameWndProc(HWND hwnd, MSG msg, MPARAM Mp1, MPARAM Mp2);
MRESULT EXPENTRY ClientWndProc(HWND hwnd, MSG msg, MPARAM Mp1, MPARAM Mp2);
ULONG            EFrameFormatFrame(HWND hwnd, MSG msg, MPARAM mp1, MPARAM mp2);
MRESULT          EFrameInit(HWND HwndFrame, MPARAM Mp1, MPARAM Mp2);
VOID             EFrameMenu( HWND hwnd, PVOID MenuTemplate, PVOID HelpSubTable, ULONG Style);
