/**************************************************************************/
/*                                                                        */
/* Filter to convert PMMail address book to RexxMail format               */
/*                                                                        */
/**************************************************************************/
/*                                                                        */
/* This program forms part of the RexxMail package, and may not be        */
/* distributed separately.                                                */
/*                                                                        */
/**************************************************************************/
/*                                                                        */
/* The latest version of RexxMail can be found at                         */
/*               www.degeus.com/rexx                                      */
/*                                                                        */
/**************************************************************************/
/*                                                                        */
/* This program is released under the terms of the GNU license, see       */
/*               www.gnu.org/copyleft/gpl.html                            */
/*                                                                        */
/**************************************************************************/
/*                                                                        */
/* (c) 2002-2005 Marcus de Geus                                           */
/*               marcus@degeus.com                                        */
/*               www.degeus.com                                           */
/*                                                                        */
/**************************************************************************/
/*                                                                        */
/* Use it if you like it. Don't if you don't. No legalese.                */
/*                                                                        */
/**************************************************************************/

signal on Halt  /* handle halt condition */

parse arg FolderName  /* look for an argument */

if (FolderName >< '') then  /* if we have a folder name */
do
 FolderName = strip(FolderName,'B','"')  /* get rid of any quotation marks */
end

if (lines() = 0) then  /* if we have no lines coming in */
do
 parse source . . ProgName  /* get the program name */
 ProgName = filespec('N',ProgName)  /* get the file name part */
 parse var ProgName ProgName '.' .  /* lose the extension */
 call lineout StdOut,'Usage:   '||ProgName||' [foldername] < Infile [> OutFile]'  /* report */
 call lineout StdOut,''  /* report */
 call lineout StdOut,'Example: PMM2RXML My Friends < Friends.CSV > Friends.TXT'  /* report */
 call lineout StdOut,'         This converts the PMMail comma-separated values file "Friends.CSV" to'  /* report */
 call lineout StdOut,'         a RexxMail address text file, "Friends.TXT", in which each title'  /* report */
 call lineout StdOut,'         entry starts with "My Friends\". Use the "Friends.TXT" file to create'  /* report */
 call lineout StdOut,'         a new address template folder, "My Friends", in the "Addresses" folder'  /* report */
 call lineout StdOut,'         by importing the address text file (using the "Import Addresses"'  /* report */
 call lineout StdOut,'         program object in the "Accessories" folder).'  /* report */
 call lineout StdOut,'         If no folder name is provided, the address book templates will be'  /* report */
 call lineout StdOut,'         created in the main RexxMail "Addresses" folder.'  /* report */
 call Halt  /* and quit */
end

do while (lines(StdIn))  /* as long as we have lines coming in */
 call lineout StdOut,ConvertLine(linein(StdIn),FolderName)  /* read each, convert it, and send it to std. out */
end

call Halt  /* that's all, folks! */

/**************************************************************************/
ConvertLine: procedure  /* does the actual conversion */
/**************************************************************************/

/**************************************************************************/
/*                                                                        */
/* PMM lines are either:                                                  */
/*                                                                        */
/* 'Adr'                                                                  */
/* emailaddr                                                              */
/* alias                                                                  */
/* real name                                                              */
/* 1                                                                      */
/* company                                                                */
/* title                                                                  */
/* homestreet                                                             */
/* homebldg                                                               */
/* homecity                                                               */
/* homestate/prov                                                         */
/* homepostalcode                                                         */
/* homecountry                                                            */
/* homephone                                                              */
/* homephoneext                                                           */
/* homefax                                                                */
/* businessstreet                                                         */
/* businessbldg                                                           */
/* businesscty                                                            */
/* businessstate/prov                                                     */
/* businesspostalcode                                                     */
/* businesscountry                                                        */
/* businessphone                                                          */
/* businessphoneext                                                       */
/* businessfax                                                            */
/* noteslines                                                             */
/*                                                                        */
/* or:                                                                    */
/*                                                                        */
/* 'Grp'                                                                  */
/* groupmember1;groupmember2;...;groupmembern                             */
/* groupalias                                                             */
/* groupname                                                              */
/* 1                                                                      */
/* groupdescription                                                       */
/*                                                                        */
/* This program ignores the second (group) category of entries.           */
/*                                                                        */
/**************************************************************************/

parse arg InLine,FolderName  /* get the arguments */

parse var InLine Type ',' InLine /* get the bits we need */

if (translate(Type) >< 'ADR') then  /* if the line is not an address line */
do
 return ''  /* return empty-handed */
end

parse var InLine '"' Address '","' Alias '","' Name '",' . ',"' Info /* get the e-mail address, the alias, the name, and any other info */

KeyWords = '' /* start with nothing */

CRLF = d2c(13)||d2c(10) /* define CRLF */

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Company = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Title = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Home street = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Home building = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Home city = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Home state = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Home postcode = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Home country = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Home phone = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Home phone extension = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Home fax = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Business street = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Business building = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Business city = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Business state = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Business postcode = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Business country = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Business phone = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Business phone extension = '||NextBit||CRLF  /* add this */
end

parse var Info NextBit '","' Info '"' /* get another bit */

if (NextBit >< '') then  /* if we have something */
do
 KeyWords = KeyWords||'Business fax = '||NextBit||CRLF  /* add this */
end

if (Info ><  '') then  /* if we have info lines */
do
 Separator = d2c(227)||d2c(226)  /* define the info lines separator */
 KeyWords = KeyWords||'Notes = '  /* add this */
end

do while (Info >< '')  /* as long as we have something left */
 parse var Info NextInfoLine (Separator) Info /* get the next info line, if any */
 KeyWords = KeyWords||NextInfoLine||CRLF  /* add this */
end

OutLine = '<TITLE>'||CRLF  /* start the output with a <TITLE> tag */

if (FolderName >< '') then  /* if we have a folder name */
do
 OutLine = OutLine||FolderName||'\'  /* start the title with the folder name and add a backslash */
end

OutLine = OutLine||Name||' ('||Alias||')'||CRLF||,  /* add the name and alias */
          '<TEXT>'||CRLF||,  /* add a <TEXT> tag */
          'To: "'||Name||'" <'||Address||'>'||CRLF    /* add the 'To: ' line */

OutLine = OutLine||'Subject: '||CRLF  /* add a 'Subject: ' line */

if (KeyWords >< '') then  /* if we have a keywords bit */
do
 OutLine = OutLine||'<KEYWORDS>'||CRLF||KeyWords  /* add them to the output */
end

OutLine = OutLine||'<END>'||CRLF  /* add an <END> tag */

return OutLine  /* end of ConvertLine */

/**************************************************************************/
Halt :  /* handles halt condition */
/**************************************************************************/

exit  /* that's all, folks! */
