/*****************************************************************************/
/* IBM Internal Use Only                                                     */
/* Copyright (c) IBM Corp 1997                                               */
/*---------------------------------------------------------------------------*/
/* File        : pmPreference                                                */
/* Description : This class handles all the preference. PM, ini - the works. */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-06-17  | Created                                 | FB                */
/* 1997-11-07  | Made Win32 comp.                        | FB                */
/*---------------------------------------------------------------------------*/
/* Compile     :                                                             */
/*****************************************************************************/

#include <ifont.hpp>
#include <ITrace.hpp>
#include <ititle.hpp>
#include <IThread.hpp>
#include <ifiledlg.hpp>
#include <Ibmpctl.hpp>
#include <Imousevt.hpp>
#include <Icolor.hpp>
#include <stdlib.h>

#include "..\..\BanditTagger\PM_Interface\userPreference.hpp"
#include "..\..\BanditTagger\PM_Interface\pmBandit.rch"
#include "..\..\BanditTagger\Tagger\tagini.hpp"
#include "..\..\BanditTagger\Tagger\commonDef.hpp"


//***************************************************************************
// TAGUserPM::TAGUserPM
// Input parameters : TAGUserIni&
// The constructs the frame window, and initialize the ini class.
// Returncodes :
//***************************************************************************

TAGUserPM::TAGUserPM(TAGUserIni& aUserIni)
: IFrameWindow(WND_USER_PREFERENCE,
               IWindow::desktopWindow(),
               0,
               IRectangle(),
               IFrameWindow::classDefaultStyle |
               IFrameWindow::dialogBackground  |
               IFrameWindow::minimizedIcon     |
               IFrameWindow::shellPosition)
, _userIni(aUserIni)
, _saveIni(false)
{
  ITitle    title(this);

  if (!_userIni.registered()) {
    IString txtTitle(title.text()+ " (Unregistered)");
    title.setText(txtTitle);
  }
  this->setFont(IFont("Helv", 8));
}

//***************************************************************************
// TAGUserPM::command
// Input parameters : ICommandEvent&
// This is the event handler for the notebook.
// Returncodes : Boolean
//***************************************************************************

Boolean TAGUserPM::command(ICommandEvent& cmdEvt)
{
   Boolean  processed = false;

   switch (cmdEvt.commandId()) {
   case DID_OK:
      processed = this->handleOk();
      break;
   case DID_CANCEL:
      this->close();
      processed = true;
      break;
   case PB_BROWSE:
      this->handleBrowse();
      break;
   } // end switch
   return processed;
}

//***************************************************************************
// TAGUserPM::handleOk
// Input parameters :
// This is the query the insert events.
// Returncodes : void
//***************************************************************************

Boolean TAGUserPM::handleOk()
{
  _userIni.tagfiles      (_pefTagfiles      ->text());
  _userIni.newline       (_pefNewline       ->text());
  _userIni.wysiwyg       (_pcbWysiwyg       ->isSelected());
  _userIni.sequential    (_prbSequential    ->isSelected());
  _userIni.manualTag     (_pefManualTag     ->text());
  _userIni.xMailer       (_pefXMailer       ->text());
  _userIni.xNews         (_pefXNews         ->text());
  _userIni.anonymousName (_pefAnonymousName ->text());
  _userIni.anonymousEmail(_pefAnonymousEmail->text());
  _userIni.registeredName(_pefname          ->text());
  _userIni.registeredKey (_pefkey           ->text());
  _userIni.noReplace     (_pcbNoReplace     ->isSelected());
  _userIni.removeXMailer (_pcbRemoveXMailer ->isSelected());
  _userIni.removeXNews   (_pcbRemoveXNews   ->isSelected());
  _userIni.advertise     (_pcbAdvertise     ->isSelected());
  #ifdef __TOS_OS2__
  _userIni.windowList    (_pcbWindowList    ->isSelected());
  #endif
  _userIni.pause         (_pefPause->text().asInt());

  // Instead of using DID_OK (NT problem.)
  _saveIni = true;
  this->close();

  return true;
}

//***************************************************************************
// TAGUserPM::handleBrowse
// Input parameters :
// This member displays a filedialog. And insert the selected path into the
// tagFiles entryfield.
// Returncodes : void
//***************************************************************************

void TAGUserPM::handleBrowse(TAGUserPM::BrowseOption browseOption)
{
  // Create the settings first.
  IString   title;
  IString   filename;
  if (browseOption == TAGUserPM::tagFile) {
    title    = TAG_TITLE_FILEDLG;
    filename = _userIni.tagfiles() + TAG_FILE_MASK;
  }

  IFileDialog::Settings settings;
  settings.setOKButtonText(DID_OK)
          .setTitle(title)
          .setOpenDialog()
          .setFileName(filename);

  IFileDialog filedlg(IWindow::desktopWindow(),
                      this,
                      settings);
  if(filedlg.pressedOK()) {
    filename = filedlg.fileName();
    if (browseOption == TAGUserPM::tagFile)
      _pefTagfiles->setText(filename.subString(1, filename.lastIndexOf("\\")));
  }
  return;
}

//***************************************************************************
// TAGUserPM::layout
// Input parameters :
// The contructs the the main window.
// Returncodes :
//***************************************************************************

void TAGUserPM::layout()
{
  IMultiCellCanvas* clientCanvas = new IMultiCellCanvas(IC_FRAME_CLIENT_ID,
                                                        this,
                                                        this);

  IMultiCellCanvas* buttons  = this->insertButtons(clientCanvas);
  INotebook*        notebook = this->insertNotebookPages(clientCanvas);

  clientCanvas->addToCell(notebook, 1, 1);
  clientCanvas->addToCell(buttons , 1, 2);
  clientCanvas->setColumnWidth(1, 1, true);
  clientCanvas->setRowHeight  (1, 1, true);
  clientCanvas->setRowHeight  (3, IMultiCellCanvas::defaultCell().height());

  clientCanvas->setFont(IFont("Helv", 8));

  this->setClient(clientCanvas);
  #ifdef __TOS_OS2__
  this->moveSizeToClient(IRectangle(this->position(),
                         ISize(clientCanvas->minimumSize().width() * 1.1,
                               clientCanvas->minimumSize().height() * 1.0)));
  #else
  this->moveSizeToClient(IRectangle(this->position(),
                         ISize(clientCanvas->minimumSize().width() * 1.01,
                               clientCanvas->minimumSize().height() * 1.0)));
  #endif
  _select = new TAGUserSelect();
  _select->newline      (_pstNewline      )
          .xmailer      (_pstXMailer      )
          .xnews        (_pstXNews        )
          .newline      (_pefNewline      )
          .xmailer      (_pefXMailer      )
          .xnews        (_pefXNews        )
          .noReplace    (_pcbNoReplace    )
          .removeXMailer(_pcbRemoveXMailer)
          .removeXNews  (_pcbRemoveXNews  );


  _select->handleEventsFor(_pcbWysiwyg)
          .handleEventsFor(_pcbRemoveXMailer)
          .handleEventsFor(_pcbRemoveXNews)
          .handleEventsFor(_pcbNoReplace);
  ICommandHandler::handleEventsFor(this);
  ICommandHandler::handleEventsFor(notebook);
}

//***************************************************************************
// TAGUserPM::insertButtons
// Input parameters : IMultiCellCanvas*
// The contructs the buttons
// Returncodes : IMultiCellCanvas*
//***************************************************************************

IMultiCellCanvas* TAGUserPM::insertButtons(IMultiCellCanvas* pParentOwner)
{
  IMultiCellCanvas* buttons = new IMultiCellCanvas(0x001,
                                                   pParentOwner,
                                                   pParentOwner);
  _ppbOk      = new IPushButton(DID_OK,
                                buttons,
                                buttons);
  _ppbOk->enableDefault()
         .setText(DID_OK)
         .enableGroup()
         .enableTabStop();

  _ppbCancel  = new IPushButton(DID_CANCEL,
                                buttons,
                                buttons);
  _ppbCancel->setText(DID_CANCEL);

  buttons->addToCell(_ppbOk    , 2, 2);
  buttons->addToCell(_ppbCancel, 4, 2);

  unsigned long buttonWidth = (unsigned long)
      max(_ppbOk->minimumSize().width(), _ppbCancel->minimumSize().width());

  buttons->setColumnWidth(2, buttonWidth);
  buttons->setColumnWidth(4, buttonWidth);
  buttons->setColumnWidth(1, 1, true); // IMultiCellCanvas::defaultCell.width()), true);
  buttons->setColumnWidth(5, 1, true); // IMultiCellCanvas::defaultCell.width()), true);

  _ppbOk->enableTabStop();

  return buttons;
}

//***************************************************************************
// TAGUserPM::insertNotebookPages
// Input parameters : IMultiCellCanvas*
// The contructs the different pages.
// Returncodes :
//***************************************************************************

INotebook* TAGUserPM::insertNotebookPages(IMultiCellCanvas* pParentOwner)
{
  INotebook* notebook = new INotebook(0x002,
                                     pParentOwner,
                                     pParentOwner,
                                     IRectangle(),
                                     INotebook::spiralBinding |
                                     INotebook::polygonTabs   |
                                     INotebook::majorTabsTop  |
                                     INotebook::backPagesTopRight|
                                     INotebook::tabTextCenter |
                                     IWindow::visible);

  notebook->setAutoDeleteObject();

  INotebook::PageSettings pageSettings(INotebook::PageSettings::autoPageSize |
                                       INotebook::PageSettings::majorTab     );
  unsigned long maxWidth(0);
  IFont         notebookFont(notebook);


  pageSettings.setTabText(TAB_FILES);
  maxWidth = (unsigned long)
             max(notebookFont.minTextWidth(pageSettings.tabText()), maxWidth);
  notebook->addLastPage(pageSettings, this->insertFilePage(notebook));

  pageSettings.setTabText(TAB_USER);
  maxWidth = (unsigned long)
             max(notebookFont.minTextWidth(pageSettings.tabText()), maxWidth);
  notebook->addLastPage(pageSettings, this->insertUserPage(notebook));

  pageSettings.setTabText(TAB_ANONYMOUS);
  maxWidth = (unsigned long)
             max(notebookFont.minTextWidth(pageSettings.tabText()), maxWidth);
  notebook->addLastPage(pageSettings, this->insertAnonymousPage(notebook));

  #ifdef __TOS_OS2__
  pageSettings.setTabText(TAB_NETSCAPE);
  maxWidth = (unsigned long)
             max(notebookFont.minTextWidth(pageSettings.tabText()), maxWidth);
  notebook->addLastPage(pageSettings, this->insertNetscapePage(notebook));
  #endif

  pageSettings.setTabText(TAB_REGISTERED);
  maxWidth = (unsigned long)
             max(notebookFont.textWidth(pageSettings.tabText()), maxWidth);
  notebook->addLastPage(pageSettings, this->insertRegister(notebook));

  pageSettings.setTabText(TAB_ABOUT);
  maxWidth = (unsigned long)
             max(notebookFont.minTextWidth(pageSettings.tabText()), maxWidth);
  notebook->addLastPage(pageSettings, this->insertAbout(notebook));

  #ifdef __TOS_OS2__
  notebook->setMajorTabSize(ISize(maxWidth+10, notebookFont.maxCharHeight()+10));
  #endif

  return notebook;
}

//***************************************************************************
// TAGUserPM::insertFilePage
// Input parameters : INotebook*
// The contructs the file page.

// Returncodes :
//***************************************************************************

IMultiCellCanvas* TAGUserPM::insertFilePage(INotebook* pParentOwner)
{
  IMultiCellCanvas* filepage  = new IMultiCellCanvas(0x003,
                                                    pParentOwner,
                                                    pParentOwner);
  IMultiCellCanvas* tagCanvas = new IMultiCellCanvas(0x004,
                                                    filepage,
                                                    filepage);
  // The tag files.
  _ppbBrowse     = new IPushButton(PB_BROWSE,
                                   filepage,
                                   filepage);

  _ppbBrowse->setText(PB_BROWSE)
             .enableTabStop();
  _pefTagfiles   = new IEntryField(0x005,
                                   tagCanvas,
                                   tagCanvas,
                                   IRectangle());

  _pefTagfiles->setLimit(256)
               .setText(_userIni.tagfiles())
               .enableTabStop()
               .setFocus();

  IFont font(_pefTagfiles);
  long width(font.textWidth(_userIni.tagfiles())+ font.avgCharWidth()*2);


  tagCanvas->addToCell (_pefTagfiles, 1, 2);
  tagCanvas->setColumnWidth(1, width, true);
  tagCanvas->setRowHeight(1, 1, true);

  _pstTagfiles   = new IStaticText(TXT_TAGFILES,
                                   filepage,
                                   filepage);
  _pstTagfiles->setText(TXT_TAGFILES);


  // The newline section.
  IMultiCellCanvas* newlineCanvas = new IMultiCellCanvas(0x006,
                                                         filepage,
                                                         filepage);
  _pefNewline = new IEntryField(0x007,
                                newlineCanvas,
                                newlineCanvas);
  _pefNewline->enable(!_userIni.wysiwyg())
              .setText(_userIni.newline())
              .enableTabStop();
  _pefNewline->setMinimumSize(ISize(0.5 * _pefNewline->minimumSize().width(),
                                          _pefNewline->minimumSize().height()));
    // The wysiwig part
  _pcbWysiwyg = new ICheckBox(CB_WYSIWYG,
                              newlineCanvas,
                              newlineCanvas);
  _pcbWysiwyg->select(_userIni.wysiwyg())
              .setText(CB_WYSIWYG)
              .enableTabStop();

  newlineCanvas->addToCell(_pefNewline, 1, 1);
  newlineCanvas->addToCell(_pcbWysiwyg, 3, 1);

  _pstNewline = new IStaticText(TXT_NEWLINE,
                                filepage,
                                filepage);
  _pstNewline->setText(TXT_NEWLINE)
              .enable(!_userIni.wysiwyg());

  // The manual tag name.
  _pefManualTag  = new IEntryField(0x008,
                                   filepage,
                                   filepage);
//                                   IRectangle());
  _pefManualTag->setText(_userIni.manualTag())
                .enableTabStop();

  _pstManualTag  = new IStaticText(TXT_MANUAL_TAG,
                                   filepage,
                                   filepage);
  _pstManualTag->setText(TXT_MANUAL_TAG);

  // Insert the new random or sequential tag selection.
  IStaticText* pstSelectTag = new IStaticText(TXT_SELECT_TAG,
                                              filepage,
                                              filepage);
  pstSelectTag->setText(TXT_SELECT_TAG)
               .setAutoDeleteObject();

  IMultiCellCanvas* radioCanvas = new IMultiCellCanvas(0x009,
                                                       filepage,
                                                       filepage);
  _prbRandom = new IRadioButton(RB_RANDOM,
                                radioCanvas,
                                radioCanvas);
  _prbRandom->setText(RB_RANDOM)
             .enableGroup()
             .enableTabStop()
             .setAutoDeleteObject();

  _prbSequential = new IRadioButton(RB_SEQUENTIAL,
                                    radioCanvas,
                                    radioCanvas);
  _prbSequential->setText(RB_SEQUENTIAL)
                 .enableTabStop()
                 .setAutoDeleteObject();
  radioCanvas->addToCell(_prbRandom    , 1, 1)
              .addToCell(_prbSequential, 3, 1);
  if (_userIni.sequential())
    _prbSequential->select();
  else
    _prbRandom->select();

  filepage->addToCell(_pstTagfiles , 2, 2);
  filepage->addToCell(tagCanvas    , 2, 3, 2);
  filepage->addToCell(_ppbBrowse   , 5, 3);

  filepage->addToCell(_pstNewline  , 2, 5);
  filepage->addToCell(newlineCanvas, 2, 6, 4);

  filepage->addToCell(_pstManualTag, 2, 11);
  filepage->addToCell(_pefManualTag, 2, 12);

  filepage->addToCell(pstSelectTag , 2, 8);
  filepage->addToCell(radioCanvas  , 2, 9);

  filepage->setColumnWidth(3, 1, true);
  filepage->setColumnWidth(6, IMultiCellCanvas::defaultCell().width(), false);
  // Set the object to autodelete.
  filepage      ->setAutoDeleteObject();
  tagCanvas     ->setAutoDeleteObject();
  newlineCanvas ->setAutoDeleteObject();
  _ppbBrowse    ->setAutoDeleteObject();
  _pefTagfiles  ->setAutoDeleteObject();
  _pstTagfiles  ->setAutoDeleteObject();
  _pefNewline   ->setAutoDeleteObject();
  _pstNewline   ->setAutoDeleteObject();
  _pefManualTag ->setAutoDeleteObject();
  _pstManualTag ->setAutoDeleteObject();

  #ifndef __TOS_OS2__
  filepage->setFont(IFont("Helv", 8));
  #endif
  return filepage;
}

//***************************************************************************
// TAGUserPM::insertUserPage
// Input parameters : INotebook*
// The contructs the user page.
// Returncodes :
//***************************************************************************

IMultiCellCanvas* TAGUserPM::insertUserPage(INotebook* pParentOwner)
{
  IMultiCellCanvas* userpage = new IMultiCellCanvas(0x009,
                                                    pParentOwner,
                                                    pParentOwner);

  // Create the stupid xtra multicellcanvas.
  IMultiCellCanvas* stupidCanvas = new IMultiCellCanvas(0x00a,
                                                        userpage,
                                                        userpage);
  IMultiCellCanvas* indentCanvas = new IMultiCellCanvas(0x00b,
                                                        userpage,
                                                        userpage);


    // Create the pause controls.
    _pefPause   = new IEntryField(0x00b,
                                  stupidCanvas,
                                  stupidCanvas,
                                  IRectangle());
    _pefPause->setText(IString(_userIni.pause()))
              .enableTabStop();
    _pefPause->setMinimumSize(ISize(0.5 * _pefPause->minimumSize().width(),
                                    _pefPause->minimumSize().height()));
    stupidCanvas->addToCell(_pefPause, 1, 1);
    stupidCanvas->setColumnWidth(2, 1, true);

    _pstPause   = new IStaticText(TXT_PAUSE,
                                  userpage,
                                  userpage);
    _pstPause->setText(TXT_PAUSE);

    // Create the no replace.

    _pcbNoReplace = new ICheckBox(CB_NO_REPLACE,
                                  userpage,
                                  userpage);

    _pcbNoReplace->select (_userIni.noReplace())
                  .setText(CB_NO_REPLACE)
                  .enableTabStop()
                  .setAutoDeleteObject();


    // Create the X-Mailer.
    _pcbRemoveXMailer = new ICheckBox(CB_REMOVE_XMAILER,
                                         indentCanvas,
                                         indentCanvas);
    _pcbRemoveXMailer->select (_userIni.removeXMailer())
                      .setText(CB_REMOVE_XMAILER)
                      .enableTabStop()
                      .setAutoDeleteObject();

    _pefXMailer = new IEntryField(0x00c,
                      indentCanvas,
                      indentCanvas,
                      IRectangle());
    _pefXMailer->setLimit(70)
                .setText(_userIni.xMailer())
                .enableTabStop()
                .enable(!_userIni.removeXMailer());

    _pstXMailer = new IStaticText(TXT_XMAILER,
                                  indentCanvas,
                                  indentCanvas);

    _pstXMailer->setText(TXT_XMAILER)
                .enable(!_userIni.removeXMailer());


    // Create the X-News
    _pcbRemoveXNews   = new ICheckBox(CB_REMOVE_XNEWS,
                                       indentCanvas,
                                       indentCanvas);
    _pcbRemoveXNews->select (_userIni.removeXNews())
                    .setText(CB_REMOVE_XNEWS)
                    .enableTabStop()
                    .setAutoDeleteObject();

    _pefXNews   = new IEntryField(0x00d,
                      indentCanvas,
                      indentCanvas,
                      IRectangle());
    _pefXNews  ->setLimit(70)
                .setText(_userIni.xNews())
                .enableTabStop()
                .enable(!_userIni.removeXNews());

    _pstXNews   = new IStaticText(TXT_XNEWS,
                                  indentCanvas,
                                  indentCanvas);
    _pstXNews->setText(TXT_XNEWS)
              .enable(!_userIni.removeXNews());

    #ifndef __TOS_OS2__  // Only windows
    if (!_userIni.registered()) {
      _pcbRemoveXMailer->deselect()
                        .disable();
      _pcbRemoveXNews  ->deselect()
                        .disable();
    }
    #endif

    _pstAdvertise = new IStaticText(TXT_ADVERTISE,
                                    userpage,
                                    userpage);
    _pstAdvertise->setText(TXT_ADVERTISE);

    _pcbAdvertise = new ICheckBox(CB_ADVERTISE,
                                   userpage,
                                   userpage);

    _pcbAdvertise->select (_userIni.advertise())
                  .setText(CB_ADVERTISE)
                  .enableTabStop();

    // Enable and disable based on whether the user wants the xmailer replaced.
    if (_userIni.noReplace()) {
      _pcbRemoveXNews->enable  (false);
      _pcbRemoveXMailer->enable(false);
      _pstXNews->enable        (false);
      _pefXNews->enable        (false);
      _pstXMailer->enable      (false);
      _pefXMailer->enable      (false);
    }  // endif

    userpage->addToCell(_pstPause        , 2, 2);
    userpage->addToCell(stupidCanvas     , 2, 3);

    userpage->addToCell(_pcbNoReplace    , 2, 5);
    userpage->addToCell(indentCanvas     , 2, 7, 1, 7);

    indentCanvas->addToCell(_pcbRemoveXMailer, 2, 1);
    indentCanvas->addToCell(_pstXMailer      , 2, 2);
    indentCanvas->addToCell(_pefXMailer      , 2, 3);

    indentCanvas->addToCell(_pcbRemoveXNews  , 2, 5);
    indentCanvas->addToCell(_pstXNews        , 2, 6);
    indentCanvas->addToCell(_pefXNews        , 2, 7);

    userpage->addToCell(_pstAdvertise    , 2, 15);
    userpage->addToCell(_pcbAdvertise    , 2, 16);

    IFUNCTRACE_DEVELOP();
    IFont   efXMailerFont(_pefXMailer);
    IFont   efXNewsFont  (_pefXNews);

    long width = (long)
      max((efXMailerFont.textWidth(_pefXMailer->text()) + efXMailerFont.avgCharWidth()*2),
          (efXNewsFont  .textWidth(_pefXNews  ->text()) + efXNewsFont  .avgCharWidth()*2));
    ITRACE_DEVELOP(IString("Entryfield text : ") + _pefXMailer->text());
    ITRACE_DEVELOP(IString("Column width : ") + IString(width));
    ITRACE_DEVELOP(IString("Text   width : ") + IString(_pstXMailer->minimumSize().width()));

    indentCanvas->setColumnWidth(2, width);

    // Set auto delete on objects.
    userpage     ->setAutoDeleteObject();
    stupidCanvas ->setAutoDeleteObject();
    indentCanvas ->setAutoDeleteObject();
    _pefPause    ->setAutoDeleteObject();
    _pstPause    ->setAutoDeleteObject();
    _pefXMailer  ->setAutoDeleteObject();
    _pstXMailer  ->setAutoDeleteObject();
    _pefXNews    ->setAutoDeleteObject();
    _pstXNews    ->setAutoDeleteObject();
    _pcbAdvertise->setAutoDeleteObject();
    _pstAdvertise->setAutoDeleteObject();

    #ifndef __TOS_OS2__
    userpage->setFont(IFont("Helv", 8));
    #endif
    return userpage;
}

//***************************************************************************
// TAGUserPM::insertAnonymousPage
// Input parameters : INotebook*
// The contructs the user page.
// Returncodes :
//***************************************************************************

IMultiCellCanvas* TAGUserPM::insertAnonymousPage(INotebook* pParentOwner)
{
  IMultiCellCanvas* canvas = new IMultiCellCanvas(0x00e,
                                                  pParentOwner,
                                                  pParentOwner);
  canvas->setAutoDeleteObject();

  // The name.
  _pstAnonymousName = new IStaticText(TXT_ANONYMOUS_NAME,
                                      canvas,
                                      canvas);
  _pstAnonymousName->setText(TXT_ANONYMOUS_NAME)
                    .setAutoDeleteObject();

  _pefAnonymousName = new IEntryField(0x001,
                                      canvas,
                                      canvas);
  _pefAnonymousName->setLimit(60)
                    .setText(_userIni.anonymousName())
                    .enableTabStop()
                    .setAutoDeleteObject();

  // The e-mail.
  _pstAnonymousEmail = new IStaticText(TXT_ANONYMOUS_EMAIL,
                                      canvas,
                                      canvas);
  _pstAnonymousEmail->setText(TXT_ANONYMOUS_EMAIL)
                     .setAutoDeleteObject();

  _pefAnonymousEmail = new IEntryField(0x002,
                                      canvas,
                                      canvas);
  _pefAnonymousEmail->setLimit(60)
                     .setText(_userIni.anonymousEmail())
                     .enableTabStop()
                     .setAutoDeleteObject();

  canvas->addToCell(_pstAnonymousName , 2, 2)
         .addToCell(_pefAnonymousName , 2, 3)
         .addToCell(_pstAnonymousEmail, 2, 5)
         .addToCell(_pefAnonymousEmail, 2, 6);

  #ifndef __TOS_OS2__
  canvas->setFont(IFont("Helv", 8));
  #endif
  return canvas;
}

//***************************************************************************
// TAGUserPM::insertXPage
// Input parameters : INotebook*
// The contructs the x-page.
// Returncodes :
//***************************************************************************

IMultiCellCanvas* TAGUserPM::insertNetscapePage(INotebook* pParentOwner)
{
  IMultiCellCanvas* canvas = new IMultiCellCanvas(0x00f,
                                                  pParentOwner,
                                                  pParentOwner);
  canvas->setAutoDeleteObject();

  _pstWindowList = new IStaticText(TXT_WINDOWLIST,
                                   canvas,
                                   canvas);
  _pstWindowList->setText(TXT_WINDOWLIST)
                 .setAutoDeleteObject();

  _pcbWindowList = new ICheckBox(CB_WINDOWLIST,
                                 canvas,
                                 canvas);

  _pcbWindowList->select(_userIni.windowList())
                 .setText(CB_WINDOWLIST)
                 .enableTabStop()
                 .setAutoDeleteObject();

  canvas->addToCell(_pstWindowList, 2, 2)
         .addToCell(_pcbWindowList, 2, 3);

  #ifndef __TOS_OS2__
  canvas->setFont(IFont("Helv", 8));
  #endif

  return canvas;
}

//***************************************************************************
// TAGUserPM::insertRegister
// Input parameters : INotebook*
// The contructs the register page
// Returncodes : IMultiCellCanvas*
//***************************************************************************
IMultiCellCanvas* TAGUserPM::insertRegister(INotebook* pParentOwner)
{
  IMultiCellCanvas* canvas = new IMultiCellCanvas(0x010,
                                                  pParentOwner,
                                                  pParentOwner);
  canvas->setAutoDeleteObject();

  // The name part
  IStaticText*  pstName = new IStaticText(TXT_NAME,
                                          canvas,
                                          canvas);
  pstName->setText(TXT_NAME)
          .setAutoDeleteObject();

  _pefname = new IEntryField(0x001,
                             canvas,
                             canvas);
  _pefname->setText(_userIni.registeredName())
           .enableGroup()
           .enableTabStop()
           .setAutoDeleteObject();
  // The Key part.
  IStaticText*  pstkey  = new IStaticText(TXT_KEY,
                                          canvas,
                                          canvas);
  pstkey->setText(TXT_KEY)
         .setAutoDeleteObject();

  _pefkey = new IEntryField(0x002,
                            canvas,
                            canvas);
  _pefkey->setText(_userIni.registeredKey())
          .enableTabStop()
          .setAutoDeleteObject();
  // Reg text
  _pstRegistered = new IStaticText(TXT_REGISTERED,
                                   canvas,
                                   canvas);

  if (_userIni.registered()) {
    _pstRegistered->setText(TXT_REGISTERED_TO)
                   .setFont(IFont("Helv", 10));
  } else {
    IString regtext(TXT_UNREGISTERED);
    _pstRegistered->setText(regtext)
                   .setFont(IFont("Helv", 12))
                   .setForegroundColor(IColor::red);
    for (short index = 0; index <= TXT_HOW_TO_REG4 - TXT_HOW_TO_REG1; index++)
    {
      IStaticText* ptext = new IStaticText(TXT_HOW_TO_REG1+index,
                                           canvas,
                                           canvas);
      ptext->setText(ptext->id())
                     .setForegroundColor(IColor::red)
                     .setAutoDeleteObject();
      canvas->addToCell(ptext, 2, 10+index, 2);
    }
  }

  _pstRegistered->setAutoDeleteObject();


  // Add To Canvas
  canvas->addToCell(pstName       , 2, 2)
         .addToCell(_pefname      , 2, 3)
         .addToCell(pstkey        , 2, 5)
         .addToCell(_pefkey       , 2, 6)
         .addToCell(_pstRegistered, 2, 8, 2);
  canvas->setColumnWidth(3, 1, true);

  #ifndef __TOS_OS2__
  canvas->setFont(IFont("Helv", 8));
  #endif

  return canvas;
}

//***************************************************************************
// TAGUserPM::insertAbout
// Input parameters : INotebook*
// The contructs the about page
// Returncodes : IMultiCellCanvas*
//***************************************************************************

IMultiCellCanvas* TAGUserPM::insertAbout(INotebook* pParentOwner)
{
  IMultiCellCanvas* aboutCanvas = new IMultiCellCanvas(0x011,
                                                       pParentOwner,
                                                       pParentOwner);

  // The title and version.
  #if 0
  IStaticText*     pstName      = new IStaticText(TXT_PROGNAME,
                                                  aboutCanvas,
                                                  aboutCanvas);
  pstName->setText(TXT_PROGNAME)
          .setAlignment(IStaticText::centerCenter)
          .setForegroundColor(IColor::red);
  pstName->setFont(IFont("Helv", 24));
  #endif
  IMultiCellCanvas* bitmapCanvas = new IMultiCellCanvas(0x010,
                                                        aboutCanvas,
                                                        aboutCanvas);

  IBitmapControl*  pbmProdname  = new IBitmapControl(BM_LOGO,
                                                     bitmapCanvas,
                                                     bitmapCanvas,
                                                     BM_LOGO);
  bitmapCanvas->addToCell(pbmProdname, 2, 1)
               .setColumnWidth(1, 1, true)
               .setColumnWidth(3, 1, true)
               .setAutoDeleteObject();

  IStaticText*     pstCompany   = new IStaticText(TXT_COMPANY,
                                                  aboutCanvas,
                                                  aboutCanvas);
  pstCompany->setText(TXT_COMPANY)
             .setAlignment(IStaticText::centerCenter)
             .setFont(IFont("Helv", 12));


  IStaticText*     pstVersion   = new IStaticText(TXT_PROGVERSION,
                                                  aboutCanvas,
                                                  aboutCanvas);
  pstVersion->setText(TXT_PROGVERSION)
             .setAlignment(IStaticText::centerCenter)
             .setFont(IFont("Helv", 12));

  IStaticText*     pstBuild     = new IStaticText(TXT_BUILD,
                                                  aboutCanvas,
                                                  aboutCanvas);

  IString build(IString("Build : ") + __DATE__ + IString(", ") + __TIME__);
  pstBuild  ->setText(build)
             .setAlignment(IStaticText::centerCenter);

  // The "Created By text and the name.

  IStaticText*     _pstHome     = new IStaticText(TXT_HOME,
                                                  aboutCanvas,
                                                  aboutCanvas);

  _pstHome->setText(_pstHome->id())
           .setAlignment(IStaticText::centerCenter);
  #ifdef __TOS_OS2__
  _pmouseHdr = new TAGUserMouse(_pstHome);
  _pmouseHdr->handleEventsFor(_pstHome);
  #endif
  IStaticText*     pstCreatedBy = new IStaticText(TXT_CREATEDBY,
                                                  aboutCanvas,
                                                  aboutCanvas);
  pstCreatedBy->setText(TXT_CREATEDBY);
  IStaticText*     pstCreator   = new IStaticText(TXT_CREATOR,
                                                  aboutCanvas,
                                                  aboutCanvas);
  pstCreator->setText(TXT_CREATOR);
  // Insert the thanks to.
  IStaticText*     pstThanks    = new IStaticText(TXT_THANKS,
                                                  aboutCanvas,
                                                  aboutCanvas);
  pstThanks->setText(TXT_THANKS);

  IStaticText*     pstPerson_1  = new IStaticText(TXT_PERSON_1 ,
                                                  aboutCanvas,
                                                  aboutCanvas);
  pstPerson_1->setText(TXT_PERSON_1);
  IStaticText*     pstPerson_2  = new IStaticText(TXT_PERSON_2 ,
                                                  aboutCanvas,
                                                  aboutCanvas);
  pstPerson_2->setText(TXT_PERSON_2);

//  aboutCanvas->addToCell(pstName     , 2, 1);
  aboutCanvas->addToCell(bitmapCanvas, 2, 2);
  aboutCanvas->addToCell(pstCompany  , 2, 3);
  aboutCanvas->addToCell(pstVersion  , 2, 4);
  aboutCanvas->addToCell(pstBuild    , 2, 5);
  aboutCanvas->addToCell(_pstHome    , 2, 6);

  aboutCanvas->addToCell(pstCreatedBy, 2, 8);
  aboutCanvas->addToCell(pstCreator  , 2, 9);

  aboutCanvas->addToCell(pstThanks   , 2, 11);
  aboutCanvas->addToCell(pstPerson_1 , 2, 12);
  aboutCanvas->addToCell(pstPerson_2 , 2, 13);

  // Set the object to autodelete
  aboutCanvas ->setAutoDeleteObject();
  pbmProdname ->setAutoDeleteObject();
  pstCompany  ->setAutoDeleteObject();
  pstVersion  ->setAutoDeleteObject();
  pstCreatedBy->setAutoDeleteObject();
  pstCreator  ->setAutoDeleteObject();
  pstThanks   ->setAutoDeleteObject();
  pstPerson_1 ->setAutoDeleteObject();
  pstPerson_2 ->setAutoDeleteObject();

  #ifndef __TOS_OS2__
  aboutCanvas->setFont(IFont("Helv", 8));
  #endif
  return aboutCanvas;
}
//***************************************************************************
// TAGUserSelect::selectHandler
// Input parameters : IMouseClickedEvent
// Handles click on the text field.
// Returncodes : Boolean
//***************************************************************************

Boolean TAGUserSelect::selected(IControlEvent& ctlEvt)
{
  switch (ctlEvt.controlId()) {
  case CB_WYSIWYG:
    _pstNewline->enable(!_pstNewline->isEnabled());
    _pefNewline->enable(!_pefNewline->isEnabled());
    break;
  case CB_REMOVE_XMAILER:
    _pstXMailer->enable(!_pstXMailer->isEnabled());
    _pefXMailer->enable(!_pefXMailer->isEnabled());
    break;
  case CB_REMOVE_XNEWS:
    _pstXNews->enable(!_pstXNews->isEnabled());
    _pefXNews->enable(!_pefXNews->isEnabled());
    break;
  case CB_NO_REPLACE:
    _pcbRemoveXMailer->enable(!_pcbNoReplace->isSelected());
    _pcbRemoveXNews->enable  (!_pcbNoReplace->isSelected());
    if (_pcbNoReplace->isSelected()) {
      _pstXNews->enable        (false);
      _pefXNews->enable        (false);
      _pstXMailer->enable      (false);
      _pefXMailer->enable      (false);
    } else {
      _pstXMailer->enable      (!_pcbRemoveXMailer->isSelected());
      _pefXMailer->enable      (!_pcbRemoveXMailer->isSelected());
      _pstXNews->enable        (!_pcbRemoveXNews->isSelected());
      _pefXNews->enable        (!_pcbRemoveXNews->isSelected());
    } // endif
    break;
  } // endswitch
  return false;
}


//***************************************************************************
// TAGUserMouse::mouseClicked
// Input parameters : IMouseClickedEvent
// Handles click on the text field.
// Returncodes : Boolean
//***************************************************************************

Boolean TAGUserMouse::mouseClicked(IMouseClickEvent& mouseEvt)
{
  if (mouseEvt.mouseAction() == IMouseClickEvent::down) {
    _pstHome->setForegroundColor(IColor::red);
    IThread().setStackSize(0x2000)
             .start (new IThreadMemberFn<TAGUserMouse>(*this, loadNetscape));
  }
  if (mouseEvt.mouseAction() == IMouseClickEvent::up)
    _pstHome->setForegroundColor(IColor::darkBlue);

  return true;
}

//***************************************************************************
// TAGUserMouse::loadNetscape
// Input parameters :
// Starts Netscape with FA Partner homepage.
// Returncodes : void
//***************************************************************************

void TAGUserMouse::loadNetscape()
{
  system ("start netscape.exe /u http://www.gbar.dtu.dk/~c918704");
}





